/*
 * include system header
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#ifndef MAXLINE
#   define MAXLINE 1024
#endif

#define LENGTH   255
#define PROGNAME "genContrlFile.c "

typedef struct lineRec lineRec;

struct  lineRec
{
   char name[LENGTH+1];
   char line[MAXLINE+1]; 
   lineRec  *next;
};


FILE    *ifd1;
FILE    *ifd2;           /* input file descriptor   */
FILE    *ofd;                   /* output file descriptor  */
char    *product;             /* either pkgs/pdts        */
lineRec *hdr=NULL;
/*
Hariraj: To make sure that the ctl_bundles and the allbundles
files are consistent
*/
 char FMRELEASE[LENGTH+1];
 char PLATFORM[LENGTH+1];
 char    *iFileNam1; /* input file name         */
 char    *iFileNam2; /* input file name         */

/*
 * exitHdr: exit with a number and
 *          do exit handler
 */
void
exitHdr (exitCode)
int exitCode;
{
    if (ifd1)
       (void)fclose(ifd1);
 
    if (ifd2)
       (void)fclose(ifd2);
 
    if (ofd)
       (void)fclose(ofd);
 
    exit(exitCode);
}

void
expand(name)
char name[LENGTH+1];
{
   lineRec *list;

   list = hdr;
   while (list)
   {
      if (!strcmp(list->name, name) )
         fprintf(ofd,list->line);
      list = list->next;
   }
}

int
readMasterFile()
{
   char   line[MAXLINE+1];
   char   desc[LENGTH+1], pkgname[LENGTH+1], pdtname[LENGTH+1];
   char   pdtsize[LENGTH+1];
   char   platform[LENGTH+1];
   char   FMrelease[LENGTH+1];

   FILE   tmpfd;
   lineRec *list=NULL;
   lineRec *node; 

   while ( fgets(line, MAXLINE, ifd2) )
   {
         /* initialization */
         desc[0]     = '\0';  pkgname[0]  = '\0';  pdtname[0]   = '\0';
         pdtsize[0]  = '\0';  platform[0] = '\0';  FMrelease[0] = '\0';
        
         if ( sscanf( line,"%s%s%s%s%s%s",desc,pkgname,pdtname,
                 pdtsize, platform, FMrelease) == 6)
         {

            if (!strncmp(product,"pdts",4)) 
		if(strlen(FMRELEASE)!=0 && strlen(PLATFORM) !=0)
		   if(strcmp(FMRELEASE,FMrelease)!=0 ||
			strcmp(PLATFORM,platform) != 0)
		   {
			fprintf(stderr,"\n%s:The control information(Release(%s) and Platform(%s)) in\n %s \ndoes not match information(Release(%s) and Platform(%s)) in \n%s\n",PROGNAME,FMRELEASE,PLATFORM,iFileNam1,FMrelease,platform,iFileNam2 );
			exitHdr(11);
		   }

            if ( !(node=(lineRec *)malloc(sizeof(lineRec))))
            {
               (void)fprintf(stderr,"%sOut of memory allocation\n",PROGNAME);
               (void)exitHdr(1);
            }
            if (!strncmp(product,"pdts",4)) 
               (void)strcpy(node->name, pdtname);
            else
               (void)strcpy(node->name, pkgname);
 
            (void)strcpy(node->line, line);
            node->next = NULL;
 
            if (!hdr)
            {
               hdr=node;
               list=hdr;
            }
            else
            {
               list->next = node;
               list       = list->next;
            }
        }                    
   
    }
}

void
genControl()
{
   char   line[MAXLINE+1];
   char   desc[LENGTH+1], pkgname[LENGTH+1], pdtname[LENGTH+1];
   char   pdtsize[LENGTH+1];
   char   platform[LENGTH+1];
   char   FMrelease[LENGTH+1];
   int    found=0;
   
   while ( fgets(line, MAXLINE, ifd1 )) /* read a line */
   {
      desc[0]     = '\0';  pkgname[0]  = '\0';  pdtname[0]   = '\0';
      pdtsize[0]  = '\0';  platform[0] = '\0';  FMrelease[0] = '\0';

      if ( sscanf( line,"%s%s%s%s%s%s",desc,pkgname,pdtname,
                   pdtsize, platform, FMrelease) == 6)
      {
	    if(strlen(FMRELEASE) == 0 || strlen(PLATFORM) == 0)
	    {
	       (void)strcpy(FMRELEASE,FMrelease);
	       (void)strcpy(PLATFORM,platform);
	    }
            (void)fprintf(ofd,line);
      }
         else
         {
            if (!found )
            {
               readMasterFile();
               found=1;
            }
            expand(desc);
         }
    }              
}

/*
** Main
** usage : genContrlFile [pkgs/pdts]  (bundle/pkginfo) controlFile
**                       masterFile bundleOut/pkginfoOut   
*/
main(argc, argv)
int argc;
char *argv[];
{
    int     args  =     0;
    char    *bundleF;
    char    master[LENGTH];

    if (argc < 5)
    {
        (void)fprintf( stderr,"%sWrong arguments\n",PROGNAME);    
        exitHdr(1);
    }

    if ( !( product = argv[++args] ) )
    {  (void)fprintf(stderr,"%sIllegal empty of product/pacakge\n",PROGNAME);
       exitHdr(1);
    }
  
    if ( !(iFileNam1 = argv[++args]) )
    {  (void)fprintf(stderr,"%sIllegal empty of the first file name\n",PROGNAME);
       exitHdr(1);
    }

    if ( !(iFileNam2 = argv[++args]) )
    {  (void)fprintf(stderr,"%sIllegal empty of the second file name\n",PROGNAME);
       exitHdr(1);
    }
 
    if ( !(bundleF = argv[++args]) )
    {  (void)fprintf(stderr,"%sIllegal outfileName\n",PROGNAME);
       exitHdr(1);
    }


    if ( !(ofd  = fopen( bundleF, "w")))
    {
       (void)fprintf(stderr,"%sCannot open output file <%s>\n",PROGNAME,bundleF);
       exitHdr(1);
    }

    if ( !(ifd1 = fopen( iFileNam1, "r")))
    {
       (void)fprintf(stderr,"%sCannot open first input file <%s>\n",PROGNAME,iFileNam1);
       exitHdr(1);
    }

    if ( !(ifd2 = fopen( iFileNam2, "r")))
    {
       (void)fprintf(stderr,"%sCannot open the second input file <%s>\n",PROGNAME,iFileNam2);
       exitHdr(1);
    }

    (void)genControl();

    if (ifd1)
       (void)fclose(ifd1);
 
    if (ifd2)
       (void)fclose(ifd2);

    if (ofd)
       (void)fclose(ofd);

    return 0;
} 
