{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-couri
er-bold-r-normal--*-120-*-*-*-*-*-*" "courier" "Courier-Bold" 8 
12 192 "Courier-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--*
-140-*-*-*-*-*-*" "times" "Times-Roman" 4 14 64 "Times-Roman" 14}
{FONT 2 "-adobe-courier-medium-r-normal--*-100-*-*-*-*-*-*" "cour
ier" "Courier" 4 10 192 "Courier" 10}{FONT 3 "-adobe-times-bold-r
-normal--*-240-*-*-*-*-*-*" "times" "Times-Bold" 8 24 64 "Times-B
old" 24}{FONT 4 "-adobe-times-bold-r-normal--*-180-*-*-*-*-*-*" "
times" "Times-Bold" 8 18 64 "Times-Bold" 18}{FONT 5 "-adobe-times
-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "
Times-Bold" 14}{FONT 6 "-adobe-times-bold-r-normal--*-140-*-*-*-*
-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{SCP_R 1 0 226
{INP_R 2 0 "> "{TEXT 0 49 "restart: Digits := 4:  # To begin, pre
ss [RETURN]"}}{COM_R 3 0{TEXT 3 18 "\012Maple V Release 3"}}
{COM_R 4 0{TEXT 4 124 "The Most Comprehensive Mathematical Compua
tion \015System For Engineers and Scientists\015\015Quick Tour fo
r Engineers and Scientists"}}{COM_R 5 0{TEXT 1 44 "\015(c) Copyri
ght 1994 Waterloo Maple Software\015"}}{INP_R 6 0 "> "{TEXT 0 28 
"# Press [RETURN] to continue"}}{COM_R 7 0{TEXT 1 778 "\015\015IN
TRODUCTION\012\015Maple V Release3 for Windows is an essential to
ol for engineers and scientists who deal with formulae, equations
 and data. In this introductory session, you will sample some of \+
the more than 2500 Maple V functions.   The session covers the fo
llowing areas which are of interest to anyone using mathematics:\
012\012Numerical calculations                                  Di
fferential equations\012Symbolic manipulation                    \+
                Special transforms\012Solving equations          \+
                                   Special mathematical functions
\012Calculus                                                     \+
         Statistics\012Graphics and visualization                \+
             Programming\012Linear algebra and matrix manipulatio
n    Code generation\012"}}{INP_R 8 0 "> "{TEXT 0 28 "# Press [RE
TURN] to continue"}}{COM_R 9 0{TEXT 1 647 "\012\012THE MAPLE V WO
RKSHEET ENVIRONMENT\012\012Maple V is a comprehensive problem-sol
ving system that supports a wide variety of powerful mathematical
 operations such as symbolic analysis, numerical analysis, and gr
aphics.  Maple V also features a complete programming language th
at uses syntax similar to that of  BASIC, FORTRAN, Pascal or C.  \+
This language is indispensible for those wishing to develop solut
ions to larger problems.  The Maple V language is applied here th
rough the easy-to-use worksheet interface which allows users to o
btain quick, accurate answers to mathematical problems.  The work
sheet environment is composed of four components:  \012"}}{INP_R 
10 0 "> "{TEXT 0 28 "# Press [RETURN] to continue"}}{COM_R 11 0
{TEXT 1 129 "\0121.  Text:  for explanatory notes like this secti
o.\012\0122.  Maple V commands:  for inputing commands.  Command \+
lines look like this:"}}{INP_R 12 0 "> "{TEXT 0 65 "#This is a co
mment in the Maple V input line. Now press [RETURN]."}}{COM_R 13 
0{TEXT 1 256 "Pressing [RETURN] when the Maple V cursor is on a c
ommand line initiates computation.\012\0123.  Maple V output:  fo
r displaying the results of Maple V computations, like the corres
ponding output from the following input line (press [RETURN] to s
ee output font):"}}{INP_R 14 0 "> "{TEXT 0 40 "print(`This is a M
aple V output line`); "}}{COM_R 15 0{TEXT 1 250 "\0124.  Graphics
:  for displaying plots in separate windows.  In the full Maple V
 system, plots can be cut  from your plot window and pasted into \+
the worksheet to create complete documents. There are many exampl
es of Maple V graphics in this worksheet.\012"}}{INP_R 16 0 "> "
{TEXT 0 28 "# Press [RETURN] to continue"}}{COM_R 17 0{TEXT 1 471
 "\012\012WORKING THROUGH THIS SAMPLE WORKSHEET\012\0121.  Press \+
the [RETURN] key repeatedly to proceed through the worksheet. The
 cursor will automatically move to the next Maple V input line. \
012\0122.  If you happen to locate the cursor in another portion \+
of the worksheet, use the mouse to place it on the appropriate in
put line.  Note that you may not be able to get proper results if
 you arbitrarily execute line out of order, as some commands depe
nd on results of previous commands.\012"}}{INP_R 18 0 "> "{TEXT 0
 0 ""}}{COM_R 19 0{TEXT 1 139 "\015\015NUMERICAL CALCULATIONS\012
\012Maple V can be the ultimate calculator.  Simply type in the c
ommands and press [RETURN] to compute.  For example:"}}{INP_R 20 
0 "> "{TEXT 0 6 "1 + 2;"}}{COM_R 21 0{TEXT 1 122 "\012You can als
o include fractions, complex numbers (the variable I is the imagi
nary number sqrt(-1)), and special functions:"}}{INP_R 22 0 "> "
{TEXT 0 35 "(32.45 - 12/19)*(12-11*I)^sin(2.7);"}}{COM_R 23 0
{TEXT 1 152 "\012For numerical computations involving only intege
rs and fractions, Maple V maintains \"infinite precision\" by not
 approximating to floating point values:"}}{INP_R 24 0 "> "{TEXT 
0 31 "(32 - 12/19)*(12-11*I)*sqrt(6);"}}{COM_R 25 0{TEXT 1 190 " \+
\012\012SOME SYMBOLIC MANIPULATIONS\012\012Maple V features the m
ost powerful and efficient tools for dealing with formulas and eq
uations that contain unknowns, variables, and parameters.  For ex
ample:"}}{INP_R 26 0 "> "{TEXT 0 24 "(x+a) - 2*x + sin(Pi/4);"}}
{COM_R 27 0{TEXT 1 450 "\012The range of symbolic and numeric ope
rations is enormous.  The following are just a sample of some of \+
the mathematical problems that you can solve with Maple V.\012\01
2You can assign a name to a Maple V expression.  The assign comma
nd is  :=  in Maple V.  This essentially creates a variable in pr
ogramming terms and provides a simple way of organizing your work
.  For example, we create a variable called \"expr\" and store a \+
mathematical expression in it:"}}{INP_R 28 0 "> "{TEXT 0 27 "expr
 := (x+a)^3 - 3*x +1/2;"}}{COM_R 29 0{TEXT 1 129 "\012You can the
n use the subs() function to substitute specific values of the pa
rameters and obtain the result for the expression:  "}}{INP_R 30 
0 "> "{TEXT 0 28 "subs(a=3.45,x=-12.642,expr);"}}{COM_R 31 0{TEXT
 1 103 "\012You can also expand the oringinal expression. The fol
lowing stores the result in the variable \"expr2\":"}}{INP_R 32 0
 "> "{TEXT 0 22 "expr2 := expand(expr);"}}{COM_R 33 0{TEXT 1 150 
"\012The collect() function is used for collecting like terms of \+
a variable in a polynomial.  For example, collect for x in the ab
ove expanded expression:"}}{INP_R 34 0 "> "{TEXT 0 17 "collect(ex
pr2,x);"}}{COM_R 35 0{TEXT 1 147 "\012Lengthy and cumbersome expr
essions can be represented more concisely using the simplify() fu
nction.  For example, trigonometric simplification of:"}}{INP_R 
36 0 "> "{TEXT 0 70 "trig_expr := cos(x)^5 + sin(x)^4 + 2*cos(x)^
2 - 2*sin(x)^2 - cos(2*x);"}}{COM_R 37 0{TEXT 1 23 "\012can  be s
implified to:"}}{INP_R 38 0 "> "{TEXT 0 20 "simplify(trig_expr);"
}}{COM_R 39 0{TEXT 1 106 "\012\012SOLVING EQUATIONS\012\012You ca
n use Maple V to solve algebraic equations.  First, define a symb
olic equation:"}}{INP_R 40 0 "> "{TEXT 0 44 "eqn := x^2-1/2-13/6*
x*(a+x) = -10/3*x-5/3*a;"}}{COM_R 41 0{TEXT 1 60 "\012Solve for x
 to get two solutions to this degree-2 equation:"}}{INP_R 42 0 ">
 "{TEXT 0 13 "solve(eqn,x);"}}{COM_R 43 0{TEXT 1 124 "\012Maple V
 can also solve systems of equations.  In this problem, Maple V f
inds numerical solutions to five coupled equations:"}}{INP_R 44 0
 "> "{TEXT 0 161 "eqn1 := x+1.2*y = 3.9*z+.41*t+5*u + 41;\012eqn2
 := 5*x = 5.1*y+4*z+3*t+2*u;\012eqn3 := 3*y+4*z-8.3*t+2*u=125;\01
2eqn4 := x+0.5*y = z+t+u-9;\012eqn5 := -2.8*x+4*z+3*t+2*u=11;"}}
{COM_R 45 0{TEXT 1 39 "\012Solve using the same solve() function:
"}}{INP_R 46 0 "> "{TEXT 0 33 "solve(\{eqn.(1..5)\}, \{x,y,z,t,u\
});"}}{COM_R 47 0{TEXT 1 153 "Note that \{eqn.(1..5)\} above mean
s \"the set of equations eqn1, eqn2, ..., eqn5\".  This is an exa
mple of many syntax features that simplify Maple V input."}}
{COM_R 48 0{TEXT 1 144 "\012\012CALCULUS\012\012Maple V has an ex
tensive library of functions to support differential and integral
 calculus operations. First, define an expression:"}}{INP_R 49 0 
"> "{TEXT 0 20 "expr := arcsin(x)/x;"}}{COM_R 50 0{TEXT 1 128 "\0
12Differentiation: differentiate the expression with respect to x
 using the diff() function.  Give the result the name d_expr_dx:"
}}{INP_R 51 0 "> "{TEXT 0 26 "d_expr_dx := diff(expr,x);"}}{COM_R
 52 0{TEXT 1 140 "\012Indefinite integration:  symbolically integ
rate, (i.e. find the anti-derivative), of the above result, d_exp
r_dx, using the int() function:"}}{INP_R 53 0 "> "{TEXT 0 17 "int
(d_expr_dx,x);"}}{COM_R 54 0{TEXT 1 70 "Note that we retrieve the
 original expression expr defined previously."}}{COM_R 55 0{TEXT 
1 146 "\012Definite integration: we can also integrate between tw
o specified limits.  For example, perform the previous integratio
n between x=1/2 and x=2/3:"}}{INP_R 56 0 "> "{TEXT 0 28 "int(d_ex
pr_dx,x=1/2 .. 2/3);"}}{COM_R 57 0{TEXT 1 318 "\012Next, try to i
ntegrate the original expression (expr) within the above limits. \+
 The Maple V integration routine applies many techniques to find \+
the integral.  However, some problems may not have a known mathem
atical solution. In cases when Maple V is not able to compute an \+
integral, it responds in the following way:"}}{INP_R 58 0 "> "
{TEXT 0 23 "int(expr,x=1/2 .. 2/3);"}}{COM_R 59 0{TEXT 1 181 "\01
2In such cases, you can perform a numerical integration using a c
ombination of the evalf() function (evaluate as floating point) a
nd a special \"inert\" version of the int() function."}}{INP_R 60
 0 "> "{TEXT 0 30 "evalf(Int(expr,x=1/2 .. 2/3));"}}{COM_R 61 0
{TEXT 1 579 "\012\012GRAPHICS AND VISUALIZATION\012\012Maple V su
pports a wide variety of graphics and visualization.  You can plo
t both mathematical expressions and data in two and three-dimensi
ons.  In addition, animation facilities provide further functiona
lity.\012\012Plot of the sinc function (sin(x)/x) using the plot(
) function.  The plot will appear in a separate window.  Before r
eturning to your Maple V session, you should exit the plot window
 (using the plot window menu) to preserve memory.  When you retur
n to the worksheet, make sure that the cursor is placed on the ne
xt line of Maple V input."}}{INP_R 62 0 "> "{TEXT 0 54 "plot(sin(
x)/x, x=-8..8, title=`The Sinc(x) Function`);"}}{COM_R 63 0{TEXT 
1 400 "\012Plot a surface of  two variables (x and a) using the p
lot3d() function.  Note that you can assign various plot attribut
es from within the function.  Once the plot is displayed, you can
 rotate it by clicking with the left mouse button on any portion \+
of the surface. A box will appear.  Using the left button, rotate
 the box to the desired view, then press the middle mouse button \+
 to redraw the plot:"}}{INP_R 64 0 "> "{TEXT 0 87 "plot3d(exp(-x)
*sin(a*x),a=0..3,x=0..7,axes=FRAME,shading=ZHUE, title=`A Surface
 Plot`);"}}{COM_R 65 0{TEXT 1 186 "\012Parametric Coordinates:  y
ou can also plot curves and surfaces defined parametrically.  For
 example, define the x, y, and z coordinates for a surface as fun
ctions of parameters u and v:"}}{INP_R 66 0 "> "{TEXT 0 76 "x_coo
rd := u*sin(u)*cos(v);\012y_coord := u*cos(u)*cos(v);\012z_coord \+
:= u*sin(v);"}}{COM_R 67 0{TEXT 1 125 "\012Enclose the coordinate
 expressions in square brackets to form a \"list\" and use the pl
ot3d() function to display the surface:"}}{INP_R 68 0 "> "{TEXT 0
 117 "plot3d([x_coord,y_coord,z_coord],u=0..2*Pi,v=0..Pi,orientat
ion=[-20,110], \012       title=`A Parametric Surface Plot`);"}}
{COM_R 69 0{TEXT 1 278 "\012Extended graphics routines are availa
ble via the \"plots package\" which is a set of additional librar
y routines.  Included among these routines are animation.  First,
 call the package using the with() function.  Maple V returns a l
ist of all available functions in this package."}}{INP_R 70 0 "> \+
"{TEXT 0 12 "with(plots);"}}{COM_R 71 0{TEXT 1 228 "\012The plots
 package also supports 2D and 3D animations.  When an animation i
s produced, a special animation window appears.  The animation co
ntrol panel resembles that for a VCR.  Press the \"Play\" button \+
to begin the animation.  "}}{INP_R 72 0 "> "{TEXT 0 51 "animate( \+
\{x-x^3/t , sin(t*x)\}, x=0..Pi/2,t=1..16 );"}}{COM_R 73 0{TEXT 1
 164 "\012\012LINEAR ALGEBRA AND MATRIX MANIPULATIONS\012\012Anot
her useful package \"linalg\" contains routines for linear algebr
a.  Again, call the package using the with() function:"}}{INP_R 
74 0 "> "{TEXT 0 13 "with(linalg);"}}{COM_R 75 0{TEXT 1 82 "Note \+
that the warnings displayed are normal outputs and do not indicat
e a problem."}}{COM_R 76 0{TEXT 1 53 "\012Define a 3x3 matrix [A]
 using the matrix() function:"}}{INP_R 77 0 "> "{TEXT 0 72 "A_mat
rix := matrix([[1,-alpha,2/3],[-1.4,0.3,beta+1],[beta/3,2.25,-1]]
);"}}{COM_R 78 0{TEXT 1 26 "\012Obtain the transpose of :"}}
{INP_R 79 0 "> "{TEXT 0 20 "transpose(A_matrix);"}}{COM_R 80 0
{TEXT 1 34 "\012Compute the symbolic determinant:"}}{INP_R 81 0 "
> "{TEXT 0 14 "det(A_matrix);"}}{COM_R 82 0{TEXT 1 38 "\012Comput
e the symbolic inverse of  [A]:"}}{INP_R 83 0 "> "{TEXT 0 18 "inv
erse(A_matrix);"}}{COM_R 84 0{TEXT 1 244 "Note that Maple V intro
duces the % notation to make the output more concise.  %1 is a te
mporary output variable.  Its definition is displayed below the i
nverse matrix.  Every appearance of %1 within the matrix implies \+
an automatic substitution."}}{COM_R 85 0{TEXT 1 40 "\015Now, defi
ne a numerical 3x3 matrix [B]:"}}{INP_R 86 0 "> "{TEXT 0 64 "B_ma
trix := matrix([[1.0,2.0,3.0],[1.0,2.0,3.0],[2.0,5.0,6.0]]);"}}
{COM_R 87 0{TEXT 1 34 "\012Calculate the eigenvalues of [B]:"}}
{INP_R 88 0 "> "{TEXT 0 20 "eigenvals(B_matrix);"}}{COM_R 89 0
{TEXT 1 65 "\012Calculate the exact exponential matrix of [B] (i.
e. exp([B]*t)):"}}{INP_R 90 0 "> "{TEXT 0 24 "exponential(B_matri
x,t);"}}{COM_R 91 0{TEXT 1 148 "\012The matrixplot() function fro
m the plots package allows you to create a histogram from the num
erical elements of a given matrix, in this case, [B]:"}}{INP_R 92
 0 "> "{TEXT 0 83 "matrixplot(B_matrix,heights=HISTOGRAM,axes=BOX
ED, title=`A Matrix Histogram Plot`);"}}{COM_R 93 0{TEXT 1 61 "\0
12You can multiply 2 matrices.  For example, let [C] = [A][B]:"}}
{INP_R 94 0 "> "{TEXT 0 40 "C_matrix := multiply(A_matrix,B_matri
x);"}}{COM_R 95 0{TEXT 1 280 "\012For more complicated matrix exp
ressions, the evalm() function allows for a more natural notation
.  Note the special operator \"&*\" denote the non-commutative ma
trix multiplication whereas the normal \"*\" operator denotes sca
lar multiplication.  This example computes [A][B]-1/3*[C]"}}
{INP_R 96 0 "> "{TEXT 0 43 "evalm(A_matrix &* B_matrix - 1/3*C_ma
trix);"}}{COM_R 97 0{TEXT 1 181 "\012\012DIFFERENTIAL EQUATIONS\0
12\012Maple V can symbolically solve many ordinary differential e
quations (ODEs) including initial value and boundary value proble
ms.\012\012Define a second order ODE:"}}{INP_R 98 0 "> "{TEXT 0 
57 "diff_eq1 := diff(y(t),t,t) + 5*diff(y(t),t) + 6*y(t) = 0;"}}
{COM_R 99 0{TEXT 1 50 "\012Specify initial conditions for y(0) an
d dy/dx(0):"}}{INP_R 100 0 "> "{TEXT 0 30 "init_con := y(0)=0, D(
y)(0)=1;"}}{COM_R 101 0{TEXT 1 61 "\012Solve the initial value pr
oblem using the dsolve() function."}}{INP_R 102 0 "> "{TEXT 0 33 
"dsolve(\{diff_eq1,init_con\},y(t));"}}{COM_R 103 0{TEXT 1 151 "\
012Define a fourth order differential equation.  Note that Maple \+
V also understands common special functions such as the Dirac del
ta or impulse function:"}}{INP_R 104 0 "> "{TEXT 0 62 "diff_eq2 :
= 10^6*diff(y(x),x,x,x,x) = Dirac(x-2) - Dirac(x-4);"}}{COM_R 105
 0{TEXT 1 76 "\012Specify four boundary conditions on y(t) and th
e second derivative of y(t)."}}{INP_R 106 0 "> "{TEXT 0 56 "bound
_con := y(0)=0, D(D(y))(0)=0, y(5)=0, D(D(y))(5)=0;"}}{COM_R 107 
0{TEXT 1 88 "\012Solve the corresponding boundary value problem a
nd store the result in the name \"soln\":"}}{INP_R 108 0 "> "
{TEXT 0 42 "soln := dsolve(\{diff_eq2,bound_con\},y(x));"}}{COM_R
 109 0{TEXT 1 84 "\015Having stored the result in the variable \"
soln\", you can readily plot the solution:"}}{INP_R 110 0 "> "
{TEXT 0 60 "plot(rhs(soln),x=0..5, title=`Solution of a 4th Order
 BVP`);"}}{COM_R 111 0{TEXT 1 278 "\012\012SPECIAL TRANSFORMS\012
\012Maple V supports special transforms, and their inverses, enco
untered in engineering and science.\012\012Laplace transform:  to
 access the Laplace transform and related routines, you must firs
t call a special library called \"laplace\" using the readlib() f
unction:"}}{INP_R 112 0 "> "{TEXT 0 17 "readlib(laplace);"}}
{COM_R 113 0{TEXT 1 114 "\012Using the laplace() function, transf
orm an expression in the variable t to its equivalent in the Lapl
ace domain.:"}}{INP_R 114 0 "> "{TEXT 0 26 "laplace( t^2+sin(t) ,
t,s);"}}{COM_R 115 0{TEXT 1 139 "\012Compute the inverse Laplace \+
transform of a rational function in the Laplace domain to its equ
ivalent in t using the invlaplace() function:"}}{INP_R 116 0 "> "
{TEXT 0 36 "invlaplace( 1/s * (s+a)/(s+b) ,s,t);"}}{COM_R 117 0
{TEXT 1 50 "\012Z transform:  First, access the \"ztrans\" librar
y:"}}{INP_R 118 0 "> "{TEXT 0 16 "readlib(ztrans);"}}{COM_R 119 0
{TEXT 1 112 "\012Find the Z transform of an expression in nT (sam
pling times) to an expression in z using the ztrans() function:"}
}{INP_R 120 0 "> "{TEXT 0 30 "ztrans(exp(-nT)*cos(nT),nT,z);"}}
{COM_R 121 0{TEXT 1 75 "\012Perform an inverse Z transform comput
ation using the invztrans() function:"}}{INP_R 122 0 "> "{TEXT 0 
40 "invztrans((z^2+z)/(z^2-5/6*z+1/6),z,nT);"}}{COM_R 123 0{TEXT 
1 68 "\012Analytical Fourier transform:  First, access the \"four
ier\" library:"}}{INP_R 124 0 "> "{TEXT 0 17 "readlib(fourier);"}
}{COM_R 125 0{TEXT 1 132 "\012Compute the analytical Fourier tran
sform of a symbolic expression.  Note that Maple V supports the H
eaviside or unit step function:"}}{INP_R 126 0 "> "{TEXT 0 49 "fo
urier(sin(a*t)*exp(-3*t)*Heaviside(t),t,omega);"}}{COM_R 127 0
{TEXT 1 102 "\012Compute the inverse Fourier transform of a compl
ex rational function in the frequency (omega) domain:"}}{INP_R 
128 0 "> "{TEXT 0 49 "invfourier(t*exp(-alpha*t)*Heaviside(t),t,o
mega);"}}{COM_R 129 0{TEXT 1 311 "\015The above result is not ver
y useful mainly because the nature of the parameter alpha has not
 be established.  The Maple V assume() facility tells Maple V fun
ctions about any special constraints that need to be placed on a \+
variable or parameter.  For example, assume that alpha is greater
 than or equal to zero."}}{INP_R 130 0 "> "{TEXT 0 19 "assume(alp
ha >= 0):"}}{COM_R 131 0{TEXT 1 41 "\012Recompute the inverse Fou
rier transform:"}}{INP_R 132 0 "> "{TEXT 0 49 "invfourier(t*exp(-
alpha*t)*Heaviside(t),t,omega);"}}{COM_R 133 0{TEXT 1 154 "\015Th
e tilde character after a variable signifies that it has carries \+
an assume condition.  Now remove all assumptions on alpha to proc
eed to more examples."}}{INP_R 134 0 "> "{TEXT 0 17 "alpha := 'al
pha';"}}{COM_R 135 0{TEXT 1 95 "\012Maple V can also compute nume
rical FFTs given a data series.  First, access the \"FFT\" librar
y:"}}{INP_R 136 0 "> "{TEXT 0 13 "readlib(FFT);"}}{COM_R 137 0
{TEXT 1 149 "\012Real components of the data series are defined i
n a Maple V array.  The real components of the resulting spectrum
 will also be stored in this array:"}}{INP_R 138 0 "> "{TEXT 0 61
 "real_part := array([7.0, 5.2, 6.1, 9.2, 7.2, 5.9, 6.9, 5.7]);"}
}{COM_R 139 0{TEXT 1 169 "\012Imaginary components of the data se
ries are similarly defined in a Maple V array.  The imaginary com
ponents of the resulting spectrum will also be stored in this arr
ay:"}}{INP_R 140 0 "> "{TEXT 0 38 "imag_part := array([0,0,0,0,0,
0,0,0]);"}}{COM_R 141 0{TEXT 1 118 "\012Compute the FFT.  The arg
ument 3 corresponds to 2^3 = 8 data points.  The function returns
 the number of data points:"}}{INP_R 142 0 "> "{TEXT 0 27 "FFT(3,
real_part,imag_part);"}}{COM_R 143 0{TEXT 1 120 "\012The actual r
esults are stored in the arrays, real_part and imag_part.  To vie
w the result, we use the print() function:"}}{INP_R 144 0 "> "
{TEXT 0 17 "print(real_part);"}}{INP_R 145 0 "> "{TEXT 0 17 "prin
t(imag_part);"}}{COM_R 146 0{TEXT 1 466 "\012\012SPECIAL MATHEMAT
ICAL FUNCTIONS\012\012In the previous examples, you have seen the
 special functions Dirac() and Heaviside().  Maple V supports a w
ide variety of other special mathematical functions.\012\012Besse
l functions:  Maple V supports Bessel functions of the first and \+
second kind and hyperbolic Bessel functions of the first and seco
nd kind.  For example, to compute the value of the third order Be
ssel function of the first kind at x=4.2 , use the BesselJ() func
tion:"}}{INP_R 147 0 "> "{TEXT 0 15 "BesselJ(3,4.2);"}}{COM_R 148
 0{TEXT 1 88 "\012Symbolically differentiate a fourth order hyper
bolic Bessel function of the first kind:"}}{INP_R 149 0 "> "{TEXT
 0 21 "diff(BesselI(4,x),x);"}}{COM_R 150 0{TEXT 1 167 "\012Gamma
 function:  plot the gamma function on the interval x=-2 to x=2. \+
 Clip the plot between -20 and 20, and specify that there will be
 discontinuities in this range:"}}{INP_R 151 0 "> "{TEXT 0 71 "pl
ot(GAMMA(x),x=-2..2,-20..20,discont=true,title=`The Gamma Functio
n`);"}}{COM_R 152 0{TEXT 1 41 "\012Error and complementary error \+
functions."}}{INP_R 153 0 "> "{TEXT 0 74 "plot(\{erf(x),erfc(x)\}
,x=0..5,title=`Error and Complementary Error Func.`);"}}{COM_R 
154 0{TEXT 1 110 "\012Special functions can also arise from other
 computations.  For example, in the following indefinite integral
:"}}{INP_R 155 0 "> "{TEXT 0 17 "int(exp(-x^2),x);"}}{COM_R 156 0
{TEXT 1 173 "\012Orthogonal polynomials:  the package \"orthopoly
\" contains several functions that generate useful orthogonal pol
ynomials.  First, call the package using the with() function:"}}
{INP_R 157 0 "> "{TEXT 0 16 "with(orthopoly);"}}{COM_R 158 0{TEXT
 1 36 "\012An eighth order Hermite polynomial:"}}{INP_R 159 0 "> \+
"{TEXT 0 7 "H(8,x);"}}{COM_R 160 0{TEXT 1 63 "\012A sixth order L
aguerre polynomial using (x-a) as the variable:"}}{INP_R 161 0 ">
 "{TEXT 0 9 "L(6,x-a);"}}{COM_R 162 0{TEXT 1 60 "\012Evaluate a f
ifteenth order Chebyshev polynomial for x=1.78:"}}{INP_R 163 0 ">
 "{TEXT 0 11 "T(15,1.78);"}}{COM_R 164 0{TEXT 1 195 "\012\012STAT
ISTICS\012\012Maple V's statistics package \"stats\" provides rou
tines for streamlining many operations involved in the analysis o
f data.  First, access the stats package using the with() functio
n:"}}{INP_R 165 0 "> "{TEXT 0 12 "with(stats);"}}{COM_R 166 0
{TEXT 1 161 "\012You can perform simple statistical operations su
ch as calculating the mean, median, variance, and standard deviat
ion of a data set.  First, define the data set:"}}{INP_R 167 0 ">
 "{TEXT 0 46 "data_set := [1.1,5.8,3.4,4.2,3.9,5.0,0.9,6.2];"}}
{COM_R 168 0{TEXT 1 18 "\012Compute the mean:"}}{INP_R 169 0 "> "
{TEXT 0 25 "describe[mean](data_set);"}}{COM_R 170 0{TEXT 1 31 "\
012Compute the median data point:"}}{INP_R 171 0 "> "{TEXT 0 27 "
describe[median](data_set);"}}{COM_R 172 0{TEXT 1 32 "\012Compute
 the standard deviation:"}}{INP_R 173 0 "> "{TEXT 0 38 "describe[
standarddeviation](data_set);"}}{COM_R 174 0{TEXT 1 381 "\012Prob
ability distributions:  Maple V supports a range of useful probab
ility distributions including, normal, chi-squared, student T, F,
 exponential, among others.  These functions effectively eliminat
e the need for cumbersome tables.  For example, compute various p
robabilities for a normally distributed continuous random variabl
e.  First, define parameters for mean and variance:"}}{INP_R 175 
0 "> "{TEXT 0 29 "my_mean := 0.8;\012my_sdev := 2;"}}{COM_R 176 0
{TEXT 1 120 "\015Use the normald() function to compute the probab
ility that x <= 2.44.  Note the N() is cummulative from -infinity
 to x:"}}{INP_R 177 0 "> "{TEXT 0 52 "p1 := statevalf[cdf,normald
[my_mean,my_sdev]](2.44);"}}{COM_R 178 0{TEXT 1 46 "\012Compute t
he probability that 2.44 <= x <= 10:"}}{INP_R 179 0 "> "{TEXT 0 
47 "statevalf[cdf,normald[my_mean,my_sdev]](10)-p1;"}}{COM_R 180 
0{TEXT 1 321 "\012Least Squares:  Maple V can fit models to data.
  For example, the leastsquare() function computes the parameters
 of a variety of models.  First, define the data as a sequence of
  two Maple V lists.  The first list contains the x values of the
 data (four data points in this case).  The second list contains \+
the y values:"}}{INP_R 181 0 "> "{TEXT 0 67 "Xvalues:=[1,2,3,4]; \+
                      \012Yvalues:=[0,6,14,24];   "}}{COM_R 182 0
{TEXT 1 96 "\012Now fit a quadratic model of the form a*x^2 + b*x
 + c by determining the values of a, b, and c:"}}{INP_R 183 0 "> \+
"{TEXT 0 134 "eq_fit:= fit[leastsquare[[x,y], y=a*x^2+b*x+c, \{a,
b,c\}]]([Xvalues, Yvalues]);                                     \+
                    "}}{COM_R 184 0{TEXT 1 266 "\012The statistic
s package also includes powerful graphics functions to create plo
ts that are specific to statistical applications.  For example, t
he following creates a scatter plot with additional graphic eleme
nts to aid in data interpretation.  First define the data"}}
{INP_R 185 0 "> "{TEXT 0 285 "Xdata := [4.535,4.029,5.407,1.605,5
.757,3.527,7.890,8.159,6.092,13.442,\012          2.845,5.172,3.2
77,8.810,3.657,7.226,3.851,2.162,2.668,4.692];\012Ydata := [7.454
,4.476,2.873,5.476,9.975,-1.476,1.033,1.140,4.813,.450,\012      \+
  -.788,9.389,4.811,-3.107,4.407,5.534,1.691,-.789,1.684,1.605];"
}}{COM_R 186 0{TEXT 1 171 "\015Compose the final graph in one com
mand by combinining the display() function from the plots package
 and various specialized plotting routines from the statistics pa
ckage."}}{INP_R 187 0 "> "{TEXT 0 231 "plots[display](\{\012    s
tatplots[scatter2d](Xdata,Ydata),   \012    statplots[boxplot[15]
](Ydata),    \012    statplots[xyexchange](statplots[notchedbox[1
2]](Xdata))\},\012view =[0..17,-4..14],axes=FRAME,title=`Maple V \+
Statistical Graphics` );"}}{COM_R 188 0{TEXT 1 243 "\012Maple V c
an also be used to develop sophisticated spline-based models.  Fo
r example the spline() function computes a piecewise continuous m
odel that interpolates a data series.  First, access the \"spline
\" library using the readlib() function:"}}{INP_R 189 0 "> "{TEXT
 0 16 "readlib(spline);"}}{COM_R 190 0{TEXT 1 44 "\012Define the \+
x and y coordinates of the data:"}}{INP_R 191 0 "> "{TEXT 0 65 "d
ata_x := [0.0,0.7,2.1,3.6,4.1];\012data_y := [0.0,2.4,3.1,3.0,4.3
];"}}{COM_R 192 0{TEXT 1 204 "\012Compute the cubic splines that \+
connect successive pairs of data points.  The spline() function r
eturns a conditional expression that provides the cubic polynomia
l segments for the various intervals in x:"}}{INP_R 193 0 "> "
{TEXT 0 44 "my_spline := spline(data_x,data_y,x,cubic); "}}{COM_R
 194 0{TEXT 1 266 "\012You can convert the above information to a
 more useful form called a \"procedure\" which is Maple V's term \+
for a subroutine.  The following converts the spline information \+
to a procedure called \"s_model\".  In essence, you have defined \+
a new function called s_model():"}}{INP_R 195 0 "> "{TEXT 0 42 "s
_model := `spline/makeproc`(my_spline,x);"}}{COM_R 196 0{TEXT 1 
27 "\012Now plot the spline model:"}}{INP_R 197 0 "> "{TEXT 0 42 
"plot(s_model,0..5,title=`A Spline Model`);"}}{COM_R 198 0{TEXT 1
 74 "\012You can also calculate specific values of the spline mod
el.  For example:"}}{INP_R 199 0 "> "{TEXT 0 14 "s_model(1.34);"}
}{COM_R 200 0{TEXT 1 670 "\012\012PROGRAMMING\012\012The spline e
xample introduced the concept of a Maple V procedure.  The proced
ure is one of the principal Maple V tools to help you extend its \+
capabilities to suit specific needs in your work.  \012\012For ex
ample, suppose you wanted to be able to define data points for a \+
spline-fitting operation differently from the existing spline() f
unction (e.g. as a list of ordered pairs, rather than an separate
 x and y lists).  And, suppose you wished to automatically view a
 plot of both the data and the resulting model when the spline fi
t is performed.  \012\012The following Maple V procedure creates \+
a new function called plot_spline() which achieves these objectiv
es.  "}}{INP_R 201 0 "> "{TEXT 0 726 "plot_spline := proc(data)\0
12  local i, sp_y, sp_x, sp_proc, plt,p1,p2,x;   # local variable
s\012  sp_y := NULL;  sp_x := NULL;  plt := NULL;   # initialize\
012  for i from 1 to nops(data) do                # generate data
 structures\012     sp_y := sp_y,data[i][2];\012     sp_x := sp_x
,data[i][1];\012     plt := plt,data[i][1],data[i][2];\012  od;\0
12# compute the spline and convert to procedural form\012  sp_pro
c := `spline/makeproc`(spline([sp_x],[sp_y],'x',cubic),'x'); \012
# generate the plots\012  p1 := plot([plt],x=min(sp_x)-1..max(sp_
x)+1,\012             style=POINT,symbol=DIAMOND,color=RED):\012 \+
 p2 := plot(sp_proc,min(sp_x)-1..max(sp_x)+1):\012# combine the p
lots into one plot  \012plots[display]([p1,p2],title=`Cubic Splin
e Programming Example`);\012end;"}}{COM_R 202 0{TEXT 1 213 "\015N
ote, the Maple V programming language features many constructs fo
und in other languages (e.g. parameter passing, local variables, \+
comments, and loops).  \012\012\012Define the data set as a serie
s of ordered pairs (x,y):"}}{INP_R 203 0 "> "{TEXT 0 115 "data_se
t := [[-2.1,-1.5],[-1.8,-.5],[-1.0,-1.2],[-.5,-.25],\012         \+
    [0.3,0.34],[1.1,1.4],[1.7,1.5],[1.9,2.2]];"}}{COM_R 204 0
{TEXT 1 28 "\012Try the new spline routine:"}}{INP_R 205 0 "> "
{TEXT 0 22 "plot_spline(data_set);"}}{COM_R 206 0{TEXT 1 322 "\01
2For programmers, a tremendous benefit of Maple V is its open-arc
hitecture.  Many of Maple V's library functions can be inspected \+
by the user/programmer.  This is an essential tool for enhancing \+
existing routines to meet your specific needs.  For example, the \+
interface() function controls the \"verboseness\" of the output:"
}}{INP_R 207 0 "> "{TEXT 0 25 "interface(verboseproc=2);"}}{COM_R
 208 0{TEXT 1 98 "\012Now, if you wish to view the source code fo
r the Bessel function BesselJ(), we simply print() it:"}}{INP_R 
209 0 "> "{TEXT 0 15 "print(BesselJ);"}}{COM_R 210 0{TEXT 1 32 "\
012Reset the default output level:"}}{INP_R 211 0 "> "{TEXT 0 25 
"interface(verboseproc=1);"}}{COM_R 212 0{TEXT 1 729 "\012\012COD
E GENERATION\012\012Maple V can also be used to generate code tha
t are compatible with various languages such as FORTRAN, C, and t
he LaTeX typsetting language.  One application of this feature is
 to access specialized numerical solvers that provide maximum spe
ed for complex problems.  In such applications, Maple V is used t
o deal with the algebra of formulating the models and equations. \+
 Using the code generation feature, the expressions can be conver
ted in a form that can be directly included in a FORTRAN or C pro
gram.\012\012As an example for code generation, consider a generi
c inverse of a 3x3 matrix (Note: to perform the following calcula
tion, the linalg package must have been accessed previously using
 with(linalg) call): "}}{INP_R 213 0 "> "{TEXT 0 17 "A := matrix(
3,3);"}}{COM_R 214 0{TEXT 1 26 "\012View the contents of [A]:"}}
{INP_R 215 0 "> "{TEXT 0 9 "print(A);"}}{COM_R 216 0{TEXT 1 84 "\
012Compute the symbolic inverse of the matrix.  Store the resulti
ng matrix in [A_inv]:"}}{INP_R 217 0 "> "{TEXT 0 20 "A_inv := inv
erse(A);"}}{COM_R 218 0{TEXT 1 44 "\012Access the FORTRAN code ge
neration library:"}}{INP_R 219 0 "> "{TEXT 0 17 "readlib(fortran)
;"}}{COM_R 220 0{TEXT 1 352 "\012Generate the FORTRAN code for [A
_inv].  This produces exact formulas for all elements of the inve
rse of the matrix.  This avoids the need to program cumbersome in
version routines in a FORTRAN program.  For example, if you only \+
required the diagonal elements of the inverse matrix, the Maple V
 approach greatly simplifies the programming and execution:"}}
{INP_R 221 0 "> "{TEXT 0 15 "fortran(A_inv);"}}{COM_R 222 0{TEXT 
1 38 "\012Access the C code generation library:"}}{INP_R 223 0 ">
 "{TEXT 0 11 "readlib(C);"}}{COM_R 224 0{TEXT 1 427 "\012Generate
 the corresponding C code for the inverse.  In this case include \+
the option \"optimized\".  This option generates a series of temp
orary variables that minimizes the number of computations that th
e resulting C program will have to perform.  For applications req
uiring iterative operations, this can save computation time and m
inimize round-off errors.  Further options include those to write
 the resulting code to a file:"}}{INP_R 225 0 "> "{TEXT 0 19 "C(A
_inv,optimized);"}}{COM_R 226 0{TEXT 1 392 "\015\012INTERACTIVE H
ELP\012\012Maple V provides a complete interactive help system. F
rom the Help menu, you can navigate through the comprehensive set
 of Help pages via an interactive browser, and a powerful keyword
 search facility.  Select the Keyword Search option of the help m
enu and search on \"intro\".  You will get a list important intro
ductory topics to help you become a proficient Maple V user."}}
{COM_R 227 0{TEXT 1 328 "\015\012SUMMARY\012\012This session has \+
provided a small taste of the full power of the Maple V problem-s
olving system.  \012Maple V represents exciting new dimensions in
 engineering and scientific computing.  It is an essential produc
tivity tool that allows technical professionals to be more effici
ent, accurate, and creative in their work.\012"}}}{END}
