{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-couri
er-bold-r-normal--*-120-*-*-*-*-*-*" "courier" "Courier-Bold" 8 
12 192 "Courier-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--*
-140-*-*-*-*-*-*" "times" "Times-Roman" 4 14 64 "Times-Roman" 14}
{FONT 2 "-adobe-courier-medium-r-normal--*-80-*-*-*-*-*-*" "couri
er" "Courier" 4 8 192 "Courier" 8}{FONT 3 "-adobe-times-bold-r-no
rmal--*-240-*-*-*-*-*-*" "times" "Times-Bold" 8 24 64 "Times-Bold
" 24}{FONT 4 "-adobe-times-bold-r-normal--*-180-*-*-*-*-*-*" "tim
es" "Times-Bold" 8 18 64 "Times-Bold" 18}{FONT 5 "-adobe-times-bo
ld-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Tim
es-Bold" 14}{FONT 6 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-
*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{SCP_R 1 0 179
{INP_R 2 0 "> "{TEXT 0 34 "restart: # Press [RETURN] to begin"}}
{COM_R 3 0{TEXT 3 18 "\012Maple V Release 3"}}{COM_R 4 0{TEXT 4 
87 "The Most Comprehensive Mathematical Compuation System For Eng
ineers\015\015General Quick Tour"}}{COM_R 5 0{TEXT 1 44 "\015(c) \+
Copyright 1994 Waterloo Maple Software\015"}}{INP_R 6 0 "> "{TEXT
 0 28 "# Press [RETURN] to continue"}}{COM_R 7 0{TEXT 1 399 "\015
\015INTRODUCTION\015\012Maple V is an essential tool for anyone w
ho needs to use or study mathematics. In this introductory sessio
n you will sample some of the more than 2,500 powerful Maple V fu
nctions. The session covers the following topics:\012\012   Numer
ical Computations\012   2-Dimensional and 3-Dimensional Graphics\
012   Algebraic Computations\012   Basic Calculus\012   Different
ial Equations\012   Matrix Operations\012"}}{INP_R 8 0 "> "{TEXT 
0 28 "# Press [RETURN] to Continue"}}{COM_R 9 0{TEXT 1 647 "\015\
012THE MAPLE V WORKSHEET ENVIRONMENT\012\012Maple V is a comprehe
nsive problem-solving system that supports a wide variety of powe
rful mathematical operations such as symbolic analysis, numerical
 analysis, and graphics.  Maple V also features a complete progra
mming language that uses syntax similar to that of  BASIC, FORTRA
N, Pascal or C.  This language is indispensible for those wishing
 to develop solutions to larger problems.  The Maple V language i
s applied here through the easy-to-use worksheet interface which \+
allows users to obtain quick, accurate answers to mathematical pr
oblems.  The worksheet environment is composed of four components
:  \012"}}{INP_R 10 0 "> "{TEXT 0 28 "# Press [RETURN] to continu
e"}}{COM_R 11 0{TEXT 1 130 "\0121.  Text:  for explanatory notes \+
like this section.\012\0122.  Maple V commands:  for inputing com
mands.  Command lines look like this:"}}{INP_R 12 0 "> "{TEXT 0 
65 "#This is a comment in the Maple V input line. Now press [RETU
RN]."}}{COM_R 13 0{TEXT 1 297 "and are presented in blue Courier \+
font.  Pressing [RETURN] when the Maple V cursor is on a command \+
line initiates computation.\012\0123.  Maple V output:  for displ
aying the results of Maple V computations, like the corresponding
 output from the following input line (press [RETURN] to see outp
ut font):"}}{INP_R 14 0 "> "{TEXT 0 40 "print(`This is a Maple V \+
output line`); "}}{COM_R 15 0{TEXT 1 247 "\0124.  Graphics:  for \+
displaying plots in separate windows.  In the full Maple V system
, plots can be cut  from your plot window and pasted into the wor
ksheet create complete documents. There are many examples of Mapl
e V graphics in this worksheet.\012"}}{INP_R 16 0 "> "{TEXT 0 28 
"# Press [RETURN] to continue"}}{COM_R 17 0{TEXT 1 471 "\012\012W
ORKING THROUGH THIS SAMPLE WORKSHEET\012\0121.  Press the [RETURN
] key repeatedly to proceed through the worksheet. The cursor wil
l automatically move to the next Maple V input line. \012\0122.  \+
If you happen to locate the cursor in another portion of the work
sheet, use the mouse to place it on the appropriate input line.  \+
Note that you may not be able to get proper results if you arbitr
arily execute line out of order, as some commands depend on resul
ts of previous commands.\012"}}{COM_R 18 0{TEXT 1 102 "\015\012NU
MERICAL CALCULATIONS\012\012Maple V can be the ultimate calulator
.  Numbers have never been so friendly."}}{INP_R 19 0 "> "{TEXT 0
 27 "32*12^13;  # Press [RETURN]"}}{COM_R 20 0{TEXT 1 196 "\012Ma
ple V recognizes a wide variety of special operators including fa
ctorial, greatest common divisor, least common multiple, modular \+
arithmetic, and so on.  A factorial example is presented below:"}
}{INP_R 21 0 "> "{TEXT 0 5 "200!;"}}{COM_R 22 0{TEXT 1 337 "\012T
he previous result (200!) can be easily included in any subsequen
t calculation without having to type it.  The double-quote charac
ter (\") is used to refer to the last expression computed by Mapl
e V, in a manner analogous to the use of ditto marks in ordinary \+
English.  For example, this integer can be separated into its pri
me factors:"}}{INP_R 23 0 "> "{TEXT 0 11 "ifactor(\");"}}{COM_R 
24 0{TEXT 1 50 "\012This result can be checked by multiplying it \+
out:"}}{INP_R 25 0 "> "{TEXT 0 11 "expand(\"); "}}{COM_R 26 0
{TEXT 1 133 "\012A principal strength of Maple V is exact arithme
tic. By maintaining fractions and radicals, you can avoid annoyin
g round-off errors:"}}{INP_R 27 0 "> "{TEXT 0 20 "(2^30/3^20)*sqr
t(3);"}}{COM_R 28 0{TEXT 1 93 "\012But Maple V can also provide a
n approximation in the form of a decimal floating point value:"}}
{INP_R 29 0 "> "{TEXT 0 9 "evalf(\");"}}{COM_R 30 0{TEXT 1 30 "\0
12Here is another such example:"}}{INP_R 31 0 "> "{TEXT 0 18 "sin
(sqrt(2/3)*Pi);"}}{INP_R 32 0 "> "{TEXT 0 9 "evalf(\");"}}{COM_R 
33 0{TEXT 1 87 "\012Maple V calculates both finite and infinite s
ums.  An example of a finite sum follows:"}}{INP_R 34 0 "> "{TEXT
 0 28 "Sum((1+i)/(1+i^4), i=1..10);"}}{INP_R 35 0 "> "{TEXT 0 9 "
value(\");"}}{COM_R 36 0{TEXT 1 99 "\012Maple V also calculates b
oth finite and infinite products. Here is an example of a finite \+
product."}}{INP_R 37 0 "> "{TEXT 0 39 "Product(((i^2+3*i-11)/(i+3
)), i=0..10);"}}{INP_R 38 0 "> "{TEXT 0 9 "value(\");"}}{COM_R 39
 0{TEXT 1 130 "\012Maple V does floating-point arithmetic to any \+
desired precision.  For example approximate the above fraction to
 50 decimal places"}}{INP_R 40 0 "> "{TEXT 0 12 "evalf(\",50);"}}
{COM_R 41 0{TEXT 1 58 "\012Maple V also performs calculations usi
ng complex numbers:"}}{INP_R 42 0 "> "{TEXT 0 16 "(3+5*I)/(7+4*I)
;"}}{COM_R 43 0{TEXT 1 149 "\012You can compute numeric values fo
r the elementary functions and many special functions and constan
ts.  For example, compute the base e to 20 digits."}}{INP_R 44 0 
"> "{TEXT 0 19 "evalf(exp(1.0),40);"}}{COM_R 45 0{TEXT 1 41 "\012
The Gamma function to default precision:"}}{INP_R 46 0 "> "{TEXT 
0 18 "evalf(GAMMA(2.5));"}}{COM_R 47 0{TEXT 1 31 "\012And evaluat
e Pi to 500 digits."}}{INP_R 48 0 "> "{TEXT 0 15 "evalf(Pi, 500);
"}}{COM_R 49 0{TEXT 1 328 "\012\0122-DIMENSIONAL AND 3-DIMENSIONA
L GRAPHICS\012\012Maple V supports both 2-dimensional and 3-dimen
sional graphics.  You can plot explicit, implicit, and parametric
 functions.  In addition, you can plot data points.  The followin
g shows Maple V's plot of tan(x).  Notice the way in which Maple \+
V handles functions with discontinuities. "}}{INP_R 50 0 "> "
{TEXT 0 74 "plot( tan(x), x=-2*Pi..2*Pi, -4..4, discont=true, tit
le=`Plot of Tan(x)`);"}}{COM_R 51 0{TEXT 1 564 "\012You can also \+
plot explicit functions of two variables, implicit functions of 3
 variables, parametric spacecurves, and surfaces. The following e
xample plots a function of two variables.  The plot will be displ
ayed in a separate window.  You can rotate it by clicking on any \+
portion of the surface.  A bounding box will then appear.  While \+
holding the mouse button down, rotate the bounding box to the des
ired view. Click the middle mouse button to redraw the surface.  \+
You may wish to experiment with the various graphic options acces
sible through the plot window."}}{INP_R 52 0 "> "{TEXT 0 77 "plot
3d(x*exp(-x^2-y^2), x=-2..2, y=-2..2,axes=BOXED, title=`A Surface
 Plot`);"}}{COM_R 53 0{TEXT 1 83 "\012The following Maple V comma
nds generate a special surface called the Kuen surface:"}}{INP_R 
54 0 "> "{TEXT 0 367 "kuenx:= (u,v) -> 2*(cos(u) + u*sin(u))*sin(
v)/(1 + (u*sin(v))^2);\012kueny:= (u,v) -> 2*(sin(u) - u*cos(u))*
sin(v)/(1 + (u*sin(v))^2);\012kuenz:= (u,v) -> log(tan(v/2)) + 2*
cos(v)/(1 + (u*sin(v))^2);\012plot3d([kuenx,kueny,kuenz],-4..4,.0
1..Pi-.01,grid=[35,35],\012       orientation=[146,76],projection
=0.8,\012       style=patch,ambientlight=[.9,.8,.9], title=`The K
uen Surface`);"}}{COM_R 55 0{TEXT 1 596 "\012Maple V provides a p
ackage of functions to easily generate more complex plots. The pl
ots package is loaded using the with() command, and includes func
tions for plotting in spherical and cylindrical coordinates, conf
ormal plots for complex functions, plotting points in space, and \+
many other specialized graphical representations.  \012\012One fu
nction in this package is implicitplot3d(), which plots an implic
it equation of 3 variables (e.g. f(x,y,z)=0) without resorting to
 explicit solution of any variable. \012\012First, access the ext
ended plot package (Maple V returns a list of available functions
)."}}{INP_R 56 0 "> "{TEXT 0 12 "with(plots);"}}{COM_R 57 0{TEXT 
1 79 "\012Now plot the surface corresponding to the super-ellipso
id x^10+y^10+z^10-1=0 ."}}{INP_R 58 0 "> "{TEXT 0 119 "implicitpl
ot3d(x^10+y^10+z^10-1=0,x=-1..1,y=-1..1,z=-1..1,style=PATCHNOGRID
,\012               title=`A Super-ellipsoid`);"}}{COM_R 59 0
{TEXT 1 228 "\012The plots package also supports 2D and 3D animat
ions.  When an animation is produced, a special animation window \+
appears.  The animation control panel resembles that for a VCR.  \+
Press the \"Play\" button to begin the animation.  "}}{INP_R 60 0
 "> "{TEXT 0 51 "animate( \{x-x^3/t , sin(t*x)\}, x=0..Pi/2, t=1.
.16);"}}{COM_R 61 0{TEXT 1 231 "\015\012ALGEBRAIC COMPUTATIONS\01
2\012Maple V is a very powerful algebraic calculator that can man
ipulate and find solutions to many problems symbolically.\012\012
For example, Maple V automatically evaluates and simplifies the f
ollowing expression: "}}{INP_R 62 0 "> "{TEXT 0 16 "(x+y)^3*(x+y)
^2;"}}{COM_R 63 0{TEXT 1 37 "\012You can also expand the above re
sult"}}{INP_R 64 0 "> "{TEXT 0 10 "expand(\");"}}{COM_R 65 0{TEXT
 1 55 "\012Now, factor the above result to check the computation.
"}}{INP_R 66 0 "> "{TEXT 0 10 "factor(\");"}}{COM_R 67 0{TEXT 1 
144 "\012Maple V provides powerful simplification functions.  For
 example, Maple V can apply trigonometric identities to simplify \+
lengthy expressions:  "}}{INP_R 68 0 "> "{TEXT 0 67 "simplify(cos
(x)^5 + sin(x)^4 + 2*cos(x)^2 - 2*sin(x)^2 - cos(2*x));"}}{COM_R 
69 0{TEXT 1 131 "\012The normal() function normalizes rational ex
pressions.  The result is expressed in the form p/q with the comm
on factors cancelled."}}{INP_R 70 0 "> "{TEXT 0 32 "normal((x^3-y
^3)/(x^2+x-y-y^2));"}}{COM_R 71 0{TEXT 1 278 "\012You can also de
fine variables to be used later.  In addition you can assign a va
riable name to the results of a computation.  This is essential f
or managing large numbers of expressions and function.\012\012For
 example, define an expression and store it in a variable called \+
my_expr."}}{INP_R 72 0 "> "{TEXT 0 34 "my_expr := (41*x^2+x+1)^2*
(2*x-1);"}}{COM_R 73 0{TEXT 1 50 "\012Expand my_expr and store th
e result in my_result."}}{INP_R 74 0 "> "{TEXT 0 29 "my_result :=
 expand(my_expr);"}}{COM_R 75 0{TEXT 1 93 "\012In this example, e
1 is assigned the normalized quotient of the expansion of two exp
ressions:"}}{INP_R 76 0 "> "{TEXT 0 43 "my_numer := expand((41*x^
2+x+1)^2*(2*x-1));"}}{INP_R 77 0 "> "{TEXT 0 36 "my_denom := expa
nd((3*x+5)*(2*x-1));"}}{INP_R 78 0 "> "{TEXT 0 32 "e1 := normal(m
y_numer/my_denom);"}}{COM_R 79 0{TEXT 1 173 "\012The convert( ) o
peration allows you to convert many types of expressions into spe
cific forms.  The following example converts a symbolic expressio
n into a partial fraction:"}}{INP_R 80 0 "> "{TEXT 0 35 "expr := \+
(a*x^2+b)/(x*(-3*x^2-x+4));"}}{INP_R 81 0 "> "{TEXT 0 26 "convert
(expr, parfrac, x);"}}{COM_R 82 0{TEXT 1 90 "\012The following ex
ample converts a trigonometric expression into an exponential exp
ression:"}}{INP_R 83 0 "> "{TEXT 0 22 "convert(cot(x) , exp);"}}
{COM_R 84 0{TEXT 1 151 "\012Maple V provides several ways to defi
ne functions.  One way is to use \"arrow\" mapping notation which
 closely resembles standard mathematical notation:"}}{INP_R 85 0 
"> "{TEXT 0 22 "f1 :=  x ->  x^2+1/2 ;"}}{COM_R 86 0{TEXT 1 65 "\
012Numeric or symbolic values of the function can then be obtaine
d:"}}{INP_R 87 0 "> "{TEXT 0 6 "f1(2);"}}{INP_R 88 0 "> "{TEXT 0 
8 "f1(a+b);"}}{COM_R 89 0{TEXT 1 162 "\012Functions that involve \+
more complicated processing can be defined using a procedure.  Fo
r example consider a piecewise function that involves a logical d
ecision:"}}{INP_R 90 0 "> "{TEXT 0 56 "f2 := proc(x)  \012 if x >
 3 then x^2\012   else x-5\012 fi;\012end;"}}{INP_R 91 0 "> "
{TEXT 0 7 "f2(-1);"}}{INP_R 92 0 "> "{TEXT 0 6 "f2(6);"}}{INP_R 
93 0 "> "{TEXT 0 65 "plot( f2, 0..6, title=`Plot of Piecewise Fun
ction`, axes=BOXED );"}}{COM_R 94 0{TEXT 1 95 "\015\012SOLVING EQ
UATIONS AND SYSTEMS OF EQUATIONS\012\012You can use Maple V to so
lve algebraic equations:"}}{INP_R 95 0 "> "{TEXT 0 55 "expr := x^
3-1/2*x^2*a+13/3*x^2 = 13/6*x*a+10/3*x-5/3*a;"}}{INP_R 96 0 "> "
{TEXT 0 14 "solve(expr,x);"}}{COM_R 97 0{TEXT 1 110 "\012Maple V \+
solves systems of equations.  For example, consider the following
 set of 5 equations and 5 variables."}}{INP_R 98 0 "> "{TEXT 0 
140 "eqn1 := x+2*y+3*z+4*t+5*u=41;\012eqn2 := 5*x+5*y+4*z+3*t+2*u
=20;\012eqn3 := 3*y+4*z-8*t+2*u=125; \012eqn4 := x+y+z+t+u=9;\012
eqn5 := 8*x+4*z+3*t+2*u=11;"}}{COM_R 99 0{TEXT 1 40 "\012Now solv
e the system for all variables."}}{INP_R 100 0 "> "{TEXT 0 53 "s1
 := solve(\{eqn1,eqn2,eqn3,eqn4,eqn5\}, \{x,y,z,t,u\});"}}{COM_R 
101 0{TEXT 1 444 "\012You can also choose to solve an under-const
rained set of equations.  In this example, the concatenation oper
ator is introduced.  For example, consider a system consisting of
 the first 3 equations.  By telling Maple V to solve for only the
 variable x, y, and z, the solutions for these unknowns are retur
ned in terms of the remaining unknowns t and u  (Note: the syntax
 eqn.(1..3) is a short form to the sequence of equations eqn1, eq
n2, eqn3)."}}{INP_R 102 0 "> "{TEXT 0 35 "s2 := solve(\{eqn.(1..3
)\}, \{x,y,z\});"}}{COM_R 103 0{TEXT 1 169 "\015\012BASIC CALCULU
S\012\012Maple V provides many powerful tools for solving problem
s in calculus.  \012For example consider the series approximation
 of  the function sin(4x) cos(x):"}}{INP_R 104 0 "> "{TEXT 0 21 "
f := sin(4*x)*cos(x);"}}{INP_R 105 0 "> "{TEXT 0 21 "fs1 := serie
s(f,x=0);"}}{COM_R 106 0{TEXT 1 68 "\012Now compare the original \+
function and the approximation on a graph."}}{INP_R 107 0 "> "
{TEXT 0 89 "plot(\{f, convert(fs1,polynom)\},x=-1..1, -2..2, \012
      title=`sin(4x) cos(x) vs. Series`);"}}{COM_R 108 0{TEXT 1 
54 "\012Increase the order for the truncation (from 5 to 12)."}}
{INP_R 109 0 "> "{TEXT 0 12 "Order := 12;"}}{COM_R 110 0{TEXT 1 
36 "\012Recompute the series approximation."}}{INP_R 111 0 "> "
{TEXT 0 21 "fs2 := series(f,x=0);"}}{INP_R 112 0 "> "{TEXT 0 89 "
plot(\{f, convert(fs2,polynom)\}, x=-1..1, -2..2,\012      title=
`sin(4x) cos(x) vs. Series`);"}}{COM_R 113 0{TEXT 1 132 "\012Mapl
e V is also useful for computing limits of functions.  For exampl
e, compute the limit of a rational function as x approaches 1."}}
{INP_R 114 0 "> "{TEXT 0 39 "f := (x^2-2*x+1)/(x^4+3*x^3-7*x^2+x+
2);"}}{INP_R 115 0 "> "{TEXT 0 13 "limit(f,x=1);"}}{COM_R 116 0
{TEXT 1 61 "\012Another example: a limit evaluated as x approache
s infinity."}}{INP_R 117 0 "> "{TEXT 0 21 "f := (2*x+3)/(7*x+5);"
}}{INP_R 118 0 "> "{TEXT 0 20 "limit(f,x=infinity);"}}{COM_R 119 
0{TEXT 1 224 "\012You can also take the limit of an expression fr
om the positive and negative directions.  For example consider th
e limit of tan(x) as x approaches Pi/2.\012\012First, compute the
 limit as x approaches the singularity from the left"}}{INP_R 120
 0 "> "{TEXT 0 28 "limit(tan(x), x=Pi/2, left);"}}{COM_R 121 0
{TEXT 1 24 "\012Now try from the right:"}}{INP_R 122 0 "> "{TEXT 
0 29 "limit(tan(x), x=Pi/2, right);"}}{COM_R 123 0{TEXT 1 140 "\0
12Maple V can symbolically compute derivatives and integrals.  Fo
r example, differentiate an expression and call the resulting der
ivative df."}}{INP_R 124 0 "> "{TEXT 0 24 "f := x*sin(a*x) + b*x^
2;"}}{INP_R 125 0 "> "{TEXT 0 16 "df := diff(f,x);"}}{COM_R 126 0
{TEXT 1 70 "\012Now integrate the the result and compare it to th
e original function:"}}{INP_R 127 0 "> "{TEXT 0 22 "simplify( int
(df,x) );"}}{COM_R 128 0{TEXT 1 122 "\012You can also perform def
inite integrations.  For example, recompute the previous integral
 within the interval x=1 to x=2:"}}{INP_R 129 0 "> "{TEXT 0 15 "i
nt(df,x=1..2);"}}{COM_R 130 0{TEXT 1 90 "\012Consider some more c
omplicated integrals.  For example, integrate the following funct
ion:"}}{INP_R 131 0 "> "{TEXT 0 16 "f := exp(-x^2); "}}{INP_R 132
 0 "> "{TEXT 0 9 "int(f,x);"}}{COM_R 133 0{TEXT 1 17 "\012Another
 example:"}}{INP_R 134 0 "> "{TEXT 0 21 "f := exp(-a*t)*ln(t);"}}
{INP_R 135 0 "> "{TEXT 0 21 "int(f,t=0..infinity);"}}{COM_R 136 0
{TEXT 1 216 "\012This solution expressed as a limit may be too ge
neral for some applications.  Maple V's assume() facility allows \+
you to introduce constraints on variables.  For example, assume t
hat a > 0 and recompute the integral:"}}{INP_R 137 0 "> "{TEXT 0 
14 "assume(a > 0):"}}{INP_R 138 0 "> "{TEXT 0 21 "int(f,t=0..infi
nity);"}}{COM_R 139 0{TEXT 1 117 "\012The tilde (~) implies that \+
a carries an assumption.  Now remove the assumption in order to p
roceed to more examples."}}{INP_R 140 0 "> "{TEXT 0 9 "a := 'a':"
}}{COM_R 141 0{TEXT 1 93 "\012Maple V can also compute elliptic i
ntegrals.  For example, integrate the following function:"}}
{INP_R 142 0 "> "{TEXT 0 27 "f := 1/sqrt(2*t^4-3*t^2-2);"}}{INP_R
 143 0 "> "{TEXT 0 14 "int(f,t=2..3);"}}{COM_R 144 0{TEXT 1 680 "
\012The previous integration examples, the results were all in te
rms of special mathematical functions and numbers (e.g. the error
 function, Euler's constant - gamma, the exponential integral Ei,
 and Legendre function).  Maple V support hundreds of special fun
ctions and numbers encountered in many areas of mathematics, incl
uding, the Gamma function, Zeta function, Heaviside step function
, Dirac delta function, Bessel and modified Bessel functions, and
 an entire package for orthogonal polynomials.\012\012\012DIFFERE
NTIAL EQUATIONS\012\012Maple V can symbolically solve many ordina
ry differential equations (ODEs) including initial value and boun
dary value problems.\012\012Define a second order ODE:"}}{INP_R 
145 0 "> "{TEXT 0 57 "diff_eq1 := diff(y(t),t,t) + 5*diff(y(t),t)
 + 6*y(t) = 0;"}}{COM_R 146 0{TEXT 1 50 "\012Specify initial cond
itions for y(0) and dy/dx(0):"}}{INP_R 147 0 "> "{TEXT 0 30 "init
_con := y(0)=0, D(y)(0)=1;"}}{COM_R 148 0{TEXT 1 61 "\012Solve th
e initial value problem using the dsolve() function."}}{INP_R 149
 0 "> "{TEXT 0 33 "dsolve(\{diff_eq1,init_con\},y(t));"}}{COM_R 
150 0{TEXT 1 151 "\012Define a fourth order differential equation
.  Note that Maple V also understands common special functions su
ch as the Dirac delta or impulse function:"}}{INP_R 151 0 "> "
{TEXT 0 62 "diff_eq2 := 10^6*diff(y(x),x,x,x,x) = Dirac(x-2) - Di
rac(x-4);"}}{COM_R 152 0{TEXT 1 76 "\012Specify four boundary con
ditions on y(t) and the second derivative of y(t)."}}{INP_R 153 0
 "> "{TEXT 0 56 "bound_con := y(0)=0, D(D(y))(0)=0, y(5)=0, D(D(y
))(5)=0;"}}{COM_R 154 0{TEXT 1 88 "\012Solve the corresponding bo
undary value problem and store the result in the name \"soln\":"}
}{INP_R 155 0 "> "{TEXT 0 42 "soln := dsolve(\{diff_eq2,bound_con
\},y(x));"}}{COM_R 156 0{TEXT 1 23 "\012Now plot the solution:"}}
{INP_R 157 0 "> "{TEXT 0 72 "plot(rhs(soln),x=0..5, axes=BOXED, t
itle=`Solution to a 4th Order BVP`);"}}{COM_R 158 0{TEXT 1 144 "\
012Maple V can also solve systems of differential equations.  For
 example, solve the following system of two simultaneous, second \+
order equations."}}{INP_R 159 0 "> "{TEXT 0 51 "de_sys := diff(y(
x),x,x)=z(x), diff(z(x),x,x)=y(x);"}}{COM_R 160 0{TEXT 1 130 "\01
2Solve the system without providing additional conditions.  Maple
 V automatically generates the appropriate constants _C1 ... _C4.
"}}{INP_R 161 0 "> "{TEXT 0 30 "dsolve(\{de_sys\}, \{z(x),y(x)\})
;"}}{COM_R 162 0{TEXT 1 478 "\015\012MATRIX OPERATIONS\012\012Pre
viously, some of the power of Maple V's extended plot package was
 demonstrated.  Maple V provides a wide range of special packages
 including a calculus package specially designed for students, st
atistics, number theory, and graph theory.  One of the most frequ
ently used package is the linear algebra package called linalg.  \+
 This package provides a complete set of commands for working wit
h vectors and matrices.\012\012First, load the linear algebra pac
kage:"}}{INP_R 163 0 "> "{TEXT 0 13 "with(linalg);"}}{COM_R 164 0
{TEXT 1 31 "\012Consider a general 3x3 matrix:"}}{INP_R 165 0 "> \+
"{TEXT 0 63 "M1 := array([[1/2,-1/3,2],[-5,14/3,9],[0,11,-5/6]]):
 print(M1);"}}{COM_R 166 0{TEXT 1 21 "\012Compute the inverse:"}}
{INP_R 167 0 "> "{TEXT 0 12 "inverse(M1);"}}{COM_R 168 0{TEXT 1 
59 "\012Define a second matrix M2 containing symbolic information
:"}}{INP_R 169 0 "> "{TEXT 0 61 "M2 := array([[1/2,0,-2],[sin(the
ta),1,phi^2],[0,phi-1,3/4]]);"}}{COM_R 170 0{TEXT 1 20 "\012Multi
ply M1 and M2:"}}{INP_R 171 0 "> "{TEXT 0 22 "M3 := multiply(M1,M
2);"}}{COM_R 172 0{TEXT 1 25 "\012Compute the determinant:"}}
{INP_R 173 0 "> "{TEXT 0 8 "det(M3);"}}{COM_R 174 0{TEXT 1 178 "\
012Compute the symbolic eigenvalues and eigenvectors of M3.  The \+
map() function is introduced to automatically apply a simplificat
ion to all of the computed eigenvalue expressions."}}{INP_R 175 0
 "> "{TEXT 0 30 "map(simplify,[eigenvals(M2)]);"}}{COM_R 176 0
{TEXT 1 308 "The %1 is a place holder used to condense the output
 of expressions that have reocurring terms.  Every occurence of %
1 in the main expression can be substituted with the definition f
or %1.\012\012The linalg package also contains special matrices e
ncountered in mathemics.  For example, compute a 6x6 Hibert matri
x:"}}{INP_R 177 0 "> "{TEXT 0 11 "hilbert(6);"}}{COM_R 178 0{TEXT
 1 70 "\012Generate the Vandermonde matrix for the variables s, t
, u, v, and w: "}}{INP_R 179 0 "> "{TEXT 0 25 "vandermonde([s,t,u
,v,w]);"}}{COM_R 180 0{TEXT 1 699 "\015\012INTERACTIVE HELP\012\0
12Maple V provides a complete interactive help system. From the H
elp menu, you can navigate through the comprehensive set of Help \+
pages via an interactive browser, and a powerful keyword search f
acility.  Select the Keyword Search option of the help menu and s
earch on \"intro\".  You will get a list important introductory t
opics to help you become a proficient Maple V user.\012\012\012SU
MMARY\012\012This session has provided a small taste of the full \+
power of the Maple V problem-solving system.  \012With over 2500 \+
functions, Maple V is the ultimate mathematical assistant.   It i
s an essential tool that allows educators and researchers to be m
ore accurate, creative, productive, and effective.\012"}}}{END}
