{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-new century
 schoolbook-bold-r-normal--*-140-*-*-*-*-*-*" "new century school
book" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 4 "-adobe-times-
bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "T
imes-Bold" 14}{FONT 5 "-adobe-times-medium-r-normal--20-*" "times
" "Times-Roman" 4 12 64 "Times-Roman" 20}{SCP_R 1 0 120{COM_R 2 0
{TEXT 1 0 ""}}{COM_R 3 0{TEXT 4 32 "Public Key Encryption with Ma
ple"}}{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}{COM_R 6 0
{TEXT 1 236 "In 1977 a revolutionary cryptography scheme was inve
nted by three mathematicians: Ron Rivest, Adi Shamir, and  Len Ad
leman.  This technique, called RSA in their honour, was the first
 public key encoding system.  A feature of this method"}}{COM_R 7
 0{TEXT 1 412 "was that the method of encoding a message did not \+
give away the method of decoding.  Thus the encryption method cou
ld be readily made available, hence the name Public Key.  By usin
g such a method, only the decryption key need only be kept safe f
rom adversaries - a much easier task than keeping the entire codi
ng scheme private.  The method uses some basic algebra and this w
orksheet demonstrates its principles."}}{COM_R 8 0{TEXT 1 0 ""}}
{COM_R 9 0{TEXT 1 226 "To begin, we need a way of converting betw
een letters and numbers.  We will only use lower case letters and
 use the obvious map a->1, z->26  and space -> 27.  These two rou
tines do this - don't worry about the details of them."}}{COM_R 
10 0{TEXT 1 0 ""}}{INP_R 11 0 "> "{TEXT 0 19 "to_number:=proc(st)
"}}{INP_R 12 0 "> "{TEXT 0 22 "local ll,nn,ss,ii,num;"}}{INP_R 13
 0 "> "{TEXT 0 196 "num:=table(['a'=1,'b'=2,'c'=3,'d'=4,'e'=5,'f'
=6,'g'=7,'h'=8,'i'=9,'j'=10,'k'=11,'l'=12,'m'=13,'n'=14,'o'=15,'p
'=16,'q'=17,'r'=18,'s'=19,'t'=20,'u'=21,'v'=22,'w'=23,'x'=24,'y'=
25,'z'=26,'` `'=27]):"}}{INP_R 14 0 "> "{TEXT 0 76 "if not type(s
t,string) then ERROR(`wrong number (or type) of arguments`) fi;"}
}{INP_R 15 0 "> "{TEXT 0 16 "ll:=length(st); "}}{INP_R 16 0 "> "
{TEXT 0 27 "if ll= 0 then RETURN(0) fi;"}}{INP_R 17 0 "> "{TEXT 0
 6 "nn:=1;"}}{INP_R 18 0 "> "{TEXT 0 22 "for ii from 1 to ll do"}
}{INP_R 19 0 "> "{TEXT 0 32 "  ss:=num[substring(st,ii..ii)];"}}
{INP_R 20 0 "> "{TEXT 0 80 "  if(not type(ss,numeric)) then ERROR
(`wrong number (or type) of arguments`) fi;"}}{INP_R 21 0 "> "
{TEXT 0 16 "  nn:=100*nn+ss;"}}{INP_R 22 0 "> "{TEXT 0 3 "od;"}}
{INP_R 23 0 "> "{TEXT 0 13 "nn-10^(2*ll);"}}{INP_R 24 0 "> "{TEXT
 0 4 "end:"}}{INP_R 25 0 "> "{TEXT 0 21 "from_number:=proc(nn)"}}
{INP_R 26 0 "> "{TEXT 0 86 "  local ss,mm,ll,ii,ans,a,b,c,d,e,f,g
,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,` `,alpha;"}}{INP_R 27 0 "
> "{TEXT 0 144 "alpha:=table([1=a,2=b,3=c,4=d,5=e,6=f,7=g,8=h,9=i
,10=j,11=k,12=l,13=m,14=n,15=o,16=p,17=q,18=r,19=s,20=t,21=u,22=v
,23=w,24=x,25=y,26=z,27=` `]):"}}{INP_R 28 0 "> "{TEXT 0 9 "  mm:
=nn;"}}{INP_R 29 0 "> "{TEXT 0 80 "  if(not type(nn,integer)) the
n ERROR(`wrong number (or type) of arguments`) fi;"}}{INP_R 30 0 
"> "{TEXT 0 41 "  ll:=floor(trunc(evalf(log10(mm)))/2)+1;"}}
{INP_R 31 0 "> "{TEXT 0 10 "  ans:=``;"}}{INP_R 32 0 "> "{TEXT 0 
25 "  for ii from 1 to ll do "}}{INP_R 33 0 "> "{TEXT 0 15 "    m
m:=mm/100;"}}{INP_R 34 0 "> "{TEXT 0 28 "    ss:=alpha[frac(mm)*1
00];"}}{INP_R 35 0 "> "{TEXT 0 81 "    if(not type(ss,string)) th
en ERROR(`wrong number (or type) of arguments`) fi;"}}{INP_R 36 0
 "> "{TEXT 0 22 "    ans:=cat(ss, ans);"}}{INP_R 37 0 "> "{TEXT 0
 17 "    mm:=trunc(mm)"}}{INP_R 38 0 "> "{TEXT 0 5 "  od;"}}
{INP_R 39 0 "> "{TEXT 0 6 "  ans;"}}{INP_R 40 0 "> "{TEXT 0 4 "en
d:"}}{OUT_R 41 0 40{TEXT 2 1 "\012"}}{COM_R 42 0{TEXT 1 0 ""}}
{COM_R 43 0{TEXT 1 50 "Here is an example of how these routines a
re used:"}}{COM_R 44 0{TEXT 1 0 ""}}{INP_R 45 0 "> "{TEXT 0 19 "t
o_number('maple');"}}{OUT_R 46 0 45{DAG j4x001301161205}}{INP_R 
47 0 "> "{TEXT 0 23 "from_number(805121215);"}}{OUT_R 48 0 47{DAG
 n4\`hello`}}{COM_R 49 0{TEXT 1 0 ""}}{COM_R 50 0{TEXT 1 475 "Now
 we can get down to the mathematics.  The trick that makes public
 key encryption work is the fact that very large integers are ext
remely difficult to factor.  Thus, if we release a large integer \+
with only two large prime factors  to the public, chances are ver
y good an adversary will not be able to factor it.  In the follow
ing examples, the primes are kept much smaller than would be used
 in actual cryptography, where the two prime factors would be of \+
the order 10^100;"}}{COM_R 51 0{TEXT 1 0 ""}}{COM_R 52 0{TEXT 1 
160 "The first step is to select two large primes.  Maple has a f
unction that will return the next prime after a given integer, an
d we will use it to get our primes."}}{COM_R 53 0{TEXT 1 0 ""}}
{INP_R 54 0 "> "{TEXT 0 37 "p:=nextprime(7347124781320478301247);
"}}{INP_R 55 0 "> "{TEXT 0 51 "q:=nextprime(478574839027542389055
784235534782043);"}}{OUT_R 56 0 55{DAG :3n3\`p`j7x007347124781320
478301377}}{OUT_R 57 0 55{DAG :3n3\`q`jAx478574839027542389055784
235534782067}}{COM_R 58 0{TEXT 1 0 ""}}{COM_R 59 0{TEXT 1 133 "On
e of the numbers released as the public key is the integer  n=p*q
, where p and q are the two large primes we have just selected.  \+
 "}}{COM_R 60 0{TEXT 1 0 ""}}{COM_R 61 0{TEXT 1 388 "We now calcu
late the Euler phi function of n,  this being the number of integ
ers less than or equal to n that are coprime to n.  Since we know
 the factorization of n, we can easily compute this number, (p-1)
*(q-1).  Maple does have a built-in function that will compute th
e phi function  for any integer, but it must factor the integer, \+
and this takes a long time, even with this small n!"}}{COM_R 62 0
{TEXT 1 1 " "}}{INP_R 63 0 "> "{TEXT 0 7 "n:=p*q;"}}{OUT_R 64 0 
63{DAG :3n3\`n`j10x0035161490595357154796530135396502003185909037
67034041006259}}{INP_R 65 0 "> "{TEXT 0 19 "phi_n:=(p-1)*(q-1);"}
}{OUT_R 66 0 65{DAG :3n4\`phi_n`j10x00351614905953571547965253496
4811172768854723201478027922816}}{COM_R 67 0{TEXT 1 0 ""}}{COM_R 
68 0{TEXT 1 195 "Now we select another integer, e,  between 2 and
 phi(n), that is coprime to phi(n).  This should be easy if we pi
ck e to be prime and just perform division on phi(n) to ensure it
 is not a factor."}}{COM_R 69 0{TEXT 1 0 ""}}{INP_R 70 0 "> "
{TEXT 0 21 "e:=nextprime(432432);"}}{OUT_R 71 0 70{DAG :3n3\`e`j3
x00432433}}{INP_R 72 0 "> "{TEXT 0 15 "evalf(phi_n/e);"}}{OUT_R 
73 0 72{DAG e3j4x008131084028j2x0042}}{COM_R 74 0{TEXT 1 0 ""}}
{COM_R 75 0{TEXT 1 48 "Now we must solve a linear diophantine equ
ation:"}}{OUT_R 76 0 0{DAG =3+5*5n3\`e`j2x0001n3\`d`p5p5n4\`phi_n
k`p5p5}}{COM_R 77 0{TEXT 1 252 "Here is where we use the algebra.
  This has a solution since e was chosen to be coprime to phi(n).
  Furthermore, the solution is a single congruence class modulo p
hi(n) so there is exactly one number d between 1 and phi(n) that \+
will solve the equation."}}{COM_R 78 0{TEXT 1 0 ""}}{INP_R 79 0 "
> "{TEXT 0 24 "igcdex(e,phi_n,'d','k');"}}{OUT_R 80 0 79{DAG j2x0
001}}{INP_R 81 0 "> "{TEXT 0 15 "d:=d mod phi_n;"}}{OUT_R 82 0 81
{DAG :3n3\`d`j10x002185903712533883860716989527152372758252773961
337230693713}}{COM_R 83 0{TEXT 1 0 ""}}{COM_R 84 0{TEXT 1 312 "No
w we have all the parameters for encryption and decryption.  We r
elease the numbers n and e to the public while keeping the number
 d safe to use in decryption.  The numbers p, q and phi(n) can be
 discarded as they are not needed for decryption but must not be \+
revealed either, as they can be used to compute d."}}{COM_R 85 0
{TEXT 1 0 ""}}{COM_R 86 0{TEXT 1 267 "To encode a message, the us
er turns the message into an integer M and then breaks it up into
 chunks less than or equal to n.  This will be no problem in our \+
case as all we will not encode anything longer than 30 letters or
 so.  The user then computes the remainder of"}}{OUT_R 87 0 0{DAG
 *5^3n3\`M`n3\`e`j2x0001n3\`n`i2x0001}}{COM_R 88 0{TEXT 1 42 "Our
 first example will be a short message."}}{INP_R 89 0 "> "{TEXT 0
 19 "M:=to_number('hi');"}}{OUT_R 90 0 89{DAG :3n3\`M`j2x0809}}
{COM_R 91 0{TEXT 1 76 "Note however, given the huge size of e, we
 cannot hope to compute the power "}}{OUT_R 92 0 0{DAG ^3n3\`M`n3
\`e`}}{COM_R 93 0{TEXT 1 118 "directly.  However, Maple's mod fun
ction is smart enough to reduced each step of the power to someth
ing it can handle."}}{COM_R 94 0{TEXT 1 0 ""}}{INP_R 95 0 "> "
{TEXT 0 20 "C:=Power(M,e) mod n;"}}{OUT_R 96 0 95{DAG :3n3\`C`j10
x000445306247884178784227069275130014327352175968049363742217}}
{COM_R 97 0{TEXT 1 0 ""}}{COM_R 98 0{TEXT 1 279 "This is what we \+
send for our message.  Note that our short message has now become
 quite long.  This does not mean that slightly longer messages wi
ll take up even more space, since every M is sent to exactly one \+
integer between 1 and n, so the message cannot be any longer than
 n."}}{COM_R 99 0{TEXT 1 0 ""}}{COM_R 100 0{TEXT 1 181 "To decode
 the message we use the integer d  and some more algebra.  All we
 compute is C^d mod n.  This will give us not only a number betwe
en 1 and n, but indeed the message itself!"}}{COM_R 101 0{TEXT 1 
1 " "}}{INP_R 102 0 "> "{TEXT 0 17 "Power(C,d) mod n;"}}{OUT_R 
103 0 102{DAG j2x0809}}{INP_R 104 0 "> "{TEXT 0 15 "from_number(\
");"}}{OUT_R 105 0 104{DAG n3\`hi`}}{COM_R 106 0{TEXT 1 0 ""}}
{COM_R 107 0{TEXT 1 329 "The proof that this is always true is 1 \+
short page and uses Fermat's Little Theorem and the Chinese Remai
nder Theorem - both facts that have been known for hundreds of ye
ars.  However, tools like computers (and Maple!) have not been ar
ound that long, and they are the key to finding large primes and \+
performing the calculations. "}}{COM_R 108 0{TEXT 1 0 ""}}{COM_R 
109 0{TEXT 1 293 "There has not yet been a proof that the only wa
y to decrypt C is to factor n and determine d,  despite the work \+
of many mathematicians.  This method cannot really be considered \+
safe until such a proof is made.  If anyone has discovered an eas
ier way to decode the message, they aren't telling!"}}{COM_R 110 
0{TEXT 1 0 ""}}{COM_R 111 0{TEXT 1 75 "As a final example, we wil
l encode a longer  message from Rene Descartes.  "}}{COM_R 112 0
{TEXT 1 0 ""}}{INP_R 113 0 "> "{TEXT 0 39 "M:=to_number(`i think \+
therefore i am`);"}}{OUT_R 114 0 113{DAG :3n3\`M`jCx0927200809141
1272008051805061518052709270113}}{INP_R 115 0 "> "{TEXT 0 20 "C:=
Power(M,e) mod n;"}}{OUT_R 116 0 115{DAG :3n3\`C`j10x001130768087
962955647611115745992731338735951488133460302383}}{INP_R 117 0 ">
 "{TEXT 0 17 "Power(C,d) mod n;"}}{OUT_R 118 0 117{DAG jCx0927200
8091411272008051805061518052709270113}}{INP_R 119 0 "> "{TEXT 0 
15 "from_number(\");"}}{OUT_R 120 0 119{DAG n8\`i~`think~`therefo
re~`i~`am`}}{INP_R 121 0 "> "{TEXT 0 0 ""}}}{END}
