{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-*-Helvetica
-bold-r-normal--*-120-*-*-p-*-*-*" "Helvetica" "Times-Bold" 8 12 
64 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--*-1
20-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 12}
{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Courier"
 "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-new century scho
olbook-bold-r-normal--*-140-*-*-*-*-*-*" "new century schoolbook"
 "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 4 "-adobe-new century
 schoolbook-bold-r-normal--*-140-*-*-*-*-*-*" "new century school
book" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 5 "-adobe-times-
bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "T
imes-Bold" 14}{SCP_R 1 0 155{COM_R 2 0{TEXT 1 0 ""}}{COM_R 3 0
{TEXT 5 40 "Factoring Polynomials over Finite Fields"}}{COM_R 4 0
{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}{COM_R 6 0{TEXT 1 0 ""}}
{COM_R 7 0{TEXT 1 258 "Maple is quite good at factoring uni- and \+
multivariate polynomials over finite fields. The following illust
rates the various functions that are available. For references to
 the algorithms being used, please consult the online help pages \+
for 'Factor'.        "}}{COM_R 8 0{TEXT 1 101 "                  \+
                                                                 \+
                  "}}{COM_R 9 0{TEXT 1 0 ""}}{INP_R 10 0 "> "
{TEXT 0 24 "Factor(x^2+3*x+3) mod 5;"}}{OUT_R 11 0 10{DAG +7*3n3\
`x`j2x0002j2x0001p2j2x0003p9p6}}{COM_R 12 0{TEXT 1 104 "The above
 polynomial is irreducible over the integers mod 3. So let's try \+
a different coefficient field:"}}{COM_R 13 0{TEXT 1 0 ""}}{INP_R 
14 0 "> "{TEXT 0 24 "Factor(x^2+3*x+3) mod 7;"}}{OUT_R 15 0 14
{DAG *5+5n3\`x`j2x0001j2x0004p4p4+5p2p4j2x0006p4p4}}{COM_R 16 0
{TEXT 1 122 "Modulo 7, this polynomial can be factored in linear \+
factors. Z mod 7 is said to be the splitting field of this polyno
mial."}}{COM_R 17 0{TEXT 1 24 "Let's verify the result:"}}{COM_R 
18 0{TEXT 1 0 ""}}{INP_R 19 0 "> "{TEXT 0 10 "expand(\");"}}
{OUT_R 20 0 19{DAG +7*3n3\`x`j2x0002j2x0001p2j2x0010j2x0024p6}}
{COM_R 21 0{TEXT 1 0 ""}}{INP_R 22 0 "> "{TEXT 0 8 "\" mod 7;"}}
{OUT_R 23 0 22{DAG +7*3n3\`x`j2x0002j2x0001p2j2x0003p9p6}}{COM_R 
24 0{TEXT 1 0 ""}}{COM_R 25 0{TEXT 1 36 "Now, let's try some larg
er problems:"}}{COM_R 26 0{TEXT 1 0 ""}}{INP_R 27 0 "> "{TEXT 0 
23 "Factor(x^13-x^2) mod 2;"}}{OUT_R 28 0 27{DAG *7+17*3n3\`x`j2x
0010j2x0001*3p3j2x0009p7*3p3j2x0008p7*3p3j2x0007p7*3p3j2x0006p7*3
p3j2x0005p7*3p3j2x0004p7*3p3j2x0003p7*3p3j2x0002p7p3p7p7p7p7+5p3p
7p7p7p7p3p2E}}{INP_R 29 0 "> "{TEXT 0 23 "Factor(x^13-x^2) mod 3;
"}}{OUT_R 30 0 29{DAG *9+B*3n3\`x`j2x0005j2x0001*3p3j2x0003j2x000
2*3p3pDp7p3pDpDp7p7+Bp2p7*3p3j2x0004p7p9pDpFp7pDp7p7p3pD+5p3p7pDp
7p7}}{INP_R 31 0 "> "{TEXT 0 23 "Factor(x^13-x^2) mod 5;"}}{OUT_R
 32 0 31{DAG *9+D*3n3\`x`j2x0005j2x0001*3p3j2x0004j2x0002*3p3j2x0
003pB*3p3pDp7p3p7pBp7p7+5p3p7pBp7p7p3pD+Dp2p7p9pBpFpBp14p7p3p11pB
p7p7}}{COM_R 33 0{TEXT 1 0 ""}}{COM_R 34 0{TEXT 1 321 "Above, we \+
have factored polynomials with coefficients from a special case o
f the more general Galois field, namely GF(p), with p a prime int
eger. Maple is also able to factor polynomials over a general Gal
ois of order p^k, with p a prime integer and k a positive integer
. p is said to be the characteristic of the field. "}}{COM_R 35 0
{TEXT 1 0 ""}}{COM_R 36 0{TEXT 1 203 "Such a Galois field of orde
r p^k can be thought of as the field Zp (the integers mod p) exte
nded by a special element, an algebraic extension defined by an i
rreducible polynomial over Zp , with degree k."}}{COM_R 37 0{TEXT
 1 0 ""}}{COM_R 38 0{TEXT 1 265 "To clarify this, consider the fo
llowing example: We want to factor the polynomial x^3+1 over the \+
Galois field of order 4=2^2. First we have to choose a suitable p
olynomial to define the field extension. Any irreducible polynomi
al over Z mod 2 with degree 2 will do:"}}{COM_R 39 0{TEXT 1 0 ""}
}{INP_R 40 0 "> "{TEXT 0 6 "x^2+1;"}}{OUT_R 41 0 40{DAG +5*3n3\`x
`j2x0002j2x0001p6p6}}{COM_R 42 0{TEXT 1 0 ""}}{INP_R 43 0 "> "
{TEXT 0 16 "Factor(\") mod 2;"}}{OUT_R 44 0 43{DAG *3+5n3\`x`j2x0
001p4p4j2x0002}}{COM_R 45 0{TEXT 1 63 "This one is clearly not ir
reducible. We have to choose another."}}{COM_R 46 0{TEXT 1 0 ""}}
{INP_R 47 0 "> "{TEXT 0 8 "x^2+x+1;"}}{OUT_R 48 0 47{DAG +7*3n3\`
x`j2x0002j2x0001p2p6p6p6}}{INP_R 49 0 "> "{TEXT 0 16 "Factor(\") \+
mod 2;"}}{OUT_R 50 0 49{DAG +7*3n3\`x`j2x0002j2x0001p2p6p6p6}}
{COM_R 51 0{TEXT 1 166 "This is a good one. Now we use this polyn
omial to create the special element that will extend Z mod 2 to o
ur Galois field of order 2^2, using Maple's RootOf notation:"}}
{COM_R 52 0{TEXT 1 0 ""}}{INP_R 53 0 "> "{TEXT 0 27 "alias(a=Root
Of( x^2+x+1 )):"}}{COM_R 54 0{TEXT 1 0 ""}}{COM_R 55 0{TEXT 1 99 
"The characteristic property of this 'a', is that it nullifies th
e defining polynomial over Z mod 2:"}}{COM_R 56 0{TEXT 1 0 ""}}
{INP_R 57 0 "> "{TEXT 0 8 "a^2+a+1;"}}{OUT_R 58 0 57{DAG +7*3n3\`
a`j2x0002j2x0001p2p6p6p6}}{INP_R 59 0 "> "{TEXT 0 15 "evala(\") m
od 2;"}}{OUT_R 60 0 59{DAG j2x0000}}{COM_R 61 0{TEXT 1 87 "Note, \+
that here evala is used to evaluate an expression over an algebra
ic number field."}}{COM_R 62 0{TEXT 1 0 ""}}{COM_R 63 0{TEXT 1 
107 "Our initial goal was to factor the polynomial x^3+1 over GF(
2^2). FIrst, let's try to factor it over GF(2):"}}{COM_R 64 0
{TEXT 1 0 ""}}{INP_R 65 0 "> "{TEXT 0 20 "Factor(x^3+1) mod 2;"}}
{OUT_R 66 0 65{DAG *5+5n3\`x`j2x0001p4p4p4+7*3p2j2x0002p4p2p4p4p4
p4}}{COM_R 67 0{TEXT 1 224 "You can see that this polynomial has \+
2 factors over Z mod 2. This also means that x^3+1 cannot have fe
wer factors over GF(2^2) as GF(2^2) is an algebraic extension of \+
Z mod 2. Now we try to factor it over the extended field:"}}
{COM_R 68 0{TEXT 1 0 ""}}{INP_R 69 0 "> "{TEXT 0 25 "f:=Factor(x^
3+1,a) mod 2;"}}{OUT_R 70 0 69{DAG :3n3\`f`*7+5n3\`x`j2x0001n3\`a
`p7p7+5p5p7p7p7p7+7p5p7p9p7p7p7p7}}{COM_R 71 0{TEXT 1 86 "So, ove
r GF(2^2) this polynomial splits into linear factors. Let's verif
y this result:"}}{COM_R 72 0{TEXT 1 0 ""}}{INP_R 73 0 "> "{TEXT 0
 10 "expand(\");"}}{OUT_R 74 0 73{DAG +11*3n3\`x`j2x0003j2x0001*5
n3\`a`p6p2j2x0002pD*3p2pDpD*5p9p6p2p6p4p2p6*5p9pDp2p6p6*3p9pDp6p9
p6}}{INP_R 75 0 "> "{TEXT 0 15 "evala(\") mod 2;"}}{OUT_R 76 0 75
{DAG +5*3n3\`x`j2x0003j2x0001p6p6}}{COM_R 77 0{TEXT 1 144 "So the
 result is correct. We will now repeat this verification step a b
it slower, without using evala. First we substitute a dummy name \+
for 'a'."}}{COM_R 78 0{TEXT 1 0 ""}}{INP_R 79 0 "> "{TEXT 0 12 "s
ubs(a=y,f);"}}{OUT_R 80 0 79{DAG *7+5n3\`x`j2x0001n3\`y`p4p4+5p2p
4p4p4p4+7p2p4p4p4p6p4p4}}{COM_R 81 0{TEXT 1 133 "\015Now we reduc
e this result modulo the defining polynomial in the new dummy nam
e 'y': y^2+y+1  We perform this computation in Z mod 2."}}{COM_R 
82 0{TEXT 1 0 ""}}{INP_R 83 0 "> "{TEXT 0 23 "Rem(\",y^2+y+1,y) m
od 2;"}}{OUT_R 84 0 83{DAG +5*3n3\`x`j2x0003j2x0001p6p6}}{COM_R 
85 0{TEXT 1 93 "\015As you can see, we have successfully verified
 the factorization. Here are some more example:"}}{COM_R 86 0
{TEXT 1 0 ""}}{INP_R 87 0 "> "{TEXT 0 33 "alias(alpha=RootOf(y^4-
2) mod 5):"}}{INP_R 88 0 "> "{TEXT 0 24 "Factor( x^4 - 2 ) mod 5;
"}}{OUT_R 89 0 88{DAG +5*3n3\`x`j2x0004j2x0001j2x0003p6}}{INP_R 
90 0 "> "{TEXT 0 31 "Factor( x^4 - 2, alpha ) mod 5;"}}{OUT_R 91 
0 90{DAG *9+5n3\`x`j2x0001n4\`alpha`p4p4+5p2p4p6j2x0003p4+5p2p4p6
j2x0002p4+5p2p4p6j2x0004p4}}{INP_R 92 0 "> "{TEXT 0 48 "Factor( x
^6 - 2*x^4 + 4*x^2 - 8 , alpha ) mod 5;"}}{OUT_R 93 0 92{DAG *D+5
n3\`x`j2x0001j2x0003p4p4+5p2p4j2x0002p4p4+5p2p4j2x0004p4p4+5p2p4p
4p4p4+5p2p4*3n4\`alpha`pDp4p4+5p2p4p21p14p4}}{COM_R 94 0{TEXT 1 0
 ""}}{COM_R 95 0{TEXT 1 165 "If you want to do further processing
 on a  factored polynomial, the 'Factors' command may be useful. \+
Its output consists of a list of factors and their multiplicity:"
}}{COM_R 96 0{TEXT 1 0 ""}}{INP_R 97 0 "> "{TEXT 0 33 "Factors(x^
4+x^3+2*x^2+x+1) mod 3;"}}{OUT_R 98 0 97{DAG [2,3j2x0001[2,3[2,3+
5*3n3\`x`j2x0002p2p2p2p2[2,3+5pAp2pCp2pC}}{COM_R 99 0{TEXT 1 123 
"\015This means that the leading coefficient is 1 and the factors
 are x^2+1, appearing only once and x+2, being a factor twice."}}
{COM_R 100 0{TEXT 1 0 ""}}{COM_R 101 0{TEXT 1 392 "For some probl
ems,  it will be enough to compute the repeated factors of the po
lynomial. This can be achieved using 'Sqrfree'. The output format
 is the same as for 'Factors', but the individual factors in the \+
result are not necessarily irreducible any more. They are, howeve
r, guaranteed to have no repeated factors. Furthermore, the great
est common divisor of the square-free factors is 1.  "}}{COM_R 
102 0{TEXT 1 0 ""}}{INP_R 103 0 "> "{TEXT 0 23 "f:=x^4+2*x^3+x^2+
4*x+4;"}}{OUT_R 104 0 103{DAG :3n3\`f`+B*3n3\`x`j2x0004j2x0001*3p
5j2x0003j2x0002*3p5pFp9p5p7p7p9}}{INP_R 105 0 "> "{TEXT 0 17 "Sqr
free(f) mod 7;"}}{OUT_R 106 0 105{DAG [2,3j2x0001[2,3[2,3+7*3n3\`
x`j2x0002p2pAj2x0003pCp2p2[2,3+5pAp2p10p2pC}}{COM_R 107 0{TEXT 1 
0 ""}}{COM_R 108 0{TEXT 1 86 "For comparison, consider the output
 for 'Factors' and 'Factor' on the same polynomial:"}}{COM_R 109 
0{TEXT 1 0 ""}}{INP_R 110 0 "> "{TEXT 0 17 "Factors(f) mod 7;"}}
{OUT_R 111 0 110{DAG [2,3j2x0001[2,4[2,3+5n3\`x`p2j2x0003p2j2x000
2[2,3+5p9p2pFp2p2[2,3+5p9p2p2p2p2}}{INP_R 112 0 "> "{TEXT 0 16 "F
actor(f) mod 7;"}}{OUT_R 113 0 112{DAG *7+5n3\`x`j2x0001j2x0003p4
j2x0002+5p2p4p9p4p4+5p2p4p4p4p4}}{COM_R 114 0{TEXT 1 0 ""}}{COM_R
 115 0{TEXT 1 165 "If you are only interested in the roots of a g
iven polynomial over a Galois field but do not care for the actua
l factorization, you can use Maple's 'Roots' facility:"}}{COM_R 
116 0{TEXT 1 0 ""}}{INP_R 117 0 "> "{TEXT 0 22 "Roots(x^13-x^2) m
od 2;"}}{OUT_R 118 0 117{DAG [2,3[2,3j2x0001p4[2,3j2x0000j2x0002}
}{COM_R 119 0{TEXT 1 81 "\015This tells us that 0 is a double roo
t and 1 is a single root of the polynomials."}}{COM_R 120 0{TEXT 
1 0 ""}}{COM_R 121 0{TEXT 1 181 "'Roots' may also be used for pol
ynomials over Z mod n, where n is not a prime integer. Note that \+
this domain is not a field any more and hence the factorization w
ould not be unique."}}{COM_R 122 0{TEXT 1 0 ""}}{INP_R 123 0 "> "
{TEXT 0 22 "Roots(x^13-x^2) mod 6;"}}{OUT_R 124 0 123{DAG [2,5[2,
3j2x0001p4[2,3j2x0003p4[2,3j2x0000j2x0002[2,3j2x0004p4}}{COM_R 
125 0{TEXT 1 0 ""}}{COM_R 126 0{TEXT 1 100 "Now it's about time t
o get multivariate. Let's start with a simple bivariate polynomia
l over Z mod 3"}}{COM_R 127 0{TEXT 1 0 ""}}{INP_R 128 0 "> "{TEXT
 0 21 "f:=x^2+2*x*y+x+y+y^2;"}}{OUT_R 129 0 128{DAG :3n3\`f`+B*3n
3\`x`j2x0002j2x0001*5p5p9n3\`y`p9p7p5p9pEp9*3pEp7p9}}{COM_R 130 0
{TEXT 1 0 ""}}{INP_R 131 0 "> "{TEXT 0 16 "Factor(f) mod 3;"}}
{OUT_R 132 0 131{DAG *5+7n3\`x`j2x0001p4p4n3\`y`p4p4+5p2p4p8p4p4}
}{COM_R 133 0{TEXT 1 0 ""}}{COM_R 134 0{TEXT 1 167 "The functiona
lity is the same as for univariate polynomials. So, in order to f
actor a multivariate polynomial over a general Galois field, you \+
would do something like:"}}{COM_R 135 0{TEXT 1 0 ""}}{INP_R 136 0
 "> "{TEXT 0 27 "alias(a=RootOf( x^2+x+1 )):"}}{INP_R 137 0 "> "
{TEXT 0 36 "Factor(x^2+2*x*y+y^2+1+x+y,a) mod 5;"}}{OUT_R 138 0 
137{DAG *5+9n3\`y`j2x0001n3\`x`p4n3\`a`p4p4p4p4+7p2p4p6p4p9j2x000
4p4}}{COM_R 139 0{TEXT 1 0 ""}}{COM_R 140 0{TEXT 1 147 "If the po
lynomial can be readily identified as being over a field extended
 by 'b', you don't have to specify the extension in the call to '
Factor':"}}{COM_R 141 0{TEXT 1 0 ""}}{INP_R 142 0 "> "{TEXT 0 50 
"Factor(x^2*y+x*y^2+2*a*x*y+a*x^2+4*a*x+y+a) mod 5;"}}{OUT_R 143 
0 142{DAG *5+7*5n3\`x`j2x0001n3\`y`p5p5*5n3\`a`p5p3p5p5p5p5p5+7p7
p5p3p5pCp5p5}}{COM_R 144 0{TEXT 1 0 ""}}{COM_R 145 0{TEXT 1 139 "
Just as for univariate polynomials, you might want to compute a s
quare-free factorization of a multivariate polynomial over a Galo
is field:"}}{COM_R 146 0{TEXT 1 1 " "}}{INP_R 147 0 "> "{TEXT 0 
18 "(x+y)^2*(x*y+1)^3;"}}{OUT_R 148 0 147{DAG *5+5n3\`x`j2x0001n3
\`y`p4j2x0002+5*5p2p4p6p4p4p4p4j2x0003}}{INP_R 149 0 "> "{TEXT 0 
16 "expand(\") mod 5;"}}{OUT_R 150 0 149{DAG +19*5n3\`x`j2x0005n3
\`y`j2x0003j2x0001*5p2j2x0004p6j2x0002p8*5p2p8p6pAp8*3p2p11pA*5p2
pEp6pEp11*5p2p8p6p8pA*5p2p11p6p11pA*5p2pAp6pAp11*5p6p4p2p8pA*5p6p
Ep2p11p8*5p6p8p2pAp8*3p6p11pA}}{INP_R 151 0 "> "{TEXT 0 17 "Sqrfr
ee(\") mod 5;"}}{OUT_R 152 0 151{DAG [2,3j2x0001[2,3[2,3+5n3\`x`p
2n3\`y`p2j2x0002[2,3+5*5p9p2pCp2p2p2p2j2x0003}}{COM_R 153 0{TEXT 
1 0 ""}}{COM_R 154 0{TEXT 1 134 "Note that, although in this case
 the square-free factorization corresponds to the complete factor
ization, this is not true in general."}}{COM_R 155 0{TEXT 1 0 ""}
}{INP_R 156 0 "> "{TEXT 0 0 ""}}}{END}
