{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-adobe-courier-medium-r-normal--14-*" "courier" "Co
urier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medium-r-norm
al--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 17}{FONT 4
 "-adobe-times-medium-r-normal--20-*" "times" "Times-Roman" 4 12 
64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-normal--20-*" 
"times" "Times-Roman" 4 12 64 "Times-Roman" 20}{SCP_R 1 0 51
{COM_R 2 0{TEXT 4 21 "\015Graphics with Maple\015"}}{COM_R 3 0
{TEXT 1 615 "\015This worksheet is a demonstration of Maple's gra
phics capabilities.   Place the cursor on the first input line, a
nd step through the examples in order, by pressing <RETURN> at ea
ch Maple command.\015\015Warning:  This worksheet is quite comput
ationally intensive.  After you have looked at each plot, close t
he plot window before executing the next command.  Some plots may
 run for a very long time, or cause your machine to run out of me
mory.  Don't be alarmed - just try looking at this worksheet on a
 more powerful machine.\015\015First we load the plots package, c
ontaining various routines for special types of plotting.\015"}}
{INP_R 4 0 "> "{TEXT 0 12 "with(plots);"}}{OUT_R 5 0 4{DAG [2,22n
4\`animate`n5\`animate3d`n5\`conformal`n5\`contourplot`n6\`cylind
erplot`n5\`densityplot`n4\`display`n5\`display3d`n5\`fieldplot`n5
\`fieldplot3d`n5\`gradplot`n5\`gradplot3d`n6\`implicitplot`n6\`im
plicitplot3d`n5\`loglogplot`n4\`logplot`n5\`matrixplot`n4\`odeplo
t`n5\`pointplot`n5\`polarplot`n5\`polygonplot`n6\`polygonplot3d`n
6\`polyhedraplot`n4\`replot`n5\`setoptions`n6\`setoptions3d`n5\`s
pacecurve`n7\`sparsematrixplot`n5\`sphereplot`n5\`surfdata`n5\`te
xtplot`n5\`textplot3d`n5\`tubeplot`}}{COM_R 6 0{TEXT 1 98 "\015Th
is is an example of using several kinds of plots to examine a fun
ction.  The function will be:\015"}}{INP_R 7 0 "> "{TEXT 0 21 "f \+
:= x*exp(-x^2-y^2);"}}{OUT_R 8 0 7{DAG :3n3\`f`*5n3\`x`j2x0001(3n
3\`exp`,2+5*3p4j2x0002i2x0001*3n3\`y`pFp11p6}}{COM_R 9 0{TEXT 1 
63 "\015We can generate a three dimensional plot for it using plo
t3d.\015"}}{INP_R 10 0 "> "{TEXT 0 57 "plot3d(f,x=-2..2,y=-2..2,a
xes=BOX,orientation=[-116,75]);"}}{COM_R 11 0{TEXT 1 66 "\015cont
ourplot is used to draw the contours of  f on the x-y plane.\015"
}}{INP_R 12 0 "> "{TEXT 0 50 "contourplot(f,x=-2..2,y=-2..2,axes=
BOX,shading=Z);"}}{COM_R 13 0{TEXT 1 86 "\015A density plot is an
other way of conveying three dimensional information in a plane.\
015"}}{INP_R 14 0 "> "{TEXT 0 44 "densityplot(f, x=-2..2, y=-2..2
, axes=BOX );"}}{COM_R 15 0{TEXT 1 241 "\015Finally, we can gener
ate a  plot of the gradient of  f  by using gradplot.  The arrows
 are a points in the two dimensional vector field pointing in the
 direction of increasing f.  The size of the arrow indicates the \+
steepness of the slope.\015"}}{INP_R 16 0 "> "{TEXT 0 61 "gradplo
t(f,x=-2..2,y=-2..2,style=LINE,arrows=SLIM, axes=BOX);"}}{COM_R 
17 0{TEXT 1 62 "\015Kuen's Surface (a surface with a lot of negat
ive curvature).\015"}}{INP_R 18 0 "> "{TEXT 0 294 "kuenx:= (u,v) \+
-> 2*(cos(u)     + u*sin(u))*sin(v)/(1 + (u*sin(v))^2):\012kueny:
= (u,v) -> 2*(sin(u)     - u*cos(u))*sin(v)/(1 + (u*sin(v))^2):\0
12kuenz:= (u,v) -> log(tan(v/2)) +         2*cos(v)/(1 + (u*sin(v
))^2):\012plot3d([kuenx,kueny,kuenz], -4..4, .01 .. Pi-.01,grid=[
35,35],orientation=[134,70]);"}}{COM_R 19 0{TEXT 1 34 "\015A 2 di
mensional parametric plot.\015"}}{INP_R 20 0 "> "{TEXT 0 54 "plot
( [cos(3*t),sin(2*t),t=0..Pi], x=-1..1, y=-1..1 );"}}{COM_R 21 0
{TEXT 1 47 "\015A 3 dimensional plot of an implicit function.\015
"}}{INP_R 22 0 "> "{TEXT 0 84 "implicitplot3d( x^2+y^2+z^2-z*x*y=
1, x=-2..2, y=-2..2, z=-2..2,orientation=[9,63] );"}}{COM_R 23 0
{TEXT 1 15 "\015Pinched Torus\015"}}{INP_R 24 0 "> "{TEXT 0 89 "p
lot3d([cos(t)*(1+.2*sin(u)),sin(t)*(1+.2*sin(u)),.2*sin(t)*cos(u)
],t=0..2*Pi,u=-Pi..Pi);"}}{COM_R 25 0{TEXT 1 14 "\015Soliton Wave
\015"}}{INP_R 26 0 "> "{TEXT 0 2064 "s := sec(arctan(1/2*tan(arct
an(1/5*tan(arctan(exp(-3*x-5/3))-arctan(exp(2*x+5/\0122))))-arcta
n(3*tan(arctan(exp(2*x+5/2))-arctan(exp(x+5))))))+arctan(exp(2*x+
5/2\012))-arctan(19*tan(arctan(3*tan(arctan(exp(2*x+5/2))-arctan(
exp(x+5))))+arctan(7/\0122*tan(arctan(exp(x+5))-arctan(exp(9/5*x+
25/9))))))-arctan(exp(x+5)))^2*(1/2*\012sec(arctan(1/5*tan(arctan
(exp(-3*x-5/3))-arctan(exp(2*x+5/2))))-arctan(3*tan(\012arctan(ex
p(2*x+5/2))-arctan(exp(x+5)))))^2*(1/5*sec(arctan(exp(-3*x-5/3))-
\012arctan(exp(2*x+5/2)))^2*(-3*exp(-3*x-5/3)/(1+exp(-3*x-5/3)^2)
-2*exp(2*x+5/2)/\012(1+exp(2*x+5/2)^2))/(1+1/25*tan(arctan(exp(-3
*x-5/3))-arctan(exp(2*x+5/2)))^2\012)-3*sec(arctan(exp(2*x+5/2))-
arctan(exp(x+5)))^2*(2*exp(2*x+5/2)/(1+exp(2*x+5/\0122)^2)-exp(x+
5)/(1+exp(x+5)^2))/(1+9*tan(arctan(exp(2*x+5/2))-arctan(exp(x+5))
\012)^2))/(1+1/4*tan(arctan(1/5*tan(arctan(exp(-3*x-5/3))-arctan(
exp(2*x+5/2))))-\012arctan(3*tan(arctan(exp(2*x+5/2))-arctan(exp(
x+5)))))^2)+2*exp(2*x+5/2)/(1+exp\012(2*x+5/2)^2)-19*sec(arctan(3
*tan(arctan(exp(2*x+5/2))-arctan(exp(x+5))))+\012arctan(7/2*tan(a
rctan(exp(x+5))-arctan(exp(9/5*x+25/9)))))^2*(3*sec(arctan(exp\01
2(2*x+5/2))-arctan(exp(x+5)))^2*(2*exp(2*x+5/2)/(1+exp(2*x+5/2)^2
)-exp(x+5)/(1\012+exp(x+5)^2))/(1+9*tan(arctan(exp(2*x+5/2))-arct
an(exp(x+5)))^2)+7/2*sec(\012arctan(exp(x+5))-arctan(exp(9/5*x+25
/9)))^2*(exp(x+5)/(1+exp(x+5)^2)-9/5*exp(\0129/5*x+25/9)/(1+exp(9
/5*x+25/9)^2))/(1+49/4*tan(arctan(exp(x+5))-arctan(exp(9/5\012*x+
25/9)))^2))/(1+361*tan(arctan(3*tan(arctan(exp(2*x+5/2))-arctan(e
xp(x+5))))\012+arctan(7/2*tan(arctan(exp(x+5))-arctan(exp(9/5*x+2
5/9)))))^2)-exp(x+5)/(1+exp\012(x+5)^2))/(1+1/16*tan(arctan(1/2*t
an(arctan(1/5*tan(arctan(exp(-3*x-5/3))-\012arctan(exp(2*x+5/2)))
)-arctan(3*tan(arctan(exp(2*x+5/2))-arctan(exp(x+5))))))+\012arct
an(exp(2*x+5/2))-arctan(19*tan(arctan(3*tan(arctan(exp(2*x+5/2))-
arctan(exp\012(x+5))))+arctan(7/2*tan(arctan(exp(x+5))-arctan(exp
(9/5*x+25/9))))))-arctan(exp\012(x+5)))^2)+12*sec(arctan(exp(2*x+
5/2))-arctan(exp(x+5)))^2*(2*exp(2*x+5/2)/(1\012+exp(2*x+5/2)^2)-
exp(x+5)/(1+exp(x+5)^2))/(1+9*tan(arctan(exp(2*x+5/2))-\012arctan
(exp(x+5)))^2):\012plot(s,x=-10..10);"}}{COM_R 27 0{TEXT 1 41 "\0
15A torus knot with its Jones polynomial\015 "}}{INP_R 28 0 "> "
{TEXT 0 487 "r := a+b*cos(m*t):  z := c*sin(m*t):\012torus_knot :
= [r*cos(n*t),r*sin(n*t),z]:\012Jones_polynomial := (1-q)/(1-q^n)
*lambda^((n-1)*(m-1)/2)/(1-lambda*q)*\012sum( (-1)^j*q^(j*m+(n-j-
1)*(n-j)/2)*product(q^i-lambda*q,i=j+1-n..j)/\012(product(1-q^i,i
=1..j)*product(1-q^i,i=1..n-j-1)),j=0..n-1):\012a:=2:  b:=4/5:  c
:=1:  m:=7: n:=4:\012normal(Jones_polynomial);\012tubeplot(torus_
knot,t=0..2*Pi,radius=1/4,title=`torus knot of type 7,4`,\012nump
oints=200,tubepoints=20,orientation=[45,10],style=PATCH,shading=X
YZ);"}}{OUT_R 29 0 28{DAG +3*5+69i2x0001j2x0001*3n3\`q`j2x0008i2x
0003*3p8j2x0016p3*3p8j2x0011i2x0002*5n4\`lambda`j2x0002p8pAp17*5p
1Ap5p8j2x0006j2x0004*5p8pAp1Ap5j2x0005*5p8j2x0010p1Ap5p26*5p8j2x0
013p1Ap5p28*5p8p33p1Ap1DpC*5p8j2x0014p1Ap5p28*5p8p15p1Ap1Di2x0004
*5p8p47p1Ap1Dp17*5p8p10p1Ap1Dp3*5p8p3Ap1Aj2x0003p5*5p8p10p1Ap5p1D
*5p8j2x0017p1Ap5p5*5p1Ap1Dp8j2x0007p17*5p8j2x0015p1Ap63p5*5p8p7Cp
1Ap5p1D*5p8p7Cp1Ap1Dp17*3p8p47p17*3p8p3Ap3*5p8p3Ap1Ap1Dp51*5p1Ap5
p8p77p28*3p8j2x0012pC*5p8pA3p1Ap5p2F*5p8p15p1Ap63p5*3p8p2Fp3*3p8j
2x0009p17*5p8pB8p1Ap1Dp51*3p8p1Dp3*3p8j2x0018p3*5p8pC7p1Ap5p5*5p8
p6Ep1Ap1Dp3*5p8pA3p1Ap1DpC*5p8pB8p1Ap5p2F*5p8p15p1Ap5p2F*3p8p77p1
7*5p8pA3p1Ap63p5*5p1Ap5p8p1Dp5*5p1Ap5p8p63p5*5p1Ap5p8p28p1D*3p8p7
Cp3*3p8p63p3*3p8p33pC*3p8p26pC*3p8p28p17*5p1Ap1Dp8p2Fp3*5p1Ap1Dp8
p26p3*5p1Ap63p8pB8p5*5p1Ap5p8p2Fp1Dp5p1ApB8p3}}{COM_R 30 0{TEXT 1
 48 "\015A rational approximation to the sine function.\015"}}
{INP_R 31 0 "> "{TEXT 0 93 "s := taylor(sin(x), x=0);\012approx :
= convert(s, ratpoly);\012plot(\{approx, sin(x)\}, x = -Pi..Pi);"
}}{OUT_R 32 0 31{DAG :3n3\`s`_An3\`x`j2x0001x1/3i2x0001j2x0006x3/
3p6j2x0120x5(3n3\`O`,2p6x6}}{OUT_R 33 0 31{DAG :3n4\`approx`*5+5*
3n3\`x`j2x0003/3i2x0007j2x0060p7j2x0001p11+5p11p11*3p7j2x0002/3p1
1j2x0020i2x0001}}{COM_R 34 0{TEXT 1 28 "\015Spiral Tube Around a \+
Torus\015"}}{INP_R 35 0 "> "{TEXT 0 286 "with(plots):\012N := 10:
\012tortube := tubeplot(\{[10*cos(t),10*sin(t),0,\012t=0..2*Pi,ra
dius=2,numpoints=10*N,tubepoints=2*N]\012,[cos(t)*(10+4*sin(9*t))
,sin(t)*(10+4*sin(9*t)),4*cos(9*t),\012t=0..2*Pi,radius=1,numpoin
ts=trunc(37.5*N),tubepoints=N]\},\012scaling=CONSTRAINED,orientat
ion=[76,40]):\012tortube;"}}{COM_R 36 0{TEXT 1 19 "\015Conchoid S
urface \015"}}{INP_R 37 0 "> "{TEXT 0 178 "with(plots):\012f:= [(
t-5*Pi)*sin(t)/3,(t-5*Pi)*cos(t)/3,(t-5*Pi)*.9,t=0..5*Pi]:\012Con
choid := tubeplot(f,radius=(t-5*Pi)*.2,orientation=[-37,81],tubep
oints=25,style=PATCH):\012Conchoid;"}}{COM_R 38 0{TEXT 1 105 "\01
5Bivariate Normal Probability Density Function with means (0,0) ,
 variances (1,1) and correlation p=0.5 \015"}}{INP_R 39 0 "> "
{TEXT 0 108 "p := .5:\012plot3d(1/(2*Pi*(1-p^2)^(1/2))*exp(-1/2*(
x^2-2*p*x*y+y^2)/(1-p^2)),\012x=-2..2, y=-2..2, grid=[50,50]);"}}
{COM_R 40 0{TEXT 1 14 "\015Moebius band\012"}}{INP_R 41 0 "> "
{TEXT 0 173 "moebius :=\012plot3d([(5+cos(1/2*t)*u)*cos(t), (5+co
s(1/2*t)*u)*sin(t), sin(1/2*t)*u],\012't'=0..2*Pi, 'u'=-1..1, gri
d=[60,10],scaling=CONSTRAINED,orientation=[-106,70]):\012moebius;
"}}{COM_R 42 0{TEXT 1 17 "\015Borromean Rings\012"}}{INP_R 43 0 "
> "{TEXT 0 394 "with(plots):\012k := 3.^(1/2):\012N := 15:\012kno
t := tubeplot(\{[1+k*cos(t),k*sin(t),.3*sin(3*t),\012t=0..2*Pi,ra
dius=.3,numpoints=trunc(6.4*N),tubepoints=N],\012[-1/2+k*cos(t),k
/2+k*sin(t),.3*sin(3*t),\012t=0..2*Pi,radius=.3,numpoints=trunc(6
.4*N),tubepoints=N],\012[-1/2+k*cos(t),-k/2+k*sin(t),.3*sin(3*t),
\012t=0..2*Pi,radius=.3,numpoints=trunc(6.4*N),tubepoints=N]\},\0
12scaling=CONSTRAINED,orientation=[63,37]):\012knot;"}}{COM_R 44 
0{TEXT 1 35 "\015Three rings with different styles\012"}}{INP_R 
45 0 "> "{TEXT 0 237 "with(plots):\012opts := t=0..2*Pi,numpoints
=100,radius=.2:\012p1 := tubeplot([cos(t),sin(t),0],opts, style=P
ATCH):\012p2 := tubeplot([0,cos(t),sin(t)],opts, style=POINT):\01
2p3 := tubeplot([sin(t),0,cos(t)],opts, style=CONTOUR):\012displa
y(\{p1,p2,p3\});"}}{COM_R 46 0{TEXT 1 30 "\015A procedure to draw
 n torii.\015"}}{INP_R 47 0 "> "{TEXT 0 158 "with(plots):\012tori
i := proc(n) \012\011local s,k;\012\011s := seq(tubeplot([cos(t),
sin(t),k],\012\011\011t=0..2*Pi,numpoints=100,radius=.2),k=0..n-1
);\012\011display(\{s\});\012end:\012torii(5);"}}{COM_R 48 0{TEXT
 1 53 "\015A procedure to draw a mobius band of a given width.\01
5"}}{INP_R 49 0 "> "{TEXT 0 218 "mob := proc(width)\012\011plot3d
(\012\011\011[(5+cos(1/2*t)*u)*cos(t), \012\011\011(5+cos(1/2*t)*
u)*sin(t), \012\011\011sin(1/2*t)*u],\012\011\011t=0..2*Pi, \012\
011\011u=-width/2..width/2, \012\011\011grid=[60,10],\012\011\011
scaling=CONSTRAINED,\012\011\011orientation=[-106,70]);\012end:\0
12mob(15);"}}{COM_R 50 0{TEXT 1 33 "\015Space curve coil around a
 torus\015"}}{INP_R 51 0 "> "{TEXT 0 251 "p1 := spacecurve([cos(t
)*(10+2*sin(t*15)),sin(t)*(10+2*sin(t*15)),\012\0112*cos(t*15),t=
0..2*Pi,numpoints=1000],color=red):\012p2 := tubeplot([10*cos(t),
10*sin(t),0],t=0..2*Pi,numpoints=100,\012\011radius=1.8,style=PAT
CHNOGRID):\012display(\{p1,p2\},scaling=CONSTRAINED);"}}{INP_R 52
 0 "> "{TEXT 0 0 ""}}}{END}
