{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{SCP_R 1 0 101{COM_R 2 0{TEXT 1 0 ""}
}{COM_R 3 0{TEXT 6 23 "Group Theory with Maple"}}{COM_R 4 0{TEXT 
1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}{COM_R 6 0{TEXT 1 91 "Maple has a
 group theory package that can be used to generate and manipulate
 finite groups."}}{COM_R 7 0{TEXT 1 0 ""}}{COM_R 8 0{TEXT 1 226 "
Do you remember the pocket Rubik's cube? If you don't, it's a Rub
ik's cube with only two smaller cubes on each edge. We can repres
ent the permutation group generated by the three cube twist on th
e coloured stickers as follows:"}}{COM_R 9 0{TEXT 1 0 ""}}{COM_R 
10 0{TEXT 1 229 "Maple uses a permutation notation to represent g
roups.  Each list of lists on the next command line is a permutat
ion, with each sublist a cycle.  The group represeting the cube i
s generated by these 3 permutations on 21 elements."}}{COM_R 11 0
{TEXT 1 0 ""}}{INP_R 12 0 "> "{TEXT 0 12 "with(group):"}}{INP_R 
13 0 "> "{TEXT 0 41 "ap := [[1,2,4,3],[10,8,6,20],[9,7,5,21]]:"}}
{INP_R 14 0 "> "{TEXT 0 45 "bp := [[5,6,12,11],[1,7,15,18],[3,13,
16,20]]:"}}{INP_R 15 0 "> "{TEXT 0 47 "cp := [[18,19,21,20],[16,1
4,2,5],[17,10,1,11]]:"}}{INP_R 16 0 "> "{TEXT 0 41 "prc := permgr
oup(21, \{a=ap, b=bp, c=cp\});"}}{OUT_R 17 0 16{DAG :3n3\`prc`(3n
5\`permgroup`,3j2x0021%2,4=3n3\`a`[2,4[2,5j2x0001j2x0002j2x0004j2
x0003[2,5j2x0010j2x0008j2x0006j2x0020[2,5j2x0009j2x0007j2x0005p9=
3n3\`b`[2,4[2,5p2Cp22j2x0012j2x0011[2,5p14p2Aj2x0015j2x0018[2,5p1
Aj2x0013j2x0016p24=3n3\`c`[2,4[2,5p42j2x0019p9p24[2,5p49j2x0014p1
6p2C[2,5j2x0017p1Ep14p3A}}{COM_R 18 0{TEXT 1 0 ""}}{COM_R 19 0
{TEXT 1 76 "We can test the size of the group. How many ways can \+
the cube be scrambled?\015"}}{INP_R 20 0 "> "{TEXT 0 16 "groupord
er(prc);"}}{OUT_R 21 0 20{DAG j3x03674160}}{COM_R 22 0{TEXT 1 0 "
"}}{COM_R 23 0{TEXT 1 95 "We can also test for membership.  Can o
ne piece be twisted leaving the rest of the cube intact?"}}{COM_R
 24 0{TEXT 1 0 ""}}{INP_R 25 0 "> "{TEXT 0 30 "groupmember([[12,1
3,15]],prc);"}}{OUT_R 26 0 25{DAG n4\`false`}}{COM_R 27 0{TEXT 1 
0 ""}}{COM_R 28 0{TEXT 1 36 "Can you exchange two adjacent cubes?
"}}{COM_R 29 0{TEXT 1 0 ""}}{INP_R 30 0 "> "{TEXT 0 41 "groupmemb
er([[3,12],[6,15],[7,13]], prc);"}}{OUT_R 31 0 30{DAG n4\`true`}}
{COM_R 32 0{TEXT 1 0 ""}}{COM_R 33 0{TEXT 1 139 "The obvious six \+
generators of the ordinary Rubik's cube are redundant.  Is this t
he case with the generators we chose for our smaller cube?"}}
{COM_R 34 0{TEXT 1 0 ""}}{INP_R 35 0 "> "{TEXT 0 63 "pg := permgr
oup(21, \{a=ap, b=bp\}); permgroup(21, \{a=ap, b=bp\});"}}{OUT_R 
36 0 35{DAG :3n3\`pg`(3n5\`permgroup`,3j2x0021%2,3=3n3\`a`[2,4[2,
5j2x0001j2x0002j2x0004j2x0003[2,5j2x0010j2x0008j2x0006j2x0020[2,5
j2x0009j2x0007j2x0005p9=3n3\`b`[2,4[2,5p2Cp22j2x0012j2x0011[2,5p1
4p2Aj2x0015j2x0018[2,5p1Aj2x0013j2x0016p24}}{OUT_R 37 0 35{DAG (3
n5\`permgroup`,3j2x0021%2,3=3n3\`a`[2,4[2,5j2x0001j2x0002j2x0004j
2x0003[2,5j2x0010j2x0008j2x0006j2x0020[2,5j2x0009j2x0007j2x0005p6
=3n3\`b`[2,4[2,5p29p1Fj2x0012j2x0011[2,5p11p27j2x0015j2x0018[2,5p
17j2x0013j2x0016p21}}{INP_R 38 0 "> "{TEXT 0 19 "groupmember(cp,p
g);"}}{OUT_R 39 0 38{DAG n4\`false`}}{COM_R 40 0{TEXT 1 0 ""}}
{COM_R 41 0{TEXT 1 55 "Thus, the order of the two-twist group mus
t be smaller."}}{COM_R 42 0{TEXT 1 0 ""}}{INP_R 43 0 "> "{TEXT 0 
15 "grouporder(pg);"}}{OUT_R 44 0 43{DAG j3x00029160}}{COM_R 45 0
{TEXT 1 0 ""}}{COM_R 46 0{TEXT 1 184 "Here's a familiar problem, \+
first posed by Conway. Consider the group generated by a, b, c d,
 and e which satisfy ab=c, bc=d, cd=e, de=a, and ea=b. How many e
lements are in the group?  "}}{COM_R 47 0{TEXT 1 0 ""}}{COM_R 48 
0{TEXT 1 183 "This example shows Maple's other notation for repre
senting a group.  The first set  is a list of generators.   Each \+
list in the second set represents a product of elements equal to \+
1."}}{COM_R 49 0{TEXT 1 1 " "}}{INP_R 50 0 "> "{TEXT 0 31 "g := g
relgroup(\{a, b, c, d, e\},"}}{INP_R 51 0 "> "{TEXT 0 53 "\{[a,b,
1/c],[b,c,1/d],[c,d,1/e],[d,e,1/a],[e,a,1/b]\});"}}{OUT_R 52 0 51
{DAG :3n3\`g`(3n5\`grelgroup`,3%2,6n3\`a`n3\`b`n3\`c`n3\`e`n3\`d`
%2,6[2,4pBpD*3pFi2x0001[2,4pDpF*3p13p1D[2,4pFp13*3p11p1D[2,4p13p1
1*3pBp1D[2,4p11pB*3pDp1D}}{INP_R 53 0 "> "{TEXT 0 14 "grouporder(
g);"}}{OUT_R 54 0 53{DAG n5\`infinity`}}{COM_R 55 0{TEXT 1 0 ""}}
{COM_R 56 0{TEXT 1 94 "Now consider the group generated by a, b, \+
c and d which satisfy d=abc, a=bcd, b=cda and c=dab."}}{COM_R 57 
0{TEXT 1 0 ""}}{INP_R 58 0 "> "{TEXT 0 25 "g := grelgroup(\{a,b,c
,d\},"}}{INP_R 59 0 "> "{TEXT 0 51 "\{[a,b,c,1/d],[b,c,d,1/a],[c,
d,a,1/b],[d,a,b,1/c]\});"}}{OUT_R 60 0 59{DAG :3n3\`g`(3n5\`grelg
roup`,3%2,5n3\`a`n3\`b`n3\`c`n3\`d`%2,5[2,5pBpDpF*3p11i2x0001[2,5
pDpFp11*3pBp1C[2,5pFp11pB*3pDp1C[2,5p11pBpD*3pFp1C}}{COM_R 61 0
{TEXT 1 0 ""}}{COM_R 62 0{TEXT 1 44 "It has a subgroup generated \+
by x=ab and y=ac"}}{COM_R 63 0{TEXT 1 0 ""}}{INP_R 64 0 "> "{TEXT
 0 35 "sg := subgrel(\{x=[a,b],y=[a,c]\},g);"}}{OUT_R 65 0 64{DAG
 :3n3\`sg`(3n4\`subgrel`,3%2,3=3n3\`x`[2,3n3\`a`n3\`b`=3n3\`y`[2,
3pFn3\`c`(3n5\`grelgroup`,3%2,5pFp11p19n3\`d`%2,5[2,5pFp11p19*3p2
6i2x0001[2,5p11p19p26*3pFp31[2,5p19p26pF*3p11p31[2,5p26pFp11*3p19
p31}}{COM_R 66 0{TEXT 1 0 ""}}{COM_R 67 0{TEXT 1 80 "We can now f
ind a complete list of representative elements of the set of cose
ts."}}{COM_R 68 0{TEXT 1 0 ""}}{INP_R 69 0 "> "{TEXT 0 11 "cosets
(sg);"}}{OUT_R 70 0 69{DAG %2,5[2,1[2,2n3\`a`[2,2n3\`c`[2,3n3\`b`
pA}}{COM_R 71 0{TEXT 1 0 ""}}{COM_R 72 0{TEXT 1 41 "Which coset d
oes the product cad fall in?"}}{COM_R 73 0{TEXT 1 0 ""}}{INP_R 74
 0 "> "{TEXT 0 20 "cosrep([c,a,d], sg);"}}{OUT_R 75 0 74{DAG [2,3
[2,5*3n3\`x`i2x0001*3n3\`y`p7p5p5[2,2n3\`c`}}{COM_R 76 0{TEXT 1 
121 "The first list here is the representative in terms of the su
bgroup generators, the second in terms of the complete group."}}
{COM_R 77 0{TEXT 1 0 ""}}{COM_R 78 0{TEXT 1 90 "We can ask for a \+
representation of  the subgroup in terms of its generators and re
lations."}}{COM_R 79 0{TEXT 1 0 ""}}{INP_R 80 0 "> "{TEXT 0 9 "pr
es(sg);"}}{OUT_R 81 0 80{DAG (3n5\`grelgroup`,3%2,3n3\`y`n3\`x`%2
,4[2,9*3pAi2x0001p8p8p10*3p8p12pApAp17[2,Bp8p10p10p10p8pAp17pAp17
pA[2,9p10p8p10p17pAp8pAp17}}{COM_R 82 0{TEXT 1 0 ""}}{COM_R 83 0
{TEXT 1 96 "Finally, consider the group generated by x and y such
 that xxyxyyy = yyxyxxx = 1. How big is it?"}}{COM_R 84 0{TEXT 1 
0 ""}}{INP_R 85 0 "> "{TEXT 0 57 "g := grelgroup(\{x,y\}, \{[x,x,
y,x,y,y,y],[y,y,x,y,x,x,x]\});"}}{OUT_R 86 0 85{DAG :3n3\`g`(3n5\
`grelgroup`,3%2,3n3\`y`n3\`x`%2,3[2,8pDpDpBpDpBpBpB[2,8pBpBpDpBpD
pDpD}}{INP_R 87 0 "> "{TEXT 0 14 "grouporder(g);"}}{OUT_R 88 0 87
{DAG j2x0056}}{COM_R 89 0{TEXT 1 0 ""}}{COM_R 90 0{TEXT 1 54 "We \+
can get a permutation representation of this group."}}{COM_R 91 0
{TEXT 1 0 ""}}{INP_R 92 0 "> "{TEXT 0 34 "pg := permrep(subgrel(\
{y=[y]\},g));"}}{OUT_R 93 0 92{DAG :3n3\`pg`(3n5\`permgroup`,3j2x
0008%2,3=3n3\`x`[2,2[2,8j2x0001j2x0004j2x0005j2x0003j2x0006j2x000
7p9=3n3\`y`[2,2[2,8p14p9p1Ap1Ep16j2x0002p18}}{COM_R 94 0{TEXT 1 0
 ""}}{COM_R 95 0{TEXT 1 42 "And we can check the group order here
 too."}}{COM_R 96 0{TEXT 1 0 ""}}{INP_R 97 0 "> "{TEXT 0 15 "grou
porder(pg);"}}{OUT_R 98 0 97{DAG j2x0056}}{COM_R 99 0{TEXT 1 0 ""
}}{COM_R 100 0{TEXT 1 70 "The sizes are the same, so the permutat
ion representation is faithful."}}{COM_R 101 0{TEXT 1 0 ""}}
{INP_R 102 0 "> "{TEXT 0 0 ""}}}{END}
