{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-140-*-*-m-*-*-*" "Cou
rier" "Courier" 4 14 192 "Courier" 14}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{SCP_R 1 0 188{COM_R 2 0{TEXT 1 0 ""}}{COM_R 3 0{TEXT 7 22 "Integ
ration with Maple"}}{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 "
"}}{COM_R 6 0{TEXT 1 189 "This worksheet demonstrates the power o
f Maple's integration.   Maple attempts to integrate indefinite i
ntegrals symbolically.  If it is given a function it knows nothin
g about, it returns:"}}{COM_R 7 0{TEXT 1 0 ""}}{INP_R 8 0 "> "
{TEXT 0 12 "int(f(x),x);"}}{OUT_R 9 0 8{DAG (3n3\`int`,3(3n3\`f`,
2n3\`x`p8}}{COM_R 10 0{TEXT 1 0 ""}}{COM_R 11 0{TEXT 1 162 "Maple
 knows the integral of many elementary functions.  The next few e
xamples are typical of first year Calculus courses.  To start, Ma
ple know about polynomials."}}{COM_R 12 0{TEXT 1 0 ""}}{INP_R 13 
0 "> "{TEXT 0 16 "f1:=x^7-4*x^3+3;"}}{OUT_R 14 0 13{DAG :3n3\`f1`
+7*3n3\`x`j2x0007j2x0001*3p5j2x0003i2x0004pDp9}}{INP_R 15 0 "> "
{TEXT 0 10 "int(f1,x);"}}{OUT_R 16 0 15{DAG +7*3n3\`x`j2x0008/3j2
x0001p4*3p2j2x0004i2x0001p2j2x0003}}{COM_R 17 0{TEXT 1 0 ""}}
{COM_R 18 0{TEXT 1 118 "Maple can also integrate rational functio
ns.  These would be integrated by hand using the method of partia
l fractions."}}{COM_R 19 0{TEXT 1 0 ""}}{INP_R 20 0 "> "{TEXT 0 
47 "f2:= (x^3-x) / (x^5 + x^4 + x^3 - x^2 - x - 1);"}}{OUT_R 21 0
 20{DAG :3n3\`f2`*5+5*3n3\`x`j2x0003j2x0001p6i2x0001pA+D*3p6j2x00
05pA*3p6j2x0004pAp5pA*3p6j2x0002pDp6pDpDpApD}}{INP_R 22 0 "> "
{TEXT 0 10 "int(f2,x);"}}{OUT_R 23 0 22{DAG +5*5+5n3\`x`j2x0002j2
x0001p7p7+7*3p3p5p7p3p7p7p7i2x0001/3p14j2x0003*5p18/3p7p5(3n4\`ar
ctan`,2+3*5p2p7p18p1C/3p7p18p7/3p5j2x0009}}{COM_R 24 0{TEXT 1 0 "
"}}{COM_R 25 0{TEXT 1 163 "That last example also shows that Mapl
e knows about the derivatives and integrals of trigonometric and \+
exponential functions.  Here are some more examples of this."}}
{COM_R 26 0{TEXT 1 0 ""}}{INP_R 27 0 "> "{TEXT 0 13 "f3 := exp(x)
;"}}{OUT_R 28 0 27{DAG :3n3\`f3`(3n3\`exp`,2n3\`x`}}{INP_R 29 0 "
> "{TEXT 0 10 "int(f3,x);"}}{OUT_R 30 0 29{DAG (3n3\`exp`,2n3\`x`
}}{INP_R 31 0 "> "{TEXT 0 13 "f4:=sin(x)^2;"}}{OUT_R 32 0 31{DAG 
:3n3\`f4`*3(3n3\`sin`,2n3\`x`j2x0002}}{INP_R 33 0 "> "{TEXT 0 10 
"int(f4,x);"}}{OUT_R 34 0 33{DAG +5*5(3n3\`cos`,2n3\`x`j2x0001(3n
3\`sin`p5p8/3i2x0001j2x0002p6/3p8p12}}{COM_R 35 0{TEXT 1 0 ""}}
{COM_R 36 0{TEXT 1 108 "Maple can take apart compositions of func
tions to reduce a complex integral into something it can integrat
e."}}{COM_R 37 0{TEXT 1 0 ""}}{INP_R 38 0 "> "{TEXT 0 78 "f5 := (
(1-x^2)*sin(2*x-1) + 2*x*(x^2+1)*cos(2*x-1) + 2*x) / (x^4 + 2*x^2
 + 1);"}}{OUT_R 39 0 38{DAG :3n3\`f5`*5+7*5+5j2x0001p7*3n3\`x`j2x
0002i2x0001p7(3n3\`sin`,2+5pBpDpFp7p7p7*7pBp7+5pAp7p7p7p7(3n3\`co
s`p15p7pDpBpDp7+7*3pBj2x0004p7pApDp7p7pF}}{INP_R 40 0 "> "{TEXT 0
 24 "r5:=simplify(int(f5,x));"}}{OUT_R 41 0 40{DAG :3n3\`r5`*5+5i
2x0001j2x0001*5(3n3\`sin`,2+5n3\`x`j2x0002p5p7p7pFp7p7p7+5*3pFp11
p7p7p7p5}}{COM_R 42 0{TEXT 1 0 ""}}{COM_R 43 0{TEXT 1 126 "This n
ext integral takes hundreds of pages of formulae to calculate by \+
hand.  It's not surprising that its output is long too!"}}{COM_R 
44 0{TEXT 1 0 ""}}{INP_R 45 0 "> "{TEXT 0 46 "f6 := t^2*(t+2*z)^4
/(t+z)^5/(t*z+z^2+1)^(5/2);"}}{OUT_R 46 0 45{DAG :3n3\`f6`*9n3\`t
`j2x0002+5p4j2x0001n3\`z`p6j2x0004+5p4pApCpAi2x0005+7*5p4pApCpApA
*3pCp6pApApA/3p16p6}}{INP_R 47 0 "> "{TEXT 0 10 "int(f6,t);"}}
{OUT_R 48 0 47{DAG +F*5n3\`z`i2x0002+7*3+7*5n3\`t`j2x0001p2pCpC*3
p2j2x0002pCpCpC/3i2x0001p13p4*5p8/3i2x0003p13p2p13/3p13j2x0003*3p
8p1Fp25pCpCp29p4*5p2j2x0010+F*5p8p1F+5p9pCp11pCi2x0004p25*5p8p18p
39p3E/3j2x0022p27*5p8/3pCp13p39p3E/3i2x0033j2x0004*5p8p4Cp39p20/3
j2x0077j2x0008*5p8p4Cp39p4/3i2x0385j2x0032*5p8p4Cp39p19/3j2x1155j
2x0064(3n4\`arctanh`,2*3p8p4C/3i2x1155p72pCpC*5p2p5E+D*5p8p1Fp39p
20p25*5p8p18p39p20j2x0006p56i2x0007p60/3j2x0035p54p6A/3i2x0105p5E
p74/3j2x0105p5EpCp13*5p2p91+B*5p8p1Fp39p4p25*5p8p18p39p4/3j2x0014
p27p60/3i2x0035p91p6Ap97p74/3pBCp54pCp19*5p2p54+9*5p8p1Fp39p19p25
*5p8p18p39p19/3p33p27p6Ai2x0005p74j2x0005pCp3E*5+7p29p25p7p13p74p
4pCp2p13p19}}{COM_R 49 0{TEXT 1 0 ""}}{COM_R 50 0{TEXT 1 79 "Mapl
e also know about definite integration.  Here is another rational
 function."}}{COM_R 51 0{TEXT 1 0 ""}}{INP_R 52 0 "> "{TEXT 0 22 
"f7 := 1/(x+3)^3 + 1/x;"}}{OUT_R 53 0 52{DAG :3n3\`f7`+5*3+5n3\`x
`j2x0001j2x0003p8i2x0003p8*3p6i2x0001p8}}{INP_R 54 0 "> "{TEXT 0 
19 "r7:=int(f7,x=1..2);"}}{OUT_R 55 0 54{DAG :3n3\`r7`+5/3j2x0009
j2x0800j2x0001(3n3\`ln`,2j2x0002p9}}{COM_R 56 0{TEXT 1 0 ""}}
{COM_R 57 0{TEXT 1 60 "If we want, we can evaluate this to a floa
ting point number."}}{COM_R 58 0{TEXT 1 0 ""}}{INP_R 59 0 "> "
{TEXT 0 10 "evalf(r7);"}}{OUT_R 60 0 59{DAG e3j4x007043971806i2x0
010}}{COM_R 61 0{TEXT 1 0 ""}}{COM_R 62 0{TEXT 1 85 "In some case
s, the form of an integral depends on a parameter.  For example c
onsider:"}}{COM_R 63 0{TEXT 1 0 ""}}{INP_R 64 0 "> "{TEXT 0 29 "f
8:= exp(-u*x)*ln(x)*sqrt(x);"}}{OUT_R 65 0 64{DAG :3n3\`f8`*7(3n3
\`exp`,2+3*5n3\`u`j2x0001n3\`x`pCi2x0001pC(3n3\`ln`,2pEpCpE/3pCj2
x0002}}{INP_R 66 0 "> "{TEXT 0 22 "int(f8,x=0..infinity);"}}
{OUT_R 67 0 66{DAG (3n3\`int`,3*7(3n3\`exp`,2+3*5n3\`u`j2x0001n3\
`x`pDi2x0001pD(3n3\`ln`,2pFpDpF/3pDj2x0002=3pF~3j2x0000n5\`infini
ty`}}{COM_R 68 0{TEXT 1 0 ""}}{COM_R 69 0{TEXT 1 122 "Since nothi
ng is known about u, Maple cannot determine an answer.  We can us
e the assume facility to inform Maple about u."}}{COM_R 70 0{TEXT
 1 0 ""}}{INP_R 71 0 "> "{TEXT 0 35 "assume(u<0); int(f8,x=0..inf
inity);"}}{OUT_R 72 0 71{DAG n5\`infinity`}}{COM_R 73 0{TEXT 1 0 
""}}{COM_R 74 0{TEXT 1 92 "This integral diverges.  On the other \+
hand, if u>0 we get convergence and a symbolic answer."}}{COM_R 
75 0{TEXT 1 0 ""}}{INP_R 76 0 "> "{TEXT 0 34 "assume(u>0);int(f8,
x=0..infinity);"}}{OUT_R 77 0 76{DAG +9*7n3\`u~~`/3i2x0003j2x0002
n3\`Pi`/3j2x0001p7(3n3\`ln`,2p2pC/3i2x0001p7*5p2p4p9pBpC*7p2p4p9p
Bn4\`gamma`pCp15*7p2p4p9pB(3p10,2p7pCp16}}{COM_R 78 0{TEXT 1 0 ""
}}{COM_R 79 0{TEXT 1 312 "Of course, there are functions whose in
tegrals cannot be represented in terms of elementary functions.  \+
Even then, Maple knows about some special functions that are defi
ned in terms of integrals, and can recognize integrands based on \+
the derivatives of these functions.  A famous example of this is \+
Gauss's error"}}{COM_R 80 0{TEXT 1 9 "function."}}{COM_R 81 0
{TEXT 1 0 ""}}{INP_R 82 0 "> "{TEXT 0 16 "f8 := exp(-x^2);"}}
{OUT_R 83 0 82{DAG :3n3\`f8`(3n3\`exp`,2+3*3n3\`x`j2x0002i2x0001}
}{INP_R 84 0 "> "{TEXT 0 10 "int(f8,x);"}}{OUT_R 85 0 84{DAG +3*5
n3\`Pi`/3j2x0001j2x0002(3n3\`erf`,2n3\`x`p5p4}}{COM_R 86 0{TEXT 1
 95 "Maple can even get the answer right when these functions are
 hidden in more complex integrands."}}{COM_R 87 0{TEXT 1 0 ""}}
{INP_R 88 0 "> "{TEXT 0 21 "f9 := sqrt(x)/exp(x);"}}{OUT_R 89 0 
88{DAG :3n3\`f9`*5n3\`x`/3j2x0001j2x0002(3n3\`exp`,2p4i2x0001}}
{INP_R 90 0 "> "{TEXT 0 10 "int(f9,x);"}}{OUT_R 91 0 90{DAG +5*5n
3\`x`/3j2x0001j2x0002(3n3\`exp`,2p2i2x0001pE*5n3\`Pi`p4(3n3\`erf`
,2*3p2p4p5p4}}{COM_R 92 0{TEXT 1 0 ""}}{COM_R 93 0{TEXT 1 172 "Ev
entually, we can find integrands that will stump Maple.  When thi
s happens, there are several alternatives to get a numeric answer
.  One approach is to generate a series."}}{COM_R 94 0{TEXT 1 0 "
"}}{INP_R 95 0 "> "{TEXT 0 16 "f10 := exp(t^3);"}}{OUT_R 96 0 95
{DAG :3n3\`f10`(3n3\`exp`,2*3n3\`t`j2x0003}}{INP_R 97 0 "> "{TEXT
 0 16 "int(f10,t=0..x);"}}{OUT_R 98 0 97{DAG (3n3\`int`,3(3n3\`ex
p`,2*3n3\`t`j2x0003=3p9~3j2x0000n3\`x`}}{INP_R 99 0 "> "{TEXT 0 
34 "r10:=series(int(f10,t=0..x),x,10);"}}{OUT_R 100 0 99{DAG :3n3
\`r10`_An3\`x`j2x0001x1/3p6j2x0004x4/3p6j2x0014x7(3n3\`O`,2p6xA}}
{COM_R 101 0{TEXT 1 0 ""}}{COM_R 102 0{TEXT 1 119 "Maple's answer
 is in the form of a series data structure.  We can turn this int
o a polynomial function for computation."}}{COM_R 103 0{TEXT 1 0 
""}}{INP_R 104 0 "> "{TEXT 0 37 "p10:=unapply(convert(r10,polynom
),x);"}}{OUT_R 105 0 104{DAG :3n3\`p10`@8,2n3\`x`,1,3n5\`operator
`n4\`arrow`p7+7a2x0001j2x0001*3p12j2x0004/3p14p18*3p12j2x0007/3p1
4j2x0014p7p7}}{INP_R 106 0 "> "{TEXT 0 14 "evalf(p10(1));"}}
{OUT_R 107 0 106{DAG e3j4x001321428571i2x0009}}{COM_R 108 0{TEXT 
1 0 ""}}{COM_R 109 0{TEXT 1 137 "Unless we wanted to investigate \+
the coefficients of  the series,  there is a short cut for evalua
tion of a definite integral using evalf."}}{COM_R 110 0{TEXT 1 0 
""}}{INP_R 111 0 "> "{TEXT 0 23 "evalf(int(f10,t=0..1));"}}{OUT_R
 112 0 111{DAG e3j4x001341904418i2x0009}}{COM_R 113 0{TEXT 1 0 ""
}}{COM_R 114 0{TEXT 1 181 "Another advantage of evalf is that the
 answer is correct up to the last digit.  Using a series solution
,  further analysis would be required to determine the accuracy o
f the answer."}}{COM_R 115 0{TEXT 1 0 ""}}{COM_R 116 0{TEXT 1 243
 "Evalf also takes advantage of Maple's symbolic power.  This nex
t example cannot be integrated using numerical techniques alone a
s the integrand has a singularity at 0.  It cannot be integrated \+
symbolically as there is not closed form solution."}}{COM_R 117 0
{TEXT 1 1 " "}}{INP_R 118 0 "> "{TEXT 0 24 "f11:=cos(x)/sqrt(x+x^
2);"}}{OUT_R 119 0 118{DAG :3n3\`f11`*5(3n3\`cos`,2n3\`x`j2x0001+
5p8pA*3p8j2x0002pA/3i2x0001p11}}{INP_R 120 0 "> "{TEXT 0 28 "r11:
=int(f11,x=0..infinity);"}}{OUT_R 121 0 120{DAG :3n3\`r11`(3n3\`i
nt`,3*5(3n3\`cos`,2n3\`x`j2x0001+5pCpE*3pCj2x0002pE/3i2x0001p15=3
pC~3j2x0000n5\`infinity`}}{INP_R 122 0 "> "{TEXT 0 11 "evalf(r11)
;"}}{OUT_R 123 0 122{DAG e3j4x001319513339i2x0009}}{COM_R 124 0
{TEXT 1 0 ""}}{COM_R 125 0{TEXT 1 89 "Maple is also capable of co
mputing improper integrals - often symbolically.  For example:"}}
{COM_R 126 0{TEXT 1 0 ""}}{INP_R 127 0 "> "{TEXT 0 40 "Int( exp(-
t^2), t=-infinity..infinity );"}}{OUT_R 128 0 127{DAG (3n3\`Int`,
3(3n3\`exp`,2+3*3n3\`t`j2x0002i2x0001=3pA~3+3n5\`infinity`pEp14}}
{INP_R 129 0 "> "{TEXT 0 9 "value(\");"}}{OUT_R 130 0 129{DAG *3n
3\`Pi`/3j2x0001j2x0002}}{INP_R 131 0 "> "{TEXT 0 44 "Int( exp(-t^
2)*t^2, t=-infinity..infinity );"}}{OUT_R 132 0 131{DAG (3n3\`Int
`,3*5(3n3\`exp`,2+3*3n3\`t`j2x0002i2x0001j2x0001pBpD=3pB~3+3n5\`i
nfinity`pFp19}}{INP_R 133 0 "> "{TEXT 0 9 "value(\");"}}{OUT_R 
134 0 133{DAG +3*3n3\`Pi`/3j2x0001j2x0002p4}}{INP_R 135 0 "> "
{TEXT 0 36 "Int(exp(-t)/t^(1/3), t=0..infinity);"}}{OUT_R 136 0 
135{DAG (3n3\`Int`,3*5(3n3\`exp`,2+3n3\`t`i2x0001j2x0001pA/3pCj2x
0003=3pA~3j2x0000n5\`infinity`}}{INP_R 137 0 "> "{TEXT 0 9 "value
(\");"}}{OUT_R 138 0 137{DAG (3n4\`GAMMA`,2/3j2x0002j2x0003}}
{COM_R 139 0{TEXT 1 122 "\015This is the generalized factorial fu
nction.  Maple recognized that the integrand matched that of the \+
definition of gamma:"}}{OUT_R 140 0 0{DAG =3(3n4\`Gamma`,2n3\`n`(
3n3\`Int`,3*5^3n3\`e`n3\`x`j2x0001^3p10+5p6p12i2x0001p12p12=3p10~
3j2x0000n5\`infinity`}}{INP_R 141 0 "> "{TEXT 0 33 "Int(exp(-t)*l
n(t),t=0..infinity);"}}{OUT_R 142 0 141{DAG (3n3\`Int`,3*5(3n3\`e
xp`,2+3n3\`t`i2x0001j2x0001(3n3\`ln`,2pApE=3pA~3j2x0000n5\`infini
ty`}}{INP_R 143 0 "> "{TEXT 0 9 "value(\");"}}{OUT_R 144 0 143
{DAG +3n4\`gamma`i2x0001}}{COM_R 145 0{TEXT 1 0 ""}}{COM_R 146 0
{TEXT 1 32 "Here, gamma is Euler's constant:"}}{OUT_R 147 0 0{DAG
 (3n4\`Limit`,3+5(3n3\`Sum`,3*3n3\`i`i2x0001=3pB~3j2x0001n3\`n`p1
2(3n3\`ln`,2p14pD=3p14n5\`infinity`}}{INP_R 148 0 "> "{TEXT 0 39 
"Int(exp(-t^2)*sin(t^2),t=0..infinity );"}}{OUT_R 149 0 148{DAG (
3n3\`Int`,3*5(3n3\`exp`,2+3*3n3\`t`j2x0002i2x0001j2x0001(3n3\`sin
`,2pAp11=3pB~3j2x0000n5\`infinity`}}{INP_R 150 0 "> "{TEXT 0 9 "v
alue(\");"}}{OUT_R 151 0 150{DAG +3*7j2x0002/3j2x0003j2x0004+5p2j
2x0001*3p2/3pBp2i2x0001pFn3\`Pi`pF/3pBj2x0008}}{INP_R 152 0 "> "
{TEXT 0 37 "Int(exp(-t)*ln(t)/t^2,t=1..infinity);"}}{OUT_R 153 0 
152{DAG (3n3\`Int`,3*7(3n3\`exp`,2+3n3\`t`i2x0001j2x0001(3n3\`ln`
,2pApEpAi2x0002=3pA~3pEn5\`infinity`}}{INP_R 154 0 "> "{TEXT 0 9 
"value(\");"}}{OUT_R 155 0 154{DAG (3n4\`MeijerG`,4j2x0003i2x0001
j2x0001}}{COM_R 156 0{TEXT 1 0 ""}}{COM_R 157 0{TEXT 1 64 "Meijer
G is another of the many special functions known to Maple."}}
{COM_R 158 0{TEXT 1 0 ""}}{COM_R 159 0{TEXT 1 0 ""}}{COM_R 160 0
{TEXT 1 111 "Maple can also calculate integrals symbolically  usi
ng a representation involving of the roots of a polynomial:"}}
{COM_R 161 0{TEXT 1 0 ""}}{INP_R 162 0 "> "{TEXT 0 26 "f18:=Int(x
/(x^3-x^2+1),x);"}}{OUT_R 163 0 162{DAG :3n3\`f18`(3n3\`Int`,3*5n
3\`x`j2x0001+7*3p8j2x0003pA*3p8j2x0002i2x0001pApAp16p8}}{INP_R 
164 0 "> "{TEXT 0 9 "value(\");"}}{OUT_R 165 0 164{DAG (3n3\`sum`
,3*5n3\`_R`j2x0001(3n3\`ln`,2+7n3\`x`p7*3p5j2x0002/3j2x0023j2x000
3/3p7p18p7p7=3p5(3n4\`RootOf`,2+7*3n3\`_Z`p18p16p28p18p7p7}}
{COM_R 166 0{TEXT 1 0 ""}}{COM_R 167 0{TEXT 1 49 "Here, the sum i
s over all roots of the polynomial"}}{OUT_R 168 0 0{DAG +7*3n3\`x
`j2x0002j2x0023p2j2x0003j2x0001pB}}{COM_R 169 0{TEXT 1 55 "We can
 also compute definite integrals in this fashion."}}{COM_R 170 0
{TEXT 1 0 ""}}{INP_R 171 0 "> "{TEXT 0 32 "r18:=Int(x/(x^3-x^2+1)
, x=0..1);"}}{OUT_R 172 0 171{DAG :3n3\`r18`(3n3\`Int`,3*5n3\`x`j
2x0001+7*3p8j2x0003pA*3p8j2x0002i2x0001pApAp16=3p8~3j2x0000pA}}
{INP_R 173 0 "> "{TEXT 0 9 "value(\");"}}{OUT_R 174 0 173{DAG +5(
3n3\`sum`,3*5n3\`_R`j2x0001(3n3\`ln`,2+5/3j2x0004j2x0003p8*3p6j2x
0002/3j2x0023p12p8=3p6(3n4\`RootOf`,2+7*3n3\`_Z`p12p1Ap27p12p8p8p
8(3p2,3*5p6p8(3pB,2+5p15p19/3p8p12p8p8p1Ei2x0001}}{INP_R 175 0 ">
 "{TEXT 0 11 "evalf(r18);"}}{OUT_R 176 0 175{DAG e3j4x00556825462
9i2x0010}}{COM_R 177 0{TEXT 1 0 ""}}{COM_R 178 0{TEXT 1 111 "Mapl
e knows about some integral transformations - Mellin transforms, \+
Fourier transforms and Laplace transforms."}}{COM_R 179 0{TEXT 1 
0 ""}}{INP_R 180 0 "> "{TEXT 0 17 "readlib(fourier):"}}{INP_R 181
 0 "> "{TEXT 0 14 "eq19:=x^3-3*x;"}}{OUT_R 182 0 181{DAG :3n4\`eq
19`+5*3n3\`x`j2x0003j2x0001p6i2x0003}}{INP_R 183 0 "> "{TEXT 0 18
 "fourier(eq19,x,t);"}}{OUT_R 184 0 183{DAG +5*7n3\`I`j2x0001n3\`
Pi`p4(3n4\`Dirac`,3p4n3\`t`p4i2x0006*7p2p4p6p4(3pA,3j2x0003pFp4i2
x0002}}{INP_R 185 0 "> "{TEXT 0 28 "eq20:=t^3*exp(a*t)*cos(b*t);"
}}{OUT_R 186 0 185{DAG :3n4\`eq20`*7n3\`t`j2x0003(3n3\`exp`,2*5n3
\`a`j2x0001p5p10p10(3n3\`cos`,2*5n3\`b`p10p5p10p10}}{INP_R 187 0 
"> "{TEXT 0 18 "laplace(eq20,t,p);"}}{OUT_R 188 0 187{DAG +9*5+5*
3+5n3\`p`j2x0001n3\`a`i2x0001j2x0002p7*3n3\`b`pDp7i2x0003+5p5pDp9
i2x0002pDi2x0006*3p2p1Bj2x0006*7p4p7p2i2x0004p17j2x0003p23*7p4p7p
2p15p17p7i2x0012}}{INP_R 189 0 "> "{TEXT 0 0 ""}}}{END}
