{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 8 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "
Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 9 "-adobe-times-bold-r-
normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bo
ld" 14}{FONT 10 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "
times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 11 "-adobe-time
s-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 
"Times-Bold" 14}{FONT 12 "-adobe-times-bold-r-normal--*-140-*-*-*
-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 13 "-a
dobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold"
 8 14 64 "Times-Bold" 14}{FONT 14 "-adobe-times-bold-r-normal--*-
140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 15 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" 
"Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 16 "-adobe-times-bold-
r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-
Bold" 14}{FONT 17 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*"
 "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 18 "-adobe-ti
mes-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 
64 "Times-Bold" 14}{SCP_R 1 0 97{COM_R 2 0{TEXT 1 0 ""}}{COM_R 3 
0{TEXT 8 49 "Introduction to Maple - a Computer Algebra System"}}
{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}{COM_R 6 0{TEXT 1
 177 "As a demonstration of Maple's numeric power, let's compute \+
100 factorial.   Maple does not have an upper bound on the number
 of digits in an integer, so Maple's answer is exact."}}{COM_R 7 
0{TEXT 1 0 ""}}{INP_R 8 0 "> "{TEXT 0 10 "big:=100!;"}}{OUT_R 9 0
 8{DAG :3n3\`big`j29x00933262154439441526816992388562667004907159
68264381621468592963895217599993229915608941463976156518286253697
920827223758251185210916864000000000000000000000000}}{COM_R 10 0
{TEXT 1 0 ""}}{COM_R 11 0{TEXT 1 135 "Perhaps more impressive  is
 Maple's ability to manipulate mathematical objects.  For example
, we can quickly factor this large integer."}}{COM_R 12 0{TEXT 1 
1 " "}}{INP_R 13 0 "> "{TEXT 0 13 "ifactor(big);"}}{OUT_R 14 0 13
{DAG *33(3n3\``,2j2x0002j2x0097(3p2,2j2x0003j2x0048(3p2,2j2x0005j
2x0024(3p2,2j2x0007j2x0016(3p2,2j2x0011j2x0009(3p2,2j2x0013p1A(3p
2,2j2x0017p13(3p2,2j2x0019p13(3p2,2j2x0023j2x0004(3p2,2j2x0029pC(
3p2,2j2x0031pC(3p2,2j2x0037p5(3p2,2j2x0041p5(3p2,2j2x0043p5(3p2,2
j2x0047p5(3p2,2j2x0053j2x0001(3p2,2j2x0059p67(3p2,2j2x0061p67(3p2
,2j2x0067p67(3p2,2j2x0071p67(3p2,2j2x0073p67(3p2,2j2x0079p67(3p2,
2j2x0083p67(3p2,2j2x0089p67(3p2,2p7p67}}{COM_R 15 0{TEXT 1 0 ""}}
{COM_R 16 0{TEXT 1 83 "Another example of Maple's integer arithme
tic capability is its knowledge of GCD's."}}{COM_R 17 0{TEXT 1 0 
""}}{INP_R 18 0 "> "{TEXT 0 20 "igcd(3^500,5^300-1);"}}{OUT_R 19 
0 18{DAG j2x0009}}{COM_R 20 0{TEXT 1 0 ""}}{COM_R 21 0{TEXT 1 143
 "Maple can also do floating point calculations to arbitrary prec
ision. Let's get a floating point approximation of Pi to 100 digi
ts of accuracy:"}}{COM_R 22 0{TEXT 1 0 ""}}{INP_R 23 0 "> "{TEXT 
0 14 "evalf(Pi,100);"}}{OUT_R 24 0 23{DAG e3j1Ax31415926535897932
38462643383279502884197169399375105820974944592307816406286208998
628034825342117068i2x0099}}{COM_R 25 0{TEXT 1 0 ""}}{COM_R 26 0
{TEXT 1 128 "Maple's true power, however,  lies in its ability to
 do symbolic mathematics. To show Maple's strength,  let's comput
e this sum:"}}{OUT_R 27 0 0{DAG (3n3\`Sum`,3*3n3\`i`j2x0020=3p5~3
j2x0001n3\`n`}}{INP_R 28 0 "> "{TEXT 0 17 "sum(i^20,i=1..n);"}}
{OUT_R 29 0 28{DAG +1B*3+5n3\`n`j2x0001p5p5j2x0021/3p5p9*3p2j2x00
20/3i2x0001j2x0002*3p2j2x0019/3j2x0005j2x0003*3p2j2x0017/3i2x0019
p15*3p2j2x0015/3j2x1292p9*3p2j2x0013i2x0323*3p2j2x0011/3j3x000419
90j2x0033*3p2j2x0009/3i3x00223193j2x0063*3p2j2x0007j2x6460*3p2p1C
/3i3x00068723j2x0010*3p2p1E/3j3x00219335p48p3/3i3x00174611j2x0330
p62p5}}{INP_R 30 0 "> "{TEXT 0 12 "simplify(\");"}}{OUT_R 31 0 30
{DAG +19*3n3\`n`j2x0003/3j3x00219335j2x0063*3p2j2x0005/3i3x000687
23j2x0010*3p2j2x0007j2x6460*3p2j2x0009/3i3x00223193pA*3p2j2x0011/
3j3x00041990j2x0033*3p2j2x0013i2x0323*3p2j2x0015/3j2x1292j2x0021*
3p2j2x0017/3i2x0019j2x0002*3p2j2x0019/3pEp4*3p2j2x0020/3j2x0001p4
5*3p2p3C/3p53p3Cp2/3i3x00174611j2x0330}}{INP_R 32 0 "> "{TEXT 0 
10 "factor(\");"}}{OUT_R 33 0 32{DAG +3*9n3\`n`j2x0001+5p2j2x0002
p4p4p4+5p2p4p4p4p4+27*3p2j2x0018j2x0165*3p2j2x0017j2x1485*3p2j2x0
016j2x3465*3p2j2x0015i2x5940*3p2j2x0014i3x00025740*3p2j2x0013j3x0
0041580*3p2j2x0012j3x00163680*3p2j2x0011i3x00266310*3p2j2x0010i3x
00801570*3p2j2x0009j3x01335510*3p2j2x0008j3x02806470*3p2j2x0007i3
x04877460*3p2j2x0006i3x06362660*3p2j2x0005j3x11982720*3p2j2x0004j
3x07591150*3p2j2x0003i3x17378085*3p2p8i3x01540967p2j3x11000493i3x
03666831p4p4/3p4j2x6930}}{COM_R 34 0{TEXT 1 0 ""}}{COM_R 35 0
{TEXT 1 170 "Since n was an unassigned, or symbolic, variable the
 symbolic answer is a formula in n.\012\012\012Maple even underst
ands how to work with infinity.  For example, we can compute:\012
"}}{OUT_R 36 0 0{DAG (3n3\`Sum`,3*3n3\`i`i2x0003=3p5~3j2x0001n5\`
infinity`}}{INP_R 37 0 "> "{TEXT 0 26 " sum(1/i^3,i=1..infinity);
"}}{OUT_R 38 0 37{DAG (3n4\`Zeta`,2j2x0003}}{COM_R 39 0{TEXT 1 0 
""}}{COM_R 40 0{TEXT 1 272 "Maple deduced an  answer in terms of \+
the well known Riemann Zeta function from mathematical analysis. \+
Maple's library of over 2,000 math routines encapsulate a large b
ody of mathematical knowledge.  This example also demonstrates Ma
ple's ability to print Greek characters."}}{COM_R 41 0{TEXT 1 0 "
"}}{COM_R 42 0{TEXT 1 149 "To get an idea of the magnitude of tha
t last answer (which is an exact answer without roundoff errors),
 let's ask for a floating point approximation:"}}{COM_R 43 0{TEXT
 1 0 ""}}{INP_R 44 0 "> "{TEXT 0 9 "evalf(\");"}}{OUT_R 45 0 44
{DAG e3j4x001202056903i2x0009}}{COM_R 46 0{TEXT 1 0 ""}}{COM_R 47
 0{TEXT 1 143 "Evalf evaluates an expression with 10 digits of ac
curacy by default, though any amount of precision can be specifie
d, like the example with Pi."}}{COM_R 48 0{TEXT 1 0 ""}}{COM_R 49
 0{TEXT 1 0 ""}}{COM_R 50 0{TEXT 1 123 "Maple can solve many solv
e many problems in differential and integral calculus.  Here is a
n indefinite integration problem:"}}{OUT_R 51 0 0{DAG (3n3\`Int`,
3*3+5(3n3\`exp`,2n3\`x`j2x0001pCpCi2x0001pA}}{INP_R 52 0 "> "
{TEXT 0 22 "f := 1 / (exp(x) + 1);"}}{OUT_R 53 0 52{DAG :3n3\`f`*
3+5(3n3\`exp`,2n3\`x`j2x0001pBpBi2x0001}}{INP_R 54 0 "> "{TEXT 0 
9 "int(f,x);"}}{OUT_R 55 0 54{DAG +5(3n3\`ln`,2+5(3n3\`exp`,2n3\`
x`j2x0001pCpCi2x0001(3p2,2p6pC}}{COM_R 56 0{TEXT 1 0 ""}}{COM_R 
57 0{TEXT 1 192 "This is a much  harder problem that would be ted
ious to compute by hand, even using integral tables. The output o
f the intermediate steps has been suppressed to make the example \+
more readable."}}{COM_R 58 0{TEXT 1 0 ""}}{INP_R 59 0 "> "{TEXT 0
 132 "Int(x*(x+1)*((x^2*exp(x^2)^2-ln(x+1)^2)^2+2*x*exp(x^2)^3*(x
-(2*x^3+2*x^2+x+1)*ln(x+1)))/((x+1)*ln(x+1)^2-(x^3+x^2)*exp(x^2)^
2)^2,x);"}}{OUT_R 60 0 0{DAG (3n3\`Int`,3*9n3\`x`j2x0001+5p5p7p7p
7p7+5*3+5*5p5j2x0002(3n3\`exp`,2*3p5p14p14p7*3(3n3\`ln`,2p9p14i2x
0001p14p7*7p5p7p16j2x0003+5p5p7*5+9*3p5p2Ep14p1Ap14p5p7p7p7p7p20p
7p26p7p14p7+5*5p9p7p20p14p7*5+5p35p7p1Ap7p7p16p14p26i2x0002p5}}
{COM_R 61 0{TEXT 1 0 ""}}{INP_R 62 0 "> "{TEXT 0 9 "value(\");"}}
{OUT_R 63 0 62{DAG +Bn3\`x`j2x0001(3n3\`ln`,2+5p1p3p3p3i2x0001*9p
1p3(3n3\`exp`,2*3p1j2x0002p3p5p3+5*5p1p19p13p19p3*3p5p19pEpEp3(3p
6,2+5p5p3*5p1p3p13p3pE/3pEp19(3p6,2+5p5p3p31p3/3p3p19}}{COM_R 64 
0{TEXT 1 0 ""}}{COM_R 65 0{TEXT 1 89 "Not all integration problem
s have a closed form solution.  For example, this one doesn't:"}}
{COM_R 66 0{TEXT 1 0 ""}}{INP_R 67 0 "> "{TEXT 0 45 "r1 := int( e
xp(-t) / sqrt(1-t^2),t = -1..1 );"}}{OUT_R 68 0 67{DAG :3n3\`r1`(
3n3\`int`,3*5(3n3\`exp`,2+3n3\`t`i2x0001j2x0001+5p11p11*3pDj2x000
2pF/3pFp18=3pD~3pFp11}}{COM_R 69 0{TEXT 1 0 ""}}{COM_R 70 0{TEXT 
1 119 "When a symbolic solution doesn't exist, we can have Maple \+
use numeric techniques to get a numeric approximate solution:"}}
{COM_R 71 0{TEXT 1 0 ""}}{INP_R 72 0 "> "{TEXT 0 10 "evalf(r1);"}
}{OUT_R 73 0 72{DAG e3j4x003977463261i2x0009}}{COM_R 74 0{TEXT 1 
0 ""}}{COM_R 75 0{TEXT 1 212 "Maple provides graphics output as w
ell as symbolic and numeric results.  Here's an illustration of h
ow graphics can be used to show how well Taylor series can approx
imate a function around the point of expansion."}}{COM_R 76 0
{TEXT 1 0 ""}}{COM_R 77 0{TEXT 1 84 "Let's compute a Taylor serie
s approximation for the sine function to order 6 at x=0:"}}{COM_R
 78 0{TEXT 1 0 ""}}{INP_R 79 0 "> "{TEXT 0 35 "approx := taylor( \+
sin(x), x=0, 6 );"}}{OUT_R 80 0 79{DAG :3n4\`approx`_An3\`x`j2x00
01x1/3i2x0001j2x0006x3/3p7j2x0120x5(3n3\`O`,2p7x6}}{COM_R 81 0
{TEXT 1 133 "Notice the approximation term in the series answer. \+
 Now let's convert it into a straight  polynomial without the app
roximation term:"}}{COM_R 82 0{TEXT 1 0 ""}}{INP_R 83 0 "> "{TEXT
 0 35 "poly := convert( approx, polynom );"}}{OUT_R 84 0 83{DAG :
3n4\`poly`+7n3\`x`j2x0001*3p5j2x0003/3i2x0001j2x0006*3p5j2x0005/3
p7j2x0120}}{COM_R 85 0{TEXT 1 0 ""}}{COM_R 86 0{TEXT 1 150 "Final
ly, let's plot the sine function along with the polynomial approx
imation.  Put the cursor on the next line and press <RETURN> to g
enerate a plot."}}{COM_R 87 0{TEXT 1 0 ""}}{INP_R 88 0 "> "{TEXT 
0 90 " plot( \{ sin(x), poly \}, x=0..4,title=`Sin(x) and Taylor \+
Series Approximation (order 6)`);"}}{COM_R 89 0{TEXT 1 0 ""}}
{COM_R 90 0{TEXT 1 165 "We can get a qualitative feel for how muc
h better the approximation is with a series of higher order by re
computing the series with order 10 and making another plot."}}
{COM_R 91 0{TEXT 1 0 ""}}{INP_R 92 0 "> "{TEXT 0 51 "poly2 := con
vert(taylor( sin(x), x=0, 10),polynom);"}}{OUT_R 93 0 92{DAG :3n4
\`poly2`+Bn3\`x`j2x0001*3p5j2x0003/3i2x0001j2x0006*3p5j2x0005/3p7
j2x0120*3p5j2x0007/3pEj2x5040*3p5j2x0009/3p7j3x00362880}}{COM_R 
94 0{TEXT 1 0 ""}}{COM_R 95 0{TEXT 1 125 "Again, place the cursor
 on the next line and press return to generate a plot. Notice the
 good approximation up to Pi radians."}}{COM_R 96 0{TEXT 1 0 ""}}
{INP_R 97 0 "> "{TEXT 0 92 "plot( \{ sin(x), poly2 \}, x=0..4, ti
tle=`Sin(x) and Taylor Series Approximation (order 10)`);"}}
{INP_R 98 0 "> "{TEXT 0 0 ""}}}{END}
