{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 8 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "
Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 9 "-adobe-times-bold-r-
normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bo
ld" 14}{SCP_R 1 0 180{COM_R 2 0{TEXT 1 0 ""}}{COM_R 3 0{TEXT 9 25
 "Linear Algebra with Maple"}}{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0
{TEXT 1 0 ""}}{COM_R 6 0{TEXT 1 271 "Maple has a library package \+
for linear algebra.  With it, we can compute eigenvalues and eige
nvectors, determinants of matrices, perform row and column operat
ions, and calculate many canonical forms of matrices.  Many of th
ese functions can be used on symbolic matrices. "}}{COM_R 7 0
{TEXT 1 1 " "}}{COM_R 8 0{TEXT 1 112 "To use the package we must \+
first read it in.  This also lists the names of the functions tha
t are now available."}}{COM_R 9 0{TEXT 1 0 ""}}{INP_R 10 0 "> "
{TEXT 0 13 "with(linalg);"}}{OUT_R 11 0 10{TEXT 2 71 "Warning: ne
w definition for   norm\012Warning: new definition for   trace\01
2"}}{OUT_R 12 0 10{DAG [2,6An6\`BlockDiagonal`n5\`GramSchmidt`n5\
`JordanBlock`n5\`Wronskian`n3\`add`n4\`addcol`n4\`addrow`n3\`adj`
n4\`adjoint`n4\`angle`n4\`augment`n4\`backsub`n4\`band`n4\`basis`
n4\`bezout`n5\`blockmatrix`n4\`charmat`n5\`charpoly`n3\`col`n4\`c
oldim`n5\`colspace`n4\`colspan`n5\`companion`n4\`concat`n4\`cond`
n5\`copyinto`n5\`crossprod`n4\`curl`n5\`definite`n4\`delcols`n4\`
delrows`n3\`det`n4\`diag`n4\`diverge`n4\`dotprod`n5\`eigenvals`n5
\`eigenvects`n5\`entermatrix`n4\`equal`n5\`exponential`n4\`extend
`n5\`ffgausselim`n5\`fibonacci`n5\`frobenius`n5\`gausselim`n5\`ga
ussjord`n5\`genmatrix`n4\`grad`n5\`hadamard`n4\`hermite`n4\`hessi
an`n4\`hilbert`n5\`htranspose`n5\`ihermite`n5\`indexfunc`n5\`inne
rprod`n5\`intbasis`n4\`inverse`n4\`ismith`n4\`iszero`n5\`jacobian
`n4\`jordan`n4\`kernel`n5\`laplacian`n5\`leastsqrs`n5\`linsolve`n
4\`matrix`n4\`minor`n4\`minpoly`n4\`mulcol`n4\`mulrow`n5\`multipl
y`n4\`norm`n5\`normalize`n5\`nullspace`n4\`orthog`n5\`permanent`n
4\`pivot`n5\`potential`n5\`randmatrix`n5\`randvector`n4\`rank`n4\
`ratform`n3\`row`n4\`rowdim`n5\`rowspace`n4\`rowspan`n4\`rref`n5\
`scalarmul`n6\`singularvals`n4\`smith`n4\`stack`n5\`submatrix`n5\
`subvector`n5\`sumbasis`n4\`swapcol`n4\`swaprow`n5\`sylvester`n5\
`toeplitz`n4\`trace`n5\`transpose`n5\`vandermonde`n5\`vecpotent`n
4\`vectdim`n4\`vector`}}{COM_R 13 0{TEXT 1 0 ""}}{COM_R 14 0{TEXT
 1 144 "Maple uses its array structure for matrices and vectors. \+
 The linalg package contains a couple of shortcut functions for c
reating these objects."}}{COM_R 15 0{TEXT 1 0 ""}}{INP_R 16 0 "> \+
"{TEXT 0 33 "a:=vector([2,sin(x),4,5.3,beta]);"}}{OUT_R 17 0 16
{DAG :3n3\`a`(3n4\`VECTOR`,2[2,6j2x0002(3n3\`sin`,2n3\`x`j2x0004e
3j2x0053i2x0001n4\`beta`}}{INP_R 18 0 "> "{TEXT 0 37 "A:=matrix([
[1,x,y],[0,1,z],[0,0,1]]);"}}{OUT_R 19 0 18{DAG :3n3\`A`(3n4\`MAT
RIX`,2[2,4[2,4j2x0001n3\`x`n3\`y`[2,4j2x0000pCn3\`z`[2,4p14p14pC}
}{COM_R 20 0{TEXT 1 0 ""}}{COM_R 21 0{TEXT 1 140 "Maple uses its \+
&* operator to denote non-commutative matrix multiplication.  We \+
must use the function evalm to evaluate a matrix expression."}}
{COM_R 22 0{TEXT 1 0 ""}}{INP_R 23 0 "> "{TEXT 0 12 "evalm(A&*A);
"}}{OUT_R 24 0 23{DAG (3n4\`MATRIX`,2[2,4[2,4j2x0001+3n3\`x`j2x00
02+5n3\`y`pE*5pCp9n3\`z`p9p9[2,4j2x0000p9+3p17pE[2,4p1Dp1Dp9}}
{COM_R 25 0{TEXT 1 0 ""}}{COM_R 26 0{TEXT 1 59 "We could also hav
e used the exponent operator in this case."}}{COM_R 27 0{TEXT 1 0
 ""}}{INP_R 28 0 "> "{TEXT 0 11 "evalm(A^2);"}}{OUT_R 29 0 28{DAG
 (3n4\`MATRIX`,2[2,4[2,4j2x0001+3n3\`x`j2x0002+5n3\`y`pE*5pCp9n3\
`z`p9p9[2,4j2x0000p9+3p17pE[2,4p1Dp1Dp9}}{COM_R 30 0{TEXT 1 0 ""}
}{COM_R 31 0{TEXT 1 31 "Maple can compute determinants:"}}{COM_R 
32 0{TEXT 1 0 ""}}{INP_R 33 0 "> "{TEXT 0 7 "det(A);"}}{OUT_R 34 
0 33{DAG j2x0001}}{COM_R 35 0{TEXT 1 0 ""}}{COM_R 36 0{TEXT 1 124
 "This should have been obvious since A is upper diagonal with on
ly 1's on its diagonal.  We can try this on a harder problem:"}}
{COM_R 37 0{TEXT 1 0 ""}}{INP_R 38 0 "> "{TEXT 0 37 "B:=matrix([[
a,a,c],[b,5,f],[g,c,d]]);"}}{OUT_R 39 0 38{DAG :3n3\`B`(3n4\`MATR
IX`,2[2,4[2,4n3\`a`pCn3\`c`[2,4n3\`b`j2x0005n3\`f`[2,4n3\`g`pFn3\
`d`}}{INP_R 40 0 "> "{TEXT 0 7 "det(B);"}}{OUT_R 41 0 40{DAG +D*5
n3\`a`j2x0001n3\`d`p4j2x0005*7p2p4n3\`f`p4n3\`c`p4i2x0001*7n3\`b`
p4p2p4p6p4p14*5p17p4p11j2x0002p4*7n3\`g`p4p2p4pEp4p4*5p27p4p11p4i
2x0005}}{INP_R 42 0 "> "{TEXT 0 11 "inverse(A);"}}{OUT_R 43 0 42
{DAG (3n4\`MATRIX`,2[2,4[2,4j2x0001+3n3\`x`i2x0001+5*5pCp9n3\`z`p
9p9n3\`y`pE[2,4j2x0000p9+3p14pE[2,4p1Dp1Dp9}}{INP_R 44 0 "> "
{TEXT 0 11 "inverse(B);"}}{OUT_R 45 0 44{DAG (3n4\`MATRIX`,2[2,4[
2,4*5+5n3\`d`i2x0005*5n3\`f`j2x0001n3\`c`p12p12p12+D*5n3\`a`p12pB
p12pD*7p1Bp12p10p12p14p12p12*7n3\`b`p12p1Bp12pBp12p12*5p2Ap12p14j
2x0002i2x0001*7n3\`g`p12p1Bp12p10p12p38*5p3Bp12p14p12j2x0005p38*5
+5p1Ap12*3p14p36p38p12p19p38+3*5+5*5p1Bp12p10p12p12p14pDp12p19p38
p38[2,4+3*5+5*5p2Ap12pBp12p38*5p10p12p3Bp12p12p12p19p38p38+3*5+5p
1Ap12p43p38p12p19p38p38*5+5p59p12*5p2Ap12p14p12p38p12p19p38[2,4+3
*5+5p89p12p3BpDp12p19p38p38*7p1Bp12+5p14p12p3Bp38p12p19p38*7p1Bp1
2+5pDp12p2Ap12p12p19p38}}{COM_R 46 0{TEXT 1 0 ""}}{COM_R 47 0
{TEXT 1 87 "That last computation, of course, assumes that the de
terminant multinomial is non-zero."}}{COM_R 48 0{TEXT 1 0 ""}}
{COM_R 49 0{TEXT 1 46 "Maple even knows about the matrix exponent
ial:"}}{OUT_R 50 0 0{DAG ^3n3\`e`n3\`A`}}{COM_R 51 0{TEXT 1 96 "T
his is useful, for example, in the theory of systems of linear or
dinary differential equations."}}{COM_R 52 0{TEXT 1 0 ""}}{INP_R 
53 0 "> "{TEXT 0 15 "exponential(A);"}}{OUT_R 54 0 53{DAG (3n4\`M
ATRIX`,2[2,4[2,4(3n3\`exp`,2j2x0001*5n3\`x`pDp9pD+5*7p10pDn3\`z`p
Dp9pD/3pDj2x0002*5n3\`y`pDp9pDpD[2,4j2x0000p9*5p19pDp9pD[2,4p2Bp2
Bp9}}{COM_R 55 0{TEXT 1 0 ""}}{COM_R 56 0{TEXT 1 134 "A critical \+
computation when working with linear operators is determining eig
envalues and eigenvectors.  Maple has a facility for this."}}
{COM_R 57 0{TEXT 1 0 ""}}{INP_R 58 0 "> "{TEXT 0 25 "C:=matrix([[
2,3],[4,5]]);"}}{OUT_R 59 0 58{DAG :3n3\`C`(3n4\`MATRIX`,2[2,3[2,
3j2x0002j2x0003[2,3j2x0004j2x0005}}{COM_R 60 0{TEXT 1 0 ""}}
{COM_R 61 0{TEXT 1 45 "First, lets compute the eigenvalues by han
d. "}}{COM_R 62 0{TEXT 1 0 ""}}{INP_R 63 0 "> "{TEXT 0 45 "F:=eva
lm(C-lambda*array(identity,1..2,1..2));"}}{OUT_R 64 0 63{DAG :3n3
\`F`(3n4\`MATRIX`,2[2,3[2,3+5j2x0002j2x0001n4\`lambda`i2x0001j2x0
003[2,3j2x0004+5j2x0005pFp11p14}}{INP_R 65 0 "> "{TEXT 0 12 "eq1:
=det(F);"}}{OUT_R 66 0 65{DAG :3n3\`eq1`+7i2x0002j2x0001n4\`lambd
a`i2x0007*3p8j2x0002p6}}{COM_R 67 0{TEXT 1 0 ""}}{COM_R 68 0{TEXT
 1 72 "This is the characteristic polynomial.  Now we can solve f
or the roots. "}}{COM_R 69 0{TEXT 1 0 ""}}{INP_R 70 0 "> "{TEXT 0
 26 "egv:=solve(det(F),lambda);"}}{OUT_R 71 0 70{DAG :3n3\`egv`,3
+5/3j2x0007j2x0002j2x0001*3j2x0057/3pAp8pF+5p5pApC/3i2x0001p8}}
{COM_R 72 0{TEXT 1 0 ""}}{COM_R 73 0{TEXT 1 63 "We can do a quick
 verification of the Cayley-Hamilton  theorem."}}{COM_R 74 0{TEXT
 1 0 ""}}{INP_R 75 0 "> "{TEXT 0 26 "evalm(subs(lambda=C,eq1));"}
}{OUT_R 76 0 75{DAG (3n4\`MATRIX`,2[2,3[2,3j2x0000p9p7}}{COM_R 77
 0{TEXT 1 0 ""}}{COM_R 78 0{TEXT 1 100 "We can also compute the e
igenvectors for an eigendirection by finding the null space of th
e operator"}}{OUT_R 79 0 0{DAG +5n3\`C`j2x0001*5n3\`I`p3n4\`lambd
a`p3i2x0001}}{COM_R 80 0{TEXT 1 89 "for a specific value for lamb
da.  nullspace returns a basis for the kernel of the matrix."}}
{COM_R 81 0{TEXT 1 0 ""}}{INP_R 82 0 "> "{TEXT 0 40 "nullspace(su
bs(lambda=egv[1],evalm(F)));"}}{OUT_R 83 0 82{DAG %2,2(3n4\`VECTO
R`,2[2,3+5/3i2x0003j2x0008j2x0001*3j2x0057/3pFj2x0002/3pFpDpF}}
{COM_R 84 0{TEXT 1 0 ""}}{COM_R 85 0{TEXT 1 109 "Maple has a sing
le command to computes the eigenvalues, and another to compute th
e characteristic polynomial."}}{COM_R 86 0{TEXT 1 0 ""}}{INP_R 87
 0 "> "{TEXT 0 13 "eigenvals(C);"}}{OUT_R 88 0 87{DAG ,3+5/3j2x00
07j2x0002j2x0001*3j2x0057/3p7p5pC+5p2p7p9/3i2x0001p5}}{INP_R 89 0
 "> "{TEXT 0 19 "charpoly(C,lambda);"}}{OUT_R 90 0 89{DAG +7i2x00
02j2x0001n4\`lambda`i2x0007*3p5j2x0002p3}}{INP_R 91 0 "> "{TEXT 0
 24 "eigenvects(C,'radical');"}}{OUT_R 92 0 91{DAG ,3[2,4+5/3j2x0
007j2x0002j2x0001*3j2x0057/3p9p7pEp9%2,2(3n4\`VECTOR`,2[2,3p9+5pE
p9pB/3p9j2x0006[2,4+5p4p9pB/3i2x0001p7p9%2,2(3p16,2[2,3p9+5pEp9pB
/3p2Cp23}}{COM_R 93 0{TEXT 1 0 ""}}{COM_R 94 0{TEXT 1 228 "Each l
ist in this sequence contains an eigenvalue, an algebraic multipl
icity, and an eigendirection. We specified the radical option her
e to make Maple list each eigenvector separately, rather than usi
ng Maple's RootOf notation:"}}{COM_R 95 0{TEXT 1 0 ""}}{INP_R 96 
0 "> "{TEXT 0 14 "eigenvects(C);"}}{OUT_R 97 0 96{DAG [2,4(3n4\`R
ootOf`,2+7*3n3\`_Z`j2x0002j2x0001p9i2x0007i2x0002pDpD%2,2(3n4\`VE
CTOR`,2[2,3+5p2/3pDj2x0004/3i2x0005p23pDpD}}{COM_R 98 0{TEXT 1 0 
""}}{COM_R 99 0{TEXT 1 50 "Maple can reduce matrices to many cano
nical forms."}}{COM_R 100 0{TEXT 1 0 ""}}{COM_R 101 0{TEXT 1 44 "
First, lets compute a random integer matrix."}}{COM_R 102 0{TEXT 
1 0 ""}}{INP_R 103 0 "> "{TEXT 0 22 "G := array(1..4,1..4):"}}
{COM_R 104 0{TEXT 1 0 ""}}{COM_R 105 0{TEXT 1 72 "This next step \+
creates a random number generator for filling the matrix."}}
{COM_R 106 0{TEXT 1 0 ""}}{INP_R 107 0 "> "{TEXT 0 13 "r:=rand(10
0):"}}{INP_R 108 0 "> "{TEXT 0 48 "for i to 4 do for j to 4 do G[
i,j] := r() od od:"}}{INP_R 109 0 "> "{TEXT 0 9 "evalm(G);"}}
{OUT_R 110 0 109{DAG (3n4\`MATRIX`,2[2,5[2,5j2x0081j2x0070j2x0097
j2x0063[2,5j2x0076j2x0038j2x0085j2x0068[2,5j2x0021j2x0009j2x0055p
F[2,5j2x0057j2x0060j2x0074p17}}{COM_R 111 0{TEXT 1 0 ""}}{COM_R 
112 0{TEXT 1 157 "We can reduce this matrix to reduced row echelo
n form using `gaussjordan`.  We can extend the matrix with an ide
ntity matrix to get the inverse of G as well."}}{COM_R 113 0{TEXT
 1 0 ""}}{INP_R 114 0 "> "{TEXT 0 19 "H:=extend(G,0,4,0);"}}
{OUT_R 115 0 114{DAG :3n3\`H`(3n4\`MATRIX`,2[2,5[2,9j2x0081j2x007
0j2x0097j2x0063j2x0000p14p14p14[2,9j2x0076j2x0038j2x0085j2x0068p1
4p14p14p14[2,9j2x0021j2x0009j2x0055p12p14p14p14p14[2,9j2x0057j2x0
060j2x0074p1Fp14p14p14p14}}{INP_R 116 0 "> "{TEXT 0 31 "for i to \+
4 do H[i,i+4] := 1 od:"}}{INP_R 117 0 "> "{TEXT 0 9 "evalm(H);"}}
{OUT_R 118 0 117{DAG (3n4\`MATRIX`,2[2,5[2,9j2x0081j2x0070j2x0097
j2x0063j2x0001j2x0000p13p13[2,9j2x0076j2x0038j2x0085j2x0068p13p11
p13p13[2,9j2x0021j2x0009j2x0055pFp13p13p11p13[2,9j2x0057j2x0060j2
x0074p1Dp13p13p13p11}}{INP_R 119 0 "> "{TEXT 0 16 "J:=gaussjord(H
);"}}{OUT_R 120 0 119{DAG :3n3\`J`(3n4\`MATRIX`,2[2,5[2,9j2x0001j
2x0000pEpE/3i3x00077657j3x02815042/3j3x00127423p16/3i3x00045908j3
x01407521/3j3x00023671p16[2,9pEpCpEpE/3j3x00023495p22/3i3x0003831
6p22/3i3x00011969p22/3j3x00022110p22[2,9pEpEpCpE/3j3x00054858p22/
3i3x00035367p22/3j3x00049454p22/3i3x00049020p22[2,9pEpEpEpC/3i3x0
0076611p16/3j3x00030225p16/3i2x3820p22/3j3x00071383p16}}{COM_R 
121 0{TEXT 1 0 ""}}{COM_R 122 0{TEXT 1 58 "The 4x4 submatrix on t
he right should be the inverse of G."}}{COM_R 123 0{TEXT 1 0 ""}}
{INP_R 124 0 "> "{TEXT 0 26 "H:=submatrix(J,1..4,5..8);"}}{OUT_R 
125 0 124{DAG :3n3\`H`(3n4\`MATRIX`,2[2,5[2,5/3i3x00077657j3x0281
5042/3j3x00127423p10/3i3x00045908j3x01407521/3j3x00023671p10[2,5/
3j3x00023495p1C/3i3x00038316p1C/3i3x00011969p1C/3j3x00022110p1C[2
,5/3j3x00054858p1C/3i3x00035367p1C/3j3x00049454p1C/3i3x00049020p1
C[2,5/3i3x00076611p10/3j3x00030225p10/3i2x3820p1C/3j3x00071383p10
}}{INP_R 126 0 "> "{TEXT 0 12 "evalm(G&*H);"}}{OUT_R 127 0 126
{DAG (3n4\`MATRIX`,2[2,5[2,5j2x0001j2x0000pBpB[2,5pBp9pBpB[2,5pBp
Bp9pB[2,5pBpBpBp9}}{COM_R 128 0{TEXT 1 0 ""}}{COM_R 129 0{TEXT 1 
163 "Maple can also compute the Jordan normal form and rational c
anonical form.  We can also obtain the transformation matrix by i
ncluding a second name as an argument."}}{COM_R 130 0{TEXT 1 0 ""
}}{INP_R 131 0 "> "{TEXT 0 30 "J:=matrix([[34,25],[-16,-6]]);"}}
{OUT_R 132 0 131{DAG :3n3\`J`(3n4\`MATRIX`,2[2,3[2,3j2x0034j2x002
5[2,3i2x0016i2x0006}}{COM_R 133 0{TEXT 1 0 ""}}{COM_R 134 0{TEXT 
1 35 "Here we have a single Jordan block."}}{COM_R 135 0{TEXT 1 0
 ""}}{INP_R 136 0 "> "{TEXT 0 15 "jordan(J,'T1');"}}{OUT_R 137 0 
136{DAG (3n4\`MATRIX`,2[2,3[2,3j2x0014j2x0001[2,3j2x0000p9}}
{COM_R 138 0{TEXT 1 0 ""}}{COM_R 139 0{TEXT 1 63 "We can verify t
he similarity using the returned transformation."}}{COM_R 140 0
{TEXT 1 0 ""}}{INP_R 141 0 "> "{TEXT 0 26 "evalm(T1&*J&*inverse(T
1));"}}{OUT_R 142 0 141{DAG (3n4\`MATRIX`,2[2,3[2,3j2x0014j2x0001
[2,3j2x0000p9}}{COM_R 143 0{TEXT 1 0 ""}}{COM_R 144 0{TEXT 1 59 "
`ratform`,  the rational canonical form works the same way."}}
{COM_R 145 0{TEXT 1 0 ""}}{INP_R 146 0 "> "{TEXT 0 16 "ratform(J,
'T2');"}}{OUT_R 147 0 146{DAG (3n4\`MATRIX`,2[2,3[2,3j2x0000i2x01
96[2,3j2x0001j2x0028}}{INP_R 148 0 "> "{TEXT 0 26 "evalm(inverse(
T2)&*J&*T2);"}}{OUT_R 149 0 148{DAG (3n4\`MATRIX`,2[2,3[2,3j2x000
0i2x0196[2,3j2x0001j2x0028}}{COM_R 150 0{TEXT 1 0 ""}}{COM_R 151 
0{TEXT 1 56 "Maple has a shortcut command to create Hilbert matri
ces."}}{COM_R 152 0{TEXT 1 0 ""}}{INP_R 153 0 "> "{TEXT 0 14 "C:=
hilbert(5);"}}{OUT_R 154 0 153{DAG :3n3\`C`(3n4\`MATRIX`,2[2,6[2,
6j2x0001/3pCj2x0002/3pCj2x0003/3pCj2x0004/3pCj2x0005[2,6pEp12p16p
1A/3pCj2x0006[2,6p12p16p1Ap24/3pCj2x0007[2,6p16p1Ap24p2E/3pCj2x00
08[2,6p1Ap24p2Ep38/3pCj2x0009}}{INP_R 155 0 "> "{TEXT 0 14 "F:=in
verse(C);"}}{OUT_R 156 0 155{DAG :3n3\`F`(3n4\`MATRIX`,2[2,6[2,6j
2x0025i2x0300j2x1050i2x1400j2x0630[2,6pEj2x4800i3x00018900j3x0002
6880i3x00012600[2,6p10p1Bj3x00079380i3x00117600j3x00056700[2,6p12
p1Ep2Bj3x00179200i3x00088200[2,6p14p21p2Ep39j3x00044100}}{COM_R 
157 0{TEXT 1 0 ""}}{COM_R 158 0{TEXT 1 88 "Since F has all intege
r entries, we can compute the Hermite and Smith normal forms of F
."}}{COM_R 159 0{TEXT 1 0 ""}}{INP_R 160 0 "> "{TEXT 0 10 "ismith
(F);"}}{OUT_R 161 0 160{DAG (3n4\`MATRIX`,2[2,6[2,6j2x0005j2x0000
pBpBpB[2,6pBj2x0060pBpBpB[2,6pBpBj2x0420pBpB[2,6pBpBpBj2x0840pB[2
,6pBpBpBpBj2x2520}}{INP_R 162 0 "> "{TEXT 0 12 "ihermite(F);"}}
{OUT_R 163 0 162{DAG (3n4\`MATRIX`,2[2,6[2,6j2x0005j2x0000j2x0210
j2x0560j2x0630[2,6pBj2x0060pBpBpB[2,6pBpBj2x0420pBpB[2,6pBpBpBj2x
0840pB[2,6pBpBpBpBj2x2520}}{COM_R 164 0{TEXT 1 0 ""}}{COM_R 165 0
{TEXT 1 155 "Our last example examines the factorization of Vande
rmonde and Toeplitz matrices.  Maple has a command to generate bo
th Toeplitz  and Vandermonde matrices."}}{COM_R 166 0{TEXT 1 0 ""
}}{COM_R 167 0{TEXT 1 71 "The vandermonde command takes a list of
 field elements as its argument."}}{COM_R 168 0{TEXT 1 0 ""}}
{INP_R 169 0 "> "{TEXT 0 31 "V := vandermonde( [x.(1..4)] );"}}
{OUT_R 170 0 169{DAG :3n3\`V`(3n4\`MATRIX`,2[2,5[2,5j2x0001n3\`x1
`*3pEj2x0002*3pEj2x0003[2,5pCn3\`x2`*3p1Bp12*3p1Bp16[2,5pCn3\`x3`
*3p26p12*3p26p16[2,5pCn3\`x4`*3p31p12*3p31p16}}{INP_R 171 0 "> "
{TEXT 0 7 "det(V);"}}{OUT_R 172 0 171{DAG +31*7n3\`x2`j2x0001n3\`
x3`j2x0002n3\`x4`j2x0003p4*7p2p4p6pCpAp8i2x0001*7p6p4p2p8pApCp16*
7p6p4p2pCpAp8p4*7pAp4p2p8p6pCp4*7pAp4p2pCp6p8p16*7n3\`x1`p4p6p8pA
pCp16*7p39p4p6pCpAp8p4*7p6p4p39p8pApCp4*7p6p4p39pCpAp8p16*7pAp4p3
9p8p6pCp16*7pAp4p39pCp6p8p4*7p39p4p2p8pApCp4*7p39p4p2pCpAp8p16*7p
2p4p39p8pApCp16*7p2p4p39pCpAp8p4*7pAp4p39p8p2pCp4*7pAp4p39pCp2p8p
16*7p39p4p2p8p6pCp16*7p39p4p2pCp6p8p4*7p2p4p39p8p6pCp4*7p2p4p39pC
p6p8p16*7p6p4p39p8p2pCp16*7p6p4p39pCp2p8p4}}{INP_R 173 0 "> "
{TEXT 0 15 "factor(det(V));"}}{OUT_R 174 0 173{DAG *D+5n3\`x4`i2x
0001n3\`x3`j2x0001p8+5n3\`x2`p8p2p4p8+5pCp8p6p4p8+5p2p4n3\`x1`p8p
8+5p1Bp8p6p4p8+5p1Bp8pCp4p8}}{INP_R 175 0 "> "{TEXT 0 24 "T:=toep
litz([x.(1..4)]);"}}{OUT_R 176 0 175{DAG :3n3\`T`(3n4\`MATRIX`,2[
2,5[2,5n3\`x1`n3\`x2`n3\`x3`n3\`x4`[2,5pEpCpEp10[2,5p10pEpCpE[2,5
p12p10pEpC}}{INP_R 177 0 "> "{TEXT 0 7 "det(T);"}}{OUT_R 178 0 
177{DAG +19*3n3\`x1`j2x0004j2x0001*5p2j2x0002n3\`x2`pAi2x0003*7p2
p6n3\`x3`p6pCpAp4*5p2pAp14pAi2x0002*3pCp4p6*5n3\`x4`p6pCj2x0003p1
F*5pCpAp14pAp1F*9pCp6p14p6p26p6p2p6p4*3p14p4p6*7p26p6p14pApCp6p1F
*5p2pAp26pAi2x0001*5p26pApCpAp6}}{INP_R 179 0 "> "{TEXT 0 15 "fac
tor(det(T));"}}{OUT_R 180 0 179{DAG *5+F*5n3\`x4`j2x0001n3\`x1`p5
i2x0001*5n3\`x2`p5p3p5p5*3p7j2x0002p5*3n3\`x3`p15pA*5pDp5p7p5pA*5
pDp5p19p5p15*3pDp15pAp5+Fp2p5pCp5p13p5p18pAp1Dp5p23i2x0002p29pAp5
}}{INP_R 181 0 "> "{TEXT 0 0 ""}}}{END}
