{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 8 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "
Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 9 "-adobe-times-bold-r-
normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bo
ld" 14}{FONT 10 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "
times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 11 "-adobe-time
s-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 
"Times-Bold" 14}{SCP_R 1 0 91{COM_R 2 0{TEXT 1 0 ""}}{COM_R 3 0
{TEXT 11 41 "Solving Differential Equations with Maple"}}{COM_R 4
 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}{COM_R 6 0{TEXT 1 79 "Thi
s worksheet demonstrates Maple's sophisticated differential equat
ion solver."}}{COM_R 7 0{TEXT 1 0 ""}}{COM_R 8 0{TEXT 1 68 "Let's
 start with a first order ODE (ordinary differential equation)."}
}{COM_R 9 0{TEXT 1 0 ""}}{COM_R 10 0{TEXT 1 0 ""}}{INP_R 11 0 "> \+
"{TEXT 0 34 "de1:=diff(y(x),x)*(3*x^2+1)-2*x=0;"}}{OUT_R 12 0 11
{DAG :3n3\`de1`=3+5*5(3n4\`diff`,3(3n3\`y`,2n3\`x`pFj2x0001+5*3pF
j2x0002j2x0003p12p12p12p12pFi2x0002j2x0000}}{INP_R 13 0 "> "{TEXT
 0 17 "dsolve(de1,y(x));"}}{OUT_R 14 0 13{DAG =3(3n3\`y`,2n3\`x`+
5(3n3\`ln`,2+5*3p5j2x0002j2x0003j2x0001p13/3p13p11n3\`_C1`p13}}
{COM_R 15 0{TEXT 1 0 ""}}{COM_R 16 0{TEXT 1 131 "Since no initial
 conditions were given, Maple returns an answer with an  unknown \+
parameter.   We can specify the initial condition "}}{OUT_R 17 0 
0{DAG =3(3n3\`y`,2j2x0000p5}}{COM_R 18 0{TEXT 1 11 "as follows:"}
}{COM_R 19 0{TEXT 1 0 ""}}{INP_R 20 0 "> "{TEXT 0 26 "dsolve(\{de
1,y(0)=0\},y(x));"}}{OUT_R 21 0 20{DAG =3(3n3\`y`,2n3\`x`+3(3n3\`
ln`,2+5*3p5j2x0002j2x0003j2x0001p13/3p13p11}}{COM_R 22 0{TEXT 1 0
 ""}}{COM_R 23 0{TEXT 1 103 "Here are some more examples of equat
ions that would appear in a first course on differential equation
s."}}{COM_R 24 0{TEXT 1 0 ""}}{COM_R 25 0{TEXT 1 42 "This first o
ne is a linear first order DE."}}{COM_R 26 0{TEXT 1 0 ""}}{INP_R 
27 0 "> "{TEXT 0 42 "de2 := x^2 * diff(y(x),x) + y(x) = exp(x);"}
}{OUT_R 28 0 27{DAG :3n3\`de2`=3+5*5n3\`x`j2x0002(3n4\`diff`,3(3n
3\`y`,2p6p6j2x0001p15pFp15(3n3\`exp`p12}}{INP_R 29 0 "> "{TEXT 0 
17 "dsolve(de2,y(x));"}}{OUT_R 30 0 29{DAG =3(3n3\`y`,2n3\`x`+5*5
(3n3\`exp`,2*3p5i2x0001j2x0001(3n3\`int`,3*5(3pA,2*7+5p5p11pFp11p
11+5p5p11p11p11p11p5pFp11p5i2x0002p5p11p11*5p9p11n3\`_C1`p11p11}}
{COM_R 31 0{TEXT 1 0 ""}}{COM_R 32 0{TEXT 1 85 "Next we can try a
 non-homogeneous second order linear ODE with constant coefficien
ts."}}{COM_R 33 0{TEXT 1 0 ""}}{INP_R 34 0 "> "{TEXT 0 50 "de3 :=
 diff(f(x),x$2) + 2*diff(f(x),x) + f(x) = x;"}}{OUT_R 35 0 34{DAG
 :3n3\`de3`=3+7(3n4\`diff`,3(3p6,3(3n3\`f`,2n3\`x`p11p11j2x0001pA
j2x0002pDp15p11}}{INP_R 36 0 "> "{TEXT 0 17 "dsolve(de3,f(x));"}}
{OUT_R 37 0 36{DAG =3(3n3\`f`,2n3\`x`+9i2x0002j2x0001p5pA*5n3\`_C
1`pA(3n3\`exp`,2+3p5i2x0001pApA*7n3\`_C2`pAp12pAp5pApA}}{COM_R 38
 0{TEXT 1 0 ""}}{COM_R 39 0{TEXT 1 132 "Here Maple has found the \+
particular solution x-2 and superimposed on it the general soluti
on of the associated homogeneous equation."}}{COM_R 40 0{TEXT 1 0
 ""}}{COM_R 41 0{TEXT 1 0 ""}}{COM_R 42 0{TEXT 1 147 "Now let's m
ove on to the somewhat more difficult task of solving non-linear \+
equations.  In the next two  cases, Maple finds a closed form sol
ution."}}{COM_R 43 0{TEXT 1 0 ""}}{INP_R 44 0 "> "{TEXT 0 53 "de4
 := diff(y(x),x) = (y(x)^2-3*x*y(x))/(y(x)^2-x^2);"}}{OUT_R 45 0 
44{DAG :3n3\`de4`=3(3n4\`diff`,3(3n3\`y`,2n3\`x`pD*5+5*3p9j2x0002
j2x0001*5pDp16p9p16i2x0003p16+5p12p16*3pDp14i2x0001p26}}{INP_R 46
 0 "> "{TEXT 0 17 "dsolve(de4,y(x));"}}{OUT_R 47 0 46{DAG =3n3\`x
`*Bn3\`_C1`j2x0001(3n3\`y`,2p1/3p6j2x0002p1p6+7*3p8pFp6*3p1pFpF*5
p1p6p8p6i2x0001/3i2x0003j2x0004(3n3\`exp`,2+3*5j2x0007pD(3n4\`arc
tan`,2+3*7+5p8i2x0002p1p6p6p2EpDp1p21/3p6p2Ep6/3p6j2x0014p6}}
{INP_R 48 0 "> "{TEXT 0 68 "de5 := diff (y(t), t) + y(t)^2 + (2*t
 + 1) * y(t) + t^2 + t + 1 = 0;"}}{OUT_R 49 0 48{DAG :3n3\`de5`=3
+D(3n4\`diff`,3(3n3\`y`,2n3\`t`pEj2x0001*3pAj2x0002p11*5+5pEp15p1
1p11p11pAp11p11*3pEp15p11pEp11p11p11j2x0000}}{INP_R 50 0 "> "
{TEXT 0 17 "dsolve(de5,y(t));"}}{OUT_R 51 0 50{DAG =3(3n3\`y`,2n3
\`t`+7p5i2x0001p9j2x0001*5(3n3\`exp`p4pC+5n3\`_C1`pCpFpCp9pC}}
{COM_R 52 0{TEXT 1 0 ""}}{COM_R 53 0{TEXT 1 117 "If Maple cannot \+
solve an equation, we can always ask for a series solution.  Here
 is the famous Van der Pol equation."}}{COM_R 54 0{TEXT 1 0 ""}}
{INP_R 55 0 "> "{TEXT 0 54 "de6:=diff(y(t),t$2)+mu*(y(t)^2-1)*dif
f(y(t),t)+y(t)=0;"}}{OUT_R 56 0 55{DAG :3n3\`de6`=3+7(3n4\`diff`,
3(3p6,3(3n3\`y`,2n3\`t`p11p11j2x0001*7n3\`mu`p15+5*3pDj2x0002p15i
2x0001p15p15pAp15p15pDp15j2x0000}}{INP_R 57 0 "> "{TEXT 0 17 "dso
lve(de6,y(t));"}}{COM_R 58 0{TEXT 1 0 ""}}{COM_R 59 0{TEXT 1 164 
"Maple is unable to find a solution and returns NULL.  Now let's \+
get a series approximation.  To make the output more manageable, \+
 we will specify initial conditions"}}{COM_R 60 0{TEXT 1 0 ""}}
{INP_R 61 0 "> "{TEXT 0 43 "dsolve(\{de6,y(0)=1,D(y)(0)=1\},y(t),
series);"}}{OUT_R 62 0 61{DAG =3(3n3\`y`,2n3\`t`_10p5j2x0001x0p9x
1/3i2x0001j2x0002x2+5/3pFj2x0006p9n3\`mu`/3pFj2x0003x3+5p1A/3p9p1
7/3p9j2x0024p9x4+7p1A/3p11j2x0015*3p1Ap11p2E/3p9j2x0120p9x5(3n3\`
O`,2p9x6}}{COM_R 63 0{TEXT 1 0 ""}}{COM_R 64 0{TEXT 1 60 "Maple c
an also solve some systems of differential equations."}}{COM_R 65
 0{TEXT 1 0 ""}}{INP_R 66 0 "> "{TEXT 0 54 "de7:=\{ diff(y(t),t)=
x(t)+1, diff(x(t),t)*a = y(t)-3 \};"}}{OUT_R 67 0 66{DAG :3n3\`de
7`%2,3=3(3n4\`diff`,3(3n3\`y`,2n3\`t`pF+5(3n3\`x`pEj2x0001p17p17=
3*5(3p7,3p13pFp17n3\`a`p17+5pBp17i2x0003p17}}{INP_R 68 0 "> "
{TEXT 0 24 "dsolve(de7,\{x(t),y(t)\});"}}{OUT_R 69 0 68{DAG %2,3=
3(3n3\`y`,2n3\`t`+7j2x0003j2x0001*7n3\`_C1`pC(3n3\`exp`,2*5n3\`a`
/3i2x0001j2x0002p7pCpCp17/3pCp1CpC*7n3\`_C2`pC(3p13,2+3p16p1ApCp1
7p22p1A=3(3n3\`x`p6+7p1ApC*5pFpCp12pCpC*5p27pCp2ApCpC}}{COM_R 70 
0{TEXT 1 0 ""}}{COM_R 71 0{TEXT 1 158 "In some cases, we can spec
ify an algorithm to be used in solving the equation.  For example
,  we can ask Maple to use Laplace transforms to find its solutio
n."}}{COM_R 72 0{TEXT 1 0 ""}}{INP_R 73 0 "> "{TEXT 0 56 "de8:=di
ff(y(x),x$6) + 2*diff(y(x),x$4) + diff(y(x),x$2);"}}{OUT_R 74 0 
73{DAG :3n3\`de8`+7(3n4\`diff`,3(3p5,3(3p5,3(3p5,3(3p5,3(3p5,3(3n
3\`y`,2n3\`x`p1Cp1Cp1Cp1Cp1Cp1Cj2x0001pCj2x0002p12p24}}{INP_R 75 
0 "> "{TEXT 0 26 "dsolve(de8, y(x),laplace);"}}{OUT_R 76 0 75{DAG
 =3(3n3\`y`,2n3\`x`+1D(3(3(3n3\`@@`,3n3\`D`j2x0004,2p2,2j2x0000j2
x0001(3(3(3pB,3pEj2x0002p12p14p1F(3p2p14p17*5p5p17(3(3(3pB,3pEj2x
0005p12p14p17p17*5p5p17(3(3pEp12p14p17p17*5p5p17(3(3(3pB,3pEj2x00
03p12p14p17p1F*5p2Bp17(3n3\`sin`p4p17/3i2x0003p1F*5p44p17p53p17/3
i2x0005p1F*5p8p17(3n3\`cos`p4p17i2x0001*5p19p17p68p17i2x0002*7p8p
17p5p17p53p17/3p6Dp1F*7p19p17p5p17p53p17p7D*7p2Bp17p5p17p68p17/3p
17p1F*7p44p17p5p17p68p17p8F}}{COM_R 77 0{TEXT 1 0 ""}}{COM_R 78 0
{TEXT 1 293 "Maple also has an option for finding numerical solut
ions.  Maple returns a procedure that, when evaluated at a point,
 yields the solution's value, and the value of all derivatives up
 to the order of the ODE -1 .  The default algorithm  used is a F
ehlberg fourth-fifth order Runge-Kutta method."}}{COM_R 79 0{TEXT
 1 0 ""}}{INP_R 80 0 "> "{TEXT 0 44 "de9:=\{diff(y(t),t$3)-2*diff
(y(t),t$2)+y(t)\};"}}{OUT_R 81 0 80{DAG :3n3\`de9`%2,2+7(3n4\`dif
f`,3(3p7,3(3p7,3(3n3\`y`,2n3\`t`p15p15p15j2x0001pBi2x0002p11p1A}}
{INP_R 82 0 "> "{TEXT 0 39 "ic9:=\{y(0)=1,D(y)(0)=1,(D@@2)(y)(0)=
1\};"}}{OUT_R 83 0 82{DAG :3n3\`ic9`%2,4=3(3n3\`y`,2j2x0000j2x000
1=3(3(3n3\`D`,2p7p9pC=3(3(3(3n3\`@@`,3p11j2x0002p13p9pC}}{INP_R 
84 0 "> "{TEXT 0 39 "s9:=dsolve(de9 union ic9,y(t),numeric);"}}
{OUT_R 85 0 84{DAG :3n3\`s9`@8,2n4\`rkf45_x`,3n3\`i`n4\`rkf45_s`,
2nD\`Copyright~`1993~`by~`Waterloo~`Maple~`Software`,1;4:3b3n4\`c
ontrol`,2j2x0003(3n4\`evalf`,2a2x0001?4$3n4\`Digits`(3n4\`evalhf`
,2p2E;3:3l2x0002(3n5\`traperror`,2(3p32,2(3n8\`dsolve/numeric_sol
nall`,Bn3\`F`(3n3\`var`,2p1F(3p50,2n3\`y0`(3p50,2n3\`y1`(3p50,2n3
\`F1`(3p50,2n3\`F2`(3p50,2n3\`F3`(3p50,2n3\`F4`(3p50,2n3\`F5`(3p5
0,2n4\`work`?3=3p39n5\`lasterror`?4<3j2x0002b3p1F,2j2x0006(3n4\`E
RROR`,2p39(3p45,Bp4Dp1Fp57p5Cp61p66p6Bp70p75p7Ap93[2,3=3n3\`t`p2A
(3n3\`seq`,3=3b3n3\`ord`,2+5l2x0001j2x0001pB3pB3b3p57,2pB1=3pB1~3
pB3p23p1Bp52}{TEXT 2 29 "\012s9 := proc(rkf45_x) ... end\012"}}
{INP_R 86 0 "> "{TEXT 0 7 "s9(1.);"}}{OUT_R 87 0 86{DAG [2,5=3n3\
`t`e3j2x0001j2x0000=3(3n3\`y`,2p3e3j5x2718281811394142i2x0015=3(3
n4\`diff`,3pBp3p10=3(3p1A,3p19p3p10}}{COM_R 88 0{TEXT 1 0 ""}}
{COM_R 89 0{TEXT 1 51 "We can plot the result using the function \+
odeplot. "}}{COM_R 90 0{TEXT 1 0 ""}}{INP_R 91 0 "> "{TEXT 0 45 "
with(plots): odeplot(s9,\{t,y,yp\},0..2,0..10);"}}{INP_R 92 0 "> \+
"{TEXT 0 0 ""}}}{END}
