{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 8 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "
Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 9 "-adobe-times-bold-r-
normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bo
ld" 14}{FONT 10 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "
times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 11 "-adobe-time
s-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 
"Times-Bold" 14}{FONT 12 "-adobe-times-bold-r-normal--*-140-*-*-*
-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{SCP_R 1 0 
164{COM_R 2 0{TEXT 1 0 ""}}{COM_R 3 0{TEXT 12 23 "Optimization wi
th Maple"}}{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}{COM_R
 6 0{TEXT 1 217 "Maple has a library function for finding solutio
ns to linear programs using the simplex algorithm.  The later exa
mples in this demonstration worksheet are taken from problems in \+
\"Linear Programming\"  by Vasek Chvatal."}}{COM_R 7 0{TEXT 1 0 "
"}}{COM_R 8 0{TEXT 1 43 "To begin, we must load the simplex packa
ge."}}{COM_R 9 0{TEXT 1 0 ""}}{INP_R 10 0 "> "{TEXT 0 14 "with(si
mplex);"}}{OUT_R 11 0 10{DAG [2,10n4\`basis`n5\`convexhull`n4\`ct
erm`n5\`define_zero`n4\`display`n4\`dual`n5\`feasible`n5\`maximiz
e`n5\`minimize`n4\`pivot`n5\`pivoteqn`n5\`pivotvar`n4\`ratio`n4\`
setup`n5\`standardize`}}{COM_R 12 0{TEXT 1 0 ""}}{COM_R 13 0{TEXT
 1 42 "This will be our first set of constraints:"}}{COM_R 14 0
{TEXT 1 0 ""}}{INP_R 15 0 "> "{TEXT 0 17 "c1:=\{x<=-4,y<=3\};"}}
{OUT_R 16 0 15{DAG :3n3\`c1`%2,3$3n3\`x`i2x0004$3n3\`y`j2x0003}}
{COM_R 17 0{TEXT 1 0 ""}}{COM_R 18 0{TEXT 1 115 "The function fea
sible is used to determine if the constraints have a solution at \+
all.  This case is trivially true."}}{COM_R 19 0{TEXT 1 1 " "}}
{INP_R 20 0 "> "{TEXT 0 13 "feasible(c1);"}}{OUT_R 21 0 20{DAG n4
\`true`}}{COM_R 22 0{TEXT 1 0 ""}}{COM_R 23 0{TEXT 1 163 "We can \+
also check for solutions in which each of the parameters is posit
ive.  This is a shorthand for the constraints x>=0 for each x men
tioned in the constraints."}}{COM_R 24 0{TEXT 1 0 ""}}{INP_R 25 0
 "> "{TEXT 0 25 "feasible(c1,NONNEGATIVE);"}}{OUT_R 26 0 25{DAG n
4\`false`}}{COM_R 27 0{TEXT 1 0 ""}}{COM_R 28 0{TEXT 1 147 "Maple
 uses the simplex method for optimization.  The procedure maximiz
e from the simplex package does this.  We will solve this objecti
ve function:"}}{COM_R 29 0{TEXT 1 0 ""}}{INP_R 30 0 "> "{TEXT 0 
18 "w := -x + y + 2*z;"}}{OUT_R 31 0 30{DAG :3n3\`w`+Bn3\`x`i2x00
01n3\`y`j2x0001n3\`x1`j2x0004n3\`x2`i2x0002n3\`x3`j2x0016}}{COM_R
 32 0{TEXT 1 29 "subject to these constraints:"}}{COM_R 33 0{TEXT
 1 0 ""}}{INP_R 34 0 "> "{TEXT 0 25 "eq1 := 3*x+4*y -3*z<= 23;"}}
{OUT_R 35 0 34{DAG :3n3\`eq1`$3+Bn3\`x`j2x0003n3\`y`j2x0004n3\`x1
`i2x0006n3\`x2`p7n3\`x3`i2x0024j2x0023}}{INP_R 36 0 "> "{TEXT 0 
25 "eq2 := 5*x-4*y -3*z<= 10;"}}{OUT_R 37 0 36{DAG :3n3\`eq2`$3+B
n3\`x`j2x0005n3\`y`i2x0004n3\`x1`i2x0006n3\`x2`j2x0003n3\`x3`i2x0
024j2x0010}}{INP_R 38 0 "> "{TEXT 0 30 "eq3 := 7*x + 4*y + 11*z <
= 30;"}}{OUT_R 39 0 38{DAG :3n3\`eq3`$3+Bn3\`x`j2x0007n3\`y`j2x00
04n3\`x1`j2x0022n3\`x2`i2x0011n3\`x3`j2x0088j2x0030}}{INP_R 40 0 
"> "{TEXT 0 19 "c2 := \{ eq.(1..3)\};"}}{OUT_R 41 0 40{DAG :3n3\`
c2`%2,4$3+Bn3\`x`j2x0003n3\`y`j2x0004n3\`x1`i2x0006n3\`x2`p9n3\`x
3`i2x0024j2x0023$3+Bp7j2x0005pBi2x0004pFp11p13p9p16p18j2x0010$3+B
p7j2x0007pBpDpFj2x0022p13i2x0011p16j2x0088j2x0030}}{INP_R 42 0 ">
 "{TEXT 0 15 "maximize(w,c2);"}}{COM_R 43 0{TEXT 1 0 ""}}{COM_R 
44 0{TEXT 1 122 "Maple returned NULL here since the solution is u
nbounded.  However, if we add more constraints,  a finite solutio
n exists."}}{COM_R 45 0{TEXT 1 0 ""}}{INP_R 46 0 "> "{TEXT 0 27 "
maximize(w,c2,NONNEGATIVE);"}}{OUT_R 47 0 46{DAG %2,6=3n3\`x2`j2x
0000=3n3\`x`p5=3n3\`y`/3j2x0049j2x0008=3n3\`x1`/3j2x0001j2x0004=3
n3\`x3`p5}}{COM_R 48 0{TEXT 1 0 ""}}{COM_R 49 0{TEXT 1 40 "This i
s the same as solving this system:"}}{COM_R 50 0{TEXT 1 0 ""}}
{INP_R 51 0 "> "{TEXT 0 38 "maximize(w,c2 union \{x>=0,y>=0,z>=0\
});"}}{OUT_R 52 0 51{DAG %2,6=3n3\`x2`j2x0000=3n3\`x`p5=3n3\`y`/3
j2x0049j2x0008=3n3\`x1`/3j2x0001j2x0004=3n3\`x3`p5}}{COM_R 53 0
{TEXT 1 0 ""}}{COM_R 54 0{TEXT 1 136 "Here are some ways in which
 the simplex method can run into difficulty.  This will be our ob
jective function, taken from Chvatal, p. 29:"}}{COM_R 55 0{TEXT 1
 0 ""}}{INP_R 56 0 "> "{TEXT 0 31 "z :=  2*x1 - x2 + 8*x3; obj:=z
:"}}{OUT_R 57 0 56{DAG :3n3\`z`+7n3\`x1`j2x0002n3\`x2`i2x0001n3\`
x3`j2x0008}}{COM_R 58 0{TEXT 1 0 ""}}{COM_R 59 0{TEXT 1 59 "We wi
sh to solve this subject to the following constraints:"}}{COM_R 
60 0{TEXT 1 0 ""}}{INP_R 61 0 "> "{TEXT 0 71 "cnts1 :=[ 2*x3 <= 1
, 2*x1 - 4*x2 + 6*x3 <= 3, -x1 + 3*x2 + 4*x3 <= 2 ];"}}{OUT_R 62 
0 61{DAG :3n4\`cnts1`[2,4$3+3n3\`x3`j2x0002j2x0001$3+7n3\`x1`pAn3
\`x2`i2x0004p8j2x0006j2x0003$3+7p10i2x0001p13p1Ap8j2x0004pA}}
{COM_R 63 0{TEXT 1 0 ""}}{COM_R 64 0{TEXT 1 189 "This system is c
alled degenerate as there are several pivoting iterations in the \+
simplex algorithm that will fail to increase the objective functi
on.  Maple is able to find a solution here."}}{COM_R 65 0{TEXT 1 
0 ""}}{INP_R 66 0 "> "{TEXT 0 38 "sol1 := maximize(z,cnts1,NONNEG
ATIVE);"}}{OUT_R 67 0 66{DAG :3n4\`sol1`%2,4=3n3\`x3`j2x0000=3n3\
`x1`/3j2x0017j2x0002=3n3\`x2`/3j2x0007p11}}{COM_R 68 0{TEXT 1 0 "
"}}{COM_R 69 0{TEXT 1 98 "We can also work through this example b
y hand.  First we create a dictionary from our constraints."}}
{COM_R 70 0{TEXT 1 0 ""}}{INP_R 71 0 "> "{TEXT 0 20 "eqns1:=setup
(cnts1);"}}{OUT_R 72 0 71{DAG :3n4\`eqns1`[2,4=3n4\`_SL1`+5j2x000
1pBn3\`x3`i2x0002=3n4\`_SL2`+9j2x0003pBn3\`x1`p10n3\`x2`j2x0004pE
i2x0006=3n4\`_SL3`+9j2x0002pBp1ApBp1Di2x0003pEi2x0004}}{COM_R 73 
0{TEXT 1 0 ""}}{COM_R 74 0{TEXT 1 327 "We have two choices for va
riables to add to our basis in the beginning, x1 and x3.  Followi
ng convention, we choose x3.  We can determine which variable is \+
most restrictive with respect to the next pivot using the functio
n ratios.  In this case,  all variables are equally restrictive w
ith respect to x3, leading to degeneracy."}}{COM_R 75 0{TEXT 1 0 
""}}{INP_R 76 0 "> "{TEXT 0 17 "ratios(eqns1,x3);"}}{OUT_R 77 0 
76{DAG [2,4/3j2x0001j2x0002p2p2}}{INP_R 78 0 "> "{TEXT 0 29 "subs
(\{x3=1/2,x1=0,x2=0\},obj);"}}{OUT_R 79 0 78{DAG j2x0004}}{INP_R 
80 0 "> "{TEXT 0 45 "eqns1:=pivot(eqns1,x3,eqns1[1]); subs(\",obj
);"}}{OUT_R 81 0 80{DAG :3n4\`eqns1`[2,4=3n3\`x3`+5n4\`_SL1`/3i2x
0001j2x0002/3j2x0001p10p13=3n4\`_SL2`+7n3\`x1`i2x0002n3\`x2`j2x00
04pAj2x0003=3n4\`_SL3`+7p1Cp13p20i2x0003pAp10}}{OUT_R 82 0 80{DAG
 +9n3\`x1`j2x0002n3\`x2`i2x0001n4\`_SL1`i2x0004j2x0004j2x0001}}
{COM_R 83 0{TEXT 1 0 ""}}{COM_R 84 0{TEXT 1 105 "Our only choice \+
here is to pivot about x1 as increasing any  others will decrease
 the objective function."}}{COM_R 85 0{TEXT 1 0 ""}}{INP_R 86 0 "
> "{TEXT 0 17 "ratios(eqns1,x1);"}}{OUT_R 87 0 86{DAG [2,4n5\`inf
inity`j2x0000p2}}{COM_R 88 0{TEXT 1 111 "Here we can only raise x
1 to 0, its present value, so our objective function has not incr
eased, and is still 4."}}{COM_R 89 0{TEXT 1 0 ""}}{INP_R 90 0 "> \+
"{TEXT 0 44 "eqns1:=pivot(eqns1,x1,eqns1[2]);subs(\",obj);"}}
{OUT_R 91 0 90{DAG :3n4\`eqns1`[2,4=3n3\`x3`+5n4\`_SL1`/3i2x0001j
2x0002/3j2x0001p10p13=3n3\`x1`+7n4\`_SL2`pDn3\`x2`p10pA/3j2x0003p
10=3n4\`_SL3`+7p1BpDp1FpEpA/3j2x0007p10}}{OUT_R 92 0 90{DAG +9n4\
`_SL2`i2x0001n3\`x2`j2x0003n4\`_SL1`p4j2x0004j2x0001}}{INP_R 93 0
 "> "{TEXT 0 17 "ratios(eqns1,x2);"}}{OUT_R 94 0 93{DAG [2,4n5\`i
nfinity`p2j2x0000}}{COM_R 95 0{TEXT 1 93 "Again, x2 is our only c
hoice for pivoting and again we can only set x2=0, its original v
alue."}}{COM_R 96 0{TEXT 1 0 ""}}{INP_R 97 0 "> "{TEXT 0 44 "eqns
1:=pivot(eqns1,x2,eqns1[3]);subs(\",obj);"}}{OUT_R 98 0 97{DAG :3
n4\`eqns1`[2,4=3n3\`x3`+5n4\`_SL1`/3i2x0001j2x0002/3j2x0001p10p13
=3n3\`x1`+7n4\`_SL2`/3i2x0003p10n4\`_SL3`i2x0002pA/3j2x0017p10=3n
3\`x2`+7p22pEp1BpDpA/3j2x0007p10}}{OUT_R 99 0 97{DAG +9n4\`_SL2`/
3i2x0005j2x0002n4\`_SL3`i2x0003n4\`_SL1`/3j2x0019p7j2x0004j2x0001
}}{INP_R 100 0 "> "{TEXT 0 19 "ratios(eqns1,_SL1);"}}{OUT_R 101 0
 100{DAG [2,4j2x0001n5\`infinity`p4}}{COM_R 102 0{TEXT 1 0 ""}}
{COM_R 103 0{TEXT 1 90 "And now we are done by simply back substi
tuting _SL1=1, _SL2=0 and _SL3=0 into our system."}}{COM_R 104 0
{TEXT 1 0 ""}}{INP_R 105 0 "> "{TEXT 0 35 "subs(\{_SL2=0,_SL3=0,_
SL1=1\},eqns1);"}}{OUT_R 106 0 105{DAG [2,4=3n3\`x3`j2x0000=3n3\`
x1`/3j2x0017j2x0002=3n3\`x2`/3j2x0007pD}}{COM_R 107 0{TEXT 1 0 ""
}}{COM_R 108 0{TEXT 1 297 "The algorithm can run into trouble by \+
never reaching its terminal step.  This will occur if the initial
 step is found after some pivoting iterations and the phenomenon \+
is known as cycling.  This example is from Chvatal pp. 31-22. Map
le finds the solution by using a varient of the simplex method. "
}}{COM_R 109 0{TEXT 1 0 ""}}{INP_R 110 0 "> "{TEXT 0 33 "z2 := 10
*x1 - 57*x2 -9*x3 -24*x4;"}}{OUT_R 111 0 110{DAG :3n3\`z2`+9n3\`x
1`j2x0010n3\`x2`i2x0057n3\`x3`i2x0009n3\`x4`i2x0024}}{INP_R 112 0
 "> "{TEXT 0 49 "cnts2 := [ 1/2*x1 - 11/2*x2 - 5/2*x3 + 9*x4 <= 0
,"}}{INP_R 113 0 "> "{TEXT 0 40 "   1/2*x1 - 3/2*x2 - 1/2*x3 + 1*
x4 <= 0,"}}{INP_R 114 0 "> "{TEXT 0 18 "        x1 <= 1 ];"}}
{OUT_R 115 0 114{DAG :3n4\`cnts2`[2,4$3+9n3\`x1`/3j2x0001j2x0002n
3\`x2`/3i2x0011pDn3\`x3`/3i2x0005pDn3\`x4`j2x0009j2x0000$3+9p8pAp
F/3i2x0003pDp15/3i2x0001pDp1BpBp1F$3p8pB}}{INP_R 116 0 "> "{TEXT 
0 39 "sol2 := maximize(z2,cnts2,NONNEGATIVE);"}}{OUT_R 117 0 116
{DAG :3n4\`sol2`%2,5=3n3\`x4`j2x0000=3n3\`x2`p9=3n3\`x3`j2x0001=3
n3\`x1`p12}}{COM_R 118 0{TEXT 1 0 ""}}{COM_R 119 0{TEXT 1 238 "If
 we work through the example by hand, we will see what happens in
 a cycle.  At each stage,  we will only check which variable is t
o be added to the basis, and which should be removed, not botheri
ng with observing the objective function."}}{COM_R 120 0{TEXT 1 0
 ""}}{COM_R 121 0{TEXT 1 76 "Our objective function leaves us onl
y one choice for our pivot variable: x1."}}{COM_R 122 0{TEXT 1 1 
" "}}{INP_R 123 0 "> "{TEXT 0 9 "obj2:=z2;"}}{OUT_R 124 0 123{DAG
 :3n4\`obj2`+9n3\`x1`j2x0010n3\`x2`i2x0057n3\`x3`i2x0009n3\`x4`i2
x0024}}{INP_R 125 0 "> "{TEXT 0 20 "eqns2:=setup(cnts2);"}}{OUT_R
 126 0 125{DAG :3n4\`eqns2`[2,4=3n4\`_SL1`+9n3\`x1`/3i2x0001j2x00
02n3\`x2`/3j2x0011p10n3\`x3`/3j2x0005p10n3\`x4`i2x0009=3n4\`_SL2`
+9pBpDp12/3j2x0003p10p18/3j2x0001p10p1EpE=3n4\`_SL3`+5p30p30pBpE}
}{INP_R 127 0 "> "{TEXT 0 16 "ratio(eqns2,x1);"}}{OUT_R 128 0 127
{DAG [2,4j2x0000p2j2x0001}}{COM_R 129 0{TEXT 1 0 ""}}{COM_R 130 0
{TEXT 1 113 "Here we have degeneracy again.  We remove the variab
le with the smallest index  from the basis as there is a tie."}}
{COM_R 131 0{TEXT 1 0 ""}}{INP_R 132 0 "> "{TEXT 0 51 "eqns2:=piv
ot(eqns2,x1,eqns2[1]):obj2:=subs(\",obj2);"}}{OUT_R 133 0 132{DAG
 :3n4\`obj2`+9n4\`_SL1`i2x0020n3\`x2`j2x0053n3\`x3`j2x0041n3\`x4`
i2x0204}}{COM_R 134 0{TEXT 1 0 ""}}{COM_R 135 0{TEXT 1 121 "Here \+
we have two choices to  add to the basis.  Following convention a
gain, we pick the one with the largest coefficient."}}{COM_R 136 
0{TEXT 1 0 ""}}{INP_R 137 0 "> "{TEXT 0 17 "ratios(eqns2,x2);"}}
{OUT_R 138 0 137{DAG [2,4n5\`infinity`j2x0000/3j2x0001j2x0011}}
{INP_R 139 0 "> "{TEXT 0 51 "eqns2:=pivot(eqns2,x2,eqns2[2]):obj2
:=subs(\",obj2);"}}{OUT_R 140 0 139{DAG :3n4\`obj2`+9n4\`_SL1`/3i
2x0027j2x0004n4\`_SL2`/3i2x0053pBn3\`x3`/3j2x0029j2x0002n3\`x4`i2
x0098}}{INP_R 141 0 "> "{TEXT 0 17 "ratios(eqns2,x3);"}}{OUT_R 
142 0 141{DAG [2,4j2x0000p2n5\`infinity`}}{INP_R 143 0 "> "{TEXT 
0 51 "eqns2:=pivot(eqns2,x3,eqns2[1]):obj2:=subs(\",obj2);"}}
{OUT_R 144 0 143{DAG :3n4\`obj2`+9n4\`_SL1`j2x0015n4\`_SL2`i2x009
3n3\`x1`i2x0029n3\`x4`j2x0018}}{INP_R 145 0 "> "{TEXT 0 17 "ratio
s(eqns2,x4);"}}{OUT_R 146 0 145{DAG [2,4n5\`infinity`j2x0000p2}}
{INP_R 147 0 "> "{TEXT 0 51 "eqns2:=pivot(eqns2,x4,eqns2[2]):obj2
:=subs(\",obj2);"}}{OUT_R 148 0 147{DAG :3n4\`obj2`+9n4\`_SL1`/3j
2x0021j2x0002n4\`_SL2`/3i2x0141pBn3\`x1`i2x0020n3\`x2`i2x0009}}
{INP_R 149 0 "> "{TEXT 0 19 "ratios(eqns2,_SL1);"}}{OUT_R 150 0 
149{DAG [2,4j2x0000p2n5\`infinity`}}{INP_R 151 0 "> "{TEXT 0 53 "
eqns2:=pivot(eqns2,_SL1,eqns2[1]):obj2:=subs(\",obj2);"}}{OUT_R 
152 0 151{DAG :3n4\`obj2`+9n3\`x3`i2x0021n3\`x1`j2x0022n4\`_SL2`j
2x0024n3\`x2`i2x0093}}{INP_R 153 0 "> "{TEXT 0 19 "ratios(eqns2,_
SL2);"}}{OUT_R 154 0 153{DAG [2,4n5\`infinity`j2x0000p2}}{INP_R 
155 0 "> "{TEXT 0 53 "eqns2:=pivot(eqns2,_SL2,eqns2[2]):obj2:=sub
s(\",obj2);"}}{OUT_R 156 0 155{DAG :3n4\`obj2`+9n3\`x1`j2x0010n3\
`x2`i2x0057n3\`x3`i2x0009n3\`x4`i2x0024}}{COM_R 157 0{TEXT 1 0 ""
}}{COM_R 158 0{TEXT 1 123 "This, however is our initial objective
 function!  If we take a look at our equations, we will find our \+
original dictionary:"}}{COM_R 159 0{TEXT 1 0 ""}}{INP_R 160 0 "> \+
"{TEXT 0 6 "eqns2;"}}{OUT_R 161 0 160{DAG [2,4=3n4\`_SL1`+9n3\`x1
`/3i2x0001j2x0002n3\`x2`/3j2x0011pCn3\`x3`/3j2x0005pCn3\`x4`i2x00
09=3n4\`_SL2`+9p7p9pE/3j2x0003pCp14/3j2x0001pCp1ApA=3n4\`_SL3`+5p
2Cp2Cp7pA}}{COM_R 162 0{TEXT 1 0 ""}}{COM_R 163 0{TEXT 1 72 "Thus
 continued iterations of this algorithm will only repeat this cyc
le."}}{INP_R 164 0 "> "{TEXT 0 0 ""}}{COM_R 165 0{TEXT 1 0 ""}}}
{END}
