{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 8 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "
Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 9 "-adobe-times-bold-r-
normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bo
ld" 14}{FONT 10 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "
times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 11 "-adobe-time
s-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 
"Times-Bold" 14}{FONT 12 "-adobe-times-bold-r-normal--*-140-*-*-*
-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 13 "-a
dobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold"
 8 14 64 "Times-Bold" 14}{SCP_R 1 0 130{COM_R 2 0{TEXT 1 0 ""}}
{COM_R 3 0{TEXT 13 26 "Language Output with Maple"}}{COM_R 4 0
{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}{COM_R 6 0{TEXT 1 175 "Mapl
e has several commands for converting Maple output into other lan
guages and forms.  This worksheet highlights transformations to F
ortran, C, LaTeX, and troff eqn printing."}}{COM_R 7 0{TEXT 1 0 "
"}}{COM_R 8 0{TEXT 1 44 "First, let's start with a simple express
ion."}}{COM_R 9 0{TEXT 1 0 ""}}{INP_R 10 0 "> "{TEXT 0 40 "e1:=ex
p(-x^2) * (a*cos(y+t)+b*sin(y-t));"}}{OUT_R 11 0 10{DAG :3n3\`e1`
*5(3n3\`exp`,2+3*3n3\`x`j2x0002i2x0001j2x0001+5*5n3\`a`p10(3n3\`c
os`,2+5n3\`y`p10n3\`t`p10p10p10*5n3\`b`p10(3n3\`sin`,2+5p1Cp10p1F
pEp10p10p10}}{INP_R 12 0 "> "{TEXT 0 12 "fortran(e1);"}}{OUT_R 13
 0 12{TEXT 2 46 "      t0 = exp(-x**2)*(a*cos(y+t)+b*sin(y-t))\01
2"}}{COM_R 14 0{TEXT 1 0 ""}}{COM_R 15 0{TEXT 1 116 "Since the in
put was just an expression, it is assigned to the arbitrary varia
ble t0.  We can do the same thing in C."}}{COM_R 16 0{TEXT 1 0 ""
}}{INP_R 17 0 "> "{TEXT 0 11 "readlib(C):"}}{INP_R 18 0 "> "{TEXT
 0 6 "C(e1);"}}{OUT_R 19 0 18{TEXT 2 46 "      t0 = exp(-x*x)*(a*
cos(y+t)+b*sin(y-t));\012"}}{COM_R 20 0{TEXT 1 0 ""}}{COM_R 21 0
{TEXT 1 152 "Note that Maple takes full advantage of the C librar
y functions and the builtin Fortran functions sin and cos.  Also \+
not the difference in notation for "}}{OUT_R 22 0 0{DAG *3n3\`x`j
2x0002}}{COM_R 23 0{TEXT 1 21 "in the two languages."}}{COM_R 24 
0{TEXT 1 0 ""}}{COM_R 25 0{TEXT 1 245 "Now consider a far more co
mplicated expression.  Suppose we want our code to use the deriva
tive determinant,  the Hessian, for our expression e1.  We can  d
o  these calculations in Maple and convert the output expression \+
to the desired language."}}{COM_R 26 0{TEXT 1 0 ""}}{INP_R 27 0 "
> "{TEXT 0 13 "with(linalg):"}}{OUT_R 28 0 27{TEXT 2 107 "Warning
: new definition for   norm\012Warning: new definition for   stac
k\012Warning: new definition for   trace\012"}}{INP_R 29 0 "> "
{TEXT 0 28 "h:=det(hessian(e1,[x,y,t]));"}}{OUT_R 30 0 29{DAG :3n
3\`h`+D*B(3n3\`exp`,2+3*3n3\`x`j2x0002i2x0001j2x0003n3\`a`pD(3n3\
`cos`,2+5n3\`y`j2x0001n3\`t`p1DpDn3\`b`p1D(3n3\`sin`,2+5p1Bp1Dp1F
pFp1Di2x0008*Bp5p11p13p1Dp16p1Dp23pDp26pDp30*Dp5p11p13pDp16pDp23p
1Dp26p1DpBpDj2x0016*Dp5p11p13p1Dp16p1Dp23pDp26pDpBpDp4B*DpBpDp5p1
1p13pD(3p27p19pDp23p1Dp26p1Dp4B*DpBpDp5p11p23pD(3p17p29pDp13p1Dp1
6p1Dp4B}}{INP_R 31 0 "> "{TEXT 0 21 "fortran([hessian=h]);"}}
{OUT_R 32 0 31{TEXT 2 341 "      hessian = -8*exp(-x**2)**3*a**2*
cos(y+t)**2*b*sin(y-t)-8*exp(\\\012-x**2\012     #)**3*a*cos(y+t)
*b**2*sin(y-t)**2+16*exp(-x**2)**3*a**2*cos(y+\\\012t)**2\012    \+
 #*b*sin(y-t)*x**2+16*exp(-x**2)**3*a*cos(y+t)*b**2*sin(y-t)**2\\
\012*x**2\012     #+16*x**2*exp(-x**2)**3*a**2*sin(y+t)**2*b*sin(
y-t)+16*x**2*ex\\\012p(-x*\012     #*2)**3*b**2*cos(y-t)**2*a*cos
(y+t)\012"}}{COM_R 33 0{TEXT 1 0 ""}}{COM_R 34 0{TEXT 1 219 "Noti
ce how Maple has placed a line continuation character in the colu
mn where it is needed.  However,  the expression clearly contains
 many repeated subexpressions.  These can be eliminated using the
 option 'optimized'."}}{COM_R 35 0{TEXT 1 0 ""}}{INP_R 36 0 "> "
{TEXT 0 31 "fortran([hessian=h],optimized);"}}{OUT_R 37 0 36{TEXT
 2 445 "      t1 = x**2\012      t2 = exp(-t1)\012      t3 = t2**
2\012      t4 = t3*t2\012      t5 = a**2\012      t6 = t4*t5\012 \+
     t7 = y+t\012      t8 = cos(t7)\012      t9 = t8**2\012      \+
t11 = y-t\012      t12 = sin(t11)\012      t15 = t4*a\012      t1
6 = b**2\012      t18 = t12**2\012      t29 = t1*t4\012      t32 \+
= sin(t7)**2\012      t38 = cos(t11)**2\012      hessian = -8*t6*
t9*b*t12-8*t15*t8*t16*t18+16*t6*t9*b*t12*t1+1\\\0126*t15\012     \+
#*t8*t16*t18*t1+16*t29*t5*t32*b*t12+16*t29*t16*t38*a*t8\012"}}
{INP_R 38 0 "> "{TEXT 0 25 "C([hessian=h],optimized);"}}{OUT_R 39
 0 38{TEXT 2 479 "      t1 = x*x;\012      t2 = exp(-t1);\012    \+
  t3 = t2*t2;\012      t4 = t3*t2;\012      t5 = a*a;\012      t6
 = t4*t5;\012      t7 = y+t;\012      t8 = cos(t7);\012      t9 =
 t8*t8;\012      t11 = y-t;\012      t12 = sin(t11);\012      t15
 = t4*a;\012      t16 = b*b;\012      t18 = t12*t12;\012      t29
 = t1*t4;\012      t32 = pow(sin(t7),2.0);\012      t38 = pow(cos
(t11),2.0);\012      hessian = -8.0*t6*t9*b*t12-8.0*t15*t8*t16*t1
8+16.0*t6*t9*b*t1\\\0122*t1+16.0*\012t15*t8*t16*t18*t1+16.0*t29*t
5*t32*b*t12+16.0*t29*t16*t38*a*t8;\012"}}{COM_R 40 0{TEXT 1 0 ""}
}{COM_R 41 0{TEXT 1 115 "Here is another example of using Maple a
nd fortran.  Suppose we want to compute the inverse of a symbolic
 matrix M."}}{COM_R 42 0{TEXT 1 0 ""}}{INP_R 43 0 "> "{TEXT 0 32 
"M := array(1..3,1..3,symmetric):"}}{INP_R 44 0 "> "{TEXT 0 12 "M
[2,3] := 0:"}}{INP_R 45 0 "> "{TEXT 0 87 "M[1,1] := 18*cos(q3)*co
s(q2)*m30*p^2-sin(q3)^2*j30y+ sin(q3)^2*j30z-9*sin(q3)^2*m30*p^2"
}}{INP_R 46 0 "> "{TEXT 0 32 " + j10y+j30y+m10*p^2+18*m30*p^2:"}}
{INP_R 47 0 "> "{TEXT 0 86 "M[1,2] := 9*cos(q3)*cos(q2)*m30*p^2-s
in(q3)^2*j30y+ sin(q3)^2*j30z-9*sin(q3)^2*m30*p^2"}}{INP_R 48 0 "
> "{TEXT 0 17 "+ j30y+9*m30*p^2:"}}{INP_R 49 0 "> "{TEXT 0 37 "M[
1,3] := -9*sin(q3)*sin(q2)*m30*p^2:"}}{INP_R 50 0 "> "{TEXT 0 77 
"M[2,2] := -sin(q3)^2*j30y+sin(q3)^2*j30z- 9*sin(q3)^2*m30*p^2+j3
0y+9*m30*p^2:"}}{INP_R 51 0 "> "{TEXT 0 25 "M[3,3] := 9*m30*p^2+j
30x:"}}{INP_R 52 0 "> "{TEXT 0 9 "evalm(M);"}}{OUT_R 53 0 52{DAG 
(3n4\`MATRIX`,2[2,4[2,4+11*9(3n3\`cos`,2n3\`q3`j2x0001(3pC,2n3\`q
2`p11n3\`m30`p11n3\`p`j2x0002j2x0018*5(3n3\`sin`pEp1En4\`j30y`p11
i2x0001*5p23p1En4\`j30z`p11p11*7p23p1Ep19p11p1Cp1Ei2x0009n4\`j10y
`p11p28p11*5n3\`m10`p11p1Cp1Ep11*5p19p11p1Cp1Ep20+DpAj2x0009p22p2
Cp2Ep11p36p3Dp28p11p4Cp54+3*9p23p11(3p24p15p11p19p11p1Cp1Ep3D[2,4
p52+Bp22p2Cp2Ep11p36p3Dp28p11p4Cp54j2x0000[2,4p60p7B+5p4Cp54n4\`j
30x`p11}}{COM_R 54 0{TEXT 1 0 ""}}{COM_R 55 0{TEXT 1 267 "The fir
st strategy is to compute the symbolic inverse of the M matrix. M
aple can do it, but it is a huge expression.  We can try to simpl
ify and optimize this big expression but this approach becomes in
creasingly inefficient for larger matrices.  Here is what we get:
"}}{COM_R 56 0{TEXT 1 0 ""}}{INP_R 57 0 "> "{TEXT 0 24 "B := lina
lg[inverse](M):"}}{INP_R 58 0 "> "{TEXT 0 24 "fortran( B, optimiz
ed );"}}{OUT_R 59 0 58{TEXT 2 2114 "      t1 = sin(q3)\012      t
2 = t1**2\012      t3 = t2*j30y\012      t4 = t2*j30z\012      t5
 = t2*m30\012      t6 = p**2\012      t7 = t5*t6\012      t8 = m3
0*t6\012      t9 = t3-t4+9*t7-j30y-9*t8\012      t10 = 9*t8+j30x\
012      t12 = t6**2\012      t13 = t12*t6\012      t14 = m10*t13
\012      t15 = m30**2\012      t18 = j30y*t15*t12\012      t19 =
 t15*m30\012      t22 = t15*t12\012      t23 = t22*j30x\012      \+
t24 = j10y*j30y\012      t26 = t8*j30x\012      t28 = m10*t12\012
      t31 = t2**2\012      t32 = sin(q2)\012      t33 = t32**2\01
2      t34 = t31*t33\012      t38 = t19*t13\012      t40 = t2*t33
\012      t45 = t2*t15\012      t47 = j10y*t2\012      t54 = cos(
q3)\012      t55 = t54**2\012      t56 = cos(q2)\012      t57 = t
56**2\012      t58 = t55*t57\012      t60 = -81*t14*t15-81*t18+72
9*t2*t19*t13-81*t23-t24*j30x+9*t3*\\\012t26-9\012     #*t28*m30*j
30x-81*t34*t18+81*t34*t22*j30z-729*t34*t38+729*t40*\\\012t38+8\01
2     #1*t40*t18+9*t28*t3*m30+81*t14*t45-9*t47*j30z*m30*t6+81*t47
*t2\\\0122-9*t\012     #28*t4*m30+81*t58*t23\012      t61 = j10y*
m30\012      t62 = t6*j30x\012      t64 = j30y*m30\012      t69 =
 j30y*j30x\012      t75 = m10*t6\012      t76 = t3*j30x\012      \+
t78 = t64*t6\012      t83 = t4*j30x\012      t91 = -729*t38-9*t61
*t62-9*t28*t64+9*t47*t26-t47*j30z*j30x+t4\\\0127*t69\012     #+81
*t3*t22-81*t4*t22-9*t4*t26+729*t58*t38+t75*t76+9*t47*t78-t\\\0127
5*t6\012     #9+9*t28*t5*j30x-t75*t83+81*t45*t12*j30x-9*t64*t62-9
*t24*t8-81\\\012*j10y\012     #*t15*t12\012      t93 = 1/(t60+t91
)\012      t95 = t54*t56\012      t97 = 9*t95*t8-t3+t4-9*t7+j30y+
9*t8\012      t99 = t97*t10*t93\012      t104 = t1*t32*m30*t6*t9*
t93\012      t107 = t3*t8\012      t108 = t4*t8\012      t109 = t
45*t12\012      t111 = t61*t6\012      t113 = t28*m30\012      t1
16 = 162*t95*t22+18*t95*t26-9*t107-t76+9*t108+t83-81*t109-9\\\012
*t5*t\012     #62+9*t111+j10y*j30x+9*t78+t69+9*t113+t75*j30x+162*
t22+18*t26-\\\01281*t4\012     #0*t22\012      t121 = t97*t1*t32*
t8*t93\012      t130 = -81*t22-t24-t47*j30z+t47*j30y+9*t107+9*t47
*t8+9*t28*t5\\\012-9*t1\012     #08+t75*t3-t75*t4-9*t78+81*t109-9
*t113-9*t111-t75*j30y+81*t58*\\\012t22\012      B(1,1) = t9*t10*t
93\012      B(1,2) = t99\012      B(1,3) = 9*t104\012      B(2,1)
 = t99\012      B(2,2) = -t116*t93\012      B(2,3) = 9*t121\012  \+
    B(3,1) = 9*t104\012      B(3,2) = 9*t121\012      B(3,3) = t1
30*t93\012"}}{INP_R 60 0 "> "{TEXT 0 14 "readlib(cost):"}}{INP_R 
61 0 "> "{TEXT 0 18 "cost(optimize(B));"}}{OUT_R 62 0 61{DAG +Dn5
\`additions`j2x0078n6\`multiplications`j2x0181n5\`divisions`j2x00
01n5\`functions`j2x0004n5\`subscripts`j2x0009n5\`assignments`j2x0
066}}{COM_R 63 0{TEXT 1 0 ""}}{COM_R 64 0{TEXT 1 214 "The more cl
ever approach is to compute the inverse of the M matrix before as
signing the entries.  Since M is symmetric and M[2,3] = 0 we shou
ld specify those entries first.  This keeps the structure of the \+
inverse."}}{COM_R 65 0{TEXT 1 0 ""}}{INP_R 66 0 "> "{TEXT 0 32 "M
 := array(1..3,1..3,symmetric);"}}{OUT_R 67 0 66{DAG :3n3\`M`(3n4
\`array`,5n5\`symmetric`~3j2x0001j2x0003pC[2,1}}{INP_R 68 0 "> "
{TEXT 0 12 "M[2,3] := 0:"}}{INP_R 69 0 "> "{TEXT 0 24 "B := linal
g[inverse](M);"}}{OUT_R 70 0 69{DAG :3n3\`B`(3n4\`MATRIX`,2[2,4[2
,4*7b3n3\`M`,3j2x0002p11j2x0001b3pE,3j2x0003p19p14+7*7b3pE,3p14p1
4p14pDp14p16p14p14*5b3pE,3p14p11p11p16p14i2x0001*5b3pE,3p14p19p11
pDp14p33p33+3*7p2Bp14p16p14p1Dp33p33+3*7p36p14pDp14p1Dp33p33[2,4p
40*5+5*5p1Fp14p16p14p14*3p36p11p33p14p1Dp33*7p2Bp14p36p14p1Dp33[2
,4p49p64*5+5*5p1Fp14pDp14p14*3p2Bp11p33p14p1Dp33}}{COM_R 71 0
{TEXT 1 0 ""}}{COM_R 72 0{TEXT 1 72 "Now define the entries for M
[1,1], M[1,2] etc. and don't try to simplify"}}{COM_R 73 0{TEXT 1
 0 ""}}{INP_R 74 0 "> "{TEXT 0 88 " M[1,1] := 18*cos(q3)*cos(q2)*
m30*p^2-sin(q3)^2*j30y+ sin(q3)^2*j30z-9*sin(q3)^2*m30*p^2"}}
{INP_R 75 0 "> "{TEXT 0 31 "+ j10y+j30y+m10*p^2+18*m30*p^2:"}}
{INP_R 76 0 "> "{TEXT 0 86 "M[1,2] := 9*cos(q3)*cos(q2)*m30*p^2-s
in(q3)^2*j30y+ sin(q3)^2*j30z-9*sin(q3)^2*m30*p^2"}}{INP_R 77 0 "
> "{TEXT 0 17 "+ j30y+9*m30*p^2:"}}{INP_R 78 0 "> "{TEXT 0 37 "M[
1,3] := -9*sin(q3)*sin(q2)*m30*p^2:"}}{INP_R 79 0 "> "{TEXT 0 78 
" M[2,2] := -sin(q3)^2*j30y+sin(q3)^2*j30z- 9*sin(q3)^2*m30*p^2+j
30y+9*m30*p^2:"}}{INP_R 80 0 "> "{TEXT 0 26 " M[3,3] := 9*m30*p^2
+j30x:"}}{INP_R 81 0 "> "{TEXT 0 37 "B:=map(eval,B):fortran(B, op
timized);"}}{OUT_R 82 0 81{TEXT 2 814 "      t1 = sin(q3)\012    \+
  t2 = t1**2\012      t3 = t2*j30y\012      t4 = t2*j30z\012     \+
 t6 = p**2\012      t7 = t2*m30*t6\012      t8 = m30*t6\012      \+
t9 = -t3+t4-9*t7+j30y+9*t8\012      t10 = 9*t8+j30x\012      t15 \+
= cos(q3)*cos(q2)*t8\012      t17 = 18*t15-t3+t4-9*t7+j10y+j30y+m
10*t6+18*t8\012      t18 = t17*t9\012      t20 = 9*t15-t3+t4-9*t7
+j30y+9*t8\012      t21 = t20**2\012      t23 = sin(q2)\012      \+
t24 = t23**2\012      t25 = t2*t24\012      t26 = m30**2\012     \+
 t27 = t6**2\012      t28 = t26*t27\012      t32 = 1/(t18*t10-t21
*t10-81*t25*t28*t9)\012      t35 = t20*t10*t32\012      t40 = t1*
t23*m30*t6*t9*t32\012      t48 = t20*t1*t23*t8*t32\012      B(1,1
) = t9*t10*t32\012      B(1,2) = -t35\012      B(1,3) = 9*t40\012
      B(2,1) = -t35\012      B(2,2) = (t17*t10-81*t25*t28)*t32\01
2      B(2,3) = -9*t48\012      B(3,1) = 9*t40\012      B(3,2) = \+
-9*t48\012      B(3,3) = (t18-t21)*t32\012"}}{INP_R 83 0 "> "
{TEXT 0 18 "cost(optimize(B));"}}{OUT_R 84 0 83{DAG +Dn5\`additio
ns`j2x0023n6\`multiplications`j2x0053n5\`divisions`j2x0001n5\`fun
ctions`j2x0004n5\`subscripts`j2x0009n5\`assignments`j2x0033}}
{COM_R 85 0{TEXT 1 0 ""}}{COM_R 86 0{TEXT 1 245 "This is quite go
od.  But in general it is best to not even try to invert the matr
ix symbolically.  That should be done numerically.  Inverting a 3
 by 3 numerical matrix is easy.  So just generate Fortran code fo
r the contruction of the matrix M."}}{COM_R 87 0{TEXT 1 0 ""}}
{INP_R 88 0 "> "{TEXT 0 21 "fortran(M,optimized);"}}{OUT_R 89 0 
88{TEXT 2 464 "      t4 = p**2\012      t5 = m30*t4\012      t6 =
 cos(q3)*cos(q2)*t5\012      t7 = sin(q3)\012      t8 = t7**2\012
      t9 = t8*j30y\012      t10 = t8*j30z\012      t12 = t8*m30*t
4\012      t15 = 9*t6-t9+t10-9*t12+j30y+9*t5\012      t18 = t7*si
n(q2)*t5\012      M(1,1) = 18*t6-t9+t10-9*t12+j10y+j30y+m10*t4+18
*t5\012      M(1,2) = t15\012      M(1,3) = -9*t18\012      M(2,1
) = t15\012      M(2,2) = -t9+t10-9*t12+j30y+9*t5\012      M(2,3)
 = 0\012      M(3,1) = -9*t18\012      M(3,2) = 0\012      M(3,3)
 = 9*t5+j30x\012"}}{INP_R 90 0 "> "{TEXT 0 20 "cost( optimize(M) \+
);"}}{OUT_R 91 0 90{DAG +Bn5\`additions`j2x0017n6\`multiplication
s`j2x0023n5\`functions`j2x0004n5\`subscripts`j2x0009n5\`assignmen
ts`j2x0019}}{COM_R 92 0{TEXT 1 77 "We can save the output from bo
th fortran and C using the option filename=foo."}}{COM_R 93 0
{TEXT 1 1 " "}}{COM_R 94 0{TEXT 1 0 ""}}{COM_R 95 0{TEXT 1 0 ""}}
{COM_R 96 0{TEXT 1 243 "The Maple library latex and eqn conversio
n routines serve two useful purposes.  They provide foremost a wa
y of presenting the results of a Maple session, but they also wor
k pretty well as general purpose math interpreters for making doc
uments."}}{COM_R 97 0{TEXT 1 0 ""}}{COM_R 98 0{TEXT 1 52 "Here is
 an example using our previous expression e1."}}{COM_R 99 0{TEXT 
1 0 ""}}{INP_R 100 0 "> "{TEXT 0 10 "latex(e1);"}}{OUT_R 101 0 
100{TEXT 2 51 "\{e^\{-\{x\}^\{2\}\}\}\\left (a\\cos(y+t)+b\\sin(y
-t)\\right )\012"}}{COM_R 102 0{TEXT 1 0 ""}}{COM_R 103 0{TEXT 1 
231 "Notice that Maple has correctly backslashed the function nam
es that LaTeX knows how to print in Roman type. The latex command
 can also generate correct output for products, sums, polynomials
, and derivatives,  amongst other things."}}{COM_R 104 0{TEXT 1 0
 ""}}{INP_R 105 0 "> "{TEXT 0 63 "e2:=Int(Int(exp(x^2+y^2),x=-inf
inity..infinity),y=-Pi/2..zeta);"}}{OUT_R 106 0 105{DAG :3n3\`e2`
(3n3\`Int`,3(3p4,3(3n3\`exp`,2+5*3n3\`x`j2x0002j2x0001*3n3\`y`p12
p14=3p10~3+3n5\`infinity`i2x0001p1F=3p17~3+3n3\`Pi`/3p23p12n4\`ze
ta`}}{INP_R 107 0 "> "{TEXT 0 10 "latex(e2);"}}{OUT_R 108 0 107
{TEXT 2 97 "\\int _\{-\{\\frac \{\\pi \}\{2\}\}\}^\{\\zeta\}\\!\\
int _\{-\\infty \}^\{\012\\infty \}\\!\{e^\{\{x\}^\{2\}+\{y\}^\{2
\}\}\}\{dx\}\\,\{dy\}\012"}}{COM_R 109 0{TEXT 1 0 ""}}{COM_R 110 
0{TEXT 1 187 "Here latex  has correctly placed a \\! (a negative \+
thin space) between the integral signs to make the spacing more a
ppealing, and has also identified Pi and zeta as variables to bac
kslash."}}{COM_R 111 0{TEXT 1 1 " "}}{INP_R 112 0 "> "{TEXT 0 23 
"e3:=diff(f(x,y,z),x,y);"}}{OUT_R 113 0 112{DAG :3n3\`e3`(3n4\`di
ff`,3(3p4,3(3n3\`f`,4n3\`x`n3\`y`n3\`z`p11pF}}{INP_R 114 0 "> "
{TEXT 0 10 "latex(e3);"}}{OUT_R 115 0 114{TEXT 2 54 "\{\\frac \{\
\partial ^\{2\}\}\{\\partial y\\partial x\}\}f(x,y,z)\012"}}
{COM_R 116 0{TEXT 1 0 ""}}{COM_R 117 0{TEXT 1 101 "All the above \+
expressions could also have been converted into troff eqn output \+
using the eqn command."}}{COM_R 118 0{TEXT 1 0 ""}}{INP_R 119 0 "
> "{TEXT 0 13 "readlib(eqn);"}}{OUT_R 120 0 119{DAG @8,3~3n3\`e`n
5\`anything`~3n5\`filename`n4\`string`,4n3\`i`n4\`eqnlist`n4\`eqn
str`,2nD\`Copyright~`1993~`by~`Waterloo~`Maple~`Software`,1;6?4|3
|3(3n4\`type`,3a2x0001n4\`table`(3p2D,3p31n5\`procedure`(3p2D,3p3
1n4\`array`:3l2x0002[2,2(3n5\`eqn/print`,2(3n4\`eval`,2p31:3p46[2
,2(3p4Bp54?3<3j2x0001a2x0000;3(3n4\`readlib`,2n4\`write`(3n4\`ope
n`,2a2x0002:3l2x0003b3p46,2p5Ff7l2x0001j2x0002p5F(3n4\`nops`,2p46
n4\`true`?4<3j2x0070+5(3n4\`length`,2p74p5F(3p8F,2b3p46,2p7Bp5F;3
?4p5E(3n4\`writeln`p92(3n4\`lprint`p92:3p74p98:3p74.3.3n3\``p74p9
8?4p5E;3pA0(3n4\`close`p27pA5p27p27}{TEXT 2 42 "\012proc(e:anythi
ng,filename:string) ... end\012"}}{INP_R 121 0 "> "{TEXT 0 8 "eqn
(e1);"}}{OUT_R 122 0 121{TEXT 2 110 "\{\{e sup \{-^ \{  \"x\"  su
p 2 \}\}\}^\{( \{\{ \"a\" ^\{cos ( \{ \"y\" ^+^ \"t\" \})\}\}^\\\
012+^\{\012 \"b\" ^\{sin ( \{ \"y\" ^-^ \"t\" \})\}\}\} )\}\}\012
"}}{INP_R 123 0 "> "{TEXT 0 8 "eqn(e2);"}}{OUT_R 124 0 123{TEXT 2
 148 "\{int from \{\{-^  pi  over 2 \}\} to \{\{size 13 zeta\}\} \+
\{int from \{\{-^  i\\\012nf \012\}\} to \{ inf \} \{e sup \{\{  \+
\"x\"  sup 2 \}^+^\{  \"y\"  sup 2 \}\}\}~d \"x\" \}~d\012 \"y\" \+
\}\012"}}{INP_R 125 0 "> "{TEXT 0 8 "eqn(e3);"}}{OUT_R 126 0 125
{TEXT 2 63 "\{d over \{d \"x\" \}\{d over \{d \"y\" \}\{f ( \{ \"
x\" ,~ \"y\" ,~ \"z\" \})\}\}\}\012"}}{COM_R 127 0{TEXT 1 0 ""}}
{COM_R 128 0{TEXT 1 275 "Note that the troff output needs to be p
laced between .EQ or .EN lines, just as the LaTeX output needs to
 be placed in a math mode environment ($  $, \\[   \\] , etc).  B
oth latex and eqn output can be saved to a file by adding the fil
ename as the second argument, for example:"}}{COM_R 129 0{TEXT 1 
0 ""}}{INP_R 130 0 "> "{TEXT 0 21 "#latex(e1,`foo.tex`);"}}{INP_R
 131 0 "> "{TEXT 0 0 ""}}}{END}
