{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 8 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "
Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 9 "-adobe-times-bold-r-
normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bo
ld" 14}{FONT 10 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "
times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 11 "-adobe-time
s-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 
"Times-Bold" 14}{FONT 12 "-adobe-times-bold-r-normal--*-140-*-*-*
-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 13 "-a
dobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold"
 8 14 64 "Times-Bold" 14}{FONT 14 "-adobe-times-bold-r-normal--*-
140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 15 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" 
"Times-Bold" 8 14 64 "Times-Bold" 14}{SCP_R 1 0 196{COM_R 2 0
{TEXT 1 0 ""}}{COM_R 3 0{TEXT 15 38 "Solving Algebraic Equations \+
with Maple"}}{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}
{COM_R 6 0{TEXT 1 239 "This is a demonstration of Maple's ability
 to solve  algebraic equations - both isolated equations and syst
ems.  Many equations can be solved exactly by Maple, and Maple ha
s numerical methods for solving those it cannot solve symbolicall
y."}}{COM_R 7 0{TEXT 1 0 ""}}{COM_R 8 0{TEXT 1 76 "To start, let'
s take a look at a system of 5 linear equations in 5 unknowns."}}
{COM_R 9 0{TEXT 1 1 " "}}{INP_R 10 0 "> "{TEXT 0 39 "eqs1 := \{x \+
+ 2*y + 3*z + 4*t + 5*u = 6,"}}{INP_R 11 0 "> "{TEXT 0 32 "5*x + \+
5*y + 4*z + 3*t + 2*u = 1,"}}{INP_R 12 0 "> "{TEXT 0 26 "3*y + 4*
z - 8*t + 2*u = 1,"}}{INP_R 13 0 "> "{TEXT 0 22 "x + y + z + t + \+
u = 9,"}}{INP_R 14 0 "> "{TEXT 0 27 "8*x + 4*z + 3*t + 2*u = 1\};
"}}{OUT_R 15 0 14{DAG :3n4\`eqs1`%2,6=3+9n3\`y`j2x0003n3\`z`j2x00
04n3\`t`i2x0008n3\`u`j2x0002j2x0001=3+Bn3\`x`p18p8p16pCpAp10pEp14
j2x0005j2x0006=3+Bp1Cp26p8p26pCpEp10pAp14p16p18=3+9p1Cj2x0008pCpE
p10pAp14p16p18=3+Bp1Cp18p8p18pCp18p10p18p14p18j2x0009}}{INP_R 16 
0 "> "{TEXT 0 29 "a1:=solve(eqs1, \{x,y,z,t,u\});"}}{OUT_R 17 0 
16{DAG :3n3\`a1`%2,6=3n3\`t`/3i2x1736j2x0055=3n3\`z`/3i3x00013983
j2x0110=3n3\`x`j2x0056=3n3\`y`/3j2x0168j2x0005=3n3\`u`/3j2x8589p1
4}}{COM_R 18 0{TEXT 1 0 ""}}{COM_R 19 0{TEXT 1 152 "The answer is
 returned as a set of expressions.  This is a natural form for su
bstitution back into the original system.  Thus we can check the \+
solution:"}}{COM_R 20 0{TEXT 1 0 ""}}{INP_R 21 0 "> "{TEXT 0 14 "
subs(a1,eqs1);"}}{OUT_R 22 0 21{DAG %2,4=3j2x0009p3=3j2x0006p7=3j
2x0001pB}}{COM_R 23 0{TEXT 1 0 ""}}{COM_R 24 0{TEXT 1 161 "Maple'
s answer need not be just numerical.   For example, we can solve \+
a system of  3 linear equations in 3 unknowns with a fourth unkno
wn, non-linear parameter."}}{COM_R 25 0{TEXT 1 0 ""}}{INP_R 26 0 
"> "{TEXT 0 54 "eqs2:=\{(3*a^2+9)*x+(1-3*a^2)*y+(a^2-2*a-2)*z = -
7*a^2,"}}{INP_R 27 0 "> "{TEXT 0 47 "(7+4*a)*x+(-8*a^2+3+5*a)*y+2
*a*z = 9*a+4+2*a^2,"}}{INP_R 28 0 "> "{TEXT 0 47 "-5*a^2*x+(-3*a-
7*a^2)*y+(5-6*a)*z = 4-5*a-a^2\};"}}{OUT_R 29 0 28{DAG :3n4\`eqs2
`%2,4=3+7*5+5*3n3\`a`j2x0002j2x0003j2x0009j2x0001p13n3\`x`p13p13*
5+5p13p13pAi2x0003p13n3\`y`p13p13*5+7pAp13pBi2x0002p2Bp13p13n3\`z
`p13p13+3pAi2x0007=3+7*5+5j2x0007p13pBj2x0004p13p16p13p13*5+7pAi2
x0008pFp13pBj2x0005p13p22p13p13*5pBp13p30p13pD+7pBp11p40p13pApD=3
+7*5pBpDp16p13i2x0005*5+5pBp1FpAp36p13p22p13p13*5+5p4Ep13pBi2x000
6p13p30p13p13+7p40p13pBp68pAi2x0001}}{INP_R 30 0 "> "{TEXT 0 24 "
a2:=solve(eqs2,\{x,y,z\});"}}{OUT_R 31 0 30{DAG :3n3\`a2`%2,4=3n3
\`y`+3*5+F*3n3\`a`j2x0005i2x0293*3pCj2x0004j2x0224*3pCj2x0003i2x0
580*3pCj2x0002j2x0268pCi2x0127i2x0100j2x0001*3pCj2x0006j2x0040i2x
0001+Fj2x0124p29p2Bj2x0010pBj2x0061p12i2x0379p18i2x0292p1Ej2x0079
pCj2x0099p29p31=3n3\`z`+3*5+Fp2Bj2x0188pBj2x0228p12j2x0237p18j2x0
518p1Ej2x0041pCj2x0086p2Fp29p29pAp31i2x0002=3n3\`x`*5+Fp2Bj2x0022
pBj2x0524p12i2x0603p18i2x0181p1Ep31pCi2x0045i2x0004p29p29pAp31}}
{INP_R 32 0 "> "{TEXT 0 26 "map(normal,subs(a2,eqs2));"}}{OUT_R 
33 0 32{DAG %2,4=3+7j2x0004j2x0001n3\`a`i2x0005*3p8j2x0002i2x0001
p3=3+7p8j2x0009p4p6pCpEp14=3+3pCi2x0007p1E}}{COM_R 34 0{TEXT 1 0 
""}}{COM_R 35 0{TEXT 1 42 "Maple can also solve non-linear equati
ons."}}{COM_R 36 0{TEXT 1 0 ""}}{INP_R 37 0 "> "{TEXT 0 21 "eqn3:
=cos(x) + y = 9;"}}{OUT_R 38 0 37{DAG :3n4\`eqn3`=3+5(3n3\`cos`,2
n3\`x`j2x0001n3\`y`pCj2x0009}}{INP_R 39 0 "> "{TEXT 0 14 "solve(e
qn3,x);"}}{OUT_R 40 0 39{DAG +5n3\`Pi`j2x0001(3n4\`arccos`,2+5n3\
`y`p3i2x0009p3i2x0001}}{INP_R 41 0 "> "{TEXT 0 20 "eqn4 := 2^u + \+
G = 0;"}}{OUT_R 42 0 41{DAG :3n4\`eqn4`=3+5^3j2x0002n3\`u`j2x0001
n3\`G`pBj2x0000}}{INP_R 43 0 "> "{TEXT 0 14 "solve(eqn4,u);"}}
{OUT_R 44 0 43{DAG *5(3n3\`ln`,2+3n3\`G`i2x0001j2x0001(3p2,2j2x00
02p8}}{COM_R 45 0{TEXT 1 0 ""}}{COM_R 46 0{TEXT 1 101 "This next \+
problem is a third degree polynomial.  Maple returns a sequence o
f exact radical solutions."}}{COM_R 47 0{TEXT 1 0 ""}}{INP_R 48 0
 "> "{TEXT 0 28 "eqn3:=x^3-54*x^2+972*x-5839;"}}{OUT_R 49 0 48
{DAG :3n4\`eqn3`+9*3n3\`x`j2x0003j2x0001*3p6j2x0002i2x0054p6j2x09
72i2x5839pA}}{INP_R 50 0 "> "{TEXT 0 14 "solve(eqn3,x);"}}{OUT_R 
51 0 50{DAG ,4+5*3j2x0007/3j2x0001j2x0003p6j2x0018p6+7p2/3i2x0001
j2x0002pBp6*7n3\`I`p6p8/3p6p13p3p5p1C+7p2p10pBp6p17p10}}{COM_R 52
 0{TEXT 1 0 ""}}{COM_R 53 0{TEXT 1 317 "For fourth and higher deg
ree polynomials, Maple uses a RootOf representation for the roots
.  In general, there is no closed form solution of fifth degree a
nd higher order polynomials.  Even though all fourth order polyno
mials can be solved exactly, it is often notationally convenient \+
to represent the roots this way."}}{COM_R 54 0{TEXT 1 0 ""}}
{INP_R 55 0 "> "{TEXT 0 22 "eqn4:=x^5+3*x^2-2*x-1;"}}{OUT_R 56 0 
55{DAG :3n4\`eqn4`+9*3n3\`x`j2x0005j2x0001*3p6j2x0002j2x0003p6i2x
0002i2x0001pA}}{INP_R 57 0 "> "{TEXT 0 18 "a4:=solve(eqn4,x);"}}
{OUT_R 58 0 57{DAG :3n3\`a4`(3n4\`RootOf`,2+9*3n3\`_Z`j2x0005j2x0
001*3pAj2x0002j2x0003pAi2x0002i2x0001pE}}{COM_R 59 0{TEXT 1 0 ""}
}{COM_R 60 0{TEXT 1 208 "We can access these roots by using the f
unction allvalues.   The long output shows why the RootOf notatio
n is used.  When Maple cannot find a closed form solution to the \+
RootOf, it returns a numerical answer."}}{COM_R 61 0{TEXT 1 1 " "
}}{INP_R 62 0 "> "{TEXT 0 20 "s4:=[allvalues(a4)];"}}{OUT_R 63 0 
62{DAG :3n3\`s4`[2,6e3i4x001569778412i2x0009e3i4x003343775377i2x0
010+5e3j4x005194892704p11j2x0001n3\`I`e3i4x001390014884pA+5p14p1A
p1Ce3j4x001390014884pAe3j4x008651774091p11}}{COM_R 64 0{TEXT 1 0 
""}}{COM_R 65 0{TEXT 1 72 "Maple can also solve some non-linear s
ystems of equations.  For example:"}}{COM_R 66 0{TEXT 1 0 ""}}
{INP_R 67 0 "> "{TEXT 0 48 "eqs5 := \{2*x*y = 1, x + a*z = 0, 2*x
 - 3*z = a\};"}}{OUT_R 68 0 67{DAG :3n4\`eqs5`%2,4=3+3*5n3\`x`j2x
0001n3\`y`pBj2x0002pB=3+5p9pB*5n3\`a`pBn3\`z`pBpBj2x0000=3+5p9p10
p1Bi2x0003p18}}{INP_R 69 0 "> "{TEXT 0 20 "solve(eqs5,\{x,y,z\});
"}}{OUT_R 70 0 69{DAG %2,4=3n3\`x`*5n3\`a`j2x0002+5j2x0003j2x0001
p6p8i2x0001=3n3\`y`+3*5pApDp6i2x0002/3pDp8=3n3\`z`+3*5p6pDpAp11p1
1}}{COM_R 71 0{TEXT 1 0 ""}}{COM_R 72 0{TEXT 1 163 "In this next \+
case, there are multiple solutions (this is obvious since the equ
ations are symmetric in the unknowns), and Maple returns a sequen
ce of solution sets."}}{COM_R 73 0{TEXT 1 0 ""}}{INP_R 74 0 "> "
{TEXT 0 33 "eqs6:=\{x   + y   + z   + w   = 6,"}}{INP_R 75 0 "> "
{TEXT 0 28 " x^2 + y^2 + z^2 + w^2 = 14,"}}{INP_R 76 0 "> "{TEXT 
0 28 " x^3 + y^3 + z^3 + w^3 = 36,"}}{INP_R 77 0 "> "{TEXT 0 29 "
 x^4 + y^4 + z^4 + w^4 = 98\};"}}{OUT_R 78 0 77{DAG :3n4\`eqs6`%2
,5=3+9*3n3\`x`j2x0004j2x0001*3n3\`y`pBpD*3n3\`z`pBpD*3n3\`w`pBpDj
2x0098=3+9*3p9j2x0003pD*3p10p24pD*3p15p24pD*3p1Ap24pDj2x0036=3+9*
3p9j2x0002pD*3p10p39pD*3p15p39pD*3p1Ap39pDj2x0014=3+9p9pDp10pDp15
pDp1ApDj2x0006}}{INP_R 79 0 "> "{TEXT 0 22 "solve(eqs6,\{w,x,y,z\
});"}}{OUT_R 80 0 79{DAG ,19%2,5=3n3\`x`j2x0003=3n3\`y`j2x0000=3n
3\`z`j2x0001=3n3\`w`j2x0002%2,5p3p8=3pEp15=3p13p10%2,5p8p1B=3p13p
6=3p4p10%2,5p8p12p28=3pEp6%2,5p8pDp25=3p4p15%2,5p8p1Ep38p30%2,5=3
p4pBp1B=3p9p10p25%2,5p43p47p12p30%2,5=3pEpBp47p25p38%2,5p47=3p13p
Bp38p30%2,5p3p53p47p12%2,5p3p1Bp47p5C%2,5p43=3p9p15pDp25%2,5p43p7
0p1Ep30%2,5p43=3p9p6pDp12%2,5p43p7Ep1Bp1E%2,5p53p7Ep12p28%2,5p7Ep
1Bp28p5C%2,5p53p7Ep1Ep38%2,5p7EpDp5Cp38%2,5p53p70p25p28%2,5p70p28
p5Cp30%2,5p3p53p70p1E%2,5p3p70pDp5C}}{COM_R 81 0{TEXT 1 0 ""}}
{COM_R 82 0{TEXT 1 62 "In this next example, Maple cannot find a \+
symbolic solution.  "}}{COM_R 83 0{TEXT 1 1 " "}}{INP_R 84 0 "> "
{TEXT 0 37 "eqn7:=exp(x*ln(18/10+x))+13/10*x-7=0;"}}{OUT_R 85 0 
84{DAG :3n4\`eqn7`=3+7(3n3\`exp`,2*5n3\`x`j2x0001(3n3\`ln`,2+5/3j
2x0009j2x0005pDpBpDpDpDpB/3j2x0013j2x0010i2x0007pDj2x0000}}{INP_R
 86 0 "> "{TEXT 0 18 "a7:=solve(eqn7,x);"}}{OUT_R 87 0 86{DAG :3n
3\`a7`,1}}{COM_R 88 0{TEXT 1 0 ""}}{COM_R 89 0{TEXT 1 100 "When t
his happens, Maple returns no output.  However, we can find a num
erical solution using fsolve."}}{COM_R 90 0{TEXT 1 0 ""}}{INP_R 
91 0 "> "{TEXT 0 19 "a7:=fsolve(eqn7,x);"}}{OUT_R 92 0 91{DAG :3n
3\`a7`e3j4x001408842218i2x0009}}{COM_R 93 0{TEXT 1 0 ""}}{COM_R 
94 0{TEXT 1 59 "This solution can be computed to as many digits a
s desired."}}{COM_R 95 0{TEXT 1 0 ""}}{INP_R 96 0 "> "{TEXT 0 11 
"Digits:=30:"}}{INP_R 97 0 "> "{TEXT 0 20 "a7:= fsolve(eqn7,x);"}
}{OUT_R 98 0 97{DAG :3n3\`a7`e3j9x0014088422178020567955736660883
4i2x0029}}{INP_R 99 0 "> "{TEXT 0 11 "Digits:=10:"}}{INP_R 100 0 
"> "{TEXT 0 23 "evalf(subs(x=a7,eqn7));"}}{OUT_R 101 0 100{DAG =3
j2x0000p1}}{COM_R 102 0{TEXT 1 0 ""}}{COM_R 103 0{TEXT 1 269 "Lik
e solve, fsolve can be used to find the roots of a polynomial.  I
n general, fsolve finds a single real root.  The exception is for
 polynomials (where it tries to find all real roots). When the op
tion complex is given, it looks for solutions over then complex d
omain."}}{COM_R 104 0{TEXT 1 0 ""}}{INP_R 105 0 "> "{TEXT 0 44 " \+
eqn8 := 3*x^4 - 16*x^3 - 3*x^2 + 13*x + 16;"}}{OUT_R 106 0 105
{DAG :3n4\`eqn8`+B*3n3\`x`j2x0004j2x0003*3p6pAi2x0016*3p6j2x0002i
2x0003p6j2x0013j2x0016j2x0001}}{INP_R 107 0 "> "{TEXT 0 29 "a8:=\
{fsolve(eqn8,x,complex)\};"}}{OUT_R 108 0 107{DAG :3n3\`a8`%2,5+5
e3i4x006623589786i2x0010j2x0001n3\`I`e3j4x005622795121pBe3j4x0013
24717957i2x0009e3j4x005333333333p1C+5p6pDpFe3i4x005622795121pB}}
{INP_R 109 0 "> "{TEXT 0 40 "for y in a8 do evalf(subs(x=y,eqn8))
 od;"}}{OUT_R 110 0 109{DAG +3n3\`I`e3j2x0002i2x0009}}{OUT_R 111 
0 109{DAG j2x0000}}{OUT_R 112 0 109{DAG e3j2x0001i2x0008}}{OUT_R 
113 0 109{DAG +3n3\`I`e3i2x0002i2x0009}}{COM_R 114 0{TEXT 1 0 ""}
}{COM_R 115 0{TEXT 1 117 "The last two examples here are larges s
ystems from outside sources where Maple has easily computed the c
orrect answer"}}{COM_R 116 0{TEXT 1 0 ""}}{COM_R 117 0{TEXT 1 160
 "This first example is a system of non-linear equations from SIG
SAM, the Special Interest Group for Symbolic Algebraic Manipulati
ons.  Maple finds two solutions."}}{COM_R 118 0{TEXT 1 0 ""}}
{INP_R 119 0 "> "{TEXT 0 71 "eqs8 := \{2*d3*b3+d5*b3+d3*b5, d5*b3
+2*d5*b5+d3*b5, d5*b5, d2*b2, d4*b4,"}}{INP_R 120 0 "> "{TEXT 0 
46 "d5*b1+b5+d4*b3+d3*b4, d5*b3+d5*b5+d3*b5+d3*b3,"}}{INP_R 121 0
 "> "{TEXT 0 36 "d0*b2+b2+d4*b2+d2*b4+c2+d2*b0+d2*b1,"}}{INP_R 
122 0 "> "{TEXT 0 57 "d0*b0+d0*b1+d0*b4+d3*b2+b0+b1+b4+d4*b0+d4*b
1+d2*b5+d4*b4+"}}{INP_R 123 0 "> "{TEXT 0 21 "c1+c4+d5*b2+d2*b3+c
0,"}}{INP_R 124 0 "> "{TEXT 0 75 "-1+d3*b0+d0*b3+d0*b5+d5*b0+b3+b
5+d5*b4+d4*b3+d4*b5+d3*b4+d5*b1+d3*b1+c3+c5,"}}{INP_R 125 0 "> "
{TEXT 0 58 "b4+d4*b1, d5*b3+d3*b5, d2*b1+b2, d4*b5+d5*b4, d2*b4+d
4*b2,"}}{INP_R 126 0 "> "{TEXT 0 52 "d0*b5+d5*b0+d3*b4+2*d5*b4+d5
*b1+b5+d4*b3+2*d4*b5+c5,"}}{INP_R 127 0 "> "{TEXT 0 44 "d4*b0+2*d
4*b4+d2*b5+b4+d4*b1+d5*b2+d0*b4+c4,"}}{INP_R 128 0 "> "{TEXT 0 49
 "c3+d0*b3+2*b3+b5+d4*b3+d3*b0+2*d3*b1+d5*b1+d3*b4,"}}{INP_R 129 
0 "> "{TEXT 0 39 "c1+d0*b1+2*b1+d4*b1+d2*b3+b0+d3*b2+b4\};"}}
{OUT_R 130 0 129{DAG :3n4\`eqs8`%2,14+7*5n3\`d5`j2x0001n3\`b3`pAp
A*5p8pAn3\`b5`pAj2x0002*5n3\`d3`pAp13pApA+7*5p19pApCpAp16p7pAp18p
A+1Fi2x0001pA*5p19pAn3\`b0`pApA*5n3\`d0`pApCpApA*5p36pAp13pApA*5p
8pAp31pApApCpAp13pA*5p8pAn3\`b4`pApA*5n3\`d4`pApCpApA*5p54pAp13pA
pA*5p19pAp4FpApA*5p8pAn3\`b1`pApA*5p19pAp69pApAn3\`c3`pAn3\`c5`pA
+21*5p36pAp31pApA*5p36pAp69pApA*5p36pAp4FpApA*5p19pAn3\`b2`pApAp3
1pAp69pAp4FpA*5p54pAp31pApA*5p54pAp69pApA*5n3\`d2`pAp13pApA*5p54p
Ap4FpApAn3\`c1`pAn3\`c4`pA*5p8pAp8FpApA*5pA6pApCpApAn3\`c0`pA+9p7
pAp10pAp18pAp20pA+F*5p36pAp8FpApAp8FpA*5p54pAp8FpApA*5pA6pAp4FpAp
An3\`c2`pA*5pA6pAp31pApA*5pA6pAp69pApA+9p66pAp13pAp53pAp60pA*5pA6
pAp8FpApAC+11pB2pAp80pAp69p16p9FpApBEpAp31pAp8CpAp4FpAp10+11p99pA
pACp16pA5pAp4FpAp9FpApB8pAp86pApB5pA+13p73pAp35pApCp16p13pAp53pAp
2EpAp6Dp16p66pAp60pA+13p3CpAp42pAp60pAp4Cp16p66pAp13pAp53pAp5Ap16
p76pA+5pDFpApD9pA+5p4FpAp9FpA+5p7pAp18pA+5pEEpAp8FpA+5p5ApAp4CpA}
}{INP_R 131 0 "> "{TEXT 0 20 "sols := solve(eqs8);"}}{OUT_R 132 0
 131{DAG :3n4\`sols`,4%2,12=3n3\`d4`j2x0000=3n3\`d5`pA=3n3\`b1`pA
=3n3\`d3`pA=3n3\`d2`p19=3n3\`d0`p1D=3n3\`b0`p21=3n3\`c1`+5p19j2x0
001p21i2x0001=3n3\`c4`pA=3n3\`b4`pA=3n3\`b2`pA=3n3\`c0`+3*5p1Dp29
p21p29p2C=3n3\`b3`p2C=3n3\`b5`pA=3n3\`c3`+5p1Dp29j2x0002p29=3n3\`
c5`pA=3n3\`c2`+3*5p19p29p21p29p2C%2,12=3p3B+5p3Ep2Cp11p29p7pC=3p1
9pAp14=3p11p11p1Cp20=3p25+7*5p1Dp29p11p29p2Cp11i2x0002p21p2C=3p5A
pAp2Ep32p36p44p48p4Cp55%2,12p7pC=3p11+3*3p15p2Cp2Cp6E=3p15p15=3p2
5*5+7p1Dp29p52p29*5p15p29p21p29p2Cp29p15p2Cp1Cp20=3p45pA=3p4D+5p5
2p29pA6p2C=3p3B+3*5+5*7p1Dp29p21p29p15p29p29p29p29p29p15p2Cp2Cp85
p2Ep32p36p48p55}}{COM_R 133 0{TEXT 1 0 ""}}{COM_R 134 0{TEXT 1 
303 "Finally, our last example comes from  Stanly Steinberg.  It \+
arises from the computation of a truncated power series solution \+
to a differential equation. It is presented with 189 equations, a
lthough several are repeated.  Once the repetitions are removed, \+
the system is of 147 equations with 49 unknowns."}}{COM_R 135 0
{TEXT 1 0 ""}}{INP_R 136 0 "> "{TEXT 0 7 "eqs9:=\{"}}{INP_R 137 0
 "> "{TEXT 0 55 " -b*k8/a+c*k8/a, -b*k11/a+c*k11/a, -b*k10/a+c*k1
0/a+k2,"}}{INP_R 138 0 "> "{TEXT 0 55 " -k3-b*k9/a+c*k9/a, -b*k14
/a+c*k14/a, -b*k15/a+c*k15/a,"}}{INP_R 139 0 "> "{TEXT 0 60 " -b*
k18/a+c*k18/a-k2, -b*k17/a+c*k17/a, -b*k16/a+c*k16/a+k4,"}}{INP_R
 140 0 "> "{TEXT 0 48 " -b*k13/a+c*k13/a-b*k21/a+c*k21/a+b*k5/a-c
*k5/a,"}}{INP_R 141 0 "> "{TEXT 0 54 "  b*k44/a-c*k44/a, -b*k45/a
+c*k45/a, -b*k20/a+c*k20/a,"}}{INP_R 142 0 "> "{TEXT 0 35 " -b*k4
4/a+c*k44/a, b*k46/a-c*k46/a,"}}{INP_R 143 0 "> "{TEXT 0 40 "  b^
2*k47/a^2-2*b*c*k47/a^2+c^2*k47/a^2,"}}{INP_R 144 0 "> "{TEXT 0 
42 "  k3, -k4, -b*k12/a+c*k12/a-a*k6/b+c*k6/b,"}}{INP_R 145 0 "> \+
"{TEXT 0 49 " -b*k19/a+c*k19/a+a*k7/c-b*k7/c, b*k45/a-c*k45/a,"}}
{INP_R 146 0 "> "{TEXT 0 54 " -b*k46/a+c*k46/a, -k48+c*k48/a+c*k4
8/b-c^2*k48/(a*b),"}}{INP_R 147 0 "> "{TEXT 0 51 " -k49+b*k49/a+b
*k49/c-b^2*k49/(a*c), a*k1/b-c*k1/b,"}}{INP_R 148 0 "> "{TEXT 0 
54 "  a*k4/b-c*k4/b, a*k3/b-c*k3/b+k9, -k10+a*k2/b-c*k2/b,"}}
{INP_R 149 0 "> "{TEXT 0 57 "  a*k7/b-c*k7/b, -k9, k11, b*k12/a-c
*k12/a+a*k6/b-c*k6/b,"}}{INP_R 150 0 "> "{TEXT 0 39 "  a*k15/b-c*
k15/b, k10+a*k18/b-c*k18/b,"}}{INP_R 151 0 "> "{TEXT 0 39 " -k11+
a*k17/b-c*k17/b, a*k16/b-c*k16/b,"}}{INP_R 152 0 "> "{TEXT 0 48 "
 -a*k13/b+c*k13/b+a*k21/b-c*k21/b+a*k5/b-c*k5/b,"}}{INP_R 153 0 "
> "{TEXT 0 35 " -a*k44/b+c*k44/b, a*k45/b-c*k45/b,"}}{INP_R 154 0
 "> "{TEXT 0 51 "  a*k14/c-b*k14/c+a*k20/b-c*k20/b, a*k44/b-c*k44
/b,"}}{INP_R 155 0 "> "{TEXT 0 54 " -a*k46/b+c*k46/b, -k47+c*k47/
a+c*k47/b-c^2*k47/(a*b),"}}{INP_R 156 0 "> "{TEXT 0 53 "  a*k19/b
-c*k19/b, -a*k45/b+c*k45/b, a*k46/b-c*k46/b,"}}{INP_R 157 0 "> "
{TEXT 0 40 "  a^2*k48/b^2-2*a*c*k48/b^2+c^2*k48/b^2,"}}{INP_R 158
 0 "> "{TEXT 0 47 " -k49+a*k49/b+a*k49/c-a^2*k49/(b*c), k16, -k17
,"}}{INP_R 159 0 "> "{TEXT 0 52 " -a*k1/c+b*k1/c, -k16-a*k4/c+b*k
4/c, -a*k3/c+b*k3/c,"}}{INP_R 160 0 "> "{TEXT 0 51 "  k18-a*k2/c+
b*k2/c, b*k19/a-c*k19/a-a*k7/c+b*k7/c,"}}{INP_R 161 0 "> "{TEXT 0
 54 " -a*k6/c+b*k6/c, -a*k8/c+b*k8/c, -a*k11/c+b*k11/c+k17,"}}
{INP_R 162 0 "> "{TEXT 0 38 " -a*k10/c+b*k10/c-k18, -a*k9/c+b*k9/
c,"}}{INP_R 163 0 "> "{TEXT 0 34 " -a*k14/c+b*k14/c-a*k20/b+c*k20
/b,"}}{INP_R 164 0 "> "{TEXT 0 48 " -a*k13/c+b*k13/c+a*k21/c-b*k2
1/c-a*k5/c+b*k5/c,"}}{INP_R 165 0 "> "{TEXT 0 54 "  a*k44/c-b*k44
/c, -a*k45/c+b*k45/c, -a*k44/c+b*k44/c,"}}{INP_R 166 0 "> "{TEXT 
0 54 "  a*k46/c-b*k46/c, -k47+b*k47/a+b*k47/c-b^2*k47/(a*c),"}}
{INP_R 167 0 "> "{TEXT 0 53 " -a*k12/c+b*k12/c, a*k45/c-b*k45/c, \+
-a*k46/c+b*k46/c,"}}{INP_R 168 0 "> "{TEXT 0 36 " -k48+a*k48/b+a*
k48/c-a^2*k48/(b*c),"}}{INP_R 169 0 "> "{TEXT 0 55 "  a^2*k49/c^2
-2*a*b*k49/c^2+b^2*k49/c^2, k8, k11, -k15,"}}{INP_R 170 0 "> "
{TEXT 0 55 "  k10-k18, -k17, k9, -k16, -k29, k14-k32, -k21+k23-k3
1,"}}{INP_R 171 0 "> "{TEXT 0 55 " -k24-k30, -k35, k44, -k45, k36
, k13-k23+k39, -k20+k38,"}}{INP_R 172 0 "> "{TEXT 0 53 "  k25+k37
, b*k26/a-c*k26/a-k34+k42, -2*k44, k45, k46,"}}{INP_R 173 0 "> "
{TEXT 0 52 "  b*k47/a-c*k47/a, k41, k44, -k46, -b*k47/a+c*k47/a,"
}}{INP_R 174 0 "> "{TEXT 0 53 "  k12+k24, -k19-k25, -a*k27/b+c*k2
7/b-k33, k45, -k46,"}}{INP_R 175 0 "> "{TEXT 0 50 " -a*k48/b+c*k4
8/b, a*k28/c-b*k28/c+k40, -k45, k46,"}}{INP_R 176 0 "> "{TEXT 0 
53 "  a*k48/b-c*k48/b, a*k49/c-b*k49/c, -a*k49/c+b*k49/c,"}}
{INP_R 177 0 "> "{TEXT 0 51 " -k1, -k4, -k3, k15, k18-k2, k17, k1
6, k22, k25-k7,"}}{INP_R 178 0 "> "{TEXT 0 57 "  k24+k30, k21+k23
-k31, k28, -k44, k45, -k30-k6, k20+k32,"}}{INP_R 179 0 "> "{TEXT 
0 57 "  k27+b*k33/a-c*k33/a, k44, -k46, -b*k47/a+c*k47/a, -k36,"}
}{INP_R 180 0 "> "{TEXT 0 57 "  k31-k39-k5, -k32-k38, k19-k37, k2
6-a*k34/b+c*k34/b-k42,"}}{INP_R 181 0 "> "{TEXT 0 57 "  k44, -2*k
45, k46, a*k48/b-c*k48/b, a*k35/c-b*k35/c-k41,"}}{INP_R 182 0 "> \+
"{TEXT 0 57 " -k44, k46, b*k47/a-c*k47/a, -a*k49/c+b*k49/c, -k40,
 k45,"}}{INP_R 183 0 "> "{TEXT 0 58 " -k46, -a*k48/b+c*k48/b, a*k
49/c-b*k49/c, k1, k4, k3, -k8,"}}{INP_R 184 0 "> "{TEXT 0 63 " -k
11, -k10+k2, -k9, k37+k7, -k14-k38, -k22, -k25-k37, -k24+k6,"}}
{INP_R 185 0 "> "{TEXT 0 59 " -k13-k23+k39, -k28+b*k40/a-c*k40/a,
 k44, -k45, -k27, -k44,"}}{INP_R 186 0 "> "{TEXT 0 59 "  k46, b*k
47/a-c*k47/a, k29, k32+k38, k31-k39+k5, -k12+k30,"}}{INP_R 187 0 
"> "{TEXT 0 59 "  k35-a*k41/b+c*k41/b, -k44, k45, -k26+k34+a*k42/
c-b*k42/c,"}}{INP_R 188 0 "> "{TEXT 0 55 "  k44, k45, -2*k46, -b*
k47/a+c*k47/a, -a*k48/b+c*k48/b,"}}{INP_R 189 0 "> "{TEXT 0 51 " \+
 a*k49/c-b*k49/c, k33, -k45, k46, a*k48/b-c*k48/b,"}}{INP_R 190 0
 "> "{TEXT 0 20 " -a*k49/c+b*k49/c \}:"}}{INP_R 191 0 "> "{TEXT 0
 75 "vars9 := \{k1, k2, k3, k4, k5, k6, k7, k8, k9, k10, k11, k12
, k13, k14, k15,"}}{INP_R 192 0 "> "{TEXT 0 72 "   k16, k17, k18,
 k19, k20, k21, k22, k23, k24, k25, k26, k27, k28, k29,"}}{INP_R 
193 0 "> "{TEXT 0 72 "   k30, k31, k32, k33, k34, k35, k36, k37, \+
k38, k39, k40, k41, k42, k43,"}}{INP_R 194 0 "> "{TEXT 0 33 "   k
44, k45, k46, k47, k48, k49\}:"}}{INP_R 195 0 "> "{TEXT 0 18 "sol
ve(eqs9,vars9);"}}{OUT_R 196 0 195{DAG %2,32=3n3\`k22`j2x0000=3n3
\`k17`p5=3n3\`k35`p5=3n3\`k2`p5=3n3\`k5`p5=3n3\`k10`p5=3n3\`k38`p
5=3n3\`k13`p5=3n3\`k21`p5=3n3\`k23`n3\`k39`=3n3\`k25`p5=3n3\`k18`
p5=3n3\`k37`p5=3n3\`k31`p2A=3n3\`k42`*7n3\`c`j2x0001n3\`k26`p42n3
\`a`i2x0001=3n3\`k34`*7n3\`b`p42p44p42p47p49=3n3\`k20`p5=3n3\`k47
`p5=3n3\`k12`p5=3n3\`k6`p5=3n3\`k19`p5=3n3\`k7`p5=3n3\`k48`p5=3n3
\`k49`p5=3n3\`k32`p5=3n3\`k24`p5=3p2Ap2A=3p44p44=3n3\`k43`p85=3n3
\`k40`p5=3n3\`k14`p5=3n3\`k16`p5=3n3\`k4`p5=3n3\`k44`p5=3n3\`k45`
p5=3n3\`k46`p5=3n3\`k29`p5=3n3\`k36`p5=3n3\`k41`p5=3n3\`k33`p5=3n
3\`k28`p5=3n3\`k1`p5=3n3\`k9`p5=3n3\`k3`p5=3n3\`k11`p5=3n3\`k8`p5
=3n3\`k15`p5=3n3\`k27`p5=3n3\`k30`p5}}{INP_R 197 0 "> "{TEXT 0 0 
""}}}{END}
