{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 2 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-120-*-*-m-*-*-*" "Cou
rier" "Courier" 4 12 192 "Courier" 12}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 8 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "
Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 9 "-adobe-times-bold-r-
normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bo
ld" 14}{FONT 10 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "
times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 11 "-adobe-time
s-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 
"Times-Bold" 14}{FONT 12 "-adobe-times-bold-r-normal--*-140-*-*-*
-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 13 "-a
dobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold"
 8 14 64 "Times-Bold" 14}{FONT 14 "-adobe-times-bold-r-normal--*-
140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 15 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" 
"Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 16 "-adobe-times-bold-
r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-
Bold" 14}{SCP_R 1 0 138{COM_R 2 0{TEXT 1 0 ""}}{COM_R 3 0{TEXT 16
 23 "More Solvers with Maple"}}{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0
{TEXT 1 0 ""}}{COM_R 6 0{TEXT 1 233 "Maple has a variety of equat
ion solvers.  This worksheet is an overview of some of Maple's le
sser known solve commands.  The algebraic equation solver and the
 ordinary differential equation solvers are discussed in other wo
rksheets. "}}{COM_R 7 0{TEXT 1 0 ""}}{COM_R 8 0{TEXT 1 148 "Close
ly related to differential equations are recurrence equations.  F
or example, this sequence and initial conditions define the fibon
acci numbers."}}{COM_R 9 0{TEXT 1 0 ""}}{INP_R 10 0 "> "{TEXT 0 
54 "eq1 := \{f(n+2) = f(n+1) + f(n) , f(0) = 1 , f(1) = 1\};"}}
{OUT_R 11 0 10{DAG :3n3\`eq1`%2,4=3(3n3\`f`,2j2x0001pA=3(3p7,2j2x
0000pA=3(3p7,2+5n3\`n`pAj2x0002pA+5(3p7,2+5p19pApApApA(3p7,2p19pA
}}{INP_R 12 0 "> "{TEXT 0 18 "a1:=rsolve(eq1,f);"}}{OUT_R 13 0 12
{DAG :3n3\`a1`+5*7j2x0005/3j2x0001j2x0002^3+3*3+5i2x0001p8*3p5p7p
8p10pAn3\`n`p8pFp10/3pAp5*7p5p7^3+3*3+5p8p8p13p8p10i2x0002p19p8p2
7p10p1E}}{INP_R 14 0 "> "{TEXT 0 30 "normal(subs(n=7,a1),expanded
);"}}{OUT_R 15 0 14{DAG j2x0021}}{COM_R 16 0{TEXT 1 0 ""}}{COM_R 
17 0{TEXT 1 62 "Here is another example, this time without initia
l conditions."}}{COM_R 18 0{TEXT 1 0 ""}}{INP_R 19 0 "> "{TEXT 0 
32 "eq2 := f(n) = a*f(n-1) + f(n-2);"}}{OUT_R 20 0 19{DAG :3n3\`e
q2`=3(3n3\`f`,2n3\`n`+5*5n3\`a`j2x0001(3p5,2+5p8pEi2x0001pEpEpE(3
p5,2+5p8pEi2x0002pEpE}}{INP_R 21 0 "> "{TEXT 0 14 "rsolve(eq2,f);
"}}{OUT_R 22 0 21{DAG +5*9+B*5n3\`a`j2x0001(3n3\`f`,2p6p6i2x0001*
5p4j2x0002(3p9,2j2x0000p6p6*5+5*3p4p12p6j2x0004p6/3p6p12p8p6p6*7p
1Cp24p4p6p14p6pEp14p12p6p1C/3pEp12^3+3*3+5*3p1Cp24pEp4p6pEi2x0002
n3\`n`p6p3CpEpE*9+Bp3pEp10p6p1BpEp2Ap6p14p12p6p1Cp36^3+3*3+5p4p6p
3Dp6pEp44p46p6p5EpEp6}}{COM_R 23 0{TEXT 1 0 ""}}{COM_R 24 0{TEXT 
1 54 "Maple can even solve \"divide and conquer\" recurrences:"}}
{COM_R 25 0{TEXT 1 0 ""}}{INP_R 26 0 "> "{TEXT 0 29 "eq4 := s(n) \+
= 3*s(n/2) + 5*n;"}}{OUT_R 27 0 26{DAG :3n3\`eq4`=3(3n3\`s`,2n3\`
n`+5(3p5,2+3p8/3j2x0001j2x0002j2x0003p8j2x0005}}{INP_R 28 0 "> "
{TEXT 0 14 "rsolve(eq4,s);"}}{OUT_R 29 0 28{DAG +5*5(3n3\`s`,2j2x
0001p6^3n3\`n`*5(3n3\`ln`,2j2x0003p6(3pE,2j2x0002i2x0001p6p6*5p9p
6+5^3/3p17p11+5*5(3pE,2pAp6p14p19p6p6p6i2x0015j2x0010p6p6p6}}
{COM_R 30 0{TEXT 1 0 ""}}{COM_R 31 0{TEXT 1 85 "Maple's linear al
gebra package has a function for solving system of linear equatio
ns."}}{COM_R 32 0{TEXT 1 0 ""}}{INP_R 33 0 "> "{TEXT 0 13 "with(l
inalg):"}}{OUT_R 34 0 33{TEXT 2 71 "Warning: new definition for  \+
 norm\012Warning: new definition for   trace\012"}}{INP_R 35 0 ">
 "{TEXT 0 92 "A := matrix([[-85, -55, -37, -35], [97, 50, 79, 56]
, [49, 63, 57, -59], [45, -8, -93, 92]]);"}}{OUT_R 36 0 35{DAG :3
n3\`A`(3n4\`MATRIX`,2[2,5[2,5i2x0085i2x0055i2x0037i2x0035[2,5j2x0
097j2x0050j2x0079j2x0056[2,5j2x0049j2x0063j2x0057i2x0059[2,5j2x00
45i2x0008i2x0093j2x0092}}{INP_R 37 0 "> "{TEXT 0 39 "b := matrix(
[[43], [-62], [77], [66]]);"}}{OUT_R 38 0 37{DAG :3n3\`b`(3n4\`MA
TRIX`,2[2,5[2,2j2x0043[2,2i2x0062[2,2j2x0077[2,2j2x0066}}{COM_R 
39 0{TEXT 1 0 ""}}{COM_R 40 0{TEXT 1 68 "First we can perform for
ward elimination using the gauselim command."}}{COM_R 41 0{TEXT 1
 0 ""}}{INP_R 42 0 "> "{TEXT 0 33 "C := gausselim( concat(A,b), 4
 );"}}{OUT_R 43 0 42{DAG :3n3\`C`(3n4\`MATRIX`,2[2,5[2,6i2x0085i2
x0055i2x0037i2x0035j2x0043[2,6j2x0000/3i2x0217j2x0017/3j2x3126j2x
0085/3j2x0273p1D/3i2x1099p22[2,6p18p18/3j3x00019504j2x0155/3i2x12
34j2x0031/3j3x00010864p34[2,6p18p18p18/3i3x00031663j2x0742/3j3x00
013178j2x0053}}{INP_R 44 0 "> "{TEXT 0 46 "x:=linsolve(submatrix(
C,1..4,1..4), col(C,5));"}}{OUT_R 45 0 44{DAG :3n3\`x`(3n4\`VECTO
R`,2[2,5/3j3x13019547j3x01456498/3i3x07299476j3x00728249/3i3x0187
3417pE/3i3x00184492j3x00031663}}{COM_R 46 0{TEXT 1 0 ""}}{COM_R 
47 0{TEXT 1 39 "Now check that our solution is correct."}}{COM_R 
48 0{TEXT 1 0 ""}}{INP_R 49 0 "> "{TEXT 0 20 "evalm( A &* x - b )
;"}}{OUT_R 50 0 49{DAG (3n4\`MATRIX`,2[2,5[2,2j2x0000p7p7p7}}
{COM_R 51 0{TEXT 1 0 ""}}{COM_R 52 0{TEXT 1 67 "Here is an underd
etermined example that results in free parameters."}}{COM_R 53 0
{TEXT 1 0 ""}}{INP_R 54 0 "> "{TEXT 0 78 "A := matrix([[-68, -36,
 0, 0, 90], [0, 0, 81, 0, 0], [-90, -79, 0, -92, 0], [0"}}{INP_R 
55 0 "> "{TEXT 0 37 ", 0, -24, 0, 0], [-58, 0, 0, 0, 0]]);"}}
{OUT_R 56 0 55{DAG :3n3\`A`(3n4\`MATRIX`,2[2,6[2,6i2x0068i2x0036j
2x0000p10j2x0090[2,6p10p10j2x0081p10p10[2,6i2x0090i2x0079p10i2x00
92p10[2,6p10p10i2x0024p10p10[2,6i2x0058p10p10p10p10}}{INP_R 57 0 
"> "{TEXT 0 17 "b := vector(5,0);"}}{OUT_R 58 0 57{DAG :3n3\`b`(3
n4\`VECTOR`,2[2,6j2x0000pApApApA}}{INP_R 59 0 "> "{TEXT 0 33 "C :
= gausselim( concat(A,b), 5 );"}}{OUT_R 60 0 59{DAG :3n3\`C`(3n4\
`MATRIX`,2[2,6[2,7i2x0068i2x0036j2x0000p10j2x0090p10[2,7p10/3i2x0
533j2x0017p10i2x0092/3i2x2025p1Cp10[2,7p10p10j2x0081p10p10p10[2,7
p10p10p10/3i3x00048024j2x0533/3i3x00103095p38p10[2,7p10p10p10p10p
10p10}}{INP_R 61 0 "> "{TEXT 0 50 "x := linsolve( submatrix(C,1..
5,1..5), col(C,6) );"}}{OUT_R 62 0 61{DAG :3n3\`x`(3n4\`VECTOR`,2
[2,6j2x0000+3b3n3\`_t`,2j2x0001/3j2x0005j2x0002pA+3pD/3i2x0395j2x
0184pD}}{COM_R 63 0{TEXT 1 0 ""}}{COM_R 64 0{TEXT 1 104 "This las
t example using linsolve comes from a problem posed on the Intern
et newsgroup sci.math.symbolic."}}{COM_R 65 0{TEXT 1 0 ""}}{INP_R
 66 0 "> "{TEXT 0 25 "z1:= b*(b-1)/(a+1)/(a+2);"}}{OUT_R 67 0 66
{DAG :3n3\`z1`*9n3\`b`j2x0001+5p4p6i2x0001p6p6+5n3\`a`p6p6p6pB+5p
10p6j2x0002p6pB}}{INP_R 68 0 "> "{TEXT 0 13 "z2:= b/(a+1);"}}
{OUT_R 69 0 68{DAG :3n3\`z2`*5n3\`b`j2x0001+5n3\`a`p6p6p6i2x0001}
}{INP_R 70 0 "> "{TEXT 0 7 "z3:= 1;"}}{OUT_R 71 0 70{DAG :3n3\`z3
`j2x0001}}{INP_R 72 0 "> "{TEXT 0 13 "z4:= a/(b+1);"}}{OUT_R 73 0
 72{DAG :3n3\`z4`*5n3\`a`j2x0001+5n3\`b`p6p6p6i2x0001}}{INP_R 74 
0 "> "{TEXT 0 25 "z5:= a*(a-1)/(b+1)/(b+2);"}}{OUT_R 75 0 74{DAG 
:3n3\`z5`*9n3\`a`j2x0001+5p4p6i2x0001p6p6+5n3\`b`p6p6p6pB+5p10p6j
2x0002p6pB}}{INP_R 76 0 "> "{TEXT 0 80 "m:=array([[0,z1*z1,2*z1*z
2,2*z1*z3+z2*z2,2*z1*z4+2*z2*z3,2*z1*z5+2*z2*z4+z3*z3],"}}{INP_R 
77 0 "> "{TEXT 0 55 "[-z1*z1,0,z2*z2,2*z2*z3,2*z2*z4+z3*z3,2*z2*z
5+2*z3*z4],"}}{INP_R 78 0 "> "{TEXT 0 48 "[-2*z1*z2,-z2*z2,0,z3*z
3,2*z3*z4,2*z3*z5+z4*z4],"}}{INP_R 79 0 "> "{TEXT 0 49 "[-2*z1*z3
-z2*z2,-2*z2*z3,-z3*z3,0,z4*z4,2*z4*z5],"}}{INP_R 80 0 "> "{TEXT 
0 58 "[-2*z1*z4-2*z2*z3,-2*z2*z4-z3*z3,-2*z3*z4,-z4*z4,0,z5*z5],"
}}{INP_R 81 0 "> "{TEXT 0 77 "[-2*z1*z5-2*z2*z4-z3*z3,-2*z2*z5-2*
z3*z4,-2*z3*z5-z4*z4,-2*z4*z5,-z5*z5,0]]):"}}{INP_R 82 0 "> "
{TEXT 0 36 "linsolve(m,array([1,-1,1,-1,1,-1]));"}}{OUT_R 83 0 82
{DAG (3n4\`VECTOR`,2[2,7+Bj2x0001p8n3\`a`j2x0003*3pBj2x0002/3j2x0
013j2x0004*3pBp16/3p8p16*3pBpD/3pDp11+13*5n3\`b`p8pBpDi2x0001p26i
2x0002*5p26p8pBp11i2x0004*5p26p8pBp8i2x0005p2Bp8p1E/3p8p11pBp2Ep1
8p1BpF/3i2x0003p16+15*5p26p11pBp8/3j2x0007p11*5p26p11pBp11p21*3p2
6p11p11p26pDp30/3p2Bp11p37p53p25p2Bp1Ep2Bp8p8pFp2E+15*3p26pDp2B*5
p26pDpBp8p2Bp4Ep64p57p21p5Dp2Ep30p53p37p53pBpDpFp11p8p8+13pBp2Ep3
7p3Cp4Ep35p76p2B*3p26p16p1Bp72p41p5Dp49p26p2Ep2Bp8+Bp95p1Bp72p21p
5Dp13p26pDp8p8}}{COM_R 84 0{TEXT 1 0 ""}}{COM_R 85 0{TEXT 1 65 "M
aple has a solver for polynomial equations using Groebner bases."
}}{COM_R 86 0{TEXT 1 0 ""}}{COM_R 87 0{TEXT 1 67 "First, make up \+
the test equations and express these as polynomials."}}{COM_R 88 
0{TEXT 1 0 ""}}{INP_R 89 0 "> "{TEXT 0 7 "N := 3:"}}{INP_R 90 0 "
> "{TEXT 0 13 "for i to N do"}}{INP_R 91 0 "> "{TEXT 0 49 " e.i :
= sum('(-1)^(j+1)*x.j^(i+1)',j=1..N) = -1/2"}}{INP_R 92 0 "> "
{TEXT 0 3 "od;"}}{OUT_R 93 0 92{DAG :3n3\`e1`=3+7*3n3\`x1`j2x0002
j2x0001*3n3\`x2`p8i2x0001*3n3\`x3`p8pA/3p10p8}}{OUT_R 94 0 92{DAG
 :3n3\`e2`=3+7*3n3\`x1`j2x0003j2x0001*3n3\`x2`p8i2x0001*3n3\`x3`p
8pA/3p10j2x0002}}{OUT_R 95 0 92{DAG :3n3\`e3`=3+7*3n3\`x1`j2x0004
j2x0001*3n3\`x2`p8i2x0001*3n3\`x3`p8pA/3p10j2x0002}}{INP_R 96 0 "
> "{TEXT 0 45 "polys := map(a -> lhs(a)-rhs(a), \{e.(1..N)\});"}}
{OUT_R 97 0 96{DAG :3n4\`polys`%2,4+9*3n3\`x1`j2x0002j2x0001*3n3\
`x2`pAi2x0001*3n3\`x3`pApC/3pCpApC+9*3p8j2x0003pC*3pFp20p12*3p15p
20pCp19pC+9*3p8j2x0004pC*3pFp30p12*3p15p30pCp19pC}}{COM_R 98 0
{TEXT 1 0 ""}}{COM_R 99 0{TEXT 1 39 "Now find a Groebner basis fo
r this set."}}{COM_R 100 0{TEXT 1 0 ""}}{INP_R 101 0 "> "{TEXT 0 
14 "with(grobner):"}}{INP_R 102 0 "> "{TEXT 0 26 "soln := op(gsol
ve(polys));"}}{OUT_R 103 0 102{DAG :3n4\`soln`[2,4+1Bn3\`x1`j3x00
035316*3n3\`x3`j2x0011i3x03586048*3pDj2x0008j3x00363072*3pDj2x000
6j3x00216384*3pDj2x0009i3x03163456*3pDj2x0010j3x03107840pDj3x0001
2369*3pDj2x0002j3x00135048*3pDj2x0003j3x00088600*3pDj2x0004i3x004
50416i3x00013515j2x0001*3pDj2x0005j3x00310720*3pDj2x0007i3x011591
04+1Bp14j3x02541504i3x00147579p4CpCi3x05011456p1Bj3x02268096p22i3
x05192512p29j3x07691264n3\`x2`j3x00176580pDj2x4179p34j3x00144840p
3Bi3x00168524p42i3x00625856p4Ei3x00257840p55i3x01803936+17p14j2x3
264pCi2x6144p1Bj2x0800p3Dp4C*3pDj2x0012j2x4096p22i2x4096p29j2x652
8p34j2x0054p3Bi2x0128p42i2x0048p55i2x2304}}{COM_R 104 0{TEXT 1 0 
""}}{COM_R 105 0{TEXT 1 154 "Note that now equations 1 and 2 can \+
now be trivially solved for x1 and x2 in terms of x3.  Thus the p
roblem is reduced to finding the roots of equation 3."}}{COM_R 
106 0{TEXT 1 0 ""}}{INP_R 107 0 "> "{TEXT 0 27 "s1 := solve(soln[
1], \{x1\});"}}{OUT_R 108 0 107{DAG :3n3\`s1`%2,2=3n3\`x1`+19*3n3
\`x3`j2x0008/3i3x00030256j2x2943*3pAj2x0011/3j3x00896512j2x8829*3
pAj2x0006/3i3x00018032p12*3pAj2x0009/3j3x00790864p1C*3pAj2x0010/3
i3x00776960p1CpA/3i2x4123j3x00011772*3pAj2x0002/3i3x00011254p12*3
pAj2x0003/3i3x00022150p1C*3pAj2x0004/3j3x00112604p1C/3j2x4505p3Dj
2x0001*3pAj2x0005/3i3x00077680p1C*3pAj2x0007/3j3x00096592p12}}
{INP_R 109 0 "> "{TEXT 0 27 "s2 := solve(soln[2], \{x2\});"}}
{OUT_R 110 0 109{DAG :3n3\`s2`%2,2=3n3\`x2`+19*3n3\`x3`j2x0008/3i
3x00211792j3x00014715/3j3x00049193j3x00058860j2x0001*3pAj2x0011/3
j3x01252864j3x00044145*3pAj2x0006/3i3x00189008p12*3pAj2x0009/3j3x
01298128p26*3pAj2x0010/3i3x01922816p26pA/3i2x1393p19*3pAj2x0002/3
i2x2414j2x2943*3pAj2x0003/3j3x00042131p26*3pAj2x0004/3j3x00156464
p26*3pAj2x0005/3j3x00012892j2x8829*3pAj2x0007/3j3x00150328p12}}
{INP_R 111 0 "> "{TEXT 0 27 "s3 := solve(soln[3], \{x3\});"}}
{OUT_R 112 0 111{DAG :3n3\`s3`%2,2=3n3\`x3`(3n4\`RootOf`,2+17*3n3
\`_Z`j2x0008j2x3264*3pFj2x0011i2x6144*3pFj2x0006j2x0800j2x0003j2x
0001*3pFj2x0012j2x4096*3pFj2x0009i2x4096*3pFj2x0010j2x6528*3pFj2x
0002j2x0054*3pFp21i2x0128*3pFj2x0004i2x0048*3pFj2x0007i2x2304}}
{COM_R 113 0{TEXT 1 0 ""}}{COM_R 114 0{TEXT 1 136 "This last resu
lt is Maple's RootOf notation for an arbitrary root of a polynomi
al.  Indeed, in this case, the polynomial is irreducible."}}
{COM_R 115 0{TEXT 1 0 ""}}{INP_R 116 0 "> "{TEXT 0 17 "irreduc(so
ln[3]);"}}{OUT_R 117 0 116{DAG n4\`true`}}{COM_R 118 0{TEXT 1 0 "
"}}{COM_R 119 0{TEXT 1 114 "We can get a value for these roots (s
ymbolic if Maple can determine it, floating point otherwise) usin
g allvalues."}}{COM_R 120 0{TEXT 1 0 ""}}{INP_R 121 0 "> "{TEXT 0
 17 "r:=allvalues(s3);"}}{OUT_R 122 0 121{DAG :3n3\`r`,D%2,2=3n3\
`x3`+5e3i4x003816277105i2x0010j2x0001n3\`I`e3i4x002549807846pF%2,
2=3p7+5pAp11p13e3j4x002549807846pF%2,2=3p7+5e3i4x003292057423pFp1
1p13e3i4x007049782291pF%2,2=3p7+5p2Ep11p13e3j4x007049782291pF%2,2
=3p7+5e3i4x004007218834i2x0011p11p13e3i4x002065963542pF%2,2=3p7+5
p4Fp11p13e3j4x002065963542pF%2,2=3p7+5e3j4x004329920674pFp11p13e3
i4x005536602221pF%2,2=3p7+5p71p11p13e3j4x005536602221pF%2,2=3p7+5
e3j4x005051070559pFp11p13e3i4x007561897614pF%2,2=3p7+5p92p11p13e3
j4x007561897614pF%2,2=3p7+5e3j4x005628065179pFp11p13e3i4x00261572
3814p54%2,2=3p7+5pB3p11p13e3j4x002615723814p54}}{COM_R 123 0{TEXT
 1 0 ""}}{COM_R 124 0{TEXT 1 85 "We can now use any one of these \+
values to compute a set of roots.  Let's verify r[1]."}}{COM_R 
125 0{TEXT 1 0 ""}}{INP_R 126 0 "> "{TEXT 0 9 "a3:=r[1];"}}{OUT_R
 127 0 126{DAG :3n3\`a3`%2,2=3n3\`x3`+5e3i4x003816277105i2x0010j2
x0001n3\`I`e3i4x002549807846pE}}{INP_R 128 0 "> "{TEXT 0 16 "a1:=
subs(a3,s1);"}}{OUT_R 129 0 128{DAG :3n3\`a1`%2,2=3n3\`x1`+5e3i4x
003816277109i2x0010j2x0001n3\`I`e3j4x002549807844pE}}{INP_R 130 0
 "> "{TEXT 0 16 "a2:=subs(a3,s2);"}}{OUT_R 131 0 130{DAG :3n3\`a2
`%2,2=3n3\`x2`+5e3j4x008131721943i2x0010j2x0001n3\`I`e3j2x0062i2x
0012}}{COM_R 132 0{TEXT 1 0 ""}}{COM_R 133 0{TEXT 1 30 "Now check
 the original system."}}{COM_R 134 0{TEXT 1 0 ""}}{INP_R 135 0 ">
 "{TEXT 0 57 "fnormal(evalc( subs(a1 union a2 union a3, [e1,e2,e3
]) ));"}}{OUT_R 136 0 135{DAG [2,4=3e3i4x004999999994i2x0010e3i4x
005000000000p8=3e3i4x004999999998p8pA=3e3i4x004999999997p8pA}}
{COM_R 137 0{TEXT 1 0 ""}}{COM_R 138 0{TEXT 1 57 "This is correct
 to usual floating point round off error.\015"}}{INP_R 139 0 "> "
{TEXT 0 0 ""}}}{END}
