{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-120-*-*-*-*-*-*" "helvetica" "Helvetica-Bol
d" 8 12 0 "Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-norm
al--*-120-*-*-*-*-*-*" "times" "Times-Roman" 4 12 64 "Times-Roman
" 12}{FONT 2 "-*-Courier-medium-r-normal--*-140-*-*-m-*-*-*" "Cou
rier" "Courier" 4 14 192 "Courier" 14}{FONT 3 "-adobe-symbol-medi
um-r-normal--17-*" "symbol" "Times-Roman" 4 12 64 "Times-Roman" 
17}{FONT 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 6 
"-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bo
ld" 8 14 64 "Times-Bold" 14}{FONT 7 "-adobe-times-bold-r-normal--
*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 8 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "
Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 9 "-adobe-times-bold-r-
normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bo
ld" 14}{FONT 10 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "
times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 11 "-adobe-time
s-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 
"Times-Bold" 14}{FONT 12 "-adobe-times-bold-r-normal--*-140-*-*-*
-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 13 "-a
dobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold"
 8 14 64 "Times-Bold" 14}{FONT 14 "-adobe-times-bold-r-normal--*-
140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-Bold" 14}
{FONT 15 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*" "times" 
"Times-Bold" 8 14 64 "Times-Bold" 14}{FONT 16 "-adobe-times-bold-
r-normal--*-140-*-*-*-*-*-*" "times" "Times-Bold" 8 14 64 "Times-
Bold" 14}{FONT 17 "-adobe-times-bold-r-normal--*-140-*-*-*-*-*-*"
 "times" "Times-Bold" 8 14 64 "Times-Bold" 14}{SCP_R 1 0 100
{COM_R 2 0{TEXT 1 0 ""}}{COM_R 3 0{TEXT 17 28 "Special Functions \+
with Maple"}}{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}
{COM_R 6 0{TEXT 1 236 "Maple knows about a wealth of special func
tions.  Aside from floating point evaluation, Maple can integrate
, differentiate, expand as series, and manipulate many of these f
unctions.  This is a demonstration of some of Maple's knowledge."
}}{COM_R 7 0{TEXT 1 0 ""}}{COM_R 8 0{TEXT 1 117 " To start, Maple
 knows about normal and modified Bessel functions.  The former ar
e the solution to the following ODE."}}{COM_R 9 0{TEXT 1 0 ""}}
{INP_R 10 0 "> "{TEXT 0 56 "eq1:=x^2*diff(y(x),x$2)+x*diff(y(x),x
)+(x^2-p^2)*y(x)=0;"}}{OUT_R 11 0 10{DAG :3n3\`eq1`=3+7*5n3\`x`j2
x0002(3n4\`diff`,3(3pB,3(3n3\`y`,2p6p6p6j2x0001p19*5p6p19pFp19p19
*5+5*3p6p8p19*3n3\`p`p8i2x0001p19p12p19p19j2x0000}}{INP_R 12 0 ">
 "{TEXT 0 21 "a1:=dsolve(eq1,y(x));"}}{OUT_R 13 0 12{DAG :3n3\`a1
`=3(3n3\`y`,2n3\`x`+5*5n3\`_C1`j2x0001(3n4\`BesselJ`,3n3\`p`p8pEp
E*5n3\`_C2`pE(3n4\`BesselY`p14pEpE}}{COM_R 14 0{TEXT 1 0 ""}}
{COM_R 15 0{TEXT 1 211 "BesselJ is the Bessel function of the fir
st kind while BesselY is the Bessel function of the second kind. \+
 Maple knows how to differentiate these functions and we can  sub
stitute our solutions  back into the DE."}}{COM_R 16 0{TEXT 1 0 "
"}}{INP_R 17 0 "> "{TEXT 0 21 "diff(BesselJ(p,x),x);"}}{OUT_R 18 
0 17{DAG +5(3n4\`BesselJ`,3+5n3\`p`j2x0001p9p9n3\`x`i2x0001*7p7p9
pDpF(3p2,3p7pDp9p9}}{INP_R 19 0 "> "{TEXT 0 27 "normal(eval(subs(
a1,eq1)));"}}{OUT_R 20 0 19{DAG =3j2x0000p1}}{COM_R 21 0{TEXT 1 0
 ""}}{COM_R 22 0{TEXT 1 86 "Maple also knows about the modified B
essel functions.  These are solutions to the ODE "}}{COM_R 23 0
{TEXT 1 0 ""}}{INP_R 24 0 "> "{TEXT 0 56 "eq2:=x^2*diff(y(x),x$2)
+x*diff(y(x),x)-(x^2-p^2)*y(x)=0;"}}{OUT_R 25 0 24{DAG :3n3\`eq2`
=3+7*5n3\`x`j2x0002(3n4\`diff`,3(3pB,3(3n3\`y`,2p6p6p6j2x0001p19*
5p6p19pFp19p19*5+5*3p6p8p19*3n3\`p`p8i2x0001p19p12p19p2Cj2x0000}}
{INP_R 26 0 "> "{TEXT 0 17 "dsolve(eq2,y(x));"}}{OUT_R 27 0 26
{DAG =3(3n3\`y`,2n3\`x`+5*5n3\`_C1`j2x0001(3n4\`BesselI`,3*5n3\`I
`pBn3\`p`pBp5pBpB*5n3\`_C2`pB(3n4\`BesselK`p11pBpB}}{COM_R 28 0
{TEXT 1 0 ""}}{COM_R 29 0{TEXT 1 266 "Maple can find a Puiseux se
ries expansion for these functions, and it can also expand them a
bout their pole at infinity.  Here we have to specify the order o
f the function (in this case 2/3) since the form of the series is
 different for functions with integer order."}}{COM_R 30 0{TEXT 1
 0 ""}}{INP_R 31 0 "> "{TEXT 0 25 "series(BesselK(2/3,x),x);"}}
{OUT_R 32 0 31{DAG +F*7j2x0002/3p2j2x0003(3n4\`GAMMA`,2p4j2x0001n
3\`x`/3i2x0002p6/3pEp2*Bn3\`Pi`pEp2/3pEp6p8i2x0001p6p16p10p4/3p22
j2x0004*7p2p4p8pEp10/3p2Ap6/3p6j2x0008*Bp1ApEp2p1Ep8p22p6p16p10/3
p37p6/3i2x0003j2x0080*7p2p4p8pEp10/3j2x0010p6/3j2x0009j2x0256*Bp1
ApEp2p1Ep8p22p6p16p10/3j2x0014p6/3i2x0009j2x5120(3n3\`O`,2*3p10j2
x0006pE}}{INP_R 33 0 "> "{TEXT 0 27 "series(BesselK(2/3,1/x),x);"
}}{OUT_R 34 0 33{DAG +F*9j2x0002/3j2x0001p2n3\`Pi`p4(3n3\`exp`,2+
3*3n3\`x`i2x0001p13p5p11p4p4*9p2p4p8p4pBp5p11/3j2x0003p2/3j2x0007
j2x0144*9p2p4p8p4pBp5p11/3j2x0005p2/3i2x0455j3x00020736*9p2p4p8p4
pBp5p11/3p27p2/3j3x00095095j3x04478976*9p2p4p8p4pBp5p11/3j2x0009p
2/3i3x40415375j4x001289945088*9p2p4p8p4pBp5p11/3j2x0011p2/3j4x005
763232475j4x092876046336(3n3\`O`,2*3p11/3j2x0013p2p5}}{COM_R 35 0
{TEXT 1 0 ""}}{COM_R 36 0{TEXT 1 146 "Another example of  a speci
al function that Maple knows as the solution to a differential eq
uation is Gauss's generalized hypergeometric equation."}}{COM_R 
37 0{TEXT 1 0 ""}}{INP_R 38 0 "> "{TEXT 0 66 "eq4:=x*(1-x)*diff(y
(x),x,x)+(c-(a+b+1)*x)*diff(y(x),x)-a*b*y(x)=0;"}}{OUT_R 39 0 38
{DAG :3n3\`eq4`=3+7*7n3\`x`j2x0001+5p8p8p6i2x0001p8(3n4\`diff`,3(
3p12,3(3n3\`y`,2p6p6p6p8p8*5+5n3\`c`p8*5+7n3\`a`p8n3\`b`p8p8p8p8p
6p8pEp8p16p8p8*7p29p8p2Cp8p19p8pEj2x0000}}{INP_R 40 0 "> "{TEXT 0
 17 "dsolve(eq4,y(x));"}}{OUT_R 41 0 40{DAG =3(3n3\`y`,2n3\`x`+5*
5n3\`_C1`j2x0001(3n5\`hypergeom`,4[2,3n3\`a`n3\`b`[2,2n3\`c`p5pBp
B*7n3\`_C2`pB^3p5+5pBpBp1Bi2x0001pB(3pE,4[2,3+7p17pBp1Bp2ApBpB+7p
15pBp1Bp2ApBpB[2,2+5j2x0002pBp1Bp2Ap5pBpB}}{COM_R 42 0{TEXT 1 0 "
"}}{COM_R 43 0{TEXT 1 136 "Maple's notation here is that the firs
t list is the set of numerator coefficients and the second is the
 set of denominator coefficients."}}{COM_R 44 0{TEXT 1 0 ""}}
{COM_R 45 0{TEXT 1 127 "Maple knows that the hypergeometric funct
ion simplifies to other more common  functions as a special case \+
of some coefficients."}}{COM_R 46 0{TEXT 1 0 ""}}{INP_R 47 0 "> "
{TEXT 0 19 "hypergeom([],[],x);"}}{OUT_R 48 0 47{DAG (3n3\`exp`,2
n3\`x`}}{INP_R 49 0 "> "{TEXT 0 23 "hypergeom([1,b],[b],x);"}}
{OUT_R 50 0 49{DAG +3*3+5i2x0001j2x0001n3\`x`p5p3p3}}{INP_R 51 0 
"> "{TEXT 0 25 "hypergeom([-p,b],[b],-x);"}}{OUT_R 52 0 51{DAG ^3
+5j2x0001p2n3\`x`p2n3\`p`}}{INP_R 53 0 "> "{TEXT 0 24 "hypergeom(
[1,1],[2],-x);"}}{OUT_R 54 0 53{DAG *5n3\`x`i2x0001(3n3\`ln`,2+5j
2x0001pAp1pApA}}{INP_R 55 0 "> "{TEXT 0 32 "hypergeom([1/2,1],[3/
2],-(x)^2);"}}{OUT_R 56 0 55{DAG +3*5+3*3n3\`x`j2x0002i2x0001/3p8
p6(3n3\`ln`,2*5+5j2x0001p13*3p2/3p13p6p13p13+5p13p13p16p8p8p13p18
}}{COM_R 57 0{TEXT 1 0 ""}}{COM_R 58 0{TEXT 1 71 "In all cases, M
aple can expand the hypergeometric function as a series."}}{COM_R
 59 0{TEXT 1 0 ""}}{INP_R 60 0 "> "{TEXT 0 33 "series(hypergeom([
a,b],[c],x),x);"}}{OUT_R 61 0 60{DAG _10n3\`x`j2x0001x0*7n3\`a`p3
n3\`b`p3n3\`c`i2x0001x1+3*Dp7p3pAp3pDpF+5p7p3p3p3p3+5pAp3p3p3p3+5
pDp3p3p3pF/3p3j2x0002x2+3*13p7p3pAp3pDpFp1Ap3p20p3p26pF+5p7p3p2Ep
3p3+5pAp3p2Ep3p3+5pDp3p2Ep3pF/3p3j2x0006x3+3*19p7p3pAp3pDpFp1Ap3p
20p3p26pFp3Fp3p45p3p4BpF+5p7p3j2x0003p3p3+5pAp3p6Dp3p3+5pDp3p6Dp3
pF/3p3j2x0024x4+3*1Fp7p3pAp3pDpFp1Ap3p20p3p26pFp3Fp3p45p3p4BpFp6A
p3p71p3p77pF+5p7p3j2x0004p3p3+5pAp3p9Fp3p3+5pDp3p9Fp3pF/3p3j2x012
0x5(3n3\`O`,2p3x6}}{COM_R 62 0{TEXT 1 0 ""}}{COM_R 63 0{TEXT 1 
112 "Maple knows about classes of functions defined by integrals.
  For example, it knows about the Fresnel integrals."}}{COM_R 64 
0{TEXT 1 0 ""}}{INP_R 65 0 "> "{TEXT 0 20 "diff(FresnelS(x),x);"}
}{OUT_R 66 0 65{DAG (3n3\`sin`,2+3*5n3\`Pi`j2x0001n3\`x`j2x0002/3
p8pC}}{INP_R 67 0 "> "{TEXT 0 20 "diff(FresnelC(x),x);"}}{OUT_R 
68 0 67{DAG (3n3\`cos`,2+3*5n3\`Pi`j2x0001n3\`x`j2x0002/3p8pC}}
{COM_R 69 0{TEXT 1 0 ""}}{COM_R 70 0{TEXT 1 65 "Maple also knows \+
about the generalized factorial function, GAMMA."}}{COM_R 71 0
{TEXT 1 0 ""}}{INP_R 72 0 "> "{TEXT 0 48 "eq3:='int'(exp(-x)*x^(3
24/32423),x=0..infinity);"}}{OUT_R 73 0 72{DAG :3n3\`eq3`(3n3\`in
t`,3*5(3n3\`exp`,2+3n3\`x`i2x0001j2x0001pD/3j2x0324j3x00032423=3p
D~3j2x0000n5\`infinity`}}{INP_R 74 0 "> "{TEXT 0 10 "eval(eq3);"}
}{OUT_R 75 0 74{DAG +3(3n4\`GAMMA`,2/3j2x0324j3x00032423p6}}
{COM_R 76 0{TEXT 1 0 ""}}{COM_R 77 0{TEXT 1 88 "Our last example \+
in this worksheet of a special function will be the Meijer G func
tion. "}}{COM_R 78 0{TEXT 1 0 ""}}{INP_R 79 0 "> "{TEXT 0 49 "eq6
 := Int(exp(-t)*ln(t)/t^(1/2), t=1..infinity);"}}{OUT_R 80 0 79
{DAG :3n3\`eq6`(3n3\`Int`,3*7(3n3\`exp`,2+3n3\`t`i2x0001j2x0001(3
n3\`ln`,2pDp11pD/3pFj2x0002=3pD~3p11n5\`infinity`}}{INP_R 81 0 ">
 "{TEXT 0 11 "value(eq6);"}}{OUT_R 82 0 81{DAG (3n4\`MeijerG`,4j2
x0003/3j2x0001j2x0002p8}}{INP_R 83 0 "> "{TEXT 0 11 "evalf(eq6);"
}}{OUT_R 84 0 83{DAG e3j4x001435309984i2x0010}}{COM_R 85 0{TEXT 1
 0 ""}}{COM_R 86 0{TEXT 1 228 "The Meijer G function is particula
rly useful in contexts where it is necessary to express the deriv
ative of the incomplete Gamma function GAMMA(a,z) with respect to
 its first argument. The incomplete Gamma function is defined by"
}}{OUT_R 87 0 0{DAG =3(3n4\`Gamma`,3n3\`a`n3\`x`(3n3\`Int`,3*5^3n
3\`e`+3n3\`t`i2x0001j2x0001^3p13+5p6p17p15p17p17=3p13~3p8n5\`infi
nity`}}{INP_R 88 0 "> "{TEXT 0 22 "diff(GAMMA(a,x), x$2);"}}
{OUT_R 89 0 88{DAG +5*9^3n3\`x`+5n3\`a`j2x0001i2x0001p8p8p5p8p3pA
(3n3\`exp`,2+3p3pAp8pA*5p2p8p12p8p8}}{INP_R 90 0 "> "{TEXT 0 22 "
diff(GAMMA(a,x), a$2);"}}{OUT_R 91 0 90{DAG *5n3\`x`j2x0001+7*5(3
n3\`ln`,2p1p3+5*7p7p3(3n4\`GAMMA`,3n3\`a`p1p3p1i2x0001p3(3n4\`Mei
jerG`,4j2x0003p16p1p3p3p3*5p7p3p1Ep3p3(3p1F,4j2x0004p16p1j2x0002p
3}}{COM_R 92 0{TEXT 1 0 ""}}{COM_R 93 0{TEXT 1 125 "Like many oth
er special functions, Meijer's G function has special cases that \+
reduce to more commonly understood expressions."}}{COM_R 94 0
{TEXT 1 1 " "}}{INP_R 95 0 "> "{TEXT 0 15 "MeijerG(2,a,z);"}}
{OUT_R 96 0 95{DAG *5(3n4\`GAMMA`,3n3\`a`n3\`z`j2x0001p8i2x0001}}
{INP_R 97 0 "> "{TEXT 0 15 "MeijerG(3,1,z);"}}{OUT_R 98 0 97{DAG 
*5(3n3\`Ei`,3j2x0001n3\`z`p5p7i2x0001}}{COM_R 99 0{TEXT 1 37 "Her
e, Ei is the exponential integral,"}}{OUT_R 100 0 0{DAG =3(3n3\`E
i`,3n3\`n`n3\`t`(3n3\`Int`,3*5^3n3\`e`+3*5n3\`x`j2x0001p7p15i2x00
01p15^3p7p5p19=3p7~3p15n5\`infinity`}}{INP_R 101 0 "> "{TEXT 0 0 
""}}}{END}
