


MAPLE(1)                 USER COMMANDS                   MAPLE(1)



NAME
     maple - Interactive computer algebra system

SYNOPSIS
     maple [ -b libname ] [ -e errorbreak ] [ -g gcinterval  ]  [
     -u  interface  ]  [  -f  ]  [  -q  ] [ -s ] [ -t ] [ -w war-
     ninglevel] [ -x ]

DESCRIPTION
     Initiate a session with the _M_a_p_l_e Computer  Algebra  System.
     Expressions  are  read  from standard input (unless -u or -x
     are specified) and the results are produced on the  standard
     output  as  each  input  expression  is read.  Maple has the
     ability  to  algebraically  manipulate  unbounded  integers,
     exact  rational  numbers, real numbers with arbitrary preci-
     sion, symbolic formulae, polynomials, sets, lists, and equa-
     tions.   It can solve systems of equations and differentiate
     and integrate expressions.

     In the following example from a Maple session, Maple's  out-
     put is shown to the right of the input expressions.

     p := x^2-x-2;
                                           2
                                     p := x  - x - 2

     q := (x+1)^2;
                                                  2
                                      q := (x + 1)

     s := p/q;
                                           2
                                          x  - x - 2
                                    s := ------------
                                                  2
                                           (x + 1)

     diff(s,x); # Differentiate with respect to x.

                                                2
                                 2 x - 1       x  - x - 2
                               ---------- - 2 ------------
                                       2               3
                                (x + 1)         (x + 1)

     normal(s);
                                          x - 2
                                         -------
                                          x + 1

     x := 3^50;
                              x := 717897987691852588770249



Waterloo Maple SoftwareLast change: 11/93                       1






MAPLE(1)                 USER COMMANDS                   MAPLE(1)



     s; # Re-evaluate s with a value substituted for x.
                                 717897987691852588770247
                                --------------------------
                                 717897987691852588770250

     # Set the precision to use for floating point results.
     Digits := 40;
                                       Digits := 40

     evalf(s); # Re-evaluate s in floating point format.
                     .9999999999999999999999958211332927043849

     quit

     The command _m_a_p_l_e actually invokes  a  script  which  parses
     various  command  line options, sets appropriate environment
     variables, and then starts the Maple kernel (and possibly  a
     separate  user  interface). The command _x_m_a_p_l_e invokes _m_a_p_l_e
     with the -x option (see below).

OPTIONS
     -b   The -b (li_brary) option tells Maple that the  following
          argument  should  be used as the pathname of the direc-
          tory which contains the Maple library.   This  initial-
          izes  the Maple  variable `libname'.  By default, `lib-
          name'    is    initialized    with     the     pathname
          /usr/local/maple/lib.   Some  sites  may  customize the
          maple shell script to redefine the library pathname  to
          be  whatever is appropriate for those sites.  For exam-
          ple,

                  maple -b /usr/public/waterloo/maple/lib $*

          More than one -b option can be specified. In this case,
          the  first  -b  option  overrides the default `libname'
          setting, and subsequent  -b  options  are  appended  to
          `libname',  forming  a  Maple  expression  sequence  of
          directory names.

     -e   The -e (break on _error) option tells Maple what  to  do
          when  an error is encountered while reading a file. -e0
          tells Maple to to report the error and keep reading the
          file. -e1 (the default) tells Maple to stop reading the
          file (and skip to the  end)  when  a  syntax  error  is
          encountered.  -e2  tells Maple to stop reading and skip
          to the end when any type of error is encountered.  This
          behaviour  can  also be changed from within Maple using
          the command _i_n_t_e_r_f_a_c_e(_e_r_r_o_r_b_r_e_a_k=_n) where _n is 0, 1, or
          2.

     -g   The -g (_garbage collection interval) option tells Maple
          at  what  interval  (in  terms  of  number  of words of



Waterloo Maple SoftwareLast change: 11/93                       2






MAPLE(1)                 USER COMMANDS                   MAPLE(1)



          storage allocated) to perform garbage  collection.  The
          default  on most UNIX platforms is every 250,000 words.
          This setting can also  be  changed  from  within  Maple
          using  the  command _g_c(_n) where _n is the desired inter-
          val.

     -u   The -u (_user interface) option  tells  Maple  that  the
          following  argument is the name of a program that is to
          be used as Maple's user interface.   This  is  used  to
          provide special user interfaces for different windowing
          systems and operating environments,  without  requiring
          separate  `algebra  engines'  for each environment.  If
          this option is  omitted,  Maple  does  simple  terminal
          style  input and output.  The -u option is usually used
          in a script to enable a particular user interface.

     -f   The -f (_filter) option forces Maple to  exit  when  the
          standard input has been redirected from a file, and the
          end of the file is encountered. By default, Maple  will
          not  exit,  and  will instead continue interactively at
          that point.

     -q   The -q (_quiet) option will  suppress  the  printing  of
          Maple's startup message, various informational messages
          (bytes used messages and garbage collection  messages),
          and  the  signoff  message.  Maple is better suited for
          use as a filter when these messages are suppressed.

     -s   The -s (_suppress initialization) option causes Maple to
          forego  reading any initialization file when initiating
          a session.

          If there is a  system-wide  Maple  initialization  file
          with  the  name  _i_n_i_t under the _s_r_c subdirectory of the
          Maple library, then this file is  read  and  the  Maple
          statements  in  it  executed before the session starts.
          If  there  is  a  Maple   initialization   file   named
          ._m_a_p_l_e_i_n_i_t  in  the user's home directory, this file is
          read next.

     -t   The -t (_test mode) option causes Maple  to  change  its
          prompt  to  "#-->" and disable prettyprinting, suitable
          for running the Maple test suite.  This is not normally
          used by Maple users.

     -w   The -w (_warning level) option specifies  whether  maple
          should print certain warnings.  In previous versions of
          maple, variables are assumed to be global unless expli-
          citly  declared  local,  but  this  has  changed in the
          present version. -w 0  turns  off  the  local  variable
          warning.  -w 1 (the default) enables the local variable
          warning.  For further details, see _m_2_s_r_c and _u_p_d_t_s_r_c.



Waterloo Maple SoftwareLast change: 11/93                       3






MAPLE(1)                 USER COMMANDS                   MAPLE(1)



     -x   The -x (_X interface) option causes Maple to run with an
          X  Window System user interface (see the following sec-
          tion).

WINDOW SYSTEMS
     If you are running Maple V under a windowing  system,  there
     may  be  a user interface specific to that system. For exam-
     ple, X Window System users (this includes Motif and OpenLook
     users) can run Maple by using the _x_m_a_p_l_e command.

     In addition to the Maple  options  described  above,  window
     system  specific  options can also be used. For example, the
     option -bg red tells the X version of Maple to  use  red  as
     the background color.

SEE ALSO
     _F_i_r_s_t _L_e_a_v_e_s: _A _T_u_t_o_r_i_a_l _I_n_t_r_o_d_u_c_t_i_o_n _t_o  _M_a_p_l_e  _V  by  B.W.
     Char,  K.O.  Geddes,  G.H. Gonnet, B.L. Leong, M.B. Monagan,
     S.M.Watt,  Springer-Verlag  and  Waterloo  Maple  Publishing
     (1992).

     _M_a_p_l_e _V _L_i_b_r_a_r_y _R_e_f_e_r_e_n_c_e _M_a_n_u_a_l by B.W. Char, K.O.  Geddes,
     G.H.  Gonnet,  B.L. Leong, M.B. Monagan, S.M.Watt, Springer-
     Verlag and Waterloo Maple Publishing (1991).

     _M_a_p_l_e _V _L_a_n_g_u_a_g_e _R_e_f_e_r_e_n_c_e _M_a_n_u_a_l by B.W. Char, K.O. Geddes,
     G.H.  Gonnet,  B.L. Leong, M.B. Monagan, S.M.Watt, Springer-
     Verlag and Waterloo Maple Publishing (1991).

     _M_a_p_l_e _V _R_e_l_e_a_s_e _2 _N_o_t_e_s by Waterloo Maple Software (1992).

     The _m_a_r_c_h, _m_i_n_t, _m_2_s_r_c, and _u_p_d_t_s_r_c commands.

ENVIRONMENT
     Maple uses several system environment variables.  These  are
     generally  set  by  the  _m_a_p_l_e  script, so the user need not
     worry about them.

     The _M_A_P_L_E variable is used to tell Maple where to  find  its
     library,  the  Maple  share library, the help browser index,
     and various configuration files.

     The _H_O_M_E variable is used to determine where to look for the
     user's ._m_a_p_l_e_i_n_i_t file.

     The _P_A_G_E_R variable is used to determine which program to use
     to display help files (when running with the terminal inter-
     face). If this variable is not defined, the _m_o_r_e program  is
     used.

     The _P_A_T_H variable is used to find auxiliary  programs,  such
     as the plot driver.



Waterloo Maple SoftwareLast change: 11/93                       4






MAPLE(1)                 USER COMMANDS                   MAPLE(1)



     The _X_A_P_P_L_R_E_S_D_I_R variable is used to indicate where the Maple
     X Window resource files are.

FILES
     $MAPLE/lib/src/init - system wide initialization file (where
     the  setting of the environment variable MAPLE is subject to
     change at each installation).

     $MAPLE/lib  -  Maple  library  (where  the  setting  of  the
     environment  variable  MAPLE  is  subject  to change at each
     installation).

     $HOME/.mapleinit - user's own Maple initialization file.

     $XAPPLRESDIR/MapleV - the resource file used by the X Window
     System Maple interface.

     $XAPPLRESDIR/Maple2dX11m - the resource file used by  the  X
     Window System two-dimensional plotting interface.

     $XAPPLRESDIR/Maple3dX11m - the resource file used by  the  X
     Window System three-dimensional plotting interface.

AUTHORS
     Symbolic Computation Group, University of  Waterloo,  Water-
     loo, Ontario, Canada

     G.H. Gonnet and M.B. Monagan, ETH, Zurich, Switzerland

     Waterloo Maple Software, Waterloo, Ontario, Canada

FOR HELP
     If you have a question that you think is of a very  specific
     nature  and  not  of interest to others, you may send a mail
     message to your site  license  technical  administrator  (if
     your  site has  a site license). The technical administrator
     for your site is:

          ADMINISTRATOR'S ADDRESS GOES HERE

     If your site does not have a site license, send your techni-
     cal queries to:

          support@maplesoft.on.ca.

     For queries or results that you wish to share  with  others,
     there  is a Maple user's group which interacts by electronic
     mail.  This group can be reached by mailing to:

          maple_group@daisy.waterloo.edu
     or
          maple_group@daisy.uwaterloo.ca



Waterloo Maple SoftwareLast change: 11/93                       5






MAPLE(1)                 USER COMMANDS                   MAPLE(1)



     You should subscribe to this group  (by  sending  a  message
     requesting  to  be made a member) if you intend to use Maple
     in more than just a casual manner.  Users are encouraged  to
     post  their  questions regarding Maple to this group if they
     feel that their enquiries are of a general nature.   Replies
     will be posted to the group for all to see and benefit from.

















































Waterloo Maple SoftwareLast change: 11/93                       6



