


MARCH(1)                 USER COMMANDS                   MARCH(1)



NAME
     march - Maple library archive manager

SYNOPSIS
     march -a archiveDir { fileName indexName }
     march -u archiveDir { fileName indexName }
     march -p archiveDir
     march -l archiveDir
     march -c archiveDir tableSize
     march -x archiveDir { indexName fileName }
     march -d archiveDir { indexName }

DESCRIPTION
     _M_a_r_c_h (the Maple ARCHive manager) is used  to  manage  Maple
     ".m"  files  archived  in  a Maple library.  It performs the
     following functions, on a library archive:

          -_adds or _updates Maple ".m" files
          -_packs (garbage collect)
          -_lists the contents
          -_creates a library archive
          -_extracts (but not remove) files
          -_deletes a file

     Exactly one of the above command line options must be speci-
     fied.

     _M_a_r_c_h uses or creates the library archive files  "maple.lib"
     and "maple.ind" located in _a_r_c_h_i_v_e_D_i_r.

     The rest of this document contains the following sections:

          OPTIONS
          ARGUMENTS
          DIAGNOSTICS

     plus, the standard:


          FILES
          SEE ALSO

OPTIONS
     The following command line options are understood by  _m_a_r_c_h.
     Exactly one of these options must be specified per command:

     -a   Adds the specified ".m" files  to  the  archive.   Each
          file  specified  by a _f_i_l_e_N_a_m_e is added to the archive,
          and indexed using the corresponding _i_n_d_e_x_N_a_m_e.

          If there is already a file indexed by _i_n_d_e_x_N_a_m_e,  _m_a_r_c_h
          issues a warning, and processing continues.



Waterloo Maple SoftwareLast change: 11/93                       1






MARCH(1)                 USER COMMANDS                   MARCH(1)



     -u   Updates the specified ".m" files in  the  archive.  For
          each   _i_n_d_e_x_N_a_m_e,   the   entry  is  updated  with  the
          corresponding _f_i_l_e_N_a_m_e.

          If there is no entry indexed by _i_n_d_e_x_N_a_m_e, _m_a_r_c_h issues
          a warning, and processing continues.

          If the updated version of a file is smaller or the same
          size as the old version (in the library archive), it is
          stored in the space occupied by the old version. Other-
          wise,  it  is  added  to the end of the archive and the
          space  it  previously  occupied  is  wasted  until  the
          archive is packed.

     -p   Packs the library archive.  All wasted space is  purged
          from  the  archive  (see _update option above). This can
          free up a great deal of space  if  a  large  number  of
          archive members have been replaced, or the same archive
          member has been updated frequently.

     -l   Lists the contents  of  an  archive.   Each  member  is
          listed  in  the  order  it appears in the index (so the
          order is effectively random).

          The output consists of three columns: name, offset, and
          size.  The  name  column  gives the index name by which
          Maple can retrieve the member (or -x option can extract
          it)  from the archive.  The offset column indicates the
          position in the archive  file  ("maple.lib")  that  the
          member  begins.   The  size  column  indicates how many
          bytes the member requires.

     -c   Creates a new archive  in  _a_r_c_h_i_v_e_D_i_r.   The  _t_a_b_l_e_S_i_z_e
          argument  should  be  approximately the number of files
          you wish to store in the archive.  This does not  limit
          the  number  of  files  that  can be stored, but merely
          creates the new archive's index file, such that it  can
          efficiently store that many files.

          If an old library exists in _a_r_c_h_i_v_e_D_i_r, _m_a_r_c_h will  not
          create  a  new archive.  To remove the old library, the
          files "maple.lib" and "maple.ind" in  _a_r_c_h_i_v_e_D_i_r,  must
          be removed.

     -x   Extracts the specified members of  the  archive.   Each
          member  specified by an _i_n_d_e_x_N_a_m_e is copied into a file
          specified by the corresponding _f_i_l_e_N_a_m_e.  The member is
          not removed by this option.

          If a member does not exist, a warning  is  printed  and
          processing  continues.   If  _f_i_l_e_N_a_m_e  already  exists,
          _m_a_r_c_h over-writes it.



Waterloo Maple SoftwareLast change: 11/93                       2






MARCH(1)                 USER COMMANDS                   MARCH(1)



     -d   Deletes the members specified  by  _i_n_d_e_x_N_a_m_e  from  the
          library  archive.   The  members are deleted as soon as
          the command is entered, with no warnings to prevent any
          accidental deletion.  All deleted members become wasted
          space in the library  archive,  until  the  library  is
          packed.

ARGUMENTS
     The  _a_r_c_h_i_v_e_D_i_r  argument  specifies  the  location  of  the
     archive  that  is to be managed.  The directory "_a_r_c_h_i_v_e_D_i_r"
     must   exist.    The   files   "_a_r_c_h_i_v_e_D_i_r/maple.lib"    and
     "_a_r_c_h_i_v_e_D_i_r/maple.ind"  must  also exist (or will be created
     if -c is specified).

     The _f_i_l_e_N_a_m_e and _i_n_d_e_x_N_a_m_e pairs specify the file whose con-
     tents  are  to  be added, or updated in the archive, and the
     name that the file should have in the archive index  respec-
     tively.  In the extraction case, _f_i_l_e_N_a_m_e refers to the file
     into which, the contents of _i_n_d_e_x_N_a_m_e are copied  (from  the
     archive).

     The _t_a_b_l_e_S_i_z_e argument is used when creating the archive  to
     specify  the  initial index size (see the description of the
     -c option).

DIAGNOSTICS
     _M_a_r_c_h may produce the following diagnostic messages:

     there is already an archive in '_a_r_c_h_i_v_e_D_i_r'
          An attempt was made to create an archive in a directory
          which already contains an archive.

     there is no existing archive in '_a_r_c_h_i_v_e_D_i_r'
          An attempt was made to add to, update, pack,  list,  or
          extract from a non-existent archive.

     there must be an indexName for each fileName

     there must be a fileName for each indexName
          An add, update, or extract command was followed  by  an
          odd  number  of  names (ie.  there was one left over at
          the end of the list).

     temporary archive files could not be created

     could not write to new index or archive

     an error occurred while closing the new archive
          When packing an archive, the packed archive  could  not
          be  created  successfully.   The  archive  will be left
          untouched.  The usual cause of one of these messages is
          insufficient  disk space.  In order to pack an archive,



Waterloo Maple SoftwareLast change: 11/93                       3






MARCH(1)                 USER COMMANDS                   MARCH(1)



          you need at least as much free space as the size of the
          archive.   Another  possible  cause  is that you do not
          have permissions to write into the directory containing
          the archive.

     an error occurred while creating '_a_r_c_h_i_v_e_N_a_m_e'
          While extracting from an archive,  the  extracted  file
          could  not  be  created  successfully.  This is usually
          caused by lack of disk space or permission to write the
          file.

     the archive data file could not be created

     the archive index file could not be created

     an error occurred while creating the archive

     an error occurred while creating the index
          A new archive could not be created (due to lack of disk
          space or improper permissions).

     an error occurred while reading the index
          The archive index is damaged in some way.

     an error occurred while updating the archive

     an error occurred while updating the index

     an error occurred while updating the index or archive
          While adding  to  or  updating  an  archive,  an  error
          occurred.   This is usually as a result of insufficient
          disk space.  The archive may be  left  in  an  unusable
          state if this happens.

     no more files can be added to the index
          The index is completely full.  This can happen  if  far
          more files are added to the archive than was originally
          intended.  In this case, create a  temporary  directory
          somewhere,  extract  all  the  files  from the archive,
          delete the archive, create a new (larger) archive,  and
          add all the files to this archive.

     the index could not be opened for updating

     the archive could not be opened for updating
          You do not have permissions to update the archive.

     the name '_i_n_d_e_x_N_a_m_e' is longer than 55 characters
          When adding to or updating an archive, you specified an
          _i_n_d_e_x_N_a_m_e  that is longer than 55 characters (including
          any "/" or "." characters).




Waterloo Maple SoftwareLast change: 11/93                       4






MARCH(1)                 USER COMMANDS                   MARCH(1)



     the table size must be between 1 and 99999
          The table size for creating an archive must be  between
          1  and 99999.  The limit of 99999 was chosen to prevent
          the accidental creation of ridiculously large archives.

     warning, '_i_n_d_e_x_N_a_m_e' already in archive
          While adding to an archive, the member to be added  was
          already  in  the  archive.   Use  the -u option instead
          (after making  sure  you  had  typed  the  member  name
          correctly).

     warning, '_i_n_d_e_x_N_a_m_e' not found in archive
          While updating an archive, the member to be updated was
          not  found  in  the archive.  Use the -a option instead
          (after making  sure  you  had  typed  the  member  name
          correctly).

     warning, file '_f_i_l_e_N_a_m_e' could not be opened
          A file to be added could not be  opened  (it  does  not
          exist,  or you do not have read permissions), or a file
          to be extracted could not be opened (there is  no  disk
          space, or you do not have write permissions).

FILES
     _a_r_c_h_i_v_e_D_i_r/maple.lib - the library archive file
     _a_r_c_h_i_v_e_D_i_r/maple.ind - the corresponding library index file

SEE ALSO
     Other _M_a_p_l_e related commands:
     _M_a_p_l_e, _m_i_n_t, _m_2_s_r_c, and _u_p_d_t_s_r_c

























Waterloo Maple SoftwareLast change: 11/93                       5



