


MINT(1)                  USER COMMANDS                    MINT(1)



NAME
     mint - Produce syntax and usage report of a Maple program

SYNOPSIS
     mint [ -i info_level ] [ -lpqsSx ] [ -a database_file ] [ -b
     library_dir  ]  [  -d library_database ] [ -t error_number ]
     ... [ file ]

DESCRIPTION
     _M_i_n_t produces a report about  possible  errors  in  a  Maple
     source file and also reports about how variables are used in
     the file.  If _f_i_l_e is not given, then the standard input  is
     used to read Maple source statements.  Unlike _m_a_p_l_e, _m_i_n_t is
     not terminated when it reads a quit statement.  It  is  ter-
     minated  when  it  reaches the end of _f_i_l_e.  For interactive
     use, _f_i_l_e may be omitted, and a control-d is  used  to  ter-
     minate  a _m_i_n_t session.  When started, _m_i_n_t produces a maple
     leaf logo; this can only be suppressed by the use of the  -q
     (_quiet) option.

     The amount of information to be produced by _m_i_n_t  is  speci-
     fied  by  the  _i_n_f_o__l_e_v_e_l  argument.  The values allowed for
     this argument are:

     0    Display no information.

     1    Display only severe errors.

     2    (default) Display severe and serious errors.

     3    Display warnings as well as severe and serious errors.

     4    Give a  full  report  on  variable  usage  as  well  as
          displaying errors and warnings.

     A severe error is an undisputable error.  A serious error is
     almost certainly an error.  Warnings are possible errors.

     A report is displayed for each procedure  in  the  file.   A
     global  report, for statements not contained within any pro-
     cedure, is displayed after the procedure  reports.   If  the
     severity  of  errors, found within a procedure, is less than
     what _i_n_f_o__l_e_v_e_l specifies, then no report  is  produced  for
     that  procedure.   In all cases, the most severe error found
     in _f_i_l_e will be used to set the exit status for  _m_i_n_t.   The
     possible values exit status values are:

     0    no errors or warnings

     1    warnings

     2    serious error



Waterloo Maple Software Last change: 11/93                      1






MINT(1)                  USER COMMANDS                    MINT(1)



     3    severe error

     Thus, by using an _i_n_f_o__l_e_v_e_l of  0,  _m_i_n_t  can  be  used  to
     determine  the severity of errors in a file without actually
     producing any output at all.   If  no  value  is  given  for
     _i_n_f_o__l_e_v_e_l on the command line, a default value of 2 (severe
     and serious errors) is used.

     The rest of this document contains the following sections:


          OPTIONS
          INITIALIZATION FILE
          PROCEDURE DATABASE FILES
          OTHER REPORTS
          SEVERE
          SERIOUS
          WARNING
          EXAMPLES
          FILES USED
          SEE ALSO
          STATUS

OPTIONS
     -i _i_n_f_o__l_e_v_e_l
          The _info_level option is  explained  above.   For  more
          specific information on the error and warning messages,
          see the OTHER REPORTS section.

     -l   The _library file option suppresses warnings and  errors
          that are commonly caused by Maple library source files.
          With this option error message #9 "Names used  as  glo-
          bals  don't  start  with  _" replaces error message #10
          "Global underscore variable used".

          Typically, a Maple library source file will  contain  a
          concatenation,  and  a  global name, for use in loading
          the library file.  So error message #9 and warning mes-
          sage  #29 "Catenated name used" will be suppressed when
          only one occurrence of each such name is  used  outside
          of any procedure.

          Warnings about the assignment of values to the  system-
          defined  names,  such  as  Digits  and  printlevel, are
          suppressed since this often happens in a library file.

          Global variables which start with an underscore (_) are
          allowed by using this option.

          This option also suppresses  error  messages  regarding
          library  file  names being overwritten since one of the
          purposes of a library file is to assign a procedure  to



Waterloo Maple Software Last change: 11/93                      2






MINT(1)                  USER COMMANDS                    MINT(1)



          a library file name.

     -q   The _quiet option suppresses printing of the maple  leaf
          logo.   The  maple  leaf logo is always printed, unless
          the quiet option is specified.

     -s   Do not read _startup file.  Normally, if there is a file
          named  ".mintrc" in your home directory, _m_i_n_t will read
          this file for command line options; this flag  disables
          this feature.

     See INITIALIZATION FILE below, for more details on the  ini-
     tialization file.

     -S   Enable _Syntax checking only.  This  option  will  over-
          ride  an  _i_n_f_o__l_e_v_e_l  and  most other options, allowing
          only syntax error messages to appear in the output.

     -x   The  cross-reference  (_x)  option  displays   functions
          called, in addition to any other information requested.

     -a _d_a_t_a_b_a_s_e__f_i_l_e
          This   option   _appends   procedure   information    to
          _d_a_t_a_b_a_s_e__f_i_l_e. Any procedures defined in _f_i_l_e will have
          their definition from _f_i_l_e appended  to  _d_a_t_a_b_a_s_e__f_i_l_e.
          For more information, see "PROCEDURE DATABASE FILES".

     -b _l_i_b_r_a_r_y__d_i_r
          Use li_brary located in _l_i_b_r_a_r_y__d_i_r.  _M_i_n_t will then use
          the library in the _l_i_b_r_a_r_y__d_i_r for library routines.

     If the MAPLE environment variable is set, then  the  default
     for   _l_i_b_r_a_r_y__d_i_r   is   "$MAPLE/lib",   otherwise,   it  is
     "/usr/local/maple/lib".

     -d _l_i_b_r_a_r_y__d_a_t_a_b_a_s_e
          Use _l_i_b_r_a_r_y__d_a_t_a_b_a_s_e as the procedure _data base.   This
          allows  _m_i_n_t  to  check  for improper usage of the pro-
          cedures in _f_i_l_e.  Multiple _l_i_b_r_a_r_y__d_a_t_a_b_a_s_e  files  may
          be  specified.   For  more  information,  see PROCEDURE
          DATABASE FILES.

     -t _e_r_r_o_r__n_u_m_b_e_r
          The _toggle option will turn  off  reporting  errors  of
          type  _e_r_r_o_r__n_u_m_b_e_r.  For a full listing of all warnings
          and errors see the OTHER REPORTS section.

INITIALIZATION FILE
     If there is a file named ".mintrc" in your  home  directory,
     _m_i_n_t  will  read  this  file for command line options.  This
     feature can be disabled using the -s option.  This file  may
     contain  several  lines  containing  command line options or



Waterloo Maple Software Last change: 11/93                      3






MINT(1)                  USER COMMANDS                    MINT(1)



     arguments as you would type them on a command  line.   Since
     _m_i_n_t reads this file and then scans the actual command line,
     arguments on the actual command line can override  arguments
     in  the  initialization file.  A good use of the initializa-
     tion file may be to enter the name of the Maple library pro-
     cedure database file when using the -d option, obviating the
     need to type this each time _m_i_n_t is used.

PROCEDURE DATABASE FILES
     A procedure database file  contains  information  about  the
     definition  of  procedures  which is useful in ensuring that
     these procedures are used correctly.  Each line in  a  data-
     base file contains the following:

         <name> <min args> <max args> <nargs used> <file name>

     where <name> is a legal  Maple  name  without  any  embedded
     blanks,  <min args>  is  the  minimum  number  of  arguments
     expected for <name>, <max args> is  the  maximum  number  of
     arguments,  <nargs used> is 1 if `nargs' is used in the pro-
     cedure body for <name> and 0 otherwise, <file name>  is  the
     name of the file in which <name> is defined.  The entries on
     each line are in free format but must be separated from  one
     another  by  at  least  one space character.  The values for
     <min args> and <max args> should be numbers in the  range  0
     to  999.   If  <max args>  is 999 for an entry, that denotes
     that the procedure has no upper limit on the number of argu-
     ments.   There may be multiple entries for a particular pro-
     cedure.  Later entries supersede earlier ones.

     A procedure database file for the entire  Maple  library  is
     generated   or   updated   periodically.    This   file   is
     "/usr/maple/data/mint.db" and contains over 4000 entries and
     it takes _m_i_n_t several seconds to read this file.

     A private database file can be generated through the use  of
     the  -a command line option for _m_i_n_t.  A file name must fol-
     low -a on the command line and is taken to  be  a  procedure
     database  file.   As _m_i_n_t scans procedure definitions in the
     input file, it will append procedure database  entries  into
     the  database  file.  For information gathered automatically
     by _m_i_n_t about a procedure, <min args>  and  <max args>  will
     both be the number of formal arguments used in the procedure
     definition.  You can edit the database file to adjust  these
     values.   Remember  that  use of `nargs' in a procedure body
     sets the <nargs seen> field to 1 in the database  entry  and
     that  this  will  turn  off argument count checking for that
     procedure.

OTHER REPORTS
     If _i_n_f_o__l_e_v_e_l is 4, then a usage report is  given  for  each
     procedure  as  well  as  global  statements within the file.



Waterloo Maple Software Last change: 11/93                      4






MINT(1)                  USER COMMANDS                    MINT(1)



     Each usage report shows  how  parameters,  local  variables,
     global  variables,  system-defined names and catenated names
     are used. For example:

     1    Used as a value

     2    Used as a table or list element

     3    Used as a call-by-value parameter

     4    Used as a call-by-name parameter (a quoted parameter)

     5    Called as a function

     6    Assigned a procedure

     7    Assigned a list

     8    Assigned a set

     9    Assigned a range

     10   Assigned a value as a table or list element

     11   Assigned a function value (assigned a value to remember
          as a function value)

     In addition, a list of all the error messages generated,  is
     given.   The  types of errors and warnings found are classi-
     fied as severe, serious, and warning.  A severe error is  an
     undisputable  error.  A serious error is almost certainly an
     error.  However, persons defining procedures for addition to
     the  Maple  library  may  choose to ignore these ``errors''.
     Warnings are possible errors.  They point to constructs that
     may  be  correct  in  some  contexts, but probable errors in
     other contexts.  The types of errors and  warnings  produced
     are:


SEVERE
     Syntax errors
          A caret symbol will point to the token  that  is  being
          read  when the error occurred.  Syntax errors cannot be
          toggled.

     0  Break or next statement outside of a loop
          "A break or next statement  is  found  outside  of  any
          loop"
          A break or a next statement occurs outside of any  loop
          (Break  or  next  may  still be used as names within an
          expression outside of a loop).




Waterloo Maple Software Last change: 11/93                      5






MINT(1)                  USER COMMANDS                    MINT(1)



     1  RETURN or ERROR outside of procedure
          "RETURN or ERROR statement is found outside of  a  pro-
          cedure"
          A function call to RETURN or ERROR occurs outside of  a
          procedure  body  (RETURN  or ERROR may still be used as
          names if they are not invoked as functions).

     2  Duplicated local variable
          "These names were declared more than once  as  a  local
          variable:"
          A name is declared more than once in the list of  local
          variables for a procedure.

     3  Duplicated parameter
          "These names appeared more than once in  the  parameter
          list:"
          A name appears more than once in a parameter list for a
          procedure.

     4  Local variable and parameter conflict
          "These names were declared as both a local variable and
          a parameter:"
          A name is used both as a parameter and a local variable
          within  a  procedure.  In further analysis, the name is
          treated as a parameter.

     5  Duplicated loop name
          "These names were used as the same iteration control of
          nested loops:"
          A loop nested within another loop uses as its loop con-
          trol variable the same name that the outer loop uses.

     6  Unreachable code
          "There is unreachable code following a quit statement"
          There are statements which follow directly after a goto
          type  of  statement.   These statements are unreachable
          and will never be executed.  A goto statement is a next
          statement,  a  break  statement,  a quit, stop, or done
          statement, a RETURN() call, an  ERROR()  call.   An  if
          statement all branches of which end in a goto statement
          is also considered a goto statement.

     7  Iteration control variable conflict
          "These names were used as iteration  control  variables
          for both a $, sum, or product construct and a loop:"
          The control variables for  the  inner  and  outer  con-
          structs have the duplications shown.  This message will
          occur even if the appropriate variables are quoted (').

SERIOUS
     8  Wrong argument count in a procedure call
          "'procedure_name' was was called  with  'n'  args,  but



Waterloo Maple Software Last change: 11/93                      6






MINT(1)                  USER COMMANDS                    MINT(1)



          defined for ..."
          The number of arguments  passed  in  a  procedure  call
          doesn't  match  the  number  of formal arguments in the
          definition of a procedure of the same name recorded  in
          the  library  database  file.   A library database file
          (see DATABASE FILES)  contains  information  about  the
          minimum  number  of arguments expected for a procedure,
          the maximum number of  arguments,  whether  `nargs'  is
          used in the procedure body, and the name of the file in
          which the procedure  is  defined.   If  the  number  of
          actual arguments passed is either less than the minimum
          arguments expected or  more  than  the  maximum  number
          expected _a_n_d `nargs' is not used in the procedure body,
          then  a  warning  is  generated.    This   warning   is
          suppressed  if  one  of the arguments passed is `args'.
          It is a common practice for a  procedure  to  take  its
          argument  list,  contained  in  the expression sequence
          `args', and pass that on  to  other  procedures.   What
          appears  to  _m_i_n_t  as  one  argument  is  in  reality a
          sequence of arguments.

     9  Undeclared globals
          "These names were used as global  names  but  were  not
          declared:"
          The variables are assumed to be  global,  but  are  not
          explicitly declared as such.
          Also, the -l (library) option adds the  message  "These
          names  were  used  as  global names but the names don't
          start with _", suppressing message #10.
          Versions of _M_a_p_l_e V Release 2  and  lower  treat  unde-
          clared  variables in procedures, differently than other
          later releases of _M_a_p_l_e.  For a complete description of
          the differences, see the command _u_p_d_t_s_r_c.

     10 Global underscore variable used
          "Underscore names are reserved for use in the  library.
          These global names start with _:"
          Names that start with an underscore  (_)  are  reserved
          for library files.

     11 Unused local variable
          "These local variables were never used:"
          A local variable is declared for a procedure but  never
          used within the procedure body.

     12 Local variable never assigned a value
          "These local variables were used but never  assigned  a
          value:"
          A local variable was never assigned a value in  a  pro-
          cedure but within the procedure its value is used in an
          expression.  Such an expression would contain a pointer
          to a non-existent local variable if the expression were



Waterloo Maple Software Last change: 11/93                      7






MINT(1)                  USER COMMANDS                    MINT(1)



          returned or assigned to a global variable.

     13 Local variable assigned a value but not used
          "These local variables were assigned a value but other-
          wise not used:"
          A local variable is assigned a value within a procedure
          but is not otherwise used.

     14 Unused parameter in a procedure
          "These parameters were never used explicitly:"
          A name specified in the parameter list of  a  procedure
          is  never  used in the procedure.  This is considered a
          serious error if `args' is  never used in the procedure
          either.   If  args  is used in the procedure, then it's
          possible that the parameter may be accessed  through  a
          construct using `arg' and this error is downgraded to a
          warning.

     15 Library file name overwritten
          "These library names were assigned a value:"
          The name of a library file, e.g., `convert/ratpoly`, is
          assigned  a  value.   It  is  usual  for  the name of a
          library file to also be the name of a library function.
          Hence,  the  library  function  `convert/ratpoly` is no
          longer accessible (The -l (_library  file)  option  will
          downgrade  these  messages  from  a  serious error to a
          report).

     16 System-defined name is overwritten
          "These system defined names were assigned a value:"
          A name which is treated as  a  system-defined  name  by
          Maple is assigned a value.  The class of system-defined
          names includes names which are special  names  for  the
          Maple  kernel, e.g., true and Digits, names of built-in
          functions, e.g., anames and lprint, names of  functions
          which  are  automatically readlib-defined, e.g., cat or
          help.  Also included are names that are special to rou-
          tines  for evalf, diff, expand, etc.  Examples of these
          are Pi and sinh.  These special names generally  should
          not  be assigned a value in order for some library rou-
          tines to work properly.  Included in the report  is  an
          indication  of  which  parts  of  Maple use the system-
          defined names.

     18 Macro and system name conflict
          "These system defined names were redefined in  a  macro
          or alias statement:"
          The macro or alias statement tried to assign a value to
          a system defined name.

     19 Macro and parameter name conflict
          "These parameters were also  used  as  macro  or  alias



Waterloo Maple Software Last change: 11/93                      8






MINT(1)                  USER COMMANDS                    MINT(1)



          names:"
          The parameters have been previously assigned by a macro
          or alias statement.

     20 Macro and local name conflict
          "These local variables were also used as macro or alias
          names:"
          The local variables have been previously assigned by  a
          macro or alias statement.

     22 Sequence need quotes
          "A construct should have both of its  arguments  quoted
          with  unevaluation  quotes (') since its iteration con-
          trol variable may already have a value."
          The control variables of  the  nested  constructs  con-
          flict.   This situation may be remedied by using (') on
          the inner construct's control variable which  conflicts
          but the best solution is to use a different variable.

     23 Implied multiplication
          "This function call seems to  be  a  product  which  is
          missing the * operator:"
          The expression  implies  multiplication  (for  example,
          2(x+1))  and  the  *  operator  is  needed to correctly
          evaluate this expression (continuing the example,  2  *
          (x+1) )

     24 Unnecessary quotes
          "This name does not need string quotes(``):"
          The quotes are not needed.

     25 Undeclared local
          "These local variables were not declared explicitly:"
          The variable has been assumed local.

WARNING
     26 Local variable or parameter clashes with system name
          "These parameters or local variables  are  also  system
          defined names:"
          The name of a parameter or local variable is also  used
          by Maple as a system-defined name.

     27 Macro redefined
          "These names defined in a macro or alias statement were
          redefined:"
          The names shown have been given values more than  once,
          by a macro or alias.

     28 Sequence body missing control variable
          "The main expr of a seq, $, sum  or  product  construct
          doesn't contain the iteration control variable."
          The iteration control variable is not in  the  sequence



Waterloo Maple Software Last change: 11/93                      9






MINT(1)                  USER COMMANDS                    MINT(1)



          body.

     29 Catenated name used
          "Catenated names used in this file or procedure"
          A name is formed through the catenation operator.

     30 Equation used as a statement
          "An equation is used as a statement"
          This may be intentional.  On the other hand, it's  com-
          mon  for  many Fortran and C programmers to mistype '='
          for the assignment operator which is ':=' in Maple.

     31 Unused parameter in a procedure
          "These parameters were never used explicitly:"
          See similar entry under serious errors.

EXAMPLES
         mint -d /usr/maple/data/mint.db -a my.db -i 4 file_1
         mint -d /usr/maple/data/mint.db -d my.db file_2
         mint -i 1 -q file_3

     Read the Maple source  file  file_1.   It  reads  the  Maple
     library database file and uses this to check that procedures
     defined in the Maple library are  called  with  the  correct
     number  of  arguments.  Information about procedures defined
     in file_1 is _a_p_p_e_n_d_e_d to my.db.  Also, full reports are gen-
     erated for file_1 with the '-i 4' option.

     In the second example, both the Maple library database  file
     and the private database file my.db are used to check number
     of arguments used in procedure calls  in  the  file  file_2.
     Entries  in  my.db supersede entries in the library database
     file if the name of a library procedure has  been  redefined
     in my.db.

     In the third example, no argument count  checking  is  done.
     Since  the  info_level  is  set to 1, only severe errors are
     reported.  Since the -q  (quiet) option is used, the  print-
     ing of the maple leaf logo is suppressed in the output.

FILES USED
     .mintrc - Mint initialization file
     /usr/maple/data/mint.db - Maple library  procedure  database
                               (The  location of the database may
     be different for each site)

SEE ALSO
     Other _M_a_p_l_e related commands:
     _m_a_p_l_e, _m_a_r_c_h, _m_2_s_r_c, and _u_p_d_t_s_r_c

STATUS
     _M_i_n_t will return an exit status of 1, 2, or 3 if  the  worst



Waterloo Maple Software Last change: 11/93                     10






MINT(1)                  USER COMMANDS                    MINT(1)



     error  it  detects  is  a  warning, serious error, or severe
     error, respectively.  An exit status of 0 is returned if  no
     errors or warnings are found.




















































Waterloo Maple Software Last change: 11/93                     11



