


UPDTSRC(1)               USER COMMANDS                 UPDTSRC(1)



NAME
     updtsrc - place  global  statements into  Maple V Release  2
     programs to preserve scope of procedure variables.

SYNOPSIS
     updtsrc [ -pwh ] [ _f_i_l_e_n_a_m_e...  ]

DESCRIPTION
     updtsrc reads a Maple V Release 2 program  adding  a  global
     statement   to  each procedure if a variable's scope in that
     procedure changes under the new scoping rules for  the  next
     release  of Maple (Maple V Release 3).  The  purpose  is  to
     carry  the global/local variable scope meaning from  Release
     2,  into the new form and rules of the next release.

     The program reads from command line files or  from  standard
     input and writes to standard output.

     With the Release 2 scope rules, a  procedure   variable   is
     global  UNLESS  declared local.  Under the new release scope
     rules:

     1.   a variable can now be declared global or local.

     2.   an undeclared variable is local if the variable is

          (1)  the left-hand-side of an assignment statement

          (2)  a for-loop variable

          (3)  a sequence-loop variable

     3.   otherwise, an undeclared variable is global.

     The global statement is placed in the  procedure  after  the
     local  statement  or, if none, before the first statement of
     the procedure.

     If a procedure definition is  copyright  K.O.  Geddes,  G.H.
     Gonnet, M.B. Monagan, University of Waterloo, Waterloo Maple
     Software, or ETH-Zentrum(Zurich) then it is  not  copied  to
     the   output   file  and a newer version of the procedure is
     available.  The -p option will override this.

     A  procedure assignment  where  the procedure body is  "..."
     is  not  copied to the output file.  This form of assignment
     is produced  by the m2src(1) program when it writes  library
     procedures.  See m2src(1) options.

     A warning message is written to standard error whenever text
     is  not  copied  to  the output file.  The warning gives the
     procedure name and line number in the source text.



Wateloo Maple SoftwareLast change: November 29, 1993                1






UPDTSRC(1)               USER COMMANDS                 UPDTSRC(1)



     The use of outdated library procedures also gives a  warning
     message of the same form.

     Global declarations are not made of Maple system environment
     names  that  begin  with  "_Env", or of any of the following
     Maple global names:

          constants, `constants`, Digits, `Digits`,  mod,  `mod`,
          Order,  `Order`,  printlevel, `printlevel`, Normalizer,
          `Normalizer`, Testzero, `Testzero`, ", `"`,  "",  `""`,
          """, `"""`, op, `op`

OPTIONS
     -p   Allow printing of copyright procedures.

     -w   Suppress warning messages of deleted procedures.

     -h   Suppress printing of file name header.

EXAMPLES
     Update the file myV.2file  and  write  to  standard  output,
     creating file myNewfile:

                    updtsrc myV.2file > myNewfile

     The following example will not be copied from the source:

                  `series/sin` := proc(a,x) ... end;

     This next example will not be copied to  the  source  unless
     option -p is used:

          `name`:= proc() options `Copyright Waterloo Maple Software`;
                   ...
                   end;

     This next example adds a global statement to the  procedure.
     Note  that   w  is  a  global variable under the old and new
     rules and it does not need to be included in a global state-
     ment.

          Input:
               p:= proc(a)
                   local b;
                   x := 10 + w;
                   b := seq(2*y, y = 0 .. 5);
                   for z from 1 to 5 do
                     a := a + 2*z; od
                   end;

          Output:
               p:= proc(a)



Wateloo Maple SoftwareLast change: November 29, 1993                2






UPDTSRC(1)               USER COMMANDS                 UPDTSRC(1)



                   local b;
                   global x,y,z;
                   b := seq(2*y, y = 0 .. 5);
                   ...

SEE ALSO
     m2src(1).

DIAGNOSTICS
     Exit status is 0 for normal exit and 1 if an error occurs.













































Wateloo Maple SoftwareLast change: November 29, 1993                3



