{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--17-*" "n
ew century schoolbook" "Times-Bold" 8 12 64 "Times-Bold" 17}
{SCP_R 1 0 67{COM_R 2 0{TEXT 3 23 "Finite Splitting Fields"}}
{COM_R 3 0{TEXT 1 291 "Michael Monagan\015\015This worksheet is a
n application of Maple to doing some simple calculations over fin
ite fields GF(p^k).\012The application is from error correcting c
odes and was brought to us by Nicolas Sendrier, INRIA, France, in
 May/90.\012We were given a polynomial f(x) of the following form
\012"}}{INP_R 4 0 "> "{TEXT 0 26 "f := a -> 1+x^2+a*x^3+x^4;"}}
{OUT_R 5 0 4{DAG :3n3\`f`@7,2n3\`a`,1,3n5\`operator`n4\`arrow`p7+
9j2x0001p12*3n3\`x`j2x0002p12*5a2x0001p12p16j2x0003p12*3p16j2x000
4p12p7}}{COM_R 6 0{TEXT 1 298 "\015where a = alpha was a given el
ement in K = GF(2^17), and we were asked to determine if the poly
nomial f(alpha) splits into linear factors over K.  It turned out
 that for the alpha we were given, the polynomial did not split. \+
 We were then asked to find an element a in K such that f(a) did \+
split.\012"}}{COM_R 7 0{TEXT 1 208 "First let us define the field
 K(alpha) = GF(2^17) in Maple.  We will represent the elements in
 K as polynomials in alpha where the minimial polynomial for alph
a over GF(2) is this one (which was given to us)\012"}}{INP_R 8 0
 "> "{TEXT 0 26 "minpoly := y^17 + y^3 + 1;"}}{OUT_R 9 0 8{DAG :3
n4\`minpoly`+7*3n3\`y`j2x0017j2x0001*3p6j2x0003pApApA}}{COM_R 10 
0{TEXT 1 77 "\015We can check that this polynomial is irreducible
 over the ground field GF(2)"}}{INP_R 11 0 "> "{TEXT 0 22 "Factor
(minpoly) mod 2;"}}{OUT_R 12 0 11{DAG +7*3n3\`y`j2x0017j2x0001*3p
2j2x0003p6p6p6}}{COM_R 13 0{TEXT 1 222 "\015In Maple we represent
 the elements of a general finite field GF(p^k) as polynomials in
 alpha where alpha is a RootOf the minimal polynomial.  And we us
e the alias command so that RootOf(minpoly) will print nicely as \+
alpha"}}{INP_R 14 0 "> "{TEXT 0 36 "alias( alpha = RootOf(y^17+y^
3+1) ):"}}{COM_R 15 0{TEXT 1 44 "\015As an example, here is the i
nverse of alpha"}}{INP_R 16 0 "> "{TEXT 0 22 "Normal(1/alpha) mod
 2;"}}{OUT_R 17 0 16{DAG +5*3n4\`alpha`j2x0016j2x0001*3p2j2x0002p
7}}{COM_R 18 0{TEXT 1 35 "\015Thus our polynomial in x over K is"
}}{INP_R 19 0 "> "{TEXT 0 9 "f(alpha);"}}{OUT_R 20 0 19{DAG +9j2x
0001p1*3n3\`x`j2x0002p1*5n4\`alpha`p1p5j2x0003p1*3p5j2x0004p1}}
{COM_R 21 0{TEXT 1 318 "\015Our question is: does f(alpha) split \+
over GF(2^17) into linear factors?\012This can be answered by try
ing to factor f(alpha) and looking to see if all the factors are \+
linear.  But since we are only interested in the linear factors, \+
we can just test to see how many roots the the polynomial has - w
hich is more efficient."}}{INP_R 22 0 "> "{TEXT 0 22 "Roots(f(alp
ha)) mod 2;"}}{OUT_R 23 0 22{DAG [2,3[2,3+11*3n4\`alpha`j2x0015j2
x0001*3p6j2x0014pB*3p6j2x0012pB*3p6j2x0010pB*3p6j2x0009pB*3p6j2x0
008pB*3p6j2x0005pBpBpBpB[2,3+15*3p6j2x0016pBp5pBp12pB*3p6j2x0011p
Bp1CpBp21pB*3p6j2x0007pBp26pB*3p6j2x0003pBp6pBpB}}{COM_R 24 0
{TEXT 1 251 "\015This says that there are two roots each with mul
tiplicity 1.  So the polynomial did not split into linear factors
.  Note, another efficient way to test if a polynomial over a fin
ite field factors into linear factors is to test if this conditio
n holds"}}{INP_R 25 0 "> "{TEXT 0 33 "Rem( x^(2^17), f(alpha), x \+
) = x;"}}{OUT_R 26 0 25{DAG =3(3n3\`Rem`,4*3n3\`x`j3x00131072+9j2
x0001pC*3p6j2x0002pC*5n4\`alpha`pCp6j2x0003pC*3p6j2x0004pCp6p6}}
{COM_R 27 0{TEXT 1 431 "\015But we better not try to compute this
 remainder because the input polynomial has degree 131072!!  This
 calculation can be computed efficiently using the Powmod functio
n which uses binary powering with remainder to compute this remai
nder.  The idea is to compute this remainder as  Rem(  Rem( (1310
72)/2, f(alhpa), x )^2, f(alpha), x ).  It is a good excercise to
 write a little program to do this and to determine the actual co
st."}}{INP_R 28 0 "> "{TEXT 0 25 "Powmod(x,2^17,f,x) mod 2;"}}
{OUT_R 29 0 28{DAG j2x0000}}{COM_R 30 0{TEXT 1 250 "\015Now the n
ext question was to try to find an element a of GF(2^17) such tha
t f(a) splits into linear factors.  We do this by simply trying a
 random polynomial in alpha (of degree 16 or less) until we find \+
a good one.  Here is a little loop to do this"}}{INP_R 31 0 "> "
{TEXT 0 2 "do"}}{INP_R 32 0 "> "{TEXT 0 46 "   a := subs( y=alpha
, Randpoly(16,y) mod 2 );"}}{INP_R 33 0 "> "{TEXT 0 67 "   if Pow
mod( x, 2^17, f(a), x ) mod 2 = x then print(a); break fi;"}}
{INP_R 34 0 "> "{TEXT 0 3 "od;"}}{OUT_R 35 0 34{DAG :3n3\`a`+F*3n
4\`alpha`j2x0016j2x0001*3p5j2x0015pA*3p5j2x0012pA*3p5j2x0011pA*3p
5j2x0005pA*3p5j2x0003pApApA}}{OUT_R 36 0 34{DAG :3n3\`a`+15*3n4\`
alpha`j2x0016j2x0001*3p5j2x0012pA*3p5j2x0011pA*3p5j2x0008pA*3p5j2
x0007pA*3p5j2x0006pA*3p5j2x0004pA*3p5j2x0002pAp5pApApA}}{OUT_R 37
 0 34{DAG :3n3\`a`+11*3n4\`alpha`j2x0016j2x0001*3p5j2x0014pA*3p5j
2x0013pA*3p5j2x0011pA*3p5j2x0010pA*3p5j2x0008pA*3p5j2x0005pAp5pA}
}{OUT_R 38 0 34{DAG :3n3\`a`+D*3n4\`alpha`j2x0016j2x0001*3p5j2x00
15pA*3p5j2x0013pA*3p5j2x0012pA*3p5j2x0009pA*3p5j2x0008pA}}{OUT_R 
39 0 34{DAG :3n3\`a`+17*3n4\`alpha`j2x0016j2x0001*3p5j2x0014pA*3p
5j2x0013pA*3p5j2x0012pA*3p5j2x0010pA*3p5j2x0008pA*3p5j2x0007pA*3p
5j2x0004pA*3p5j2x0002pAp5pApApA}}{OUT_R 40 0 34{DAG :3n3\`a`+17*3
n4\`alpha`j2x0016j2x0001*3p5j2x0015pA*3p5j2x0014pA*3p5j2x0013pA*3
p5j2x0011pA*3p5j2x0007pA*3p5j2x0006pA*3p5j2x0004pA*3p5j2x0002pAp5
pApApA}}{OUT_R 41 0 34{DAG :3n3\`a`+1B*3n4\`alpha`j2x0016j2x0001*
3p5j2x0015pA*3p5j2x0014pA*3p5j2x0013pA*3p5j2x0012pA*3p5j2x0011pA*
3p5j2x0009pA*3p5j2x0007pA*3p5j2x0006pA*3p5j2x0005pA*3p5j2x0002pAp
5pApApA}}{OUT_R 42 0 34{DAG :3n3\`a`+F*3n4\`alpha`j2x0016j2x0001*
3p5j2x0015pA*3p5j2x0014pA*3p5j2x0009pA*3p5j2x0007pA*3p5j2x0004pAp
5pA}}{OUT_R 43 0 34{DAG :3n3\`a`+15*3n4\`alpha`j2x0016j2x0001*3p5
j2x0014pA*3p5j2x0010pA*3p5j2x0007pA*3p5j2x0006pA*3p5j2x0005pA*3p5
j2x0004pA*3p5j2x0003pAp5pApApA}}{OUT_R 44 0 34{DAG :3n3\`a`+F*3n4
\`alpha`j2x0016j2x0001*3p5j2x0012pA*3p5j2x0010pA*3p5j2x0009pA*3p5
j2x0008pA*3p5j2x0007pA*3p5j2x0003pA}}{OUT_R 45 0 34{DAG :3n3\`a`+
13*3n4\`alpha`j2x0016j2x0001*3p5j2x0015pA*3p5j2x0014pA*3p5j2x0013
pA*3p5j2x0009pA*3p5j2x0007pA*3p5j2x0005pA*3p5j2x0003pApApA}}
{OUT_R 46 0 34{DAG :3n3\`a`+11*3n4\`alpha`j2x0016j2x0001*3p5j2x00
15pA*3p5j2x0014pA*3p5j2x0013pA*3p5j2x0010pA*3p5j2x0007pA*3p5j2x00
02pAp5pA}}{OUT_R 47 0 34{DAG :3n3\`a`+19*3n4\`alpha`j2x0016j2x000
1*3p5j2x0015pA*3p5j2x0013pA*3p5j2x0012pA*3p5j2x0010pA*3p5j2x0009p
A*3p5j2x0008pA*3p5j2x0007pA*3p5j2x0006pA*3p5j2x0005pA*3p5j2x0004p
A*3p5j2x0002pA}}{OUT_R 48 0 34{DAG +19*3n4\`alpha`j2x0016j2x0001*
3p2j2x0015p7*3p2j2x0013p7*3p2j2x0012p7*3p2j2x0010p7*3p2j2x0009p7*
3p2j2x0008p7*3p2j2x0007p7*3p2j2x0006p7*3p2j2x0005p7*3p2j2x0004p7*
3p2j2x0002p7}}{COM_R 49 0{TEXT 1 14 "\015A final check"}}{INP_R 
50 0 "> "{TEXT 0 18 "Roots(f(a)) mod 2;"}}{OUT_R 51 0 50{DAG [2,5
[2,3+D*3n4\`alpha`j2x0016j2x0001*3p6j2x0011pB*3p6j2x0009pB*3p6j2x
0008pB*3p6j2x0002pBp6pBpB[2,3+15*3p6j2x0015pB*3p6j2x0013pB*3p6j2x
0010pB*3p6j2x0006pB*3p6j2x0005pB*3p6j2x0004pB*3p6j2x0003pBp1CpBp6
pBpBpBpB[2,3+11*3p6j2x0014pBp12pBp17pBp36pBp40pBp45pBp1CpBp6pBpB[
2,3+15p54pB*3p6j2x0012pBpDpBp12pBp17pB*3p6j2x0007pBp36pBp40pBp6pB
pBpBpB}}{COM_R 52 0{TEXT 1 23 "\015Thus our polynomial is"}}
{INP_R 53 0 "> "{TEXT 0 5 "f(a);"}}{OUT_R 54 0 53{DAG +9j2x0001p1
*3n3\`x`j2x0002p1*5+19*3n4\`alpha`j2x0016p1*3pDj2x0015p1*3pDj2x00
13p1*3pDj2x0012p1*3pDj2x0010p1*3pDj2x0009p1*3pDj2x0008p1*3pDj2x00
07p1*3pDj2x0006p1*3pDj2x0005p1*3pDj2x0004p1*3pDp7p1p1p5j2x0003p1*
3p5p42p1}}{COM_R 55 0{TEXT 1 278 "\015For the interested reader, \+
the Roots function uses a probabilistic method to compute the roo
ts of a polynomial over a finite field.  The idea is very nice.  \+
Consider a polynomial in x over GF(p) where p is prime.  We know \+
from Fermat's little theorem that the following is true"}}{INP_R 
56 0 "> "{TEXT 0 16 "'a^p = a mod p';"}}{OUT_R 57 0 56{DAG =3^3n3
\`a`n3\`p`(3n3\`mod`,3p2p4}}{COM_R 58 0{TEXT 1 97 "This means tha
t the polynomial x^p-x has roots 0,1,...,p-1 over GF(p), i.e. it \+
factors as follows"}}{INP_R 59 0 "> "{TEXT 0 33 "x^p-x = Product(
 x-i, i=0..p-1 );"}}{OUT_R 60 0 59{DAG =3+5^3n3\`x`n3\`p`j2x0001p
3i2x0001(3n4\`Product`,3+5p3p7n3\`i`pA=3p14~3j2x0000+5p5p7pAp7}}
{COM_R 61 0{TEXT 1 428 "So suppose we are given a polynomial a(x)
 and we want to compute the roots.  We can compute the product of
 all the linear factors by computing the g = Gcd( a(x), x^p-x ). \+
 This Gcd calculation needs to be computed carefully if p is larg
e.  So the next thing to do is to split g into the linear factors
 to get the roots.  Here comes the probabilistic part of the algo
rithm.  We know that we can write (assuming p is an odd prime)"}}
{INP_R 62 0 "> "{TEXT 0 44 "x^p-x = x*(x^((p-1)/2)-1) * (x^((p-1)
/2)+1);"}}{OUT_R 63 0 62{DAG =3+5^3n3\`x`n3\`p`j2x0001p3i2x0001*7
p3p7+5^3p3+5p5/3p7j2x0002pAp7p7pAp7p7+5^3p3+5p5p14/3pAp16p7p7p7p7
p7}}{COM_R 64 0{TEXT 1 66 "\015Ignoring the factor of x, consider
 now the following calculations"}}{INP_R 65 0 "> "{TEXT 0 79 "'g1
 = Gcd( a(x), x^((p-1)/2)-1 ) mod p', 'g2 = Gcd(a(x), x^((p-1)/2)
+1) mod p';"}}{OUT_R 66 0 65{DAG ,3=3n3\`g1`(3n3\`mod`,3(3n3\`Gcd
`,3(3n3\`a`,2n3\`x`+5^3p10+5n3\`p`/3j2x0001j2x0002/3i2x0001p1Bp19
p19p1Ep19p16=3n3\`g2`(3p5,3(3p9,3pC+5p13p19p19p19p16}}{COM_R 67 0
{TEXT 1 686 "\015These two calculations will with good probabilit
y split the product of linear factors g into two parts.  The next
 idea is instead of computing these Gcd's, to choose an element b
eta at random from GF(p) and compute using x = x+beta instead.  T
he polynomial  (x+beta)^((p-1)/2)-1 will now be a product of diff
erent linear factors.  The idea then is to do the above Gcd calcu
lation for g1 with different beta's until you get a non-trivial s
plitting of g.  Repeat on each factor of g until g is completely \+
split into linear factors.  That's the idea.  One can show that t
he idea generalizes to arbitrary finite fields GF(p^k) and a simi
lar idea can be used to handle the special case p=2."}}{INP_R 68 
0 "> "{TEXT 0 0 ""}}}{END}
