{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-140-*" "helvetica" "Helvetica-Bold" 8 12 0 
"Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--*-140-
*" "times" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe
-courier-medium-r-normal--*-140-*" "courier" "Courier" 4 12 192 "
Courier" 12}{FONT 3 "-adobe-times-bold-i-normal--*-240-*-*-*-*-*-
*" "times" "Times-BoldItalic" 8 12 96 "Times-BoldItalic" 12}{FONT
 4 "-adobe-times-bold-i-normal--*-180-*-*-*-*-*-*" "times" "Times
-BoldItalic" 8 12 96 "Times-BoldItalic" 12}{FONT 5 "-adobe-times-
bold-i-normal--*-180-*-*-*-*-*-*" "times" "Times-BoldItalic" 8 12
 96 "Times-BoldItalic" 12}{SCP_R 1 0 118{COM_R 2 0{TEXT 3 31 "\01
5Matrix-type Pade Approximants\015"}}{COM_R 3 0{TEXT 4 26 "Hermit
e Pade Approximants\015"}}{COM_R 4 0{TEXT 1 637 "The concept of t
he Pade approximant of a function f(x) is well known. One looks f
or polynomials a(x) and b(x) of degrees at most m and n  respecti
vely such that\012\012  f(x) =  a(x)/b(x) + O(x^(m+n+1) )\012\012
Such an approximant does not always exist since it is possible fo
r the order condition to be weakened. One can still obtain the re
quired approximants via solving a linearized equation \012\012  f
(x) b(x) - a(x)  =  O(x^(m+n+1) ).\012\012Under normal conditions
 these two equations end up the same. The result is an approximat
ion to f(x) that is better than using a truncated polynomial as a
n approximation.  For example, for f(x) = arctan(x) we have\012"}
}{INP_R 5 0 "> "{TEXT 0 15 "# read MatPade;"}}{INP_R 6 0 "> "
{TEXT 0 40 "with(share): readshare(MatPade,algebra);"}}{OUT_R 7 0
 6{TEXT 2 71 "See ?share and ?share,contents for information abou
t the share library\012"}}{OUT_R 8 0 6{DAG n1B\`See~`?SigmaBases,
~`?HermitePade,~`?PHPA,~`?SimultaneousPade,~`?RightMatrixPade,~`?
LeftMatrixPade,~`?Pade`}}{INP_R 9 0 "> "{TEXT 0 15 "f := arctan(x
);"}}{OUT_R 10 0 9{DAG :3n3\`f`(3n4\`arctan`,2n3\`x`}}{INP_R 11 0
 "> "{TEXT 0 23 "s := series( f, x, 8);\012"}}{OUT_R 12 0 11{DAG 
:3n3\`s`_Cn3\`x`j2x0001x1/3i2x0001j2x0003x3/3p6j2x0005x5/3pAj2x00
07x7(3n3\`O`,2p6x8}}{COM_R 13 0{TEXT 1 50 "In this case the trunc
ated polynomial is given by\015"}}{INP_R 14 0 "> "{TEXT 0 25 "f1 
:= convert(s,polynom);"}}{OUT_R 15 0 14{DAG :3n3\`f1`+9n3\`x`j2x0
001*3p4j2x0003/3i2x0001pA*3p4j2x0005/3p6p12*3p4j2x0007/3pDp19}}
{COM_R 16 0{TEXT 1 29 "we corresponding error curve\015"}}{INP_R 
17 0 "> "{TEXT 0 20 "plot(f-f1,x=0..100);"}}{COM_R 18 0{TEXT 1 99
 "\015while the Pade approximant of type (3,4) along with the cor
responding error curve can be found as\015"}}{INP_R 19 0 "> "
{TEXT 0 29 "f2 := convert(s,ratpoly,3,4);"}}{OUT_R 20 0 19{DAG :3
n3\`f2`*5+5*3n3\`x`j2x0003/3j2x0011j2x0021p6j2x0001p10+7p10p10*3p
6j2x0002/3j2x0006j2x0007*3p6j2x0004/3p8j2x0035i2x0001}}{INP_R 21 
0 "> "{TEXT 0 20 "plot(f-f2,x=0..100);"}}{COM_R 22 0{TEXT 1 127 "
\015Thus we see that f2 is a much better approximation to f. Howe
ver, it is also the case that for large x we have some problems:\
015"}}{INP_R 23 0 "> "{TEXT 0 20 "limit(f,x=infinity);"}}{OUT_R 
24 0 23{DAG +3n3\`Pi`/3j2x0001j2x0002}}{INP_R 25 0 "> "{TEXT 0 21
 "limit(f2,x=infinity);"}}{OUT_R 26 0 25{DAG j2x0000}}{COM_R 27 0
{TEXT 1 986 "so that this approximation is only so useful. Howeve
r, there are  other approximants which can be used as Pade-like a
pproximants. For example, one can determine polynomials a(x), b(x
) and c(x), having degrees bounded  by m,n, and p, respectively, 
such that\015\012 a(x) f(x)^2 + b(x) f(x) + c(x) = O( x^(m+n+p+2)
 ). \012\012 In this case we have the approximation\012\012 f(x) 
~= ( -b(x) +- sqrt( b(x)^2 - 4*a(x)*c(x) ) / 2/a(x)\012\015 calle
d quadratic approximations. We can use the notion of a  Hermite P
ade approximation to find a quadratic approximant to f. The  Herm
itePade  command inputs a vector [F0, ... , Fk] of power series  
and a vector [n0 , ... , nk ] of degree bounds and returns a vect
or  [H0 , ... , Hk] of polynomials having degrees bounded by the 
ni and where\012\012 F0 H0 + ... + Fk Hk = O(x^( n0 + ... + nk + 
k ) )\012\015They appear in Pade's thesis (Hermite was the superv
isor of Pade). The quadratic approximant is the case where the in
put vector is  [ 1 , f, f^2 ]. In our case above we can do \012"}
}{INP_R 28 0 "> "{TEXT 0 46 "H := HermitePade( [1, f, f^2], x, [2
, 2, 2] );"}}{OUT_R 29 0 28{DAG :3n3\`H`[2,4*3n3\`x`j2x0002+3p6/3
i2x0003j2x0004+5p5/3i2x0005j2x0012/3i2x0001pFj2x0001}}{COM_R 30 0
{TEXT 1 52 "\015which sets up the equation to approximate f(x) an
d\015"}}{INP_R 31 0 "> "{TEXT 0 35 "eq := H[1] + H[2]*y + H[3]*y^
2 = 0;"}}{OUT_R 32 0 31{DAG :3n3\`eq`=3+7*3n3\`x`j2x0002j2x0001*5
p6pAn3\`y`pA/3i2x0003j2x0004*5+5p5/3i2x0005j2x0012/3i2x0001p15pAp
ApFp8pAj2x0000}}{COM_R 33 0{TEXT 1 37 "\015Solving this equation 
for y we get \015"}}{INP_R 34 0 "> "{TEXT 0 20 "F := solve( eq , 
y):"}}{INP_R 35 0 "> "{TEXT 0 23 "f1 := F[1]; f2 := F[2];"}}
{OUT_R 36 0 35{DAG :3n3\`f1`+3*5+5*3n3\`x`j2x0002/3i2x0005j2x0012
/3i2x0001j2x0004j2x0001p11+5p7/3j2x0003p13*3+5p6j2x0225*3p7p13j2x
0240/3p15p9/3p15pEp15p28}}{OUT_R 37 0 35{DAG :3n3\`f2`+3*5+5*3n3\
`x`j2x0002/3i2x0005j2x0012/3i2x0001j2x0004j2x0001p11+5p7/3j2x0003
p13*3+5p6j2x0225*3p7p13j2x0240/3p15p9/3p11pEp15p28}}{COM_R 38 0
{TEXT 1 82 "giving two alternate ``rational-type'' approximants o
f f. At infinity we now have\015"}}{INP_R 39 0 "> "{TEXT 0 31 "L1
 := limit(  f1, x=infinity);\012"}}{OUT_R 40 0 39{DAG :3n3\`L1`+3
*3j2x0015/3j2x0001j2x0002/3i2x0002j2x0005}}{INP_R 41 0 "> "{TEXT 
0 30 "L2 := limit(  f2, x=infinity);"}}{OUT_R 42 0 41{DAG :3n3\`L
2`+3*3j2x0015/3j2x0001j2x0002/3pAj2x0005}}{COM_R 43 0{TEXT 1 69 "
Taking the best approximation to f at infinity and calling it f1 
via\015"}}{INP_R 44 0 "> "{TEXT 0 40 "if signum(L2-L1) = 1 then  
f1 := f2; fi:"}}{COM_R 45 0{TEXT 1 45 "\015we obtain an approxima
tion with error curve\015"}}{INP_R 46 0 "> "{TEXT 0 29 "plot( f -
 f1, x = 0 .. 100 );"}}{COM_R 47 0{TEXT 1 209 " \015There are of 
course various additional computations handled this way.  For exa
mple, for a given f(x) and degrees ni we can find an algebraic eq
uation that is approximately satisfied by f(x). For example, if\0
12"}}{INP_R 48 0 "> "{TEXT 0 16 "f := exp(a*x^3);"}}{OUT_R 49 0 
48{DAG :3n3\`f`(3n3\`exp`,2*5n3\`a`j2x0001n3\`x`j2x0003}}{COM_R 
50 0{TEXT 1 46 "\015with power series expansion about 0 given by\
015"}}{INP_R 51 0 "> "{TEXT 0 19 "s:= series(f,x,24);"}}{OUT_R 52
 0 51{DAG :3n3\`s`_14n3\`x`j2x0001x0n3\`a`x3+3*3p9j2x0002/3p6pFx6
+3*3p9j2x0003/3p6j2x0006x9+3*3p9j2x0004/3p6j2x0024xC+3*3p9j2x0005
/3p6j2x0120xF+3*3p9p1C/3p6j2x0720x12+3*3p9j2x0007/3p6j2x5040x15(3
n3\`O`,2p6x18}}{COM_R 53 0{TEXT 1 186 "then we determine an algeb
raic equation of degree 4 having polynomial coefficients in x of 
degrees at most 6, 3, 2, 5 and 4, respectively,  for which the ab
ove is a series solution by: \015"}}{INP_R 54 0 "> "{TEXT 0 28 "F
 := [1, f, f^2, f^3, f^4 ];"}}{OUT_R 55 0 54{DAG :3n3\`F`[2,6j2x0
001(3n3\`exp`,2*5n3\`a`p5n3\`x`j2x0003*3p7j2x0002*3p7p11*3p7j2x00
04}}{INP_R 56 0 "> "{TEXT 0 44 "H := HermitePade( F , x, [ 6, 3, 
2, 5, 4] );"}}{OUT_R 57 0 56{DAG :3n3\`H`[2,6+9*5+5n3\`a`/3i2x000
1j2x0002j2x0001pFpFn3\`x`j2x0006pF*5+5/3i2x0061j2x0024pF*3p8pB/3j
2x0016j2x0003pFp13p26pFp20/3i2x0187j2x0048*3p8i2x0002/3j2x0209p1D
+7*3p13p26pFp32i2x0016p20/3j2x0026p26+5p32j2x0018p20/3i2x0045j2x0
004+7*5+5p20/3j2x0032p26/3i2x0019p26pFpFp13p26pFp32/3p40p26p20/3j
2x0010p26+7*5+5p20/3p26pD/3i2x0007j2x0008pFpFp13p26pFp32/3i2x0043
p75p20/3j2x0151p30}}{COM_R 58 0{TEXT 1 29 "\015The corresponding 
equation \015"}}{INP_R 59 0 "> "{TEXT 0 53 "eq := H[1] + H[2]*y +
 H[3]*y^2 + H[4]*y^3 + H[5]*y^4;"}}{OUT_R 60 0 59{DAG :3n3\`eq`+1
1*5+5n3\`a`/3i2x0001j2x0002j2x0001pDpDn3\`x`j2x0006pD*5+5/3i2x006
1j2x0024pD*3p6p9/3j2x0016j2x0003pDp11p24pDp1E/3i2x0187j2x0048*3p6
i2x0002/3j2x0209p1B*5+7*3p11p24pDp30i2x0016p1E/3j2x0026p24pDn3\`y
`pDpD*5+5p30j2x0018p1E/3i2x0045j2x0004pDp47pBpD*5+7*5+5p1E/3j2x00
32p24/3i2x0019p24pDpDp11p24pDp30/3p3Fp24p1E/3j2x0010p24pDp47p24pD
*5+7*5+5p1E/3p24pB/3i2x0007j2x0008pDpDp11p24pDp30/3i2x0043p84p1E/
3j2x0151p2EpDp47p54pD}}{COM_R 61 0{TEXT 1 80 "\015then has y =  f
(x)  as a solution, at least to a certain order. To check we do\0
15"}}{INP_R 62 0 "> "{TEXT 0 39 "map(normal,series( subs(y=f,eq),
x,24));"}}{OUT_R 63 0 62{DAG _4n3\`x`(3n3\`O`,2j2x0001x18}}{COM_R
 64 0{TEXT 1 109 " \015Note that the exact solution to the above 
equation has the same series  solution as f(x) as can be seen by\
015"}}{INP_R 65 0 "> "{TEXT 0 21 "S := solve( eq , y );"}}{OUT_R 
66 0 65{DAG :3n3\`S`(3n4\`RootOf`,2+15*5+9j2x0258j2x0001*5n3\`a`p
Dn3\`x`j2x0003i2x0072p10i2x0151*5p10j2x0002p13p15j2x0042pDn3\`_Z`
j2x0004pD*5+9pFi2x0512p1Cj2x0304j2x0256pDp10i2x0160pDp25p15pD*5+5
i2x0864pDp10j2x0540pDp25p1EpD*5+7p1Ci2x0048j2x0768pDp10i2x0416pDp
25pDpDi2x0418pDpFi2x0256*5p10p1Ep13j2x0006p4Bp10j2x0187p1Cj2x0122
*5p10p15p13p61j2x0024}}{INP_R 67 0 "> "{TEXT 0 15 "series(S,x,24)
;"}}{OUT_R 68 0 67{DAG _14n3\`x`j2x0001x0n3\`a`x3+3*3p6j2x0002/3p
3pCx6+3*3p6j2x0003/3p3j2x0006x9+3*3p6j2x0004/3p3j2x0024xC+3*3p6j2
x0005/3p3j2x0120xF+3*3p6p19/3p3j2x0720x12+3*3p6j2x0007/3p3j2x5040
x15(3n3\`O`,2p3x18}}{COM_R 69 0{TEXT 1 30 "\015which compares exa
ctly to s\015:"}}{INP_R 70 0 "> "{TEXT 0 2 "s;"}}{OUT_R 71 0 70
{DAG _14n3\`x`j2x0001x0n3\`a`x3+3*3p6j2x0002/3p3pCx6+3*3p6j2x0003
/3p3j2x0006x9+3*3p6j2x0004/3p3j2x0024xC+3*3p6j2x0005/3p3j2x0120xF
+3*3p6p19/3p3j2x0720x12+3*3p6j2x0007/3p3j2x5040x15(3n3\`O`,2p3x18
}}{COM_R 72 0{TEXT 1 782 "\015 As a second example of the use of 
a Hermite Pade approximant consider  series solutions of differen
tial equations. Often one has a differential   equation without k
nown closed form solutions.  A common method of attack   is to ob
tain a series solution. \012\012Now consider the inverse situatio
n, namely:  given a function f(x),  which \012differential equati
on (of a certain type) is solved by f(x), or at least  solved app
roximately. Again one may use Hermite Pade approximants here. \01
2\012For example, consider the problem of determining a different
ial equation of \012order 4 having polynomial coefficients of deg
rees at most 2, 3, 4, 5 and 6, \012respectively, and for which th
e above is a series solution. You are given \012 initial conditio
ns y(0)=1; D(y)(0)=0; D(D(y))(0)=0. In this case we do\015"}}
{INP_R 73 0 "> "{TEXT 0 56 "F := [f,diff(f,x),diff(f,x$2),diff(f,
x$3), diff(f,x$4)];"}}{OUT_R 74 0 73{DAG :3n3\`F`[2,6(3n3\`exp`,2
*5n3\`a`j2x0001n3\`x`j2x0003+3*7pApCpEj2x0002p5pCp10+5*7pApCpEpCp
5pCj2x0006*7pAp17pEj2x0004p5pCj2x0009+7*5pApCp5pCp24*7pAp17pEp10p
5pCj2x0054*7pAp10pEp24p5pCj2x0027+7*7pAp17pEp17p5pCj2x0180*7pAp10
pEj2x0005p5pCj2x0324*7pAp2ApEj2x0008p5pCj2x0081}}{INP_R 75 0 "> "
{TEXT 0 44 "H := HermitePade( F , x, [ 2, 3, 4, 5, 6] );"}}{OUT_R
 76 0 75{DAG :3n3\`H`[2,6j2x0001p5+B*3n3\`x`j2x0004p5*3pAj2x0003p
C*3pAj2x0002/3i2x0003p16*5+5p5p5*3n3\`a`i2x0001/3j2x0010p11p5pAp5
p5p20/3i2x0002p11+Bp9p5pF/3p23p11p14/3p5j2x0006*5p21p23pAp5/3p16p
11p20/3p23p3C+9*5p21p23pAp16p36p3E/3p5j2x0009p20/3p23j2x0018*3p21
p2F/3p23p54}}{COM_R 77 0{TEXT 1 59 "\015which gives the fourth or
der linear differential equation\015"}}{INP_R 78 0 "> "{TEXT 0 
112 "deq := H[1]*y(x) + H[2]*diff(y(x),x) +  H[3]*diff(y(x),x$2) 
 +\012       H[4]*diff(y(x),x$3) + H[5]*diff(y(x),x$4);"}}{OUT_R 
79 0 78{DAG :3n3\`deq`+B(3n3\`y`,2n3\`x`j2x0001(3n4\`diff`,3p4p8p
A*5+B*3p8j2x0004pA*3p8j2x0003p18*3p8j2x0002/3i2x0003p22*5+5pApA*3
n3\`a`i2x0001/3j2x0010p1DpAp8pApAp2C/3i2x0002p1DpA(3pD,3pCp8pApA*
5+Bp16pAp1B/3p2Fp1Dp20/3pAj2x0006*5p2Dp2Fp8pA/3p22p1Dp2C/3p2Fp51p
A(3pD,3p3Fp8pApA*5+9*5p2Dp2Fp8p22p4Bp53/3pAj2x0009p2C/3p2Fj2x0018
*3p2Dp3B/3p2Fp72pA(3pD,3p60p8pApA}}{COM_R 80 0{TEXT 1 91 "\015We 
see that f(x) really does solve the equation, at least up to a ce
rtain  order by doing\015"}}{INP_R 81 0 "> "{TEXT 0 44 "map(norma
l,series( subs(y(x)=f,deq),x, 24));"}}{OUT_R 82 0 81{DAG _4n3\`x`
(3n3\`O`,2j2x0001x18}}{COM_R 83 0{TEXT 1 101 "\015Comparing this 
to the series solution of the differential equation defined by de
q\015(up to 24 terms),\015"}}{INP_R 84 0 "> "{TEXT 0 12 "Order :=
 24:"}}{INP_R 85 0 "> "{TEXT 0 67 "inits := y(0)= 1, D(y)(0) = 0,
 D(D(y))(0) = 0, D(D(D(y)))(0) = 6*a;"}}{OUT_R 86 0 85{DAG :3n4\`
inits`,5=3(3n3\`y`,2j2x0000j2x0001=3(3(3n3\`D`,2p7p9pA=3(3(3(3n3\
`@@`,3p11j2x0002p13p9pA=3(3(3(3p1B,3p11j2x0003p13p9+3n3\`a`j2x000
6}}{INP_R 87 0 "> "{TEXT 0 41 "dsolve( \{ deq , inits\} , y(x) , 
series );"}}{OUT_R 88 0 87{DAG =3(3n3\`y`,2n3\`x`_14p5j2x0001x0n3
\`a`x3+3*3pCj2x0002/3p9p12x6+3*3pCj2x0003/3p9j2x0006x9+3*3pCj2x00
04/3p9j2x0024xC+3*3pCj2x0005/3p9j2x0120xF+3*3pCp1F/3p9j2x0720x12+
3*3pCj2x0007/3p9j2x5040x15(3n3\`O`,2p9x18}}{COM_R 89 0{TEXT 1 67 
"\015we see that we  get back the same power series as given for 
f(x):\015"}}{INP_R 90 0 "> "{TEXT 0 2 "s;"}}{OUT_R 91 0 90{DAG _1
4n3\`x`j2x0001x0n3\`a`x3+3*3p6j2x0002/3p3pCx6+3*3p6j2x0003/3p3j2x
0006x9+3*3p6j2x0004/3p3j2x0024xC+3*3p6j2x0005/3p3j2x0120xF+3*3p6p
19/3p3j2x0720x12+3*3p6j2x0007/3p3j2x5040x15(3n3\`O`,2p3x18}}
{COM_R 92 0{TEXT 5 32 "\015Simultaneous Pade Approximants\015"}}
{COM_R 93 0{TEXT 1 1025 "Given a vector of power series A(x) = [A
1(x), ... , Ak(x)] and a vector of integers  [n0, ... , nk] consi
der the problem of finding matrices U(x) and V(x) such that\012\0
12  A(x) = U(x) V(x)^(-1)  + O( x^(N+1) )\012\012where U(x) has d
egree less than n0 while row i of V(x) has degree less than ni,\0
12and N = n0 + ... + nk. Thus this resembles a type of matrix gen
eralization of the classical notion of a Pade approximant.\012\01
2Using the adjoint representation of the inverse of a matrix one 
can write  this as\012\012  A(x) = W(x) /d(x) + O(x^(N+1))\012\01
5where W(x) = U(x) adjoint( V(x) ) and d(x) = det( V(x) ). This i
mplies that  one is now looking for a vector W(x) = [W1(x) , ... 
, Wk(x)] where each  Wi has degree at most N - ni and a d(x) of d
egree at most N - n0 such that\012\012 Ai(x) = Wi(x)/d(x) + O(x^(
N+1))\012\012W(x) and d(x) are called a Simultaneous Pade approxi
mant of the vector A(x).\012This notion was introduced by Hermite
 in 1873 and was a fundamental tool in\012 his proof of the trans
cendence of e. \015\015As an  example, with A and n defined below
:\015"}}{INP_R 94 0 "> "{TEXT 0 48 "A1 := exp(2*x): A2 := arctan(
x): A3 := 1 + x^2: "}}{INP_R 95 0 "> "{TEXT 0 19 "A := [ A1, A2, 
A3];"}}{OUT_R 96 0 95{DAG :3n3\`A`[2,4(3n3\`exp`,2+3n3\`x`j2x0002
(3n4\`arctan`,2pA+5j2x0001p15*3pApCp15}}{INP_R 97 0 "> "{TEXT 0 
15 "n := [2,1,2,3];"}}{OUT_R 98 0 97{DAG :3n3\`n`[2,5j2x0002j2x00
01p5j2x0003}}{COM_R 99 0{TEXT 1 76 "\015the simultaneous Pade app
roximant of type n for the vector A  is given by\015 "}}{INP_R 
100 0 "> "{TEXT 0 29 "H := SimultaneousPade(A,x,n);"}}{OUT_R 101 
0 100{DAG :3n3\`H`[2,5+9*3n3\`x`j2x0003/3i2x0825j2x0118*3p7j2x000
2/3j2x1275j2x0059p7/3i2x1155pE/3j2x1785p17j2x0001+11*3p7j2x0007p2
2*3p7j2x0006/3j2x0914j2x0177*3p7j2x0005/3j2x0966p17*3p7j2x0004/3j
2x2145p17p6/3j2x6725pEp10/3j2x3690p17p7/3j2x5985pEp1Ep22+Dp2A/3j2
x0022p17p33/3i2x0068p17p3B/3i2x0220p17p6/3j2x0680p17p10p1Ap7p1E+D
p33pBp3Bp14p6/3i2x0990p17p10/3j2x3060p17p7p1Ap1Ep22}}{COM_R 102 0
{TEXT 1 142 "\015We see that the corresponding components define 
rational functions, all having the same denominator, which approx
imate the components of A. \015"}}{INP_R 103 0 "> "{TEXT 0 11 "d 
:= H[1]; "}}{OUT_R 104 0 103{DAG :3n3\`d`+9*3n3\`x`j2x0003/3i2x08
25j2x0118*3p5j2x0002/3j2x1275j2x0059p5/3i2x1155pC/3j2x1785p15j2x0
001}}{INP_R 105 0 "> "{TEXT 0 12 "W1 := H[2]; "}}{OUT_R 106 0 105
{DAG :3n3\`W1`+11*3n3\`x`j2x0007j2x0001*3p5j2x0006/3j2x0914j2x017
7*3p5j2x0005/3j2x0966j2x0059*3p5j2x0004/3j2x2145p1B*3p5j2x0003/3j
2x6725j2x0118*3p5j2x0002/3j2x3690p1Bp5/3j2x5985p2C/3j2x1785p1Bp9}
}{INP_R 107 0 "> "{TEXT 0 11 "W2 := H[3];"}}{OUT_R 108 0 107{DAG 
:3n3\`W2`+D*3n3\`x`j2x0006/3j2x0022j2x0059*3p5j2x0005/3i2x0068pC*
3p5j2x0004/3i2x0220pC*3p5j2x0003/3j2x0680pC*3p5j2x0002/3i2x1155j2
x0118p5/3j2x1785pC}}{INP_R 109 0 "> "{TEXT 0 11 "W3 := H[4];"}}
{OUT_R 110 0 109{DAG :3n3\`W3`+D*3n3\`x`j2x0005/3i2x0825j2x0118*3
p5j2x0004/3j2x1275j2x0059*3p5j2x0003/3i2x0990p15*3p5j2x0002/3j2x3
060p15p5/3i2x1155pC/3j2x1785p15j2x0001}}{COM_R 111 0{TEXT 1 68 "\
015Forming the rational functions and computing the series expans
ions\015"}}{INP_R 112 0 "> "{TEXT 0 31 "W_over_d := [W1/d, W2/d, 
W3/d]:"}}{INP_R 113 0 "> "{TEXT 0 20 "N := convert(n,`+`);"}}
{OUT_R 114 0 113{DAG :3n3\`N`j2x0008}}{INP_R 115 0 "> "{TEXT 0 28
 "map(series,W_over_d,x, N+1);"}}{OUT_R 116 0 115{DAG [2,4_16n3\`
x`j2x0001x0j2x0002x1p8x2/3j2x0004j2x0003x3/3p8p10x4/3pEj2x0015x5/
3pEj2x0045x6/3j2x0008j2x0315x7/3p8p24x8(3n3\`O`,2p5x9_Cp3p5x1/3i2
x0001p10x3/3p5j2x0005x5/3p36j2x0007x7p2Bx9_6p3p5x0p5x2}}{COM_R 
117 0{TEXT 1 81 "\015we see that these are the  same series expan
sions as for  the original vector A\015"}}{INP_R 118 0 "> "{TEXT 
0 21 "map(series,A,x, N+1);"}}{OUT_R 119 0 118{DAG [2,4_16n3\`x`j
2x0001x0j2x0002x1p8x2/3j2x0004j2x0003x3/3p8p10x4/3pEj2x0015x5/3pE
j2x0045x6/3j2x0008j2x0315x7/3p8p24x8(3n3\`O`,2p5x9_Cp3p5x1/3i2x00
01p10x3/3p5j2x0005x5/3p36j2x0007x7p2Bx9_6p3p5x0p5x2}}}{END}
