{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 12 64 "Times-Roman" 20}{FONT 4 "-adobe-times-medium-r-norm
al--20-*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{FONT 5 
"-adobe-times-medium-r-normal--20-*" "times" "Times-Roman" 4 12 
64 "Times-Roman" 20}{SCP_R 1 0 54{COM_R 2 0{TEXT 3 25 "\015Group \+
Theory with Maple\015"}}{SEP_R 3 0}{COM_R 4 0{TEXT 1 530 "\015Map
le has a group theory package that can be used to generate and ma
nipulate finite groups.\015\015Do you remember the pocket Rubik's
 cube? If you don't, it's a Rubik's cube with only two smaller cu
bes on each edge. We can represent the permutation group generate
d by the three cube twist on the coloured stickers as follows. Ma
ple uses a permutation notation to represent groups.  Each list o
f lists on the next command line is a permutation, with each subl
ist a cycle.  The group is generated by these 3 permutations on 2
1 elements.\015"}}{INP_R 5 0 "> "{TEXT 0 191 "with(group):\012ap \+
:= [[1,2,4,3],[10,8,6,20],[9,7,5,21]]:\012bp := [[5,6,12,11],[1,7
,15,18],[3,13,16,20]]:\012cp := [[18,19,21,20],[16,14,2,5],[17,10
,1,11]]:\012prc := permgroup(21, \{a=ap, b=bp, c=cp\});\012"}}
{OUT_R 6 0 5{DAG :3n3\`prc`(3n5\`permgroup`,3j2x0021%2,4=3n3\`c`[
2,4[2,5j2x0018j2x0019p9j2x0020[2,5j2x0016j2x0014j2x0002j2x0005[2,
5j2x0017j2x0010j2x0001j2x0011=3n3\`a`[2,4[2,5p2Bp21j2x0004j2x0003
[2,5p29j2x0008j2x0006p19[2,5j2x0009j2x0007p23p9=3n3\`b`[2,4[2,5p2
3p41j2x0012p2D[2,5p2Bp48j2x0015p14[2,5p3Aj2x0013p1Dp19}}{COM_R 7 
0{TEXT 1 77 "\015We can test the size of the group. How many ways
 can the cube be scrambled?\015"}}{INP_R 8 0 "> "{TEXT 0 16 "grou
porder(prc);"}}{OUT_R 9 0 8{DAG j3x03674160}}{COM_R 10 0{TEXT 1 
96 "\015We can also test for membership.  Can one cube be twisted
 leaving the rest of the cube intact?\015"}}{INP_R 11 0 "> "{TEXT
 0 30 "groupmember([[12,13,15]],prc);"}}{OUT_R 12 0 11{DAG n4\`fa
lse`}}{COM_R 13 0{TEXT 1 38 "\015Can you exchange two adjacent cu
bes?\015"}}{INP_R 14 0 "> "{TEXT 0 41 "groupmember([[3,12],[6,15]
,[7,13]], prc);"}}{OUT_R 15 0 14{DAG n4\`true`}}{COM_R 16 0{TEXT 
1 141 "\015The obvious six generators of the ordinary Rubik's cub
e are redundant.  Is this the case with the generators we chose f
or our smaller cube?\015"}}{INP_R 17 0 "> "{TEXT 0 83 "pg := perm
group(21, \{a=ap, b=bp\}); permgroup(21, \{a=ap, b=bp\});\012grou
pmember(cp,pg);"}}{OUT_R 18 0 17{DAG :3n3\`pg`(3n5\`permgroup`,3j
2x0021%2,3=3n3\`a`[2,4[2,5j2x0001j2x0002j2x0004j2x0003[2,5j2x0010
j2x0008j2x0006j2x0020[2,5j2x0009j2x0007j2x0005p9=3n3\`b`[2,4[2,5p
2Cp22j2x0012j2x0011[2,5p14p2Aj2x0015j2x0018[2,5p1Aj2x0013j2x0016p
24}}{OUT_R 19 0 17{DAG (3n5\`permgroup`,3j2x0021%2,3=3n3\`a`[2,4[
2,5j2x0001j2x0002j2x0004j2x0003[2,5j2x0010j2x0008j2x0006j2x0020[2
,5j2x0009j2x0007j2x0005p6=3n3\`b`[2,4[2,5p29p1Fj2x0012j2x0011[2,5
p11p27j2x0015j2x0018[2,5p17j2x0013j2x0016p21}}{OUT_R 20 0 17{DAG 
n4\`false`}}{COM_R 21 0{TEXT 1 57 "\015Thus, the order of the two
-twist group must be smaller.\015"}}{INP_R 22 0 "> "{TEXT 0 15 "g
rouporder(pg);"}}{OUT_R 23 0 22{DAG j3x00029160}}{COM_R 24 0{TEXT
 1 369 "Here's a familiar problem, first posed by Conway. Conside
r the group generated by a, b, c d, and e which satisfy ab=c, bc=
d, cd=e, de=a, and ea=b. How many elements are in the group?  Thi
s example shows Maple's other notation for representing a group. \+
 The first set  is a list of generators.   Each list in the secon
d set represents a product of elements equal to 1.\015 "}}{INP_R 
25 0 "> "{TEXT 0 85 "g := grelgroup(\{a, b, c, d, e\},\012\{[a,b,
1/c],[b,c,1/d],[c,d,1/e],[d,e,1/a],[e,a,1/b]\});"}}{OUT_R 26 0 25
{DAG :3n3\`g`(3n5\`grelgroup`,3%2,6n3\`e`n3\`d`n3\`a`n3\`b`n3\`c`
%2,6[2,4p11p13*3pDi2x0001[2,4p13pD*3pBp1D[2,4pDpB*3pFp1D[2,4pBpF*
3p11p1D[2,4pFp11*3p13p1D}}{INP_R 27 0 "> "{TEXT 0 14 "grouporder(
g);"}}{OUT_R 28 0 27{DAG j2x0011}}{COM_R 29 0{TEXT 1 96 "\015Now \+
consider the group generated by a, b, c and d which satisfy d=abc
, a=bcd, b=cda and c=dab.\012"}}{INP_R 30 0 "> "{TEXT 0 77 "g := \+
grelgroup(\{a,b,c,d\},\012\{[a,b,c,1/d],[b,c,d,1/a],[c,d,a,1/b],[
d,a,b,1/c]\});"}}{OUT_R 31 0 30{DAG :3n3\`g`(3n5\`grelgroup`,3%2,
5n3\`d`n3\`a`n3\`b`n3\`c`%2,5[2,5pDpFp11*3pBi2x0001[2,5pBpDpF*3p1
1p1C[2,5pFp11pB*3pDp1C[2,5p11pBpD*3pFp1C}}{COM_R 32 0{TEXT 1 46 "
\015It has a subgroup generated by x=ab and y=ac\015"}}{INP_R 33 
0 "> "{TEXT 0 35 "sg := subgrel(\{x=[a,b],y=[a,c]\},g);"}}{OUT_R 
34 0 33{DAG :3n3\`sg`(3n4\`subgrel`,3%2,3=3n3\`y`[2,3n3\`a`n3\`c`
=3n3\`x`[2,3pFn3\`b`(3n5\`grelgroup`,3%2,5n3\`d`pFp19p11%2,5[2,5p
Fp19p11*3p23i2x0001[2,5p23pFp19*3p11p31[2,5p19p11p23*3pFp31[2,5p1
1p23pF*3p19p31}}{COM_R 35 0{TEXT 1 82 "\015We can now find a comp
lete list of representative elements of the set of cosets.\015"}}
{INP_R 36 0 "> "{TEXT 0 11 "cosets(sg);"}}{OUT_R 37 0 36{DAG %2,5
[2,2n3\`a`[2,2n3\`c`[2,3n3\`b`p8[2,1}}{COM_R 38 0{TEXT 1 43 "\015
Which coset does the product cad fall in?\015"}}{INP_R 39 0 "> "
{TEXT 0 20 "cosrep([c,a,d], sg);"}}{OUT_R 40 0 39{DAG [2,3[2,5*3n
3\`x`i2x0001*3n3\`y`p7p5p5[2,2n3\`c`}}{COM_R 41 0{TEXT 1 214 "The
 first list here is the representative in terms of the subgroup g
enerators, the second in terms of the complete group.\015\015We c
an ask for a representation of  the subgroup in terms of its gene
rators and relations.\015"}}{INP_R 42 0 "> "{TEXT 0 9 "pres(sg);"
}}{OUT_R 43 0 42{DAG (3n5\`grelgroup`,3%2,3n3\`y`n3\`x`%2,4[2,Bp8
*3pAi2x0001p11p11p8pA*3p8p13pAp19pA[2,9p11p8p8p11p19pApAp19[2,9p1
1p8p11p19pAp8pAp19}}{COM_R 44 0{TEXT 1 98 "\015Finally, consider \+
the group generated by x and y such that xxyxyyy = yyxyxxx = 1. H
ow big is it?\012"}}{INP_R 45 0 "> "{TEXT 0 72 "g := grelgroup(\{
x,y\}, \{[x,x,y,x,y,y,y],[y,y,x,y,x,x,x]\});\012grouporder(g);"}}
{OUT_R 46 0 45{DAG :3n3\`g`(3n5\`grelgroup`,3%2,3n3\`y`n3\`x`%2,3
[2,8pDpDpBpDpBpBpB[2,8pBpBpDpBpDpDpD}}{OUT_R 47 0 45{DAG j2x0056}
}{COM_R 48 0{TEXT 1 56 "\015We can get a permutation representati
on of this group.\015"}}{INP_R 49 0 "> "{TEXT 0 34 "pg := permrep
(subgrel(\{y=[y]\},g));"}}{OUT_R 50 0 49{DAG :3n3\`pg`(3n5\`permg
roup`,3j2x0008%2,3=3n3\`x`[2,2[2,8j2x0001j2x0002j2x0005j2x0003j2x
0007p9j2x0006=3n3\`y`[2,2[2,8p16p1Cj2x0004p9p1Ap18p1F}}{COM_R 51 
0{TEXT 1 44 "\015And we can check the group order here too.\015"}
}{INP_R 52 0 "> "{TEXT 0 15 "grouporder(pg);"}}{OUT_R 53 0 52{DAG
 j2x0056}}{INP_R 54 0 "> "{TEXT 0 0 ""}}{COM_R 55 0{TEXT 1 72 "\0
15The sizes are the same, so the permutation representation is fa
ithful.\015"}}}{END}
