{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 14}{FONT 1 "-adobe-times-medium-r-normal--17-*" "ti
mes" "Times-Roman" 4 17 64 "Times-Roman" 17}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-times-medium-r-normal--20-*" "times" "Times-Ro
man" 4 20 64 "Times-Roman" 20}{FONT 4 "-adobe-new century schoolb
ook-bold-i-normal--25-*" "new century schoolbook" "Times-BoldItal
ic" 8 25 96 "Times-BoldItalic" 25}{FONT 5 "-adobe-times-medium-r-
normal--20-*" "times" "Times-Roman" 4 20 64 "Times-Roman" 20}
{SCP_R 1 0 51{COM_R 2 0{TEXT 4 20 "Primitive Trinomials"}}{COM_R 
3 0{TEXT 1 341 "Michael Monagan, Institute for Scientific Computa
tion, ETH Zurich, monagan@inf.ethz.ch\015Keywords: finite fields,
 primitive polynomials, primitive elements\015\015This is an exam
ple of computing with in finite fields in Maple showing how to fi
nd primitive trinomials over GF(2), the finite field with two ele
ments.  These are polynomials of the form"}}{COM_R 4 0{TEXT 1 0 "
"}}{OUT_R 5 0 0{DAG +7^3n3\`x`n3\`n`j2x0001^3p2n3\`m`p6p6p6}}
{COM_R 6 0{TEXT 1 748 "\015which are `primitive' over GF(2).  Pri
mitive polynomials find utility in the generation of error correc
ting codes, random number generators, and the reason trinomials a
re of special interest is because they result in faster computati
on, because most of the terms are zero.\015\015Recall that a poly
nomial a(x) over GF(p) of degree k is said to be primitive if \01
5\015(i)  it is irreducible (it does not factor over GF(p) and\01
5(ii) the element x in GF(p^k) = Zp[x]/<a(x)> is a primitive elem
ent.\015\015The second condition says that the sequence x^i  for 
i=1..p^k-1 generates all the non-zero elements of the the field G
F(p^k).  For example, lets show that the polynomial x^4+x+1 over 
GF(2) is primitive.  For (i) we use the Irreduc function from the
 Maple library\015"}}{INP_R 7 0 "> "{TEXT 0 24 "Irreduc( x^4+x+1)
 mod 2;"}}{OUT_R 8 0 7{DAG n4\`true`}}{COM_R 9 0{TEXT 1 237 "\015
The algorithm Maple uses to show that a polynomial is irreducible
 is known as the Cantor-Zassenhaus distinct degree algorithm.  Fo
r (ii), we must show that the folowing sequence creates all 15 no
n-zero polynomials of degree less than 4\015"}}{INP_R 10 0 "> "
{TEXT 0 70 "s := 1:\012for i from 1 to 15 do s := s, Rem(x^i, x^4
+x+1,x) mod 2 od:\012s;"}}{OUT_R 11 0 10{DAG ,11j2x0001n3\`x`*3p3
j2x0002*3p3j2x0003+5p3p1p1p1+5p5p1p3p1+5p9p1p5p1+7p9p1p3p1p1p1+5p
5p1p1p1+5p9p1p3p1+7p5p1p3p1p1p1+7p9p1p5p1p3p1+9p9p1p5p1p3p1p1p1+7
p9p1p5p1p1p1+5p9p1p1p1p1}}{COM_R 12 0{TEXT 1 592 "\015This is a b
rute force method of showing that x^i generates generates all ele
ments of the field, and clearly it is not possible to do this for
 trinomials with large n, say n = 50.  Here is a Maple program wh
ich computes and prints all primitive trinomials over GF(2) with 
degrees between 10 and 20 using a smarter approach by looking onl
y at x^k where k divides p^k-1 the order of the multiplicative gr
oup. Note the ifactors function returns the factorization of an i
nteger n in the format  [s,[[p1,e1],...,[pm,em]]].  The Powmod fu
nction computes Rem(a^n,b,x) mod p efficiently for large n.\015"}
}{INP_R 13 0 "> "{TEXT 0 570 " readlib(ifactors):\012 for k from 
10 to 20 do\012     n := ifactors(2^k-1);\012     trinomials := N
ULL;\012     for i from 1 to k-1 do\012         candidate := x^k+
x^i+1;\012         if not Irreduc(candidate) mod 2 then next fi;\
012         isPrimitive := true;\012         for j in n[2] while 
isPrimitive do\012             if Powmod(x,(2^k-1)/j[1],candidate
,x) mod 2 = 1 then\012                 isPrimitive := false\012  
           fi;\012         od;\012         if isPrimitive then tr
inomials := trinomials, candidate fi;\012     od;\012     if trin
omials <> NULL then print(`degree `.k, trinomials) fi;\012 od:\01
2"}}{OUT_R 14 0 13{DAG ,4n5\`degree~`10`+7*3n3\`x`j2x0010j2x0001*
3p7j2x0003pBpBpB+7p6pB*3p7j2x0007pBpBpB}}{OUT_R 15 0 13{DAG ,4n5\
`degree~`11`+7*3n3\`x`j2x0011j2x0001*3p7j2x0002pBpBpB+7p6pB*3p7j2
x0009pBpBpB}}{OUT_R 16 0 13{DAG ,8n5\`degree~`15`+7*3n3\`x`j2x001
5j2x0001p7pBpBpB+7p6pB*3p7j2x0004pBpBpB+7p6pB*3p7j2x0007pBpBpB+7p
6pB*3p7j2x0008pBpBpB+7p6pB*3p7j2x0011pBpBpB+7p6pB*3p7j2x0014pBpBp
B}}{OUT_R 17 0 13{DAG ,8n5\`degree~`17`+7*3n3\`x`j2x0017j2x0001*3
p7j2x0003pBpBpB+7p6pB*3p7j2x0005pBpBpB+7p6pB*3p7j2x0006pBpBpB+7p6
pB*3p7j2x0011pBpBpB+7p6pB*3p7j2x0012pBpBpB+7p6pB*3p7j2x0014pBpBpB
}}{OUT_R 18 0 13{DAG ,4n5\`degree~`18`+7*3n3\`x`j2x0018j2x0001*3p
7j2x0007pBpBpB+7p6pB*3p7j2x0011pBpBpB}}{OUT_R 19 0 13{DAG ,4n5\`d
egree~`20`+7*3n3\`x`j2x0020j2x0001*3p7j2x0003pBpBpB+7p6pB*3p7j2x0
017pBpBpB}}{SEP_R 20 0}{SEP_R 21 0}{COM_R 22 0{TEXT 1 199 "\015Fo
r higher degree, the factorization of 2^k-1 will become the bottl
eneck.  We can improve the speed of this particular integer facto
rization by considering first the factorization of the polynomial
\015"}}{OUT_R 23 0 0{DAG +5^3n3\`x`n3\`k`j2x0001i2x0001p6}}{COM_R
 24 0{TEXT 1 30 "For example, for k=50 we have\015"}}{INP_R 25 0 
"> "{TEXT 0 15 "factor(x^50-1);"}}{OUT_R 26 0 25{DAG *D+5n3\`x`j2
x0001i2x0001p4p4+B*3p2j2x0004p4*3p2j2x0003p4*3p2j2x0002p4p2p4p4p4
p4+B*3p2j2x0020p4*3p2j2x0015p4*3p2j2x0010p4*3p2j2x0005p4p4p4p4+5p
2p4p4p4p4+Bp4p4p2p6p15p4p10p6pBp4p4+Bp4p4p2Fp6p2Ap4p25p6p20p4p4}}
{COM_R 27 0{TEXT 1 96 "\015Therefore the factors of the integer 2
^50-1 = 1125899906842623 are the factors of the integers\012"}}
{INP_R 28 0 "> "{TEXT 0 19 "subs(x=2,[op(\")]);\012"}}{OUT_R 29 0
 28{DAG [2,7j2x0001j2x0031j3x01082401j2x0003j2x0011j3x01016801}}
{COM_R 30 0{TEXT 1 34 "\015These integers factor as follows\012"}
}{INP_R 31 0 "> "{TEXT 0 16 "map(ifactor,\");\012"}}{OUT_R 32 0 
31{DAG [2,7j2x0001(3n3\``,2j2x0031*5(3p5,2j2x0601p2(3p5,2j2x1801p
2(3p5,2j2x0003(3p5,2j2x0011*5(3p5,2j2x0251p2(3p5,2j2x4051p2}}
{INP_R 33 0 "> "{TEXT 0 16 "convert(\",`*`);\012"}}{OUT_R 34 0 33
{DAG *F(3n3\``,2j2x0031j2x0001(3p2,2j2x0601p7(3p2,2j2x1801p7(3p2,
2j2x0003p7(3p2,2j2x0011p7(3p2,2j2x0251p7(3p2,2j2x4051p7}}{COM_R 
35 0{TEXT 1 218 "\015Using this idea we can factor a number of th
e form  2^n-1  faster via first factoring the polynomial x^n-1.  
The following Maple procedure factors the integer efficiently and
 the factorizations of 2^90-1 and 2^100-1.\015"}}{INP_R 36 0 "> "
{TEXT 0 144 "fastifactors := proc(n) local f;\012    f := factor(
x^n-1);\012    f := subs(x=2,[op(f)]);\012    f := map(ifactor,f)
;\012    ifactors(convert(f,`*`));\012end:"}}{COM_R 37 0{TEXT 1 0
 ""}}{INP_R 38 0 "> "{TEXT 0 26 "2^90-1 = fastifactors(90);"}}
{OUT_R 39 0 38{DAG =3j8x1237940039285380274899124223[2,3j2x0001[2
,C[2,3j2x0031pB[2,3j2x0007pB[2,3j2x0151pB[2,3j2x0073pB[2,3j2x0631
pB[2,3j3x00023311pB[2,3j2x0003p30[2,3j2x0011pB[2,3j2x0331pB[2,3j2
x0019pB[2,3j3x18837001pB}}{INP_R 40 0 "> "{TEXT 0 28 "2^100-1 = f
astifactors(100);"}}{OUT_R 41 0 40{DAG =3j9x012676506002282294014
96703205375[2,3j2x0001[2,D[2,3j2x0031pC[2,3j2x0601pC[2,3j2x1801pC
[2,3j2x0003pC[2,3j2x0011pC[2,3j2x0251pC[2,3j2x4051pC[2,3j2x0005p2
1[2,3j2x0041pC[2,3j2x0101pC[2,3j3x00268501pC[2,3j2x8101pC}}{SEP_R
 42 0}{SEP_R 43 0}{COM_R 44 0{TEXT 1 305 "\015A second improvemen
t that will save half the work comes from noting the following th
eorem. If x^n + x^m + 1 is primitive then it's self reciprocal po
lynomial x^n + x^(n-m) + 1 is also primitive.  Including both ide
as we have the following program to compute all primitive trinomi
als of degree 90 to 100.\015"}}{INP_R 45 0 "> "{TEXT 0 601 "for k
 from 90 to 100 do\012    n := fastifactors(k);\012    trinomials
 := NULL;\012    for i from 1 to k/2 do\012      candidate := x^k
+x^i+1;\012      if not Irreduc(candidate) mod 2 then next fi;\01
2      isPrimitive := true;\012      for j in n[2] while isPrimit
ive do\012          if Powmod(x,(2^k-1)/j[1],candidate,x) mod 2 =
 1 then\012              isPrimitive := false\012          fi;\01
2      od;\012      if isPrimitive then\012          trinomials :
= trinomials, candidate;\012          if i<k/2 then trinomials :=
 trinomials, x^k+x^(k-i)+1 fi\012      fi;\012    od;\012    if t
rinomials <> NULL then print(`degree `.k, trinomials) fi;\012od:\
012"}}{OUT_R 46 0 45{DAG ,4n5\`degree~`93`+7*3n3\`x`j2x0093j2x000
1*3p7j2x0002pBpBpB+7p6pB*3p7j2x0091pBpBpB}}{OUT_R 47 0 45{DAG ,4n
5\`degree~`94`+7*3n3\`x`j2x0094j2x0001*3p7j2x0021pBpBpB+7p6pB*3p7
j2x0073pBpBpB}}{OUT_R 48 0 45{DAG ,6n5\`degree~`95`+7*3n3\`x`j2x0
095j2x0001*3p7j2x0011pBpBpB+7p6pB*3p7j2x0084pBpBpB+7p6pB*3p7j2x00
17pBpBpB+7p6pB*3p7j2x0078pBpBpB}}{OUT_R 49 0 45{DAG ,An5\`degree~
`97`+7*3n3\`x`j2x0097j2x0001*3p7j2x0006pBpBpB+7p6pB*3p7j2x0091pBp
BpB+7p6pB*3p7j2x0012pBpBpB+7p6pB*3p7j2x0085pBpBpB+7p6pB*3p7j2x003
3pBpBpB+7p6pB*3p7j2x0064pBpBpB+7p6pB*3p7j2x0034pBpBpB+7p6pB*3p7j2
x0063pBpBpB}}{OUT_R 50 0 45{DAG ,6n5\`degree~`98`+7*3n3\`x`j2x009
8j2x0001*3p7j2x0011pBpBpB+7p6pB*3p7j2x0087pBpBpB+7p6pB*3p7j2x0027
pBpBpB+7p6pB*3p7j2x0071pBpBpB}}{OUT_R 51 0 45{DAG ,4n5\`degree~`1
00`+7*3n3\`x`j2x0100j2x0001*3p7j2x0037pBpBpB+7p6pB*3p7j2x0063pBpB
pB}}{INP_R 52 0 "> "{TEXT 0 0 ""}}}{END}
