{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--17-*" "helvetica" "Helvetica-Bold" 8 17 0 "Ti
mes-Bold" 17}{FONT 1 "-adobe-helvetica-medium-r-normal--17-*" "he
lvetica" "Helvetica" 4 17 0 "Helvetica" 17}{FONT 2 "-adobe-courie
r-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
14}{FONT 3 "-adobe-courier-medium-r-normal--14-*" "courier" "Cour
ier" 4 14 192 "Courier" 14}{FONT 4 "-adobe-new century schoolbook
-bold-i-normal--25-*" "new century schoolbook" "Times-BoldItalic"
 8 25 96 "Times-BoldItalic" 25}{FONT 5 "-adobe-times-medium-r-nor
mal--20-*" "times" "Times-Roman" 4 20 64 "Times-Roman" 20}{SCP_R 
1 0 79{COM_R 2 0{TEXT 4 40 "Gradients via Automatic Differentiati
on."}}{COM_R 3 0{TEXT 3 362 "Michael Monagan, monagan@inf.ethz.ch
\015\015This is a collection of examples showing some of the new 
automatic differentation facilities in Maple, including the D ope
rator and GRADIENT routine from the share library.\015\015What is
 automatic differentiation? The reader is probably familiar with 
the Maple diff command which differentiates an expression for for
mula, namely\015"}}{INP_R 4 0 "> "{TEXT 0 13 "diff(f(x),x);"}}
{OUT_R 5 0 4{DAG (3n4\`diff`,3(3n3\`f`,2n3\`x`p9}}{COM_R 6 0{TEXT
 1 98 "\015computes the partial derivative of the formula f(x) wi
th respect to x.  A simple example is this\015"}}{INP_R 7 0 "> "
{TEXT 0 18 "diff( sin(x), x );"}}{OUT_R 8 0 7{DAG (3n3\`cos`,2n3\
`x`}}{COM_R 9 0{TEXT 1 37 "\015A not so simple example is this on
e\015"}}{INP_R 10 0 "> "{TEXT 0 47 "f := x^3*sin(x)^3+(1-cos(x))*
sin(x)^2*x*cos(x);"}}{OUT_R 11 0 10{DAG :3n3\`f`+5*5n3\`x`j2x0003
(3n3\`sin`,2p5p7j2x0001*9+5pFpF(3n3\`cos`pCi2x0001pFp9j2x0002p5pF
p15pFpF}}{INP_R 12 0 "> "{TEXT 0 10 "diff(f,x);"}}{OUT_R 13 0 12
{DAG +D*5n3\`x`j2x0002(3n3\`sin`,2p2j2x0003pB*7p2pBp6p4(3n3\`cos`
p9j2x0001pB*7p6pBp2p17p13p17p17*9+5p17p17p13i2x0001p17p6p17p2p17p
13p4p4*7p23p17p6p4p13p17p17*7p23p17p6pBp2p17p27}}{COM_R 14 0{TEXT
 1 315 "\015The output expression is rather large.  It contains m
any repeated common subexpressions.  Actually, the input also con
tains common subexpressions.  The idea of automatic differentiati
on is to instead of representing the function as a formula in x, 
to represent it as a procedure which takes x as a parameter, thus
\015"}}{INP_R 15 0 "> "{TEXT 0 86 "F := proc(x) local s,c,t; s :=
 sin(x); c := cos(x); t := s*x; x*s*t^2+(1-c)*t*s*c end:"}}{COM_R
 16 0{TEXT 1 219 "\015Obviously this representation of f will be 
more compact than an explicit formula because we are making use o
f local variables to avoid repeated terms. The D operator can be 
used to differentiate a Maple procedure thus\015"}}{INP_R 17 0 ">
 "{TEXT 0 11 "Fx := D(F);"}}{OUT_R 18 0 17{DAG :3n3\`Fx`@8,2n3\`x
`,7n3\`s`n3\`c`n3\`t`n3\`sx`n3\`cx`n3\`tx`,1p14;8:3l2x0004(3n3\`c
os`,2a2x0001:3l2x0001(3n3\`sin`p1D:3l2x0005+3p23i2x0001:3l2x0002p
1A:3l2x0006+5*5p18j2x0001p1Ep38p38p21p38:3l2x0003*5p21p38p1Ep38+F
*5p21p38p40j2x0002p38*7p1Ep38p18p38p40p4Cp38*9p1Ep38p21p38p40p38p
33p38p4C*9p28p38p40p38p21p38p2Fp38p2C*9+5p38p38p2Fp2Cp38p33p38p21
p38p2Fp38p38*9p6Cp38p40p38p18p38p2Fp38p38*9p6Cp38p40p38p21p38p28p
38p38p14p14}{TEXT 2 265 "\012Fx :=\012\012   proc(x)\012   local 
s,c,t,sx,cx,tx;\012       sx := cos(x);\012       s := sin(x);\01
2       cx := -sin(x);\012       c := cos(x);\012       tx := sx*
x+s;\012       t := s*x;\012       s*t^2+x*sx*t^2+2*x*s*t*tx-cx*t
*s*c+(1-c)*tx*s*c+(1-c)*t*sx*c+\012           (1-c)*t*s*cx\012   
end\012"}}{COM_R 19 0{TEXT 1 196 "Does this procedure Fx really c
ompute the derivative of F?  Well, we can check this by using the
 diff routine and noting that Fx(x) will recreate the formula whi
ch should be equal to diff(F(x),x)\015"}}{INP_R 20 0 "> "{TEXT 0 
31 "expand( Fx(x) - diff(F(x),x) );"}}{OUT_R 21 0 20{DAG j2x0000}
}{COM_R 22 0{TEXT 1 124 "\015Now the function Fx does do some red
undant computations.  We can use the Maple optimizer to optimize 
this Maple procedure.\015"}}{INP_R 23 0 "> "{TEXT 0 29 "Fxo := re
adlib(optimize)(Fx);"}}{OUT_R 24 0 23{DAG :3n3\`Fxo`@8,2n3\`x`,Cn
3\`sx`n3\`s`n3\`cx`n3\`c`n3\`tx`n3\`t`n3\`t1`n3\`t2`n3\`t8`n3\`t1
0`n3\`t13`,1p1E;D:3l2x0001(3n3\`cos`,2a2x0001:3l2x0002(3n3\`sin`p
27:3l2x0003+3p2Bi2x0001:3l2x0004p22:3l2x0007*5p22j2x0001p28p41:3l
2x0005+5p3Dp41p2Bp41:3l2x0006*5p2Bp41p28p41:3l2x0008*3p4Ej2x0002:
3l2x0009*5p2Bp41p39p41:3l2x0010+5p41p41p39p36:3l2x0011*5p65p41p4E
p41:3n4\`result`+F*5p2Bp41p56p41p41*5p3Dp41p56p41p41*5p4Ep5Ap46p4
1p5A*7p32p41p4Ep41p5Dp41p36*7p65p41p46p41p5Dp41p41*7p6Dp41p22p41p
39p41p41*7p6Dp41p2Bp41p32p41p41p1Ep1E}{TEXT 2 374 "\012Fxo :=\012
\012    proc(x)\012    local sx,s,cx,c,tx,t,t1,t2,t8,t10,t13;\012
        sx := cos(x);\012        s := sin(x);\012        cx := -s
;\012        c := sx;\012        t1 := sx*x;\012        tx := t1+
s;\012        t := s*x;\012        t2 := t^2;\012        t8 := s*
c;\012        t10 := 1-c;\012        t13 := t10*t;\012        res
ult :=\012            s*t2+t1*t2+2*t^2*tx-cx*t*t8+t10*tx*t8+t13*s
x*c+t13*s*cx\012    end\012"}}{COM_R 25 0{TEXT 1 37 "\015And a si
mple check that Fxo correct\015"}}{INP_R 26 0 "> "{TEXT 0 21 "exp
and(Fx(x)-Fxo(x));"}}{OUT_R 27 0 26{DAG j2x0000}}{COM_R 28 0{TEXT
 1 304 "\015The power of this automatic differentation really bec
omes clear when we have more complicated functions, and want to c
ompute higher order derivatives, gradients and Jacobians.  Recall
 that the gradient of a function f:R^n -> R is the vector of part
ial derviatives. Consider the function below of t,u,v.\015"}}
{INP_R 29 0 "> "{TEXT 0 51 "f := sum( (-1)^i*sin(u*v)*t^i*exp(-t)
/i!, i=0..5 );"}}{OUT_R 30 0 29{DAG :3n3\`f`+D*5(3n3\`sin`,2*5n3\
`u`j2x0001n3\`v`pCpC(3n3\`exp`,2+3n3\`t`i2x0001pCpC*7p5pCp17pCp12
pCp19*7p5pCp17j2x0002p12pC/3pCp29*7p5pCp17j2x0003p12pC/3p19j2x000
6*7p5pCp17j2x0004p12pC/3pCj2x0024*7p5pCp17j2x0005p12pC/3p19j2x012
0}}{COM_R 31 0{TEXT 1 63 "\015We can compute the gradient as a fo
rmula using diff as follows"}}{COM_R 32 0{TEXT 1 0 ""}}{INP_R 33 
0 "> "{TEXT 0 48 "g := array([ diff(f,t), diff(f,u), diff(f,v) ])
;"}}{OUT_R 34 0 33{DAG :3n3\`g`(3n4\`VECTOR`,2[2,4+D*5(3n3\`sin`,
2*5n3\`u`j2x0001n3\`v`p13p13(3n3\`exp`,2+3n3\`t`i2x0001p13i2x0002
*7pCp13p1Ep13p19p13j2x0002*7pCp13p1Ep2Cp19p13p20*7pCp13p1Ej2x0003
p19p13/3p13p3A*7pCp13p1Ej2x0004p19p13/3p20j2x0012*7pCp13p1Ej2x000
5p19p13/3p13j2x0120+D*7(3n3\`cos`pFp13p15p13p19p13p13*9p5Bp13p15p
13p1Ep13p19p13p20*9p5Bp13p15p13p1Ep2Cp19p13/3p13p2C*9p5Bp13p15p13
p1Ep3Ap19p13/3p20j2x0006*9p5Bp13p15p13p1Ep45p19p13/3p13j2x0024*9p
5Bp13p15p13p1Ep51p19p13/3p20p57+D*7p5Bp13p11p13p19p13p13*9p5Bp13p
11p13p1Ep13p19p13p20*9p5Bp13p11p13p1Ep2Cp19p13p78*9p5Bp13p11p13p1
Ep3Ap19p13p84*9p5Bp13p11p13p1Ep45p19p13p91*9p5Bp13p11p13p1Ep51p19
p13p9E}}{SEP_R 35 0}{COM_R 36 0{TEXT 1 0 ""}}{COM_R 37 0{TEXT 1 
97 "Incidentally, Fortran code for these formulae can easily be g
enerated using the fortran command.\015"}}{INP_R 38 0 "> "{TEXT 0
 11 "fortran(g);"}}{OUT_R 39 0 38{TEXT 2 525 "      g(1) = -2*sin
(u*v)*exp(-t)+2*sin(u*v)*t*exp(-t)-sin(u*v)*t**2\\\012*exp(\012  
   #-t)+sin(u*v)*t**3*exp(-t)/3-sin(u*v)*t**4*exp(-t)/12+sin(u*v)
\\\012*t**5\012     #*exp(-t)/120\012      g(2) = cos(u*v)*v*exp(
-t)-cos(u*v)*v*t*exp(-t)+cos(u*v)*v*t**\\\0122*exp\012     #(-t)/
2-cos(u*v)*v*t**3*exp(-t)/6+cos(u*v)*v*t**4*exp(-t)/24-c\\\012os(
u*\012     #v)*v*t**5*exp(-t)/120\012      g(3) = cos(u*v)*u*exp(
-t)-cos(u*v)*u*t*exp(-t)+cos(u*v)*u*t**\\\0122*exp\012     #(-t)/
2-cos(u*v)*u*t**3*exp(-t)/6+cos(u*v)*u*t**4*exp(-t)/24-c\\\012os(
u*\012     #v)*u*t**5*exp(-t)/120\012"}}{INP_R 40 0 "> "{TEXT 0 
21 "fortran(g,optimized);"}}{OUT_R 41 0 40{TEXT 2 505 "      t1 =
 u*v\012      t2 = sin(t1)\012      t3 = exp(-t)\012      t7 = t*
*2\012      t10 = t7*t\012      t13 = t7**2\012      t16 = t13*t\
012      t20 = cos(t1)\012      t21 = t20*v\012      t23 = t*t3\0
12      t25 = t7*t3\012      t27 = t10*t3\012      t29 = t13*t3\0
12      t31 = t16*t3\012      t34 = t20*u\012      g(1) = -2*t2*t
3+2*t2*t*t3-t2*t7*t3+t2*t10*t3/3-t2*t13*t3/12+t\\\0122*t16\012   
  #*t3/120\012      g(2) = t21*t3-t21*t23+t21*t25/2-t21*t27/6+t21
*t29/24-t21*t31/\\\012120\012      g(3) = t34*t3-t34*t23+t34*t25/
2-t34*t27/6+t34*t29/24-t34*t31/\\\012120\012"}}{SEP_R 42 0}{COM_R
 43 0{TEXT 1 166 "\015To use automatic differentiation, we need f
irst to formulate the expression f as a Maple procedure.\015Obvio
usly, we could do this most compactly using a for loop thus\015"}
}{INP_R 44 0 "> "{TEXT 0 31 "F := proc(t,u,v) local i,e,s,p;"}}
{INP_R 45 0 "> "{TEXT 0 32 "    s := sin(u*v); e := exp(-t);"}}
{INP_R 46 0 "> "{TEXT 0 21 "    p := s*e; s := p;"}}{INP_R 47 0 "
> "{TEXT 0 50 "    for i from 1 to 5 do p := -p*t/i; s := s+p od;
"}}{INP_R 48 0 "> "{TEXT 0 5 "    s"}}{INP_R 49 0 "> "{TEXT 0 4 "
end:"}}{COM_R 50 0{TEXT 1 277 "\015This is a very compact represe
ntation of the function f, consequently, computing it's derivativ
e(s) will be relatively simple, and the resulting Maple procedure
 is expected to be much more compact than the large formula above
.  Here is the derivative wrt the first argument t\015"}}{INP_R 
51 0 "> "{TEXT 0 8 "D[1](F);"}}{OUT_R 52 0 51{DAG @8,4n3\`t`n3\`u
`n3\`v`,8n3\`et`n3\`st`n3\`pt`n3\`p`n3\`i`n3\`e`n3\`s`,1p17;B:3l2
x0002j2x0000:3l2x0007(3n3\`sin`,2*5a2x0002j2x0001a2x0003p29:3l2x0
001+3(3n3\`exp`,2+3a2x0001i2x0001p39:3l2x0006p32:3l2x0003+5*5p1Bp
29p3Dp29p29*5p20p29p2Fp29p29:3l2x0004*5p20p29p3Dp29:3p1Bp41:3p20p
51f7l2x0005p29p29j2x0005n4\`true`;5:3p41+5*7p41p29p37p29p5Fp39p39
*5p51p29p5Fp39p39:3p51+3*7p51p29p37p29p5Fp39p39:3p1B+5p1Bp29p41p2
9:3p20+5p20p29p51p29p1Bp17p17}{TEXT 2 267 "\012proc(t,u,v)\012loc
al et,st,pt,p,i,e,s;\012    st := 0;\012    s := sin(u*v);\012   
 et := -exp(-t);\012    e := exp(-t);\012    pt := st*e+s*et;\012
    p := s*e;\012    st := pt;\012    s := p;\012    for i to 5 d
o\012        pt := -pt*t/i-p/i; p := -p*t/i; st := st+pt; s := s+
p\012    od;\012    st\012end\012"}}{COM_R 53 0{TEXT 1 127 "And h
ere is the gradient of F.  We first load the GRADIENT procedure f
rom the Maple share library - using one of the following\015"}}
{INP_R 54 0 "> "{TEXT 0 42 "with(share): readshare(GRADIENT,autod
iff);"}}{INP_R 55 0 "> "{TEXT 0 20 "# read `GRADIENT.m`;"}}{INP_R
 56 0 "> "{TEXT 0 17 "G := GRADIENT(F);"}}{OUT_R 57 0 56{DAG :3n3
\`G`@8,4n3\`t`n3\`u`n3\`v`,8n3\`de`n3\`dp`n3\`ds`n3\`e`n3\`i`n3\`
p`n3\`s`,1p1A;5:3l2x0003(3n4\`array`,2~3j2x0001j2x0003:3l2x0002p2
0:3l2x0001p20;10:3b3p1E,2j2x0002*5(3n3\`cos`,2*5a2x0002p26a2x0003
p26p26p42p26:3b3p1E,2p28*5p3Ap26p3Fp26:3l2x0007(3n3\`sin`p3D:3b3p
2F,2p26+3(3n3\`exp`,2+3a2x0001i2x0001p66:3l2x0004p5F:3b3p2Bp5C*5p
53p26p5Ap26:3b3p2Bp36*5p34p26p6Ap26:3b3p2Bp4B*5p49p26p6Ap26:3l2x0
006*5p53p26p6Ap26:3b3p1Ep5Cp6E:3p34p77:3p49p80:3p53p89f7l2x0005p2
6p26j2x0005n4\`true`;9:3p6E+5*7p6Ep26p64p26p9Fp66p66*5p89p26p9Fp6
6p66:3p77+3*7p77p26p64p26p9Fp66p66:3p80+3*7p80p26p64p26p9Fp66p66:
3p89+3*7p89p26p64p26p9Fp66p66:3p91+5p91p26p6Ep26:3p34+5p34p26p77p
26:3p49+5p49p26p80p26:3p53+5p53p26p89p26(3n4\`RETURN`,4p91p34p49p
1Ap1A}{TEXT 2 803 "\012G := proc(t,u,v)\012     local de,dp,ds,e,
i,p,s;\012         ds := array(1 .. 3);\012         dp := array(1
 .. 3);\012         de := array(1 .. 3);\012         ds[2] := cos
(u*v)*v;\012         ds[3] := cos(u*v)*u;\012         s := sin(u*
v);\012         de[1] := -exp(-t);\012         e := exp(-t);\012 
        dp[1] := s*de[1];\012         dp[2] := ds[2]*e;\012      
   dp[3] := ds[3]*e;\012         p := s*e;\012         ds[1] := d
p[1];\012         ds[2] := dp[2];\012         ds[3] := dp[3];\012
         s := p;\012         for i to 5 do\012             dp[1] 
:= -dp[1]*t/i-p/i;\012             dp[2] := -dp[2]*t/i;\012      
       dp[3] := -dp[3]*t/i;\012             p := -p*t/i;\012     
        ds[1] := ds[1]+dp[1];\012             ds[2] := ds[2]+dp[2
];\012             ds[3] := ds[3]+dp[3];\012             s := s+p
\012         od;\012         RETURN(ds[1],ds[2],ds[3])\012     en
d\012"}}{INP_R 58 0 "> "{TEXT 0 15 "G(0.2,0.3,0.7);"}}{OUT_R 59 0
 58{DAG ,4e3i4x002794701249i2x0010e3j4x004589155611p6e3j4x0019667
80976p6}}{SEP_R 60 0}{COM_R 61 0{TEXT 1 227 "\015The GRADIENT ret
urns a procedure which by default returns a Maple sequence of the
 values of the gradient.  Sometimes the user will want to obtain 
an array of the results.  This can be by setting the following gl
obal variable.\015"}}{INP_R 62 0 "> "{TEXT 0 23 "generate_array :
= true;"}}{OUT_R 63 0 62{DAG :3n6\`generate_array`n4\`true`}}
{INP_R 64 0 "> "{TEXT 0 17 "G := GRADIENT(F);"}}{OUT_R 65 0 64
{DAG :3n3\`G`@8,4n3\`t`n3\`u`n3\`v`,9n3\`de`n3\`dp`n3\`ds`n3\`e`n
3\`grd`n3\`i`n3\`p`n3\`s`,1p1C;6:3l2x0005(3n4\`array`,2~3j2x0001j
2x0003:3l2x0003p22:3l2x0002p22:3l2x0001p22;13:3b3p2D,2j2x0002*5(3
n3\`cos`,2*5a2x0002p28a2x0003p28p28p48p28:3b3p2D,2p2A*5p40p28p45p
28:3l2x0008(3n3\`sin`p43:3b3p35,2p28+3(3n3\`exp`,2+3a2x0001i2x000
1p6C:3l2x0004p65:3b3p31p62*5p59p28p60p28:3b3p31p3C*5p3Ap28p70p28:
3b3p31p51*5p4Fp28p70p28:3l2x0007*5p59p28p70p28:3b3p2Dp62p74:3p3Ap
7D:3p4Fp86:3p59p8Ff7l2x0006p28p28j2x0005n4\`true`;9:3p74+5*7p74p2
8p6Ap28pA5p6Cp6C*5p8Fp28pA5p6Cp6C:3p7D+3*7p7Dp28p6Ap28pA5p6Cp6C:3
p86+3*7p86p28p6Ap28pA5p6Cp6C:3p8F+3*7p8Fp28p6Ap28pA5p6Cp6C:3p97+5
p97p28p74p28:3p3A+5p3Ap28p7Dp28:3p4F+5p4Fp28p86p28:3p59+5p59p28p8
Fp28:3b3p20p62p97:3b3p20p3Cp3A:3b3p20p51p4Fp20p1Cp1C}{TEXT 2 894 
"\012G := proc(t,u,v)\012     local de,dp,ds,e,grd,i,p,s;\012    
     grd := array(1 .. 3);\012         ds := array(1 .. 3);\012  
       dp := array(1 .. 3);\012         de := array(1 .. 3);\012 
        ds[2] := cos(u*v)*v;\012         ds[3] := cos(u*v)*u;\012
         s := sin(u*v);\012         de[1] := -exp(-t);\012       
  e := exp(-t);\012         dp[1] := s*de[1];\012         dp[2] :
= ds[2]*e;\012         dp[3] := ds[3]*e;\012         p := s*e;\01
2         ds[1] := dp[1];\012         ds[2] := dp[2];\012        
 ds[3] := dp[3];\012         s := p;\012         for i to 5 do\01
2             dp[1] := -dp[1]*t/i-p/i;\012             dp[2] := -
dp[2]*t/i;\012             dp[3] := -dp[3]*t/i;\012             p
 := -p*t/i;\012             ds[1] := ds[1]+dp[1];\012            
 ds[2] := ds[2]+dp[2];\012             ds[3] := ds[3]+dp[3];\012 
            s := s+p\012         od;\012         grd[1] := ds[1];
\012         grd[2] := ds[2];\012         grd[3] := ds[3];\012   
      grd\012     end\012"}}{INP_R 66 0 "> "{TEXT 0 15 "G(0.2,0.3
,0.7);"}}{OUT_R 67 0 66{DAG n3t4,1,2~3j2x0001j2x0003h101\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\\\\\\\\\\\\#7x2BB4BCe3j4x004589155611i2x0010x0\x0\\\\\\\\\\\\\\\
\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
\#7x2BAF44e3i4x002794701249p11x0\x0\#7x2BAF4Ce3j4x001966780976p11
x0\x0\\\\\\\\\\\\\\\\\\\\\\\`grd`}}{INP_R 68 0 "> "{TEXT 0 9 "pri
nt(\");"}}{OUT_R 69 0 68{DAG (3n4\`VECTOR`,2[2,4e3i4x002794701249
i2x0010e3j4x004589155611pCe3j4x001966780976pC}}{COM_R 70 0{TEXT 1
 325 "\015It is also possible now to compute Jacobians.  Recall t
hat the Jacobian of n functions g in m variables x is the matrix 
J of partial derivatives, i.e J[i,j] = diff(g[i],x[j]).  Again, w
e can use Maple's diff command to compute the Jacobian matrix of 
our three functions g as follows.  The output now is really quite
 large.\015 "}}{INP_R 71 0 "> "{TEXT 0 48 "[ seq( [seq(diff(g[i],
x),x=[t,u,v])], i=1..3 )];"}}{OUT_R 72 0 71{DAG [2,4[2,4+D*5(3n3\
`sin`,2*5n3\`u`j2x0001n3\`v`pDpD(3n3\`exp`,2+3n3\`t`i2x0001pDj2x0
004*7p6pDp18pDp13pDi2x0004*7p6pDp18j2x0002p13pDp2C*7p6pDp18j2x000
3p13pD/3i2x0002p35*7p6pDp18p1Dp13pD/3pDj2x0008*7p6pDp18j2x0005p13
pD/3p1Aj2x0120+D*7(3n3\`cos`p9pDpFpDp13pDp3A*9p56pDpFpDp18pDp13pD
p2C*9p56pDpFpDp18p2Cp13pDp1A*9p56pDpFpDp18p35p13pD/3pDp35*9p56pDp
FpDp18p1Dp13pD/3p1Aj2x0012*9p56pDpFpDp18p4Cp13pD/3pDp52+D*7p56pDp
BpDp13pDp3A*9p56pDpBpDp18pDp13pDp2C*9p56pDpBpDp18p2Cp13pDp1A*9p56
pDpBpDp18p35p13pDp7D*9p56pDpBpDp18p1Dp13pDp89*9p56pDpBpDp18p4Cp13
pDp96[2,4p54+D*7p6pDpFp2Cp13pDp1A*9p6pDpFp2Cp18pDp13pDpD*9p6pDpFp
2Cp18p2Cp13pD/3p1Ap2C*9p6pDpFp2Cp18p35p13pD/3pDj2x0006*9p6pDpFp2C
p18p1Dp13pD/3p1Aj2x0024*9p6pDpFp2Cp18p4Cp13pDp96+19*9p6pDpBpDpFpD
p13pDp1A*5p56pDp13pDpD*Bp6pDpBpDpFpDp18pDp13pDpD*7p56pDp18pDp13pD
p1A*Bp6pDpBpDpFpDp18p2Cp13pDpF3*7p56pDp18p2Cp13pD/3pDp2C*Bp6pDpBp
DpFpDp18p35p13pDpFF*7p56pDp18p35p13pD/3p1Ap101*Bp6pDpBpDpFpDp18p1
Dp13pDp10C*7p56pDp18p1Dp13pD/3pDp10E*Bp6pDpBpDpFpDp18p4Cp13pDp96*
7p56pDp18p4Cp13pDp50[2,4p99p11A+D*7p6pDpBp2Cp13pDp1A*9p6pDpBp2Cp1
8pDp13pDpD*9p6pDpBp2Cp18p2Cp13pDpF3*9p6pDpBp2Cp18p35p13pDpFF*9p6p
DpBp2Cp18p1Dp13pDp10C*9p6pDpBp2Cp18p4Cp13pDp96}}{COM_R 73 0{TEXT 
1 78 "\015Alternatively, we can obtain the same matrix by computi
ng the gradient of G\015 "}}{INP_R 74 0 "> "{TEXT 0 17 "J := GRAD
IENT(G);"}}{OUT_R 75 0 74{DAG :3n3\`J`@8,4n3\`t`n3\`u`n3\`v`,Fn3\
`dde`n3\`ddp`n3\`dds`n3\`de`n3\`de1`n4\`dgrd`n3\`dp`n3\`dp1`n3\`d
s`n3\`ds1`n3\`e`n3\`i`n3\`p`n3\`s`,1p29;5:3l2x0010(3n4\`array`,2~
3j2x0001j2x0003:3l2x0008p2F:3l2x0005p2F;40:3l2x0006(3p30,3p34p34:
3l2x0003p45:3l2x0009p2F:3l2x0002p45:3l2x0007p2F:3l2x0001p45:3l2x0
004p2F:3b3p4B,3j2x0002p66+3*5(3n3\`sin`,2*5a2x0002p35a2x0003p35p3
5p73p66i2x0001:3b3p4B,3p66p37+5*7p6Bp35p70p35p73p35p79(3n3\`cos`p
6Ep35:3b3p4F,2p66*5p8Ap35p73p35:3b3p4B,3p37p66p81:3b3p4B,3p37p37+
3*5p6Bp35p70p66p79:3b3p4F,2p37*5p8Ap35p70p35:3b3p2Dp92p94:3b3p2Dp
B0pB2:3l2x0014p6B:3b3p5B,3p35p35(3n3\`exp`,2+3a2x0001p79:3b3p5F,2
p35+3pC6p79:3b3p3EpD6pD4:3l2x0011pCB:3b3p53pC8*5pC2p35pC6p35:3b3p
53,3p35p66*5pB8p35pD4p35:3b3p53,3p35p37*5pBDp35pD4p35:3b3p57pD6*5
pC2p35pD4p35:3b3p53,3p66p35*5p90p35pDCp35:3b3p53p65*5p63p35pE1p35
:3b3p53p7E*5p7Cp35pE1p35:3b3p57p92*5p90p35pE1p35:3b3p53,3p37p35*5
pAEp35pDCp35:3b3p53p9C*5p9Ap35pE1p35:3b3p53pA3*5pA1p35pE1p35:3b3p
57pB0*5pAEp35pE1p35:3b3p3ApD6*5pC2p35pDCp35:3b3p3Ap92*5pB8p35pE1p
35:3b3p3ApB0*5pBDp35pE1p35:3l2x0013*5pC2p35pE1p35:3b3p4BpC8pE5:3b
3p4BpF0pEE:3b3p4BpFBpF9:3b3p4FpD6p104:3b3p4Bp10Fp10D:3p63p118:3p7
Cp121:3p90p12A:3b3p4Bp135p133:3p9Ap13E:3pA1p147:3pAEp150:3b3p2DpD
6p159:3pB8p162:3pBDp16B:3pC2p174f7l2x0012p35p35j2x0005n4\`true`;2
1:3pE5+7*7pE5p35pD0p35p1BAp79p79*5p104p35p1BAp79p79*5p159p35p1BAp
79p79:3pEE+5*7pEEp35pD0p35p1BAp79p79*5p162p35p1BAp79p79:3pF9+5*7p
F9p35pD0p35p1BAp79p79*5p16Bp35p1BAp79p79:3p104+5*7p104p35pD0p35p1
BAp79p79*5p174p35p1BAp79p79:3p10D+5*7p10Dp35pD0p35p1BAp79p79*5p12
Ap35p1BAp79p79:3p118+3*7p118p35pD0p35p1BAp79p79:3p121+3*7p121p35p
D0p35p1BAp79p79:3p12A+3*7p12Ap35pD0p35p1BAp79p79:3p133+5*7p133p35
pD0p35p1BAp79p79*5p150p35p1BAp79p79:3p13E+3*7p13Ep35pD0p35p1BAp79
p79:3p147+3*7p147p35pD0p35p1BAp79p79:3p150+3*7p150p35pD0p35p1BAp7
9p79:3p159+5*7p159p35pD0p35p1BAp79p79p208p79:3p162+3*7p162p35pD0p
35p1BAp79p79:3p16B+3*7p16Bp35pD0p35p1BAp79p79:3p174+3*7p174p35pD0
p35p1BAp79p79:3p17C+5p17Cp35pE5p35:3p181+5p181p35pEEp35:3p186+5p1
86p35pF9p35:3p18B+5p18Bp35p104p35:3p190+5p190p35p10Dp35:3p63+5p63
p35p118p35:3p7C+5p7Cp35p121p35:3p90+5p90p35p12Ap35:3p19E+5p19Ep35
p133p35:3p9A+5p9Ap35p13Ep35:3pA1+5pA1p35p147p35:3pAE+5pAEp35p150p
35:3p1AC+5p1ACp35p159p35:3pB8+5pB8p35p162p35:3pBD+5pBDp35p16Bp35:
3pC2+5pC2p35p174p35:3b3p43pC8p17C:3b3p43pF0p181:3b3p43pFBp186:3b3
p43p10Fp190:3b3p43p65p63:3b3p43p7Ep7C:3b3p43p135p19E:3b3p43p9Cp9A
:3b3p43pA3pA1p43p29p29}{TEXT 2 3411 "\012J := proc(t,u,v)\012    
 local dde,ddp,dds,de,de1,dgrd,dp,dp1,ds,ds1,e,i,p,s;\012        
 ds1 := array(1 .. 3);\012         dp1 := array(1 .. 3);\012     
    de1 := array(1 .. 3);\012         dgrd := array(1 .. 3,1 .. 3
);\012         dds := array(1 .. 3,1 .. 3);\012         ds := arr
ay(1 .. 3);\012         ddp := array(1 .. 3,1 .. 3);\012         
dp := array(1 .. 3);\012         dde := array(1 .. 3,1 .. 3);\012
         de := array(1 .. 3);\012         dds[2,2] := -sin(u*v)*v
^2;\012         dds[2,3] := -sin(u*v)*u*v+cos(u*v);\012         d
s[2] := cos(u*v)*v;\012         dds[3,2] := -sin(u*v)*u*v+cos(u*v
);\012         dds[3,3] := -sin(u*v)*u^2;\012         ds[3] := co
s(u*v)*u;\012         ds1[2] := cos(u*v)*v;\012         ds1[3] :=
 cos(u*v)*u;\012         s := sin(u*v);\012         dde[1,1] := e
xp(-t);\012         de[1] := -dde[1,1];\012         de1[1] := de[
1];\012         e := exp(-t);\012         ddp[1,1] := s*dde[1,1];
\012         ddp[1,2] := ds1[2]*de[1];\012         ddp[1,3] := ds
1[3]*de[1];\012         dp[1] := s*de[1];\012         ddp[2,1] :=
 ds[2]*de1[1];\012         ddp[2,2] := dds[2,2]*e;\012         dd
p[2,3] := dds[2,3]*e;\012         dp[2] := ds[2]*e;\012         d
dp[3,1] := ds[3]*de1[1];\012         ddp[3,2] := dds[3,2]*e;\012 
        ddp[3,3] := dds[3,3]*e;\012         dp[3] := ds[3]*e;\012
         dp1[1] := s*de1[1];\012         dp1[2] := ds1[2]*e;\012 
        dp1[3] := ds1[3]*e;\012         p := s*e;\012         dds
[1,1] := ddp[1,1];\012         dds[1,2] := ddp[1,2];\012         
dds[1,3] := ddp[1,3];\012         ds[1] := dp[1];\012         dds
[2,1] := ddp[2,1];\012         dds[2,2] := ddp[2,2];\012         
dds[2,3] := ddp[2,3];\012         ds[2] := dp[2];\012         dds
[3,1] := ddp[3,1];\012         dds[3,2] := ddp[3,2];\012         
dds[3,3] := ddp[3,3];\012         ds[3] := dp[3];\012         ds1
[1] := dp1[1];\012         ds1[2] := dp1[2];\012         ds1[3] :
= dp1[3];\012         s := p;\012         for i to 5 do\012      
       ddp[1,1] := -ddp[1,1]*t/i-dp[1]/i-dp1[1]/i;\012           
  ddp[1,2] := -ddp[1,2]*t/i-dp1[2]/i;\012             ddp[1,3] :=
 -ddp[1,3]*t/i-dp1[3]/i;\012             dp[1] := -dp[1]*t/i-p/i;
\012             ddp[2,1] := -ddp[2,1]*t/i-dp[2]/i;\012          
   ddp[2,2] := -ddp[2,2]*t/i;\012             ddp[2,3] := -ddp[2,
3]*t/i;\012             dp[2] := -dp[2]*t/i;\012             ddp[
3,1] := -ddp[3,1]*t/i-dp[3]/i;\012             ddp[3,2] := -ddp[3
,2]*t/i;\012             ddp[3,3] := -ddp[3,3]*t/i;\012          
   dp[3] := -dp[3]*t/i;\012             dp1[1] := -dp1[1]*t/i-p/i
;\012             dp1[2] := -dp1[2]*t/i;\012             dp1[3] :
= -dp1[3]*t/i;\012             p := -p*t/i;\012             dds[1
,1] := dds[1,1]+ddp[1,1];\012             dds[1,2] := dds[1,2]+dd
p[1,2];\012             dds[1,3] := dds[1,3]+ddp[1,3];\012       
      ds[1] := ds[1]+dp[1];\012             dds[2,1] := dds[2,1]+
ddp[2,1];\012             dds[2,2] := dds[2,2]+ddp[2,2];\012     
        dds[2,3] := dds[2,3]+ddp[2,3];\012             ds[2] := d
s[2]+dp[2];\012             dds[3,1] := dds[3,1]+ddp[3,1];\012   
          dds[3,2] := dds[3,2]+ddp[3,2];\012             dds[3,3]
 := dds[3,3]+ddp[3,3];\012             ds[3] := ds[3]+dp[3];\012 
            ds1[1] := ds1[1]+dp1[1];\012             ds1[2] := ds
1[2]+dp1[2];\012             ds1[3] := ds1[3]+dp1[3];\012        
     s := s+p\012         od;\012         dgrd[1,1] := dds[1,1];\
012         dgrd[1,2] := dds[1,2];\012         dgrd[1,3] := dds[1
,3];\012         dgrd[2,1] := dds[2,1];\012         dgrd[2,2] := 
dds[2,2];\012         dgrd[2,3] := dds[2,3];\012         dgrd[3,1
] := dds[3,1];\012         dgrd[3,2] := dds[3,2];\012         dgr
d[3,3] := dds[3,3];\012         dgrd\012     end\012"}}{COM_R 76 
0{TEXT 1 283 "Although the program is quite long, it does very fe
w computations.  If it was optimized it would be a lot shorter st
ill -- Maple's optimizer is not able to optimize programs with lo
ops in them yet.  Does the J procedure really compute the Jacobia
n?  We can check one of the entries\015\015"}}{INP_R 77 0 "> "
{TEXT 0 38 "expand( J(t,u,v)[2,3] - diff(f,u,v) );"}}{OUT_R 78 0 
77{DAG j2x0000}}{COM_R 79 0{TEXT 1 861 "\015To end this worksheet
 we want to state the algorithm.  We will do so for gradients, as
 partial derivatives is just a special case.  It is really surpri
singly simple.  It is known as the forward mode of differentiatio
n.  Given a function of n parameters x1,...,xn and m local variab
les t1,...,tm, for every assignment statement in the procedure of
 the form\015\015               tj := f(x1,x2,...,xn,t1,...,tm);\
015\015Preceed it by this loop\015\015               for i to n d
o dtj[i] := diff( f(x1,x2,...,xn,t1,t2,...,tm) ) od;\015\015where
 dt is a local vector of dimension n, and the derivative here is 
computed using the chain rule.  Note the local variables are to b
e regarded as functions of x1,...,xn unless it can be shown other
wise, and the uknown derivatives, e.g. diff(tj,xi) are replaced b
y dtj[i].  Finally, replace the\015return value of the function t
n by the vector dtn.\015"}}{INP_R 80 0 "> "{TEXT 0 0 ""}}}{END}
