{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "Courier New"
 "Courier New" "Courier" 4 12 192 "Courier" 10}{FONT 3 "-adobe-ti
mes-medium-r-normal--20-*" "times" "Times-Roman" 4 20 64 "Times-R
oman" 20}{FONT 4 "-adobe-new century schoolbook-bold-i-normal--25
-*" "new century schoolbook" "Times-BoldItalic" 8 25 96 "Times-Bo
ldItalic" 25}{FONT 5 "-adobe-times-medium-r-normal--20-*" "times"
 "Times-Roman" 4 20 64 "Times-Roman" 20}{SCP_R 1 0 146{COM_R 2 0
{TEXT 1 0 ""}}{COM_R 3 0{TEXT 1 146 "This worksheet explores the 
period-doubling bifurcation sequence of the discrete Logistic map
.   \015\015Rob Corless, 9.10.1993, Zuerich\015rcorless@uwo.ca"}}
{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 0 ""}}{INP_R 6 0 "> "
{TEXT 0 20 "f := x -> a*x*(1-x);"}}{COM_R 7 0{TEXT 1 85 "\015The 
following is shorthand for iteration of the map f:  (f@@3)(x) = f
(f(f(x))), etc\015"}}{INP_R 8 0 "> "{TEXT 0 35 "fn := (x,n) -> ex
pand( (f@@n)(x) );"}}{COM_R 9 0{TEXT 1 0 ""}}{COM_R 10 0{TEXT 1 
71 "First, let us look at the fixed points of  f, or the roots of
  x - f(x)"}}{INP_R 11 0 "> "{TEXT 0 9 "x - f(x);"}}{INP_R 12 0 "
> "{TEXT 0 10 "factor(\");"}}{COM_R 13 0{TEXT 1 78 "Solutions are
 x = 0 and x = 1 - 1/a, which is positive if  a is bigger than 1.
"}}{INP_R 14 0 "> "{TEXT 0 13 "trivial := 0;"}}{INP_R 15 0 "> "
{TEXT 0 22 "nontrivial := 1 - 1/a;"}}{COM_R 16 0{TEXT 1 94 "These
 roots will be stable if the derivative is less than 1 in magnitu
de.  Thus we investigate"}}{COM_R 17 0{TEXT 1 105 "the locations 
where the derivative is equal to 1, and the locations where the d
erivative is equal to  -1."}}{COM_R 18 0{TEXT 1 0 ""}}{INP_R 19 0
 "> "{TEXT 0 11 "df := D(f);"}}{INP_R 20 0 "> "{TEXT 0 12 "fp := 
df(x);"}}{INP_R 21 0 "> "{TEXT 0 24 "simple := solve(fp-1,x);"}}
{INP_R 22 0 "> "{TEXT 0 22 "flip := solve(fp+1,x);"}}{INP_R 23 0 
"> "{TEXT 0 44 "plot(\{nontrivial,simple,flip\},a=0..4,-2..2);"}}
{COM_R 24 0{TEXT 1 91 "\015The intersection at (a,x) = (1,0) show
s where the trivial solution loses stability and the"}}{COM_R 25 
0{TEXT 1 89 "nontrivial solution gains stability, through a `simp
le' bifurcation.  The intersection at"}}{COM_R 26 0{TEXT 1 87 "(a
,x) = (3,2/3) shows where the nontrivial equlibrium loses stabili
ty through a period-"}}{COM_R 27 0{TEXT 1 21 "doubling bifurcatio
n."}}{COM_R 28 0{TEXT 1 0 ""}}{COM_R 29 0{TEXT 1 83 "The equlibri
a are stable in between the `flip' curve and the `simple' curve, 
so we "}}{COM_R 30 0{TEXT 1 50 "see that an exchange of stability
 occurs at (1,0)."}}{COM_R 31 0{TEXT 1 41 "We now investigate the
 period-two points."}}{INP_R 32 0 "> "{TEXT 0 14 "f2 := fn(x,2);"
}}{INP_R 33 0 "> "{TEXT 0 17 "factor( x - f2 );"}}{COM_R 34 0
{TEXT 1 0 ""}}{COM_R 35 0{TEXT 1 93 "Notice that the period-1 poi
nts are also period-2 points.  Only the last factor describes the
"}}{COM_R 36 0{TEXT 1 21 "true period-2 points."}}{INP_R 37 0 "> 
"{TEXT 0 20 "period_2 := op(3,\");"}}{INP_R 38 0 "> "{TEXT 0 13 "
discrim(\",x);"}}{INP_R 39 0 "> "{TEXT 0 10 "factor(\");"}}{COM_R
 40 0{TEXT 1 0 ""}}{COM_R 41 0{TEXT 1 113 "This discriminant will
 be zero precisely when there are multiple period-two points; for
 us, that happens at  a=3."}}{COM_R 42 0{TEXT 1 1 "."}}{INP_R 43 
0 "> "{TEXT 0 18 "solve(period_2,x);"}}{INP_R 44 0 "> "{TEXT 0 24
 "r1 := \"[1]; r2 := \"\"[2];"}}{INP_R 45 0 "> "{TEXT 0 15 "map(f
actor,r1);"}}{INP_R 46 0 "> "{TEXT 0 30 "r1 := \": r2 := map(fact
or,r2);"}}{INP_R 47 0 "> "{TEXT 0 37 "plot(\{nontrivial,r1,r2\},a
=2..4,0..2);"}}{COM_R 48 0{TEXT 1 143 "We know from before that t
he period-one solution loses stability at (3,2/3), which is preci
sely where the two new period-two points are `born'."}}{COM_R 49 
0{TEXT 1 0 ""}}{COM_R 50 0{TEXT 1 39 "We now look at stabilty of 
these roots."}}{INP_R 51 0 "> "{TEXT 0 18 "f2p := diff(f2,x);"}}
{INP_R 52 0 "> "{TEXT 0 8 "f2p = 1;"}}{INP_R 53 0 "> "{TEXT 0 19 
"rp := [solve(\",x)];"}}{COM_R 54 0{TEXT 1 99 "Let's plot all thr
ee roots.  But first, we compute the discriminant to decide if th
ey are all real."}}{INP_R 55 0 "> "{TEXT 0 17 "discrim(f2p-1,x);"
}}{INP_R 56 0 "> "{TEXT 0 10 "factor(\");"}}{INP_R 57 0 "> "{TEXT
 0 22 "a^4-4*a^3+7*a^2-6*a+9;"}}{INP_R 58 0 "> "{TEXT 0 15 "plot(
\",a=2..4);"}}{COM_R 59 0{TEXT 1 56 "So the discriminant is posit
ive, and all roots are real."}}{INP_R 60 0 "> "{TEXT 0 50 "plot(\
{Re(rp[1]),Re(rp[2]),Re(rp[3])\},a=3..4,0..2);"}}{COM_R 61 0{TEXT
 1 75 "Now let us plot the nontrivial roots together with this st
ability boundary."}}{INP_R 62 0 "> "{TEXT 0 56 "plot(\{r1,r2,Re(r
p[1]),Re(rp[2]),Re(rp[3])\},a=3..4,0..2);"}}{INP_R 63 0 "> "{TEXT
 0 9 "f2p = -1;"}}{INP_R 64 0 "> "{TEXT 0 19 "rm := [solve(\",x)]
:"}}{INP_R 65 0 "> "{TEXT 0 17 "discrim(f2p+1,x):"}}{INP_R 66 0 "
> "{TEXT 0 10 "factor(\");"}}{INP_R 67 0 "> "{TEXT 0 56 "plot(\{r
1,r2,Re(rm[1]),Re(rm[2]),Re(rm[3])\},a=3..4,0..2);"}}{COM_R 68 0
{TEXT 1 119 "\015On the other hand, THIS plot shows that there is
 a stability change at a little bigger than 3.4--- very interesti
ng!\015\015"}}{COM_R 69 0{TEXT 1 47 "Now let us investigate the p
eriod four points.\015"}}{INP_R 70 0 "> "{TEXT 0 14 "f4 := fn(x,4
);"}}{INP_R 71 0 "> "{TEXT 0 18 "f4 := factor(x-\");"}}{COM_R 72 
0{TEXT 1 229 "\015It is somewhat difficult in a worksheet to pick
 off the desired factor, because the order\015of the factors can 
change with different instances of the worksheet.  Below, we use\
015select.\015\015Later, we just use lprint and cut and paste.\01
5"}}{INP_R 73 0 "> "{TEXT 0 32 "m := max(seq(degree(g,x),g=f4));"
}}{INP_R 74 0 "> "{TEXT 0 51 "period_4 := select( proc(f) degree(
f,x)=m end, f4);"}}{INP_R 75 0 "> "{TEXT 0 13 "discrim(\",x);"}}
{INP_R 76 0 "> "{TEXT 0 10 "factor(\");"}}{COM_R 77 0{TEXT 1 343 
"\015The roots of the discriminant locate possible bifurcation po
ints.  In fact, I know (from\015previous run-throughs of this wor
ksheet) that the factor I want is the a^2-2*a-5 one;\015all the o
ther roots are either complex or larger in magnitude than the roo
ts of this\015factor.  So we look at that one first, but later ve
rify the statement made above.\015"}}{INP_R 78 0 "> "{TEXT 0 12 "
disc_4 := \":"}}{INP_R 79 0 "> "{TEXT 0 10 "a^2-2*a-5;"}}{INP_R 
80 0 "> "{TEXT 0 11 "solve(\",a);"}}{INP_R 81 0 "> "{TEXT 0 11 "e
valf([\"]);"}}{COM_R 82 0{TEXT 1 106 "So when a = 1+sqrt(6), some
thing happens. This agrees with our earlier plot.   What about th
e other roots?"}}{INP_R 83 0 "> "{TEXT 0 38 "a^6-6*a^5+3*a^4+28*a
^3-9*a^2-54*a-135;"}}{INP_R 84 0 "> "{TEXT 0 28 "readlib(realroot
)(\",1/1000);"}}{INP_R 85 0 "> "{TEXT 0 9 "evalf(\");"}}{COM_R 86
 0{TEXT 1 0 ""}}{COM_R 87 0{TEXT 1 139 "Interesting.  There appea
r to be other period-four bifurcations appearing later, around a=
3.96. This may be in one of the stable `windows'."}}{COM_R 88 0
{TEXT 1 0 ""}}{INP_R 89 0 "> "{TEXT 0 10 "a^2-4*a+5;"}}{INP_R 90 
0 "> "{TEXT 0 11 "solve(\",a);"}}{COM_R 91 0{TEXT 1 128 "And the 
other roots are obviously complex.  Thus we have only the two set
s of points at which multiple period-four roots appear."}}{COM_R 
92 0{TEXT 1 0 ""}}{INP_R 93 0 "> "{TEXT 0 27 "subs(a=1+sqrt(6),pe
riod_4);"}}{INP_R 94 0 "> "{TEXT 0 18 "factor(\",sqrt(6));"}}
{COM_R 95 0{TEXT 1 49 "Excellent---we see the multiple roots at t
he end."}}{INP_R 96 0 "> "{TEXT 0 36 "3*6^(1/2)+2-20*x-5*x*6^(1/2
)+25*x^2;"}}{COM_R 97 0{TEXT 1 0 ""}}{COM_R 98 0{TEXT 1 0 ""}}
{INP_R 99 0 "> "{TEXT 0 20 "p_4 := [solve(\",x)];"}}{INP_R 100 0 
"> "{TEXT 0 9 "evalf(\");"}}{COM_R 101 0{TEXT 1 0 ""}}{COM_R 102 
0{TEXT 1 86 "So we have these two double points becoming our four
 period-4 points as `a' increases."}}{COM_R 103 0{TEXT 1 0 ""}}
{COM_R 104 0{TEXT 1 83 "Note that these points also indicate the 
period-2 points lose their stability here:"}}{INP_R 105 0 "> "
{TEXT 0 36 "subs(a=1+sqrt(6),x=p_4[1],period_2);"}}{INP_R 106 0 "
> "{TEXT 0 12 "simplify(\");"}}{INP_R 107 0 "> "{TEXT 0 36 "subs(
a=1+sqrt(6),x=p_4[2],period_2);"}}{INP_R 108 0 "> "{TEXT 0 12 "si
mplify(\");"}}{INP_R 109 0 "> "{TEXT 0 31 "subs(a=1+sqrt(6),x=p_4
[1],f2p);"}}{INP_R 110 0 "> "{TEXT 0 12 "simplify(\");"}}{COM_R 
111 0{TEXT 1 129 "So we see that we have a period-doubling bifurc
ation exactly at this point, and the period-2 solutions lose thei
r stability here."}}{COM_R 112 0{TEXT 1 0 ""}}{INP_R 113 0 "> "
{TEXT 0 31 "subs(a=1+sqrt(6),x=p_4[2],f2p);"}}{INP_R 114 0 "> "
{TEXT 0 12 "simplify(\");"}}{COM_R 115 0{TEXT 1 0 ""}}{COM_R 116 
0{TEXT 1 457 "Now we investigate the period-eight points.  A litt
le cleverness is required for the factorization, and in fact we c
an only go so far before running into real difficulty.\015A compl
ete analysis of the period-eight points needs more cleverness tha
n I am\015exhibiting here.  I believe that there is work by John 
Stephenson which goes much\015farther by being more clever about 
the factorizations; perhaps also work by Keith\015Briggs.  I don'
t have the references handy."}}{COM_R 117 0{TEXT 1 0 ""}}{INP_R 
118 0 "> "{TEXT 0 21 "F := unapply( f4, x);"}}{COM_R 119 0{TEXT 1
 0 ""}}{INP_R 120 0 "> "{TEXT 0 31 "G := unapply(factor(2*x+f4),x
);"}}{COM_R 121 0{TEXT 1 168 "Note that F @ G = (I - f4)@(I+f4) =
 I - f8, and that we have `pre-factored' this polynomial.  Thus w
e can hope to investigate the new, period-eight points at less co
st."}}{COM_R 122 0{TEXT 1 39 "First we break  F  up into its fact
ors."}}{INP_R 123 0 "> "{TEXT 0 28 "F1 := unapply(op(1,F(x)),x);"
}}{INP_R 124 0 "> "{TEXT 0 28 "F2 := unapply(op(2,F(x)),x);"}}
{INP_R 125 0 "> "{TEXT 0 28 "F3 := unapply(op(3,F(x)),x);"}}
{INP_R 126 0 "> "{TEXT 0 28 "F4 := unapply(op(4,F(x)),x);"}}
{INP_R 127 0 "> "{TEXT 0 9 "F1(G(x));"}}{INP_R 128 0 "> "{TEXT 0 
4 "\"/x;"}}{INP_R 129 0 "> "{TEXT 0 13 "discrim(\",x);"}}{INP_R 
130 0 "> "{TEXT 0 10 "factor(\");"}}{INP_R 131 0 "> "{TEXT 0 18 "
disc_8 := \"/a^210:"}}{INP_R 132 0 "> "{TEXT 0 36 "max(seq(abs(c)
,c=[coeffs(disc_8)]));"}}{INP_R 133 0 "> "{TEXT 0 10 "ilog10(\");
"}}{INP_R 134 0 "> "{TEXT 0 21 "Digits := \" + Digits;"}}{INP_R 
135 0 "> "{TEXT 0 17 "fsolve(disc_8,a);"}}{COM_R 136 0{TEXT 1 179
 "We see that the first positive values of a for which period eig
ht points exist are about 3.8460887... and there are other bifurc
ation points very close to those,\015at  a=3.8658...\015\015"}}
{INP_R 137 0 "> "{TEXT 0 9 "F2(G(x));"}}{INP_R 138 0 "> "{TEXT 0 
10 "factor(\");"}}{INP_R 139 0 "> "{TEXT 0 13 "discrim(\",x);"}}
{INP_R 140 0 "> "{TEXT 0 10 "factor(\");"}}{INP_R 141 0 "> "{TEXT
 0 8 "\"/a^240:"}}{INP_R 142 0 "> "{TEXT 0 12 "fsolve(\",a);"}}
{COM_R 143 0{TEXT 1 116 "\015We see that there are more roots nea
r 3.664, but these are ``too late'' since the bifurcation has\015
already occurred."}}{INP_R 144 0 "> "{TEXT 0 9 "F3(G(x));"}}
{INP_R 145 0 "> "{TEXT 0 10 "factor(\");"}}{INP_R 146 0 "> "{TEXT
 0 13 "discrim(\",x);"}}{COM_R 147 0{TEXT 1 392 "Basically, that 
is as far as we can go, I think.  We can do some more discriminan
t\015calculations, and factorizations, but can identify no more b
ifurcation points in potentia.\015\015Numerical techniques, of co
urse, can be used to explore this problem further---\015nonethele
ss I believe it is useful to examine the polynomial algebra here 
in some\015detail, and I hope you found it useful and interesting
."}}}{END}
