{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--17-*" "n
ew century schoolbook" "Times-Bold" 8 12 64 "Times-Bold" 17}{FONT
 4 "-adobe-times-medium-r-normal--20-*" "times" "Times-Roman" 4 
12 64 "Times-Roman" 20}{FONT 5 "-adobe-times-medium-r-normal--20-
*" "times" "Times-Roman" 4 12 64 "Times-Roman" 20}{SCP_R 1 0 75
{COM_R 2 0{TEXT 3 52 "Rational Function Integration via Partial F
ractions\015"}}{COM_R 3 0{TEXT 1 15 "Michael Monagan"}}{COM_R 4 0
{TEXT 1 216 "This worksheet shows how to use Maple as an aid to t
eaching students how to integrate a rational function in x using \+
the method of partial fractions.  The steps of the method and the
 Maple commands needed are shown.\015"}}{COM_R 5 0{TEXT 1 46 "Con
sider the integral of the rational function"}}{INP_R 6 0 "> "
{TEXT 0 39 "f := x^6/(x^5-4*x^4+6*x^3-6*x^2+5*x-2);"}}{OUT_R 7 0 
6{DAG :3n3\`f`*5n3\`x`j2x0006+D*3p4j2x0005j2x0001*3p4j2x0004i2x00
04*3p4j2x0003p6*3p4j2x0002i2x0006p4pBi2x0002pDi2x0001}}{INP_R 8 0
 "> "{TEXT 0 9 "Int(f,x);"}}{OUT_R 9 0 8{DAG (3n3\`Int`,3*5n3\`x`
j2x0006+D*3p5j2x0005j2x0001*3p5j2x0004i2x0004*3p5j2x0003p7*3p5j2x
0002i2x0006p5pCi2x0002pEi2x0001p5}}{COM_R 10 0{TEXT 1 616 "\012Ho
w do we teach students how to do this?\012The method of partial f
ractions is conceptually not difficult. But in explaining the met
hod, it is very easy to get bogged down\012with doing arithmetic \+
on the blackboard.  As an intermediate step, one also has to teac
h how to solve linear equations and\012how to factor the denomina
tor polynomial. And in the end, if one asks a student to actually
 solve a problem by hand,\012they will find it VERY difficult to \+
get all the way through to the right answer because of all the ar
ithmetic that they have to do along the way. This is where Maple \+
can be useful; in doing the arithmetic.\012"}}{COM_R 11 0{TEXT 1 
637 "Here are the steps.\012The first step is to write the ration
al function f as a polynomial q plus a ``proper'' rational functi
on r/d where the degree of the numerator polynomial r is less tha
n the degree of the denominator polynomial d.  What we need to do
 here is to do polynomial long division with remainder, i.e. divi
de d, the denominator of f into n, the numerator of f.  The first
 place where one can make use of Maple is to this polynomial long
 division.  The Maple commands to do this are quo (for quotient) \+
and rem (for remainder).  First we pick off the numerator and den
ominator polynomials and store them in the variables n and d"}}
{INP_R 12 0 "> "{TEXT 0 14 "n := numer(f);"}}{OUT_R 13 0 12{DAG :
3n3\`n`*3n3\`x`j2x0006}}{INP_R 14 0 "> "{TEXT 0 14 "d := denom(f)
;"}}{OUT_R 15 0 14{DAG :3n3\`d`+D*3n3\`x`j2x0005j2x0001*3p5j2x000
4i2x0004*3p5j2x0003j2x0006*3p5j2x0002i2x0006p5p7i2x0002p9}}{INP_R
 16 0 "> "{TEXT 0 16 "q := quo(n,d,x);"}}{OUT_R 17 0 16{DAG :3n3\
`q`+5n3\`x`j2x0001j2x0004p6}}{INP_R 18 0 "> "{TEXT 0 16 "r := rem
(n,d,x);"}}{OUT_R 19 0 18{DAG :3n3\`r`+B*3n3\`x`j2x0004j2x0010*3p
5j2x0003i2x0018*3p5j2x0002j2x0019p5pFj2x0008j2x0001}}{COM_R 20 0
{TEXT 1 22 "Therefore we can write"}}{INP_R 21 0 "> "{TEXT 0 31 "
Int(f,x) = Int(q,x)+Int(r/d,x);"}}{OUT_R 22 0 21{DAG =3(3n3\`Int`
,3*5n3\`x`j2x0006+D*3p6j2x0005j2x0001*3p6j2x0004i2x0004*3p6j2x000
3p8*3p6j2x0002i2x0006p6pDi2x0002pFi2x0001p6+5(3p2,3+5p6pFp13pFp6p
F(3p2,3*5+Bp11j2x0010p17i2x0018p1Cj2x0019p6p3Ej2x0008pFpFpAp27p6p
F}}{COM_R 23 0{TEXT 1 411 "\012So integrating the polynomial part
 is easy.  That leaves us with the ``proper rational function'' p
art r/d.  The second step is to factor the denominator into linea
r or quadratic factors.  Factoring polynomials is quite difficult
 in general and we usually don't teach students how to do this ex
cept for quadratic and perhaps cubic polynomials.  So the next pl
ace where we use Maple is to factor the denominator"}}{INP_R 24 0
 "> "{TEXT 0 15 "d := factor(d);"}}{OUT_R 25 0 24{DAG :3n3\`d`*7+
5n3\`x`j2x0001i2x0002p7p7+5*3p5j2x0002p7p7p7p7+5p5p7i2x0001p7p10}
}{INP_R 26 0 "> "{TEXT 0 11 "Int(r/d,x);"}}{OUT_R 27 0 26{DAG (3n
3\`Int`,3*9+B*3n3\`x`j2x0004j2x0010*3p7j2x0003i2x0018*3p7j2x0002j
2x0019p7p11j2x0008j2x0001p1D+5p7p1Di2x0002p1Di2x0001+5p13p1Dp1Dp1
Dp26+5p7p1Dp26p1Dp23p7}}{COM_R 28 0{TEXT 1 203 "The third step of
 the algorithm for partial fractions is to split this rational fu
nction into pieces.  We can now write down the partial fraction f
orm for the rational function r/d for unknowns a,b,c,e,g"}}{INP_R
 29 0 "> "{TEXT 0 52 "ANSWER := a/(x-1)+b/(x-1)^2+(c+e*x)/(x^2+1)
+g/(x-2);"}}{OUT_R 30 0 29{DAG :3n4\`ANSWER`+9*5n3\`a`j2x0001+5n3
\`x`p8i2x0001p8pEp8*5n3\`b`p8pAi2x0002p8*5+5n3\`c`p8*5n3\`e`p8pBp
8p8p8+5*3pBj2x0002p8p8p8pEp8*5n3\`g`p8+5pBp8p18p8pEp8}}{COM_R 31 
0{TEXT 1 149 "\012Now we need to solve for the unknows a,b,c,e,g.
  First we use Maple to equate coefficients to set up a system of
 linear\012equations to solve.  We have"}}{INP_R 32 0 "> "{TEXT 0
 17 "r/d - ANSWER = 0;"}}{OUT_R 33 0 32{DAG =3+B*9+B*3n3\`x`j2x00
04j2x0010*3p5j2x0003i2x0018*3p5j2x0002j2x0019p5pFj2x0008j2x0001p1
B+5p5p1Bi2x0002p1Bi2x0001+5p11p1Bp1Bp1Bp24+5p5p1Bp24p1Bp21p1B*5n3
\`a`p1Bp2Cp24p24*5n3\`b`p1Bp2Cp21p24*5+5n3\`c`p1B*5n3\`e`p1Bp5p1B
p1Bp1Bp26p24p24*5n3\`g`p1Bp1Ep24p24j2x0000}}{INP_R 34 0 "> "{TEXT
 0 15 "normal(lhs(\"));"}}{OUT_R 35 0 34{DAG +3*9+37i2x0008j2x000
1n3\`g`p5n3\`a`j2x0002n3\`b`i2x0002n3\`c`p10*3n3\`x`j2x0004i2x001
0p16j2x0018*3p16j2x0003p1D*3p16pCi2x0019*5n3\`e`p5p16p5p10*5pAp5p
16p18p5*5pAp5p16p21i2x0003*5pAp5p16pCp21*5pAp5p16p5p3B*5pEp5p16p2
1p5*5pEp5p16pCp10*5pEp5p16p5p5*5p12p5p16p5j2x0005*5p2Ap5p16pCp60*
5p12p5p16p21p5*5p12p5p16pCi2x0004*5p2Ap5p16p18p5*5p2Ap5p16p21p73*
5p7p5p16p18p5*5p7p5p16p21p10*5p7p5p16pCpC*5p7p5p16p5p10p5+5p16p5p
10p5i2x0001+5p24p5p5p5p9F+5p16p5p9Fp5p10p9F}}{COM_R 36 0{TEXT 1 
195 "\012If this expression must be 0 then the numerator must be \+
0.  Pick off the numerator and write it as a polynomial in x with
 coefficients involving the unknowns a,b,c,e,g using the collect \+
command."}}{INP_R 37 0 "> "{TEXT 0 20 "collect(numer(\"),x);"}}
{OUT_R 38 0 37{DAG +13*5+9n3\`a`i2x0001n3\`g`p5n3\`e`p5j2x0010j2x
0001pFn3\`x`j2x0004pF*5+Dn3\`b`p5p3j2x0003pAp14n3\`c`p5i2x0018pFp
7j2x0002pFp12p1DpF*5+Dp21p14p19p28j2x0019pFp3i2x0003pAi2x0005p7i2
x0002pFp12p28pF*5+DpAp28p24pFp19p5p3p1Dp7p28p21p3BpFp12pFpFj2x000
8pFp7p5p3p3Ep19p28p21p28}}{COM_R 39 0{TEXT 1 235 "\012If this pol
ynomial is to be 0, then each coefficient must be 0.  Thefore we \+
need to solve the linear system of equations specified by the coe
fficients.  We can use the coeffs command to pick off the coeffic
ients and put them in a set."}}{INP_R 40 0 "> "{TEXT 0 26 "eqns :
= \{coeffs(\",x)\};    "}}{OUT_R 41 0 40{DAG :3n4\`eqns`%2,6+9n3\
`a`i2x0001n3\`g`p9n3\`e`p9j2x0010j2x0001+Dn3\`b`p9p7j2x0003pEj2x0
004n3\`c`p9i2x0018p13pBj2x0002+Bj2x0008p13pBp9p7i2x0002p16p26p1Fp
26+DpEp26p22p13p16p9p7p1ApBp26p1Fi2x0005+Dp1Fp1Dp16p26j2x0019p13p
7i2x0003pEp41pBp2F}}{COM_R 42 0{TEXT 1 120 "\012The fifth step in
 the algorithm is to solve this linear system of equations.  Here
 we use the solve command to do this."}}{INP_R 43 0 "> "{TEXT 0 
19 "sol := solve(eqns);"}}{OUT_R 44 0 43{DAG :3n3\`sol`%2,6=3n3\`
c`/3i2x0001j2x0010=3n3\`b`/3p9j2x0002=3n3\`e`/3j2x0001j2x0005=3n3
\`a`i2x0003=3n3\`g`/3j2x0064p1A}}{INP_R 45 0 "> "{TEXT 0 23 "pf :
= subs(sol,ANSWER);"}}{OUT_R 46 0 45{DAG :3n3\`pf`+9*3+5n3\`x`j2x
0001i2x0001p8pAi2x0003*3p5i2x0002/3pAj2x0002*5+5/3pAj2x0010p8p6/3
p8j2x0005p8+5*3p6p16p8p8p8pAp8*3+5p6p8p12p8pA/3j2x0064p22}}{COM_R
 47 0{TEXT 1 175 "\015So pf  is the partial fraction representati
on of r/d.  The final sixth step of the algorithm is to integrate
 each of these\012simple rational functions.  I.e. we have to com
pute"}}{INP_R 48 0 "> "{TEXT 0 14 "map(Int,pf,x);"}}{OUT_R 49 0 
48{DAG +9(3n3\`Int`,3+3*3+5n3\`x`j2x0001i2x0001pApCi2x0003p8pA(3p
2,3+3*3p7i2x0002/3pCj2x0002p8pA(3p2,3*5+5/3pCj2x0010pAp8/3pAj2x00
05pA+5*3p8p1EpApApApCp8pA(3p2,3+3*3+5p8pAp1ApApC/3j2x0064p2Fp8pA}
}{COM_R 50 0{TEXT 1 75 "\015This is not difficult to do.  Here we
 use Maple to compute these integrals"}}{INP_R 51 0 "> "{TEXT 0 9
 "value(\");"}}{OUT_R 52 0 51{DAG +B(3n3\`ln`,2+5n3\`x`j2x0001i2x
0001p8i2x0003*3p5pA/3p8j2x0002(3p2,2+5*3p6p14j2x0010p1Dp8/3p8p1D(
3n4\`arctan`,2p6/3pAp1D(3p2,2+5p6p8i2x0002p8/3j2x0064j2x0005}}
{COM_R 53 0{TEXT 1 551 "\015The very good student should now be s
aying to himself - I hate partial fractions - I'd hate to have to
 do all this arithmetic by hand!  Let me try to automate the step
s outlined here, i.e. to program it.  There is one good thing abo
ut programming - you are forced to look at exceptional cases.  Fo
r instance, what if the solutions to the linear system are not un
ique?  Well, you better go back and prove that they are.  Otherwi
se you can't be sure that your program will work!  So the program
ming activity reinforces the need to look at the details.\015"}}
{COM_R 54 0{TEXT 1 228 "In fact if you try to do this you will di
scover a big hole with the method of integration by partial fract
ions.  Namely,\012you can't always factor a polynomial into linea
r and quadratic factors symbolically.  Here are two examples"}}
{INP_R 55 0 "> "{TEXT 0 20 "f1 := factor(x^3-2);"}}{OUT_R 56 0 55
{DAG :3n3\`f1`+5*3n3\`x`j2x0003j2x0001i2x0002p9}}{INP_R 57 0 "> "
{TEXT 0 23 "f2 := factor(x^5+x+11);"}}{OUT_R 58 0 57{DAG :3n3\`f2
`+7*3n3\`x`j2x0005j2x0001p5p9j2x0011p9}}{COM_R 59 0{TEXT 1 230 "\
012In both these cases the polynomials do not factor over the int
egers.  This what Maple's factor command tries to do.  It is howe
ver  possible to factor the first polynomial and express the fact
orization in terms of radicals.  I.e."}}{INP_R 60 0 "> "{TEXT 0 
22 "sols := [solve(f1,x)];"}}{OUT_R 61 0 60{DAG :3n4\`sols`[2,4*3
j2x0002/3j2x0001j2x0003+5p6/3i2x0001p7*7n3\`I`pApC/3pAp7p7p9p19+5
p6p10p14p10}}{COM_R 62 0{TEXT 1 51 "\012Hence the factorization o
f the first polynomial is"}}{INP_R 63 0 "> "{TEXT 0 45 "f1 = (x-s
ols[1]) * (x-sols[2]) * (x-sols[3]);"}}{OUT_R 64 0 63{DAG =3+5*3n
3\`x`j2x0003j2x0001i2x0002p7*7+5p3p7*3j2x0002/3p7p5i2x0001p7+7p3p
7p10/3p7p11*7n3\`I`p7p5p1Dp11p13/3p16p11p7+7p3p7p10p1Dp20p1Dp7}}
{INP_R 65 0 "> "{TEXT 0 11 "expand(f1);"}}{OUT_R 66 0 65{DAG +5*3
n3\`x`j2x0003j2x0001i2x0002p6}}{COM_R 67 0{TEXT 1 107 "\015That f
actorization is complex.  The real factorization is easily obtain
ed by combining the complex factors"}}{INP_R 68 0 "> "{TEXT 0 53 
"f1 = (x-sols[1]) * expand( (x-sols[2])*(x-sols[3]) );"}}{OUT_R 
69 0 68{DAG =3+5*3n3\`x`j2x0003j2x0001i2x0002p7*5+5p3p7*3j2x0002/
3p7p5i2x0001p7+7*3p3p11p7*5p3p7p11p13p7*3p11/3p11p5p7p7}}{COM_R 
70 0{TEXT 1 72 "\015This is essentially what Maple does in this c
ase.  We obtain the answer"}}{INP_R 71 0 "> "{TEXT 0 15 "int( 1/f
1, x );"}}{OUT_R 72 0 71{DAG +7*5j2x0002/3j2x0001j2x0003(3n3\`ln`
,2+5n3\`x`p5*3p2p4i2x0001p5/3p5j2x0006*5p2p4(3pA,2+7*3pEp2p5*5pEp
5p2p4p5*3p2/3p2p7p5p5/3p14j2x0012*7p2p4p7/3p5p2(3n4\`arctan`,2+3*
5p7p3B+5*5p2p2EpEp5p5p5p5p5p4p5/3p14p19}}{COM_R 73 0{TEXT 1 299 "
\015But this is not possible in general.  The second polynomial's
 roots cannot be expressed in terms of exact radicals.  This mean
s that the method of partial fractions is essentially stuck.  Wha
t Maple does at this point if you try to integrate 1/f2 we leave \+
for those users who are really interested."}}{INP_R 74 0 "> "
{TEXT 0 15 "int( 1/f2, x );"}}{OUT_R 75 0 74{DAG (3n3\`sum`,3*5n3
\`_R`j2x0001(3n3\`ln`,2+Dn3\`x`p7*3p5j2x0004/3i4x002928216384j3x0
0831875*3p5j2x0003/3j4x000732054096p1A*3p5j2x0002/3i4x00018300328
4p1Ap5/3j3x04159631j3x00075625/3j2x0256p1Ap7p7=3p5(3n4\`RootOf`,2
+B*3n3\`_Z`j2x0005j3x45753381*3p48p1Fi2x0160*3p48p29i2x0080p48i2x
0015i2x0001p7}}{INP_R 76 0 "> "{TEXT 0 0 ""}}}{END}
