5a 
 	help/share/text/chemistry    
 help/share/text/science      
 help/share/text/physics   
 	help/share/text/numtheory    
 	help/share/text/numtheor         
 readshare    2  *  4  
 f        
 string      4  
 g         *  
 filename         
 r        *   D  >    0           :  .                 
          
 sharename        
 /        0      0     
 .m       :          :  .       
 traperror       *    2  *      @     *   >     
 lasterror          
 ERROR       *   >    
 type        *    
 eval        *         
 	help/share/text/engineering  
 	help/share/text/engineer         
 share/check     #y     J 
 help/share/text/plots    
 	help/share/text/graphics         
 help/share/text/contrib    
 TEXT         *  
          
 Guidelines for contributing to the Maple share library.      
 =======================================================      b 
 The purpose of the share library is to make Maple code and applications      
 worksheets which have been developed by Maple users and groups other than the        
 Maple company Waterloo Maple Software (WMS) freely available to Maple users.         b 
 For code and worksheets to be added to the share library, we require that        b 
 1) you grant WMS a non-exclusive right to distribute your code or worksheet(s)       
    to any Maple user who requests it.  You may wish to include an authors        
    copyright notice in your code so that other parties cannot distribute it,         
 	   or sell it for profit.        b 
 2) you hereby authorize WMS to modify your code or worksheet(s) as required,         
    for example, to correct bugs, and make changes required due to changes in         
 	   new versions of Maple         b 
 3) you provide test file(s) (described below) that adequately test your Maple        
    code so that we can reasonably determine whether the code is working.         b 
 4) you provide Maple style help file(s) (see below) as documentation for your        
    Maple code.       b 
 Points 1) and 2) are stated precisely in the file called "agree".        
 This is also in the on-line help page ?share[agree] .        
 Please read it, fill it out, sign it, and send or fax it to us at        b 
   Dr. Michael Monagan        
   Institute for Scientific Computation, ETH Zentrum,         
 
  CH 8092 Zurich, Switzerland.       
   FAX: +41 (1) 262-3973      
 
  EMAIL: monagan@inf.ethz.ch         b 
 Code and worksheets must be sent by electronic mail to Dr. Monagan at the        
 above address.  Please also tell us which version of Maple you created       
 the code on, and in which versions you want it to be distributed.        
 We also insist (sorry) on electronic mail because this this only feasible        
 way in which we can contact you in case there is a problem with the code.        b 
 We also include some simple coding style conventions below.      b 
 Please understand that you are giving the code to the Maple community.       
 You may not expect the WMS to pay any royalty or other monies for the code.      
 However, WMS will NOT sell your code for profit.         
 You may of course sell or distribute your code yourself.         b b 
 Test files           
 ==========           b 
 The test file should read your code, and for each test, compare      
 the actual answer computed with the answer that it should yield.         
 If the comparison is okay, then the string "okay" should be printed.         
 
Otherwise you should print the bad result.       
 
Thus a typical test would be         b 
 	  a := symmpoly([x,y,z],2):      
   if a = x*y + x*z + y*z then print(okay) else print(a) fi;      b 
 Notice that the correct result is included in the test file.         
 And also that the output of a test which runs correctly is       
 
simply a sequence of okay's.         b 
 Please include the examples that you use in your help file as tests.         
 In writing tests, you should also be aware of the following.         
 Maple, and/or your code may return an answer that looks different,       
 but is the same mathematically.  For example, Maple may return       
 exp(2*x) instead of exp(x)^2 .  In your application, both answers        
 may be acceptable.  Secondly, the output may come in a different         
 order, e.g. [x^2+x+1, x^4+x+1] instead of [x^4+x+1, x^2+x+1].        b b 
 Coding conventions       
 ==================       b 
 1: Global variables      
 -------------------      
 Every programmer has his/her own coding style and we are not         
 going to tell you how to program.  However, please do not use global         
 variables in your procedures unless absolutely necessary.        
 If necessary, please document them in the on-line help documentation.        b 
 The "mint" program will tell you which variables are global in       
 your procedures and which names clash with Maple library functions.      
 Look for global variables that you have forgotten to declare local.      b 
 2: Naming conventions        
 ---------------------        
 Routines and global variables which are not meant to be directly accessed        
 by the user, should be given "slash" names.  E.g. if your package is called      
 foo, and you have a local routine which checks the input, you should call        
 it `foo/check` and not check.  The macro facility will be useful here to         
 avoid having to type `foo/check` throughout the code.  Simply put        b 
 	  macro(foo = `foo/check`);      b 
 at the top of your code.  See ?macro for details         b 
 3: Type checking         
 ----------------         
 Please include adequate type checking.  The type checking also serves        
 as useful documentation for finding errors and understanding which cases         
 your code is intended to handle.  For Maple V Release 2 and later versions,      
 it is possible to declare the type of parameters.  For example, a routine        
 foo which takes an algebraic expression a and an integer n as arguments can      
 be written in this way       b 
   foo := proc(a:algebraic, n:integer)        b 
 A routine foo which takes a list E of polynomials and a list X of variables as       
 	arguments can be written         b 
 
  foo := proc(E:list(polynom),X:list(name))      b 
 4: Miscellaneous         
 ---------------      
 Please do not use the old $ function for creating sequences.         
 Please use instead the seq function.         
 For example, instead of 'f(i)' $ 'i'=1..n use        b 
   seq(f(i),i=1..n);      b 
 The seq function works like a for loop.  It doesn't require quotes and       
 consequently is much simpler to use.  It is also more efficient.         b b 
 
Documentation and Help files         
 
============================         b 
 Remember, your code is only as useful as your documentation is clear.        
 We require that you include Maple style help files which include a description       
 of the user-level procedures and and global variables in your code, plus         
 
examples showing typical usage.      b 
 A TeX or LaTeX document is welcome as additional documentation.      
 An Maple .ms worksheet (Release 2) showing how the package is used,      
 and typical examples, is especially welcome.         b 
 To write a Maple help file for a function called say "symmpoly"      
 one assigns an object of type TEXT to the name `help/text/symmpoly`.         
 A TEXT object is a function whose arguments are Maple strings.       
 For example, here is a help file for the symmpoly function       b 
 
  `help/text/symmpoly` := TEXT(      
   `FUNCTION: symmpoly - generate the symmetric polynomials`,         
   `   `,         
   `CALLING SEQUENCES: symmpoly([x1,x2,...,xn]);  or`,        
   `                   symmpoly([x1,x2,...,xn],m);`,      U 
   `PARAMETERS: x1,x2,...,xn - names`,        
 
  `            m - non-negative integer`,        U 
   `SYNOPSIS:   `,        
   `- The call symmpoly([x1,...,xn],m) returns the symmetric polynomial`,         
   `  in the variables x1,...,xn (which may not necessarily be distinct)`,        
 
  `  having total degree m`,         
   `- The call symmpoly([x1,...,xn]); returns a sequence of the symmetric`,       
   `  polynomials in x1, ..., xn for m = 0..n`,       U 
   `EXAMPLES:   `,        U 
 
  `> symmpoly([u,v,w,x],3);`,        U 
   `                         u v w + u v x + u w x + v w x`,      
 	  `> symmpoly([x,y,z]);`,        U 
   `                      1, x + y + z, x y + x z + y z, x y z`       
   ):         b b 
 When the user does  ?symmpoly  the text of your help file will       
 be printed by Maple in the normal way. I.e. as       b 
   FUNCTION: symmpoly - generate the symmetric polynomials        b 
   CALLING SEQUENCES: symmpoly([x1,x2,...,xn]);  or       
                      symmpoly([x1,x2,...,xn],m);         b 
   ... etc. ...       b b 
 
How to create this TEXT object?      
 
-------------------------------      
 Write the text for the help file in a file as you want it to appear      
 for the user.  You may find it convenient to copy and edit a Maple help file.        
 Under Unix, the C program "helptomaple" that you should find in the same         
 place as "maple" is kept, can be used to create a TEXT object from a file        
 of text.  For example        b 
   helptomaple "help/text/symmpoly" < symmpolyhelp        b 
 outputs the TEXT object for symmpoly above, assigned to the name         
 `help/text/symmpoly`.        b 
 Alternatively, in Maple V Release 2 and later versions of Maple, you can         
 use the makehelp function from the Maple library.  Suppose the text you      
 have for your help file is in the file foo.  Then in Maple do        b 
   > readlib(makehelp): # load from the Maple library         
 	  > makehelp(topic, foo):        
   > save `help/text/topic`, fooTEXT;         b 
 The text file foo is read and converted into a TEXT object and assigned      
 to the variable `help/text/topic`.  This has been saved into the file        
 fooTEXT which you can now include in your Maple src code.  Then when the         
 code loaded into Maple, the on-line help will also be there too.         b 
 Remember also to include the examples used in the help file in your test file!       
 	help/share/text/analysis     
 	help/share/text/calculus         
 	help/share/text/contents       ] *  b 
           Contents of the Maple V Release 3 Share Library        
           ===============================================        b 
 This file contains an overall description of the contents of the Maple       
 share library, instructions for how to load Maple code and Maple worksheets      
 from the share library, and an index of the actual contents.         b 
 We have grouped the contents under the following subject areas.      
 To see the contents for a particular subject area execute the ? command      
 as shown on the right.       b 
   Algebra                              ?share,algebra        
   Analysis (Calculus)                  ?share,analysis  or  ?share,calculus      
   Automatic Differentiation            ?share,autodiff       
   Combinatorics                        ?share,combinat       
   Engineering                          ?share,engineer       
   Graphics and Geometry                ?share,graphics  or  ?share,geometry      
   Linear Algebra                       ?share,linalg         
   Number Theory                        ?share,numtheory      
   Numerics                             ?share,numerics       
   Programming                          ?share,programming        
   Science                              ?share,science        
   Statistics                           ?share,statistics         
   System Tools                         ?share,system         b 
 We have also provided an alphabetical index.  This index lists the contents      
 by name of Maple routine or worksheet and also under topics like Series,         
 Differential Equations, Thermodynamics, etc.  See the help file      b 
   ?share,index       b 
 For each entry, if it is a Maple routine or package, it needs to be loaded       
 before you can use it.  Instructions for how to do this are given below.         
 If it is a Maple worksheet, you need to open the worksheet from the File menu.       
 Instructions for doing this are given under `Loading worksheets' below.      b 
              
 
Loading routines and packages        
 
=============================        b 
 For each entry you will find the name of the routine or package or worksheet         
 on the left and some details about it on the right.  If it is a routine or       
 package you'll find the command needed to load it assuming you have already      
 executed the command with(share);  For example, here is a typical entry      b 
 gfun            > readshare(gfun, calculus); (76K)       
                 SEE ALSO: calculus/gfun.tex  (46K)       b 
                 A package for computing with generating functions.       
                 ...      
                 Bruno Salvy, Bruno.Salvy@inria.fr        
                 Paul Zimmermann, Paul.Zimmermann@inria.fr        b 
 
o The routine or package is called gfun.         
 o Assuming you have already executed the command:  with(share);  this routine        
   or package can be loaded using the command:  readshare(gfun, calculus);        
   The command tells you that the Maple src code can be found in the calculus         
   directory in the share library.        
 o The number 76K in parenthesis tells you that the code is approximately         
   76 kilo-bytes in size, so this code is a relatively large piece of code.       
   Note size figures are not given for packages smaller than 30K bytes.       
 o After loading the code, on-line help is available using  ?gfun         
   In this case, ?gfun brings up the main help page for the gfun package.         
 o The SEE ALSO: line points to additional files related to this package.         
   They are typically documentation files, additional examples or applications.       
   In the case of the gfun package, there is a LaTeX file of size 46K which       
 
  includes many nice additional examples.        
 o Next comes a brief description of what the Maple routine or package contains       
   and what it does.      
 o Finally, the authors' names and electronic mail addresses are given should you         
   wish to contact them about the code.  The original Maple src code is kept in       
   the share library should you want to look at it or modify it.  If you do       
   modify the code, please respect any authors' copyright notice on the code.         b 
 In summary, the normal way to load code from the share library is to first do        b 
    > with(share);        b 
 Next you load the routine or package that you want to use        b 
 
   > readshare(gfun, calculus);      b 
 Now you can read the on-line documentation using         b 
    > ?gfun           b 
 Since gfun is a Maple package, you may now do        b 
    > with(gfun);         b b 
 	Where is the Share Library?      
 	===========================      b 
 The command with(share); tries to locate the share library.      
 If successful it sets the Maple global variable `sharename' to be the path       
 of where the Maple share library is on your computer.  On my Sun computer,       
 after doing  with(share);  I have        b 
    > sharename;      b 
                        /home/rutishauser/ru2/maple/share         b 
 On a PC, after doing  with(share);  you should see something like        b ( b 
                                C:/maplev3/share      b 
 The sharename variable is used by the readshare function to read in a Maple      
 routine or package from the share library.  The with(share); command also        
 sets the Maple global variable libname to be the sequence libname, sharename         
 so that the readlib command will search the Maple library first, then the        
 share library.  On my Sun computer, after doing  with(share);  I have        b 
    > libname;        b 
        /home/rutishauser/ru2/maple/lib, /home/rutishauser/ru2/maple/share        b A b  b 
                       C:/maplev3/lib, C:/maplev3/share       b 
 (Note: for those of you who are more familiar with Maple, you will be able to        
  load code from the share library also using the read and readlib commands.)         b 
 If, however, for some reason this does not work, you can always load code        
 directly using the read command by reading in the Maple src code.  You will      
 need to know where the share library is located on your computer so that         
 you can give the read command the correct directory path for the code.       
 On my Sun computer, I am also able to load the gfun package using the command        b 
    > read `/home/rutishauser/ru2/maple/share/calculus/gfun`;         b 
 And on a PC with         b 
 
   > read `C:/maplev3/lib/calculus/gfun.m`;      b b 
 	Files in the Share Library       
 	==========================       b 
 Here is a description of the of files that are in the share library.         
 
Files ending with the suffix         b 
 
   .tex     are LaTeX or plain TeX files         
 
   .dvi     are device independent files         
    .sty     are LaTeX style files        b 
    .ms      are Maple worksheets         
    .in      are Input files for Maple containing examples        
    .ps      are PostScript files         b 
    .lib     is a Maple library archive       
    .ind     is an index into a Maple library archive         b 
 Files having no . suffix are plain text files.  Most are the Maple src code      
 corresponding to the Maple routines and packages in the share library.  You      
 may read them.  There are also various kinds of miscellaneous documentation      
 files.  See `Additional Documentation' below.        b b 
 Loading Worksheets       
 b 
 If your Maple version supports worksheets, it should be possible to load and         
 execute any of the worksheets in the share library.  Pull down the File menu.        
 You should see a button labelled `Open'.  Click on it.  A menu should pop up.        
 You need to move to the directory containing the worksheet.  You need to         
 know where the Maple share library is on your machine.  See the section above        
 on `Where is the Share Library?'.  Move first to the share library directory.        
 Now move to the directory containing the worksheet you want.  The worksheets         
 in that directory will be displayed in the menu as files ending with .ms.        
 
Now select the one you want.         b b 
 	Additional Documentation         
 	========================         b 
 The Maple share library contains various kinds of documentation files.       
 Many of the LaTeX files require LaTeX style files.  These files have a .sty      
 suffix.  The most useful ones are        b b 
 A4.sty          A LaTeX style file for European size paper       
 fullpage.sty    A LaTeX style file for American size paper       
 maple.sty       A LaTeX style file for including Maple input/output in a         
                   \begin{maple} ... \end{maple}      b 
 SEE ALSO: ?share[contrib], ?share[index], ?share[address]        
 
help/share/text/combinatorics    
 	help/share/text/combinat         
 	help/share/text/statistics   
 help/share/text/stats        
 	help/share/text/geometry     L 
 	help/share/text/programming  
 help/share/text/program     