{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-courier-bold-r-normal--17-*" "courier" "Courie
r-Bold" 8 17 192 "Courier-Bold" 17}{SCP_R 1 0 49{COM_R 2 0{TEXT 3
 108 "Reliability polynomials for all terminal reliability networ
ks.\012Author: Michael Monagan, monagan@inf.ethz.ch\012"}}{COM_R 
3 0{TEXT 1 705 "The main function in this file is the routine rel
poly(G,p). It computes the reliability polynomial a(p) for G the 
so called\012``all-terminal reliability network''. Such a network
 is modelled by a graph G with multiple edges and with a probabil
ity p of failure on each edge.  The polynomial a(p) gives the pro
bability that the network is spanned in the presence of edge fail
ures, i.e. the probability that each node remains connected to ea
ch other node. We give several examples below.\015\012The algorit
hm used in this routine is a heuristic which works quite well for
 sparse networks, and appears to be much much (100 times) faster 
than the algorithm used in the routine networks[spanpoly] in the 
Maple library.\012"}}{COM_R 4 0{TEXT 1 342 "The call relpoly(G,p)
 computes the reliability polynomial a(p) from the Graph G on N v
ertices.\012The input graph G should be input as a list of N poly
nomials in the vertices X[i], i=1..N, where the c = coeff(G[i],X[
j]) gives the multiplicity of the edges from vertex i to j.\012Th
e input p is the edge probability and N is the number of vertices
.\012"}}{INP_R 5 0 "> "{TEXT 0 99 "relpoly := proc(G:list(polynom
(nonnegint)),p) local n;\012   n := nops(G);\012   reliability(G,
p,n)\012end:\012"}}{INP_R 6 0 "> "{TEXT 0 1177 "reliability := pr
oc(G,p,n) local c,d,k,u,v,w,t,H;\012        # Choose first vertex
 of minimum degree\012        d := n;\012        for k to nops(G)
 while d > 0 do\012            if G[k] <> infinity then\012      
          c := nops(indets(G[k]));\012                if c < d th
en d := c; u := k fi\012            fi;\012        od;\012       
 if d = 0 then if n = 1 then RETURN(1) else RETURN(0) fi fi;\012 
       v := op(1,op(1,indets(G[u]))); c := coeff(G[u],X[v],1);\01
2        if d = 1 then           # Isolated node contraction\012 
               H := subsop( u=infinity, v=G[v]-c*X[u], G );\012  
              RETURN( expand( (1-(1-p)^c) * reliability(H,p,n-1) 
) )\012        fi;\012        # First delete the edge of multipli
city c between vertices u and v\012        # (All edges between u
 and v have failed with probability (1-p)^c)\012        H := subs
op( u=G[u]-c*X[v], v=G[v]-c*X[u], G );\012        t := (1-p)^c * 
reliability(H,p,n);\012        # Now contract vertices u and v (a
t least one edge has not failed)\012        H := subsop( u=infini
ty, v=H[u]+H[v], subs(X[u]=X[v],H) );\012        t := expand( (1-
(1-p)^c) * reliability(H,p,n-1) + t );\012        # Now remember 
this computation\012        reliability(G,p,n) := t;\012\012end:\
012"}}{COM_R 7 0{TEXT 1 182 "This is a utility routine to insert 
the edge u v into the graph G.\012G should be initialized to vect
or (array) of N zeroes.\012The third argument m specifies the mul
tiplicity of the edge\012"}}{INP_R 8 0 "> "{TEXT 0 148 "insert :=
 proc(G,u,v,m)\012   if nargs = 3 then insert(G,u,v,1) else\012  
      G[u] := G[u]+m*X[v];\012        G[v] := G[v]+m*X[u];\012   
     NULL\012   fi\012end:\012"}}{SEP_R 9 0}{COM_R 10 0{TEXT 1 61
 "Example 1: computing the reliability polynomials for cliques\01
2"}}{COM_R 11 0{TEXT 1 116 "relpoly_clique(N,p); computes the rel
iability polynomial for\012a clique on N vertices with edge failu
re probability p\012"}}{INP_R 12 0 "> "{TEXT 0 173 "relpoly_cliqu
e := proc(N,p) local G,i,j;\012   G := array([0$N]);\012   for i 
to N-1 do for j from i+1 to N do insert(G,i,j) od od;\012   G := 
convert(G,list):\012   relpoly(G,p);\012end:\012"}}{INP_R 13 0 ">
 "{TEXT 0 94 "for i from 1 to 6 do\012   printf(`  Clique on %d v
ertices is\\n`,i);\012   relpoly_clique(i,p);\012od;\012"}}{OUT_R
 14 0 13{TEXT 2 26 "  Clique on 1 vertices is\012"}}{OUT_R 15 0 
13{DAG j2x0001}}{OUT_R 16 0 13{TEXT 2 26 "  Clique on 2 vertices 
is\012"}}{OUT_R 17 0 13{DAG n3\`p`}}{OUT_R 18 0 13{TEXT 2 26 "  C
lique on 3 vertices is\012"}}{OUT_R 19 0 13{DAG +5*3n3\`p`j2x0002
j2x0003*3p2p6i2x0002}}{OUT_R 20 0 13{TEXT 2 26 "  Clique on 4 ver
tices is\012"}}{OUT_R 21 0 13{DAG +9*3n3\`p`j2x0003j2x0016*3p2j2x
0004i2x0033*3p2j2x0005j2x0024*3p2j2x0006i2x0006}}{OUT_R 22 0 13
{TEXT 2 26 "  Clique on 5 vertices is\012"}}{OUT_R 23 0 13{DAG +F
*3n3\`p`j2x0004j2x0125*3p2j2x0005i2x0528*3p2j2x0006j2x0970*3p2j2x
0007i2x0980*3p2j2x0008j2x0570*3p2j2x0009i2x0180*3p2j2x0010j2x0024
}}{OUT_R 24 0 13{TEXT 2 26 "  Clique on 6 vertices is\012"}}
{OUT_R 25 0 13{DAG +17*3n3\`p`j2x0005j2x1296*3p2j2x0006i2x9300*3p
2j2x0007j3x00031080*3p2j2x0008i3x00063195*3p2j2x0009j3x00086110*3
p2j2x0010i3x00081840*3p2j2x0011j3x00054780*3p2j2x0012i3x00025440*
3p2j2x0013j2x7830*3p2j2x0014i2x1440*3p2j2x0015j2x0120}}{SEP_R 26 
0}{COM_R 27 0{TEXT 1 52 "Example 2: reliability polynomials for s
imple loops\012"}}{COM_R 28 0{TEXT 1 120 "relpoly_loop(N,p); comp
utes the reliability polynomial for\012a simply cycle on N vertic
es with edge failure probability p\012"}}{INP_R 29 0 "> "{TEXT 0 
163 "relpoly_loop := proc(N,p) local G,i;\012   G := array([0$N])
;\012   for i to N-1 do insert(G,i,i+1) od;\012   insert(G,N,1);\
012   G := convert(G,list):\012   relpoly(G,p);\012end:\012"}}
{INP_R 30 0 "> "{TEXT 0 94 "for i from 1 to 6 do\012    printf( `
  Loop of %d vertices\\n`, i );\012    relpoly_clique(i,p);\012od
;\012"}}{OUT_R 31 0 30{TEXT 2 21 "  Loop of 1 vertices\012"}}
{OUT_R 32 0 30{DAG j2x0001}}{OUT_R 33 0 30{TEXT 2 21 "  Loop of 2
 vertices\012"}}{OUT_R 34 0 30{DAG n3\`p`}}{OUT_R 35 0 30{TEXT 2 
21 "  Loop of 3 vertices\012"}}{OUT_R 36 0 30{DAG +5*3n3\`p`j2x00
02j2x0003*3p2p6i2x0002}}{OUT_R 37 0 30{TEXT 2 21 "  Loop of 4 ver
tices\012"}}{OUT_R 38 0 30{DAG +9*3n3\`p`j2x0003j2x0016*3p2j2x000
4i2x0033*3p2j2x0005j2x0024*3p2j2x0006i2x0006}}{OUT_R 39 0 30{TEXT
 2 21 "  Loop of 5 vertices\012"}}{OUT_R 40 0 30{DAG +F*3n3\`p`j2
x0004j2x0125*3p2j2x0005i2x0528*3p2j2x0006j2x0970*3p2j2x0007i2x098
0*3p2j2x0008j2x0570*3p2j2x0009i2x0180*3p2j2x0010j2x0024}}{OUT_R 
41 0 30{TEXT 2 21 "  Loop of 6 vertices\012"}}{OUT_R 42 0 30{DAG 
+17*3n3\`p`j2x0005j2x1296*3p2j2x0006i2x9300*3p2j2x0007j3x00031080
*3p2j2x0008i3x00063195*3p2j2x0009j3x00086110*3p2j2x0010i3x0008184
0*3p2j2x0011j3x00054780*3p2j2x0012i3x00025440*3p2j2x0013j2x7830*3
p2j2x0014i2x1440*3p2j2x0015j2x0120}}{INP_R 43 0 "> "{TEXT 0 0 ""}
}{SEP_R 44 0}{COM_R 45 0{TEXT 1 62 "Example 3: reliability polyno
mial for the Red Arpanet network\012"}}{INP_R 46 0 "> "{TEXT 0 
734 "relpoly_RedArpanet := proc(p) local N,G;\012   N := 20;\012 
  G := array([0$N]):\012   insert(G,1,2):\012   insert(G,1,3):\01
2   insert(G,2,3):\012   insert(G,2,4):\012   insert(G,3,5):\012 
  insert(G,4,5):\012   insert(G,4,6):\012   insert(G,6,7):\012   
insert(G,5,7):\012   insert(G,1,8):\012   insert(G,8,9):\012   in
sert(G,9,10):\012   insert(G,9,11):\012   insert(G,10,11):\012   
insert(G,7,10):\012   insert(G,6,11):\012   insert(G,8,12):\012  
 insert(G,10,15):\012   insert(G,11,20):\012   insert(G,12,13):\0
12   insert(G,13,14):\012   insert(G,14,15):\012   insert(G,13,15
):\012   insert(G,14,18):\012   insert(G,12,16):\012   insert(G,1
5,17):\012   insert(G,16,17):\012   insert(G,16,18):\012   insert
(G,17,19):\012   insert(G,18,19):\012   insert(G,18,20):\012   in
sert(G,19,20):\012   G := convert(G,list);\012   relpoly(G,p)\012
end:\012"}}{INP_R 47 0 "> "{TEXT 0 22 "relpoly_RedArpanet(p);"}}
{OUT_R 48 0 47{DAG +1D*3n3\`p`j2x0019j3x10122705*3p2j2x0020i4x000
106094745*3p2j2x0021j4x000515605909*3p2j2x0022i4x001537987681*3p2
j2x0024i4x004635703270*3p2j2x0025j4x005086777925*3p2j2x0023j4x003
140740957*3p2j2x0030i3x91591772*3p2j2x0029j4x000401796342*3p2j2x0
031j3x12793356*3p2j2x0032i3x00826848*3p2j2x0026i4x004200709423*3p
2j2x0027j4x002610217206*3p2j2x0028i4x001205140660}}{SEP_R 49 0}
{INP_R 50 0 "> "{TEXT 0 0 ""}}}{END}
