{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-140-*" "helvetica" "Helvetica-Bold" 8 14 0 
"Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--*-140-
*" "times" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "-adobe
-courier-medium-r-normal--*-140-*" "courier" "Courier" 4 14 192 "
Courier" 12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal-
-*-180-*-*-*-*-*-*" "new century schoolbook" "Times-Bold" 8 18 64
 "Times-Bold" 18}{SCP_R 1 0 73{COM_R 2 0{TEXT 3 48 "Harmonic Anal
ysis of Phase Controlled Waveforms\012"}}{COM_R 3 0{TEXT 1 20 "Au
thor: A. D. Rough\012"}}{COM_R 4 0{TEXT 1 99 "A.D. Rough is at Wa
terloo Maple Software,\015Waterloo, Ontario, N2L 5J2\012email: ad
rough@maplesoft.on.ca"}}{COM_R 5 0{TEXT 1 123 " \015Maple Procedu
res for Analysis of Single Phase Thyristor.\012The code is descri
bed in the Maple Technical Newsletter Issue 9."}}{COM_R 6 0{TEXT 
1 186 "\015This session calculates the harmonic content of a sing
le phase, phase controlled rectified sinewave for a firing angle \+
y (degrees) and a frequency f (hertz) and plots the results.     \+
 "}}{COM_R 7 0{TEXT 1 219 "Integer harmonics are defined by x.  T
he resultant magnitude of each harmonic is rx. After the harmonic
 magnitudes a0,ax,bx,rx are determined, the signal is reconstruct
ed and plotted against the original for comparison."}}{COM_R 8 0
{TEXT 1 239 "\015The commands with(plots,matrixplot):   matrixplo
t(c);\012plot the harmonic magnitudes rx against its rows (firing
 angle) and columns (harmonic number).  They are also plotted wit
h `surfdata' which can also be obtained from the share library."}
}{COM_R 9 0{TEXT 1 69 "(see issue no. 9 of the Maple Technical Ne
wsletter for more details)."}}{INP_R 10 0 "> "{TEXT 0 16 "top:= y
/(360*f):"}}{INP_R 11 0 "> "{TEXT 0 27 "bottom:= (y/180 - 1)/(2*f
):"}}{COM_R 12 0{TEXT 1 55 "Calculate harmonic magnitudes ``a0'',
 ``ax'' and ``bx''"}}{INP_R 13 0 "> "{TEXT 0 82 "a0:=2*f*int(-sin
(2*Pi*f*t),t= bottom..0) + 2*f*int(sin(2*Pi*f*t), t=top..1/(2*f))
;"}}{OUT_R 14 0 13{DAG :3n3\`a0`+5*5n3\`f`j2x0001+5*5n3\`Pi`i2x00
01p5pD/3p7j2x0002*7(3n3\`cos`,2+3*5pBp7+5n3\`y`p7i2x0180p7p7/3p7j
2x0180p7pBpDp5pD/3pDp13p7p13*5p5p7+5pAp11*7(3p17,2+3*5pBp7p1Fp7p2
6p7pBpDp5pDp11p7p13}}{INP_R 15 0 "> "{TEXT 0 45 "a0:= subs(\{sin(
x*Pi)=0,cos(x*Pi)=(-1)^x\},a0):"}}{INP_R 16 0 "> "{TEXT 0 16 "a0:
= expand(a0);"}}{OUT_R 17 0 16{DAG :3n3\`a0`+5*3n3\`Pi`i2x0001j2x
0002*5(3n3\`cos`,2+3*5p5j2x0001n3\`y`p13/3p13j2x0180p13p5p7p9}}
{INP_R 18 0 "> "{TEXT 0 114 "ax:=2*f*int(-sin(2*Pi*f*t)*cos(2*x*P
i*f*t),t= bottom..0) + 2*f*int(sin(2*Pi*f*t)*cos(2*x*Pi*f*t), t=t
op..1/(2*f));"}}{OUT_R 19 0 18{DAG :3n3\`ax`+5*5n3\`f`j2x0001+5*9
n3\`Pi`i2x0001p5pD+5p7p7n3\`x`p7pD+5pDp7p14p7pD/3pDj2x0002*B+9(3n
3\`cos`,2+3*7pBp7+5n3\`y`p7i2x0180p7p7p11p7/3p7j2x0180pD*5p24p7p1
4p7p7(3p25,2+3*7pBp7p2Cp7p18p7p36pD*5p41p7p14p7pDp7pBpDp5pDp11pDp
18pD/3pDj2x0004p7p20*5p5p7+5*B+9(3p25,2*5pBp7p11p7pD*5p69p7p14p7p
7(3p25,2*5pBp7p18p7pD*5p78p7p14p7pDp7pBpDp5pDp11pDp18pDp5D*B+9(3p
25,2+3*7pBp7p2Dp7p11p7p36pD*5p93p7p14p7p7(3p25,2+3*7pBp7p2Dp7p18p
7p36pD*5pA6p7p14p7pDp7pBpDp5pDp11pDp18pD/3p7p5Fp7p20}}{INP_R 20 0
 "> "{TEXT 0 16 "ax:= expand(ax):"}}{INP_R 21 0 "> "{TEXT 0 45 "a
x:= subs(\{sin(x*Pi)=0,cos(x*Pi)=(-1)^x\},ax):"}}{INP_R 22 0 "> "
{TEXT 0 16 "ax:= normal(ax):"}}{INP_R 23 0 "> "{TEXT 0 33 "ax:= f
actor(numer(ax))/denom(ax);"}}{OUT_R 24 0 23{DAG :3n3\`ax`+3*B+5j
2x0001p6^3i2x0001n3\`x`p6p6+7*5(3n3\`cos`,2+3*5n3\`Pi`p6n3\`y`p6/
3p6j2x0180p6(3p13,2+3*7p18p6p1Bp6pCp6p1Ep6p6*7pCp6(3n3\`sin`p15p6
(3p35p25p6p6p6p6p6p18pA+5p6p6pCp6pA+5pAp6pCp6pApA}}{INP_R 25 0 ">
 "{TEXT 0 115 "bx:= 2*f*int(-sin(2*Pi*f*t)*sin(2*x*Pi*f*t),t= bot
tom..0) + 2*f*int(sin(2*Pi*f*t)*sin(2*x*Pi*f*t), t=top..1/(2*f));
"}}{OUT_R 26 0 25{DAG :3n3\`bx`+5*9+9(3n3\`sin`,2+3*7n3\`Pi`j2x00
01+5n3\`y`pEi2x0180pEpE+5i2x0001pEn3\`x`pEpE/3pEj2x0180pE*5p6pEp1
CpEpE(3p7,2+3*7pCpEp10pE+5pEpEp1CpEpEp20pE*5p2BpEp1CpEp19pEpCp19p
18p19p34p19/3pEj2x0002*5n3\`f`pE+5*B+9(3p7,2*5pCpEp18pEpE*5p54pEp
1CpEpE(3p7,2*5pCpEp34pEpE*5p63pEp1CpEp19pEpCp19p4Ep19p18p19p34p19
/3pEj2x0004*B+9(3p7,2+3*7pCpEp11pEp18pEp20pE*5p81pEp1CpEpE(3p7,2+
3*7pCpEp11pEp34pEp20pE*5p94pEp1CpEp19pEpCp19p4Ep19p18p19p34p19/3p
19p7DpEp4B}}{INP_R 27 0 "> "{TEXT 0 16 "bx:= expand(bx):"}}{INP_R
 28 0 "> "{TEXT 0 45 "bx:= subs(\{sin(x*Pi)=0,cos(x*Pi)=(-1)^x\},
bx):"}}{INP_R 29 0 "> "{TEXT 0 16 "bx:= normal(bx):"}}{INP_R 30 0
 "> "{TEXT 0 33 "bx:= factor(numer(bx))/denom(bx);"}}{OUT_R 31 0 
30{DAG :3n3\`bx`*B+5j2x0001p5^3i2x0001n3\`x`p5p5+5*5(3n3\`cos`,2+
3*5n3\`Pi`p5n3\`y`p5/3p5j2x0180p5(3n3\`sin`,2+3*7p17p5p1Ap5pBp5p1
Dp5p9*7pBp5(3p23p14p5(3p12p25p5p5p5p17p9+5p5p5pBp5p9+5p9p5pBp5p9}
}{COM_R 32 0{TEXT 1 170 " Note that the first harmonic x = 1 give
s 0 in the denominators of\012 ``ax'' and ``bx''.  Consequently, \+
these components must be calculated  using the Maple limit functi
on:"}}{INP_R 33 0 "> "{TEXT 0 29 "a1:=evalc(Re(limit(ax,x=1)));"}
}{OUT_R 34 0 33{DAG :3n3\`a1`j2x0000}}{INP_R 35 0 "> "{TEXT 0 18 
"b1:=limit(bx,x=1);"}}{OUT_R 36 0 35{DAG :3n3\`b1`j2x0000}}{COM_R
 37 0{TEXT 1 28 "Calculate resultant harmonic"}}{INP_R 38 0 "> "
{TEXT 0 26 "rx:=sqrt((ax)^2 + (bx)^2);"}}{OUT_R 39 0 38{DAG :3n3\
`rx`*3+5*B+5j2x0001p7^3i2x0001n3\`x`p7j2x0002+7*5(3n3\`cos`,2+3*5
n3\`Pi`p7n3\`y`p7/3p7j2x0180p7(3p15,2+3*7p1Ap7p1Dp7pDp7p20p7p7*7p
Dp7(3n3\`sin`p17p7(3p37p27p7p7p7p7p10p1Ai2x0002+5p7p7pDp7p44+5pBp
7pDp7p44p7*Bp6p10+5*5p14p7p3Bp7pB*7pDp7p36p7p25p7p7p10p1Ap44p46p4
4p4Cp44p7/3p7p10}}{COM_R 40 0{TEXT 1 31 " Set frequency and firin
g angle"}}{INP_R 41 0 "> "{TEXT 0 5 "f:=1:"}}{INP_R 42 0 "> "
{TEXT 0 7 "y:= 70:"}}{COM_R 43 0{TEXT 1 19 " Reconstruct signal"}
}{INP_R 44 0 "> "{TEXT 0 16 "signal:= proc(t)"}}{INP_R 45 0 "> "
{TEXT 0 69 "        a0/2 + sum(ax*cos(2*Pi*f*x*t) + bx*sin(2*Pi*f
*x*t), x=2..10):"}}{INP_R 46 0 "> "{TEXT 0 4 "end:"}}{COM_R 47 0
{TEXT 1 55 " Plot the controlled rectified single phase source wa
ve"}}{INP_R 48 0 "> "{TEXT 0 19 "source:=proc(angle)"}}{INP_R 49 
0 "> "{TEXT 0 33 "m:=signum(t-a):   n:=signum(t-b):"}}{INP_R 50 0
 "> "{TEXT 0 20 "d(t,a,b):=1/2*(m-n):"}}{INP_R 51 0 "> "{TEXT 0 
62 "e1(t):=-sin(2*Pi*t)*(subs(\{a=-1/2 + angle/360,b=0\},d(t,a,b)
)):"}}{INP_R 52 0 "> "{TEXT 0 56 "e2(t):=sin(2*Pi*t)*(subs(\{a = \+
angle/360,b=1\},d(t,a,b))):"}}{INP_R 53 0 "> "{TEXT 0 22 "e3(t):=
e1(t) + e2(t) ;"}}{INP_R 54 0 "> "{TEXT 0 4 "end:"}}{OUT_R 55 0 
54{TEXT 2 84 "Warning, `m` is implicitly declared local\012Warnin
g, `n` is implicitly declared local\012"}}{COM_R 56 0{TEXT 1 35 "
compare source wave and signal wave"}}{INP_R 57 0 "> "{TEXT 0 52 
"plot(\{signal(t),source(70)\},t=-1/2..1/2,style=LINE);"}}{COM_R 
58 0{TEXT 1 17 "Using matrixplot "}}{INP_R 59 0 "> "{TEXT 0 9 "y \+
:= 'y';"}}{OUT_R 60 0 59{DAG :3n3\`y`p1}}{INP_R 61 0 "> "{TEXT 0 
26 "c:= array(1..11,1..19,[]):"}}{INP_R 62 0 "> "{TEXT 0 21 "for \+
j from 0 to 18 do"}}{INP_R 63 0 "> "{TEXT 0 36 "   c[1,j+1]:=eval
f(subs(y=10*j,a0)):"}}{INP_R 64 0 "> "{TEXT 0 15 "   c[2,j+1]:=0:
"}}{INP_R 65 0 "> "{TEXT 0 24 "   for i from 2 to 10 do"}}{INP_R 
66 0 "> "{TEXT 0 49 "        c[i+1,j+1]:=evalf(subs(\{x=i,y=10*j\
},rx)):"}}{INP_R 67 0 "> "{TEXT 0 6 "   od:"}}{INP_R 68 0 "> "
{TEXT 0 3 "od:"}}{INP_R 69 0 "> "{TEXT 0 23 "with(plots,matrixplo
t):"}}{INP_R 70 0 "> "{TEXT 0 14 "matrixplot(c);"}}{INP_R 71 0 ">
 "{TEXT 0 55 "e:=[seq([seq([i,j*10,c[i+1,j+1]],i=0..10)]  ,j=0..1
8)]:"}}{INP_R 72 0 "> "{TEXT 0 21 "with(plots,surfdata):"}}{INP_R
 73 0 "> "{TEXT 0 12 "surfdata(e);"}}{INP_R 74 0 "> "{TEXT 0 0 ""
}}}{END}
