{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--12-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 14}{FONT 2 "Courier" "Co
urier" "Courier" 4 12 192 "Courier" 12}{SCP_R 1 0 83{COM_R 2 0
{TEXT 1 1285 "In this sample session we use Maple to solve a simp
le material balance problem.  It must be noted that there are man
y ways to solve any given problem with Maple.  The methodology fo
llowed here is not what a beginner to Maple would do.  On the oth
er hand, the procedure followed here is simple and starightforwar
d and requires very little alteration to be useful in a host of s
imilar problems.\015\015The Problem Statement\015\015We will illu
strate the use of Maple with a simple example from \"Introduction
 to Material and Energy Balances\" by G.V. Reklaitis.  On page 62
 of that book we are asked to consider the separation of a three 
component mixture of benzene, toluene, and xylene into three stre
ams, each rich in one of the species.\015We are told that the fee
d rate is 1000 mol/h of a mixture containing 20% benzene, 30% tol
uene and the rest is xylene.  The feed is to be separated in two 
distillation columns and the bottoms product  from the first cont
ains 2.5% benzene, 35% toluene  and the rest is xylene.  There is
 assumed to be no xylene in the overhead from the first column.  
The feed to the second column is the bottoms product from the fir
st column; the overhead product contains 8% benzene and 72% tolue
ne.  The bottoms product from the second column contains essentia
lly no benzene.\015"}}{INP_R 3 0 "> "{TEXT 0 8 "restart;"}}{COM_R
 4 0{TEXT 1 161 "\015We begin by creating a list of component ide
ntities.  We could use numbers, or chemical formulae; here we use
 a single capital letter to denote each component.\015"}}{INP_R 5
 0 "> "{TEXT 0 20 "components:=[B,T,X];"}}{OUT_R 6 0 5{DAG :3n5\`
components`[2,4n3\`B`n3\`T`n3\`X`}}{COM_R 7 0{TEXT 1 126 "\015Nex
t, we create a set of units.  This problem has two units, both di
stillation columns which shall be identified as follows:\015"}}
{INP_R 8 0 "> "{TEXT 0 19 "Units:=[Col1,Col2];"}}{OUT_R 9 0 8{DAG
 :3n4\`Units`[2,3n4\`Col1`n4\`Col2`}}{COM_R 10 0{TEXT 1 156 "The 
streams will also have to be identified.  Again, we could use any
 indexing method that is convenient.  Here we choose to assign nu
mbers to each stream.\015"}}{INP_R 11 0 "> "{TEXT 0 25 "Streams:=
[seq(i,i=1..5)];"}}{OUT_R 12 0 11{DAG :3n4\`Streams`[2,6j2x0001j2
x0002j2x0003j2x0004j2x0005}}{COM_R 13 0{TEXT 1 245 "\015The next 
step is to set up the material balances.  To help us do this in a
 systematic way we create lists of the input streams to and outpu
t streams leaving each process unit.  The streams entering and le
aving the first distillation column are\015"}}{INP_R 14 0 "> "
{TEXT 0 48 "Inputs[Units[1]]:=[1]; Outputs[Units[1]]:=[2,3];"}}
{OUT_R 15 0 14{DAG :3b3n4\`Inputs`,2n4\`Col1`[2,2j2x0001}}{OUT_R 
16 0 14{DAG :3b3n4\`Outputs`,2n4\`Col1`[2,3j2x0002j2x0003}}{COM_R
 17 0{TEXT 1 60 "\015and the streams entering and leaving the sec
ond column are\015"}}{INP_R 18 0 "> "{TEXT 0 48 "Inputs[Units[2]]
:=[3]; Outputs[Units[2]]:=[4,5];"}}{OUT_R 19 0 18{DAG :3b3n4\`Inp
uts`,2n4\`Col2`[2,2j2x0003}}{OUT_R 20 0 18{DAG :3b3n4\`Outputs`,2
n4\`Col2`[2,3j2x0004j2x0005}}{COM_R 21 0{TEXT 1 121 "The basic id
ea of all material balances is that\015\015   Input = Output.\015
\015This must be true for each component in the system. "}}{INP_R
 22 0 "> "{TEXT 0 185 "for u in Units do \012   for i in componen
ts do\012        CMB[i,u]:=convert([seq(F[j]*x[i,j],j=Inputs[u])]
,`+`)=convert([seq(F[j]*x[i,j],j=Outputs[u])],`+`);\012        pr
int(CMB[i,u]);\012od; od;"}}{OUT_R 23 0 22{DAG =3*5b3n3\`F`,2j2x0
001p6b3n3\`x`,3n3\`B`p6p6+5*5b3p3,2j2x0002p6b3pA,3pDp16p6p6*5b3p3
,2j2x0003p6b3pA,3pDp24p6p6}}{OUT_R 24 0 22{DAG =3*5b3n3\`F`,2j2x0
001p6b3n3\`x`,3n3\`T`p6p6+5*5b3p3,2j2x0002p6b3pA,3pDp16p6p6*5b3p3
,2j2x0003p6b3pA,3pDp24p6p6}}{OUT_R 25 0 22{DAG =3*5b3n3\`F`,2j2x0
001p6b3n3\`x`,3n3\`X`p6p6+5*5b3p3,2j2x0002p6b3pA,3pDp16p6p6*5b3p3
,2j2x0003p6b3pA,3pDp24p6p6}}{OUT_R 26 0 22{DAG =3*5b3n3\`F`,2j2x0
003j2x0001b3n3\`x`,3n3\`B`p6p8+5*5b3p3,2j2x0004p8b3pB,3pEp17p8p8*
5b3p3,2j2x0005p8b3pB,3pEp25p8p8}}{OUT_R 27 0 22{DAG =3*5b3n3\`F`,
2j2x0003j2x0001b3n3\`x`,3n3\`T`p6p8+5*5b3p3,2j2x0004p8b3pB,3pEp17
p8p8*5b3p3,2j2x0005p8b3pB,3pEp25p8p8}}{OUT_R 28 0 22{DAG =3*5b3n3
\`F`,2j2x0003j2x0001b3n3\`x`,3n3\`X`p6p8+5*5b3p3,2j2x0004p8b3pB,3
pEp17p8p8*5b3p3,2j2x0005p8b3pB,3pEp25p8p8}}{COM_R 29 0{TEXT 1 733
 "\015In the above Maple construction we have created the compone
nt material balances for each component\015(the inner loop) and f
or each process unit (the outer loop).\015\015The total molar flo
ws are given the symbol F and x refers to the mole fraction of  s
ome component.  The first index of the component mole fraction id
entifies the component in question, the second associates that qu
antity with a particular process stream.  This double loop will w
ork with all simple material balances\015regardless of complexity
 provided we have identified the components, the units and the in
putand output streams associated with each unit.\015\015The mole 
fractions in each stream must sum to 1.  The mole fraction summat
ion equations can be created as follows:\015"}}{INP_R 30 0 "> "
{TEXT 0 119 "SumEqn:='SumEqn': for j in Streams do\012   SumEqn[j
]:=convert([seq(x[i,j],i=components)],`+`)=1;\012   print(SumEqn[
j]);\012od:"}}{OUT_R 31 0 30{DAG =3+7b3n3\`x`,3n3\`B`j2x0001p8b3p
3,3n3\`T`p8p8b3p3,3n3\`X`p8p8p8}}{OUT_R 32 0 30{DAG =3+7b3n3\`x`,
3n3\`B`j2x0002j2x0001b3p3,3n3\`T`p8pAb3p3,3n3\`X`p8pApA}}{OUT_R 
33 0 30{DAG =3+7b3n3\`x`,3n3\`B`j2x0003j2x0001b3p3,3n3\`T`p8pAb3p
3,3n3\`X`p8pApA}}{OUT_R 34 0 30{DAG =3+7b3n3\`x`,3n3\`B`j2x0004j2
x0001b3p3,3n3\`T`p8pAb3p3,3n3\`X`p8pApA}}{OUT_R 35 0 30{DAG =3+7b
3n3\`x`,3n3\`B`j2x0005j2x0001b3p3,3n3\`T`p8pAb3p3,3n3\`X`p8pApA}}
{COM_R 36 0{TEXT 1 309 "\015The component material balances and t
he mole fraction summation equations comprise the complete set of
 independent equations for this kind of problem.  Any other balan
ce equation can be created from simple combinations of these equa
tions.  The total material balances for each unit are obtained as
 follows:\015\015"}}{INP_R 37 0 "> "{TEXT 0 295 "for u in Units d
o   \012   t1:=convert([seq(CMB[i,u],i=components)],`+`);   # sum
 component balances for a unit\012   t1:=collect(t1,[seq(F[j],j=S
treams)]);                   # collect terms in each flow rate\01
2   TMB[u]:=subs(\{seq(SumEqn[j],j=Streams)\},\");     # substitu
te the summation equations \012od:"}}{INP_R 38 0 "> "{TEXT 0 36 "
for u in Units do print(TMB[u]); od;"}}{OUT_R 39 0 38{DAG =3b3n3\
`F`,2j2x0001+5b3p2,2j2x0002p5b3p2,2j2x0003p5}}{OUT_R 40 0 38{DAG 
=3b3n3\`F`,2j2x0003+5b3p2,2j2x0004j2x0001b3p2,2j2x0005pD}}{COM_R 
41 0{TEXT 1 67 "\015The number of variables appearing in the inde
pendent equations is\015"}}{INP_R 42 0 "> "{TEXT 0 42 "Nvars:=(no
ps(components)+1)*nops(Streams);"}}{OUT_R 43 0 42{DAG :3n4\`Nvars
`j2x0020}}{COM_R 44 0{TEXT 1 174 "where we have counted the mole 
fraction of each component and the total flow rate and multiilpie
d by the number of streams.\015\015The number of equations is com
puted differently:\015"}}{INP_R 45 0 "> "{TEXT 0 52 "Neqns:=nops(
[indices(CMB)])+nops([indices(SumEqn)]);"}}{OUT_R 46 0 45{DAG :3n
4\`Neqns`j2x0011}}{COM_R 47 0{TEXT 1 0 ""}}{COM_R 48 0{TEXT 1 269
 "where we have counted the number of component mass balances by 
counting the number of different indices there are in the table o
f component mass balances; similarly the summation equations.\015
\015The number of degrees of freedom is the difference between th
ese two numbers\015 "}}{INP_R 49 0 "> "{TEXT 0 21 "DegFree:=Nvars
-Neqns;"}}{OUT_R 50 0 49{DAG :3n4\`DegFree`j2x0009}}{COM_R 51 0
{TEXT 1 183 "This means that we must specify 9 of the variables b
efore we have a consistent set of equations that can be solved.\0
15\015Usually we will know the flow and composition of the feed s
tream:\015"}}{INP_R 52 0 "> "{TEXT 0 20 "Specs[1]:=F[1]=1000;"}}
{OUT_R 53 0 52{DAG :3b3n4\`Specs`,2j2x0001=3b3n3\`F`p5j2x1000}}
{INP_R 54 0 "> "{TEXT 0 21 "Specs[2]:=x[B,1]=0.2;"}}{OUT_R 55 0 
54{DAG :3b3n4\`Specs`,2j2x0002=3b3n3\`x`,3n3\`B`j2x0001e3p6i2x000
1}}{INP_R 56 0 "> "{TEXT 0 21 "Specs[3]:=x[T,1]=0.3;"}}{OUT_R 57 
0 56{DAG :3b3n4\`Specs`,2j2x0003=3b3n3\`x`,3n3\`T`j2x0001e3p6i2x0
001}}{COM_R 58 0{TEXT 1 202 "\015We must look to the problem stat
ement to find out what other specifications we must make.\015In t
his example we must specify the mole fraction of benzene and tolu
ene in the bottoms product from column 1.\015"}}{INP_R 59 0 "> "
{TEXT 0 46 "Specs[4]:=x[B,3]=0.025; Specs[5]:=x[T,3]=0.35;"}}
{OUT_R 60 0 59{DAG :3b3n4\`Specs`,2j2x0004=3b3n3\`x`,3n3\`B`j2x00
03e3j2x0025i2x0003}}{OUT_R 61 0 59{DAG :3b3n4\`Specs`,2j2x0005=3b
3n3\`x`,3n3\`T`j2x0003e3j2x0035i2x0002}}{COM_R 62 0{TEXT 1 79 "\0
15We can also see that we want no xylene in the overhead product 
from column 1.\015"}}{INP_R 63 0 "> "{TEXT 0 19 "Specs[6]:=x[X,2]
=0;"}}{OUT_R 64 0 63{DAG :3b3n4\`Specs`,2j2x0006=3b3n3\`x`,3n3\`X
`j2x0002j2x0000}}{COM_R 65 0{TEXT 1 54 "The overhead from column 
two is specified as follows:\015"}}{INP_R 66 0 "> "{TEXT 0 46 "Sp
ecs[7]:=x[B,4]=0.08; Specs[8]:=x[T,4]=0.72; "}}{OUT_R 67 0 66{DAG
 :3b3n4\`Specs`,2j2x0007=3b3n3\`x`,3n3\`B`j2x0004e3j2x0008i2x0002
}}{OUT_R 68 0 66{DAG :3b3n4\`Specs`,2j2x0008=3b3n3\`x`,3n3\`T`j2x
0004e3j2x0072i2x0002}}{COM_R 69 0{TEXT 1 91 "and we want to ensur
e that the amount of benzene in the bottom product is vanishingly
 low.\015"}}{INP_R 70 0 "> "{TEXT 0 19 "Specs[9]:=x[B,5]=0;"}}
{OUT_R 71 0 70{DAG :3b3n4\`Specs`,2j2x0009=3b3n3\`x`,3n3\`B`j2x00
05j2x0000}}{COM_R 72 0{TEXT 1 117 "\015We now have 9 specificatio
ns and we should be ready to ask Maple to solve it for us.  We cr
eate a set of equations:\015"}}{INP_R 73 0 "> "{TEXT 0 106 "Eqns:
=\{seq(seq(CMB[i,u],i=components),u=Units),seq(SumEqn[j],j=Stream
s),\012           seq(Specs[l],l=1..9)\};"}}{OUT_R 74 0 73{DAG :3
n4\`Eqns`%2,15=3*5b3n3\`F`,2j2x0001pCb3n3\`x`,3n3\`B`pCpC+5*5b3p9
,2j2x0002pCb3p10,3p13p1CpCpC*5b3p9,2j2x0003pCb3p10,3p13p2ApCpC=3*
5p8pCb3p10,3n3\`T`pCpC+5*5p19pCb3p10,3p3Bp1CpCpC*5p27pCb3p10,3p3B
p2ApCpC=3*5p8pCb3p10,3n3\`X`pCpC+5*5p19pCb3p10,3p5Bp1CpCpC*5p27pC
b3p10,3p5Bp2ApCpC=3p26+5*5b3p9,2j2x0004pCb3p10,3p13p7BpCpC*5b3p9,
2j2x0005pCb3p10,3p13p89pCpC=3p4A+5*5p78pCb3p10,3p3Bp7BpCpC*5p86pC
b3p10,3p3Bp89pCpC=3p6A+5*5p78pCb3p10,3p5Bp7BpCpC*5p86pCb3p10,3p5B
p89pCpC=3+7pFpCp38pCp58pCpC=3+7p1FpCp43pCp63pCpC=3+7p2DpCp4DpCp6D
pCpC=3+7p7EpCp99pCpB0pCpC=3+7p8CpCpA3pCpBApCpC=3pFe3p1Ci2x0001=3p
38e3p2ApF2=3p2De3j2x0025i2x0003=3p4De3j2x0035i2x0002=3p63j2x0000=
3p7Ee3j2x0008p105=3p99e3j2x0072p105=3p8Cp109=3p8j2x1000}}{COM_R 
75 0{TEXT 1 75 "\015and a set of variables that we wish to comput
e by solving these equations\015"}}{INP_R 76 0 "> "{TEXT 0 68 "Va
rs:=\{seq(seq(x[i,j],i=components),j=Streams),seq(F[j],j=Streams)
\};"}}{OUT_R 77 0 76{DAG :3n4\`Vars`%2,15b3n3\`F`,2j2x0001b3n3\`x
`,3n3\`B`pAb3p7,2j2x0002b3pD,3p10p16b3p7,2j2x0003b3pD,3p10p20b3pD
,3n3\`T`pAb3pD,3p2Ap16b3pD,3p2Ap20b3pD,3n3\`X`pAb3pD,3p3Ap16b3pD,
3p3Ap20b3p7,2j2x0004b3pD,3p10p4Ab3p7,2j2x0005b3pD,3p10p54b3pD,3p2
Ap4Ab3pD,3p2Ap54b3pD,3p3Ap4Ab3pD,3p3Ap54}}{COM_R 78 0{TEXT 1 59 "
\015and we ask Maple to solve the equations for the unknowns.\015
"}}{INP_R 79 0 "> "{TEXT 0 25 "result:=solve(Eqns,Vars);"}}{OUT_R
 80 0 79{DAG :3n4\`result`%2,15=3b3n3\`F`,2j2x0005e3j2x0550j2x000
0=3b3n3\`x`,3n3\`X`pBe3j4x008181818181i2x0010=3b3p8,2j2x0002e3j2x
0200p10=3b3p14,3n3\`T`p25e3j4x001000000000p1F=3b3p14,3p2FpBe3j4x0
01818181819p1F=3b3p14,3n3\`B`p25e3j4x009000000000p1F=3b3p8,2j2x00
04e3j2x0250p10=3b3p8,2j2x0003e3j2x0800p10=3b3p8,2j2x0001e3j2x1000
p10=3b3p14,3p48p69e3j4x002000000000p1F=3b3p14,3p17p25p10=3b3p14,3
p48pBp10=3b3p14,3p2Fp5Fe3j4x003500000000p1F=3b3p14,3p48p5Fe3j4x00
2500000000i2x0011=3b3p14,3p17p69e3j4x005000000000p1F=3b3p14,3p2Fp
69e3j4x003000000000p1F=3b3p14,3p48p55e3j4x008000000000pA0=3b3p14,
3p17p5Fe3j4x006250000000p1F=3b3p14,3p17p55p75=3b3p14,3p2Fp55e3j4x
007200000000p1F}}{COM_R 81 0{TEXT 1 283 "\015Note that the result
 is a set of equations.  We can use the Maple assign command to a
ttach the results to the appropriate variables but we will not do
 that here.  We can easily check if this result really is a solut
ion by substituting the result into the original set  of equation
s."}}{INP_R 82 0 "> "{TEXT 0 18 "subs(result,Eqns);"}}{OUT_R 83 0
 82{DAG %2,F=3e3j4x002000000000i2x0007p3=3e3j4x003000000000p8pC=3
e3j4x005000000000p8p14=3e3p4i2x0008p1C=3e3j4x002800000000p8p22=3e
3j4x001000000000i2x0009j2x0001=3e3p4i2x0010e3j2x0002i2x0001=3e3pD
p36e3j2x0003p3B=3e3j4x002500000000i2x0011e3j2x0025i2x0003=3e3j4x0
03500000000p36e3j2x0035i2x0002=3j2x0000p5F=3e3j4x008000000000p4Be
3j2x0008p5C=3e3j4x007200000000p36e3j2x0072p5C=3e3j2x1000p5Fp7A}}
{COM_R 84 0{TEXT 1 518 "and we see that the result that Maple com
puted does indeed satisfy the equations.\015\015The procedures us
ed here can be applied to a variety of simple material balance pr
oblems.  The advantages of a systematic approach that Maple allow
s you to use are reduced probability of errors, quick and easy de
termination of the number of degrees of freedomso you know how ma
ny variables must be specified and frredom from the chore of comp
uting an answer, allowing an emphasis of setting up the problem c
orrectly in the first place."}}}{END}

