{VERSION 1 1 "MS-Windows" "1.0"}{GLOBALS 1 2}{FONT 0 "" "" "Helve
tica-Bold" 7 10 0 "Helvetica-Bold" 10{COLOR "000000"}}{FONT 1 "Ti
mes New Roman" "Times New Roman" "Times-Roman" 4 12 64 "Times-Rom
an" 12{COLOR "000000"}}{FONT 2 "Courier New" "Courier New" "Couri
er" 4 10 192 "Courier" 10{COLOR "000000"}}{SCP_R 0 0 68{SCP_R 1 0
 10{COM_R 3 0{TEXT 1 57 "Example 1: Recycle and Purge in the Synt
hesis of Methanol"}}{COM_R 6 0{TEXT 1 0 ""}}{COM_R 9 0{TEXT 1 67 
"We begin by quoting the problem statement from Felder and Rousse
au."}}{COM_R 12 0{TEXT 1 0 ""}}{COM_R 15 0{TEXT 1 72 "\"Methanol 
may be produced by the reaction of carbon dioxide and hydrogen"}}
{COM_R 18 0{TEXT 1 0 ""}}{COM_R 21 0{TEXT 1 28 "    CO2 + 3 H2 = 
CH3OH + H2O"}}{COM_R 24 0{TEXT 1 0 ""}}{COM_R 27 0{TEXT 1 644 "Th
e fresh feed to the process contains hydrogen and carbon dioxide 
in stoichiometric proportions, and 0.5 mole% inerts (I).  The rea
ctor effluent passes to a condenser, which removes essentially al
l the methanol and water formed, and none of the reactants or ine
rts.  The latter substances are recycled to the reactor.  To avoi
d buildup of the inerts in the system, a purge stream is withdraw
n from the recycle.  The feed to the reactor contains 2% inerts a
nd the single pass conversion is 60%.  Calculate the molar flow r
ates of the fresh feed, the total feed to the reactor, and the pu
rge stream for a methanol production rate of 1000 mol/h.\""}}
{COM_R 30 0{TEXT 1 0 ""}}}{SCP_R 32 0 1{COM_R 34 0{TEXT 1 35 "The
 flowsheet is shown in Figure 1."}}}{SCP_R 36 0 2{INP_R 38 0 "> "
{TEXT 0 51 "restart; interface(labelling=false): printlevel:=2:"}
}{OUT_R 41 0 38{TEXT 2 1 "\012"}}}{SCP_R 43 0 2{COM_R 45 0{TEXT 1
 206 "We begin by creating a list of component identities.  We co
uld use numbers, or letters; here we use the chemical formulae to
 denote each component.   The number of components is also comput
ed for later use."}}{COM_R 48 0{TEXT 1 0 ""}}}{SCP_R 50 0 3{INP_R
 52 0 "> "{TEXT 0 55 "components:=[CO2,H2,CH3OH,H2O,I]; nc:=nops(
components);"}}{OUT_R 55 8192 52{DAG :3n5\`components`[2,6n3\`CO2
`n3\`H2`n4\`CH3OH`n3\`H2O`n3\`I`}}{OUT_R 58 8192 52{DAG :3n3\`nc`
j2x0005}}}{SCP_R 60 0 3{COM_R 62 0{TEXT 1 0 ""}}{COM_R 65 0{TEXT 
1 39 "Next, we create a set of process units:"}}{COM_R 68 0{TEXT 
1 0 ""}}}{SCP_R 70 0 2{INP_R 72 0 "> "{TEXT 0 42 "Units:=[Mixer,R
eactor,Condenser,Splitter];"}}{OUT_R 75 8192 72{DAG :3n4\`Units`[
2,5n4\`Mixer`n4\`Reactor`n5\`Condenser`n5\`Splitter`}}}{SCP_R 77 
0 2{COM_R 79 0{TEXT 1 155 "The streams will also have to be ident
ified.  Again, we could use any indexing method that is convenien
t.  Here we choose to assign numbers to each stream."}}{COM_R 82 
0{TEXT 1 0 ""}}}{SCP_R 84 0 2{INP_R 86 0 "> "{TEXT 0 25 "Streams:
=[seq(i,i=1..7)];"}}{OUT_R 89 8192 86{DAG :3n4\`Streams`[2,8j2x00
01j2x0002j2x0003j2x0004j2x0005j2x0006j2x0007}}}{SCP_R 91 0 3
{COM_R 93 0{TEXT 1 0 ""}}{COM_R 96 0{TEXT 1 87 "We create lists o
f the input streams to and output streams leaving each process un
it.  "}}{COM_R 99 0{TEXT 1 0 ""}}}{SCP_R 101 0 3{INP_R 103 0 "> "
{TEXT 0 48 "Inputs[Units[1]]:=[1,7]; Outputs[Units[1]]:=[2];"}}
{OUT_R 106 8192 103{DAG :3b3n4\`Inputs`,2n4\`Mixer`[2,3j2x0001j2x
0007}}{OUT_R 109 8192 103{DAG :3b3n4\`Outputs`,2n4\`Mixer`[2,2j2x
0002}}}{SCP_R 111 0 3{INP_R 113 0 "> "{TEXT 0 46 "Inputs[Units[2]
]:=[2]; Outputs[Units[2]]:=[3];"}}{OUT_R 116 8192 113{DAG :3b3n4\
`Inputs`,2n4\`Reactor`[2,2j2x0002}}{OUT_R 119 8192 113{DAG :3b3n4
\`Outputs`,2n4\`Reactor`[2,2j2x0003}}}{SCP_R 121 0 3{INP_R 123 0 
"> "{TEXT 0 48 "Inputs[Units[3]]:=[3]; Outputs[Units[3]]:=[4,5];"
}}{OUT_R 126 8192 123{DAG :3b3n4\`Inputs`,2n5\`Condenser`[2,2j2x0
003}}{OUT_R 129 8192 123{DAG :3b3n4\`Outputs`,2n5\`Condenser`[2,3
j2x0004j2x0005}}}{SCP_R 131 0 3{INP_R 133 0 "> "{TEXT 0 48 "Input
s[Units[4]]:=[5]; Outputs[Units[4]]:=[6,7];"}}{OUT_R 136 8192 133
{DAG :3b3n4\`Inputs`,2n5\`Splitter`[2,2j2x0005}}{OUT_R 139 8192 
133{DAG :3b3n4\`Outputs`,2n5\`Splitter`[2,3j2x0006j2x0007}}}
{SCP_R 141 0 2{COM_R 143 0{TEXT 1 107 "The material balances for 
units other than the reactor may be obtained by the following Map
le construction."}}{COM_R 146 0{TEXT 1 0 ""}}}{SCP_R 148 0 25
{INP_R 150 0 "> "{TEXT 0 39 "for u in [Mixer,Condenser,Splitter] 
do "}}{INP_R 153 0 "> "{TEXT 0 37 "   print(`Material balances fo
r `.u);"}}{INP_R 156 0 "> "{TEXT 0 37 "   for i in components do 
           "}}{INP_R 159 0 "> "{TEXT 0 61 "   CMB[i,u] := convert
([seq(F[j]*x[i,j],j=Inputs[u])],`+`) = "}}{INP_R 162 0 "> "{TEXT 
0 67 "                      convert([seq(F[j]*x[i,j],j=Outputs[u]
)],`+`):"}}{INP_R 165 0 "> "{TEXT 0 19 "   print(CMB[i,u]);"}}
{INP_R 168 0 "> "{TEXT 0 7 "od; od:"}}{OUT_R 171 8192 168{DAG n9\
`Material~`balances~`for~`Mixer`}}{OUT_R 174 8192 168{DAG =3+5*5b
3n3\`F`,2j2x0001p7b3n3\`x`,3n3\`CO2`p7p7p7*5b3p4,2j2x0007p7b3pB,3
pEp17p7p7*5b3p4,2j2x0002p7b3pB,3pEp25p7}}{OUT_R 177 8192 168{DAG 
=3+5*5b3n3\`F`,2j2x0001p7b3n3\`x`,3n3\`H2`p7p7p7*5b3p4,2j2x0007p7
b3pB,3pEp17p7p7*5b3p4,2j2x0002p7b3pB,3pEp25p7}}{OUT_R 180 8192 
168{DAG =3+5*5b3n3\`F`,2j2x0001p7b3n3\`x`,3n4\`CH3OH`p7p7p7*5b3p4
,2j2x0007p7b3pB,3pEp18p7p7*5b3p4,2j2x0002p7b3pB,3pEp26p7}}{OUT_R 
183 8192 168{DAG =3+5*5b3n3\`F`,2j2x0001p7b3n3\`x`,3n3\`H2O`p7p7p
7*5b3p4,2j2x0007p7b3pB,3pEp17p7p7*5b3p4,2j2x0002p7b3pB,3pEp25p7}}
{OUT_R 186 8192 168{DAG =3+5*5b3n3\`F`,2j2x0001p7b3n3\`x`,3n3\`I`
p7p7p7*5b3p4,2j2x0007p7b3pB,3pEp17p7p7*5b3p4,2j2x0002p7b3pB,3pEp2
5p7}}{OUT_R 189 8192 168{DAG nA\`Material~`balances~`for~`Condens
er`}}{OUT_R 192 8192 168{DAG =3*5b3n3\`F`,2j2x0003j2x0001b3n3\`x`
,3n3\`CO2`p6p8+5*5b3p3,2j2x0004p8b3pB,3pEp17p8p8*5b3p3,2j2x0005p8
b3pB,3pEp25p8p8}}{OUT_R 195 8192 168{DAG =3*5b3n3\`F`,2j2x0003j2x
0001b3n3\`x`,3n3\`H2`p6p8+5*5b3p3,2j2x0004p8b3pB,3pEp17p8p8*5b3p3
,2j2x0005p8b3pB,3pEp25p8p8}}{OUT_R 198 8192 168{DAG =3*5b3n3\`F`,
2j2x0003j2x0001b3n3\`x`,3n4\`CH3OH`p6p8+5*5b3p3,2j2x0004p8b3pB,3p
Ep18p8p8*5b3p3,2j2x0005p8b3pB,3pEp26p8p8}}{OUT_R 201 8192 168{DAG
 =3*5b3n3\`F`,2j2x0003j2x0001b3n3\`x`,3n3\`H2O`p6p8+5*5b3p3,2j2x0
004p8b3pB,3pEp17p8p8*5b3p3,2j2x0005p8b3pB,3pEp25p8p8}}{OUT_R 204 
8192 168{DAG =3*5b3n3\`F`,2j2x0003j2x0001b3n3\`x`,3n3\`I`p6p8+5*5
b3p3,2j2x0004p8b3pB,3pEp17p8p8*5b3p3,2j2x0005p8b3pB,3pEp25p8p8}}
{OUT_R 207 8192 168{DAG nA\`Material~`balances~`for~`Splitter`}}
{OUT_R 210 8192 168{DAG =3*5b3n3\`F`,2j2x0005j2x0001b3n3\`x`,3n3\
`CO2`p6p8+5*5b3p3,2j2x0006p8b3pB,3pEp17p8p8*5b3p3,2j2x0007p8b3pB,
3pEp25p8p8}}{OUT_R 213 8192 168{DAG =3*5b3n3\`F`,2j2x0005j2x0001b
3n3\`x`,3n3\`H2`p6p8+5*5b3p3,2j2x0006p8b3pB,3pEp17p8p8*5b3p3,2j2x
0007p8b3pB,3pEp25p8p8}}{OUT_R 216 8192 168{DAG =3*5b3n3\`F`,2j2x0
005j2x0001b3n3\`x`,3n4\`CH3OH`p6p8+5*5b3p3,2j2x0006p8b3pB,3pEp18p
8p8*5b3p3,2j2x0007p8b3pB,3pEp26p8p8}}{OUT_R 219 8192 168{DAG =3*5
b3n3\`F`,2j2x0005j2x0001b3n3\`x`,3n3\`H2O`p6p8+5*5b3p3,2j2x0006p8
b3pB,3pEp17p8p8*5b3p3,2j2x0007p8b3pB,3pEp25p8p8}}{OUT_R 222 8192 
168{DAG =3*5b3n3\`F`,2j2x0005j2x0001b3n3\`x`,3n3\`I`p6p8+5*5b3p3,
2j2x0006p8b3pB,3pEp17p8p8*5b3p3,2j2x0007p8b3pB,3pEp25p8p8}}}
{SCP_R 224 0 6{COM_R 226 0{TEXT 1 195 "In the above Maple constru
ction we have created the component material balances for each co
mponent in the inner loop and for each process unit with the exce
ption of the reactor in the outer loop."}}{COM_R 229 0{TEXT 1 0 "
"}}{COM_R 232 0{TEXT 1 254 "The total molar flows are given the s
ymbol F and x refers to the mole fraction of  some component.  Th
e first index of the component mole fraction identifies the compo
nent in question, the second associates that quantity with a part
icular process stream."}}{COM_R 235 0{TEXT 1 0 ""}}{COM_R 238 0
{TEXT 1 198 "We now turn our attention to the reactor.  We start 
with some fairly general constructions that are useful in other p
roblems.  First, we identify a set of reactions (in this case the
re is only one):"}}{COM_R 241 0{TEXT 1 0 ""}}}{SCP_R 243 0 2
{INP_R 245 0 "> "{TEXT 0 16 "Reactions:=[R1];"}}{OUT_R 248 8192 
245{DAG :3n5\`Reactions`[2,2n3\`R1`}}}{SCP_R 250 0 2{COM_R 252 0
{TEXT 1 50 "The reaction may be expressed as a Maple equation:"}}
{COM_R 255 0{TEXT 1 0 ""}}}{SCP_R 257 0 2{INP_R 259 0 "> "{TEXT 0
 33 "Reaction[R1]:=CO2+3*H2=CH3OH+H2O;"}}{OUT_R 262 8192 259{DAG 
:3b3n5\`Reaction`,2n3\`R1`=3+5n3\`CO2`j2x0001n3\`H2`j2x0003+5n4\`
CH3OH`pDn3\`H2O`pD}}}{SCP_R 264 0 2{COM_R 266 0{TEXT 1 83 "The st
oichiometric cofficients can be deduced from the set of reactions
 as follows:"}}{COM_R 269 0{TEXT 1 0 ""}}}{SCP_R 271 0 9{INP_R 
273 0 "> "{TEXT 0 22 "for r in Reactions do "}}{INP_R 276 0 "> "
{TEXT 0 26 "   for i in components do "}}{INP_R 279 0 "> "{TEXT 0
 58 "     nu[i,r]:=coeff(lhs(Reaction[r])-rhs(Reaction[r]),i); "}
}{INP_R 282 0 "> "{TEXT 0 7 "od; od;"}}{OUT_R 285 8192 282{DAG :3
b3n3\`nu`,3n3\`CO2`n3\`R1`j2x0001}}{OUT_R 288 8192 282{DAG :3b3n3
\`nu`,3n3\`H2`n3\`R1`j2x0003}}{OUT_R 291 8192 282{DAG :3b3n3\`nu`
,3n4\`CH3OH`n3\`R1`i2x0001}}{OUT_R 294 8192 282{DAG :3b3n3\`nu`,3
n3\`H2O`n3\`R1`i2x0001}}{OUT_R 297 8192 282{DAG :3b3n3\`nu`,3n3\`
I`n3\`R1`j2x0000}}}{SCP_R 299 0 2{COM_R 301 0{TEXT 1 120 "The rat
e of consumption of CO2 is expressed in terms of the conversion, 
X, and the rate at which CO2 enters the reactor."}}{COM_R 304 0
{TEXT 1 0 ""}}}{SCP_R 306 0 2{INP_R 308 0 "> "{TEXT 0 78 "X:='X':
 u:=Reactor: R[CO2,u]:=X*convert([seq(F[j]*x[CO2,j],j=Inputs[u])]
,`+`);"}}{OUT_R 311 8192 308{DAG :3b3n3\`R`,3n3\`CO2`n4\`Reactor`
*7n3\`X`j2x0001b3n3\`F`,2j2x0002pDb3n3\`x`,3p5p13pD}}}{SCP_R 313 
0 2{COM_R 315 0{TEXT 1 122 "The rates at which the other componen
ts are used up (or created) can be expressed in terms of the rate
 of reaction of CO2."}}{COM_R 318 0{TEXT 1 0 ""}}}{SCP_R 320 0 5
{INP_R 322 0 "> "{TEXT 0 71 "for i in [H2,CH3OH,H2O,I] do  R[i,u]
:=nu[i,R1]/nu[CO2,R1]*R[CO2,u]; od;"}}{OUT_R 325 8192 322{DAG :3b
3n3\`R`,3n3\`H2`n4\`Reactor`+3*7n3\`X`j2x0001b3n3\`F`,2j2x0002pEb
3n3\`x`,3n3\`CO2`p14pEj2x0003}}{OUT_R 328 8192 322{DAG :3b3n3\`R`
,3n4\`CH3OH`n4\`Reactor`+3*7n3\`X`j2x0001b3n3\`F`,2j2x0002pFb3n3\
`x`,3n3\`CO2`p15pFi2x0001}}{OUT_R 331 8192 322{DAG :3b3n3\`R`,3n3
\`H2O`n4\`Reactor`+3*7n3\`X`j2x0001b3n3\`F`,2j2x0002pEb3n3\`x`,3n
3\`CO2`p14pEi2x0001}}{OUT_R 334 8192 322{DAG :3b3n3\`R`,3n3\`I`n4
\`Reactor`j2x0000}}}{SCP_R 336 0 4{COM_R 338 0{TEXT 1 83 "Note th
at the rate of reaction of the inerts is computed to be zero (as 
it should)."}}{COM_R 341 0{TEXT 1 0 ""}}{COM_R 344 0{TEXT 1 230 "
We are now in position to present the material balances for the r
eactor.  The Maple construction is similar to that used to derive
 the material balances for the other units but contains an additi
onal term for the rate of reaction."}}{COM_R 347 0{TEXT 1 0 ""}}}
{SCP_R 349 0 13{INP_R 351 0 "> "{TEXT 0 22 "for u in [Reactor] do
 "}}{INP_R 354 0 "> "{TEXT 0 37 "   print(`Material balances for 
`.u);"}}{INP_R 357 0 "> "{TEXT 0 33 "   for i in components do   
     "}}{INP_R 360 0 "> "{TEXT 0 61 "   CMB[i,u] := convert([seq(
F[j]*x[i,j],j=Inputs[u])],`+`) = "}}{INP_R 363 0 "> "{TEXT 0 76 "
                      convert([seq(F[j]*x[i,j],j=Outputs[u])],`+`
) + R[i,u];"}}{INP_R 366 0 "> "{TEXT 0 19 "   print(CMB[i,u]);"}}
{INP_R 369 0 "> "{TEXT 0 7 "od; od:"}}{OUT_R 372 8192 369{DAG nA\
`Material~`balances~`for~`Reactor`}}{OUT_R 375 8192 369{DAG =3*5b
3n3\`F`,2j2x0002j2x0001b3n3\`x`,3n3\`CO2`p6p8+5*5b3p3,2j2x0003p8b
3pB,3pEp17p8p8*7n3\`X`p8p2p8pAp8p8}}{OUT_R 378 8192 369{DAG =3*5b
3n3\`F`,2j2x0002j2x0001b3n3\`x`,3n3\`H2`p6p8+5*5b3p3,2j2x0003p8b3
pB,3pEp17p8p8*7n3\`X`p8p2p8b3pB,3n3\`CO2`p6p8p17}}{OUT_R 381 8192
 369{DAG =3*5b3n3\`F`,2j2x0002j2x0001b3n3\`x`,3n4\`CH3OH`p6p8+5*5
b3p3,2j2x0003p8b3pB,3pEp18p8p8*7n3\`X`p8p2p8b3pB,3n3\`CO2`p6p8i2x
0001}}{OUT_R 384 8192 369{DAG =3*5b3n3\`F`,2j2x0002j2x0001b3n3\`x
`,3n3\`H2O`p6p8+5*5b3p3,2j2x0003p8b3pB,3pEp17p8p8*7n3\`X`p8p2p8b3
pB,3n3\`CO2`p6p8i2x0001}}{OUT_R 387 8192 369{DAG =3*5b3n3\`F`,2j2
x0002j2x0001b3n3\`x`,3n3\`I`p6p8*5b3p3,2j2x0003p8b3pB,3pEp16p8}}}
{SCP_R 389 0 3{COM_R 391 0{TEXT 1 0 ""}}{COM_R 394 0{TEXT 1 114 "
The mole fractions in each stream must sum to 1.  The mole fracti
on summation equations can be created as follows:"}}{COM_R 397 0
{TEXT 1 0 ""}}}{SCP_R 399 0 11{INP_R 401 0 "> "{TEXT 0 37 "SumEqn
:='SumEqn': for j in Streams do"}}{INP_R 404 0 "> "{TEXT 0 56 "  
 SumEqn[j]:=convert([seq(x[i,j],i=components)],`+`)=1;"}}{INP_R 
407 0 "> "{TEXT 0 20 "   print(SumEqn[j]);"}}{INP_R 410 0 "> "
{TEXT 0 3 "od:"}}{OUT_R 413 8192 410{DAG =3+Bb3n3\`x`,3n3\`CO2`j2
x0001p8b3p3,3n3\`H2`p8p8b3p3,3n4\`CH3OH`p8p8b3p3,3n3\`H2O`p8p8b3p
3,3n3\`I`p8p8p8}}{OUT_R 416 8192 410{DAG =3+Bb3n3\`x`,3n3\`CO2`j2
x0002j2x0001b3p3,3n3\`H2`p8pAb3p3,3n4\`CH3OH`p8pAb3p3,3n3\`H2O`p8
pAb3p3,3n3\`I`p8pApA}}{OUT_R 419 8192 410{DAG =3+Bb3n3\`x`,3n3\`C
O2`j2x0003j2x0001b3p3,3n3\`H2`p8pAb3p3,3n4\`CH3OH`p8pAb3p3,3n3\`H
2O`p8pAb3p3,3n3\`I`p8pApA}}{OUT_R 422 8192 410{DAG =3+Bb3n3\`x`,3
n3\`CO2`j2x0004j2x0001b3p3,3n3\`H2`p8pAb3p3,3n4\`CH3OH`p8pAb3p3,3
n3\`H2O`p8pAb3p3,3n3\`I`p8pApA}}{OUT_R 425 8192 410{DAG =3+Bb3n3\
`x`,3n3\`CO2`j2x0005j2x0001b3p3,3n3\`H2`p8pAb3p3,3n4\`CH3OH`p8pAb
3p3,3n3\`H2O`p8pAb3p3,3n3\`I`p8pApA}}{OUT_R 428 8192 410{DAG =3+B
b3n3\`x`,3n3\`CO2`j2x0006j2x0001b3p3,3n3\`H2`p8pAb3p3,3n4\`CH3OH`
p8pAb3p3,3n3\`H2O`p8pAb3p3,3n3\`I`p8pApA}}{OUT_R 431 8192 410{DAG
 =3+Bb3n3\`x`,3n3\`CO2`j2x0007j2x0001b3p3,3n3\`H2`p8pAb3p3,3n4\`C
H3OH`p8pAb3p3,3n3\`H2O`p8pAb3p3,3n3\`I`p8pApA}}}{SCP_R 433 0 2
{COM_R 435 0{TEXT 1 188 "The composition of the the streams enter
ing and leaving the stream splitter must be the same.  We must, t
herefore, add the following mole fraction equalities to the set o
f model equations."}}{COM_R 438 0{TEXT 1 0 ""}}}{SCP_R 440 0 8
{INP_R 442 0 "> "{TEXT 0 36 "u:=Splitter: for i from 1 to nc-1 do
"}}{INP_R 445 0 "> "{TEXT 0 79 "  SplitEqn[i,u]:=x[components[i],
Outputs[u][1]]=x[components[i],Outputs[u][2]];"}}{INP_R 448 0 "> 
"{TEXT 0 24 "  print(SplitEqn[i,u]); "}}{INP_R 451 0 "> "{TEXT 0 
3 "od:"}}{OUT_R 454 8192 451{DAG =3b3n3\`x`,3n3\`CO2`j2x0006b3p2,
3p5j2x0007}}{OUT_R 457 8192 451{DAG =3b3n3\`x`,3n3\`H2`j2x0006b3p
2,3p5j2x0007}}{OUT_R 460 8192 451{DAG =3b3n3\`x`,3n4\`CH3OH`j2x00
06b3p2,3p5j2x0007}}{OUT_R 463 8192 451{DAG =3b3n3\`x`,3n3\`H2O`j2
x0006b3p2,3p5j2x0007}}}{SCP_R 465 0 4{COM_R 467 0{TEXT 1 177 "Not
e that we only need 4 mole fraction equalities; the mole fraction
 summation equations will take care of ensuring that the mole fra
ctions of the other component will be equal."}}{COM_R 470 0{TEXT 
1 0 ""}}{COM_R 473 0{TEXT 1 298 "The component material balances 
and the mole fraction summation equations comprise the complete s
et of independent equations for this problem.  Any other balance 
equation can be created from simple combinations of these equatio
ns.  The total material balances for each unit are obtained as fo
llows:"}}{COM_R 476 0{TEXT 1 0 ""}}}{SCP_R 478 0 10{INP_R 480 0 "
> "{TEXT 0 17 "for u in Units do"}}{INP_R 483 0 "> "{TEXT 0 49 " 
  t1:=convert([seq(CMB[i,u],i=components)],`+`):"}}{INP_R 486 0 "
> "{TEXT 0 41 "   t1:=collect(t1,[seq(F[j],j=Streams)]):"}}{INP_R
 489 0 "> "{TEXT 0 46 "   TMB[u]:=subs(\{seq(SumEqn[j],j=Streams)
\},\");"}}{INP_R 492 0 "> "{TEXT 0 17 "   print(TMB[u]);"}}{INP_R
 495 0 "> "{TEXT 0 3 "od:"}}{OUT_R 498 8192 495{DAG =3+5b3n3\`F`,
2j2x0001p6b3p3,2j2x0007p6b3p3,2j2x0002}}{OUT_R 501 8192 495{DAG =
3b3n3\`F`,2j2x0002+5*7n3\`X`j2x0001p1pBb3n3\`x`,3n3\`CO2`p5pBp5b3
p2,2j2x0003pB}}{OUT_R 504 8192 495{DAG =3b3n3\`F`,2j2x0003+5b3p2,
2j2x0004j2x0001b3p2,2j2x0005pD}}{OUT_R 507 8192 495{DAG =3b3n3\`F
`,2j2x0005+5b3p2,2j2x0006j2x0001b3p2,2j2x0007pD}}}{SCP_R 509 0 2
{COM_R 511 0{TEXT 1 65 "The number of variables appearing in the 
independent equations is"}}{COM_R 514 0{TEXT 1 0 ""}}}{SCP_R 516 
0 2{INP_R 518 0 "> "{TEXT 0 28 "Nvars:=(nc+1)*nops(Streams);"}}
{OUT_R 521 8192 518{DAG :3n4\`Nvars`j2x0042}}}{SCP_R 523 0 4
{COM_R 525 0{TEXT 1 123 "where we have counted the mole fraction 
of each component and the total flow rate and multiilpied by the 
number of streams."}}{COM_R 528 0{TEXT 1 0 ""}}{COM_R 531 0{TEXT 
1 48 "The number of equations is computed differently:"}}{COM_R 
534 0{TEXT 1 0 ""}}}{SCP_R 536 0 3{INP_R 538 0 "> "{TEXT 0 51 "Ne
qns:=nops([indices(CMB)])+nops([indices(SumEqn)])"}}{INP_R 541 0 
"> "{TEXT 0 39 "            +nops([indices(SplitEqn)]);"}}{OUT_R 
544 8192 541{DAG :3n4\`Neqns`j2x0031}}}{SCP_R 546 0 5{COM_R 548 0
{TEXT 1 0 ""}}{COM_R 551 0{TEXT 1 208 "where we have counted the 
number of component mass balances, summation equations and splitt
er equalities by counting the number of different indices there a
re in the tables of each of these sets of equations."}}{COM_R 554
 0{TEXT 1 0 ""}}{COM_R 557 0{TEXT 1 76 "The number of degrees of 
freedom is the difference between these two numbers"}}{COM_R 560 
0{TEXT 1 1 " "}}}{SCP_R 562 0 2{INP_R 564 0 "> "{TEXT 0 21 "DegFr
ee:=Nvars-Neqns;"}}{OUT_R 567 8192 564{DAG :3n4\`DegFree`j2x0011}
}}{SCP_R 569 0 4{COM_R 571 0{TEXT 1 116 "This means that we must 
provide 11 specifications in order to have a consistent set of eq
uations that can be solved."}}{COM_R 574 0{TEXT 1 0 ""}}{COM_R 
577 0{TEXT 1 283 "Felder and Rousseau set the feed flow to the re
actor to 100 mol/h as a basis for solving this problem and then s
cale the flows afterwards to meet the specified production rate o
f methanol of 1000 kmol/h.  Here we simply specify the flow rate 
of methanol in stream 4 to be 1000 mol/h."}}{COM_R 580 0{TEXT 1 0
 ""}}}{SCP_R 582 0 2{INP_R 584 0 "> "{TEXT 0 31 "Specs[1]:=F[4]*x
[CH3OH,4]=1000;"}}{OUT_R 587 8192 584{DAG :3b3n4\`Specs`,2j2x0001
=3*5b3n3\`F`,2j2x0004p6b3n3\`x`,3n4\`CH3OH`pEp6j2x1000}}}{SCP_R 
589 0 2{COM_R 591 0{TEXT 1 129 "We also know that the fresh feed 
to the process has 0.5% inerts and that the two reactants are pre
sent in stoichiometric amounts."}}{COM_R 594 0{TEXT 1 0 ""}}}
{SCP_R 596 0 3{INP_R 598 0 "> "{TEXT 0 72 "Specs[2]:=x[I,1]=0.005
; Specs[3]:=x[H2,1]=nu[H2,R1]/nu[CO2,R1]*x[CO2,1];"}}{OUT_R 601 
8192 598{DAG :3b3n4\`Specs`,2j2x0002=3b3n3\`x`,3n3\`I`j2x0001e3j2
x0005i2x0003}}{OUT_R 604 8192 598{DAG :3b3n4\`Specs`,2j2x0003=3b3
n3\`x`,3n3\`H2`j2x0001+3b3pA,3n3\`CO2`pFp6}}}{SCP_R 606 0 1{COM_R
 608 0{TEXT 1 48 "There is no methanol or water in the feed strea
m"}}}{SCP_R 610 0 3{INP_R 612 0 "> "{TEXT 0 45 "Specs[4]:=x[H2O,1
]=0; Specs[5]:=x[CH3OH,1]=0;"}}{OUT_R 615 8192 612{DAG :3b3n4\`Sp
ecs`,2j2x0004=3b3n3\`x`,3n3\`H2O`j2x0001j2x0000}}{OUT_R 618 8192 
612{DAG :3b3n4\`Specs`,2j2x0005=3b3n3\`x`,3n4\`CH3OH`j2x0001j2x00
00}}}{SCP_R 620 0 3{COM_R 622 0{TEXT 1 0 ""}}{COM_R 625 0{TEXT 1 
244 "The condenser serves as a simple component separator and we 
need one specification equation for each component.  There is no 
methanol or water in the recyle stream (5) and there is no CO2, H
2, or inerts in the methanol/water product stream (4)."}}{COM_R 
628 0{TEXT 1 0 ""}}}{SCP_R 630 0 7{INP_R 632 0 "> "{TEXT 0 46 "Sp
ecs[6]:=x[CH3OH,5]=0; Specs[7]:=x[H2O,5]=0; "}}{INP_R 635 0 "> "
{TEXT 0 63 "Specs[8]:=x[CO2,4]=0; Specs[9]:=x[H2,4]=0; Specs[10]:
=x[I,4]=0;"}}{OUT_R 638 8192 635{DAG :3b3n4\`Specs`,2j2x0006=3b3n
3\`x`,3n4\`CH3OH`j2x0005j2x0000}}{OUT_R 641 8192 635{DAG :3b3n4\`
Specs`,2j2x0007=3b3n3\`x`,3n3\`H2O`j2x0005j2x0000}}{OUT_R 644 
8192 635{DAG :3b3n4\`Specs`,2j2x0008=3b3n3\`x`,3n3\`CO2`j2x0004j2
x0000}}{OUT_R 647 8192 635{DAG :3b3n4\`Specs`,2j2x0009=3b3n3\`x`,
3n3\`H2`j2x0004j2x0000}}{OUT_R 650 8192 635{DAG :3b3n4\`Specs`,2j
2x0010=3b3n3\`x`,3n3\`I`j2x0004j2x0000}}}{SCP_R 652 0 2{COM_R 654
 0{TEXT 1 385 "We complete the set of specifications by saying so
mething about the purge stream.  It is possible for Maple to solv
e this problem for an arbitrary purge or recycle flow rate or  ra
tio.  However, the resulting expressions are rather lengthy.  The
 purge and recycle flows are controlled by the requirement (given
 in the problem statement) that the feed to the reactor contains 
2% inerts."}}{COM_R 657 0{TEXT 1 0 ""}}}{SCP_R 659 0 2{INP_R 661 
0 "> "{TEXT 0 23 "Specs[11]:=x[I,2]=0.02;"}}{OUT_R 664 8192 661
{DAG :3b3n4\`Specs`,2j2x0011=3b3n3\`x`,3n3\`I`j2x0002e3pFi2x0002}
}}{SCP_R 666 0 3{COM_R 668 0{TEXT 1 299 "It is often wise to tack
le problems like this by solving the equations for one unit at a 
time to ensure that the model has been set up correctly.  In the 
interests of brevity we do not include the results of such an exe
rcise here.  Instead, we will ask Maple to solve the entire flows
heet in one go."}}{COM_R 671 0{TEXT 1 0 ""}}{COM_R 674 0{TEXT 1 
52 "We create a set of equations and a set of variables:"}}}
{SCP_R 676 0 3{INP_R 678 0 "> "{TEXT 0 72 "Eqns:=\{seq(seq(CMB[i,
u],i=components),u=Units),seq(SumEqn[j],j=Streams),"}}{INP_R 681 
0 "> "{TEXT 0 72 "            seq(SplitEqn[i,Splitter],i=1..nc-1)
, seq(Specs[l],l=1..11)\}:"}}{OUT_R 684 0 681{TEXT 2 1 "\012"}}}
{SCP_R 686 0 2{INP_R 688 0 "> "{TEXT 0 68 "Vars:=\{seq(seq(x[i,j]
,i=components),j=Streams),seq(F[j],j=Streams)\}:"}}{OUT_R 691 0 
688{TEXT 2 1 "\012"}}}{SCP_R 693 0 1{COM_R 695 0{TEXT 1 80 "A fin
al check that the number of equations and the number of variables
 are equal"}}}{SCP_R 697 0 3{INP_R 699 0 "> "{TEXT 0 23 "nops(Eqn
s); nops(Vars);"}}{OUT_R 702 8192 699{DAG j2x0042}}{OUT_R 705 
8192 699{DAG j2x0042}}}{SCP_R 707 0 1{COM_R 709 0{TEXT 1 50 "and 
we are ready to invoke Maple's solve function."}}}{SCP_R 711 0 2
{INP_R 713 0 "> "{TEXT 0 25 "result:=solve(Eqns,Vars):"}}{OUT_R 
716 0 713{TEXT 2 1 "\012"}}}{SCP_R 718 0 2{COM_R 720 0{TEXT 1 150
 "The result (hidden here to save space) is a set of equations in
 no particular order.  We will print out the results in a rather 
more organized fashion"}}{COM_R 723 0{TEXT 1 0 ""}}}{SCP_R 725 0 
2{INP_R 727 0 "> "{TEXT 0 45 "print(seq(F[j]=subs(result,F[j]),j=
Streams));"}}{OUT_R 730 8192 727{DAG ,8=3b3n3\`F`,2j2x0001*7+5e3i
3x29400000j2x0000p6n3\`X`e3j3x29400000pEp6+5e3j2x0150pEp6p11e3j2x
0049pEi2x0001+5e3i4x003675000000i2x0008p6p11e3j4x003675000000p2Cp
24=3b3p3,2j2x0002+3*7p11p24+5e3i2x3000pEp6p11e3j2x3000pEp6p26p24e
3j4x005000000000p2C=3b3p3,2j2x0003+3*5+5p11e3j2x2000pEe3i4x004081
632653i2x0006p6p6p11p24e3p24pE=3b3p3,2j2x0004*5+5e3i3x00073500pEp
6p11e3j3x00073500pEp6p26p24=3b3p3,2j2x0005+3*5+5p11e3j2x4000pEp63
p6p6p11p24p6E=3b3p3,2j2x0006+3*9+5e3i3x00049000pEp6p11e3j3x000490
00pEp6+5p11e3j2x0147pEe3i2x0150pEp6p6p19p24p26p24p6E=3b3p3,2j2x00
07+3*BpB2p6+5e3i3x00150000pEp6p11e3j3x00150000pEp6p19p24p26p24p11
p24p6E}}}{SCP_R 732 0 1{COM_R 734 0{TEXT 1 51 "The mole fractions
 in streams 1 to 5 are as follows"}}}{SCP_R 736 0 6{INP_R 738 0 "
> "{TEXT 0 80 "for j in [1,2,3,4,5] do print(seq(x[i,j]=subs(resu
lt,x[i,j]),i=components)); od;"}}{OUT_R 741 8192 738{DAG ,6=3b3n3
\`x`,3n3\`CO2`j2x0001e3j4x002487500000i2x0010=3b3p3,3n3\`H2`p8e3j
4x007462500000pF=3b3p3,3n4\`CH3OH`p8j2x0000=3b3p3,3n3\`H2O`p8p26=
3b3p3,3n3\`I`p8e3j4x005000000000i2x0012}}{OUT_R 744 8192 738{DAG 
,6=3b3n3\`x`,3n3\`CO2`j2x0002e3j4x002450000000i2x0010=3b3p3,3n3\`
H2`p8e3j4x007350000000pF=3b3p3,3n4\`CH3OH`p8j2x0000=3b3p3,3n3\`H2
O`p8p26=3b3p3,3n3\`I`p8e3j4x002000000000i2x0011}}{OUT_R 747 8192 
738{DAG ,6=3b3n3\`x`,3n3\`CO2`j2x0003*5+5e3i2x1000j2x0000j2x0001n
3\`X`e3j2x1000pFp11+5p13e3j2x2000pFe3i4x004081632653i2x0006p11i2x
0001=3b3p3,3n3\`H2`p8+3*5+5e3i2x3000pFp11p13e3j2x3000pFp11p1Ap28e
3j4x001000000000i2x0009=3b3p3,3n4\`CH3OH`p8+3*5p1Ap28p13p11e3i4x0
01000000000p25=3b3p3,3n3\`H2O`p8p50=3b3p3,3n3\`I`p8+3*7p33p11+5e3
i4x003675000000i2x0008p11p13e3j4x003675000000p75p28p1Ap28e3p57p46
}}{OUT_R 750 8192 738{DAG ,6=3b3n3\`x`,3n3\`CO2`j2x0004j2x0000=3b
3p3,3n3\`H2`p8pA=3b3p3,3n4\`CH3OH`p8e3j4x005000000000i2x0010=3b3p
3,3n3\`H2O`p8p1C=3b3p3,3n3\`I`p8pA}}{OUT_R 753 8192 738{DAG ,6=3b
3n3\`x`,3n3\`CO2`j2x0005*5+5e3i2x1000j2x0000j2x0001n3\`X`e3j2x100
0pFp11+5p13e3j2x4000pFe3i4x004081632653i2x0006p11i2x0001=3b3p3,3n
3\`H2`p8*5+5e3i2x3000pFp11p13e3j2x3000pFp11p1Ap28=3b3p3,3n4\`CH3O
H`p8pF=3b3p3,3n3\`H2O`p8pF=3b3p3,3n3\`I`p8+3*7p32p11p1Ap28+5e3i4x
003675000000i2x0008p11p13e3j4x003675000000p64p28e3p28pF}}}{SCP_R 
755 0 3{COM_R 757 0{TEXT 1 116 "We have not printed the mole frac
tions in streams 6 and 7 since they are the same as the mole frac
tions in stream 5."}}{COM_R 760 0{TEXT 1 0 ""}}{COM_R 763 0{TEXT 
1 83 "We can now evaluate the flows and compositions for the spec
ified conversion of 0.6."}}}{SCP_R 765 0 2{INP_R 767 0 "> "{TEXT 
0 7 "X:=0.6:"}}{OUT_R 770 0 767{TEXT 2 1 "\012"}}}{SCP_R 772 0 2
{INP_R 774 0 "> "{TEXT 0 45 "print(seq(F[j]=subs(result,F[j]),j=S
treams));"}}{OUT_R 777 8192 774{DAG ,8=3b3n3\`F`,2j2x0001e3j4x004
459308807i2x0006=3b3p3,2j2x0002e3j4x006802721090pD=3b3p3,2j2x0003
e3j4x004802721088pD=3b3p3,2j2x0004e3j2x2000j2x0000=3b3p3,2j2x0005
e3j4x002802721088pD=3b3p3,2j2x0006e3j4x004593088071i2x0007=3b3p3,
2j2x0007e3j4x002343412282pD}}}{SCP_R 779 0 6{INP_R 781 0 "> "
{TEXT 0 80 "for j in [1,2,3,4,5] do print(seq(x[i,j]=subs(result,
x[i,j]),i=components)); od;"}}{OUT_R 784 8192 781{DAG ,6=3b3n3\`x
`,3n3\`CO2`j2x0001e3j4x002487500000i2x0010=3b3p3,3n3\`H2`p8e3j4x0
07462500000pF=3b3p3,3n4\`CH3OH`p8j2x0000=3b3p3,3n3\`H2O`p8p26=3b3
p3,3n3\`I`p8e3j4x005000000000i2x0012}}{OUT_R 787 8192 781{DAG ,6=
3b3n3\`x`,3n3\`CO2`j2x0002e3j4x002450000000i2x0010=3b3p3,3n3\`H2`
p8e3j4x007350000000pF=3b3p3,3n4\`CH3OH`p8j2x0000=3b3p3,3n3\`H2O`p
8p26=3b3p3,3n3\`I`p8e3j4x002000000000i2x0011}}{OUT_R 790 8192 781
{DAG ,6=3b3n3\`x`,3n3\`CO2`j2x0003e3j4x001388101983i2x0010=3b3p3,
3n3\`H2`p8e3j4x004164305949pF=3b3p3,3n4\`CH3OH`p8e3j4x00208215297
5pF=3b3p3,3n3\`H2O`p8p26=3b3p3,3n3\`I`p8e3j4x002832861190i2x0011}
}{OUT_R 793 8192 781{DAG ,6=3b3n3\`x`,3n3\`CO2`j2x0004j2x0000=3b3
p3,3n3\`H2`p8pA=3b3p3,3n4\`CH3OH`p8e3j4x005000000000i2x0010=3b3p3
,3n3\`H2O`p8p1C=3b3p3,3n3\`I`p8pA}}{OUT_R 796 8192 781{DAG ,6=3b3
n3\`x`,3n3\`CO2`j2x0005e3j4x002378640777i2x0010=3b3p3,3n3\`H2`p8e
3j4x007135922330pF=3b3p3,3n4\`CH3OH`p8j2x0000=3b3p3,3n3\`H2O`p8p2
6=3b3p3,3n3\`I`p8e3j4x004854368932i2x0011}}}{SCP_R 798 0 2{COM_R 
800 0{TEXT 1 0 ""}}{COM_R 803 0{TEXT 1 121 "We can easily check t
hat this result really is a solution by substituting the result i
nto the original set  of equations."}}}{SCP_R 805 0 2{INP_R 807 0
 "> "{TEXT 0 28 "simplify(subs(result,Eqns));"}}{OUT_R 810 8192 
807{DAG %2,14=3e3j4x005000000000i2x0012p3=3e3j4x002378640777i2x00
10pC=3e3j4x007462500000p11p15=3e3j4x007135922330p11p1D=3e3j4x0016
66666667i2x0006p25=3j2x0000p2E=3e3j4x001360544217i2x0007e3j4x0013
60544218p37=3e3j4x006666666666p37p40=3e3j4x005000000001p2Ap48=3p3
9p32=3p40e3j4x006666666669p37=3p32p32=3p39p39=3e3j2x0001p2Ep62=3e
3j2x1000p2Ep68=3e3j2x5000p2Ep48=3e3j2x2000p2Ep73=3p67p67=3e3j4x00
2000000000i2x0011p7C}}}{SCP_R 812 0 2{COM_R 814 0{TEXT 1 102 "It 
is a simple matter now to assign to X a different numerical value
 and to re-evaluate the flowsheet."}}{INP_R 817 0 "> "{TEXT 0 0 "
"}}}}{END}

