{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--10-*" "helvetica" "Helvetica-Bold" 8 10 0 "He
lvetica-Bold" 10}{FONT 1 "-adobe-times-medium-r-normal--12-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "Courier" "Co
urier" "Courier" 4 12 192 "Courier" 12}{SCP_R 1 0 99{COM_R 2 0
{TEXT 1 245 "Material balances for a process with bypass \015\015
This worksheet solve example 2.19 in G.V. Reklaitis' book \"Intro
duction to Material and Energy Balances\" (McGraw-Hill)\015\015Th
e example concerns the concentration of range juice by evaporatio
n of water.\015"}}{INP_R 3 0 "> "{TEXT 0 36 "restart; interface(l
abelling=false):"}}{COM_R 4 0{TEXT 1 209 "\015We begin by creatin
g a list of component identities.  We could use numbers, or lette
rs; here we use the chemical formulae to denote each component.  
 The number of components is also computed for later use.\015\015
"}}{INP_R 5 0 "> "{TEXT 0 49 "components:=[Solids,Water]; nc:=nop
s(components);"}}{OUT_R 6 0 5{DAG :3n5\`components`[2,3n4\`Solids
`n4\`Water`}}{OUT_R 7 0 5{DAG :3n3\`nc`j2x0002}}{COM_R 8 0{TEXT 1
 41 "\015Next, we create a set of process units:\015"}}{INP_R 9 0
 "> "{TEXT 0 35 "Units:=[Splitter,Evaporator,Mixer];"}}{OUT_R 10 
0 9{DAG :3n4\`Units`[2,4n5\`Splitter`n5\`Evaporator`n4\`Mixer`}}
{COM_R 11 0{TEXT 1 156 "The streams will also have to be identifi
ed.  Again, we could use any indexing method that is convenient. 
 Here we choose to assign numbers to each stream.\015"}}{INP_R 12
 0 "> "{TEXT 0 25 "Streams:=[seq(i,i=1..6)];"}}{OUT_R 13 0 12{DAG
 :3n4\`Streams`[2,7j2x0001j2x0002j2x0003j2x0004j2x0005j2x0006}}
{COM_R 14 0{TEXT 1 283 "\015We create lists of the input streams 
to and output streams leaving each process unit.  \015\015The fir
st unit is the splitter which takes the fresh feed and splits it 
into 2 streams, one of which goes to the evaporator (stream 2), t
he other bypasses the evaporator altogether (stream 3).\015"}}
{INP_R 15 0 "> "{TEXT 0 48 "Inputs[Units[1]]:=[1]; Outputs[Units[
1]]:=[2,3];"}}{OUT_R 16 0 15{DAG :3b3n4\`Inputs`,2n5\`Splitter`[2
,2j2x0001}}{OUT_R 17 0 15{DAG :3b3n4\`Outputs`,2n5\`Splitter`[2,3
j2x0002j2x0003}}{INP_R 18 0 "> "{TEXT 0 48 "Inputs[Units[2]]:=[2]
; Outputs[Units[2]]:=[4,5];"}}{OUT_R 19 0 18{DAG :3b3n4\`Inputs`,
2n5\`Evaporator`[2,2j2x0002}}{OUT_R 20 0 18{DAG :3b3n4\`Outputs`,
2n5\`Evaporator`[2,3j2x0004j2x0005}}{COM_R 21 0{TEXT 1 107 "where
 stream 4 is the evaporated water stream.  Stream 5 goes to the m
ixer along with the bypass stream 3.\015"}}{INP_R 22 0 "> "{TEXT 
0 48 "Inputs[Units[3]]:=[3,5]; Outputs[Units[3]]:=[6];"}}{OUT_R 
23 0 22{DAG :3b3n4\`Inputs`,2n4\`Mixer`[2,3j2x0003j2x0005}}{OUT_R
 24 0 22{DAG :3b3n4\`Outputs`,2n4\`Mixer`[2,2j2x0006}}{COM_R 25 0
{TEXT 1 54 "We may now set up the material balances for each unit
\015"}}{INP_R 26 0 "> "{TEXT 0 223 "for u in Units do \012   prin
t(`Material balances for `.u);\012   for i in components do\012  
      CMB[i,u]:=convert([seq(F[j]*x[i,j],j=Inputs[u])],`+`)=conve
rt([seq(F[j]*x[i,j],j=Outputs[u])],`+`);\012        print(CMB[i,u
]);\012od; od;"}}{OUT_R 27 0 26{DAG nA\`Material~`balances~`for~`
Splitter`}}{OUT_R 28 0 26{DAG =3*5b3n3\`F`,2j2x0001p6b3n3\`x`,3n4
\`Solids`p6p6+5*5b3p3,2j2x0002p6b3pA,3pDp17p6p6*5b3p3,2j2x0003p6b
3pA,3pDp25p6p6}}{OUT_R 29 0 26{DAG =3*5b3n3\`F`,2j2x0001p6b3n3\`x
`,3n4\`Water`p6p6+5*5b3p3,2j2x0002p6b3pA,3pDp17p6p6*5b3p3,2j2x000
3p6b3pA,3pDp25p6p6}}{OUT_R 30 0 26{DAG nB\`Material~`balances~`fo
r~`Evaporator`}}{OUT_R 31 0 26{DAG =3*5b3n3\`F`,2j2x0002j2x0001b3
n3\`x`,3n4\`Solids`p6p8+5*5b3p3,2j2x0004p8b3pB,3pEp18p8p8*5b3p3,2
j2x0005p8b3pB,3pEp26p8p8}}{OUT_R 32 0 26{DAG =3*5b3n3\`F`,2j2x000
2j2x0001b3n3\`x`,3n4\`Water`p6p8+5*5b3p3,2j2x0004p8b3pB,3pEp18p8p
8*5b3p3,2j2x0005p8b3pB,3pEp26p8p8}}{OUT_R 33 0 26{DAG n9\`Materia
l~`balances~`for~`Mixer`}}{OUT_R 34 0 26{DAG =3+5*5b3n3\`F`,2j2x0
003j2x0001b3n3\`x`,3n4\`Solids`p7p9p9*5b3p4,2j2x0005p9b3pC,3pFp19
p9p9*5b3p4,2j2x0006p9b3pC,3pFp27p9}}{OUT_R 35 0 26{DAG =3+5*5b3n3
\`F`,2j2x0003j2x0001b3n3\`x`,3n4\`Water`p7p9p9*5b3p4,2j2x0005p9b3
pC,3pFp19p9p9*5b3p4,2j2x0006p9b3pC,3pFp27p9}}{COM_R 36 0{TEXT 1 
498 "In the above Maple construction we have created the componen
t material balances for each component in the inner loop and for 
each process unit with the exception of the reactor in the outer 
loop.\015\015The total flows are given the symbol F and x refers 
to the mass fraction of  some component.  The first index of the 
component mole fraction identifies the component in question, the
 second associates that quantity with a particular process stream
.\015\015The mass fractions must sum to one for each stream\015"}
}{INP_R 37 0 "> "{TEXT 0 119 "SumEqn:='SumEqn': for j in Streams 
do\012   SumEqn[j]:=convert([seq(x[i,j],i=components)],`+`)=1;\01
2   print(SumEqn[j]);\012od:"}}{OUT_R 38 0 37{DAG =3+5b3n3\`x`,3n
4\`Solids`j2x0001p9b3p3,3n4\`Water`p9p9p9}}{OUT_R 39 0 37{DAG =3+
5b3n3\`x`,3n4\`Solids`j2x0002j2x0001b3p3,3n4\`Water`p9pBpB}}
{OUT_R 40 0 37{DAG =3+5b3n3\`x`,3n4\`Solids`j2x0003j2x0001b3p3,3n
4\`Water`p9pBpB}}{OUT_R 41 0 37{DAG =3+5b3n3\`x`,3n4\`Solids`j2x0
004j2x0001b3p3,3n4\`Water`p9pBpB}}{OUT_R 42 0 37{DAG =3+5b3n3\`x`
,3n4\`Solids`j2x0005j2x0001b3p3,3n4\`Water`p9pBpB}}{OUT_R 43 0 37
{DAG =3+5b3n3\`x`,3n4\`Solids`j2x0006j2x0001b3p3,3n4\`Water`p9pBp
B}}{COM_R 44 0{TEXT 1 189 "The composition of the the streams ent
ering and leaving the stream splitter must be the same.  We must,
 therefore, add the following mole fraction equalities to the set
 of model equations.\015"}}{INP_R 45 0 "> "{TEXT 0 167 "u:=Splitt
er: SplitEqn:='SplitEqn': for i from 1 to nc-1 do\012     SplitEq
n[i,u]:=x[components[i],Outputs[u][1]]=x[components[i],Outputs[u]
[2]]; print(SplitEqn[i,u]); od:"}}{OUT_R 46 0 45{DAG =3b3n3\`x`,3
n4\`Solids`j2x0002b3p2,3p5j2x0003}}{COM_R 47 0{TEXT 1 462 "Note t
hat we only need 1 mass fraction equality; the mass fraction summ
ation equations will take care of ensuring that the mass fraction
s of the other component will be equal.\015\015The component mate
rial balances and the summation equations comprise the complete s
et of independent equations for this problem.  Any other balance 
equation can be created from simple combinations of these equatio
ns.  The total material balances for each unit are obtained as fo
llows:\015"}}{INP_R 48 0 "> "{TEXT 0 291 "for u in Units do\012  
 t1:=convert([seq(CMB[i,u],i=components)],`+`):  # sum component 
balances for a unit\012   t1:=collect(t1,[seq(F[j],j=Streams)]); 
                  # collect terms in each flow rate\012   TMB[u]:
=subs(\{seq(SumEqn[j],j=Streams)\},\");     # substitute the summ
ation equations \012od:"}}{INP_R 49 0 "> "{TEXT 0 36 "for u in Un
its do print(TMB[u]); od;"}}{OUT_R 50 0 49{DAG =3b3n3\`F`,2j2x000
1+5b3p2,2j2x0002p5b3p2,2j2x0003p5}}{OUT_R 51 0 49{DAG =3b3n3\`F`,
2j2x0002+5b3p2,2j2x0004j2x0001b3p2,2j2x0005pD}}{OUT_R 52 0 49{DAG
 =3+5b3n3\`F`,2j2x0003j2x0001b3p3,2j2x0005p8b3p3,2j2x0006}}{COM_R
 53 0{TEXT 1 67 "\015The number of variables appearing in the ind
ependent equations is\015"}}{INP_R 54 0 "> "{TEXT 0 28 "Nvars:=(n
c+1)*nops(Streams);"}}{OUT_R 55 0 54{DAG :3n4\`Nvars`j2x0018}}
{COM_R 56 0{TEXT 1 174 "where we have counted the mole fraction o
f each component and the total flow rate and multiilpied by the n
umber of streams.\015\015The number of equations is computed diff
erently:\015"}}{INP_R 57 0 "> "{TEXT 0 78 "Neqns:=nops([indices(C
MB)])+nops([indices(SumEqn)])+nops([indices(SplitEqn)]);"}}{OUT_R
 58 0 57{DAG :3n4\`Neqns`j2x0013}}{COM_R 59 0{TEXT 1 0 ""}}{COM_R
 60 0{TEXT 1 288 "where we have counted the number of component m
ass balances, summation equations and splitter equalities by coun
ting the number of different indices there are in the tables of e
ach of these sets of equations.\015\015The number of degrees of f
reedom is the difference between these two numbers\015 "}}{INP_R 
61 0 "> "{TEXT 0 21 "DegFree:=Nvars-Neqns;"}}{OUT_R 62 0 61{DAG :
3n4\`DegFree`j2x0005}}{COM_R 63 0{TEXT 1 150 "This means that we 
must provide 5 specifications in order to have a consistent set o
f equations that can be solved.\015\015The feed flow rate is 1000
0 lb/h\015"}}{INP_R 64 0 "> "{TEXT 0 21 "Specs[1]:=F[1]=10000;"}}
{OUT_R 65 0 64{DAG :3b3n4\`Specs`,2j2x0001=3b3n3\`F`p5j3x00010000
}}{COM_R 66 0{TEXT 1 105 "The fresh feed to the process has 12% s
olids and the fraction of solids in the evaporator product is 80%
."}}{INP_R 67 0 "> "{TEXT 0 28 "Specs[2]:=x[Solids,1]=0.12; "}}
{OUT_R 68 0 67{DAG :3b3n4\`Specs`,2j2x0002=3b3n3\`x`,3n4\`Solids`
j2x0001e3j2x0012i2x0002}}{INP_R 69 0 "> "{TEXT 0 26 "Specs[3]:=x[
Solids,5]=0.8;"}}{OUT_R 70 0 69{DAG :3b3n4\`Specs`,2j2x0003=3b3n3
\`x`,3n4\`Solids`j2x0005e3j2x0008i2x0001}}{COM_R 71 0{TEXT 1 51 "
There are no solids in stream 4 from the evaporator"}}{INP_R 72 0
 "> "{TEXT 0 25 "Specs[4]:=x[Solids,4]=0; "}}{OUT_R 73 0 72{DAG :
3b3n4\`Specs`,2j2x0004=3b3n3\`x`,3n4\`Solids`p6j2x0000}}{COM_R 74
 0{TEXT 1 27 "and the bypass ratio is 10%"}}{INP_R 75 0 "> "{TEXT
 0 24 "Specs[5]:=F[3]=F[1]/10;;"}}{OUT_R 76 0 75{DAG :3b3n4\`Spec
s`,2j2x0005=3b3n3\`F`,2j2x0003+3b3pA,2j2x0001/3p13j2x0010}}{COM_R
 77 0{TEXT 1 44 "\015We create a set of equations and variables\0
15"}}{INP_R 78 0 "> "{TEXT 0 154 "Eqns:=\{seq(seq(CMB[i,u],i=comp
onents),u=Units),seq(SumEqn[j],j=[1,2,3,4,5,6]),seq(SplitEqn[i,Sp
litter],i=1..nc-1),\012           seq(Specs[l],l=1..DegFree)\}:"}
}{INP_R 79 0 "> "{TEXT 0 80 "Vars:=\{seq(seq(x[i,j],i=components)
,j=[1,2,3,4,5,6]),seq(F[j],j=[1,2,3,4,5,6])\}:"}}{COM_R 80 0{TEXT
 1 82 "\015A final check that the numebr of equations and the num
ber of variables are equal\015"}}{INP_R 81 0 "> "{TEXT 0 23 "nops
(Eqns); nops(Vars);"}}{OUT_R 82 0 81{DAG j2x0018}}{OUT_R 83 0 81
{DAG j2x0018}}{COM_R 84 0{TEXT 1 51 "and we are ready to invoke M
aple's solve function.\015"}}{INP_R 85 0 "> "{TEXT 0 25 "result:=
solve(Eqns,Vars):"}}{COM_R 86 0{TEXT 1 277 "\015The result (hidde
n here to save apace) is a set of equations in no particular orde
r.  We can use the Maple assign command to attach the results to 
the appropriate variables but we will not do that here.  Instead 
we will print out the results in a rather more readable fashion\0
15"}}{INP_R 87 0 "> "{TEXT 0 45 "print(seq(F[j]=subs(result,F[j])
,j=Streams));"}}{OUT_R 88 0 87{DAG ,7=3b3n3\`F`,2j2x0001e3j3x0001
0000j2x0000=3b3p3,2j2x0002e3j4x009000000000i2x0006=3b3p3,2j2x0003
e3j2x1000pC=3b3p3,2j2x0004e3j4x007650000000p19=3b3p3,2j2x0005e3j4
x001350000000p19=3b3p3,2j2x0006e3j4x002350000000p19}}{INP_R 89 0 
"> "{TEXT 0 76 "for j in Streams do print(seq(x[i,j]=subs(result,
x[i,j]),i=components)); od;"}}{OUT_R 90 0 89{DAG ,3=3b3n3\`x`,3n4
\`Solids`j2x0001e3j4x001200000000i2x0010=3b3p3,3n4\`Water`p9e3j4x
008800000000p10}}{OUT_R 91 0 89{DAG ,3=3b3n3\`x`,3n4\`Solids`j2x0
002e3j4x001200000000i2x0010=3b3p3,3n4\`Water`p9e3j4x008800000000p
10}}{OUT_R 92 0 89{DAG ,3=3b3n3\`x`,3n4\`Solids`j2x0003e3j4x00120
0000000i2x0010=3b3p3,3n4\`Water`p9e3j4x008800000000p10}}{OUT_R 93
 0 89{DAG ,3=3b3n3\`x`,3n4\`Solids`j2x0004j2x0000=3b3p3,3n4\`Wate
r`p9e3j2x0001pB}}{OUT_R 94 0 89{DAG ,3=3b3n3\`x`,3n4\`Solids`j2x0
005e3j4x008000000000i2x0010=3b3p3,3n4\`Water`p9e3j4x002000000000p
10}}{OUT_R 95 0 89{DAG ,3=3b3n3\`x`,3n4\`Solids`j2x0006e3j4x00510
6382979i2x0010=3b3p3,3n4\`Water`p9e3j4x004893617021p10}}{COM_R 96
 0{TEXT 1 0 ""}}{COM_R 97 0{TEXT 1 122 "We can easily check that 
this result really is a solution by substituting the result into 
the original set  of equations.\015"}}{INP_R 98 0 "> "{TEXT 0 28 
"simplify(subs(result,Eqns));"}}{OUT_R 99 0 98{DAG %2,C=3e3j2x115
0j2x0000p3=3e3j2x1000p6pA=3e3j4x008000000000i2x0010p10=3e3j2x0001
p6p1A=3e3j4x001200000000p15p1F=3e3j3x00010000p6p28=3p6p6=3e3j2x12
00p6p31=3e3j2x8800p6p37=3e3j2x1080p6p3D=3e3j2x7920p6p43}}{INP_R 
100 0 "> "{TEXT 0 0 ""}}}{END}

