{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 0}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 14}{FONT 1 "-adobe-helvetica-bold-r-normal--18-*" "
helvetica" "Courier-Bold" 8 18 128 "Helvetica-Bold" 18}{FONT 2 "-
adobe-helvetica-bold-o-normal--14-*" "helvetica" "Helvetica-BoldO
blique" 8 14 32 "Helvetica-BoldOblique" 14}{SCP_R 1 0 59{COM_R 2 
0{TEXT 1 563 "ENGINEERING APPLICATIONS OF MAPLE V RELEASE 2\015\0
15Circuits 1:  Low pass filter design\015\015(c) Copyright R. Ian
 Adare, Thomas Lee 1992\015\015Sensitive electronic equipment is 
often protect from noisy power supplies\015with the use of a surg
e suppresser and/or a low pass filter.  This type of \015device i
s commonly found in power bars used with a computer and they\015h
elp to remove high frequency noise.  A simple\015filter can be co
nstructed with a resistor and a capacitor.  The following example
\015analyzes a the effects of a low pass filter on a change in si
gnal or power \015frequency."}}{SEP_R 3 0}{COM_R 4 0{TEXT 1 224 "
One approach to the problem is to simplly write out all the equat
ions which\015define the characteristics of the circuit.  These e
quations are based on the \015physical laws governing circuit beh
aviour,  such as Kirchhoff's laws.\012"}}{INP_R 5 0 "> "{TEXT 0 
50 "circ1_eqn1 := Vi1(t) = Vri1(t) + Vr1(t) + Vo1(t);\012"}}
{OUT_R 6 0 5{DAG :3n5\`circ1_eqn1`=3(3n3\`Vi1`,2n3\`t`+7(3n4\`Vri
1`p9j2x0001(3n3\`Vr1`p9p12(3n3\`Vo1`p9p12}}{SEP_R 7 0}{COM_R 8 0
{TEXT 1 126 "Each component in the circuit will have an equation 
which describes its \015operation.  In this circuit there are res
istors and \012"}}{INP_R 9 0 "> "{TEXT 0 72 "circ1_eqn2 := Vri1(t
) = I1(t) * Ri1;\012circ1_eqn3 := Vr1(t) = I1(t) * R1;\012"}}
{OUT_R 10 0 9{DAG :3n5\`circ1_eqn2`=3(3n4\`Vri1`,2n3\`t`*5(3n3\`I
1`pAj2x0001n3\`Ri1`p12}}{OUT_R 11 0 9{DAG :3n5\`circ1_eqn3`=3(3n3
\`Vr1`,2n3\`t`*5(3n3\`I1`p9j2x0001n3\`R1`p11}}{SEP_R 12 0}{COM_R 
13 0{TEXT 1 104 "a single capacitor.  The capcitor is described b
y a special equation known\015as a differential equation.\015 "}}
{INP_R 14 0 "> "{TEXT 0 42 "circ1_eqn4 := I1(t) = C1*diff(Vc1(t),
t);\012\012"}}{OUT_R 15 0 14{DAG :3n5\`circ1_eqn4`=3(3n3\`I1`,2n3
\`t`*5n3\`C1`j2x0001(3n4\`diff`,3(3n3\`Vc1`p9pApF}}{SEP_R 16 0}
{COM_R 17 0{TEXT 1 112 "There are often other equations required 
to describe relationships between\015different components in the 
circuit.\012"}}{INP_R 18 0 "> "{TEXT 0 32 "circ1_eqn5 := Vo1(t) =
 Vc1(t);\012\012"}}{OUT_R 19 0 18{DAG :3n5\`circ1_eqn5`=3(3n3\`Vo
1`,2n3\`t`(3n3\`Vc1`p9}}{SEP_R 20 0}{COM_R 21 0{TEXT 1 84 "The in
put voltage or signal is usually a sinusoidal function at a given
 frequency..\012"}}{INP_R 22 0 "> "{TEXT 0 38 "circ1_eqn6 := Vi1(
t) = A1*sin(w1*t);\012\012"}}{OUT_R 23 0 22{DAG :3n5\`circ1_eqn6`
=3(3n3\`Vi1`,2n3\`t`*5n3\`A1`j2x0001(3n3\`sin`,2*5n3\`w1`pFpApFpF
}}{SEP_R 24 0}{COM_R 25 0{TEXT 1 55 "Before the circuit is switch
ed on the voltage is zero.\015"}}{INP_R 26 0 "> "{TEXT 0 27 "circ
1_eqn7 := Vo1(0) = 0;\012\012"}}{OUT_R 27 0 26{DAG :3n5\`circ1_eq
n7`=3(3n3\`Vo1`,2j2x0000pA}}{SEP_R 28 0}{COM_R 29 0{TEXT 1 193 "A
ll of the equations are combined into a set and solved together.\
015The solution will take a few seconds.  Maple is actually solvi
ng a system\015of 6 equations of which one of them is differentia
l.\015"}}{INP_R 30 0 "> "{TEXT 0 210 "eqn_set := \{circ1_eqn1, ci
rc1_eqn2, circ1_eqn3, circ1_eqn4, circ1_eqn5, circ1_eqn6, circ1_e
qn7\};\012var_set := \{Vi1(t), Vri1(t), Vr1(t), Vo1(t), Vc1(t), I
1(t)\};\012soltn1 := dsolve(eqn_set, var_set);\012assign(soltn1);
\012"}}{OUT_R 31 0 30{DAG :3n4\`eqn_set`%2,8=3(3n3\`Vo1`,2n3\`t`(
3n3\`Vc1`pA=3(3n3\`Vi1`pA*5n3\`A1`j2x0001(3n3\`sin`,2*5n3\`w1`p19
pBp19p19=3(3n3\`I1`pA*5n3\`C1`p19(3n4\`diff`,3pDpBp19=3(3n4\`Vri1
`pA*5p27p19n3\`Ri1`p19=3(3n3\`Vr1`pA*5p27p19n3\`R1`p19=3p12+7p38p
19p44p19p7p19=3(3p8,2j2x0000p5B}}{OUT_R 32 0 30{DAG :3n4\`var_set
`%2,7(3n3\`Vc1`,2n3\`t`(3n3\`Vi1`p9(3n4\`Vri1`p9(3n3\`Vr1`p9(3n3\
`Vo1`p9(3n3\`I1`p9}}{OUT_R 33 0 30{DAG :3n4\`soltn1`%2,7=3(3n3\`V
r1`,2n3\`t`*7+F*D(3n3\`exp`,2*7pBj2x0001n3\`C1`i2x0001+5n3\`Ri1`p
16n3\`R1`p16p1Ap16n3\`A1`p16n3\`w1`p16p18p16(3n3\`cos`,2*5p28p16p
Bp16p16p20p16p16*Fp18j2x0002p10p16p25p16p28p3Cp1Dp16(3n3\`sin`p30
p16p20p16p16*Dp18p3Cp10p16p25p16p28p3Cp20p3Cp46p16p16*7p20p16+5*9
p25p16p28p16p18p16p1Dp16p16*9p25p16p28p16p18p16p20p16p16p16+Dp1Dp
16p20p16*7p28p3Cp18p3Cp1Dj2x0003p16*9p20p16p28p3Cp18p3Cp1Dp3Cp80*
9p28p3Cp18p3Cp1Dp16p20p3Cp80*7p28p3Cp18p3Cp20p80p16p1Ap1A*Dp20p16
p5Fp16p75p1Ap28p3Cp18p3Cp1Dp3Cp1A*Dp5Fp16p75p1Ap28p3Cp18p3Cp1Dp16
p20p3Ci2x0002*Bp5Fp16p75p1Ap28p3Cp18p3Cp20p80p1Ap16(3p11,2+3p14p1
Ap16+9p16p16*7p28p3Cp18p3Cp1Dp3Cp16*9p28p3Cp18p3Cp1Dp16p20p16p3C*
7p28p3Cp18p3Cp20p3Cp16p1A=3(3n3\`I1`pA*7+F*Bp18p16p10p16p25p16p28
p16p2Dp16p16*Dp18p3Cp10p16p25p16p28p3Cp46p16p1Dp16p16*Dp18p3Cp10p
16p25p16p28p3Cp46p16p20p16p16*5p5Fp16p75p1Ap1A*Bp5Fp16p75p1Ap28p3
Cp18p3Cp1Dp3Cp1A*Dp5Fp16p75p1Ap28p3Cp18p3Cp1Dp16p20p16pBC*Bp5Fp16
p75p1Ap28p3Cp18p3Cp20p3Cp1Ap16pCBp16pD2p1A=3(3n3\`Vc1`pA*7+F*Dp10
p16p25p16p28p16p18p16p2Dp16p1Dp16p1ApFp1A*7p25p16p46p16p10p16p16*
7p1Cp16p5Fp16p75p1Ap16*Dp1Cp16p5Fp16p75p1Ap28p3Cp18p3Cp1Dp3Cp16*F
p1Cp16p5Fp16p75p1Ap28p3Cp18p3Cp1Dp16p20p16p3C*Dp1Cp16p5Fp16p75p1A
p28p3Cp18p3Cp20p3Cp16p16pCBp16pD2p1A=3(3n4\`Vri1`pA*7+Fp157p16*Dp
18p3Cp10p16p25p16p28p3Cp1Dp3Cp46p16p16p3Ap16*7p5Fp16p75p1Ap1Dp16p
1A*Bp5Fp16p75p1Ap28p3Cp18p3Cp1Dp80p1ApA1pBCpAFp1Ap16pCBp16pD2p1A=
3(3n3\`Vo1`pAp155=3(3n3\`Vi1`pA*5p25p16p46p16}}{SEP_R 34 0}{COM_R
 35 0{TEXT 1 107 "The effect of the circuit is determined by exam
ining how the input voltage\015compares to the output voltage.\01
5"}}{INP_R 36 0 "> "{TEXT 0 52 "Vi := unapply(Vi1(t),t); \012 Vo 
:= unapply(Vo1(t),t);\012"}}{OUT_R 37 0 36{DAG :3n3\`Vi`@7,2n3\`t
`,1,3n5\`operator`n4\`arrow`p7*5n3\`A1`j2x0001(3n3\`sin`,2*5n3\`w
1`p14a2x0001p14p14p7}}{OUT_R 38 0 36{DAG :3n3\`Vo`@7,2n3\`t`,1,3n
5\`operator`n4\`arrow`p7*7+F*D(3n3\`exp`,2*7a2x0001j2x0001n3\`C1`
i2x0001+5n3\`Ri1`p1Bn3\`R1`p1Bp1Fp1Bn3\`A1`p1Bn3\`w1`p1Bp1Dp1B(3n
3\`cos`,2*5p2Dp1Bp19p1Bp1Bp22p1Bp1F*Dp14p1Bp2Ap1Bp2Dp1Bp1Dp1Bp32p
1Bp25p1Bp1F*7p2Ap1B(3n3\`sin`p35p1Bp14p1Bp1B*7p21p1B+5*9p2Ap1Bp2D
p1Bp1Dp1Bp22p1Bp1B*9p2Ap1Bp2Dp1Bp1Dp1Bp25p1Bp1Bp1B+Dp22p1Bp25p1B*
7p2Dj2x0002p1Dp78p22j2x0003p1B*9p25p1Bp2Dp78p1Dp78p22p78p7D*9p2Dp
78p1Dp78p22p1Bp25p78p7D*7p2Dp78p1Dp78p25p7Dp1Bp1Fp1B*Dp21p1Bp5Bp1
Bp71p1Fp2Dp78p1Dp78p22p78p1B*Fp21p1Bp5Bp1Bp71p1Fp2Dp78p1Dp78p22p1
Bp25p1Bp78*Dp21p1Bp5Bp1Bp71p1Fp2Dp78p1Dp78p25p78p1Bp1B(3p15,2+3p1
8p1Fp1B+9p1Bp1B*7p2Dp78p1Dp78p22p78p1B*9p2Dp78p1Dp78p22p1Bp25p1Bp
78*7p2Dp78p1Dp78p25p78p1Bp1Fp7}}{SEP_R 39 0}{COM_R 40 0{TEXT 1 71
 "Simplify the above expression to make it faster and easier to c
ompute.\015"}}{INP_R 41 0 "> "{TEXT 0 34 "Vo := unapply(simplify(
Vo(t)),t);\012"}}{OUT_R 42 0 41{DAG :3n3\`Vo`@7,2n3\`t`,1,3n5\`op
erator`n4\`arrow`p7+3*9n3\`A1`j2x0001+B*B(3n3\`exp`,2*7a2x0001p15
n3\`C1`i2x0001+5n3\`Ri1`p15n3\`R1`p15p23p15n3\`w1`p15p21p15(3n3\`
cos`,2*5p2Ep15p1Ep15p15p26p15p15*7p2Ep15p21p15p29p15p23*Bp19p15p2
Ep15p21p15p33p15p29p15p15*7p2Ep15p21p15p26p15p23*5p19p15(3n3\`sin
`p36p15p23p15(3p1A,2+3p1Dp23p15+9p15p15*7p2Ej2x0002p21p72p26p72p1
5*9p2Ep72p21p72p26p15p29p15p72*7p2Ep72p21p72p29p72p15p23p23p7}}
{SEP_R 43 0}{COM_R 44 0{TEXT 1 195 "Maple is a powerful program a
nd allows all the computations be performed\015algebraically - wi
th symbols instead of numbers.  This way the solution is general\
015and the numbers can be specified last.\015"}}{INP_R 45 0 "> "
{TEXT 0 53 "Ri1 := 100;\012R1 :=1000;\012C1 := 10*10^(-6);\012A1 
:= 125;\012\012"}}{OUT_R 46 0 45{DAG :3n3\`Ri1`j2x0100}}{OUT_R 47
 0 45{DAG :3n3\`R1`j2x1000}}{OUT_R 48 0 45{DAG :3n3\`C1`/3j2x0001
j3x00100000}}{OUT_R 49 0 45{DAG :3n3\`A1`j2x0125}}{SEP_R 50 0}
{COM_R 51 0{TEXT 1 69 "The output signal can be compare to the in
put signal at 60 Hertz or \012"}}{INP_R 52 0 "> "{TEXT 0 98 "w1 :
= 2*Pi*60;\012plot(\{Vi(t), Vo(t)\},t=0..2/60,title=`input and ou
tput voltage vs. time:  60 Hz`);\012\012"}}{OUT_R 53 0 52{DAG :3n
3\`w1`+3n3\`Pi`j2x0120}}{SEP_R 54 0}{COM_R 55 0{TEXT 1 14 "at 600
 Hertz.\012"}}{INP_R 56 0 "> "{TEXT 0 99 "w1 := 2*Pi*600;\012plot
(\{Vi(t), Vo(t)\},t=0..2/600,title=`input and output voltage vs. 
time: 600 Hz`);\012"}}{OUT_R 57 0 56{DAG :3n3\`w1`+3n3\`Pi`j2x120
0}}{SEP_R 58 0}{COM_R 59 0{TEXT 1 320 "In the above plots note th
e change in the magnitude (size) and \015phase (horizontal positi
on) of the output waves (the smaller waves).\015The amount of cha
nge at various input frequencies characterize a\015particular cir
cuit.  The collection of all of these characteristics for all\015
frequencies is called the frequency response.\015"}}{SEP_R 60 0}}
{END}
