{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "Courier New"
 "Courier New" "Courier" 4 12 192 "Courier" 11}{SCP_R 1 0 122
{COM_R 2 0{TEXT 1 99 "APPROXIMATING ROOTS OF NON-LINEAR EQUATIONS
\015Alastair Rough: ROUGH@MANADON-ENGINEERING-COLLEGE.AC.UK"}}
{COM_R 3 0{TEXT 1 0 ""}}{COM_R 4 0{TEXT 1 3 "AIM"}}{COM_R 5 0
{TEXT 1 93 "The tutorial investigates the following methods of fi
nding the roots of non-linear equations:"}}{COM_R 6 0{TEXT 1 20 "
           Sketching"}}{COM_R 7 0{TEXT 1 27 "           Simple It
eration"}}{COM_R 8 0{TEXT 1 25 "           Newton-Raphson"}}
{COM_R 9 0{TEXT 1 0 ""}}{COM_R 10 0{TEXT 1 0 ""}}{COM_R 11 0{TEXT
 1 50 "EXERCISE 1 - SKETCHING AND SIMPLE ITERATION METHOD"}}
{COM_R 12 0{TEXT 1 0 ""}}{COM_R 13 0{TEXT 1 20 "Assign the functi
on:"}}{INP_R 14 0 "> "{TEXT 0 24 "f:= x-> 2*x - 3 - ln(x);"}}
{COM_R 15 0{TEXT 1 0 ""}}{COM_R 16 0{TEXT 1 18 "Plot the function
:"}}{INP_R 17 0 "> "{TEXT 0 21 "plot(f(x), x = 0..2);"}}{COM_R 18
 0{TEXT 1 211 "There clearly are two zeros of this function in th
is range.  Can you obtain an accurate value of these zeros by usi
ng the sketch alone? The zeros of the function occur at approxima
tely x = 0.0556 and x = 1.7915."}}{COM_R 19 0{TEXT 1 0 ""}}{COM_R
 20 0{TEXT 1 105 "Now confirm these roots using the simple iterat
ion method. The above function f(x) in rearranged form is:"}}
{COM_R 21 0{TEXT 1 70 "x = (ln(x) + 3 )/2.  Assign this value to 
the iteration function g(x):"}}{INP_R 22 0 "> "{TEXT 0 20 "g:=x->
(ln(x) + 3)/2;"}}{COM_R 23 0{TEXT 1 0 ""}}{COM_R 24 0{TEXT 1 48 "
Evaluate the first approximation at x = 1 using:"}}{INP_R 25 0 ">
 "{TEXT 0 12 "evalf(g(1));"}}{INP_R 26 0 "> "{TEXT 0 12 "evalf(g(
\"));"}}{COM_R 27 0{TEXT 1 0 ""}}{COM_R 28 0{TEXT 1 115 "Repeat t
he iteration process with each successive approximation to confir
m x = 1.7915 using expressions similar to:"}}{INP_R 29 0 "> "
{TEXT 0 39 "for n from 1 to 10 do; evalf(g(\")); od;"}}{COM_R 30 
0{TEXT 1 0 ""}}{COM_R 31 0{TEXT 1 109 "The existence of a solutio
n can be displayed by plotting both sides of the iteration expres
sion as y = x and "}}{COM_R 32 0{TEXT 1 18 "y = (ln(x) + 3)/2:"}}
{INP_R 33 0 "> "{TEXT 0 43 "plot(\{x,g(x)\}, x = 0..2, 0..2, styl
e=LINE);"}}{COM_R 34 0{TEXT 1 0 ""}}{COM_R 35 0{TEXT 1 104 "The c
onvergence may be illustrated by drawing line segments using the 
Maple procedure cobweb as follows:"}}{INP_R 36 0 "> "{TEXT 0 55 "
cobweb:=proc(expr,initial,number,left,right,bottom,top)"}}{INP_R 
37 0 "> "{TEXT 0 30 "  local f,t,i,n; global x1,x2;"}}{INP_R 38 0
 "> "{TEXT 0 34 "  f:=expr: x1:=initial: n:=number:"}}{INP_R 39 0
 "> "{TEXT 0 37 "  x2:=subs(x=x1,f):  t:=(x1,0,x1,x2):"}}{INP_R 
40 0 "> "{TEXT 0 25 "     for i from 2 to n do"}}{INP_R 41 0 "> "
{TEXT 0 57 "     x.(i+1):=subs(x=x.i,f):  t:=t,(x.i,x.i,x.i,x.(i+
1)):"}}{INP_R 42 0 "> "{TEXT 0 8 "     od:"}}{INP_R 43 0 "> "
{TEXT 0 34 "print(`Zero at x= `,evalf(x.(i)));"}}{INP_R 44 0 "> "
{TEXT 0 58 "plot(\{[t],x,expr\},x=left..right,y=bottom..top,style
=LINE);"}}{INP_R 45 0 "> "{TEXT 0 4 "end:"}}{INP_R 46 0 "> "{TEXT
 0 0 ""}}{INP_R 47 0 "> "{TEXT 0 26 "cobweb(g(x),1,20,0,2,0,2);"}
}{COM_R 48 0{TEXT 1 0 ""}}{COM_R 49 0{TEXT 1 142 "It is important
 to note that the convergence condition |g'(x)| < 1 is satisfied 
in the vicinity of the root 1.7915. Confirm this is the case. "}}
{INP_R 50 0 "> "{TEXT 0 33 "plot(abs(diff(g(x),x)), x= 1..2);"}}
{COM_R 51 0{TEXT 1 67 "This is a sufficient but not a necessary c
ondition for convergence."}}{COM_R 52 0{TEXT 1 0 ""}}{COM_R 53 0
{TEXT 1 188 "Now repeat this procedure to try to find the other z
ero, by using different values of the first approximation.  You w
ill find that \015the zero cannot be found using this iteration f
unction. "}}{COM_R 54 0{TEXT 1 68 "Try the alternative iteration 
expression x = e^(2x -3), by entering:"}}{INP_R 55 0 "> "{TEXT 0 
22 "g:= x -> exp(2*x - 3);"}}{COM_R 56 0{TEXT 1 179 "Use the firs
t approximation x = 1 and repeat the above steps to confirm x = 0
.0556.  Again the convergence condition  |g'(x)| < 1 is satisfied
 in the vicinity of the second zero. "}}{COM_R 57 0{TEXT 1 0 ""}}
{COM_R 58 0{TEXT 1 55 "The iteration procedure can again be illus
trated using:"}}{INP_R 59 0 "> "{TEXT 0 25 "cobweb(g(x),1,5,0,1,0
,1);"}}{INP_R 60 0 "> "{TEXT 0 33 "plot(abs(diff(g(x),x)), x= 0..
1);"}}{COM_R 61 0{TEXT 1 0 ""}}{COM_R 62 0{TEXT 1 206 "It is impo
rtant that in order to assure that the correct solutions are obta
ined we need to know the general behaviour of the function, perha
ps from the sketch, before applying detailed numerical techniques
."}}{COM_R 63 0{TEXT 1 0 ""}}{COM_R 64 0{TEXT 1 43 "Maple finds z
eros numerically using fsolve:"}}{INP_R 65 0 "> "{TEXT 0 15 "fsol
ve(f(x),x);"}}{COM_R 66 0{TEXT 1 57 "Even Maple needs to know the
 vicinity of the second zero:"}}{INP_R 67 0 "> "{TEXT 0 21 "fsolv
e(f(x),x, 0..1);"}}{COM_R 68 0{TEXT 1 0 ""}}{COM_R 69 0{TEXT 1 0 
""}}{COM_R 70 0{TEXT 1 34 "EXERCISE 2 - NEWTON-RAPHSON METHOD"}}
{COM_R 71 0{TEXT 1 0 ""}}{COM_R 72 0{TEXT 1 31 "Assign the functi
on f(x) to be:"}}{INP_R 73 0 "> "{TEXT 0 25 "f:= x -> exp(x) - si
n(x);"}}{INP_R 74 0 "> "{TEXT 0 32 "plot(f(x), x = -10..2, y=-2..
2);"}}{COM_R 75 0{TEXT 1 210 "\015The Newton raphson method is ba
sed on the following formula for the next value in the interation
: x.(k+1) = x.k - f(x.k)/f'(x.k).  The following procedure comput
es the formula for a given function f(x) in x.\015 "}}{INP_R 76 0
 "> "{TEXT 0 40 "Newton := proc(f,x) x - f/diff(f,x) end;"}}
{COM_R 77 0{TEXT 1 0 ""}}{COM_R 78 0{TEXT 1 54 "Applying the Newt
on routine to f(x) we get the formula"}}{INP_R 79 0 "> "{TEXT 0 
19 "g:= Newton(f(x),x);"}}{INP_R 80 0 "> "{TEXT 0 18 "g := unappl
y(g,x);"}}{COM_R 81 0{TEXT 1 0 ""}}{COM_R 82 0{TEXT 1 76 "Choose 
an initial of x_\{1\} = -5 and then approximate the zero of f(x) 
using:"}}{INP_R 83 0 "> "{TEXT 0 13 "evalf(g(-5));"}}{INP_R 84 0 
"> "{TEXT 0 12 "evalf(g(\"));"}}{COM_R 85 0{TEXT 1 47 "and so on 
to obtain a zero value at x = 9.4249."}}{INP_R 86 0 "> "{TEXT 0 
39 "for n from 1 to 10 do; evalf(g(\")); od;"}}{COM_R 87 0{TEXT 1
 0 ""}}{COM_R 88 0{TEXT 1 118 "Each iteration of the Newton-Raphs
on procedure can  be represented graphically by using in the foll
owing procedure nr."}}{INP_R 89 0 "> "{TEXT 0 49 " nr:=proc(f,ini
tial,number,left,right,bottom,top)"}}{INP_R 90 0 "> "{TEXT 0 18 "
    local t,n,N,g:"}}{INP_R 91 0 "> "{TEXT 0 14 "    N:=number:"}
}{INP_R 92 0 "> "{TEXT 0 12 "    t:=NULL:"}}{INP_R 93 0 "> "{TEXT
 0 50 "    g := unapply(Newton(f(x),x),x); x.1:= initial:"}}
{INP_R 94 0 "> "{TEXT 0 25 "    for n from 1 to N do:"}}{INP_R 95
 0 "> "{TEXT 0 30 "      t:=t,(x.n,0,x.n,f(x.n)):"}}{INP_R 96 0 "
> "{TEXT 0 29 "      x.(n+1):=evalf(g(x.n)):"}}{INP_R 97 0 "> "
{TEXT 0 7 "    od:"}}{INP_R 98 0 "> "{TEXT 0 34 "print(`Zero at x
= `,evalf(x.(n)));"}}{INP_R 99 0 "> "{TEXT 0 60 "plot(\{[t], f(x)
 \}, x= left..right, bottom..top, style=LINE);"}}{INP_R 100 0 "> 
"{TEXT 0 4 "end:"}}{COM_R 101 0{TEXT 1 24 "all the procedure usin
g:"}}{INP_R 102 0 "> "{TEXT 0 30 "nr(f, -4, 5, -6, -0, -1, 1.5);"
}}{COM_R 103 0{TEXT 1 0 ""}}{COM_R 104 0{TEXT 1 146 "Drawing tang
ents to the curve at one approximation of x gives the next approx
imation where this tangent intersects the x axis.  This explains 
why:"}}{COM_R 105 0{TEXT 1 120 "1.  The zero found may not be the
 closest to our starting value. To obtain the adjacent root the i
nitial value needs to "}}{COM_R 106 0{TEXT 1 60 "     be in the v
icinity of the root.  For example choosing: "}}{COM_R 107 0{TEXT 
1 62 "                   x_1 = -6 gives the root at x = -6.2813, 
but"}}{COM_R 108 0{TEXT 1 58 "                   x_1 = -5 gives t
he root at x = -9.4249."}}{INP_R 109 0 "> "{TEXT 0 31 "nr(f, -5, 
5, -12, -0, -1, 1.5);"}}{COM_R 110 0{TEXT 1 0 ""}}{COM_R 111 0
{TEXT 1 105 "2.  The Newton-Raphson method will fail if the initi
al approximation is selected at a stationary point.  "}}{COM_R 
112 0{TEXT 1 61 "      For example try the procedure starting wit
h x_1 = -1.3."}}{INP_R 113 0 "> "{TEXT 0 33 "nr(f, -1.3, 5, -12, 
-0, -1, 1.5);"}}{COM_R 114 0{TEXT 1 0 ""}}{COM_R 115 0{TEXT 1 110
 "Again, therefore, we need to know the general behaviour of the 
function before applying a numerical technique."}}{COM_R 116 0
{TEXT 1 0 ""}}{COM_R 117 0{TEXT 1 0 ""}}{COM_R 118 0{TEXT 1 10 "E
XERCISE 3"}}{COM_R 119 0{TEXT 1 0 ""}}{COM_R 120 0{TEXT 1 109 "Re
peat the Newton-Raphson procedure for V(x) = ln(x) + x^2 - 3.  Pl
ot the function in the ange 0 < x < 2 and "}}{COM_R 121 0{TEXT 1 
123 "-10 < y < 2.  Clearly the intersection lies in the interval 
1 < x < 2.  The single zero is easily calculated as x = 1.5921."}
}{INP_R 122 0 "> "{TEXT 0 0 ""}}{INP_R 123 0 "> "{TEXT 0 0 ""}}}
{END}
