{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 14}{FONT 2 "-*-Courier-m
edium-r-normal--*-120-*-*-m-*-*-*" "Courier" "Courier" 4 12 192 "
Courier" 10}{FONT 3 "-adobe-new century schoolbook-medium-r-norma
l--*-240-*-*-*-*-*-*" "new century schoolbook" "Times-Roman" 4 24
 64 "Times-Roman" 24}{FONT 4 "-adobe-new century schoolbook-mediu
m-r-normal--*-240-*-*-*-*-*-*" "new century schoolbook" "Times-Ro
man" 4 24 64 "Times-Roman" 24}{FONT 5 "-adobe-new century schoolb
ook-medium-r-normal--*-240-*-*-*-*-*-*" "new century schoolbook" 
"Times-Roman" 4 24 64 "Times-Roman" 24}{FONT 6 "-adobe-new centur
y schoolbook-medium-r-normal--*-240-*-*-*-*-*-*" "new century sch
oolbook" "Times-Roman" 4 24 64 "Times-Roman" 24}{FONT 7 "-adobe-n
ew century schoolbook-medium-r-normal--*-240-*-*-*-*-*-*" "new ce
ntury schoolbook" "Times-Roman" 4 24 64 "Times-Roman" 24}{SCP_R 1
 0 172{COM_R 2 0{TEXT 1 58 "Example 3: Dehydrogenation of Benzene
 in a Tubular Reactor"}}{COM_R 3 0{TEXT 1 0 ""}}{COM_R 4 0{TEXT 1
 138 "In this example we consider the dehydrogenation of benzene \+
in a tubular reactor.  The example is adapted from Example 4-7 in
 Smith (1981)."}}{INP_R 5 0 "> "{TEXT 0 51 "restart; interface(la
belling=false): printlevel:=2:"}}{COM_R 6 0{TEXT 1 0 ""}}{COM_R 7
 0{TEXT 1 164 "\" Hougen and Watson, in an analysis of Kassell's \+
data for the homogeneous, vapor-phase dehydrogenation of benzene \+
in a tubular-flow reactor considered two reactions"}}{COM_R 8 0
{TEXT 1 0 ""}}{COM_R 9 0{TEXT 1 28 "    1.  2 C6H6 = C12H10 + H2"
}}{COM_R 10 0{TEXT 1 35 "    2.  C6H6 + C12H10 = C18H14 + H2"}}
{COM_R 11 0{TEXT 1 0 ""}}{COM_R 12 0{TEXT 1 77 "...design a tubul
ar reactor which will operate at 1 atm pressure and 1400 F.\""}}
{COM_R 13 0{TEXT 1 0 ""}}{COM_R 14 0{TEXT 1 150 "We begin by crea
ting a list of component identities.  Here we use abbreviations t
o denote each component.   The number of components also is compu
ted."}}{COM_R 15 0{TEXT 1 0 ""}}{INP_R 16 0 "> "{TEXT 0 47 "compo
nents:=[B,DP,TP,H2]; nc:=nops(components);"}}{OUT_R 17 0 16{DAG :
3n5\`components`[2,5n3\`B`n3\`DP`n3\`TP`n3\`H2`}}{OUT_R 18 0 16
{DAG :3n3\`nc`j2x0004}}{COM_R 19 0{TEXT 1 85 "where the letters r
efer, respectively, to Benzene, DiPhenyl, TriPhenyl, and Hydrogen
."}}{COM_R 20 0{TEXT 1 0 ""}}{COM_R 21 0{TEXT 1 37 "Next, we iden
tify a set of reactions:"}}{INP_R 22 0 "> "{TEXT 0 19 "Reactions:
=[R1,R2];"}}{OUT_R 23 0 22{DAG :3n5\`Reactions`[2,3n3\`R1`n3\`R2`
}}{COM_R 24 0{TEXT 1 50 "The reactions may be expressed as Maple \+
equations:"}}{INP_R 25 0 "> "{TEXT 0 24 "Reaction[R1]:=2*B=DP+H2;
"}}{OUT_R 26 0 25{DAG :3b3n5\`Reaction`,2n3\`R1`=3+3n3\`B`j2x0002
+5n3\`DP`j2x0001n3\`H2`p12}}{INP_R 27 0 "> "{TEXT 0 25 "Reaction[
R2]:=B+DP=TP+H2;"}}{OUT_R 28 0 27{DAG :3b3n5\`Reaction`,2n3\`R2`=
3+5n3\`B`j2x0001n3\`DP`pD+5n3\`TP`pDn3\`H2`pD}}{COM_R 29 0{TEXT 1
 83 "The stoichiometric cofficients can be deduced from the set o
f reactions as follows:"}}{INP_R 30 0 "> "{TEXT 0 22 "for r in Re
actions do "}}{INP_R 31 0 "> "{TEXT 0 26 "   for i in components \+
do "}}{INP_R 32 0 "> "{TEXT 0 58 "     nu[i,r]:=coeff(lhs(Reactio
n[r])-rhs(Reaction[r]),i); "}}{INP_R 33 0 "> "{TEXT 0 7 "od; od;"
}}{OUT_R 34 0 33{DAG :3b3n3\`nu`,3n3\`B`n3\`R1`j2x0002}}{OUT_R 35
 0 33{DAG :3b3n3\`nu`,3n3\`DP`n3\`R1`i2x0001}}{OUT_R 36 0 33{DAG 
:3b3n3\`nu`,3n3\`TP`n3\`R1`j2x0000}}{OUT_R 37 0 33{DAG :3b3n3\`nu
`,3n3\`H2`n3\`R1`i2x0001}}{OUT_R 38 0 33{DAG :3b3n3\`nu`,3n3\`B`n
3\`R2`j2x0001}}{OUT_R 39 0 33{DAG :3b3n3\`nu`,3n3\`DP`n3\`R2`j2x0
001}}{OUT_R 40 0 33{DAG :3b3n3\`nu`,3n3\`TP`n3\`R2`i2x0001}}
{OUT_R 41 0 33{DAG :3b3n3\`nu`,3n3\`H2`n3\`R2`i2x0001}}{COM_R 42 
0{TEXT 1 76 "The material balances for a tubular flow reactor may
 be expressed as follows"}}{INP_R 43 0 "> "{TEXT 0 76 "for i in c
omponents do CMB[i] := Diff(F*x[i],z)=-R[i]*A;  print(CMB[i]); od
:"}}{OUT_R 44 0 43{DAG =3(3n4\`Diff`,3*5n3\`F`j2x0001b3n3\`x`,2n3
\`B`p9n3\`z`+3*5b3n3\`R`pEp9n3\`A`p9i2x0001}}{OUT_R 45 0 43{DAG =
3(3n4\`Diff`,3*5n3\`F`j2x0001b3n3\`x`,2n3\`DP`p9n3\`z`+3*5b3n3\`R
`pEp9n3\`A`p9i2x0001}}{OUT_R 46 0 43{DAG =3(3n4\`Diff`,3*5n3\`F`j
2x0001b3n3\`x`,2n3\`TP`p9n3\`z`+3*5b3n3\`R`pEp9n3\`A`p9i2x0001}}
{OUT_R 47 0 43{DAG =3(3n4\`Diff`,3*5n3\`F`j2x0001b3n3\`x`,2n3\`H2
`p9n3\`z`+3*5b3n3\`R`pEp9n3\`A`p9i2x0001}}{COM_R 48 0{TEXT 1 105 
"The rate of reaction of each component may be expressed in terms
 of the rate of each reaction as follows:"}}{INP_R 49 0 "> "{TEXT
 0 22 "for i in components do"}}{INP_R 50 0 "> "{TEXT 0 62 "   R[
i]:=convert([seq(nu[i,r]/nu[B,r]*R[r],r=Reactions)],`+`);"}}
{INP_R 51 0 "> "{TEXT 0 4 "od; "}}{OUT_R 52 0 51{DAG :3b3n3\`R`,2
n3\`B`+5b3p2,2n3\`R1`j2x0001b3p2,2n3\`R2`pD}}{OUT_R 53 0 51{DAG :
3b3n3\`R`,2n3\`DP`+5b3p2,2n3\`R1`/3i2x0001j2x0002b3p2,2n3\`R2`j2x
0001}}{OUT_R 54 0 51{DAG :3b3n3\`R`,2n3\`TP`+3b3p2,2n3\`R2`i2x000
1}}{OUT_R 55 0 51{DAG :3b3n3\`R`,2n3\`H2`+5b3p2,2n3\`R1`/3i2x0001
j2x0002b3p2,2n3\`R2`pE}}{COM_R 56 0{TEXT 1 95 "where R[R1] and R[
R2] are the rates of reaction of benzene in reactions R1 and R2 r
espectively."}}{COM_R 57 0{TEXT 1 0 ""}}{COM_R 58 0{TEXT 1 85 "Th
e total material balance may be obtained by summing the component
 material balances"}}{INP_R 59 0 "> "{TEXT 0 86 "TMB:=Diff(F,z)=c
onvert([seq(rhs(CMB[i]),i=components)],`+`): TMB:=collect(TMB,A):
 TMB;"}}{OUT_R 60 0 59{DAG =3(3n4\`Diff`,3n3\`F`n3\`z`j2x0000}}
{COM_R 61 0{TEXT 1 134 "showing that the total molar flow is cons
tant (as it should be since numbers of moles are conserved by the
 reactions in this example)."}}{COM_R 62 0{TEXT 1 0 ""}}{COM_R 63
 0{TEXT 1 583 "The next step is to express the component material
 balances in terms of the mole fraction derivatives rather than t
he component flow derivatives.  The following Maple construction \+
does this for us by replacing the partial derivative operator by \+
the D operator in order to apply the chain rule for thedifferenti
ation of a product.  The derivative of the total molar flow is el
iminated using the total material balance.  In this example the r
esulting expressions are quite simple because the total flow is c
onstant; however, the construction given here works when that is \+
not the case."}}{INP_R 64 0 "> "{TEXT 0 22 "for i in components d
o"}}{INP_R 65 0 "> "{TEXT 0 41 "  t2:=subs(lhs(CMB[i])=D(F*x[i]),
CMB[i]):"}}{INP_R 66 0 "> "{TEXT 0 28 "  D(x[i])=solve(t2,D(x[i])
):"}}{INP_R 67 0 "> "{TEXT 0 56 "  CMB[i]:=subs(\{D(F)=Diff(F,z),
D(x[i])=Diff(x[i],z)\},\");"}}{INP_R 68 0 "> "{TEXT 0 28 "  CMB[i
]:=subs(TMB,CMB[i]); "}}{INP_R 69 0 "> "{TEXT 0 56 "  CMB[i]:=col
lect(CMB[i],[A,P,F,seq(k[r],r=Reactions)]);"}}{INP_R 70 0 "> "
{TEXT 0 17 "  print (CMB[i]);"}}{INP_R 71 0 "> "{TEXT 0 3 "od:"}}
{OUT_R 72 0 71{DAG =3(3n4\`Diff`,3b3n3\`x`,2n3\`B`n3\`z`*7+5b3n3\
`R`,2n3\`R1`i2x0001b3p11,2n3\`R2`p16j2x0001n3\`F`p16n3\`A`p1E}}
{OUT_R 73 0 71{DAG =3(3n4\`Diff`,3b3n3\`x`,2n3\`DP`n3\`z`*7+5b3n3
\`R`,2n3\`R1`/3j2x0001j2x0002b3p11,2n3\`R2`i2x0001p17n3\`F`p20n3\
`A`p17}}{OUT_R 74 0 71{DAG =3(3n4\`Diff`,3b3n3\`x`,2n3\`TP`n3\`z`
*7b3n3\`R`,2n3\`R2`j2x0001n3\`A`p15n3\`F`i2x0001}}{OUT_R 75 0 71
{DAG =3(3n4\`Diff`,3b3n3\`x`,2n3\`H2`n3\`z`*7+5b3n3\`R`,2n3\`R1`/
3j2x0001j2x0002b3p11,2n3\`R2`p17p17n3\`F`i2x0001n3\`A`p17}}{COM_R
 76 0{TEXT 1 242 "To design a tubular reactor at constant tempera
ture and pressure we must integrate these equations as a function
 of tube length.  The rates of reaction are given in terms of the
 partial pressures of the reactants and products by (Smith, 1981)
"}}{INP_R 77 0 "> "{TEXT 0 40 "R[R1]:=k[R1]*(p[B]^2-p[DP]*p[H2]/K
[R1]);"}}{OUT_R 78 0 77{DAG :3b3n3\`R`,2n3\`R1`*5b3n3\`k`p4j2x000
1+5*3b3n3\`p`,2n3\`B`j2x0002pC*7b3p11,2n3\`DP`pCb3p11,2n3\`H2`pCb
3n3\`K`p4i2x0001p2ApC}}{INP_R 79 0 "> "{TEXT 0 44 "R[R2]:=k[R2]*(
p[B]*p[DP]-p[TP]*p[H2]/K[R2]);"}}{OUT_R 80 0 79{DAG :3b3n3\`R`,2n
3\`R2`*5b3n3\`k`p4j2x0001+5*5b3n3\`p`,2n3\`B`pCb3p11,2n3\`DP`pCpC
*7b3p11,2n3\`TP`pCb3p11,2n3\`H2`pCb3n3\`K`p4i2x0001p2FpC}}{COM_R 
81 0{TEXT 1 79 "The next step is to replace the partial pressures
 by mole fractions as follows:"}}{INP_R 82 0 "> "{TEXT 0 22 "for \+
r in Reactions do "}}{INP_R 83 0 "> "{TEXT 0 24 "  for i in compo
nents do"}}{INP_R 84 0 "> "{TEXT 0 32 "   R[r]:=subs(p[i]=P*x[i],
R[r]);"}}{INP_R 85 0 "> "{TEXT 0 4 "od; "}}{INP_R 86 0 "> "{TEXT 
0 12 "print(R[r]);"}}{INP_R 87 0 "> "{TEXT 0 3 "od:"}}{OUT_R 88 0
 87{DAG *5b3n3\`k`,2n3\`R1`j2x0001+5*5n3\`P`j2x0002b3n3\`x`,2n3\`
B`pDp7*9pBpDb3p10,2n3\`DP`p7b3p10,2n3\`H2`p7b3n3\`K`p4i2x0001p2Ap
7}}{OUT_R 89 0 87{DAG *5b3n3\`k`,2n3\`R2`j2x0001+5*7n3\`P`j2x0002
b3n3\`x`,2n3\`B`p7b3p10,2n3\`DP`p7p7*9pBpDb3p10,2n3\`TP`p7b3p10,2
n3\`H2`p7b3n3\`K`p4i2x0001p30p7}}{COM_R 90 0{TEXT 1 67 "The forwa
rd reaction rate coefficients are as follows (Smith, 1981)"}}
{INP_R 91 0 "> "{TEXT 0 29 "k[R1]:=14.96e6*exp(-15200/T);"}}
{OUT_R 92 0 91{DAG :3b3n3\`k`,2n3\`R1`+3(3n3\`exp`,2+3*3n3\`T`i2x
0001i3x00015200e3j2x1496j2x0004}}{INP_R 93 0 "> "{TEXT 0 28 "k[R2
]:=8.67e6*exp(-15200/T);"}}{OUT_R 94 0 93{DAG :3b3n3\`k`,2n3\`R2`
+3(3n3\`exp`,2+3*3n3\`T`i2x0001i3x00015200e3j2x0867j2x0004}}
{COM_R 95 0{TEXT 1 42 "The equilibrium coefficients at 1400 F are
"}}{INP_R 96 0 "> "{TEXT 0 26 "K[R1]:=0.312; K[R2]:=0.48;"}}
{OUT_R 97 0 96{DAG :3b3n3\`K`,2n3\`R1`e3j2x0312i2x0003}}{OUT_R 98
 0 96{DAG :3b3n3\`K`,2n3\`R2`e3j2x0048i2x0002}}{COM_R 99 0{TEXT 1
 208 "These expressions give the reaction rates in lb moles benze
ne reacted per hour per cubic foot with T in Kelvin and P in atmo
spheres.  The desired reactor temperature and pressure are specif
ied in these units "}}{INP_R 100 0 "> "{TEXT 0 27 "T:=(1400+459.6
9)/1.8; P:=1;"}}{OUT_R 101 0 100{DAG :3n3\`T`e3j4x001033161111i2x
0006}}{OUT_R 102 0 100{DAG :3n3\`P`j2x0001}}{COM_R 103 0{TEXT 1 
84 "The cross sectional area of a tube may be expressed in terms \+
of the tube diameter as"}}{INP_R 104 0 "> "{TEXT 0 12 "A:=Pi*d^2/
4;"}}{OUT_R 105 0 104{DAG :3n3\`A`+3*5n3\`Pi`j2x0001n3\`d`j2x0002
/3p7j2x0004}}{COM_R 106 0{TEXT 1 116 "We will carry out the integ
ration of the material balance equations for a tube diameter of 1
 inches and length 8 ft."}}{INP_R 107 0 "> "{TEXT 0 18 "d:=1.0/12
; L:=8.0;"}}{OUT_R 108 0 107{DAG :3n3\`d`e3j4x008333333333i2x0011
}}{OUT_R 109 0 107{DAG :3n3\`L`e3j2x0080i2x0001}}{COM_R 110 0
{TEXT 1 205 "We shall use the 4th order Runge Kutta method from t
he Maple Share Library to integrate the differential material bal
ance equations.  The package can be accessed only after reading i
n the appropriate file:"}}{INP_R 111 0 "> "{TEXT 0 34 "with(share
); readshare(ODE,plots);"}}{OUT_R 112 0 111{TEXT 2 71 "See ?share
 and ?share,contents for information about the share library\012"
}}{OUT_R 113 0 111{DAG [2,1}}{OUT_R 114 0 111{DAG n14\`See~`?dire
ctionfield,~`?phaseplot,~`?impeuler,~`?rungekutta,~`?rungekuttahf
`}}{COM_R 115 0{TEXT 1 176 "The procedure rungekutta in this libr
ary package requires the differential equations to be passed as a
 list of Maple functions which are created here using the unapply
 command."}}{INP_R 116 0 "> "{TEXT 0 22 "for i in components do"}
}{INP_R 117 0 "> "{TEXT 0 57 "   de.i:=unapply(rhs(CMB[i]),z,seq(
x[i],i=components),F);"}}{INP_R 118 0 "> "{TEXT 0 3 "od;"}}{OUT_R
 119 0 118{DAG :3n3\`deB`@8,7n3\`y1`n3\`y2`n3\`y3`n3\`y4`n3\`y5`n
3\`y6`,1,3n5\`operator`n4\`arrow`p11+3*7+9*3a2x0002j2x0002e3i4x00
6102881829i2x0009*5a2x0003j2x0001a2x0005p2De3j4x001956051868i2x00
08*5p1Fp2Dp2Bp2De3i4x003536897423p28*5a2x0004p2Dp2Fp2De3j4x007368
536297p28p2Da2x0006i2x0001n3\`Pi`p2De3j4x001736111111i2x0012p11p1
1}}{OUT_R 120 0 118{DAG :3n4\`deDP`@8,7n3\`y1`n3\`y2`n3\`y3`n3\`y
4`n3\`y5`n3\`y6`,1,3n5\`operator`n4\`arrow`p12+3*7+9*3a2x0002j2x0
002e3j4x003051440915i2x0009*5a2x0003j2x0001a2x0005p2Ee3i4x0097802
59340p29*5p20p2Ep2Cp2Ee3i4x003536897423p29*5a2x0004p2Ep30p2Ee3j4x
007368536297p29p2Ea2x0006i2x0001n3\`Pi`p2Ee3j4x001736111111i2x001
2p12p12}}{OUT_R 121 0 118{DAG :3n4\`deTP`@8,7n3\`y1`n3\`y2`n3\`y3
`n3\`y4`n3\`y5`n3\`y6`,1,3n5\`operator`n4\`arrow`p12+3*7+5*5a2x00
02j2x0001a2x0003p22e3j4x003536897423i2x0009*5a2x0004p22a2x0005p22
e3i4x007368536297p2Cp22n3\`Pi`p22a2x0006i2x0001e3j4x001736111111i
2x0012p12p12}}{OUT_R 122 0 118{DAG :3n4\`deH2`@8,7n3\`y1`n3\`y2`n
3\`y3`n3\`y4`n3\`y5`n3\`y6`,1,3n5\`operator`n4\`arrow`p12+3*7+9*3
a2x0002j2x0002e3j4x003051440915i2x0009*5a2x0003j2x0001a2x0005p2Ee
3i4x009780259340p29*5p20p2Ep2Cp2Ee3j4x003536897423p29*5a2x0004p2E
p30p2Ee3i4x007368536297p29p2Ea2x0006i2x0001n3\`Pi`p2Ee3j4x0017361
11111i2x0012p12p12}}{INP_R 123 0 "> "{TEXT 0 51 "de.F:=unapply(rh
s(TMB),z,seq(x[i],i=components),F);"}}{OUT_R 124 0 123{DAG :3n3\`
deF`j2x0000}}{COM_R 125 0{TEXT 1 84 "The feed to the reactor is p
ure benzene at a flow rate of 0.05 lb moles/hr per tube."}}{INP_R
 126 0 "> "{TEXT 0 48 "Feedflow := 0.05; FeedComp:= 1.0, 0.0, 0.0
, 0.0;"}}{OUT_R 127 0 126{DAG :3n5\`Feedflow`e3j2x0005i2x0002}}
{OUT_R 128 0 126{DAG :3n5\`FeedComp`,5e3j2x0010i2x0001j2x0000pBpB
}}{COM_R 129 0{TEXT 1 170 "We create a list of  initial condition
s containing the length at the start of the reactor (z=0), the mo
le fractions of each component and the molar flow rate in the fee
d."}}{INP_R 130 0 "> "{TEXT 0 34 "StartPoint:=[0,FeedComp,Feedflo
w];"}}{OUT_R 131 0 130{DAG :3n5\`StartPoint`[2,7j2x0000e3j2x0010i
2x0001p7p7p7e3j2x0005i2x0002}}{COM_R 132 0{TEXT 1 59 "We will use
 100 points to integrate over the reactor length"}}{INP_R 133 0 "
> "{TEXT 0 32 "numpts:=100; stepsize:=L/numpts;"}}{OUT_R 134 0 
133{DAG :3n4\`numpts`j2x0100}}{OUT_R 135 0 133{DAG :3n5\`stepsize
`e3j4x008000000000i2x0011}}{COM_R 136 0{TEXT 1 94 "We now call th
e integrator (but suppress the output which is a large array of n
umerical data)."}}{INP_R 137 0 "> "{TEXT 0 76 "rkpts:=rungekutta(
[seq(de.i,i=components),de.F],StartPoint,stepsize,numpts):"}}
{COM_R 138 0{TEXT 1 93 "The output is stored as an array of lists
, the first and last lines of which are shown below."}}{INP_R 139
 0 "> "{TEXT 0 9 "rkpts[1];"}}{OUT_R 140 0 139{DAG [2,7e3j4x00800
0000000i2x0011e3j4x009491053109i2x0010e3j4x002487857257p7e3j4x003
791813111i2x0013e3j4x002563693521p7e3j2x0005i2x0002}}{INP_R 141 0
 "> "{TEXT 0 14 "rkpts[numpts];"}}{OUT_R 142 0 141{DAG [2,7e3j4x0
08000000000i2x0009e3j4x004136273164i2x0010e3j4x001580834087pEe3j4
x009006862198i2x0011e3j4x003382206529pEe3j2x0005i2x0002}}{COM_R 
143 0{TEXT 1 183 "Each list contains, in order, the distance from
 the entrance of the reactor, the mole fractions of benzene, diph
enyl, triphenyl, and hydrogen, and the total molar flow of the mi
xture."}}{COM_R 144 0{TEXT 1 0 ""}}{COM_R 145 0{TEXT 1 284 "The r
esults are more easily understood by plotting the composition pro
files. To do this we make use of the procedure makelist which is \+
part of the package read in above.  Makelist creates a set of poi
nts from the output from the integrator that can be plotted by Ma
ple's plot command."}}{INP_R 146 0 "> "{TEXT 0 55 "plot(\{seq(mak
elist(rkpts,1,i),i=[2,3,4,5])\},color=RED);"}}{COM_R 147 0{TEXT 1
 0 ""}}{COM_R 148 0{TEXT 1 257 "It is clear from this graph that \+
the mole fractions have reached their equilibrium values.  The fi
nal equilibrium composition is given in the last line of data in \+
the results array (here reprinted so that we can identify the com
ponents in the above figure)."}}{INP_R 149 0 "> "{TEXT 0 65 "for \+
i from 1 to nc do x[components[i],eq]=rkpts[numpts][1+i]; od;"}}
{OUT_R 150 0 149{DAG =3b3n3\`x`,3n3\`B`n3\`eq`e3j4x004136273164i2
x0010}}{OUT_R 151 0 149{DAG =3b3n3\`x`,3n3\`DP`n3\`eq`e3j4x001580
834087i2x0010}}{OUT_R 152 0 149{DAG =3b3n3\`x`,3n3\`TP`n3\`eq`e3j
4x009006862198i2x0011}}{OUT_R 153 0 149{DAG =3b3n3\`x`,3n3\`H2`n3
\`eq`e3j4x003382206529i2x0010}}{COM_R 154 0{TEXT 1 101 "and it is
 pleasant to note that these numbers are in agreement with those \+
calculated by Smith (1981)."}}{COM_R 155 0{TEXT 1 0 ""}}{COM_R 
156 0{TEXT 1 139 "Finally, we wish to see how the rate of reactio
n changed along the length of the reactor.  We make functions of \+
the reaction rate equations"}}{INP_R 157 0 "> "{TEXT 0 43 "fr1:=u
napply(R[R1],seq(x[i],i=components));"}}{OUT_R 158 0 157{DAG :3n3
\`fr1`@8,5n3\`y1`n3\`y2`n3\`y3`n3\`y4`,1,3n5\`operator`n4\`arrow`
pD+5*3a2x0001j2x0002e3j4x006102881829i2x0009*5a2x0002j2x0001a2x00
04p27e3i4x001956051868i2x0008pDpD}}{INP_R 159 0 "> "{TEXT 0 43 "f
r2:=unapply(R[R2],seq(x[i],i=components));"}}{OUT_R 160 0 159{DAG
 :3n3\`fr2`@8,5n3\`y1`n3\`y2`n3\`y3`n3\`y4`,1,3n5\`operator`n4\`a
rrow`pD+5*5a2x0001j2x0001a2x0002p1Be3j4x003536897423i2x0009*5a2x0
003p1Ba2x0004p1Be3i4x007368536297p25pDpD}}{COM_R 161 0{TEXT 1 104
 "and create a set of points for each reaction rate evaluated at \+
each incremental position in the reactor."}}{INP_R 162 0 "> "
{TEXT 0 26 "for i from 1 to numpts do "}}{INP_R 163 0 "> "{TEXT 0
 58 "  R1pts[i] := [rkpts[i][1],fr1(seq(rkpts[i][j],j=2..5))]; "}
}{INP_R 164 0 "> "{TEXT 0 58 "  R2pts[i] := [rkpts[i][1],fr2(seq(
rkpts[i][j],j=2..5))]; "}}{INP_R 165 0 "> "{TEXT 0 3 "od:"}}
{INP_R 166 0 "> "{TEXT 0 31 "plot([seq(R1pts[i],i=1..100)]);"}}
{COM_R 167 0{TEXT 1 0 ""}}{INP_R 168 0 "> "{TEXT 0 31 "plot([seq(
R2pts[i],i=1..100)]);"}}{COM_R 169 0{TEXT 1 0 ""}}{COM_R 170 0
{TEXT 1 196 "Here we see that the rate of reaction 1 falls contin
uously to its equilibrium value whereas the rate of reaction 2 ri
ses at first, passes through a maximum before falling to its equi
librium value."}}{COM_R 171 0{TEXT 1 0 ""}}{COM_R 172 0{TEXT 1 
181 "It would now be a simple matter to investigate the effects o
f alternative reactor designs (tube length and diameter) or opera
ting conditions (feed flow rate, temperature, pressure)."}}{INP_R
 173 0 "> "{TEXT 0 0 ""}}}{END}
