{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "Courier New"
 "Courier New" "Courier" 4 12 192 "Courier" 10}{SCP_R 1 0 92
{COM_R 2 0{TEXT 1 96 "POTENTIAL FIELDS USING GREEN'S FUNCTIONS\01
5Alastair Rough: ROUGH@MANADON-ENGINEERING-COLLEGE.AC.UK"}}{COM_R
 3 0{TEXT 1 0 ""}}{COM_R 4 0{TEXT 1 363 "Green's functions can be
 used to calculate the solution of Laplace's equation in two dime
nsions.  The solution method can be simplified for each of two se
ts of boundary conditions which define the external Neumann and D
irichlet problems.  Assuming the conductivity of the electrolyte 
is sigma = 1, the Green's function in two dimensions in an unboun
ded region is:"}}{INP_R 5 0 "> "{TEXT 0 48 "G := 1/(2*Pi)*ln(sqrt
((x - x0)^2 + (y - y0)^2));"}}{COM_R 6 0{TEXT 1 0 ""}}{COM_R 7 0
{TEXT 1 86 "It is important to note that the function G has a sin
gularity at the point x=x0, y=y0."}}{COM_R 8 0{TEXT 1 0 ""}}
{COM_R 9 0{TEXT 1 16 "NEUMANN PROBLEM "}}{COM_R 10 0{TEXT 1 0 ""}
}{COM_R 11 0{TEXT 1 212 "The Neumann problem is characterised by 
the definition of the boundary condition in terms of current dens
ity.  The potential at a point (x,y) due to unit current density 
on the boundary (x0,0) is evaluated using:"}}{INP_R 12 0 "> "
{TEXT 0 36 " v_n:= int(subs(y0=0,G), x0 = a..b);"}}{COM_R 13 0
{TEXT 1 0 ""}}{COM_R 14 0{TEXT 1 10 "EXAMPLE 1."}}{COM_R 15 0
{TEXT 1 0 ""}}{COM_R 16 0{TEXT 1 44 "For a single line electrode 
from a=5 to b=6:"}}{INP_R 17 0 "> "{TEXT 0 62 " plot3d(subs(\{a=5
,b=6\},v_n), x=0..10, y= -10..10, axes=BOXED);"}}{COM_R 18 0{TEXT
 1 0 ""}}{COM_R 19 0{TEXT 1 26 "To see potential contours:"}}
{INP_R 20 0 "> "{TEXT 0 12 "with(plots):"}}{INP_R 21 0 "> "{TEXT 
0 67 "contourplot(subs(\{a=5,b=6\},v_n), x=0..10, y= -10..10, axe
s=NORMAL);"}}{COM_R 22 0{TEXT 1 0 ""}}{COM_R 23 0{TEXT 1 44 "The 
current density can be calculated using:"}}{INP_R 24 0 "> "{TEXT 
0 13 "with(linalg):"}}{INP_R 25 0 "> "{TEXT 0 29 "j_n:= -sigma*Gr
ad(v_n,[x,y]);"}}{COM_R 26 0{TEXT 1 22 "which is performed as:"}}
{INP_R 27 0 "> "{TEXT 0 9 "sigma:=1;"}}{INP_R 28 0 "> "{TEXT 0 42
 "j_n:= scalarmul( grad(v_n,[x,y]), -sigma);"}}{COM_R 29 0{TEXT 1
 0 ""}}{COM_R 30 0{TEXT 1 29 "To see lines of current flow:"}}
{INP_R 31 0 "> "{TEXT 0 96 "fieldplot( [subs(\{a=5,b=6\}, j_n[1])
, subs(\{a=5,b=6\}, j_n[2] )], x=4..7, y= 0.1..1, arrows=SLIM);"}
}{COM_R 32 0{TEXT 1 0 ""}}{COM_R 33 0{TEXT 1 62 "The magnitude of
 current density is calculated and plotted as:"}}{INP_R 34 0 "> "
{TEXT 0 17 "J_n:=norm(j_n,2):"}}{INP_R 35 0 "> "{TEXT 0 63 "conto
urplot(subs(\{a=5,b=6\},J_n), x=5..8, y= 0..2, axes=NORMAL);"}}
{COM_R 36 0{TEXT 1 0 ""}}{COM_R 37 0{TEXT 1 10 "EXAMPLE 2."}}
{COM_R 38 0{TEXT 1 0 ""}}{COM_R 39 0{TEXT 1 60 "Determine the pot
ential field arising from three electrodes:"}}{COM_R 40 0{TEXT 1 
67 "     * an anode at 5 <  x0 <  6 emitting current density g(x0
) = 3;"}}{COM_R 41 0{TEXT 1 93 "     * cathodes at  3 <  x0 < 5 a
nd 6 < x0 < 8 each emitting unit current density g(x0) = -1."}}
{COM_R 42 0{TEXT 1 17 "The potential is:"}}{INP_R 43 0 "> "{TEXT 
0 78 " v[elec] := 3*subs(\{a=5,b=6\},v_n) - subs(\{a=3,b=5\},v_n)
 - subs(\{a=6,b=8\},v_n):"}}{INP_R 44 0 "> "{TEXT 0 49 " plot3d(v
[elec], x=0..10, y=-10..10, axes=BOXED);"}}{COM_R 45 0{TEXT 1 0 "
"}}{COM_R 46 0{TEXT 1 0 ""}}{COM_R 47 0{TEXT 1 17 "DIRICHLET PROB
LEM"}}{COM_R 48 0{TEXT 1 0 ""}}{COM_R 49 0{TEXT 1 202 "The Dirich
let problem is characterised by the definition of the boundary co
ndition in terms of potential.  The potential at a point (x,y) du
e to unit potential on the boundary (x0,0) is evaluated using:"}}
{INP_R 50 0 "> "{TEXT 0 48 " v[d] := -int(subs(y0=0,diff(G,y0)), 
x0 = a..b);"}}{COM_R 51 0{TEXT 1 0 ""}}{COM_R 52 0{TEXT 1 10 "EXA
MPLE 3."}}{COM_R 53 0{TEXT 1 0 ""}}{COM_R 54 0{TEXT 1 133 "Calcul
ate the potential distribution surrounding a line electrode  5 < 
x0 < 6, y0=0 with the Dirichlet boundary conditions h(x0) = 1:"}}
{INP_R 55 0 "> "{TEXT 0 63 " plot3d(subs(\{a=5,b=6\},v[d]), x=0..
10, y= -10..10, axes=BOXED);"}}{COM_R 56 0{TEXT 1 0 ""}}{COM_R 57
 0{TEXT 1 209 "This plot shows an anomalous inversion of potentia
l through the y axis due to the reversal of direction of the outw
ard normal to the electrode.  A method of overcoming this anomaly
 is used in examples 4 and 5."}}{COM_R 58 0{TEXT 1 0 ""}}{COM_R 
59 0{TEXT 1 51 "EXAMPLE 4: FIELD SURROUNDING A STRAIGHT LINE CHAR
GE"}}{COM_R 60 0{TEXT 1 0 ""}}{COM_R 61 0{TEXT 1 131 "Consider a 
straight line segment of charge at uniform unit potential at a po
sition 5< x0 < 6 potential field at any point (x,y) is:"}}{INP_R 
62 0 "> "{TEXT 0 40 "v[line] := - int(1*diff(G,y0), x0=5..6);"}}
{COM_R 63 0{TEXT 1 0 ""}}{COM_R 64 0{TEXT 1 47 "Given that the co
nductor lies on the line y0=0:"}}{INP_R 65 0 "> "{TEXT 0 30 "v[li
ne]:= subs(y0=0, v[line]):"}}{COM_R 66 0{TEXT 1 0 ""}}{COM_R 67 0
{TEXT 1 79 "Since the outward normal to the line segment reverses
 direction for negative y:"}}{INP_R 68 0 "> "{TEXT 0 28 "v[line]:
= signum(y)*v[line];"}}{COM_R 69 0{TEXT 1 0 ""}}{COM_R 70 0{TEXT 
1 28 "Now plot the field contours:"}}{INP_R 71 0 "> "{TEXT 0 51 "
contourplot(v[line], x=4..8, y=-4..4, axes=NORMAL);"}}{COM_R 72 0
{TEXT 1 0 ""}}{COM_R 73 0{TEXT 1 32 "and on a three dimensional p
lot:"}}{INP_R 74 0 "> "{TEXT 0 48 "plot3d(v[line], x=0..10, y=-10
..10, axes=BOXED);"}}{COM_R 75 0{TEXT 1 0 ""}}{COM_R 76 0{TEXT 1 
74 "EXAMPLE 5: FIELD SUROUNDING FOUR LINE SEGMENTS FORMING A UNIT
 SQUARE FRAME"}}{COM_R 77 0{TEXT 1 0 ""}}{COM_R 78 0{TEXT 1 105 "
Now consider the field surrounding a unit square frame made of fo
ur such line segments -1/2 < x, y < 1/2:"}}{INP_R 79 0 "> "{TEXT 
0 46 "v[bottom] := -int(1*diff(G,y0), x0=-1/2..1/2):"}}{INP_R 80 
0 "> "{TEXT 0 55 "v[bottom] :=  signum(y+1/2)*subs(y0 = -1/2, v[b
ottom]):"}}{INP_R 81 0 "> "{TEXT 0 49 "      v[top] := -int(1*dif
f(G,y0), x0=-1/2..1/2):"}}{INP_R 82 0 "> "{TEXT 0 52 "      v[top
] :=  signum(y-1/2)*subs(y0=1/2, v[top]):"}}{INP_R 83 0 "> "{TEXT
 0 50 "      v[left] := -int(1*diff(G,x0), y0=-1/2..1/2):"}}
{INP_R 84 0 "> "{TEXT 0 56 "      v[left] :=  signum(x+1/2)*subs(
x0= -1/2, v[left]):"}}{INP_R 85 0 "> "{TEXT 0 49 "    v[right] :=
 -int(1*diff(G,x0), y0=-1/2..1/2):"}}{INP_R 86 0 "> "{TEXT 0 54 "
    v[right] :=  signum(x-1/2)*subs(x0=1/2, v[right]):"}}{INP_R 
87 0 "> "{TEXT 0 54 "v[square] :=  v[bottom] + v[right] + v[top] 
+ v[left];"}}{COM_R 88 0{TEXT 1 0 ""}}{COM_R 89 0{TEXT 1 28 "Plot
ting the external field:"}}{INP_R 90 0 "> "{TEXT 0 49 "plot3d(v[s
quare], x= -2..2, y=-2..2, axes=BOXED);"}}{COM_R 91 0{TEXT 1 0 ""
}}{COM_R 92 0{TEXT 1 22 "and on a contour plot:"}}{INP_R 93 0 "> 
"{TEXT 0 54 "contourplot(v[square], x= -2..2, y=-2..2,axes=NORMAL
);"}}}{END}
