{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--17-*" "helvetica" "Helvetica-Bold" 8 17 0 "He
lvetica-Bold" 17}{FONT 1 "-adobe-helvetica-bold-r-normal--20-*" "
helvetica" "Helvetica-Bold" 8 20 0 "Helvetica-Bold" 20}{FONT 2 "-
adobe-courier-bold-r-normal--11-*" "courier" "Courier-Bold" 8 11 
192 "Courier-Bold" 11}{FONT 3 "-adobe-helvetica-bold-o-normal--18
-*" "helvetica" "Courier-BoldOblique" 8 18 160 "Helvetica-BoldObl
ique" 18}{SCP_R 1 0 95{COM_R 2 0{TEXT 1 125 "ENGINEERING APPLICAT
IONS OF MAPLE V RELEASE 2\015\015Analysis and Design of Machines\
015\015(c) Copyright Jason Argent, Thomas Lee 1992\015\015"}}
{COM_R 3 0{TEXT 1 946 "\015Mechanical engineers deal with the ana
lysis and design of machines.  Accurate\015stress information all
ow engineers to choose the proper material, shape and\015size of 
the machine.  Typically, this requires large amounts of mathemati
cal\015manipulation.\015\015This application presents two typical
 design problems for a MACHINE ELEMENT\015(a component of more co
mplicated systems).  It illustrates the powerful new \015mathemat
ical, graphical, and display features of Release 2.  Specifically
, the \015standard math notation, Greek letters, subscripts, comp
lex numbers, \015various graphics, and simplification routines ar
e emphasized.\015\015Furthermore a general Maple V-based problem 
solving PHILOSOPHY is\015illustrated.  General expressions are fi
rst SYMBOLICALLY derived.\015These equations are then adapted to 
particular problems.  These specialized\015equations are then use
d to investigate the solution.  The entire process exploits\015a 
single efficient computing environment.\015\015\015"}}{COM_R 4 0
{TEXT 1 66 "\015\015STEP 1 : GENERAL PRINCIPLES AND EQUATIONS OF 
STATIC EQUILIBRIUM\015"}}{COM_R 5 0{TEXT 1 99 "Equilibrium equati
ons for general free body (wedge element). Sums of forces in x an
d y directions.\012"}}{INP_R 6 0 "> "{TEXT 0 186 "Forces_x := -si
gma[x]*cos(phi)- tau[yx]*sin(phi)+sigma[normal]*cos(phi)+tau[shea
r]*sin(phi);\012Forces_y := -sigma[y]*sin(phi)- tau[xy]*cos(phi)+
sigma[normal]*sin(phi)+tau[shear]*cos(phi);\012"}}{OUT_R 7 0 6
{DAG :3n5\`Forces_x`+9*5b3n4\`sigma`,2n3\`x`j2x0001(3n3\`cos`,2n3
\`phi`pEi2x0001*5b3n3\`tau`,2n3\`yx`pE(3n3\`sin`p13pEp17*5b3p8,2n
4\`normal`pEp10pEpE*5b3p1B,2n4\`shear`pEp21pEpE}}{OUT_R 8 0 6{DAG
 :3n5\`Forces_y`+9*5b3n4\`sigma`,2n3\`y`j2x0001(3n3\`sin`,2n3\`ph
i`pEi2x0001*5b3n3\`tau`,2n3\`xy`pE(3n3\`cos`p13pEp17*5b3p8,2n4\`n
ormal`pEp10pEpE*5b3p1B,2n4\`shear`pEp21pEpE}}{COM_R 9 0{TEXT 1 34
 "General truism for shear stresses\012"}}{INP_R 10 0 "> "{TEXT 0
 20 "tau[yx] := tau[xy];\012"}}{OUT_R 11 0 10{DAG :3b3n3\`tau`,2n
3\`yx`b3p2,2n3\`xy`}}{COM_R 12 0{TEXT 1 90 "Solve equilibrium equ
ations and  obtain general expressions for shear and normal stres
ses\012"}}{INP_R 13 0 "> "{TEXT 0 21 "_EnvExplicit := true;"}}
{OUT_R 14 0 13{DAG :3n6\`_EnvExplicit`n4\`true`}}{INP_R 15 0 "> "
{TEXT 0 66 "solve(\{Forces_x,Forces_y\},\{tau[shear],sigma[normal
]\});\012assign(\");\012"}}{OUT_R 16 0 15{DAG %2,3=3b3n4\`sigma`,
2n4\`normal`*5+5*3(3n3\`sin`,2n3\`phi`j2x0002i2x0001*3(3n3\`cos`p
11p14j2x0001p16+5*5b3p4,2n3\`y`p1EpEp14p16*5b3p4,2n3\`x`p1Ep19p14
p1Ep1E=3b3n3\`tau`,2n4\`shear`+3*5+9*7p19p1Ep23p1EpEp1Ep16*7p2Dp1
Ep19p1EpEp1Ep1E*5b3p39,2n3\`xy`p1EpEp14p1E*5p53p1Ep19p14p16p1EpCp
16p16}}{COM_R 17 0{TEXT 1 224 "Derive general expression for prin
cipal (extremum normal) stresses. By definition, shear stress is 
0 for principal stresses. First determine corresponding principal
 angles.\012\015First, solve the general shear equation for phi. 
 "}}{INP_R 18 0 "> "{TEXT 0 24 "solve(tau[shear]=0,phi);"}}{OUT_R
 19 0 18{DAG ,5+3(3n4\`arctan`,2+7*5+5b3n4\`sigma`,2n3\`y`j2x0002
b3pB,2n3\`x`i2x0002j2x0001b3n3\`tau`,2n3\`xy`i2x0001/3p1Aj2x0004*
5p1Cp22+9*3pAp11p1A*5pAp1Ap13p1Ap18*3p13p11p1A*3p1Cp11p26/3p1Ap11
p3E*5p1Cp22+3*5+15*5p2Bp3EpAp11p18*7p2Bp3EpAp1Ap13p1Ap26*5p2Bp3Ep
13p11p18*5p1Cp11p2Bp3Ei2x0008*3pAj2x0003p18*5pAp11p13p1Aj2x0006*5
pAp1Ap13p11i2x0006*5pAp1Ap1Cp11p61*3p13p65p11*5p13p1Ap1Cp11j2x000
8p1Ap2B/3p22p11p22p3Ep3Ep11+3(3p3,2+7p8p24p28p3Ep42p89p11+3(3p3,2
+7p8p24p28p89*7p11p3Ep1Cp22*5+15p48p1Ap4Ep18p56p1Ap5Cp26p63p22p68
p65p6Fi2x0003p76i2x0004p7Cp1Ap80p26p1Ap2Bp89p3Ep3Ep11+3(3p3,2+7p8
p24p28p89pA5p89p11}}{COM_R 20 0{TEXT 1 45 "\012Simplify the solut
ion to a more consise form"}}{INP_R 21 0 "> "{TEXT 0 27 "map(simp
lify,[\"],symbolic);"}}{OUT_R 22 0 21{DAG [2,5+3(3n4\`arctan`,2+3
*7+9*5b3n4\`sigma`,2n3\`y`j2x0001+9*3pCj2x0002p13*5pCp13b3pD,2n3\
`x`p13i2x0002*3p1Ep18p13*3b3n3\`tau`,2n3\`xy`p18j2x0004/3p13p32p1
3*5p1Ep13p15p34i2x0001*3p15/3j2x0003p32p13*5n3\`I`p13+15*5p15/3p1
3p18pCp18p24*7p15p4DpCp13p1Ep13p32*5p15p4Dp1Ep18p24*5p2Bp18p15p4D
i2x0008*3pCp42p24*5pCp18p1Ep13j2x0006*5pCp13p1Ep18i2x0006*5pCp13p
2Bp18p66*3p1Ep42p18*5p1Ep13p2Bp18j2x0008p4Dp13p13p15/3p3Dp32p2Bp3
Dp4Dp18+3(3p4,2+3*7+9pBp3Dp38p13p3Fp3Dp46p13p13p15p8Fp2Bp3Dp4Dp24
+3(3p4,2+3*7+9pBp13p38p3Dp3Fp3D*5p18p4D+15p4Bp13p53p24p5Bp13p61p3
2p68p3Dp6Cp42p73i2x0003p7Ai2x0004p80p13p84p32p4Dp13p13p15p8Fp2Bp3
Dp4Dp18+3(3p4,2+3*7+9pBp3Dp38p13p3Fp13pB9p13p13p15p8Fp2Bp3Dp4Dp24
}}{COM_R 23 0{TEXT 1 36 "Therefore, the principal angles are,"}}
{INP_R 24 0 "> "{TEXT 0 61 "lambda[principal][1] := \"[3];\012lam
bda[principal][2] := \"\"[4];\012"}}{OUT_R 25 0 24{DAG :3b3b3n4\`
lambda`,2n5\`principal`,2j2x0001+3(3n4\`arctan`,2+3*7+9*5b3n4\`si
gma`,2n3\`y`pC+9*3p18j2x0002pC*5p18pCb3p19,2n3\`x`pCi2x0002*3p29p
23pC*3b3n3\`tau`,2n3\`xy`p23j2x0004/3pCp3DpC*5p29pCp20p3Fi2x0001*
3p20/3j2x0003p3Dp48*5p23/3pCp23+15*5p20p53p18p23pC*7p20p53p18pCp2
9pCp2F*5p20p53p29p23pC*5p36p23p20p53p3D*3p18p4Dp48*5p18p23p29pCp4
D*5p18pCp29p23i2x0003*5p18pCp36p23i2x0004*3p29p4DpC*5p29pCp36p23p
3Dp53pCpCp20/3p48p3Dp36p48p53p23}}{OUT_R 26 0 24{DAG :3b3b3n4\`la
mbda`,2n5\`principal`,2j2x0002+3(3n4\`arctan`,2+3*7+9*5b3n4\`sigm
a`,2n3\`y`j2x0001+9*3p18pCp1F*5p18p1Fb3p19,2n3\`x`p1Fi2x0002*3p29
pCp1F*3b3n3\`tau`,2n3\`xy`pCj2x0004/3p1Fp3Di2x0001*5p29p1Fp21p3Fp
1F*3p21/3j2x0003p3Dp1F*5pC/3p1FpC+15*5p21p53p18pCp1F*7p21p53p18p1
Fp29p1Fp2F*5p21p53p29pCp1F*5p36pCp21p53p3D*3p18p4Dp42*5p18pCp29p1
Fp4D*5p18p1Fp29pCi2x0003*5p18p1Fp36pCi2x0004*3p29p4Dp1F*5p29p1Fp3
6pCp3Dp53p1Fp1Fp21/3p42p3Dp36p42p53p2F}}{COM_R 27 0{TEXT 1 38 "Ge
neral equation for Von Mises stress\012"}}{INP_R 28 0 "> "{TEXT 0
 165 "sigma[`Von Mises`]:= sqrt(((sigma[principal][1]-sigma[princ
ipal][2])^2+(sigma[principal][2]- sigma[principal][3])^2+(sigma[p
rincipal][1]-sigma[principal][3])^2)/2);\012"}}{OUT_R 29 0 28{DAG
 :3b3n4\`sigma`,2n5\`Von~`Mises`*3+D*3b3b3p2,2n5\`principal`,2j2x
0001j2x0002p16*5pDp16b3pE,2p18p16i2x0001*3p1Ep18p16*5p1Ep16b3pE,2
j2x0003p16p23*3p2Cp18p16*5pDp16p2Cp16p23/3p16p18}}{COM_R 30 0
{TEXT 1 199 "Now, define expressions for principal stresses (i.e.
 normal stress at principal angles).\015These expressions will au
tomatically be substituted into the general expression for\015Von
 Mises stress (above).\012"}}{INP_R 31 0 "> "{TEXT 0 148 "phi := 
lambda[principal][1]:\012sigma[principal][1] := sigma[normal];\01
2phi := lambda[principal][2]:\012sigma[principal][2] := sigma[nor
mal];\012phi := 'phi';\012"}}{OUT_R 32 0 31{DAG :3b3b3n4\`sigma`,
2n5\`principal`,2j2x0001*5+5*3(3n3\`sin`,2+3(3n4\`arctan`,2+3*7+9
*5b3p3,2n3\`y`pC+9*3p1Fj2x0002pC*5p1FpCb3p3,2n3\`x`pCi2x0002*3p2E
p28pC*3b3n3\`tau`,2n3\`xy`p28j2x0004/3pCp42pC*5p2EpCp25p44i2x0001
*3p25/3j2x0003p42p4D*5p28/3pCp28+15*5p25p58p1Fp28pC*7p25p58p1FpCp
2EpCp34*5p25p58p2Ep28pC*5p3Bp28p25p58p42*3p1Fp52p4D*5p1Fp28p2EpCp
52*5p1FpCp2Ep28i2x0003*5p1FpCp3Bp28i2x0004*3p2Ep52pC*5p2EpCp3Bp28
p42p58pCpCp25/3p4Dp42p3Bp4Dp58p28p28p4D*3(3n3\`cos`p14p28pCp4D+5*
5p1FpCp11p28p4D*5p2EpCpA6p28pCpC}}{OUT_R 33 0 31{DAG :3b3b3n4\`si
gma`,2n5\`principal`,2j2x0002*5+5*3(3n3\`sin`,2+3(3n4\`arctan`,2+
3*7+9*5b3p3,2n3\`y`j2x0001+9*3p1FpCp24*5p1Fp24b3p3,2n3\`x`p24i2x0
002*3p2EpCp24*3b3n3\`tau`,2n3\`xy`pCj2x0004/3p24p42i2x0001*5p2Ep2
4p26p44p24*3p26/3j2x0003p42p24*5pC/3p24pC+15*5p26p58p1FpCp24*7p26
p58p1Fp24p2Ep24p34*5p26p58p2EpCp24*5p3BpCp26p58p42*3p1Fp52p47*5p1
FpCp2Ep24p52*5p1Fp24p2EpCi2x0003*5p1Fp24p3BpCi2x0004*3p2Ep52p24*5
p2Ep24p3BpCp42p58p24p24p26/3p47p42p3Bp47p58pCpCp47*3(3n3\`cos`p14
pCp24p47+5*5p1Fp24p11pCp47*5p2Ep24pA6pCp24p24}}{OUT_R 34 0 31{DAG
 :3n3\`phi`p1}}{COM_R 35 0{TEXT 1 146 "Derive general expression 
for maximum shear stresses that occur when derivative \015of the 
general shear stress expression (previously derived) is 0\012"}}
{INP_R 36 0 "> "{TEXT 0 41 "max_shear_eqn := diff(tau[shear],phi)
=0;\012"}}{OUT_R 37 0 36{DAG :3n6\`max_shear_eqn`=3+5*5+B*5b3n4\`
sigma`,2n3\`y`j2x0001(3n3\`sin`,2n3\`phi`j2x0002p12*5(3n3\`cos`p1
7p1ApBp12i2x0001*5b3pC,2n3\`x`p12p14p1Ap25*5p28p12p1Ep1Ap12*7b3n3
\`tau`,2n3\`xy`p12p14p12p1Ep12j2x0004p12+5*3p14p1Ap25*3p1Ep1Ap12p
25p25*9+9*7p1Ep12pBp12p14p12p25*7p28p12p1Ep12p14p12p12*5p38p12p14
p1Ap12*5p38p12p1Ep1Ap25p12p46i2x0002p14p12p1Ep12i2x0004j2x0000}}
{COM_R 38 0{TEXT 1 79 "STEP 2: ADAPTATION OF GENERAL EQUATIONS TO
 MACHINE ELEMENT UNDER CONSIDERATION\012"}}{COM_R 39 0{TEXT 1 121
 "Second moments of area (inertia) describe critical cross-sectio
nal \012geometry of the machine element under consideration \015"
}}{COM_R 40 0{TEXT 1 71 "Second moment area of shaft, and polar s
econd moment of area for shaft\012"}}{INP_R 41 0 "> "{TEXT 0 29 "
II := Pi*r*r;\012J := Pi*r^4/2;\012"}}{OUT_R 42 0 41{DAG :3n3\`II
`*5n3\`Pi`j2x0001n3\`r`j2x0002}}{OUT_R 43 0 41{DAG :3n3\`J`+3*5n3
\`Pi`j2x0001n3\`r`j2x0004/3p7j2x0002}}{COM_R 44 0{TEXT 1 33 "Defi
ne components of load vector\012"}}{INP_R 45 0 "> "{TEXT 0 44 "P[
x] := P*cos(theta);\012P[y] := P*sin(theta);\012"}}{OUT_R 46 0 45
{DAG :3b3n3\`P`,2n3\`x`*5p2j2x0001(3n3\`cos`,2n4\`theta`p9}}
{OUT_R 47 0 45{DAG :3b3n3\`P`,2n3\`y`*5p2j2x0001(3n3\`sin`,2n4\`t
heta`p9}}{COM_R 48 0{TEXT 1 53 "General expressions for moments c
aused by load force\012"}}{INP_R 49 0 "> "{TEXT 0 48 "M[y] := P[x
]*b;\012M[z] := P[y]*a;\012M[x] := P[y]*b;\012"}}{OUT_R 50 0 49
{DAG :3b3n3\`M`,2n3\`y`*7n3\`P`j2x0001(3n3\`cos`,2n4\`theta`pAn3\
`b`pA}}{OUT_R 51 0 49{DAG :3b3n3\`M`,2n3\`z`*7n3\`P`j2x0001(3n3\`
sin`,2n4\`theta`pAn3\`a`pA}}{OUT_R 52 0 49{DAG :3b3n3\`M`,2n3\`x`
*7n3\`P`j2x0001(3n3\`sin`,2n4\`theta`pAn3\`b`pA}}{COM_R 53 0{TEXT
 1 92 "Equations of normal stresses due to bending and axial load
 at the point under consideration\012"}}{INP_R 54 0 "> "{TEXT 0 
57 "sigma[bend][x] := -M[z]*r/II;\012sigma[axial][x] := P[x]/a;\0
12"}}{OUT_R 55 0 54{DAG :3b3b3n4\`sigma`,2n4\`bend`,2n3\`x`+3*Bn3
\`P`j2x0001(3n3\`sin`,2n4\`theta`p11n3\`a`p11n3\`r`i2x0001n3\`Pi`
p20p20}}{OUT_R 56 0 54{DAG :3b3b3n4\`sigma`,2n4\`axial`,2n3\`x`*7
n3\`P`j2x0001(3n3\`cos`,2n4\`theta`p10n3\`a`i2x0001}}{COM_R 57 0
{TEXT 1 58 "General expression for total normal stress due to ben
ding\012"}}{INP_R 58 0 "> "{TEXT 0 50 "sigma[total] := sigma[bend
][x] + sigma[axial][x];\012"}}{OUT_R 59 0 58{DAG :3b3n4\`sigma`,2
n4\`total`+5*Bn3\`P`j2x0001(3n3\`sin`,2n4\`theta`pDn3\`a`pDn3\`r`
i2x0001n3\`Pi`p1Cp1C*7pBpD(3n3\`cos`p12pDp17p1CpD}}{COM_R 60 0
{TEXT 1 51 "General expression for shear stress due to torsion\01
2"}}{INP_R 61 0 "> "{TEXT 0 21 "tau[xy] := M[x]*r/J;\012"}}{OUT_R
 62 0 61{DAG :3b3n3\`tau`,2n3\`xy`+3*Bn3\`P`j2x0001(3n3\`sin`,2n4
\`theta`pBn3\`b`pBn3\`r`i2x0003n3\`Pi`i2x0001j2x0002}}{COM_R 63 0
{TEXT 1 72 "Assumption: Effects of shear forces are 0 at a free s
urface. Therefore,\012"}}{INP_R 64 0 "> "{TEXT 0 15 "sigma[z] := 
0;\012"}}{OUT_R 65 0 64{DAG :3b3n4\`sigma`,2n3\`z`j2x0000}}{COM_R
 66 0{TEXT 1 45 "Assumption: No external pressure. Therefore,\012
"}}{INP_R 67 0 "> "{TEXT 0 41 "sigma[y] := 0;\012sigma[principal]
[3] := 0;\012"}}{OUT_R 68 0 67{DAG :3b3n4\`sigma`,2n3\`y`j2x0000}
}{OUT_R 69 0 67{DAG :3b3b3n4\`sigma`,2n5\`principal`,2j2x0003j2x0
000}}{COM_R 70 0{TEXT 1 61 "Normal stress in x direction is equal
 to total normal stress\012"}}{INP_R 71 0 "> "{TEXT 0 26 "sigma[x
] := sigma[total];\012"}}{OUT_R 72 0 71{DAG :3b3n4\`sigma`,2n3\`x
`+5*Bn3\`P`j2x0001(3n3\`sin`,2n4\`theta`pCn3\`a`pCn3\`r`i2x0001n3
\`Pi`p1Bp1B*7pApC(3n3\`cos`p11pCp16p1BpC}}{COM_R 73 0{TEXT 1 657 
"STEP 3a: DESIGN PROBLEM I\015 \012Given some likely dimensions f
or the machine element, determine the type of steel \012one shoul
d use to prevent failure or breaking of the shaft under given loa
ding conditions.  \012Knowing that higher strength steel is more 
expensive, determine the steel that will \012ensure factor of saf
ety of n=2 and incurs a minimum financial cost (in a general sens
e).\012\012Choice of steels: \0121) A.I.S.I. 4140 (Quenched and t
empered at 600 deg. F., Yield strength Sy = 165 kpsi)\0122) A.I.S
.I. 4140 (Quenched and tempered at 1000 deg. F., Yield strength S
y = 121 kpsi)\0123) A.I.S.I. 1040 (Quenched and tempered at 400 d
eg. F., Yield strength Sy = 86 kpsi) \012"}}{COM_R 74 0{TEXT 1 24
 "General design equation\012"}}{INP_R 75 0 "> "{TEXT 0 28 "Sy :=
 n*sigma[`Von Mises`];\012"}}{OUT_R 76 0 75{DAG :3n3\`Sy`*5n3\`n`
j2x0001+7*7+5*3(3n3\`sin`,2+3(3n4\`arctan`,2+3*F+7*5+5*Bn3\`P`p6(
3pD,2n4\`theta`p6n3\`a`p6n3\`r`i2x0001n3\`Pi`p2Bp2B*7p1Cp6(3n3\`c
os`p21p6p26p2Bp6p6+5*3p1Aj2x0002p6*Bp1Cp40p1Fp40n3\`b`p40p29i2x00
06p2Di2x0002j2x0016/3p6j2x0004p2B*3p3D/3j2x0003p55p2B*5p40/3p6p40
+9*5p3Dp61p1Ap40p6*Dp1Cp40p1Fp40p48p40p29p4Cp2Dp4Fp3Dp61p51*3p1Ap
5Bp6*Dp1Ap6p1Cp40p1Fp40p48p40p29p4Cp2Dp4Fp51p61p6p6p3D/3p2Bp55p1C
p2Bp1Fp2Bp48p2Bp29p5Bp2Dp6p53p40p40p2B*3(3p35pFp40p6p4Fp1Ap40pA1p
55p6*BpAp2Bp1Ap40pA1p40+5*3(3pD,2+3(3p12,2+3*F+7p19p6p58p6p5Fp6p6
p3Dp8Fp1Cp2Bp1Fp2Bp48p2Bp29p5Bp2Dp6p53p40p40p2B*3(3p35pB7p40p6p2B
pD7p40p2B*7pB3p4Fp1Ap40pD7p55p6p61}}{COM_R 77 0{TEXT 1 81 "Assume
d dimensions and parameter values: all lengths in inches, forces 
in pounds\012"}}{INP_R 78 0 "> "{TEXT 0 76 "a := 10;\012b := 11;\
012P := 500;\012theta := convert(45*degrees,radians);\012r := 3/8
;\012"}}{OUT_R 79 0 78{DAG :3n3\`a`j2x0010}}{OUT_R 80 0 78{DAG :3
n3\`b`j2x0011}}{OUT_R 81 0 78{DAG :3n3\`P`j2x0500}}{OUT_R 82 0 78
{DAG :3n4\`theta`+3n3\`Pi`/3j2x0001j2x0004}}{OUT_R 83 0 78{DAG :3
n3\`r`/3j2x0003j2x0008}}{COM_R 84 0{TEXT 1 96 "For a factor of sa
fety of n=2, calculate the minimum required yield strength for a 
given steel.\012"}}{INP_R 85 0 "> "{TEXT 0 63 "n := 2;\012sigma[`
minimum required yield strength`] := evalf(Sy);\012"}}{OUT_R 86 0
 85{DAG :3n3\`n`j2x0002}}{OUT_R 87 0 85{DAG :3b3n4\`sigma`,2nA\`m
inimum~`required~`yield~`strength`e3j4x009098078482i2x0005}}
{COM_R 88 0{TEXT 1 92 "Therefore, steel 3) fails and we should ch
oose steel 2) over steel 1) to minimize cost. \012\015\015\015"}}
{COM_R 89 0{TEXT 1 182 "STEP 3b: DESIGN PROBLEM 2\012 \012For ste
el 2) and a,b, and P parameters same as before, investigate the a
ffect of \012changes in shaft radius r and load angle theta on th
e Von Mises stress.\012"}}{COM_R 90 0{TEXT 1 16 "Reset variables\
012"}}{INP_R 91 0 "> "{TEXT 0 18 "theta := 'theta';\012"}}{OUT_R 
92 0 91{DAG :3n4\`theta`p1}}{INP_R 93 0 "> "{TEXT 0 10 "r := 'r';
\012"}}{OUT_R 94 0 93{DAG :3n3\`r`p1}}{INP_R 95 0 "> "{TEXT 0 89 
"plot3d(sigma[`Von Mises`],r=1/4..1,theta=0..Pi/2,style=WIREFRAME
,axes=BOXED,shading=Z);\012\012"}}{INP_R 96 0 "> "{TEXT 0 0 ""}}}
{END}
