{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-helvetica-bold-r-normal--20-*" "
helvetica" "Helvetica-Bold" 8 20 0 "Helvetica-Bold" 20}{FONT 2 "-
adobe-courier-medium-r-normal--14-*" "courier" "Courier" 4 14 192
 "Courier" 12}{SCP_R 1 0 40{SEP_R 2 0}{COM_R 3 0{TEXT 1 690 "ENGI
NEERING APPLICATIONS OF MAPLE V RELEASE 2\015\015Circuits 2 :  St
ep response Analysis of an RC Circuit\015\015(c) Copyright  R. Ia
n Adare, Thomas Lee  1992\015\015It is often important to determi
ne how an electronic device will respond when it \015is switched 
on.  It is undesirable to BLOW a fuse every time you turn on the 
TV or \015to POP a speaker when the stereo comes on.  The Step re
sponse of a circuit helps\015determine this aspect of a circuit b
y analyzing the effect that a sudden input signal\015(a \"step\")
 has on the circuit's output.  The following example illustrates 
the step \015response of a simple circuit.  It also demostrates h
ow the step response can change \015if the value of the capacitor
 changes."}}{SEP_R 4 0}{COM_R 5 0{TEXT 1 130 "The behavior of all
 circuits is governed by certains laws such as Kirchhoff's laws\0
15which can be written in the form of equations.\012"}}{INP_R 6 0
 "> "{TEXT 0 77 "KCL_eqn := Ii2(t) = IC2(t) + IR2(t);\012KVL_eqn 
:= Vi2(t) = VRi2(t) + Vo2(t);\012\012\012"}}{OUT_R 7 0 6{DAG :3n4
\`KCL_eqn`=3(3n3\`Ii2`,2n3\`t`+5(3n3\`IC2`p8j2x0001(3n3\`IR2`p8p1
0}}{OUT_R 8 0 6{DAG :3n4\`KVL_eqn`=3(3n3\`Vi2`,2n3\`t`+5(3n4\`VRi
2`p8j2x0001(3n3\`Vo2`p8p11}}{SEP_R 9 0}{COM_R 10 0{TEXT 1 103 "Ea
ch component in the circuit can be described by a single equation
 which relates\015current and voltage.\015"}}{INP_R 11 0 "> "
{TEXT 0 107 "Cap_eqn := IC2(t) = C2*diff(VC2(t),t);\012Res_eqn :=
 IR2(t) = VR2(t) / R2;\012Ri_eqn := Ii2(t) = VRi2(t) / Ri2;\012\0
12"}}{OUT_R 12 0 11{DAG :3n4\`Cap_eqn`=3(3n3\`IC2`,2n3\`t`*5n3\`C
2`j2x0001(3n4\`diff`,3(3n3\`VC2`p8p9pE}}{OUT_R 13 0 11{DAG :3n4\`
Res_eqn`=3(3n3\`IR2`,2n3\`t`*5(3n3\`VR2`p8j2x0001n3\`R2`i2x0001}}
{OUT_R 14 0 11{DAG :3n4\`Ri_eqn`=3(3n3\`Ii2`,2n3\`t`*5(3n4\`VRi2`
p8j2x0001n3\`Ri2`i2x0001}}{SEP_R 15 0}{COM_R 16 0{TEXT 1 201 "The
 components of the circuit are connected together by wires which 
form\015relationships between the different components.  Furtherm
ore, the circuit will\015usually have no output before it is swit
ched on.\015"}}{INP_R 17 0 "> "{TEXT 0 78 "VR_eqn := VR2(t) = Vo2
(t);\012VC_eqn := VC2(t) = Vo2(t);\012IC_eqn := Vo2(0) = 0;\012\0
12\012"}}{OUT_R 18 0 17{DAG :3n4\`VR_eqn`=3(3n3\`VR2`,2n3\`t`(3n3
\`Vo2`p8}}{OUT_R 19 0 17{DAG :3n4\`VC_eqn`=3(3n3\`VC2`,2n3\`t`(3n
3\`Vo2`p8}}{OUT_R 20 0 17{DAG :3n4\`IC_eqn`=3(3n3\`Vo2`,2j2x0000p
9}}{SEP_R 21 0}{COM_R 22 0{TEXT 1 129 "To represent the act of sw
itch a device on a special mathematical function called\015a Heav
iside Step is used as the input voltage.\015"}}{INP_R 23 0 "> "
{TEXT 0 44 "readlib(Heaviside):\012Vi2(t) := Heaviside(t);\012"}}
{OUT_R 24 0 23{DAG :3(3n3\`Vi2`,2n3\`t`(3n5\`Heaviside`p4}}{SEP_R
 25 0}{COM_R 26 0{TEXT 1 102 "All of the equations for the circui
t can be collected into a system and\015solved analytically by Ma
ple.\015"}}{INP_R 27 0 "> "{TEXT 0 228 "eqn_set2 := \{KCL_eqn,KVL
_eqn,Cap_eqn,Res_eqn,Ri_eqn,VR_eqn,VC_eqn,IC_eqn\};\012var_set2 :
= \{Vo2(t),VRi2(t), VR2(t), VC2(t), IR2(t), IC2(t), Ii2(t)\}; \01
2assume(t>0);\015dsolve(eqn_set2, var_set2);\012assign(\");\012Vo
 := unapply(Vo2(t),t,C2);\012\012\012"}}{OUT_R 28 0 27{DAG :3n5\`
eqn_set2`%2,9=3(3n5\`Heaviside`,2n3\`t`+5(3n4\`VRi2`pDj2x0001(3n3
\`Vo2`pDp16=3(3n3\`IR2`pD*5(3n3\`VR2`pDp16n3\`R2`i2x0001=3(3n3\`I
i2`pD*5p11p16n3\`Ri2`p2A=3p23p18=3(3n3\`VC2`pDp18=3(3p19,2j2x0000
p44=3p2D+5(3n3\`IC2`pDp16p1Ep16=3p4A*5n3\`C2`p16(3n4\`diff`,3p3Bp
Ep16}}{OUT_R 29 0 27{DAG :3n5\`var_set2`%2,8(3n3\`VR2`,2n3\`t`(3n
3\`Ii2`pA(3n3\`IC2`pA(3n3\`IR2`pA(3n4\`VRi2`pA(3n3\`Vo2`pA(3n3\`V
C2`pA}}{OUT_R 30 0 27{DAG %2,8=3(3n3\`IR2`,2n3\`t~~`*5+7j2x0001pB
*7+5n3\`R2`pBn3\`Ri2`pBi2x0001(3n3\`exp`,2+3*BpFpBp7pBn3\`C2`p16p
13p16p10p16p16pBp10pBp16*7pFp16p18pBp13pBp16pBpFp16=3(3n4\`VRi2`p
6*5+7p13pB*7pFp16p10j2x0002p18pBpB*9pFp16p10pBp18pBp13pBpBpBpFp16
=3(3n3\`VC2`p6*5+7p10pBp43p16p4Cp16pBpFp16=3(3n3\`Vo2`p6p5E=3(3n3
\`Ii2`p6*5+7pBpB*9pFp16p10p47p13p16p18pBpBpEpBpBpFp16=3(3n3\`VR2`
p6p5E=3(3n3\`IC2`p6+3*9+5p10p16p13p16pBpFp16p13p16p18pBp16}}
{OUT_R 31 0 27{DAG :3n3\`Vo`@7,3n3\`t~~`n3\`C2`,1,3n5\`operator`n
4\`arrow`p9*5+7n3\`R2`j2x0001*7+5p15p17n3\`Ri2`p17i2x0001p15j2x00
02(3n3\`exp`,2+3*Bp1Ap17a2x0001p17a2x0002p20p1Dp20p15p20p20p17p20
*9p1Ap20p15p17p25p17p1Dp17p20p17p1Ap20p9}}{SEP_R 32 0}{COM_R 33 0
{TEXT 1 231 "One of the powerful aspects of Maple is that it perm
its problems to be solved in a general \015(analytical) manner us
ing variables instead of numbers.  This allow you to specify the 
numbers \015at the end and try out different values.  \012"}}
{INP_R 34 0 "> "{TEXT 0 25 "Ri2 := 100;\012R2 := 1000;\012\012"}}
{OUT_R 35 0 34{DAG :3n3\`Ri2`j2x0100}}{OUT_R 36 0 34{DAG :3n3\`R2
`j2x1000}}{SEP_R 37 0}{COM_R 38 0{TEXT 1 215 "The step response o
f a circuit will change if any of  the components change over tim
e.\015To understand how a change in the capacitance, for example,
 will affect the step response a three\015dimensional plot can be
 used.\015"}}{INP_R 39 0 "> "{TEXT 0 183 "plot3d(Vo(time,Cap), ti
me=0..0.1,Cap=.1*10^(-6)..1000*10^(-6),title=`step response as a 
function of Capacitance`,labels=[`time (sec)`,` Capacitance ( Far
ads)`, `Volts`],axes=BOXED);\012\012"}}{SEP_R 40 0}{COM_R 41 0
{TEXT 1 503 "In the surface plot, note that the reaction of the c
ircuit becomes less severe\015(\"slower\") in response to the ste
p input, as the value of the capacitor rises.  In this\015circuit
, the capacitor acts to hold electrical charge hence slowing down
 the reaction\015of the circuit.\015\015In this example, the capa
citor was used as a design parameter.  With Maple's\015symbolic c
apabilities, an engineer can analyze any circuit parameter or \01
5component much more efficiently than is possible with most tradi
tional\015techniques.\015"}}}{END}
