{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "Courier New"
 "Courier New" "Courier" 4 12 192 "Courier" 10}{SCP_R 1 0 64
{COM_R 2 0{TEXT 1 67 "STREAMLINES\015Alastair Rough: ROUGH@MANADO
N-ENGINEERING-COLLEGE.AC.UK"}}{COM_R 3 0{TEXT 1 0 ""}}{COM_R 4 0
{TEXT 1 87 "The aim of this tutorial is to illustrate streamlines
 in two dimensional vector fields."}}{COM_R 5 0{TEXT 1 0 ""}}
{COM_R 6 0{TEXT 1 0 ""}}{COM_R 7 0{TEXT 1 10 "EXAMPLE 1."}}{COM_R
 8 0{TEXT 1 0 ""}}{COM_R 9 0{TEXT 1 88 "A vector field  v is defi
ned by:                           v(x,y) =  (x + y)i + (x - y)j"}
}{COM_R 10 0{TEXT 1 0 ""}}{COM_R 11 0{TEXT 1 155 "The streamlines
 show the path traced by an object following the vector field and
 can be plotted by defining the first order ordinary differential
 equation:"}}{COM_R 12 0{TEXT 1 105 "                            
                                                     dy/dx   =  v
_y/v_x      "}}{COM_R 13 0{TEXT 1 0 ""}}{INP_R 14 0 "> "{TEXT 0 
41 "de := diff(y(x),x)=(x - y(x))/(x + y(x));"}}{INP_R 15 0 "> "
{TEXT 0 16 "dsolve(de,y(x));"}}{COM_R 16 0{TEXT 1 0 ""}}{COM_R 17
 0{TEXT 1 22 "As explicit solutions:"}}{INP_R 18 0 "> "{TEXT 0 21
 "exp1:= solve(\",y(x));"}}{COM_R 19 0{TEXT 1 0 ""}}{COM_R 20 0
{TEXT 1 126 "The family of solutions is now plotted in the first 
quadrant to display the sections of streamlines for various value
s of _C1:"}}{INP_R 21 0 "> "{TEXT 0 6 "plot(\{"}}{INP_R 22 0 "> "
{TEXT 0 26 " subs(_C1=0,     exp1[1]),"}}{INP_R 23 0 "> "{TEXT 0 
25 " subs(_C1=1/2,  exp1[1]),"}}{INP_R 24 0 "> "{TEXT 0 26 " subs
(_C1=8,     exp1[1]),"}}{INP_R 25 0 "> "{TEXT 0 25 " subs(_C1=25,
   exp1[1]),"}}{INP_R 26 0 "> "{TEXT 0 25 " subs(_C1=50,   exp1[1
]),"}}{INP_R 27 0 "> "{TEXT 0 25 " subs(_C1=-20,  exp1[1]),"}}
{INP_R 28 0 "> "{TEXT 0 25 " subs(_C1=-5,    exp1[1])"}}{INP_R 29
 0 "> "{TEXT 0 17 "\},x=0..10,0..10);"}}{COM_R 30 0{TEXT 1 0 ""}}
{COM_R 31 0{TEXT 1 66 "Alternatively samples of the vector field 
can be plotted directly:"}}{INP_R 32 0 "> "{TEXT 0 12 "with(plots
):"}}{INP_R 33 0 "> "{TEXT 0 54 "fieldplot( [x+y, x-y], x=0..10, 
y=0..10, arrows=SLIM);"}}{COM_R 34 0{TEXT 1 0 ""}}{COM_R 35 0
{TEXT 1 225 "Comparing these two plots, the solutions of the orig
inal differential equation indicate the direction of the vector f
ield at any point but to see the magnitude and direction of the f
ield, the fieldplot procedure must be used."}}{COM_R 36 0{TEXT 1 
0 ""}}{COM_R 37 0{TEXT 1 0 ""}}{COM_R 38 0{TEXT 1 10 "EXAMPLE 2."
}}{COM_R 39 0{TEXT 1 0 ""}}{COM_R 40 0{TEXT 1 89 "Repeat the abov
e analysis for the vector field:  v = e^(-x) cos x  i  -  e^(-x) 
sin x j ."}}{COM_R 41 0{TEXT 1 0 ""}}{COM_R 42 0{TEXT 1 54 "The d
ifferential equation defining the streamlines is:"}}{INP_R 43 0 "
> "{TEXT 0 28 "de := diff(y(x),x)= -tan(x);"}}{COM_R 44 0{TEXT 1 
0 ""}}{COM_R 45 0{TEXT 1 26 "whose general solution is:"}}{INP_R 
46 0 "> "{TEXT 0 16 "dsolve(de,y(x));"}}{INP_R 47 0 "> "{TEXT 0 
21 "exp2:= solve(\",y(x));"}}{COM_R 48 0{TEXT 1 0 ""}}{COM_R 49 0
{TEXT 1 65 "This expression may be rewritten, with _C1 still unsp
ecified, as:"}}{INP_R 50 0 "> "{TEXT 0 22 "exp2:= ln(_C1*cos(x));
"}}{COM_R 51 0{TEXT 1 0 ""}}{COM_R 52 0{TEXT 1 54 "Plotting the f
amily of curves for values of _C1 gives:"}}{INP_R 53 0 "> "{TEXT 
0 6 "plot(\{"}}{INP_R 54 0 "> "{TEXT 0 21 " subs(_C1=-90, exp2),"
}}{INP_R 55 0 "> "{TEXT 0 21 " subs(_C1=90,  exp2),"}}{INP_R 56 0
 "> "{TEXT 0 21 " subs(_C1=10,  exp2),"}}{INP_R 57 0 "> "{TEXT 0 
21 " subs(_C1=-10, exp2),"}}{INP_R 58 0 "> "{TEXT 0 21 " subs(_C1
=40,  exp2),"}}{INP_R 59 0 "> "{TEXT 0 20 " subs(_C1=-40, exp2)"}
}{INP_R 60 0 "> "{TEXT 0 28 "\},x=0..10,0..6, style=LINE);"}}
{COM_R 61 0{TEXT 1 0 ""}}{COM_R 62 0{TEXT 1 45 "Plotting the fiel
d components directly gives:"}}{INP_R 63 0 "> "{TEXT 0 12 "with(p
lots):"}}{INP_R 64 0 "> "{TEXT 0 60 "fieldplot( [-cos(x), sin(x)]
, x=0..10, y=0..6, arrows=SLIM);"}}{INP_R 65 0 "> "{TEXT 0 0 ""}}
}{END}
