{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--17-*" "n
ew century schoolbook" "Times-Bold" 8 12 64 "Times-Bold" 17}{FONT
 4 "-adobe-new century schoolbook-bold-r-normal--17-*" "new centu
ry schoolbook" "Times-Bold" 8 12 64 "Times-Bold" 17}{SCP_R 1 0 47
{COM_R 2 0{TEXT 4 107 "VERIFICATION OF THE KERR SOLUTION OF EINST
EIN'S EQUATIONS\012      AND EVALUATION OF ITS CURVATURE QUANTITI
ES."}}{COM_R 3 0{TEXT 1 196 "\015This program was developed in 19
86 for the Grad Student Rational Calculator program of F. J. Erns
t.  Here we rewrite the program for Maple.  Reference:  R. Kerr, \+
 Phys. Rev. Lett. 11, 237 (1963)."}}{COM_R 4 0{TEXT 1 183 "\015We
 shall use a generic procedure for determining the connection 1-f
orms, _U, _V, _W, and all the curvature quantities, given the dif
ferentials of the basic 2-forms B[1], B[0], B[-1]."}}{INP_R 5 0 "
> "{TEXT 0 12 "with(share):"}}{COM_R 6 0{TEXT 1 56 "Employ the FJ
E ENTERPRISES revision of difforms package:"}}{INP_R 7 0 "> "
{TEXT 0 45 "readshare(fjeforms,fjeforms); with(fjeforms):"}}
{INP_R 8 0 "> "{TEXT 0 28 "readshare(dBsolve,fjeforms);"}}{COM_R 
9 0{TEXT 1 202 "Because of its frequent occurrence in denominator
s, it is convenient to express things in terms of the complex fie
ld\012rho := r + I*a*cos(theta).  The shear turns out to be equal
 to the reciprocal of rho."}}{INP_R 10 0 "> "{TEXT 0 16 "defcompl
ex(rho):"}}{COM_R 11 0{TEXT 1 117 "a and M are the rotation and m
ass parameters, respectively, while u,r,theta and phi are the coo
rdinates used by Kerr."}}{INP_R 12 0 "> "{TEXT 0 24 "defform(a=co
nst,M=const,"}}{INP_R 13 0 "> "{TEXT 0 45 "         d(rho)=d(r)-I
*a*sin(theta)*d(theta),"}}{INP_R 14 0 "> "{TEXT 0 50 "         d(
cc(rho))=d(r)+I*a*sin(theta)*d(theta)):"}}{COM_R 15 0{TEXT 1 43 "
Introduce the null tetrad employed by Kerr."}}{INP_R 16 0 "> "
{TEXT 0 46 "k := expand(d(s) - a * sin(theta)^2 * d(phi));"}}
{INP_R 17 0 "> "{TEXT 0 45 "m := expand(d(r) - a * sin(theta)^2 *
 d(phi) "}}{INP_R 18 0 "> "{TEXT 0 55 "             - (1 - 2*M*re
(rho)/( rho * cc(rho)))*k/2);"}}{INP_R 19 0 "> "{TEXT 0 60 "t := \+
expand((1/sqrt(2))*rho*(d(theta)+I*sin(theta)*d(phi)));"}}{COM_R 
20 0{TEXT 1 137 "Evaluate the basic two-forms:  See Eqs. (8) in J
. Math. Phys. 15, 1409 (1974) or Eqs. (2) in Appendix B of J. Mat
h. Phys. 19, 489 (1978)."}}{INP_R 21 0 "> "{TEXT 0 23 "B[1] := ex
pand(k &^ t);"}}{INP_R 22 0 "> "{TEXT 0 36 "B[0] := expand(k &^ m
 + t &^ cc(t));"}}{INP_R 23 0 "> "{TEXT 0 28 "B[-1] := expand(m &
^ cc(t));"}}{COM_R 24 0{TEXT 1 50 "Evaluate the differentials of \+
the basic two-forms:"}}{INP_R 25 0 "> "{TEXT 0 25 "dB[1] := expan
d(d(B[1]));"}}{INP_R 26 0 "> "{TEXT 0 25 "dB[0] := expand(d(B[0])
);"}}{INP_R 27 0 "> "{TEXT 0 27 "dB[-1] := expand(d(B[-1]));"}}
{COM_R 28 0{TEXT 1 177 "Express everything in terms of the null t
etrad.  Of course, the computer can be used to solve for the coor
dinate differentials, if desired. Here we just worked them out by
 hand."}}{INP_R 29 0 "> "{TEXT 0 9 "k := 'k':"}}{INP_R 30 0 "> "
{TEXT 0 9 "m := 'm':"}}{INP_R 31 0 "> "{TEXT 0 9 "t := 't':"}}
{INP_R 32 0 "> "{TEXT 0 14 "defcomplex(t):"}}{INP_R 33 0 "> "
{TEXT 0 22 "cos(theta):=im(rho)/a:"}}{INP_R 34 0 "> "{TEXT 0 21 "
defform(k=1,m=1,t=1):"}}{COM_R 35 0{TEXT 1 81 "We need the coordi
nate differentials in terms of the null tetrad, k, m, t, cc(t)."}
}{INP_R 36 0 "> "{TEXT 0 30 "d(theta) := sqrt(2)*re(t/rho):"}}
{INP_R 37 0 "> "{TEXT 0 39 "d(phi) := sqrt(2)*im(t/rho)/sin(theta
):"}}{INP_R 38 0 "> "{TEXT 0 38 "d(s) := k + a * sin(theta)^2 * d
(phi):"}}{INP_R 39 0 "> "{TEXT 0 37 "d(r) := m + a * sin(theta)^2
 * d(phi)"}}{INP_R 40 0 "> "{TEXT 0 42 "    + (1 - 2*M*re(rho)/(r
ho*cc(rho)))*k/2:"}}{COM_R 41 0{TEXT 1 95 "to express dB in terms
 of the null tetrad.  The differentials of B[1], B[0], B[-1] are \+
given by"}}{INP_R 42 0 "> "{TEXT 0 43 "dB[1] := simpform(simpform
(expand(dB[1])));"}}{INP_R 43 0 "> "{TEXT 0 43 "dB[0] := simpform
(simpform(expand(dB[0])));"}}{INP_R 44 0 "> "{TEXT 0 45 "dB[-1] :
= simpform(simpform(expand(dB[-1])));"}}{COM_R 45 0{TEXT 1 272 "G
eneric code used from here on is in the file 'dBsolve.m' The proc
edure 'dBsolve' returns the complex connection forms v,u,w and al
l the curvature quantities, which are computed from the three 3-f
orms dB[1],dB[0],dB[-1] expressed in terms of a null tetrad \{ k,
m,t,cc(t) \}."}}{INP_R 46 0 "> "{TEXT 0 12 "dBsolve(dB);"}}{COM_R
 47 0{TEXT 1 276 "The scalar curvature R and all components of th
e tracefree Ricci tensor S[i,j] vanish, while (in Kerr's tetrad) \+
only C[2] and C[1] vanish.  By means of a null rotation about B[1
], C[-1] and C[-2] can be made to vanish as well, showing that th
e Kerr metric is of Petrov type D."}}{INP_R 48 0 "> "{TEXT 0 0 ""
}}}{END}
