{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--17-*" "n
ew century schoolbook" "Times-Bold" 8 12 64 "Times-Bold" 17}{FONT
 4 "-adobe-new century schoolbook-bold-r-normal--17-*" "new centu
ry schoolbook" "Times-Bold" 8 12 64 "Times-Bold" 17}{SCP_R 1 0 82
{COM_R 2 0{TEXT 3 90 "DERIVATION OF THE NEWMAN-PENROSE FORM OF TH
E EINSTEIN EQUATIONS AND THE BIANCHI IDENTITIES"}}{COM_R 3 0{TEXT
 1 47 "\015np    \011Copyright 1992, 1993 by FJE ENTERPRISES"}}
{COM_R 4 0{TEXT 1 241 "\015This program was developed in 1986 for
 the Grad Student Rational Calculator program of F. J. Ernst.  He
re we rewrite the program for Maple.  Reference: J. Math. Phys. 1
9, 489 (1978).\012\015Employ the FJE ENTERPRISES revision of diff
orms package:"}}{INP_R 5 0 "> "{TEXT 0 12 "with(share):"}}{INP_R 
6 0 "> "{TEXT 0 45 "readshare(fjeforms,fjeforms); with(fjeforms):
"}}{INP_R 7 0 "> "{TEXT 0 52 "if eps=1 then print(`Hauser-Ernst s
ign conventions`)"}}{INP_R 8 0 "> "{TEXT 0 56 "else eps := -1; pr
int(`Newman-Penrose sign conventions`)"}}{INP_R 9 0 "> "{TEXT 0 3
 "fi;"}}{COM_R 10 0{TEXT 1 103 "Now introduce a null tetrad of 1-
forms l, n, m and mbar, where mbar denotes the complex conjugate \+
of m."}}{INP_R 11 0 "> "{TEXT 0 28 "defform(l=1,n=1,m=1,mbar=1):"
}}{INP_R 12 0 "> "{TEXT 0 19 "defcomplex(m,mbar):"}}{INP_R 13 0 "
> "{TEXT 0 14 "cc(m) := mbar;"}}{INP_R 14 0 "> "{TEXT 0 14 "cc(mb
ar) := m;"}}{COM_R 15 0{TEXT 1 47 "Now introduce the 12 complex s
pin coefficients:"}}{INP_R 16 0 "> "{TEXT 0 73 "defcomplex(tau,ka
ppa,rho,sigma,gamma,epsilon,alpha,beta,nu,pi,lambda,mu):"}}{COM_R
 17 0{TEXT 1 27 "and the connection 1-forms:"}}{INP_R 18 0 "> "
{TEXT 0 51 "_V := kappa*n + tau*l + eps*sigma*mbar + eps*rho*m;"}
}{INP_R 19 0 "> "{TEXT 0 60 "_U := 2*(epsilon*n + gamma*l + eps*b
eta*mbar + eps*alpha*m);"}}{INP_R 20 0 "> "{TEXT 0 47 "_W := pi*n
 + nu*l + eps*mu*mbar + eps*lambda*m;"}}{COM_R 21 0{TEXT 1 111 "N
ote that W is a Maple reserved name, so use _W instead. We also s
hall need the real and imaginary parts of _U:"}}{INP_R 22 0 "> "
{TEXT 0 12 "P := re(_U);"}}{INP_R 23 0 "> "{TEXT 0 12 "Q := im(_U
);"}}{COM_R 24 0{TEXT 1 52 "The exterior derivatives of l,n,m,mba
r are given by:"}}{INP_R 25 0 "> "{TEXT 0 51 "d(l) := P &^ l + ep
s*cc(_V) &^ m + eps*_V &^ mbar; "}}{INP_R 26 0 "> "{TEXT 0 44 "d(
n) := - P &^ n + _W &^ m + cc(_W) &^ mbar;"}}{INP_R 27 0 "> "
{TEXT 0 48 "d(m) := -eps*cc(_W) &^ l - _V &^ n + I * Q &^ m;"}}
{INP_R 28 0 "> "{TEXT 0 20 "d(mbar) := cc(d(m));"}}{COM_R 29 0
{TEXT 1 112 "Now we shall derive the so-called comutation relatio
ns.  We begin by introducing complex differential operators."}}
{INP_R 30 0 "> "{TEXT 0 27 "defcomplex(delta,deltabar):"}}{COM_R 
31 0{TEXT 1 44 "These are complex conjugates of one another."}}
{INP_R 32 0 "> "{TEXT 0 23 "cc(delta) := deltabar; "}}{INP_R 33 0
 "> "{TEXT 0 22 "cc(deltabar) := delta;"}}{COM_R 34 0{TEXT 1 200 
"Note: Because 2nd exterior derivative will be evaluated, we must
 identify _D,Delta,delta,deltabar as differential operators rathe
r than ordinary functions.   Note also that D is a Maple reserved
 name."}}{INP_R 35 0 "> "{TEXT 0 35 "defdiffop(_D,Delta,delta,del
tabar):"}}{COM_R 36 0{TEXT 1 53 "The differential operators are i
dentified as follows:"}}{INP_R 37 0 "> "{TEXT 0 72 "dcomps := [l,
Delta],[n,_D],[m,eps*deltabar],[mbar,eps*delta]; # correct?"}}
{COM_R 38 0{TEXT 1 84 "We are now ready to evaluate the exterior \+
derivative of an arbitrary scalar field f."}}{INP_R 39 0 "> "
{TEXT 0 18 "df := d(f,dcomps);"}}{COM_R 40 0{TEXT 1 180 "The comm
utation relations follow from the requirement that d(df) = 0.  Th
e result will be a 2-form, each of the components of which must v
anish.  Let us assign this 2-form to Zero."}}{INP_R 41 0 "> "
{TEXT 0 21 "Zero := d(df,dcomps);"}}{COM_R 42 0{TEXT 1 31 "A basi
s for 2-forms is given by"}}{INP_R 43 0 "> "{TEXT 0 62 "basis := \+
[l &^ m,l &^ mbar,l &^ n,mbar &^ m,mbar &^ n,m &^ n];"}}{COM_R 44
 0{TEXT 1 59 "Let's look at the individual components of the 2-fo
rm Zero:"}}{INP_R 45 0 "> "{TEXT 0 20 "for i from 1 to 6 do"}}
{INP_R 46 0 "> "{TEXT 0 13 "    print(i);"}}{INP_R 47 0 "> "{TEXT
 0 38 "    print(0 = coef(Zero,basis[i])) od:"}}{COM_R 48 0{TEXT 
1 83 "We are now read to evaluate the exterior derivative of an a
rbitrary scalar field f."}}{INP_R 49 0 "> "{TEXT 0 18 "df := d(f,
dcomps);"}}{COM_R 50 0{TEXT 1 41 "The basic self-dual 2-forms are
 given by:"}}{INP_R 51 0 "> "{TEXT 0 15 "B[1] := l &^ m;"}}{INP_R
 52 0 "> "{TEXT 0 31 "B[0] := l &^ n - eps*mbar &^ m;"}}{INP_R 53
 0 "> "{TEXT 0 25 "B[-1] := - eps*mbar &^ n;"}}{COM_R 54 0{TEXT 1
 82 "The Riemann 2-form can be expressed in terms of null tetrad \+
components as follows:"}}{INP_R 55 0 "> "{TEXT 0 68 "THETA[1] := \+
eps*(Psi[0]*B[-1]-Psi[1]*B[0]+(Psi[2]-2*eps*Lambda)*B[1]"}}{INP_R
 56 0 "> "{TEXT 0 67 "   +Phi[0][0]*cc(B[-1])+eps*Phi[0][1]*cc(B[
0])+Phi[0][2]*cc(B[1]));"}}{INP_R 57 0 "> "{TEXT 0 66 "THETA[0] :
= eps*(Psi[1]*B[-1]-(Psi[2]+eps*Lambda)*B[0]+Psi[3]*B[1]"}}{INP_R
 58 0 "> "{TEXT 0 67 "   +eps*Phi[1][0]*cc(B[-1])+Phi[1][1]*cc(B[
0])-Phi[1][2]*cc(B[1]));"}}{INP_R 59 0 "> "{TEXT 0 69 "THETA[-1] \+
:= eps*((Psi[2]-2*eps*Lambda)*B[-1]-Psi[3]*B[0]+Psi[4]*B[1]"}}
{INP_R 60 0 "> "{TEXT 0 63 "   +Phi[2][0]*cc(B[-1])-Phi[2][1]*cc(
B[0])+Phi[2][2]*cc(B[1]));"}}{COM_R 61 0{TEXT 1 61 "Alternatively
 it can be computed from the connection 1-forms:"}}{INP_R 62 0 ">
 "{TEXT 0 33 "TH[1] := d(_V,dcomps) - _U &^ _V;"}}{INP_R 63 0 "> \+
"{TEXT 0 37 "TH[0] := 1/2*d(_U,dcomps) - _W &^ _V;"}}{INP_R 64 0 
"> "{TEXT 0 34 "TH[-1] := d(_W,dcomps) - _W &^ _U;"}}{COM_R 65 0
{TEXT 1 224 "The above expressions for the Riemann 2-form should \+
be equated and the components of the resulting equations displaye
d.  I shall assume you do not want to see the three equations, bu
t will be satisfied to see the components."}}{INP_R 66 0 "> "
{TEXT 0 67 "for i from 1 by -1 to -1 do Zero[i] := expand(THETA[i
] - TH[i]) od:"}}{COM_R 67 0{TEXT 1 46 "Here then are the 18 Newm
an-Penrose equations:"}}{INP_R 68 0 "> "{TEXT 0 27 "for i from 1 \+
by -1 to -1 do"}}{INP_R 69 0 "> "{TEXT 0 24 "    for j from 1 to \+
6 do"}}{INP_R 70 0 "> "{TEXT 0 25 "        print(6*(1-i)+j);"}}
{INP_R 71 0 "> "{TEXT 0 49 "        print(0 = coef(Zero[i],basis[
j])) od: od:"}}{COM_R 72 0{TEXT 1 81 "Finally, we can work out th
e Bianchi identities.  A basis for 3-forms is given by"}}{INP_R 
73 0 "> "{TEXT 0 68 "Basis := [n &^ mbar &^ m,l &^ mbar &^ m,l &^
 n &^ mbar,l &^ n &^ m];"}}{COM_R 74 0{TEXT 1 53 "I shall assume \+
that you don't wish to see the 3-forms"}}{INP_R 75 0 "> "{TEXT 0 
66 "Zero[1] := d(THETA[1],dcomps) - THETA[1] &^ _U + 2*_V &^ THET
A[0]:"}}{INP_R 76 0 "> "{TEXT 0 66 "Zero[0] := d(THETA[0],dcomps)
 + THETA[-1] &^ _V -  _W &^ THETA[1]:"}}{INP_R 77 0 "> "{TEXT 0 
69 "Zero[-1] := d(THETA[-1],dcomps) + THETA[-1] &^ _U - 2*_W &^ T
HETA[0]:"}}{COM_R 78 0{TEXT 1 60 "Here then are the Bianchi ident
ities in Newman-Penrose form."}}{INP_R 79 0 "> "{TEXT 0 27 "for i
 from 1 by -1 to -1 do"}}{INP_R 80 0 "> "{TEXT 0 24 "    for j fr
om 1 to 4 do"}}{INP_R 81 0 "> "{TEXT 0 25 "        print(4*(1-i)+
j);"}}{INP_R 82 0 "> "{TEXT 0 49 "        print(0 = coef(Zero[i],
Basis[j])) od: od:"}}{INP_R 83 0 "> "{TEXT 0 0 ""}}}{END}
