{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 0}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-helvetica-medium-o-normal--14-*"
 "helvetica" "Helvetica-Oblique" 4 14 32 "Helvetica-Oblique" 12}
{FONT 2 "-adobe-courier-medium-r-normal--14-*" "courier" "Courier
" 4 14 192 "Courier" 14}{FONT 3 "-adobe-times-bold-r-normal--25-*
" "times" "Times-Bold" 8 25 64 "Times-Bold" 25}{FONT 4 "-adobe-he
lvetica-bold-o-normal--25-*" "helvetica" "Helvetica-BoldOblique" 
8 25 32 "Helvetica-BoldOblique" 25}{FONT 5 "-adobe-helvetica-medi
um-o-normal--14-*" "helvetica" "Helvetica-Oblique" 4 14 32 "Helve
tica-Oblique" 14}{FONT 6 "-adobe-helvetica-bold-o-normal--17-*" "
helvetica" "Helvetica-BoldOblique" 8 17 32 "Helvetica-BoldOblique
" 17}{FONT 7 "-adobe-helvetica-bold-o-normal--14-*" "helvetica" "
Helvetica-BoldOblique" 8 14 32 "Helvetica-BoldOblique" 14}{SCP_R 
1 0 47{COM_R 2 0{TEXT 4 21 "The billiard problem\015"}}{COM_R 3 0
{TEXT 7 110 "W. Gander and D. Gruntz\012Institute for Scientific 
Computing\012ETH Zuerich, CH-8092 Zuerich, Switzerland\015July 19
92"}}{COM_R 4 0{TEXT 7 40 "\015gander@inf.ethz.ch, gruntz@inf.eth
z.ch\012"}}{COM_R 5 0{TEXT 1 2175 "In this paper we present an in
teresting nonlinear equation originating from a geometrical probl
em. We show how it can be solved numerically, how algorithmic dif
ferentiation is useful, and how the problem can also be solved an
alytically using the computer algebra system Maple.\012\012We con
sider a billard table which has the shape of a circle. Two balls 
are located at the points P and Q. In which direction has the bal
l at Q to be pushed, if it is to be reflected once at the boundar
y of the table and then hit the other ball located at P ?\012\012
Without loss of generality we may assume that the length of the t
able radius is 1, i.e. we will use the unit circle. Also, since t
he problem is invariant under rotations, we may assume that one b
all (e.g. Q) is located on the x-axis. The problem can now be sta
ted as follows:\012\012In the unit circle two arbitrary points P=
(px,py) and Q=(a,0) are given. We are looking for a point X on th
e border of the circle, such that a billiard ball shot from Q to 
X will hit P after it bounces off the border. We describe the poi
nt X by the angle x, therefore the coordinates of X are (cos(x),s
in(x)).\012\012The condition which must be satisfied is that the 
angle between the line QX and the tangent g to the circle in X is
 equal to the angle between XP and g, i.e. alpha1=alpha2.\012\012
The direction vector r of the tangent g to the circle in X, r=(-s
in(x), cos(x)) is orthogonal to X =(cos(x), sin(x)). The conditio
n alpha1=alpha2 is equivalent to the condition, that the vector X
 is the bisector of the angle QXP. \012Thus if eXQ is the unit ve
ctor in the direction XQ, and if eXP is defined similarly, then t
he direction of the bisector is given by eXQ + eXP and the above 
condition becomes \012 \012                                      
          (eXQ + eXP) * r = 0.\012\012In the following we derive 
an explicit expression for this equation.\015\015We get\015    XP
 = (px-cos(x), py-sin(x) )       |XP| = sqrt( (px-cos(x))^2 + (py
-sin(x))^2 )\015    XQ = (a -cos(x),  -sin(x) )          |XP| = s
qrt( (a -cos(x))^2 + (-sin(x))^2 )\015\015and the equation we hav
e to solve is given by the following Maple expression (since this
 is more readable). We refer to that equation as equation (1).\01
5"}}{INP_R 6 0 "> "{TEXT 0 205 "( (px-cos(x))/sqrt((px-cos(x))^2 
+ (py-sin(x))^2) + (a-cos(x))/sqrt((a-cos(x))^2 + sin(x)^2) )*sin
(x)-\015( (py-sin(x))/sqrt((px-cos(x))^2 + (py-sin(x))^2) - sin(x
)/sqrt((a-cos(x))^2 + sin(x)^2) )*cos(x) = 0;"}}{OUT_R 7 0 6{DAG 
=3+5*5+5*5+5n3\`px`j2x0001(3n3\`cos`,2n3\`x`i2x0001p8+5*3p5j2x000
2p8*3+5n3\`py`p8(3n3\`sin`pDp10p16p8/3p10p16p8*5+5n3\`a`p8pAp10p8
+5*3p2Ap16p8*3p1Ep16p8p25p8p8p1Ep8p8*5+5*5p1Ap8p13p25p8*5p1Ep8p31
p25p10p8pAp8p10j2x0000}}{COM_R 8 0{TEXT 1 879 "\012Equation (1) i
s complicated and difficult to manipulate by hand in order to fin
d a solution analytically. Numerically it can be solved using a m
ethod that only requires function evaluations such as the bisecti
on method or e.g. Brent's zeroin, see [1, 3].\012\012If we want t
o use Newton's method we will need the derivative of f(x). Differ
entiating (1) however gives an expression that is much more compl
ex than f(x) itself. This is certainly not the way to go. \012\01
2A better idea is to avoid the explicit expression for f(x) and t
o use a computation sequence, i.e. a program which computes f(x).
 Such a program represents a mathematical function too and can be
 differentiated quite easily using algorithmic differentiation (s
ee [5, 6, 7]) as follows. \012\012For our real computations we sw
itch to Maple V, a computer algebra system [2]. Let f(x) be given
 by the following Maple procedure F:\012"}}{INP_R 9 0 "> "{TEXT 0
 343 "F := proc(x)\012     local c,s,h,xp1,xp2,xq1,xq2,ep1,ep2,eq
1,eq2,f;\012     c   := cos(x): s   := sin(x):\012     xp1 := px-
c:   xp2 := py-s:\012     xq1 := a-c:    xq2 := -s:\012     h   :
= sqrt(xp1^2 + xp2^2):\012     ep1 := xp1/h;   ep2 := xp2/h;\012 
    h   := sqrt(xq1^2 + xq2^2):\012     eq1 := xq1/h:   eq2 := xq
2/h:\012     f   := (ep1+eq1)*s - (ep2+eq2)*c;\012end:"}}{COM_R 
10 0{TEXT 1 593 "\015If we now want to write a procedure which co
mputes f(x) and the derivative f'(x) as well we proceed as follow
s: All the local variables are functions of x. For each variable 
v used in the procedure F we introduce a new variable vx which st
ands for the derivative of v. We then differentiate the right han
d side of each statement in the procedure using the ordinary rule
s of differentiation and insert the new statement before the old 
one. In this way we obtain a procedure dF that computes f'(x).\01
2\012Maple V Release 2 knows how to differentiate procedures algo
rithmically using the D-Operator.\012"}}{INP_R 11 0 "> "{TEXT 0 
11 "dF := D(F);"}}{OUT_R 12 0 11{DAG :3n3\`dF`@8,2n3\`x`,17n3\`c`
n3\`s`n3\`h`n3\`xp1`n3\`xp2`n3\`xq1`n3\`xq2`n3\`ep1`n3\`ep2`n3\`e
q1`n3\`eq2`n4\`ep1x`n4\`ep2x`n4\`xp1x`n4\`xp2x`n4\`xq1x`n4\`eq1x`
n4\`xq2x`n4\`eq2x`n3\`cx`n3\`sx`n3\`hx`,1p3C;1A:3l2x0020+3(3n3\`s
in`,2a2x0001i2x0001:3l2x0001(3n3\`cos`p46:3l2x0021p4C:3l2x0002p43
:3l2x0014+3p40p49:3l2x0004+5n3\`px`j2x0001p4Cp49:3l2x0015+3p53p49
:3l2x0005+5n3\`py`p66p57p49:3l2x0016p5D:3l2x0006+5n3\`a`p66p4Cp49
:3l2x0018p6D:3l2x0007+3p57p49:3l2x0022+3*5+5*5p61p66p5Bp66j2x0002
*5p71p66p6Bp66p9Bp66(3n4\`sqrt`,2+5*3p61p9Bp66*3p71p9Bp66p49/3p66
p9B:3l2x0003pA4:3l2x0012+5*5p5Bp66pB7p49p66*7p61p66pB7i2x0002p91p
66p49:3l2x0008*5p61p66pB7p49:3l2x0013+5*5p6Bp66pB7p49p66*7p71p66p
B7pC8p91p66p49:3l2x0009*5p71p66pB7p49:3p91+3*5+5*5p7Ep66p7Ap66p9B
*5p8Bp66p87p66p9Bp66(3pA5,2+5*3p7Ep9Bp66*3p8Bp9Bp66p49pB3:3pB7p10
1:3l2x0017+5*5p7Ap66pB7p49p66*7p7Ep66pB7pC8p91p66p49:3l2x0010*5p7
Ep66pB7p49:3l2x0019+5*5p87p66pB7p49p66*7p8Bp66pB7pC8p91p66p49:3l2
x0011*5p8Bp66pB7p49+9*5+5pBBp66p113p66p66p57p66p66*5+5pCEp66p125p
66p66p53p66p66*5+5pD6p66p12Dp66p66p4Cp66p49*5+5pE8p66p13Fp66p66p4
0p66p49p3Cp3C}{TEXT 2 742 "\012dF :=\012\012proc(x)\012local c,s,
h,xp1,xp2,xq1,xq2,ep1,ep2,eq1,eq2,ep1x,ep2x,xp1x,xp2x,xq1x,eq1x,x
q2x,\012    eq2x,cx,sx,hx;\012    cx := -sin(x);\012    c := cos(
x);\012    sx := c;\012    s := sin(x);\012    xp1x := -cx;\012  
  xp1 := px-c;\012    xp2x := -sx;\012    xp2 := py-s;\012    xq1
x := -cx;\012    xq1 := a-c;\012    xq2x := -sx;\012    xq2 := -s
;\012    hx := 1/2*(2*xp1*xp1x+2*xp2*xp2x)/sqrt(xp1^2+xp2^2);\012
    h := sqrt(xp1^2+xp2^2);\012    ep1x := xp1x/h-xp1/h^2*hx;\012
    ep1 := xp1/h;\012    ep2x := xp2x/h-xp2/h^2*hx;\012    ep2 :=
 xp2/h;\012    hx := 1/2*(2*xq1*xq1x+2*xq2*xq2x)/sqrt(xq1^2+xq2^2
);\012    h := sqrt(xq1^2+xq2^2);\012    eq1x := xq1x/h-xq1/h^2*h
x;\012    eq1 := xq1/h;\012    eq2x := xq2x/h-xq2/h^2*hx;\012    
eq2 := xq2/h;\012    (ep1x+eq1x)*s+(ep1+eq1)*sx-(ep2x+eq2x)*c-(ep
2+eq2)*cx\012end\012"}}{COM_R 13 0{TEXT 1 243 "\015It is not diff
icult to differentiate the program again to obtain in the same wa
y the third derivative of f(x). Hence, to solve the equation, one
 then could use methods of higher order like Halley's method [4].
 \015\012The Newton procedure becomes:\015"}}{INP_R 14 0 "> "
{TEXT 0 136 "newton := proc(xx,tol) local x,h;\012   x := xx; h :
= tol;\012   while abs(h) >= tol do\012      h := - F(x)/dF(x);\0
12      x := x + h;\012   od;\012end:"}}{COM_R 15 0{TEXT 5 146 "\
015That procedure can be tested if we assign numerical values to 
the parameters x, py and a, which are global variables to the pro
cedures F and dF.\012"}}{INP_R 16 0 "> "{TEXT 0 120 "px := 0.5: p
y := 0.5: a := -0.6:\012newton(1.0, 10^(-9));\012newton(2.3, 10^(
-9));\012newton(2.7, 10^(-9));\012newton(5.0, 10^(-9));"}}{OUT_R 
17 0 16{DAG e3j4x009380770495i2x0010}}{OUT_R 18 0 16{DAG e3j4x002
274796772i2x0009}}{OUT_R 19 0 16{DAG e3j4x002750972642i2x0009}}
{OUT_R 20 0 16{DAG e3j4x005031727824i2x0009}}{COM_R 21 0{TEXT 1 
94 "\015Let's compare these results with the help of a plot of f(
x) (for px=0.5, py=0.5 and a=-0.6):\015"}}{INP_R 22 0 "> "{TEXT 0
 17 "plot(F, 0..2*Pi);"}}{COM_R 23 0{TEXT 1 672 "\015We now attem
pt to solve equation (1) analytically. As a first step we remove 
the sin(x) and cos(x) functions by the well known technique of ra
tionalizing.\012\012From a computational point of view it is a ba
d idea to substitute cos(x) by a variable c and then sin(x) by sq
rt(1-c^2), because new roots are introduced which make the equati
on more difficult to be solved. Furthermore, if it is solvable, n
ew solutions are introduced, which are not solutions of the probl
em, because squaring is necessary to get rid of the roots. Theref
ore, we choose to do a tan half angle substitution. Let t=tan(x/2
). Then sin(x) = 2 t/(1+t^2) and cos(x) = (1-t^2)/(1+t^2). Equati
on (1) becomes\012"}}{INP_R 24 0 "> "{TEXT 0 107 "px := 'px': py 
:= 'py': a := 'a':\012f := subs(\{sin(x) = 2*t/(1+t^2), cos(x) = 
(1-t^2)/(1+t^2)\}, F(x)):\012f = 0;"}}{OUT_R 25 0 24{DAG =3+5*7+5
*5+5n3\`px`j2x0001*5+5p8p8*3n3\`t`j2x0002i2x0001p8+5p8p8pEp8p13p1
3p8+5*3p5p11p8*3+5n3\`py`p8*5pFp8p16p13i2x0002p11p8/3p13p11p8*5+5
n3\`a`p8pAp13p8+5*3p36p11p8*5pFp11p16p2Dj2x0004p31p8p8pFp8p16p13p
11*7+5*5p24p8p1Ep31p8*7pFp8p16p13p3Dp31p2Dp8pBp8p16p13p13j2x0000}
}{COM_R 26 0{TEXT 1 116 "\015We refer to the above equation as eq
uation (2). Surprisingly this equation can be solved directly wit
h the command\012"}}{INP_R 27 0 "> "{TEXT 0 21 "sols := \{solve(f
,t)\};"}}{OUT_R 28 0 27{DAG :3n4\`sols`%2,3(3n4\`RootOf`,2+9*5+5n
3\`py`j2x0001*5pEp10n3\`a`p10p10p10n3\`_Z`j2x0002p10*5+5p15i2x000
2n3\`px`p1Cp10p1Ap10p10p12p10pEi2x0001(3p7,2+D*5pDp10p1Aj2x0004p1
0*5+7p24p1C*5p24p10p15p10p38p15p1Cp10p1Aj2x0003p10*7pEp10p1Ap1Cp1
5p10i2x0006*5+7p3Fi2x0004p15p1Cp24p1Cp10p1Ap10p10p12p10pEp2E}}
{COM_R 29 0{TEXT 1 447 "\015The same result can be obtained by ha
nd. First, we have to separate the two radicals. We have to move 
the second and the forth term of (2) to the right hand side and p
ut both sides over a common denominator. If we now square both si
des, the radicals disappear. If we then subtract the right hand s
ide from the left hand side and look at the factors of the numera
tor, after having put all over a common denominator, we get the f
ollowing equation:\012"}}{INP_R 30 0 "> "{TEXT 0 119 "((a*py+py)*
t^4+(4*px*a+2*px+2*a)*t^3-6*a*py*t^2+(2*px-4*px*a+2*a)*t+a*py-py)
\015*((a*py+py)*t^2+(2*px-2*a)*t+a*py-py) = 0;"}}{OUT_R 31 0 30
{DAG =3*5+D*5+5n3\`py`j2x0001*5p5p7n3\`a`p7p7p7n3\`t`j2x0004p7*5+
7n3\`px`j2x0002*5p18p7pCp7p13pCp1Ap7p11j2x0003p7*7p5p7p11p1ApCp7i
2x0006*5+7p1Ci2x0004pCp1Ap18p1Ap7p11p7p7p9p7p5i2x0001p7+9*5p4p7p1
1p1Ap7*5+5pCi2x0002p18p1Ap7p11p7p7p9p7p5p42p7j2x0000}}{COM_R 32 0
{TEXT 1 728 "\012The six roots of these two polynomials are not a
ll solutions of equation (2). Four of them are defined by the fir
st polynomial,\012and two of them by the second one. The solution
s of the polynom of degree 2 don't solve the problem. They have b
een introduced by squaring the isolated roots. They solve the equ
ation (eXQ - eXP)*r=0, and since (eXQ - eXP) is parallel to r thi
s is only possible, if eXQ = eXP. That means, that X, P and Q lie
 on a straight line. These two solutions are therefore the inters
ection points of the straight line trough P and Q and the circle.
 They are only solutions of the problem when either a=0 or py=0.\
012\012For our numerical example above let's now look at the solu
tions we get by the explicit formula:\012"}}{INP_R 33 0 "> "{TEXT
 0 32 "px := 1/2: py := 1/2: a := -3/5:"}}{COM_R 34 0{TEXT 1 134 
"\015The polynom, which defines the four solutions we have alread
y computed using Newton's method, surprisingly has integer coeffi
cients.\012"}}{INP_R 35 0 "> "{TEXT 0 35 "select(t -> degree(op(t
))=4, sols);"}}{OUT_R 36 0 35{DAG %2,2(3n4\`RootOf`,2+B*3n3\`_Z`j
2x0004j2x0001*3p9j2x0003i2x0007*3p9j2x0002j2x0009p9j2x0005i2x0004
pD}}{INP_R 37 0 "> "{TEXT 0 5 "\"[1];"}}{OUT_R 38 0 37{DAG (3n4\`
RootOf`,2+B*3n3\`_Z`j2x0004j2x0001*3p7j2x0003i2x0007*3p7j2x0002j2
x0009p7j2x0005i2x0004pB}}{INP_R 39 0 "> "{TEXT 0 14 "fsolve(op(\"
));"}}{OUT_R 40 0 39{DAG ,5e3i4x007225931043i2x0010e3j4x005067569
233p6e3j4x002161040292i2x0009e3j4x005054795890p13}}{COM_R 41 0
{TEXT 1 51 "\015From these tangent-values we compute the 4 angles
\012"}}{INP_R 42 0 "> "{TEXT 0 32 "X := map(x -> 2*arctan(x), [\"
]);"}}{OUT_R 43 0 42{DAG :3n3\`X`[2,5e3i4x001251457483i2x0009e3j4
x009380770498i2x0010e3j4x002274796772pAe3j4x002750972642pA}}
{COM_R 44 0{TEXT 1 146 "\015which are equal to the numerical resu
lts (modulo 2 Pi). In the following plot finally, the 4 solutions
 are shown for px=0.5, py=0.5 and a=-0.6..\012"}}{INP_R 45 0 "> "
{TEXT 0 192 "circle := plot([sin(t), cos(t), t=-Pi..Pi]):\012for 
i to 4 do\012  t.i := plot([a,0,cos(X[i]),sin(X[i]),px,py], style
=LINE):\012od:\012plots[display](\{circle,seq(t.i, i=1..4)\},view
=[-1.1..1.1,-1.1..1.1]);"}}{COM_R 46 0{TEXT 6 14 "\015Bibliograph
y\015"}}{COM_R 47 0{TEXT 1 795 "\012[1] R. Brent, \012Algorithms 
for Minimization Without Derivatives,\012Prentice-Hall, 1973.\012
\012[2] B.W. Char, K.O. Geddes, G.H. Gonnet, B.L. Leong, M.B. Mon
agan and S.M. Watt,\012Maple V Language/Reference Manual, Springe
r-Verlag, New York, 1991.\012\012[3] G.E. Forsythe, M.A. Malcolm 
and C.B. Moler,\012Computer Methods for Mathematical Computations
,\012Prentice-Hall, 1977.\012\012[4] W. Gander,\012On Halley's It
eration Method, \012The American Mathematical Monthly 92, 131-134
, 1985.\012\012[5] A. Griewank,\012On Automatic Differentiation,\
012Mathematical Programming, edited by M. Iri and K. Tanabe,\012K
luwer Academic Publishers, 83-107, 1989.\012\012[6] J. Joss,\012A
lgorithmisches Differenzieren,\012Dissertation Nr. 5757, ETH Zuer
ich, 1976.\012\012[7] L.B. Rall,\012Differentiation in Pascal-SC:
 Type GRADIENT,\012ACM Trans. Math. Software 10, 161-184, 1984."}
}{INP_R 48 0 "> "{TEXT 0 0 ""}}}{END}
