{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "lucidasansty
pewriter-bold-12" "lucidasanstypewriter-bold-12" "Courier" 4 12 
192 "Courier" 12}{FONT 1 "-adobe-times-medium-r-normal--17-*" "ti
mes" "Times-Roman" 4 17 64 "Times-Roman" 17}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-i-normal--17-*" "n
ew century schoolbook" "Times-BoldItalic" 8 17 96 "Times-BoldItal
ic" 17}{SCP_R 1 0 195{COM_R 2 0{TEXT 3 97 "\015Computing symbolic
 eigenvalues and eigenvectors in Maple.\015Michael Monagan, monag
an@inf.ethz.ch\015\015"}}{COM_R 3 0{TEXT 1 741 "This is a partly 
a tutorial on how to compute symbolic eigenvalues and eigenvector
s in Maple, and partly a collection of non-trivial examples to gi
ve an indication of the current limits of what can be done.  The 
main difficulty in computing symbolically is in handling roots of
 polynomials.  Maple has a facility called evala which computes w
ith roots of polynomials represented using Maples RootOf  notatio
n which often will yield better results, better in the sense that
 the results will be smaller, hence easier to understand, and als
o more efficiently computed.  Some discussion of how to compute w
ith these RootOf values is also given.\015\015Let's begin by load
ing the linear algebra package, inputting a matrix, and doing som
e calculations\015"}}{INP_R 4 0 "> "{TEXT 0 13 "with(linalg):"}}
{OUT_R 5 0 4{TEXT 2 71 "Warning: new definition for   norm\012War
ning: new definition for   trace\012"}}{INP_R 6 0 "> "{TEXT 0 39 
"A := matrix([[1,2,3],[2,3,4],[4,5,6]]);"}}{OUT_R 7 0 6{DAG :3n3\
`A`(3n4\`MATRIX`,2[2,4[2,4j2x0001j2x0002j2x0003[2,4pEp10j2x0004[2
,4p16j2x0005j2x0006}}{COM_R 8 0{TEXT 1 270 "The eigenvalues of A 
are the roots of the characteristic polynomial which is the deter
minant of the matrix lambda I - A, i.e. a polynomial of degree n 
in the variable lambda.  This polynomial is called the characteri
stic polynomial.  One way of computing it in Maple is\015"}}
{INP_R 9 0 "> "{TEXT 0 20 "cp := det(lambda-A);"}}{OUT_R 10 0 9
{DAG :3n3\`cp`+7n4\`lambda`i2x0009*3p4j2x0002i2x0010*3p4j2x0003j2
x0001}}{COM_R 11 0{TEXT 1 142 "\015In this case, the characterisi
tc is a cubic polynomial with integer coefficients.  We can use M
aple's solve function to solve for the roots\015 "}}{INP_R 12 0 "
> "{TEXT 0 17 "solve(cp,lambda);"}}{OUT_R 13 0 12{DAG ,4j2x0000+5
j2x0005j2x0001*3j2x0034/3p6j2x0002p6+5p4p6p8i2x0001}}{COM_R 14 0
{TEXT 1 88 "\015Alternatively, we could have done this in one ste
p using the builtin eigenvals command\015"}}{INP_R 15 0 "> "{TEXT
 0 18 "e := eigenvals(A);"}}{OUT_R 16 0 15{DAG :3n3\`e`,4j2x0000+
5j2x0005j2x0001*3j2x0034/3p9j2x0002p9+5p7p9pBi2x0001}}{COM_R 17 0
{TEXT 1 442 "\015Notice, that instead of getting decimal approxim
ations for the eigenvalues, which is what a numerical piece of so
ftware would give, Maple has computed the exact algebraic values 
for the eigenvalues.  You can get Maple to compute numerical eige
nvalues and eigenvectors too if you wish.  Maple will do this aut
omatically for you if one or more of the inputs entries of the ma
trix is a decimal number.  Let's just do this to see the differen
ce\015"}}{INP_R 18 0 "> "{TEXT 0 18 "B := map(evalf,A);"}}{OUT_R 
19 0 18{DAG :3n3\`B`(3n4\`MATRIX`,2[2,4[2,4e3j2x0001j2x0000e3j2x0
002pFe3j2x0003pF[2,4p11p15e3j2x0004pF[2,4p1De3j2x0005pFe3j2x0006p
F}}{INP_R 20 0 "> "{TEXT 0 13 "eigenvals(B);"}}{OUT_R 21 0 20{DAG
 ,4e3j4x001083095193i2x0008e3i4x008309518937i2x0010e3i3x30575333i
2x0017}}{COM_R 22 0{TEXT 1 339 " \015We see immediately one of th
e difficulties of working numerically.  The eigenvalue 0 is not q
uite 0.   In this tutorial we are mainly interested in computing 
exact formulae for the eigenvalues.  Let's continue by computing 
the eigenvectors for A. They are the solutions to A x = lambda x,
 i.e. the nullspace of the matrix  lambda  I - A."}}{COM_R 23 0
{TEXT 1 0 ""}}{INP_R 24 0 "> "{TEXT 0 18 "nullspace(e[1]-A);"}}
{OUT_R 25 0 24{DAG %2,2(3n4\`VECTOR`,2[2,4j2x0001i2x0002p9}}
{INP_R 26 0 "> "{TEXT 0 18 "nullspace(e[2]-A);"}}{OUT_R 27 0 26
{DAG %2,2(3n4\`VECTOR`,2[2,4+5/3i2x0004j2x0011j2x0001*3j2x0034/3p
Fj2x0002/3j2x0003j2x0022+5/3pFpDpFp11p1EpF}}{INP_R 28 0 "> "{TEXT
 0 18 "nullspace(e[3]-A);"}}{OUT_R 29 0 28{DAG %2,2(3n4\`VECTOR`,
2[2,4+5/3i2x0004j2x0011j2x0001*3j2x0034/3pFj2x0002/3i2x0003j2x002
2+5/3pFpDpFp11/3i2x0001pDpF}}{COM_R 30 0{TEXT 1 172 "\015It is a 
little bit tricky to read because Maple does not put enough space
 between the entries in these vectors.  Alternatively, one can us
e the builtin eigenvects command\015"}}{INP_R 31 0 "> "{TEXT 0 27
 "e := eigenvects(A,radical);"}}{OUT_R 32 0 31{DAG :3n3\`e`,4[2,4
+5j2x0005j2x0001*3j2x0034/3p9j2x0002p9p9%2,2(3n4\`VECTOR`,2[2,4+5
/3i2x0004j2x0011p9pB/3j2x0003j2x0022+5/3p9p21p9pBp2Bp9[2,4+5p7p9p
Bi2x0001p9%2,2(3p17,2[2,4+5p1Ep9pB/3i2x0003p28+5p2Bp9pB/3p38p21p9
[2,4j2x0000p9%2,2(3p17,2[2,4p9i2x0002p9}}{COM_R 33 0{TEXT 1 709 "
\015The output consists of a sequence of tripples of the form [e,
 m, b] where e is an eigenvalue, m it's multiplicity, and b a bas
is for the eigenspace for e, a set of vectors in Maple.  We will 
explain the option `radical' in a moment.  Let us now show that t
he results are correct, and in doing so, show how the user\015can
 access each of the eigenvectors.  If x[i] is the eigenvector for
 the eigenvalue lambda[i], then x[i] satisfies A x = lambda x.  T
hus (lambda I - A) x = 0.  The matrix lambda I - x is called the 
characteristic matrix.  One way to construct it is to use the bui
ltin function charmat(A,lambda).  We'll use Maple directly.  We p
ick off the first eigenvalue and it's corresponding eigenvector.\
015"}}{INP_R 34 0 "> "{TEXT 0 33 "e1 := e[1][1]; v1 := e[1][3][1]
; "}}{OUT_R 35 0 34{DAG :3n3\`e1`+5j2x0005j2x0001*3j2x0034/3p6j2x
0002p6}}{OUT_R 36 0 34{DAG :3n3\`v1`(3n4\`VECTOR`,2[2,4+5/3i2x000
4j2x0011j2x0001*3j2x0034/3p10j2x0002/3j2x0003j2x0022+5/3p10pEp10p
12p1Fp10}}{INP_R 37 0 "> "{TEXT 0 24 "evalm( (e1 - A) &* v1 );"}}
{OUT_R 38 0 37{DAG (3n4\`VECTOR`,2[2,4j2x0000p7p7}}{COM_R 39 0
{TEXT 1 155 "\015So far, so good.  Infact, it all works for matri
ces containing formulae as well as numbers.  For example, here is
 a matrix with 3 parameters, a,b, and c \015"}}{INP_R 40 0 "> "
{TEXT 0 25 "T := toeplitz( [a,b,c] );"}}{OUT_R 41 0 40{DAG :3n3\`
T`(3n4\`MATRIX`,2[2,4[2,4n3\`a`n3\`b`n3\`c`[2,4pEpCpE[2,4p10pEpC}
}{INP_R 42 0 "> "{TEXT 0 21 "eigenvals(T,radical);"}}{OUT_R 43 0 
42{DAG ,4+5n3\`a`j2x0001n3\`c`i2x0001+7p2p4p6/3p4j2x0002*3+5*3p6p
10p4*3n3\`b`p10j2x0008pEpE+7p2p4p6pEp12/3p8p10}}{INP_R 44 0 "> "
{TEXT 0 27 "e := eigenvects(T,radical);"}}{OUT_R 45 0 44{DAG :3n3
\`e`,4[2,4+5n3\`a`j2x0001n3\`c`i2x0001p9%2,2(3n4\`VECTOR`,2[2,4pD
j2x0000p9[2,4+7p7p9pB/3p9j2x0002*3+5*3pBp25p9*3n3\`b`p25j2x0008p2
3p23p9%2,2(3p13,2[2,4p9+3*5+5pBp23p27/3pDp25p9p2EpDpDp9[2,4+7p7p9
pBp23p27p44p9%2,2(3p13,2[2,4p9+3*5+5pBp23p27p23p9p2EpDpDp9}}
{COM_R 46 0{TEXT 1 103 "\015A little bit more complicated, but ac
tually, very nice.  Let's just check the first eigenvector again.
"}}{COM_R 47 0{TEXT 1 443 "Things however do get complicated when
 the characteristic polynomial does not factor into linear or qua
dratic factors.  Because then the formulae for the roots of a cub
ic polynomial in general are messy, and a quartic polynomial are 
even worse.  And of course,\015in general, there is no way to exp
ress the roots of a quintic or higher degree polynomial in terms 
of exact radicals.  Let's consider a slight change, a purtubation
  to our A matrix\015"}}{INP_R 48 0 "> "{TEXT 0 25 "T[2,1] := T[2
,1]+epsilon;"}}{OUT_R 49 0 48{DAG :3b3n3\`T`,3j2x0002j2x0001+5n3\
`b`p7n4\`epsilon`p7}}{INP_R 50 0 "> "{TEXT 0 20 "cp := det(lambda
-T);"}}{OUT_R 51 0 50{DAG :3n3\`cp`+1D*3n3\`a`j2x0003i2x0001*5p5j
2x0002n4\`lambda`j2x0001p7*5p5p12pFpDi2x0003*5p5p12n3\`b`pDpD*3pF
p7p12*5pFp12p1FpDi2x0002*7p1Fp12n4\`epsilon`p12p5p12pD*7p1Fp12p31
p12pFp12p2C*5n3\`c`p12p1FpDp2C*5p31pDp5p12p12*5p31pDpFp12p9*7p31p
12p41p12p1Fp12p2C*5p41pDp5p12p12*5p41pDpFp12p9}}{INP_R 52 0 "> "
{TEXT 0 11 "factor(cp);"}}{OUT_R 53 0 52{DAG +1D*3n3\`a`j2x0003i2
x0001*5p2j2x0002n4\`lambda`j2x0001p4*5p2pFpCpAi2x0003*5p2pFn3\`b`
pApA*3pCp4pF*5pCpFp1CpAi2x0002*7p1CpFn4\`epsilon`pFp2pFpA*7p1CpFp
2EpFpCpFp29*5n3\`c`pFp1CpAp29*5p2EpAp2pFpF*5p2EpApCpFp6*7p2EpFp3E
pFp1CpFp29*5p3EpAp2pFpF*5p3EpApCpFp6}}{COM_R 54 0{TEXT 1 174 "\01
5We see that the characteristic polynomial does not factor, and c
onsequently, the roots for this cubic polynomial computed by Mapl
e below are ``messy'', and of limitted use.\015"}}{INP_R 55 0 "> 
"{TEXT 0 17 "solve(cp,lambda);"}}{OUT_R 56 0 55{DAG ,4+7*3+7*5n3\
`c`j2x0001n3\`b`j2x0002p7*7n4\`epsilon`p7p5p7p9p7p7*3+21*7p9p7pFp
7p5j2x0004i2x0018*5p9j2x0003pFp26i2x0096*5p9j2x0005pFp7i2x0072*3p
Fj2x0006i2x0003*3p5p36p38*5p9p20pFpBi2x0108*5p9pBpFp20i2x0054*5p9
pBp5p20p22*5p9p7pFp2Ep22*5pFp20p5pBi2x0009*5pFpBp5p20p5D*7p9p26pF
p7p5pBj2x0090*7p9pBpFpBp5pBj2x0009*7p9p7pFp26p5pBi2x0036*5p9p20p5
pBj2x0045*3p9p36i2x0024/3p7pB/3p7p75/3p7p26p7*5+9*3p9pB/3i2x0002p
26*5p9p7pFp7p9B*3pFpB/3i2x0001p26*3p5pBpA8p7p3pA8pA9n3\`a`p7+9p2/
3pA9pBp96p8CpB4p7*7n3\`I`p7p26p8C+5p2p7p96p7p7p8C+9p2pB9p96p8CpB4
p7pC0pB9}}{COM_R 57 0{TEXT 1 798 "\015Now the eigenvectors will b
e vectors whose entries are functions of these messy eigenvalues.
  Infact, you will probably not be surprised to hear that Maple w
ill have difficulty in computing with these nested radicals.  Inf
act, Maple will have difficulty in simply showing that these eige
nvalues are roots of the characteristic polynomial.  Computing wi
th nested radicals is a known difficult computational problem.  N
ow in order to compute the eigenvectors, we are are going to swit
ch to a new notation if you like, for the roots of the characteri
stic polynomial.  Instead of solving them in terms of exact radic
als, and then proceeding to compute the eigenvectors in terms of 
these radicals, we will introduce an new variable alpha to denote
 the roots of the characteristic polynomial.  In Maple\015"}}
{INP_R 58 0 "> "{TEXT 0 33 "alias( alpha=RootOf(cp,lambda) );"}}
{OUT_R 59 0 58{DAG ,3n3\`I`n4\`alpha`}}{COM_R 60 0{TEXT 1 390 "\0
15In one sense, we are cheating, we are just doing what every mat
hematician does whenever he gets an expression which is too big t
o work with, namely, he gives it a label.  But infact, we are not
 cheating, because Maple knows how to compute with alpha, i.e. ho
w to add, subtract, multiply and divide formulae involving alpha.
  It knows that alpha is a root of the characteristic polynomial.
\015"}}{INP_R 61 0 "> "{TEXT 0 15 "f := 1/(alpha);"}}{OUT_R 62 0 
61{DAG :3n3\`f`*3n4\`alpha`i2x0001}}{INP_R 63 0 "> "{TEXT 0 14 "g
 := evala(f);"}}{OUT_R 64 0 63{DAG :3n3\`g`*5+F*3n4\`alpha`j2x000
2j2x0001*5n3\`a`pBp6pBi2x0003*3pEp9j2x0003*3n3\`b`p9i2x0002*5p1Bp
Bn4\`epsilon`pBp1E*3p23p9i2x0001*3n3\`c`p9p2BpB+F*3pEp18pB*5pEpBp
1Bp9p1E*7p1BpBp23pBpEpBp1E*5p2EpBp1Bp9p9*5p23p9pEpBp2B*7p23pBp2Ep
Bp1BpBp9*5p2Ep9pEpBp2Bp2B}}{INP_R 65 0 "> "{TEXT 0 11 "evala(1/g)
;"}}{OUT_R 66 0 65{DAG n4\`alpha`}}{COM_R 67 0{TEXT 1 416 "\015No
w when we compute the eigenvectors, Maple is going to compute the
m as a function of alpha.  The output will be much simpler than i
t would be if we used the nested radical representation for the r
oots of the characteristic polynomial. The reader is encouraged t
o try instead eigenvects(A,radical); to force Maple to compute th
e eigenvectors in terms of exact radicals to see for himself how 
much simpler they are.\015"}}{INP_R 68 0 "> "{TEXT 0 14 "eigenvec
ts(T);"}}{OUT_R 69 0 68{DAG [2,4n4\`alpha`j2x0001%2,2(3n4\`VECTOR
`,2[2,4*5+13*3n3\`b`j2x0003i2x0001*7p13p5n3\`a`p5p2p5i2x0002*5p13
p5p2j2x0002p5*5n3\`c`p27p13p5p17*5p13p5p1Cp27p5*7p2p5p2Bp5p13p5p1
7*7p2p5n4\`epsilon`p5p2Bp5p17*7p1Cp5p2Bp5p13p5p5*7p1Cp5p42p5p2Bp5
p5p5+9p12p5*5p42p5p13p27p5p2Ap17*5p42p5p2Bp27p17p17+3*5+13*5p2p5p
13p27p17*5p2Bp5p13p27p17*5p1Cp5p13p27p5*7p2p5p13p5p42p5p17*7p13p5
p42p5p1Cp5p5*7p1Cp5p2p5p2Bp5p21*5p2p27p2Bp5p5*3p2Bp15p17*5p1Cp27p
2Bp5p5p5p5Ap17p17p5}}{COM_R 70 0{TEXT 1 567 "\015Now, it would ap
pear that there is only one eigenvalue here, alpha.  But it reall
y stands for the three eigenvalues, the roots of the cubic charac
teristic polynomial.  So if the user wants the three eigenvectors
 explicitly, what needs to be done is to solve the cubic polynomi
al, and substitute alpha for each of the three solutions.  Let us
 now give an example which shows the limits of this symbolic appr
oach, in the sense that this is a very nice result, but if the pr
oblem was slighly larger, a nice result could not be given.  We a
re given the following matrix\015"}}{INP_R 71 0 "> "{TEXT 0 12 "A
 := matrix("}}{INP_R 72 0 "> "{TEXT 0 105 "[[-a1/a2, 1/a2, 0, 1/(
R*a2)],\012 [1, 0, 0, 0],\012 [-q1*a1/a2, q1/a2, 0, a2 + q1/(a2*R
)],\012 [q2, 0, 1, a1]] );\012"}}{OUT_R 73 0 72{DAG :3n3\`A`(3n4\
`MATRIX`,2[2,5[2,5+3*5n3\`a1`j2x0001n3\`a2`i2x0001p14*3p12p14j2x0
000*5n3\`R`p14p12p14[2,5p10p1Ap1Ap1A[2,5+3*7n3\`q1`p10pEp10p12p14
p14*5p2Cp10p12p14p1A+5p12p10*7p2Cp10p1Dp14p12p14p10[2,5n3\`q2`p1A
p10pE}}{INP_R 74 0 "> "{TEXT 0 20 "cp := det(lambda-A);"}}{OUT_R 
75 0 74{DAG :3n3\`cp`*7n3\`a2`i2x0001+17*7n4\`lambda`j2x0002n3\`R
`j2x0001n3\`a1`pDp6*7p13p11pAj2x0003pFp11p11*9pAp11pFp11p4p11p13p
11p6*9p13p11pAp1BpFp11p4p11p6*7pAj2x0004p4p11pFp11p11*7pApDp4pDpF
p11p6*5pApDn3\`q1`p11p6*7pAp11pFp11p13p11p11*5pApDpFp11p6*5pFp11p
4p11p11*5n3\`q2`p11pApDp6p11pFp6}}{INP_R 76 0 "> "{TEXT 0 11 "fac
tor(cp);"}}{OUT_R 77 0 76{DAG *7n3\`a2`i2x0001+17*7n4\`lambda`j2x
0002n3\`R`j2x0001n3\`a1`pAp3*7p10pEp7j2x0003pCpEpE*9p7pEpCpEp1pEp
10pEp3*9p10pEp7p18pCpEp1pEp3*7p7j2x0004p1pEpCpEpE*7p7pAp1pApCpEp3
*5p7pAn3\`q1`pEp3*7p7pEpCpEp10pEpE*5p7pApCpEp3*5pCpEp1pEpE*5n3\`q
2`pEp7pAp3pEpCp3}}{COM_R 78 0{TEXT 1 409 "\015So the characterist
ic polynomial does not factor.  We are expecting very complicated
 roots for this polynomial if we try to solve for lambda.  Howeve
r, if you inspect the polynomial, you will notice that it is symm
etric, i.e. coeff(cp,lambda,4) = coeff(cp,lambda,0) and coeff(cp,
lambda,3) = coeff(cp,lambda,1).  So solve is able to use a ration
al decomposition to find the roots in a relatively simple form.\0
15"}}{INP_R 79 0 "> "{TEXT 0 17 "solve(cp,lambda);"}}{OUT_R 80 0 
79{DAG ,5+5*7+7*7n3\`R`j2x0001n3\`a2`p7n3\`a1`p7p7*5p5p7pCp7i2x00
01*3+11*7p5j2x0002p9p1BpCp1Bp7*7p5p1Bp9p7pCp1Bp1B*5p5p1BpCp1Bp7*5
p5p1Bp9j2x0003j2x0004*7p5p7p9p7n3\`q1`p7p36*5p5p1Bp9p7p36*7p5p7p9
p7n3\`q2`p7p36*5p5p1Bp9p1Bj2x0008/3p7p1Bp7p7p5p15p9p15/3p7p36*7p1
Bp57p9p15*5p5p15+13*7p5p7p9p1BpCp1Bp7*7p9p7pCp7p18p57p7*5p5p7pCp1
Bp7*5pCp7p18p57p15*5p5p7p9p34p1B*5p9p7p3Dp7p1B*5p5p7p9p7p1B*5p9p7
p4Cp7p1B*5p5p7p9p1Bi2x0004p7p57p60+5p2p60p63/3p15p36+5*7+7p4p7p10
p15p17p15p7p5p15p9p15p60*7p1Bp57p9p15*5p5p15+13p6Cp7p74p15p7Cp7p8
2p7p88p1Bp8Ep1Bp94p1Bp9Ap1BpA0pA5p7p57p60+5pB2p60pC0pAE}}{COM_R 
81 0{TEXT 1 167 "\015The eigenvectors also turn out to be not too
 complicated when we allow Maple to use it's RootOf notation. The
 eigenvects command uses the RootOf notation by default.\015"}}
{INP_R 82 0 "> "{TEXT 0 14 "eigenvects(A);"}}{OUT_R 83 0 82{DAG [
2,4(3n4\`RootOf`,2+B*7n3\`_Z`j2x0004n3\`a2`j2x0001n3\`R`pFpF*5+5*
7p11pFpDpFn3\`a1`pFi2x0001*5p11pFp1CpFpFpFp9j2x0003pF*5+B*5p11pFp
1Cj2x0002p1F*5p11pFpDp32p1Fn3\`q1`p1Fp11p1Fn3\`q2`p1FpFp9p32pF*5p
16pFp9pFpF*5p11pFpDpFpFpF%2,2(3n4\`VECTOR`,2[2,5+3*7+11*5p2pFp3Bp
FpF*9p2p32p1CpFp11pFpDpFpF*7p2pFp11pFpDp32pF*7p1CpFp2p32p11pFp1F*
7p2pFp1Cp32p11pFpFp17pF*7p2p29p11pFpDpFp1F*5p2pFp40pFpFpFp11p1F+5
p3BpFp40pFp1Fp1F+3*7+1Bp3BpF*7p3BpFp2pFp1CpFpF*9pDp32p2pFp1CpFp11
pFpF*7p11pFpDpFp1Cp32pF*9p2pFp1CpFp11pFpDpFpF*7p1CpFp2pFp40pFpFp3
5pF*7p2p32p1Cp32p11pFp1F*9p2p32p11pFp1Cp32pDpFpF*9p2p29p1CpFp11pF
pDpFp1F*7p2pFp11pFp1Cp29pF*7p11pFpDpFp2p32p1Fp40pFpFp11p1Fp9Bp1Fp
1F*7+19*7p11pFp3BpFp2pFpF*7p11pFp3BpFp1CpFp1F*9p40pFp2pFp1Cp32p11
pFpF*7p3BpFp40pFp2pFpF*5p40p32p2pFpF*9pDpFp40pFp11pFp1CpFpF*9pDp3
2p40pFp2pFp11pFpF*9pDpFp40pFp2p29p11pFp1F*7p40pFp2pFp11pFpF*BpDpF
p40pFp2p32p1CpFp11pFpF*9p40pFp2p32p1CpFp11pFp1F*7p40pFp11pFp1CpFp
1FpFp11p1Fp9Bp1FpF}}{COM_R 84 0{TEXT 1 305 "\015Notice that the o
utput is in terms of %1, a RootOf.  It is a polynomial of degree 
4 in the variable _Z.  We could substitute %1 for any of the 4 so
lutions that we computed above if we wanted to.  Here is another 
worked example, of a matrix where the characteristic polynomial f
actors into three factors.\015"}}{INP_R 85 0 "> "{TEXT 0 156 "B :
= matrix(6,6,\012        [0,0,0,0,0,a,\012         0,1,0,0,0,-b,\
012         0,0,0,-a,b,0,\012         0,0,-c,0,0,0,\012         0
,0,d,0,0,0,\012         c,-d,0,2,0,0] );\012"}}{OUT_R 86 0 85{DAG
 :3n3\`B`(3n4\`MATRIX`,2[2,7[2,7j2x0000pCpCpCpCn3\`a`[2,7pCj2x000
1pCpCpC+3n3\`b`i2x0001[2,7pCpCpC+3p12p1Fp1DpC[2,7pCpC+3n3\`c`p1Fp
CpCpC[2,7pCpCn3\`d`pCpCpC[2,7p30+3p3Ap1FpCj2x0002pCpC}}{INP_R 87 
0 "> "{TEXT 0 25 "cp := charpoly(B,lambda);"}}{OUT_R 88 0 87{DAG 
:3n3\`cp`+17*3n4\`lambda`j2x0006j2x0001*3p5j2x0005i2x0001*7p5j2x0
004n3\`b`pAn3\`d`pAi2x0002*7p5p14n3\`c`pAn3\`a`pAp1C*7p5j2x0003p1
6pAp19pApA*7p5p2Ap21pAp24pAj2x0002*7p5p38p16p38p19p38pA*Bp5p38p21
pAp24pAp16pAp19pAp38*7p5p38p21p38p24p38pA*Bp5pAp21pAp24pAp16pAp19
pAp10*7p5pAp21p38p24p38p10}}{INP_R 89 0 "> "{TEXT 0 16 "f := fact
or(cp);"}}{OUT_R 90 0 89{DAG :3n3\`f`*7n4\`lambda`j2x0001+7*5n3\`
b`p7n3\`d`p7p7*3p4j2x0002i2x0001*5n3\`c`p7n3\`a`p7p7p7+B*7pBp7pEp
7p4p7p7*3p4j2x0003p16p12p7p18p16*7p19p7p1Cp7p4p7p7p7}}{COM_R 91 0
{TEXT 1 403 "\015From the factorization of the characteristic pol
ynomial, we see that one of the eigenvalues is 0, that two of the
 eigenvalues are + - sqrt(ac + bd), but the three others will be 
the roots of a cubic polynomial, so rather messy.  Proceeding thi
s time one step at a time, lets compute the eigenvector correspon
ding to the eigenvalue 0 by computing the nullspace of the charac
teristic matrix lambda I - A\015"}}{INP_R 92 0 "> "{TEXT 0 18 "C 
:= charmat(B,0);"}}{OUT_R 93 0 92{DAG :3n3\`C`(3n4\`MATRIX`,2[2,7
[2,7j2x0000pCpCpCpC+3n3\`a`i2x0001[2,7pCp15pCpCpCn3\`b`[2,7pCpCpC
p13+3p1Ep15pC[2,7pCpCn3\`c`pCpCpC[2,7pCpC+3n3\`d`p15pCpCpC[2,7+3p
2Ep15p38pCi2x0002pCpC}}{INP_R 94 0 "> "{TEXT 0 13 "nullspace(C);"
}}{OUT_R 95 0 94{DAG %2,2(3n4\`VECTOR`,2[2,7j2x0001j2x0000pB+3n3\
`c`/3i2x0001j2x0002+3*7n3\`b`p12n3\`a`p9pFp9p11pB}}{COM_R 96 0
{TEXT 1 73 "\015Now for the quadratic factor, here is the eigenve
ctor for + sqrt(ac+bd)\015"}}{INP_R 97 0 "> "{TEXT 0 31 "C := cha
rmat(B, sqrt(a*c+b*d));"}}{OUT_R 98 0 97{DAG :3n3\`C`(3n4\`MATRIX
`,2[2,7[2,7*3+5*5n3\`c`j2x0001n3\`a`p11p11*5n3\`b`p11n3\`d`p11p11
/3p11j2x0002j2x0000p23p23p23+3p13i2x0001[2,7p23+5pCp11p2Ap11p23p2
3p23p18[2,7p23p23pCp13+3p18p2Ap23[2,7p23p23pFpCp23p23[2,7p23p23+3
p1Bp2Ap23pCp23[2,7+3pFp2Ap1Bp23i2x0002p23pC}}{INP_R 99 0 "> "
{TEXT 0 13 "nullspace(C);"}}{OUT_R 100 0 99{DAG %2,2(3n4\`VECTOR`
,2[2,7+3*9n3\`a`j2x0001+5*3+5*5n3\`c`pDpBpDpD*5n3\`b`pDn3\`d`pDpD
/3pDj2x0002pDi2x0001pDpDp1Ap26p11/3p26p23p26pD+3*5p1DpDp13p26p2D+
3*5p1DpDp11p2Dp21+3*7p1Dp23p11p2Dp13p26p2D+3*5pFpDp1Ap26p26}}
{COM_R 101 0{TEXT 1 167 "\015Now for the cubic factor.  Let's not
 use the radical notation here.  Let's use the RootOf notation.  
First, let's give the roots of the cubic polynomial a label, beta
"}}{INP_R 102 0 "> "{TEXT 0 37 "alias( beta=RootOf(op(3,f),lambda
) );"}}{OUT_R 103 0 102{DAG ,4n3\`I`n4\`alpha`n4\`beta`}}{INP_R 
104 0 "> "{TEXT 0 21 "C := charmat(B,beta);"}}{OUT_R 105 0 104
{DAG :3n3\`C`(3n4\`MATRIX`,2[2,7[2,7n4\`beta`j2x0000pFpFpF+3n3\`a
`i2x0001[2,7pF+5pCj2x0001p17p1EpFpFpFn3\`b`[2,7pFpFpCp15+3p25p17p
F[2,7pFpFn3\`c`pCpFpF[2,7pFpF+3n3\`d`p17pFpCpF[2,7+3p35p17p3FpFi2
x0002pFpC}}{INP_R 106 0 "> "{TEXT 0 13 "nullspace(C);"}}{OUT_R 
107 0 106{DAG %2,2(3n4\`VECTOR`,2[2,7*7+7*3n4\`beta`j2x0002i2x000
1pCj2x0001*5n3\`b`p14n3\`d`p14p14p14n3\`c`p11p17p11p14j2x0000p25p
25+3*5+5pCp14p11p14p14p17p11p11}}{COM_R 108 0{TEXT 1 74 "\015Fina
lly, lets automate the entire procedure using the eigenvects comm
and."}}{INP_R 109 0 "> "{TEXT 0 14 "eigenvects(B);"}}{OUT_R 110 0
 109{DAG ,4[2,4n4\`beta`j2x0001%2,2(3n4\`VECTOR`,2[2,7*5+9*3p3j2x
0002i2x0001p3p6*5n3\`c`p6n3\`a`p6p6*5n3\`b`p6n3\`d`p6p6p6p1Cp17*5
+7p13p17p1Bp6p23p6p6p27p17j2x0000p39p39p6[2,4p39p6%2,2(3pB,2[2,7p
6p39p39+3p1C/3p17p15+3*7p24p17p1Fp6p1Cp6p4Ep39[2,4(3n4\`RootOf`,2
+7p1Bp17p23p17*3n3\`_Z`p15p6p6%2,2(3pB,2[2,7*7p5Dp6p1Fp6+5p1Bp6p2
3p6p17+3*7p24p6+5p5Dp6p6p6p6+7p1Bp6p23p6p17p6p17p17+3*Bp83p6p24p6
p27p6p89p17p1Cp17/3p6p15+3*9p24p6p27p6+7p5Dp6p1Bp6p23p6p6+B*5p1Cp
15p1Fp15p6*9p1Cp6p1Fp6p24p6p27p6p15p1Bp17*5p24p15p27p15p6p23p17p1
7p4E+3*Bp27p15p24p6pA7p6p1Cp17pAFp17p9Ep6}}{COM_R 111 0{TEXT 1 
846 "\015We can see that the eigenvector for beta is different fr
om the one we computed previously.  What has happened is that Map
le has made a different entry equal to 1, the second entry, by di
viding through.  But the eigenvectors do agree up to multplicatio
n by a constant.  The roots of the quadratic polynomial are displ
ayed  using a RootOf because we have not given an alias for this 
RootOf.\015\015We wish now to say something about the limitations
 of Maple.  Will it work for complex matrices?  Will it work for 
matrices which have algebraic numbers and functions in them, e.g.
 sqrt(2) or sqrt(1+x)?   Yes it will.  And the main facility that
 makes this possible is Maples factor command which can factor po
lynomials over algebraic number fields and, in Release 2, algebra
ic function fields.  This example will show what we mean. Conside
r this matrix\015\015"}}{INP_R 112 0 "> "{TEXT 0 35 "T := toeplit
z( [sqrt(2),x,omega] );"}}{OUT_R 113 0 112{DAG :3n3\`T`(3n4\`MATR
IX`,2[2,4[2,4*3j2x0002/3j2x0001pDn3\`x`n4\`omega`[2,4p13pCp13[2,4
p15p13pC}}{INP_R 114 0 "> "{TEXT 0 20 "cp := det(lambda-T);"}}
{OUT_R 115 0 114{DAG :3n3\`cp`+13*3j2x0002/3j2x0001p5i2x0002n4\`l
ambda`j2x0006*5p5p7pDp5i2x0003*5p5p7n3\`x`p5p5*3pDj2x0003p8*5pDp8
p1Cp5pB*5n4\`omega`p8p1Cp5pB*5p2Cp5p5p7p8*5p2Cp5pDp8i2x0001}}
{COM_R 116 0{TEXT 1 279 "\015The eigenvalues are of course the ro
ots of this polynomial.  We could use the general formula for a c
ubic polynomial to find them, but, it turns out that the polynomi
al factors.  The factorization needs to be done over the algebrai
c number field with the sqrt(2) in it.  We get\015"}}{INP_R 117 0
 "> "{TEXT 0 11 "factor(cp);"}}{OUT_R 118 0 117{DAG +3*5+D*3n4\`l
ambda`j2x0002i2x0001*5p7/3j2x0001p7p4pEp7*5n4\`omega`pEp4pEpEi2x0
002pE*5p15pEp7pDp9*3n3\`x`p7p7pE+7p4pEp15pE*3p7pDp9pEp9}}{INP_R 
119 0 "> "{TEXT 0 13 "eigenvals(T);"}}{OUT_R 120 0 119{DAG ,4+7*3
j2x0002/3j2x0001p3p6n4\`omega`p5*3+5*3pAp3p6*3n3\`x`p3j2x0008p5/3
i2x0001p3+7p2p6pAp5pEp5+5pAp1Cp2p6}}{COM_R 121 0{TEXT 1 128 "\015
Some more examples with computing over algebraic number fields.  
Suppose we have the polynomial below and we try to factor it.\015
"}}{INP_R 122 0 "> "{TEXT 0 11 "p := x^4-4;"}}{OUT_R 123 0 122
{DAG :3n3\`p`+5*3n3\`x`j2x0004j2x0001i2x0004p9}}{INP_R 124 0 "> "
{TEXT 0 10 "factor(p);"}}{OUT_R 125 0 124{DAG *5+5*3n3\`x`j2x0002
j2x0001i2x0002p7p7+5p2p7p5p7p7}}{COM_R 126 0{TEXT 1 418 "\015Obse
rve that the polynomial has not been factored into linear factors
.  The factor command factors a polynomial over the field implied
 by the coefficients in the input.  In this example, the coeffici
ents are integers.  So factor finds all irreducible factors with 
integer coefficients.  To factor the polynomial into linear facto
rs, we have to introduce the sqrt(2) and the complex unit sqrt(-1
) which is I in Maple.\015"}}{INP_R 127 0 "> "{TEXT 0 18 "factor(
p,sqrt(2));"}}{OUT_R 128 0 127{DAG *7+5*3n3\`x`j2x0002j2x0001p5p7
p7+5p3p7*3p5/3p7p5i2x0001p7+5p3p7pFp7p7}}{INP_R 129 0 "> "{TEXT 0
 12 "factor(p,I);"}}{OUT_R 130 0 129{DAG *5+5*3n3\`x`j2x0002j2x00
01i2x0002p7p7+5p2p7p5p7p7}}{INP_R 131 0 "> "{TEXT 0 22 "factor(p,
\{sqrt(2),I\});"}}{OUT_R 132 0 131{DAG *9+5n3\`x`j2x0001*5n3\`I`p
4j2x0002/3p4pAi2x0001p4+5p2p4p6p4p4+5p2p4*3pApCpFp4+5p2p4p1Bp4p4}
}{COM_R 133 0{TEXT 1 263 "\015Now this ability to factor polynomi
als over different number fields is exploited in the eigenvalues 
and eigenvectors commands to  simplify the eigenvalues.  The faci
lities in Maple also extend to algebraic functions, for example, 
sqrt(y).  Consider this example\015"}}{INP_R 134 0 "> "{TEXT 0 13
 "p := x^4-4*y;"}}{OUT_R 135 0 134{DAG :3n3\`p`+5*3n3\`x`j2x0004j
2x0001n3\`y`i2x0004}}{INP_R 136 0 "> "{TEXT 0 10 "factor(p);"}}
{OUT_R 137 0 136{DAG +5*3n3\`x`j2x0004j2x0001n3\`y`i2x0004}}
{INP_R 138 0 "> "{TEXT 0 18 "factor(p,sqrt(y));"}}{OUT_R 139 0 
138{DAG *5+5*3n3\`x`j2x0002j2x0001*3n3\`y`/3p7p5p5p7+5p2p7p9i2x00
02p7}}{COM_R 140 0{TEXT 1 85 "\015Now here is an example where of
 a matrix where this factorization capability helps.\015"}}{INP_R
 141 0 "> "{TEXT 0 41 "T := toeplitz([sqrt(1+x), sqrt(2), 1+x]);"
}}{OUT_R 142 0 141{DAG :3n3\`T`(3n4\`MATRIX`,2[2,4[2,4*3+5j2x0001
pEn3\`x`pE/3pEj2x0002*3p16p14pD[2,4p18pCp18[2,4pDp18pC}}{INP_R 
143 0 "> "{TEXT 0 25 "cp := charpoly(T,lambda);"}}{OUT_R 144 0 
143{DAG :3n3\`cp`+15*3n4\`lambda`j2x0003j2x0001*5p5j2x0002+5pApAn
3\`x`pA/3pApEi2x0003p5i2x0002*5p13pAp5pApA*3p10p16j2x0004*5p13pAp
10p16pAi2x0004pAp13p2F*5p5pAp13pEi2x0001*5p13pEp10p16pA}}{INP_R 
145 0 "> "{TEXT 0 21 "factor(cp,sqrt(1+x));"}}{OUT_R 146 0 145
{DAG +3*5+11*3n4\`lambda`j2x0002i2x0001*5p4j2x0001+5pDpDn3\`x`pD/
3pDp7p7*5p12pDp4pDpDp4pDj2x0003pDp12p9*5p12pDpFp15p9*3pFp15p9pD+9
p4pDp12pDp2Cp9pDpDpDp9}}{INP_R 147 0 "> "{TEXT 0 14 "eigenvects(T
);"}}{OUT_R 148 0 147{DAG ,4[2,4+9*3+5j2x0001p6n3\`x`p6/3p6j2x000
2p6p9pCpCp6*3+7j2x0017p6p9pE*3p9pEp6pCpCp6%2,2(3n4\`VECTOR`,2[2,4
p6+9*5pEpCp3p6pC*5p5pCpEpC/3i2x0001pE*3pEpCp39*5pEpCp9p6p39p6[2,4
+9p4p6p9pCpCp6p15p39p6%2,2(3p26,2[2,4p6+9*5pEpCp4Ap6pCp34p39p3Dp3
9p41p39p6[2,4+7p9p3Ap4p6p3Ap6p6%2,2(3p26,2[2,4p3Aj2x0000p6}}
{COM_R 149 0{TEXT 1 64 "\015Finally, an example from physics, als
o involving square roots.\015"}}{INP_R 150 0 "> "{TEXT 0 90 "s :=
 (2*t^2+2*t)^(1/2):\012P := matrix(3,3,[t*(t+1), s, 0, s, t*(t+1)
+2, s, 0, s, t*(t+1)]);\012"}}{OUT_R 151 0 150{DAG :3n3\`P`(3n4\`
MATRIX`,2[2,4[2,4*5n3\`t`j2x0001+5pDpFpFpFpF*3+5*3pDj2x0002p1BpDp
1B/3pFp1Bj2x0000[2,4p17+5pCpFp1BpFp17[2,4p23p17pC}}{INP_R 152 0 "
> "{TEXT 0 25 "cp := charpoly(P,lambda);"}}{OUT_R 153 0 152{DAG :
3n3\`cp`+19*3n4\`lambda`j2x0003j2x0001*5p5j2x0002n3\`t`pEi2x0003*
5p5pEp10pAp13*5p5pAp10j2x0004p8*5p5pAp10p8j2x0006*5p5pAp10pEp8*3p
5pEi2x0002*3p10p27i2x0001*3p10j2x0005p13*3p10p1Fp37*3p10p8p8*3p10
pEpE}}{INP_R 154 0 "> "{TEXT 0 11 "factor(cp);"}}{OUT_R 155 0 154
{DAG +3*7+9n4\`lambda`i2x0001j2x0002j2x0001n3\`t`j2x0003*3pCp8pAp
A+7p3p6pCp6p10pApA+7p3p6pCpAp10pApAp6}}{COM_R 156 0{TEXT 1 282 "\
015This example is rather interesting because the square roots ca
ncelled out in the characteristic polynomial, which factors into 
3 simple linear factors.  So the eigenvalues are easy to compute.
  In computing the eigenvectors however, we will have to compute 
with these square roots\015"}}{INP_R 157 0 "> "{TEXT 0 14 "eigenv
ects(P);"}}{OUT_R 158 0 157{DAG ,4[2,4+7j2x0002j2x0001n3\`t`j2x00
03*3p8p4p6p6%2,2(3n4\`VECTOR`,2[2,4+3*5+5pCp4p8p4/3p6p4+5p8p6p6p6
i2x0001p21p6p1A[2,4+5p8p29pCp6p6%2,2(3p14,2[2,4p6+3p1Bp29p6[2,4+5
pCp6p8p6p6%2,2(3p14,2[2,4p6j2x0000p29}}{COM_R 159 0{TEXT 1 293 "\
015Now our examples have shown that Maple can work either using r
adicals or RootOf's, but actually, all the computations are done 
in the RootOf notation.  I.e. the codes first convert from radica
ls too RootOfs.  For example, the sqrt s in the example above con
verted into the RootOf notation is\015"}}{INP_R 160 0 "> "{TEXT 0
 23 "r := convert(s,RootOf);"}}{OUT_R 161 0 160{DAG :3n3\`r`(3n4\
`RootOf`,2+7*3n3\`_Z`j2x0002j2x0001*3n3\`t`pCi2x0002p11p14}}
{COM_R 162 0{TEXT 1 113 "\015You can see that indeed, s is a root
 of this polynomial in _Z.  Converting back to the radical notati
on, we get\015"}}{INP_R 163 0 "> "{TEXT 0 19 "convert(r,radical);
"}}{OUT_R 164 0 163{DAG *3+5*3n3\`t`j2x0002p5p3p5/3j2x0001p5}}
{COM_R 165 0{TEXT 1 52 "\015Now this square root can be factored 
into the form\015"}}{INP_R 166 0 "> "{TEXT 0 20 "simplify(factor(
s));"}}{OUT_R 167 0 166{DAG *5j2x0002/3j2x0001p1+5*3n3\`t`p1p4p9p
4p3}}{COM_R 168 0{TEXT 1 364 "\015One could of course argue that 
this isn't really simpler because now we have two square roots.  
What we want to show now is that if we have an expression that in
volves both forms for s, Maple will complain and insist on using 
either one form, or the other, but not both at the same time.  He
re is what happens.  Suppose we modify the 1,2 entry of the P mat
rix be\015"}}{INP_R 169 0 "> "{TEXT 0 30 "P[1,2] := sqrt(2)*sqrt(
t^2+t);"}}{OUT_R 170 0 169{DAG :3b3n3\`P`,3j2x0001j2x0002*5p7/3p5
p7+5*3n3\`t`p7p5p10p5pB}}{INP_R 171 0 "> "{TEXT 0 9 "print(P);"}}
{OUT_R 172 0 171{DAG (3n4\`MATRIX`,2[2,4[2,4*5n3\`t`j2x0001+5pApC
pCpCpC*5j2x0002/3pCp15+5*3pAp15pCpApCp17j2x0000[2,4*3+5p1Bp15pAp1
5p17+5p9pCp15pCp26[2,4p22p26p9}}{INP_R 173 0 "> "{TEXT 0 14 "eige
nvects(P);"}}{OUT_R 174 0 173{TEXT 2 197 "Error, (in evala) reduc
ible RootOf detected.  Substitutions are, \{\012RootOf(_Z^2-t^2-t
) = -1/2*RootOf(_Z^2-2)*RootOf(_Z^2-2*t^2-2*t), \012RootOf(_Z^2-t
^2-t) = 1/2*RootOf(_Z^2-2)*RootOf(_Z^2-2*t^2-2*t)\}\012"}}{COM_R 
175 0{TEXT 1 364 "\015We get an error.  The first thing we notice
 is that Maple has converted the input radicals into the RootOf n
otation.  What does the error mean.  It means that Maple has disc
overed that the different RootOf's are not independent.  Noting t
hat sqrt(2) is RootOf(_Z^2-2) in the RootOf notation, Maple is te
lling us the relationship between them, namely that either.\015"}
}{INP_R 176 0 "> "{TEXT 0 27 "sqrt(t^2+t) = -sqrt(2)/2*s;"}}
{OUT_R 177 0 176{DAG =3*3+5*3n3\`t`j2x0002j2x0001p4p8/3p8p6+3*5p6
pC+5p3p6p4p6pC/3i2x0001p6}}{INP_R 178 0 "> "{TEXT 0 27 "sqrt(t^2+
t) = +sqrt(2)/2*s;"}}{OUT_R 179 0 178{DAG =3*3+5*3n3\`t`j2x0002j2
x0001p4p8/3p8p6+3*5p6pC+5p3p6p4p6pCpC}}{COM_R 180 0{TEXT 1 706 "\
015Of course, it would be nice if Maple would automatically do th
e right simplification for us.  But it doesn't.  And the reason i
s that in general, because there is more than one possibility, it
 doesn't know which one it should choose.  The user has to make s
ure himself that the input matrix does not have any such ``algebr
aic'' dependencies.  We wish to conclude this tutorial by pointin
g out one further advantage of working algebraically, i.e. by doi
ng all arithmetic exactly, and one disadvantage.  The advantage i
s that by doing all the arithmetic exactly, there are no roundoff
 errors.  So for matrices that have repeated eigenvalues, the eig
envectors will be computed correctly.  Here is an example\015"}}
{INP_R 181 0 "> "{TEXT 0 63 "A := matrix(4,4,[0,1,0,0,-u^2,2*u,0,
0,-u*v,v,u,0,-u*t,t,0,u]);\012"}}{OUT_R 182 0 181{DAG :3n3\`A`(3n
4\`MATRIX`,2[2,5[2,5j2x0000j2x0001pCpC[2,5+3*3n3\`u`j2x0002i2x000
1+3p16p18pCpC[2,5+3*5p16pEn3\`v`pEp1Ap27p16pC[2,5+3*5p16pEn3\`t`p
Ep1Ap34pCp16}}{INP_R 183 0 "> "{TEXT 0 20 "cp := det(lambda-A);"}
}{OUT_R 184 0 183{DAG :3n3\`cp`+B*5n4\`lambda`j2x0001n3\`u`j2x000
3i2x0004*5pAj2x0002p5p12j2x0006*5pAp8p5pCpE*3p5j2x0004p8*3pAp20p8
}}{INP_R 185 0 "> "{TEXT 0 11 "factor(cp);"}}{OUT_R 186 0 185{DAG
 *3+5n3\`u`i2x0001n4\`lambda`j2x0001j2x0004}}{INP_R 187 0 "> "
{TEXT 0 13 "eigenvals(A);"}}{OUT_R 188 0 187{DAG ,5n3\`u`p1p1p1}}
{INP_R 189 0 "> "{TEXT 0 19 "e := eigenvects(A);"}}{OUT_R 190 0 
189{DAG :3n3\`e`[2,4n3\`u`j2x0004%2,4(3n4\`VECTOR`,2[2,5*3p5i2x00
01j2x0001j2x0000p18(3pC,2[2,5p18p18p16p18(3pC,2[2,5p18p18p18p16}}
{COM_R 191 0{TEXT 1 410 "\015This example shows a matrix in which
 the eigenvalue u is repeated 4 times.  The eigenspace consists o
f a basis of more than one vector, 3 vectors.  One normally expec
ts to get 4 vectors in the basis.  But it is possible for two vec
tors to conincide.  We end by showing that the three eigenvectors
 computed are indeed correct.  Instead of doing this one vector a
t a time, we build the matrix X of eigenvectors\015"}}{INP_R 192 
0 "> "{TEXT 0 42 "X := augment( e[3][1], e[3][2], e[3][3] );"}}
{OUT_R 193 0 192{DAG :3n3\`X`(3n4\`MATRIX`,2[2,5[2,4j2x0000pC*3n3
\`u`i2x0001[2,4pCpCj2x0001[2,4pCp18pC[2,4p18pCpC}}{INP_R 194 0 ">
 "{TEXT 0 20 "evalm( (u-A) &* X );"}}{OUT_R 195 0 194{DAG (3n4\`M
ATRIX`,2[2,5[2,4j2x0000p9p9p7p7p7}}{INP_R 196 0 "> "{TEXT 0 0 ""}
}}{END}
