{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--12-*" "helvetica" "Courier-Bold" 8 12 128 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 14}{FONT 2 "-adobe-couri
er-medium-r-normal--12-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-times-bold-r-normal--17-*" "times" "Times-Bold
" 8 17 64 "Times-Bold" 17}{FONT 4 "-adobe-times-bold-r-normal--20
-*" "times" "Times-Bold" 8 20 64 "Times-Bold" 20}{FONT 5 "-adobe-
times-bold-r-normal--17-*" "times" "Times-Bold" 8 17 64 "Times-Bo
ld" 17}{FONT 6 "-adobe-times-bold-r-normal--17-*" "times" "Times-
Bold" 8 17 64 "Times-Bold" 17}{FONT 7 "-adobe-times-bold-r-normal
--17-*" "times" "Times-Bold" 8 17 64 "Times-Bold" 17}{FONT 8 "-ad
obe-times-bold-r-normal--17-*" "times" "Times-Bold" 8 17 64 "Time
s-Bold" 17}{FONT 9 "-adobe-times-bold-r-normal--17-*" "times" "Ti
mes-Bold" 8 17 64 "Times-Bold" 17}{FONT 10 "-adobe-times-bold-r-n
ormal--17-*" "times" "Times-Bold" 8 17 64 "Times-Bold" 17}{FONT 
11 "-adobe-helvetica-bold-r-normal--12-*" "helvetica" "Courier-Bo
ld" 8 12 128 "Helvetica-Bold" 12}{FONT 12 "-adobe-helvetica-bold-
r-normal--12-*" "helvetica" "Courier-Bold" 8 12 128 "Helvetica-Bo
ld" 12}{FONT 13 "-adobe-helvetica-bold-r-normal--12-*" "helvetica
" "Courier-Bold" 8 12 128 "Helvetica-Bold" 12}{FONT 14 "-adobe-he
lvetica-bold-r-normal--12-*" "helvetica" "Courier-Bold" 8 12 128 
"Helvetica-Bold" 12}{FONT 15 "-adobe-times-bold-r-normal--17-*" "
times" "Times-Bold" 8 17 64 "Times-Bold" 17}{SCP_R 1 0 205{COM_R 
2 0{TEXT 1 0 ""}}{COM_R 3 0{TEXT 4 37 "A Package for Numerical Ap
proximation"}}{COM_R 4 0{TEXT 5 36 "                         K.O.
 Geddes"}}{COM_R 5 0{TEXT 1 0 ""}}{COM_R 6 0{TEXT 1 356 "A packag
e named ``numapprox'' has been introduced in Maple V Release 2.  
This package contains various procedures for developing numerical
 approximations of functions.  Examples of its use are presented 
here using the Maple worksheet facility.  Note, some of the calcu
lations done in this worksheet, in particular, the plots, require
 some time to compute.\015"}}{COM_R 7 0{TEXT 1 0 ""}}{INP_R 8 0 "
> "{TEXT 0 16 "with(numapprox);"}}{OUT_R 9 0 8{DAG [2,Bn5\`chebpa
de`n5\`chebyshev`n5\`confracform`n5\`hornerform`n4\`infnorm`n4\`l
aurent`n4\`minimax`n4\`pade`n4\`remez`n4\`taylor`}}{SEP_R 10 0}
{COM_R 11 0{TEXT 1 0 ""}}{COM_R 12 0{TEXT 1 303 "We will use seve
ral of these procedures to develop numerical approximations for a
 particular mathematical function.  The mathematical function whi
ch we wish to approximate is the function discussed in section 6.
9 of the book First Leaves: A Tutorial Introduction to Maple V.  
The function is as follows."}}{COM_R 13 0{TEXT 1 0 ""}}{INP_R 14 
0 "> "{TEXT 0 41 "f := x -> int(1/GAMMA(t), t=0..x ) / x^2;"}}
{OUT_R 15 0 14{DAG :3n3\`f`@7,2n3\`x`,1,3n5\`operator`n4\`arrow`p
7*5(3n3\`int`,3*3(3n4\`GAMMA`,2n3\`t`i2x0001=3p1C~3j2x0000a2x0001
j2x0001p25i2x0002p7}}{SEP_R 16 0}{COM_R 17 0{TEXT 1 0 ""}}{COM_R 
18 0{TEXT 1 567 "Numerical evaluation of f(x) is quite expensive 
because it requires a numerical integration computation for each 
particular value x.  Hence many of the computations in this sessi
on require a nontrivial amount of execution time.  The purpose of
 the exercise is to develop efficient evaluation procedures for f
(x) by computing polynomial and rational function approximations 
for f(x).  Our ultimate goal is to develop an evaluation procedur
e which yields six digits of accuracy and which requires the fewe
st possible number of arithmetic operations for each evaluation."
}}{COM_R 19 0{TEXT 1 0 ""}}{SEP_R 20 0}{COM_R 21 0{TEXT 1 0 ""}}
{COM_R 22 0{TEXT 1 34 "A plot of f(x) appears as follows."}}
{COM_R 23 0{TEXT 1 0 ""}}{INP_R 24 0 "> "{TEXT 0 14 "plot(f, 0..4
);"}}{SEP_R 25 0}{COM_R 26 0{TEXT 1 0 ""}}{COM_R 27 0{TEXT 5 41 "
Approximations derived from Taylor series"}}{COM_R 28 0{TEXT 1 0 
""}}{COM_R 29 0{TEXT 1 332 "Efficient evaluation procedures are u
sually based on polynomial approximations or rational function ap
proximations (i.e. quotients of polynomials).  The reason is that
 a polynomial or a rational function can be evaluated directly us
ing only the four basic arithmetic operations:  addition, subtrac
tion, multiplication, and division."}}{COM_R 30 0{TEXT 1 0 ""}}
{COM_R 31 0{TEXT 1 129 "As our first approximation to the functio
n f(x), we compute the Taylor polynomial of degree 8 about the mi
dpoint of the interval."}}{COM_R 32 0{TEXT 1 0 ""}}{INP_R 33 0 ">
 "{TEXT 0 38 "s := map(evalf, taylor(f(x), x=2, 9));"}}{OUT_R 34 
0 33{DAG :3n3\`s`_16+5n3\`x`j2x0001i2x0002p7e3j4x004065945998i2x0
010x0e3i4x001565945998p11x1e3j4x000209790791i2x0011x2e3j4x0017626
26393p20x3e3i4x006207547124i2x0012x4e3j3x05733566p11x5e3j3x243311
63p20x6e3i3x10010535p20x7e3j3x01414215p20x8(3n3\`O`,2p7x9}}{COM_R
 35 0{TEXT 1 0 ""}}{INP_R 36 0 "> "{TEXT 0 36 "TaylorApprox := co
nvert(s, polynom):"}}{COM_R 37 0{TEXT 1 0 ""}}{SEP_R 38 0}{COM_R 
39 0{TEXT 1 0 ""}}{COM_R 40 0{TEXT 1 203 "For convenience, we con
vert the approximation to functional form to correspond with the 
form specified for the original function f.  Then we plot the err
or curve for this Taylor polynomial approximation."}}{COM_R 41 0
{TEXT 1 0 ""}}{INP_R 42 0 "> "{TEXT 0 41 "TaylorApprox := unapply
(TaylorApprox, x);"}}{OUT_R 43 0 42{DAG :3n6\`TaylorApprox`@7,2n3
\`x`,1,3n5\`operator`n4\`arrow`pA+13e3j4x007197837994i2x0010j2x00
01a2x0001e3i4x001565945998p1A*3+5p1Ep1Ci2x0002p1Cj2x0002e3j4x0002
09790791i2x0011*3p27j2x0003e3j4x001762626393p34*3p27j2x0004e3i4x0
06207547124i2x0012*3p27j2x0005e3j3x05733566p1A*3p27j2x0006e3j3x24
331163p34*3p27j2x0007e3i3x10010535p34*3p27j2x0008e3j3x01414215p34
pA}}{SEP_R 44 0}{COM_R 45 0{TEXT 1 0 ""}}{COM_R 46 0{TEXT 1 82 "T
he error curve for this Taylor polynomial approximation takes the
 following form."}}{COM_R 47 0{TEXT 1 0 ""}}{INP_R 48 0 "> "{TEXT
 0 29 "plot(f - TaylorApprox, 0..4);"}}{SEP_R 49 0}{COM_R 50 0
{TEXT 1 0 ""}}{COM_R 51 0{TEXT 1 273 "It is a typical property of
 Taylor approximations that the error is small near the point of 
the Taylor series expansion and the error gets larger as the dist
ance from the point of expansion increases.  In this particular c
ase, the largest error occurs at the left endpoint."}}{COM_R 52 0
{TEXT 1 0 ""}}{COM_R 53 0{TEXT 1 165 "To compute the value of the
 error at x=0, note that direct evaluation of f(0) will lead to a
 division by zero (see the definition of f) so we must use a limi
t value."}}{COM_R 54 0{TEXT 1 0 ""}}{INP_R 55 0 "> "{TEXT 0 60 "m
axTaylorError := abs( limit(f(x), x=0) - TaylorApprox(0) );"}}
{OUT_R 56 0 55{DAG :3n6\`maxTaylorError`e3j3x15029739i2x0010}}
{SEP_R 57 0}{COM_R 58 0{TEXT 1 0 ""}}{COM_R 59 0{TEXT 6 18 "Pade 
approximation"}}{COM_R 60 0{TEXT 1 0 ""}}{COM_R 61 0{TEXT 1 337 "
Next we compute the Pade rational approximation of degree (4,4) f
or f(x).  The approximations being computed for the remainder of 
this session will approximate the function more accurately and ro
undoff errors in the calculations will become significant.  There
fore, we will now do the calculations carrying two extra digits o
f precision."}}{COM_R 62 0{TEXT 1 0 ""}}{INP_R 63 0 "> "{TEXT 0 
13 "Digits := 12:"}}{INP_R 64 0 "> "{TEXT 0 38 "s := map(evalf, t
aylor(f(x), x=2, 9)):"}}{INP_R 65 0 "> "{TEXT 0 34 "PadeApprox :=
 pade(s, x=2, [4,4]);"}}{OUT_R 66 0 65{DAG :3n5\`PadeApprox`*5+Be
3j4x341034782414i2x0012j2x0001n3\`x`e3j4x327799086301i2x0013*3+5p
10pEi2x0002pEj2x0002e3i4x612783607852i2x0014*3p1Aj2x0003e3j4x4529
91090573p27*3p1Aj2x0004e3i4x431506281072i2x0015pE+Be3j4x068484881
719pCpEp10e3j4x465757559140pCp19e3j4x159149616411pCp29e3j4x266813
698979p17p33e3j4x346967806798p27i2x0001}}{COM_R 67 0{TEXT 1 0 ""}
}{INP_R 68 0 "> "{TEXT 0 37 "PadeApprox := unapply(PadeApprox, x)
:"}}{COM_R 69 0{TEXT 1 0 ""}}{SEP_R 70 0}{COM_R 71 0{TEXT 1 0 ""}
}{COM_R 72 0{TEXT 1 74 "The error curve for the (4,4) Pade approx
imation takes the following form."}}{COM_R 73 0{TEXT 1 0 ""}}
{INP_R 74 0 "> "{TEXT 0 27 "plot(f - PadeApprox, 0..4);"}}{SEP_R 
75 0}{COM_R 76 0{TEXT 1 0 ""}}{COM_R 77 0{TEXT 1 332 "As with Tay
lor polynomial approximations, it is a typical property of Pade a
pproximations that the error is small near the point of expansion
 and the error gets larger as the distance from the point of expa
nsion increases.  Again we see from the plot that for this partic
ular function, the largest error occurs at the left endpoint."}}
{COM_R 78 0{TEXT 1 0 ""}}{COM_R 79 0{TEXT 1 175 "However, we find
 that the maximum error in the Pade approximation is an order of 
magnitude smaller than the maximum error in the corresponding Tay
lor polynomial approximation."}}{COM_R 80 0{TEXT 1 0 ""}}{INP_R 
81 0 "> "{TEXT 0 56 "maxPadeError := abs( limit(f(x), x=0) - Pade
Approx(0) );"}}{OUT_R 82 0 81{DAG :3n6\`maxPadeError`e3j4x0003537
77309i2x0012}}{SEP_R 83 0}{COM_R 84 0{TEXT 1 0 ""}}{COM_R 85 0
{TEXT 7 44 "Approximations derived from Chebyshev series"}}{COM_R
 86 0{TEXT 1 0 ""}}{COM_R 87 0{TEXT 1 391 "In general, better app
roximations on an interval can be obtained using Chebyshev series
 expansions rather than Taylor series expansions.  The Chebyshev 
series expansion of f(x) on [0,4] is as follows, where we specify
 that we want accuracy 1E-8 which means that all terms with coeff
icients smaller than this magnitude will be dropped.  We discover
 that this yields a degree 13 approximation."}}{COM_R 88 0{TEXT 1
 0 ""}}{INP_R 89 0 "> "{TEXT 0 26 "evalf( limit(f(x), x=0) );"}}
{OUT_R 90 0 89{DAG e3j4x500000000000i2x0012}}{COM_R 91 0{TEXT 1 0
 ""}}{INP_R 92 0 "> "{TEXT 0 57 "fproc := proc(x) if x=0 then 0.5
 else evalf(f(x)) fi end:"}}{COM_R 93 0{TEXT 1 0 ""}}{INP_R 94 0 
"> "{TEXT 0 45 "ChebApprox := chebyshev(fproc, x=0..4, 1E-8);"}}
{OUT_R 95 0 94{DAG :3n5\`ChebApprox`+1D(3n3\`T`,3j2x0000+5n3\`x`/
3j2x0001j2x0002i2x0001p10e3j4x379206274273i2x0012(3p7,3p10pCe3i4x
202632813998p1C(3p7,3p12pCe3i4x369064836430i2x0013(3p7,3j2x0003pC
e3j4x370131431541p33(3p7,3j2x0004pCe3i4x888944143051i2x0014(3p7,3
j2x0005pCe3i4x149789336636i2x0015(3p7,3j2x0006pCe3j4x642974620795
p59(3p7,3j2x0007pCe3i4x170677949427p59(3p7,3j2x0008pCe3j4x1269172
83880i2x0016(3p7,3j2x0009pCe3j4x439874928686i2x0017(3p7,3j2x0010p
Ce3i4x156284139868p8B(3p7,3j2x0011pCe3j4x204980540086i2x0018(3p7,
3j2x0012pCe3j4x456254277778i2x0020(3p7,3j2x0013pCe3i4x69432389752
3pB1}}{SEP_R 96 0}{COM_R 97 0{TEXT 1 0 ""}}{COM_R 98 0{TEXT 1 561
 "If the error in a Chebyshev series approximation is plotted, it
 typically shows an oscillating error curve as can be verified fo
r this example (see the First Leaves reference mentioned above). 
 If the Chebyshev series was truncated at degree 8, to yield a po
lynomial with the same degree as the Taylor polynomial approximat
ion considered above, we would find that the maximium error in th
e Chebyshev series approximation of degree 8 is approximately 0.6
E-5.  This is two orders of magnitude smaller than the error in t
he (4,4) Pade approximation computed above."}}{COM_R 99 0{TEXT 1 
0 ""}}{SEP_R 100 0}{COM_R 101 0{TEXT 1 0 ""}}{COM_R 102 0{TEXT 1 
608 "For subsequent calculations, it is useful to note that we ca
n use a procedure for computing numerical values of f(x) which wi
ll be much less expensive than the direct definition, which requi
res a numerical integration process for each specific value.  Nam
ely, let us define a numerical evaluation procedure based on the 
Chebyshev series of degree 13 since the maximum error in ChebAppr
ox is less than 1E-8, sufficient accuracy for our purposes.  We g
ive T its polynomial definition from the orthopoly package and th
en we convert the polynomial to Horner (nested multiplication) fo
rm for efficient evaluation."}}{COM_R 103 0{TEXT 1 0 ""}}{INP_R 
104 0 "> "{TEXT 0 58 "F := hornerform( eval(subs(T=orthopoly[T], 
ChebApprox)) );"}}{OUT_R 105 0 104{DAG :3n3\`F`+5e3j4x49999999861
2i2x0012j2x0001*5+5e3j4x192405358507p9pB*5+5e3i4x163971754266p9pB
*5+5e3i4x838614327947i2x0014pB*5+5e3j4x277082269604i2x0013pB*5+5e
3i4x593172540114p26pB*5+5e3i4x132728875994p26pB*5+5e3j4x910057667
583i2x0015pB*5+5e3i4x180351188038p4CpB*5+5e3j4x576857208767i2x001
7pB*5+5e3j4x448885596391p5FpB*5+5e3i4x990274470078i2x0018pB*5+5e3
j4x925433780668i2x0019pBn3\`x`e3i4x347161948761i2x0020pBp7FpBpBpB
p7FpBpBpBp7FpBpBpBp7FpBpBpBp7FpBpBpBp7FpBpBpBp7FpBpBpBp7FpBpBpBp7
FpBpBpBp7FpBpBpBp7FpBpBpBp7FpBpB}}{COM_R 106 0{TEXT 1 0 ""}}
{INP_R 107 0 "> "{TEXT 0 20 " F := unapply(F, x):"}}{COM_R 108 0
{TEXT 1 0 ""}}{SEP_R 109 0}{COM_R 110 0{TEXT 1 0 ""}}{COM_R 111 0
{TEXT 8 28 "Chebyshev-Pade approximation"}}{COM_R 112 0{TEXT 1 0 
""}}{COM_R 113 0{TEXT 1 467 "Just as we found that going from a T
aylor polynomial to a Pade rational function yielded a more accur
ate approximation, it is equally useful to consider a Chebyshev-P
ade rational approximation.  The (m,n) Chebyshev-Pade approximati
on for f(x) is a rational function r[m,n](x) with numerator of de
gree m and denominator of degree n such that the Chebyshev series
 expansion of r[m,n](x) agrees with the Chebyshev series expansio
n of f(x) through the term of degree m+n."}}{COM_R 114 0{TEXT 1 0
 ""}}{COM_R 115 0{TEXT 1 119 "We compute the Chebyshev-Pade appro
ximation of degree (4,4) to correspond with the Pade approximatio
n computed earlier."}}{COM_R 116 0{TEXT 1 0 ""}}{INP_R 117 0 "> "
{TEXT 0 44 "ChebPadeApprox := chebpade(F,  0..4, [4,4]);"}}{OUT_R
 118 0 117{DAG :3n6\`ChebPadeApprox`@7,2n3\`x`,1,3n5\`operator`n4
\`arrow`pA*5+B(3n3\`T`,3j2x0000+5a2x0001/3j2x0001j2x0002i2x0001p2
0e3j4x285648385806i2x0012(3p17,3p20p1Ce3j4x896033601951i2x0013(3p
17,3p22p1Ce3i4x626546522489i2x0014(3p17,3j2x0003p1Ce3j4x537846736
884p44(3p17,3j2x0004p1Ce3i4x414939188070i2x0015p20+Bp16p20p2Ee3j4
x879308976550p2Cp3Ae3j4x289575808057p2Cp46e3j4x487963347474p38p52
e3j4x650272210252p44p24pA}}{SEP_R 119 0}{COM_R 120 0{TEXT 1 0 ""}
}{INP_R 121 0 "> "{TEXT 0 19 "with(orthopoly, T):"}}{COM_R 122 0
{TEXT 1 0 ""}}{INP_R 123 0 "> "{TEXT 0 31 "plot(F - ChebPadeAppro
x, 0..4);"}}{SEP_R 124 0}{COM_R 125 0{TEXT 1 0 ""}}{COM_R 126 0
{TEXT 1 341 "The maximum error occurs, once again, at the left en
dpoint.  The magnitude of the maximum error is somewhat smaller t
han the error in the corresponding Chebyshev series approximation
.  The main advantage of the rational function form is the effici
ency of evaluation which can be achieved by converting to continu
ed fraction form (see below)."}}{COM_R 127 0{TEXT 1 0 ""}}{INP_R 
128 0 "> "{TEXT 0 53 "maxChebPadeError :=  abs( F(0) - ChebPadeAp
prox(0) );"}}{OUT_R 129 0 128{DAG :3n7\`maxChebPadeError`e3j3x012
36753i2x0012}}{SEP_R 130 0}{COM_R 131 0{TEXT 1 0 ""}}{COM_R 132 0
{TEXT 9 21 "Minimax approximation"}}{COM_R 133 0{TEXT 1 0 ""}}
{COM_R 134 0{TEXT 1 438 "It is a classical result of Approximatio
n Theory that the best minimax rational function approximation of
 degree (m,n) is achieved when the error curve has m+n+2 oscillat
ions which are equal in magnitude.  The error curve of the Chebys
hev-Pade approximation has the correct number of oscillations but
 its error curve must be ``levelled'' in order to achieve the bes
t minimax approximation.  This task is achieved by the minimax pr
ocedure."}}{COM_R 135 0{TEXT 1 0 ""}}{INP_R 136 0 "> "{TEXT 0 56 
"MinimaxApprox := minimax(F, 0..4, [4,4], 1, 'maxerror');"}}
{OUT_R 137 0 0{DAG :3n6\`MinimaxApprox`@7,2n3\`x`,1,3n5\`operator
`n4\`arrow`pA*5+5e3j4x174997192885i2x0012j2x0001*5+5e3j4x83310284
4341i2x0013p1D*5+5e3i4x202160244205p26p1D*5+5e3j4x368650911740i2x
0014p1Da2x0001e3i4x158074298550i2x0015p1Dp3Cp1Dp1Dp1Dp3Cp1Dp1Dp1D
p3Cp1Dp1Dp1D+5e3j4x349994794547p1Bp1D*5+5e3j4x319144571540p26p1D*
5+5e3j4x623025914882p26p1D*5+5e3i4x115181997250p39p1Dp3Ce3j4x3362
81630951p39p1Dp3Cp1Dp1Dp1Dp3Cp1Dp1Dp1Dp3Cp1Dp1Di2x0001pA}}{SEP_R 
138 0}{COM_R 139 0{TEXT 1 0 ""}}{COM_R 140 0{TEXT 1 268 "The maxi
mum error in MinimaxApprox is given by the value of the variable 
maxerror.  It can be seen that we have achieved our goal of obtai
ning an approximation with error less than 1E-6.  A plot of the e
rror curve displays the predicted property of equal oscillations.
"}}{COM_R 141 0{TEXT 1 0 ""}}{INP_R 142 0 "> "{TEXT 0 28 "maxMini
maxError := maxerror;"}}{OUT_R 143 0 142{DAG :3n6\`maxMinimaxErro
r`e3j4x593169248608i2x0018}}{INP_R 144 0 "> "{TEXT 0 30 "plot(F -
 MinimaxApprox, 0..4);"}}{SEP_R 145 0}{COM_R 146 0{TEXT 1 0 ""}}
{COM_R 147 0{TEXT 10 42 "Efficient evaluation of rational functio
ns"}}{COM_R 148 0{TEXT 1 0 ""}}{COM_R 149 0{TEXT 1 312 "The numer
ator and denominator polynomials in MinimaxApprox have already be
en expressed in Horner form (i.e. nested multiplication form).  T
he cost of evaluating a polynomial of degree n in Horner form is 
n multiplications and n additions and this is the most efficient 
evaluation scheme for a general polynomial."}}{COM_R 150 0{TEXT 1
 0 ""}}{COM_R 151 0{TEXT 1 499 "However, for a rational function 
of degree (m,n) we can do better than simply expressing each of n
umerator and denominator in Horner form.  Noting that we could no
rmalize the rational function such that the denominator polynomia
l is monic (i.e. leading coefficient 1), to save one multiplicati
on operation, we can see that the cost of evaluating a rational f
unction of degree (m,n) in Horner form is m+n additions, m+n-1 mu
ltiplications, and 1 division.  In other words, the total operati
on count is"}}{COM_R 152 0{TEXT 1 0 ""}}{COM_R 153 0{TEXT 11 44 "
     m+n multiplication/division operations,"}}{COM_R 154 0{TEXT 
12 41 "     m+n addition/subtraction operations."}}{COM_R 155 0
{TEXT 1 0 ""}}{COM_R 156 0{TEXT 1 198 "The cost of evaluating a r
ational function can be reduced significantly by converting it to
 continued fraction form.  Specifically, a rational function of d
egree (m,n) can be evaluated using at most"}}{COM_R 157 0{TEXT 1 
0 ""}}{COM_R 158 0{TEXT 13 49 "     max(m,n) multiplication/divis
ion operations,"}}{COM_R 159 0{TEXT 14 41 "     m+n addition/subt
raction operations."}}{COM_R 160 0{TEXT 1 0 ""}}{COM_R 161 0{TEXT
 1 144 "For example, if m=n then this new scheme requires only ha
lf the number of multiplication/division operations compared with
 the preceding method."}}{COM_R 162 0{TEXT 1 0 ""}}{COM_R 163 0
{TEXT 1 475 "For the rational function MinimaxApprox, the cost of
 evaluation in the form expressed above is 9 multiplication/divis
ion operations and 8 addition/subtraction operations.  (The 9 cou
ld be reduced to 8 simply by normalizing to make the denominator 
monic.)  We now compute the continued fraction form for this same
 rational function and it can be seen from the output that the co
st of evaluation in this form is only 4 division operations and 8
 addition/subtraction operations."}}{COM_R 164 0{TEXT 1 0 ""}}
{INP_R 165 0 "> "{TEXT 0 44 "MinimaxApprox := confracform(Minimax
Approx):"}}{COM_R 166 0{TEXT 1 0 ""}}{INP_R 167 0 "> "{TEXT 0 25 
"lprint(MinimaxApprox(x));"}}{OUT_R 168 0 167{TEXT 2 149 "-470065
219153.0E-13+1.08015595629/(x+4.41674952090+16.1988470929/(x+4.27
475787694+69.9126519465/(x-10.\0122737568574+4.79087565911/(x+1.2
3973298922))))\012"}}{SEP_R 169 0}{COM_R 170 0{TEXT 1 0 ""}}
{COM_R 171 0{TEXT 15 18 "Timing comparisons"}}{COM_R 172 0{TEXT 1
 0 ""}}{COM_R 173 0{TEXT 1 332 "We now time the actual cost to ev
aluate the function f(x) at 1000 points using the original integr
al definition and compare it with the cost to evaluate MinimaxApp
rox in continued fraction form.  Since our approximation will yie
ld only 6 digits of accuracy, we only ask for 6 digits of accurac
y from the integral definition as well."}}{COM_R 174 0{TEXT 1 0 "
"}}{INP_R 175 0 "> "{TEXT 0 27 "Digits := 6:  st := time():"}}
{INP_R 176 0 "> "{TEXT 0 38 "seq( evalf(f(i/250.0)), i = 1..1000 
):"}}{INP_R 177 0 "> "{TEXT 0 23 "oldtime := time() - st;"}}
{OUT_R 178 0 177{DAG :3n4\`oldtime`e3j3x00793500i2x0003}}{SEP_R 
179 0}{COM_R 180 0{TEXT 1 0 ""}}{COM_R 181 0{TEXT 1 330 "The cont
inued fraction form of a rational function sometimes requires tha
t a few extra guard digits be carried during evaluation.  In this
 case, it is sufficient to carry two extra digits.  We find that 
the evaluation procedure based on MinimaxApprox is more than 150 
times faster than evaluating the original integral definition."}}
{COM_R 182 0{TEXT 1 0 ""}}{INP_R 183 0 "> "{TEXT 0 27 "Digits := 
8:  st := time():"}}{INP_R 184 0 "> "{TEXT 0 43 "seq( MinimaxAppr
ox(i/250.0), i = 1..1000 ):"}}{INP_R 185 0 "> "{TEXT 0 23 "newtim
e := time() - st;"}}{OUT_R 186 0 185{DAG :3n4\`newtime`e3j2x4767i
2x0003}}{INP_R 187 0 "> "{TEXT 0 27 "SpeedUp := oldtime/newtime;"
}}{OUT_R 188 0 187{DAG :3n4\`SpeedUp`e3j3x16645689i2x0005}}{SEP_R
 189 0}{COM_R 190 0{TEXT 1 0 ""}}{COM_R 191 0{TEXT 3 31 "Conversi
on to FORTRAN or C code"}}{COM_R 192 0{TEXT 1 0 ""}}{COM_R 193 0
{TEXT 1 379 "One of the common reasons for developing an efficien
t numerical evaluation procedure for a mathematical function is f
or the purpose of including it in a subroutine library in some ot
her language such as FORTRAN or C.  Conversion routines are avail
able in Maple to convert to either of these languages.  As an exa
mple, we convert the formula for MinimaxApprox into FORTRAN synta
x."}}{COM_R 194 0{TEXT 1 0 ""}}{INP_R 195 0 "> "{TEXT 0 26 "fortr
an(MinimaxApprox(x));"}}{OUT_R 196 0 195{TEXT 2 143 "      t0 = -
0.4700652E-1+0.1080156E1/(x+0.441675E1+0.1619885E2/(x+0.4274\012 
    #758E1+0.6991265E2/(x-0.1027376E2+0.4790876E1/(x+0.1239733E1)
)))\012"}}{SEP_R 197 0}{COM_R 198 0{TEXT 1 0 ""}}{COM_R 199 0
{TEXT 6 18 "Concluding remarks"}}{COM_R 200 0{TEXT 1 0 ""}}{COM_R
 201 0{TEXT 1 467 "We have shown how the facilities in Maple V Re
lease 2 can be used very effectively to develop procedures for th
e efficient numerical evaluation of mathematical functions.  Spec
ifically, the ability to generate series expansions, to compute r
ational function approximations, and to convert to various specia
l forms, combined with the powerful interactive tool of viewing p
lots of the approximations and their error curves, provides an id
eal environment for such tasks."}}{COM_R 202 0{TEXT 1 0 ""}}
{COM_R 203 0{TEXT 1 134 "This complete article, including Maple i
nput, output, text, and graphics, was created and formatted as an
 interactive Maple worksheet."}}{COM_R 204 0{TEXT 1 0 ""}}{SEP_R 
205 0}{COM_R 206 0{TEXT 1 0 ""}}}{END}
