{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 12 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 12 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 12 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--17-*" "n
ew century schoolbook" "Times-Bold" 8 12 64 "Times-Bold" 17}
{SCP_R 1 0 34{COM_R 2 0{TEXT 3 9 "B-splines"}}{COM_R 3 0{TEXT 1 
338 "\015This worksheet shows the Maple bspline package which con
structs the basis polynomials for the B-splines on a given knot s
equence.  The knot sequence may include mulitple knots.  What hap
pens in this case is that there is a loss of continuity.  Normall
y the B-splines of degree n are Cn-1 continuous.\012Michael Monag
an: monagan@inf.ethz.ch\015"}}{INP_R 4 0 "> "{TEXT 0 62 "readlib(
bspline): # read the B-spline package from the library"}}{INP_R 5
 0 "> "{TEXT 0 8 "?bspline"}}{COM_R 6 0{TEXT 1 115 "\015Compute t
he quadratic and cubic B-spline segment polynomials.  By default,
 uniformly spaced integer knots are used"}}{INP_R 7 0 "> "{TEXT 0
 39 "b2 := bspline(2,u); # knots are 0,1,2,3"}}{OUT_R 8 0 7{DAG :
3n3\`b2`[2,6[2,3<3n3\`u`j2x0000pA[2,3<3p8j2x0001+3*3p8j2x0002/3p1
1p16[2,3<3p8p16+7/3i2x0001p16p11p8p11*3+5p8p11p22p11p16p22[2,3<3p
8j2x0003+7/3j2x0005p16p11p8p22*3+5p8p11i2x0002p11p16p18[2,3$3p34p
8pA}}{INP_R 9 0 "> "{TEXT 0 41 "b3 := bspline(3,u); # knots are 0
,1,2,3,4"}}{OUT_R 10 0 9{DAG :3n3\`b3`[2,7[2,3<3n3\`u`j2x0000pA[2
,3<3p8j2x0001+3*3p8j2x0003/3p11j2x0006[2,3<3p8j2x0002+9/3i2x0001p
16p11p8/3p11p20*3+5p8p11p24p11p20p29*3p2Dp16/3p24p20[2,3<3p8p16+7
/3p20p16p11*3+5p8p11i2x0002p11p20p24*3p45p16p29[2,3<3p8j2x0004+9/
3j2x0005p16p11p8p37*3+5p8p11i2x0003p11p20p29*3p60p16/3p24p1A[2,3$
3p55p8pA}}{COM_R 11 0{TEXT 1 83 "This is a correction to the util
ity routine to create a procedure out of this list\015"}}{INP_R 
12 0 "> "{TEXT 0 194 "`convert/procedure` := proc(b:list) local x
;\012    x := op(1,b[1][1]);\012    subs( \{'_BODY'=pointto(assem
ble(31, op(map(addressof,map(op,b))))),'_ARGS'=x\},\012          \+
     proc(_ARGS) _BODY end)\012end:"}}{INP_R 13 0 "> "{TEXT 0 28 
"B3 := convert(b3,procedure);"}}{OUT_R 14 0 13{DAG :3n3\`B3`@8,2n
3\`u`,1p7p7?D<3a2x0001j2x0000pE<3pCj2x0001+3*3pCj2x0003/3p13j2x00
06<3pCj2x0002+9/3i2x0001p18p13pC/3p13p20*3+5pCp13p24p13p20p29*3p2
Dp18/3p24p20<3pCp18+7/3p20p18p13*3+5pCp13i2x0002p13p20p24*3p43p18
p29<3pCj2x0004+9/3j2x0005p18p13pCp37*3+5pCp13i2x0003p13p20p29*3p5
Cp18/3p24p1C$3p51pCpEp7p7}{TEXT 2 298 "\012B3 := proc(u)\012     \+
     if u < 0 then 0\012          elif u < 1 then 1/6*u^3\012    \+
      elif u < 2 then -1/3+1/2*u+1/2*(u-1)^2-1/2*(u-1)^3\012     \+
     elif u < 3 then 2/3-(u-2)^2+1/2*(u-2)^3\012          elif u \+
< 4 then 5/3-1/2*u+1/2*(u-3)^2-1/6*(u-3)^3\012          elif 4 <=
 u then 0\012          fi\012      end\012"}}{INP_R 15 0 "> "
{TEXT 0 15 "plot(B3, 0..4);"}}{COM_R 16 0{TEXT 1 118 "\015Now for
 symbolic knots a, b, c, d.  We compute the B-spline segment poly
nomials and factor the resulting expressions\015"}}{INP_R 17 0 ">
 "{TEXT 0 37 "b1 := factor(bspline(2,u,[a,b,c,d]));"}}{OUT_R 18 0
 17{DAG :3n3\`b1`[2,6[2,3<3n3\`u`n3\`a`j2x0000[2,3<3p8n3\`b`+3*7+
5p8i2x0001pAj2x0001j2x0002+5p12p1BpAp18p18+5n3\`c`p18pAp1Bp18p18[
2,3<3p8p26+3*9+15*7p12p1BpAp1Bp26p1Bp1B*5p8p1Dp12p1Bp1B*7p12p1BpA
p1Bn3\`d`p1Bp1B*7p12p1Bp26p1Bp48p1Bp18*7p8p1Bp12p1BpAp1Bi2x0002*5
p8p1Dp26p1Bp18*5p8p1Dp48p1Bp18*7p8p1Bp26p1Bp48p1Bp1D*5p8p1DpAp1Bp
1B*7p26p1BpAp1Bp48p1Bp18p1Bp25p18+5p26p18p12p1Bp18+5p48p18p12p1Bp
18p18[2,3<3p8p48+3*7+5p48p1Bp8p18p1Dp88p18+5p48p1Bp26p18p18p18[2,
3$3p48p8pC}}{COM_R 19 0{TEXT 1 156 "Note, this formular is not va
lid when the knots coincide.  For example, it is not valid when b
=c.  The algorithm handles this case separately.  For example\015
"}}{INP_R 20 0 "> "{TEXT 0 37 "b2 := factor(bspline(2,u,[a,b,b,c]
));"}}{OUT_R 21 0 20{DAG :3n3\`b2`[2,5[2,3<3n3\`u`n3\`a`j2x0000[2
,3<3p8n3\`b`*5+5p8i2x0001pAj2x0001j2x0002+5p12p1ApAp17i2x0002[2,3
<3p8n3\`c`*5+5p8p1Ap29p17p1C+5p29p17p12p1Ap23[2,3$3p29p8pC}}
{COM_R 22 0{TEXT 1 60 "You can then substitute for particular val
ues for the knots\015"}}{INP_R 23 0 "> "{TEXT 0 31 "b1 := subs(a=
0,b=1,c=2,d=3,b1);"}}{OUT_R 24 0 23{DAG :3n3\`b1`[2,6[2,3<3n3\`u`
j2x0000pA[2,3<3p8j2x0001+3*3p8j2x0002/3p11p16[2,3<3p8p16+7p14i2x0
001/3i2x0003p16p11p8j2x0003[2,3<3p8p2A+3*3+5p2Ap11p8p22p16p18[2,3
$3p2Ap8pA}}{INP_R 25 0 "> "{TEXT 0 27 "b2 := subs(a=0,b=1,c=3,b2)
;"}}{OUT_R 26 0 25{DAG :3n3\`b2`[2,5[2,3<3n3\`u`j2x0000pA[2,3<3p8
j2x0001*3p8j2x0002[2,3<3p8j2x0003+3*3+5p8p11i2x0003p11p15/3p11j2x
0004[2,3$3p1Bp8pA}}{COM_R 27 0{TEXT 1 59 "Then convert the segmen
ts to a Maple function or procedure\015"}}{INP_R 28 0 "> "{TEXT 0
 29 "B1 := convert(b1, procedure):"}}{INP_R 29 0 "> "{TEXT 0 29 "
B2 := convert(b2, procedure):"}}{COM_R 30 0{TEXT 1 53 "\015And pl
ot the resulting B-spline segment polynomials\015"}}{INP_R 31 0 "
> "{TEXT 0 19 "plot(\{B1,B2\},0..3);"}}{COM_R 32 0{TEXT 1 122 "\0
15It is quite easy now to visualize the continuity.  We see that \+
there is a loss of continuity for the multiple knot case.\015"}}
{INP_R 33 0 "> "{TEXT 0 22 "plot(\{B1,D(B1)\},0..3);"}}{INP_R 34 
0 "> "{TEXT 0 22 "plot(\{B2,D(B2)\},0..3);"}}{INP_R 35 0 "> "
{TEXT 0 0 ""}}}{END}
