{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--*-140-*" "helvetica" "Helvetica-Bold" 8 12 0 
"Helvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" 
"times" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "-adobe-co
urier-medium-r-normal--20-*" "courier" "Courier" 4 20 192 "Courie
r" 20}{FONT 3 "-adobe-times-bold-r-normal--24-*" "times" "Courier
-Bold" 8 24 192 "Times-Bold" 24}{FONT 4 "-adobe-times-bold-r-norm
al--24-*" "times" "Courier-Bold" 8 24 192 "Times-Bold" 24}{FONT 5
 "-adobe-times-bold-r-normal--24-*" "times" "Courier-Bold" 8 24 
192 "Times-Bold" 24}{FONT 6 "-adobe-times-bold-r-normal--24-*" "t
imes" "Courier-Bold" 8 24 192 "Times-Bold" 24}{FONT 7 "-adobe-tim
es-bold-r-normal--24-*" "times" "Courier-Bold" 8 24 192 "Times-Bo
ld" 24}{FONT 8 "-adobe-times-bold-r-normal--24-*" "times" "Courie
r-Bold" 8 24 192 "Times-Bold" 24}{FONT 9 "-adobe-times-bold-r-nor
mal--24-*" "times" "Courier-Bold" 8 24 192 "Times-Bold" 24}{FONT 
10 "-adobe-times-bold-r-normal--24-*" "times" "Courier-Bold" 8 24
 192 "Times-Bold" 24}{SCP_R 1 0 316{COM_R 2 0{TEXT 3 0 ""}}{COM_R
 3 0{TEXT 3 45 "Numerical Integration using Symbolic Analysis"}}
{COM_R 4 0{TEXT 1 0 ""}}{COM_R 5 0{TEXT 1 130 "Keith O. Geddes\01
5Symbolic Computation Group\012Department of Computer Science\012
University of Waterloo\012Waterloo, Ontario\012Canada  N2L 3G1"}}
{COM_R 6 0{TEXT 1 0 ""}}{SEP_R 7 0}{SEP_R 8 0}{COM_R 9 0{TEXT 1 0
 ""}}{COM_R 10 0{TEXT 4 12 "Introduction"}}{COM_R 11 0{TEXT 1 188
 "\012The purpose of this worksheet is to illustrate the increase
d generality that can be achieved by a numerical integration code
 which exploits MAPLE's power for performing symbolic analysis."}
}{COM_R 12 0{TEXT 1 617 "\012Numerical integration codes typicall
y require the interval of integration to be finite and the integr
and to be finite at every point of the interval, although some nu
merical routines have been written to handle specific classes of 
singularities.\012The MAPLE computer algebra system is a natural 
environment in which to treat singularities.\012By using generali
zed series expansions, variable transformations, and other techni
ques, it is possible to automatically handle the numerical integr
ation problem in the presence of various types of singularities.\
012Moreover, integrals can be computed to arbitrarily high precis
ion."}}{COM_R 13 0{TEXT 1 0 ""}}{COM_R 14 0{TEXT 1 110 "Additiona
l details about the hybrid symbolic-numeric techniques discussed 
here can be found in [Geddes&Fee92]."}}{COM_R 15 0{TEXT 1 706 "\0
12The MAPLE system includes a powerful facility for the symbolic 
indefinite integration of elementary functions, ultimately based 
on the Risch integration algorithm (see [Geddes92], Chapter 12).\
012Also, many definite integrals (not otherwise handled by indefi
nite integration) can be expressed symbolically using special tec
hniques [Geddes&Scott89], [GGMS90], [Scott91].\012Nonetheless, ma
ny integration problems of practical interest fail to be solved b
y these techniques.\012MAPLE provides a facility to ``evaluate in
 floating-point mode'' those definite integrals which are left un
evaluated by the symbolic techniques of the int command, or which
 are deliberately left unevaluated by using the inert Int command
."}}{SEP_R 16 0}{SEP_R 17 0}{COM_R 18 0{TEXT 4 10 "\012Example 1"
}}{COM_R 19 0{TEXT 1 0 ""}}{INP_R 20 0 "> "{TEXT 0 28 "f := sin(x
)*ln(x)*exp(-x^3):"}}{INP_R 21 0 "> "{TEXT 0 22 "Int(f, x=0..infi
nity);"}}{OUT_R 22 0 21{DAG (3n3\`Int`,3*7(3n3\`sin`,2n3\`x`j2x00
01(3n3\`ln`p8pB(3n3\`exp`,2+3*3p9j2x0003i2x0001pB=3p9~3j2x0000n5\
`infinity`}}{SEP_R 23 0}{INP_R 24 0 "> "{TEXT 0 9 "evalf(\");"}}
{OUT_R 25 0 24{DAG e3i4x001957885158i2x0010}}{SEP_R 26 0}{INP_R 
27 0 "> "{TEXT 0 14 "evalf(\"\", 25);"}}{OUT_R 28 0 27{DAG e3i8x0
001957885158487997538390572i2x0025}}{SEP_R 29 0}{INP_R 30 0 "> "
{TEXT 0 0 ""}}{COM_R 31 0{TEXT 1 112 "\012The computation of the 
above numerical results employs several of the techniques illustr
ated in this worksheet."}}{COM_R 32 0{TEXT 1 0 ""}}{SEP_R 33 0}
{SEP_R 34 0}{COM_R 35 0{TEXT 1 0 ""}}{COM_R 36 0{TEXT 1 175 "Note
 that the integrand in the above example has the following shape,
 where we look at the plot on the finite interval x = 0..3 since 
it decays rapidly for larger values of x."}}{COM_R 37 0{TEXT 1 0 
""}}{INP_R 38 0 "> "{TEXT 0 16 "plot(f, x=0..3);"}}{COM_R 39 0
{TEXT 1 0 ""}}{INP_R 40 0 "> "{TEXT 0 0 ""}}{SEP_R 41 0}{SEP_R 42
 0}{COM_R 43 0{TEXT 5 55 "\012The Case of an Analytic Integrand o
n a Finite Interval"}}{COM_R 44 0{TEXT 1 957 "\012Along with the 
techniques for symbolic analysis discussed here, we need an effic
ient routine for numerical integration in the simple case where t
he interval of integration is finite and the integrand has no sin
gularities on the interval.\012Most traditional numerical integra
tion methods could serve for this purpose.\012However, since the 
aim of the symbolic analysis phase is to present the numerical in
tegration phase with an analytic integrand on a finite interval, 
we have found that the preferred default method is Clenshaw-Curti
s quadrature [Gentleman72], [Geddes79].\012This method, named ccq
uad, is based on computing the Chebyshev series expansion of the 
integrand on the specified interval and then integrating term-by-
term.\012Clenshaw-Curtis quadrature is at its best when the integ
rand is analytic in a sufficiently large region of the complex pl
ane surrounding the interval of integration, in which case the Ch
ebyshev series expansion converges quickly."}}{COM_R 45 0{TEXT 1 
622 "\012In MAPLE, ccquad is programmed to detect when convergenc
e is too slow (i.e. there is a nearby singularity, perhaps on the
 real line, perhaps somewhere else in the complex plane) and to r
eturn control to the main routine when this occurs.  The singular
ity-handling techniques are then invoked.\012If attempts to remov
e the singularity are unsuccessful, the code invokes another nume
rical integration routine named quadexp, an adaptive double-expon
ential quadrature method [Takahasi74].  The strength of this meth
od is that it is less sensitive than ccquad to the presence of si
ngularities near to the interval of integration."}}{COM_R 46 0
{TEXT 1 418 "\012Prior to the invocation of the numerical integra
tion routine, an evaluation procedure for the integrand is automa
tically generated via the MAPLE procedure makeproc.\012The purpos
e of this routine is to generate a procedure which accurately eva
luates the integrand at all arguments in the interval, taking car
e to handle removable singularities and points where floating-poi
nt cancellation would lead to loss of accuracy."}}{SEP_R 47 0}
{SEP_R 48 0}{COM_R 49 0{TEXT 3 11 "\012Example 2\012"}}{INP_R 50 
0 "> "{TEXT 0 24 "g := (x - sin(x)) / x^3;"}}{OUT_R 51 0 50{DAG :
3n3\`g`*5+5n3\`x`j2x0001(3n3\`sin`,2p5i2x0001p7p5i2x0003}}{INP_R 
52 0 "> "{TEXT 0 0 ""}}{SEP_R 53 0}{COM_R 54 0{TEXT 1 363 "\012A 
straightforward procedure to evaluate this expression would have 
two types of difficulties.  First, evaluating g at x = 0 leads to
 division by zero.\012If this problem is handled by returning the
 limiting value at x = 0, a second problem is the fact that for a
rgument values near zero, cancellation in floating-point arithmet
ic will lead to inaccurate evaluation."}}{SEP_R 55 0}{SEP_R 56 0}
{COM_R 57 0{TEXT 1 39 "\012For example, direct evaluation of g at
"}}{COM_R 58 0{TEXT 1 0 ""}}{COM_R 59 0{TEXT 1 31 "              
       x = .00321"}}{COM_R 60 0{TEXT 1 0 ""}}{COM_R 61 0{TEXT 1 
65 " in a 7-decimal-digit floating-point arithmetic yields the re
sult"}}{COM_R 62 0{TEXT 1 0 ""}}{COM_R 63 0{TEXT 1 32 "          
              .1813995"}}{COM_R 64 0{TEXT 1 0 ""}}{COM_R 65 0
{TEXT 1 31 " compared to the correct result"}}{COM_R 66 0{TEXT 1 
0 ""}}{COM_R 67 0{TEXT 1 30 "    g(.00321) = .16666658... ."}}
{COM_R 68 0{TEXT 1 211 "\012The procedure makeproc analyzes the i
ntegrand for removable singularities and for points where loss of
 accuracy may occur, and creates a procedure which uses a Taylor 
series expansion near points of difficulty."}}{SEP_R 69 0}{SEP_R 
70 0}{COM_R 71 0{TEXT 1 104 "\012For the expression g above with 
the precision set at Digits := 7, the following procedure is gene
rated."}}{COM_R 72 0{TEXT 1 0 ""}}{INP_R 73 0 "> "{TEXT 0 12 "Dig
its := 7:"}}{INP_R 74 0 "> "{TEXT 0 30 "readlib(`evalf/int/makepr
oc`):"}}{INP_R 75 0 "> "{TEXT 0 48 "gproc := `evalf/int/makeproc`
(g, x, 0, 1, 1E-7);"}}{OUT_R 76 0 75{DAG :3n4\`gproc`@7,2n3\`_t`,
1p8p8?4<3(3n3\`abs`,2a2x0001e3j3x05543816i2x0007(3n4\`subs`,3=3n3
\`_V`p11+5e3j3x01666667p17j2x0001*5+5e3i3x08333333i2x0009p28*3p1F
j2x0002e3j3x01984127i2x0010p28p1Fp35p28;3(3n5\`traperror`,2(3n4\`
evalc`,2(3n4\`evalf`,2(3p1A,3p1E*5+5p1Fp28(3n3\`sin`,2p1Fi2x0001p
28p1Fi2x0003?4>3n3\`"`n5\`lasterror`p67(3p49,2(3p4E,2(3n4\`limit`
,4p56p1En4\`real`p8}{TEXT 2 359 "\012gproc :=\012\012proc(_t)\012
    if abs(_t) < .5543816  then\012        subs(_V = _t,\012     
       .1666667 +(-.8333333*10^(-2)+.0001984127*_V^2)*_V^2)\012  
  else\012        traperror(evalc(evalf(subs(_V = _t,(_V-sin(_V))
/_V^3))))\012            ;\012        if \" <> lasterror then \"\
012        else\012            evalc(evalf(limit((_V-sin(_V))/_V^
3,_V = _t,real)))\012        fi\012    fi\012end\012"}}{INP_R 77 
0 "> "{TEXT 0 0 ""}}{SEP_R 78 0}{COM_R 79 0{TEXT 1 114 "\012With 
this procedure for evaluating the integrand g, we now get accurat
e results for small values of the argument."}}{COM_R 80 0{TEXT 1 
0 ""}}{INP_R 81 0 "> "{TEXT 0 14 "gproc(.00321);"}}{OUT_R 82 0 81
{DAG e3j3x01666666i2x0007}}{INP_R 83 0 "> "{TEXT 0 13 "Digits := 
10:"}}{INP_R 84 0 "> "{TEXT 0 0 ""}}{SEP_R 85 0}{SEP_R 86 0}
{COM_R 87 0{TEXT 3 30 "\012Generalized Series Expansions"}}{COM_R
 88 0{TEXT 1 234 "\012The main tool for analyzing integrand singu
larities is a facility for computing generalized series expansion
s of expressions, called hierarchical series [Geddes&Gonnet89].\0
12The standard MAPLE syntax for generating series expansions is"}
}{COM_R 89 0{TEXT 1 37 "\012     series(expr, var = value, ord);"
}}{COM_R 90 0{TEXT 1 237 "\012although some of the most general s
eries expansions which are needed are not returned by the series 
command in current versions of MAPLE.  (There are special series 
expansion routines associated with the numerical integration rout
ines.)"}}{COM_R 91 0{TEXT 1 391 "\012A generalized series expansi
on may not be a pure power series in the variable x but it may in
volve terms in ln(x), exp(-1/x), exp(-1/x^2), etc. These series e
xpansions will be understood to be one-sided expansions for x > 0
 .\012As long as the non-polynomial functions introduced into the
 series expansion can be bounded by powers of x, the mathematical
 validity of the series can be verified."}}{COM_R 92 0{TEXT 1 36 
"\012For example, for all x > 0 we have:"}}{COM_R 93 0{TEXT 1 22 
"\012     -1/x < ln(x) < x"}}{COM_R 94 0{TEXT 1 23 "\012     0 < 
exp(-1/x) < 1"}}{COM_R 95 0{TEXT 1 27 "\012     0 < exp(-1/x^2) <
 1 ."}}{COM_R 96 0{TEXT 1 0 ""}}{SEP_R 97 0}{SEP_R 98 0}{COM_R 99
 0{TEXT 4 10 "\012Example 3"}}{COM_R 100 0{TEXT 1 55 "\012Some ex
amples of generalized series are the following."}}{COM_R 101 0
{TEXT 1 0 ""}}{INP_R 102 0 "> "{TEXT 0 31 "series( sqrt(sin(x)), 
x=0, 5 );"}}{OUT_R 103 0 102{DAG +7*3n3\`x`/3j2x0001j2x0002p5*3p2
/3j2x0005p7/3i2x0001j2x0012(3n3\`O`,2*3p2/3j2x0009p7p5}}{SEP_R 
104 0}{INP_R 105 0 "> "{TEXT 0 33 "series( ln(1-cos(2*x)), x=0, 8
 );"}}{OUT_R 106 0 105{DAG _Cn3\`x`+5(3n3\`ln`,2j2x0002j2x0001(3p
5,2*3p1i2x0001i2x0002x0/3p11j2x0003x2/3p11j2x0090x4/3p13j2x2835x6
(3n3\`O`,2pAx8}}{SEP_R 107 0}{INP_R 108 0 "> "{TEXT 0 31 "readlib
(`evalf/int/genseries`):"}}{INP_R 109 0 "> "{TEXT 0 55 "`evalf/in
t/genseries`( 1/(1-x*exp(-cos(x)/x)), x=0, 6):"}}{INP_R 110 0 "> 
"{TEXT 0 22 "# Drop the order term."}}{INP_R 111 0 "> "{TEXT 0 19
 "eval(subs(O=0, \"));"}}{OUT_R 112 0 111{DAG +Fj2x0001p1*5n3\`x`
p1(3n3\`exp`,2+3*3p5i2x0001pFp1p1*5p5j2x0002p8p1/3p1p16*5p5j2x000
3p8p1/3p1j2x0008*5p5p16p8p16p1*5p5j2x0004p8p1/3pFj2x0048*5p5p1Fp8
p16p1}}{INP_R 113 0 "> "{TEXT 0 0 ""}}{SEP_R 114 0}{COM_R 115 0
{TEXT 1 146 "\012Note:  The latter example is a case which is not
 currently handled by MAPLE's series command but rather it is gen
erated by a specialized routine."}}{COM_R 116 0{TEXT 1 0 ""}}
{SEP_R 117 0}{SEP_R 118 0}{COM_R 119 0{TEXT 5 38 "\012Transformin
g to an Analytic Integrand"}}{COM_R 120 0{TEXT 1 331 "\012If an i
ntegrand is found to be non-analytic at a point of the interval o
f integration, the first technique tried is to look for a transfo
rmation which will remove the singularity.\012The types of transf
ormations which are attempted include:\012   (i) subtracting off 
the singularity, and\012  (ii) an algebraic transformation of var
iables."}}{COM_R 121 0{TEXT 1 403 "\012In each case, the fundamen
tal tool for symbolic analysis is the generalized series expansio
n discussed in the preceding section.  By appropriate change of v
ariables, we may assume that the singularity is at the left end-p
oint of the interval and that the left end-point is zero.  This p
roperty is important because of the one-sided validity of some of
 the generalized series expansions being generated."}}{COM_R 122 
0{TEXT 1 148 "\012Let f be the integrand, x be the variable of in
tegration, x = 0 be the singular point, and s be the generalized 
series expansion of f about \015x = 0."}}{COM_R 123 0{TEXT 1 645 
"\012For case (i), the method used is to test each term in the ex
pansion s to determine which terms are regular (i.e. have a Taylo
r series expansion at x = 0).  If the number of non-regular terms
 is less than half the number of terms in s, then make the conjec
ture that the expression f - q might be analytic at x = 0, where 
q denotes the sum of the non-regular terms.  Test this conjecture
, and if it is true then the numerical integration of f - q can p
roceed normally.\012In some cases, the non-regular part q will be
 integrable by the symbolic integrator;  otherwise, it will be pa
ssed on to the general techniques discussed in subsequent section
s."}}{COM_R 124 0{TEXT 1 0 ""}}{SEP_R 125 0}{SEP_R 126 0}{COM_R 
127 0{TEXT 6 10 "\012Example 4"}}{COM_R 128 0{TEXT 1 0 ""}}{INP_R
 129 0 "> "{TEXT 0 22 "h := ln(1 - cos(2*x));"}}{OUT_R 130 0 129
{DAG :3n3\`h`(3n3\`ln`,2+5j2x0001p8(3n3\`cos`,2+3n3\`x`j2x0002i2x
0001}}{SEP_R 131 0}{INP_R 132 0 "> "{TEXT 0 15 "Int(h, x=0..1);"}
}{OUT_R 133 0 132{DAG (3n3\`Int`,3(3n3\`ln`,2+5j2x0001p9(3n3\`cos
`,2+3n3\`x`j2x0002i2x0001=3p11~3j2x0000p9}}{INP_R 134 0 "> "{TEXT
 0 0 ""}}{SEP_R 135 0}{COM_R 136 0{TEXT 1 73 "\012The generalized
 series expansion of h at x = 0 takes the following form."}}
{COM_R 137 0{TEXT 1 0 ""}}{INP_R 138 0 "> "{TEXT 0 18 "series(h, 
x=0, 8);"}}{OUT_R 139 0 138{DAG _Cn3\`x`+5(3n3\`ln`,2j2x0002j2x00
01(3p5,2*3p1i2x0001i2x0002x0/3p11j2x0003x2/3p11j2x0090x4/3p13j2x2
835x6(3n3\`O`,2pAx8}}{INP_R 140 0 "> "{TEXT 0 0 ""}}{SEP_R 141 0}
{COM_R 142 0{TEXT 1 24 "\012The non-regular part is"}}{COM_R 143 
0{TEXT 1 0 ""}}{INP_R 144 0 "> "{TEXT 0 16 "q := -2*ln(1/x);"}}
{OUT_R 145 0 144{DAG :3n3\`q`+3(3n3\`ln`,2*3n3\`x`i2x0001i2x0002}
}{INP_R 146 0 "> "{TEXT 0 0 ""}}{SEP_R 147 0}{COM_R 148 0{TEXT 1 
19 "\012The new expression"}}{COM_R 149 0{TEXT 1 0 ""}}{INP_R 150
 0 "> "{TEXT 0 14 "newh := h - q;"}}{OUT_R 151 0 150{DAG :3n4\`ne
wh`+5(3n3\`ln`,2+5j2x0001pA(3n3\`cos`,2+3n3\`x`j2x0002i2x0001pA(3
p6,2*3p12p16p14}}{INP_R 152 0 "> "{TEXT 0 0 ""}}{SEP_R 153 0}
{COM_R 154 0{TEXT 1 80 "\012is analytic on the interval [0, 1].\0
12Thus it can be integrated easily by ccquad."}}{COM_R 155 0{TEXT
 1 0 ""}}{INP_R 156 0 "> "{TEXT 0 31 "r1 := evalf(Int(newh, x=0..
1));"}}{OUT_R 157 0 156{DAG :3n3\`r1`e3j4x005797067686i2x0010}}
{INP_R 158 0 "> "{TEXT 0 0 ""}}{SEP_R 159 0}{COM_R 160 0{TEXT 1 
99 "\012(computing to 10 digits of accuracy).\012Integrating q is
 easy because it has the indefinite integral"}}{COM_R 161 0{TEXT 
1 0 ""}}{INP_R 162 0 "> "{TEXT 0 10 "int(q, x);"}}{OUT_R 163 0 
162{DAG +5*5(3n3\`ln`,2*3n3\`x`i2x0001j2x0001p7pBi2x0002p7pF}}
{INP_R 164 0 "> "{TEXT 0 0 ""}}{SEP_R 165 0}{COM_R 166 0{TEXT 1 
66 "\012and its definite integral can therefore be computed symbo
lically."}}{COM_R 167 0{TEXT 1 0 ""}}{INP_R 168 0 "> "{TEXT 0 21 
"r2 := int(q, x=0..1);"}}{OUT_R 169 0 168{DAG :3n3\`r2`i2x0002}}
{INP_R 170 0 "> "{TEXT 0 0 ""}}{SEP_R 171 0}{COM_R 172 0{TEXT 1 
100 "\012Finally, summing the two values, we obtain the value for
 the original definite integration problem."}}{COM_R 173 0{TEXT 1
 0 ""}}{INP_R 174 0 "> "{TEXT 0 27 "Int(h, x=0..1)  =  r1 + r2;"}
}{OUT_R 175 0 174{DAG =3(3n3\`Int`,3(3n3\`ln`,2+5j2x0001pA(3n3\`c
os`,2+3n3\`x`j2x0002i2x0001=3p12~3j2x0000pAe3i4x001420293231i2x00
09}}{INP_R 176 0 "> "{TEXT 0 0 ""}}{SEP_R 177 0}{SEP_R 178 0}
{COM_R 179 0{TEXT 1 559 "\012Case (ii) is the case of an algebrai
c transformation of variables.  This method comes into effect whe
never there are fractional powers of x appearing in the series ex
pansion s, whether or not there are other non-regular functions a
ppearing in the expansion.\012The idea is to transform away algeb
raic singularities, and if other singularities remain they will b
e handled on a subsequent pass.\012The specific method used is to
 compute the least common multiple n of all denominators of the f
ractional powers, and then to apply the change of variables t = x
^(1/n) ."}}{COM_R 180 0{TEXT 1 0 ""}}{SEP_R 181 0}{SEP_R 182 0}
{COM_R 183 0{TEXT 3 10 "\012Example 5"}}{COM_R 184 0{TEXT 1 0 ""}
}{INP_R 185 0 "> "{TEXT 0 18 "F := sqrt(sin(x));"}}{OUT_R 186 0 
185{DAG :3n3\`F`*3(3n3\`sin`,2n3\`x`/3j2x0001j2x0002}}{INP_R 187 
0 "> "{TEXT 0 15 "Int(F, x=0..2);"}}{OUT_R 188 0 187{DAG (3n3\`In
t`,3*3(3n3\`sin`,2n3\`x`/3j2x0001j2x0002=3p9~3j2x0000pE}}{INP_R 
189 0 "> "{TEXT 0 0 ""}}{SEP_R 190 0}{COM_R 191 0{TEXT 1 62 "\012
The generalized series expansion of F at x = 0 is of the form"}}
{COM_R 192 0{TEXT 1 0 ""}}{INP_R 193 0 "> "{TEXT 0 18 "series(F, 
x=0, 5);"}}{OUT_R 194 0 193{DAG +7*3n3\`x`/3j2x0001j2x0002p5*3p2/
3j2x0005p7/3i2x0001j2x0012(3n3\`O`,2*3p2/3j2x0009p7p5}}{INP_R 195
 0 "> "{TEXT 0 0 ""}}{SEP_R 196 0}{COM_R 197 0{TEXT 1 52 "\012App
lying the change of variables t = x^(1/2) yields"}}{COM_R 198 0
{TEXT 1 0 ""}}{INP_R 199 0 "> "{TEXT 0 60 "r3 := Int( diff(t^2, t
) * subs(x=t^2, F),  t = 0..sqrt(2) );"}}{OUT_R 200 0 199{DAG :3n
3\`r3`(3n3\`Int`,3+3*5n3\`t`j2x0001(3n3\`sin`,2*3p9j2x0002/3pBp13
p13=3p9~3j2x0000*3p13p15}}{INP_R 201 0 "> "{TEXT 0 0 ""}}{SEP_R 
202 0}{COM_R 203 0{TEXT 1 83 "\012The new integrand is analytic a
nd therefore it can be integrated easily by ccquad."}}{COM_R 204 
0{TEXT 1 0 ""}}{INP_R 205 0 "> "{TEXT 0 10 "evalf(r3);"}}{OUT_R 
206 0 205{DAG e3j4x001620723408i2x0009}}{INP_R 207 0 "> "{TEXT 0 
0 ""}}{SEP_R 208 0}{SEP_R 209 0}{COM_R 210 0{TEXT 4 43 "\012Direc
t Integration of a Generalized Series"}}{COM_R 211 0{TEXT 1 669 "
\012Suppose that we have an integrand with a singularity at the l
eft end-point x = 0.  Suppose further that we have not succeeded 
in finding a transformation which removes the singularity.\012The
n the method used is to treat the generalized series expansion as
 an approximation of the integrand near the singularity, and to d
irectly integrate this generalized series over its interval of ac
curacy.\012The remainder of the interval can then be handled by t
he numerical integration method.\012It is crucial that we move as
 far as possible away from the singularity before resuming, becau
se the efficiency of numerical integration methods is affected by
 the nearness of singularities."}}{COM_R 212 0{TEXT 1 500 "\012Th
e success of this technique relies on the power of MAPLE's symbol
ic integrator to handle many of the singular functions which may 
arise.\015For series involving ln(x), the indefinite integral of 
ln(x)*x^k is an elementary function.\012For series involving exp(
-1/x), the indefinite integral of exp(-1/x)*x^k can be expressed 
in terms of the exponential integral Ei(t).\012Similarly, series 
involving the singular function exp(-1/x^2) may lead to both the 
exponential integral and the error function erf(t)."}}{COM_R 213 
0{TEXT 1 0 ""}}{SEP_R 214 0}{SEP_R 215 0}{COM_R 216 0{TEXT 5 10 "
\012Example 6"}}{COM_R 217 0{TEXT 1 0 ""}}{INP_R 218 0 "> "{TEXT 
0 39 "G := exp(v - v^2/2) / (1 + 1/2*exp(v));"}}{OUT_R 219 0 218
{DAG :3n3\`G`*5(3n3\`exp`,2+5n3\`v`j2x0001*3p9j2x0002/3i2x0001pFp
B+5pBpB(3p5,2p9/3pBpFp12}}{SEP_R 220 0}{INP_R 221 0 "> "{TEXT 0 
22 "Int(G, v=0..infinity);"}}{OUT_R 222 0 221{DAG (3n3\`Int`,3*5(
3n3\`exp`,2+5n3\`v`j2x0001*3pAj2x0002/3i2x0001p10pC+5pCpC(3p6,2pA
/3pCp10p13=3pA~3j2x0000n5\`infinity`}}{INP_R 223 0 "> "{TEXT 0 0 
""}}{SEP_R 224 0}{COM_R 225 0{TEXT 1 110 "\012First, the interval
 is split into 0..1 and 1..infinity .\012For the finite interval,
 ccquad is applied directly."}}{COM_R 226 0{TEXT 1 0 ""}}{INP_R 
227 0 "> "{TEXT 0 29 "r01 := evalf(Int(G, v=0..1));"}}{OUT_R 228 
0 227{DAG :3n3\`r01`e3j4x007580564829i2x0010}}{INP_R 229 0 "> "
{TEXT 0 0 ""}}{SEP_R 230 0}{COM_R 231 0{TEXT 1 115 "\012For the i
nfinite interval, the change of variables v = 1/x transforms the 
problem into the new integration problem"}}{COM_R 232 0{TEXT 1 0 
""}}{INP_R 233 0 "> "{TEXT 0 58 "r1inf := Int( - diff(1/x, x) * s
ubs(v=1/x, G), x = 0..1 );"}}{OUT_R 234 0 233{DAG :3n4\`r1inf`(3n
3\`Int`,3*7n3\`x`i2x0002(3n3\`exp`,2+5*3p9i2x0001j2x0001*3p9pB/3p
14j2x0002p16+5p16p16(3pE,2p12/3p16p1Dp14=3p9~3j2x0000p16}}{INP_R 
235 0 "> "{TEXT 0 0 ""}}{SEP_R 236 0}{COM_R 237 0{TEXT 1 123 "\01
2Let the integrand appearing here be named g.  The first few term
s of the generalized series expansion of g are as follows."}}
{COM_R 238 0{TEXT 1 0 ""}}{INP_R 239 0 "> "{TEXT 0 18 "g := op(1,
 r1inf);"}}{OUT_R 240 0 239{DAG :3n3\`g`*7n3\`x`i2x0002(3n3\`exp`
,2+5*3p4i2x0001j2x0001*3p4p6/3pFj2x0002p11+5p11p11(3p9,2pD/3p11p1
8pF}}{SEP_R 241 0}{INP_R 242 0 "> "{TEXT 0 38 "s := `evalf/int/ge
nseries`(g, x=0, 6);"}}{OUT_R 243 0 242{DAG :3n3\`s`+F*5n3\`x`i2x
0002(3n3\`exp`,2+3*3p5p7i2x0001/3j2x0001j2x0002p16*7p5p7p9p13(3pA
,2+3*3p5p11p11p14i2x0004*7p5p7p9p13p1Ep16j2x0008*7p5p7p9p13p1Ej2x
0003i2x0016*7p5p7p9p13p1Ej2x0004j2x0032*7p5p7p9p13p1Ej2x0005i2x00
64(3n3\`O`,2*3p1Ej2x0006p14}}{INP_R 244 0 "> "{TEXT 0 0 ""}}
{SEP_R 245 0}{COM_R 246 0{TEXT 1 110 "\012MAPLE's symbolic integr
ator determines that the first two terms of s have the following 
indefinite integrals."}}{COM_R 247 0{TEXT 1 0 ""}}{INP_R 248 0 ">
 "{TEXT 0 16 "int(op(1,s), x);"}}{OUT_R 249 0 248{DAG +3*7n3\`Pi`
/3j2x0001j2x0002p7p4(3n3\`erf`,2+3*5p7p4n3\`x`i2x0001p4p5p15}}
{SEP_R 250 0}{INP_R 251 0 "> "{TEXT 0 16 "int(op(2,s), x);"}}
{OUT_R 252 0 251{DAG +3*9n3\`Pi`/3j2x0001j2x0002(3n3\`exp`,2p4p5p
7p4(3n3\`erf`,2+5*5p7p4n3\`x`i2x0001p4*3p7p4p4p5p7}}{INP_R 253 0 
"> "{TEXT 0 0 ""}}{SEP_R 254 0}{COM_R 255 0{TEXT 1 224 "\012Simil
arly, the integral of each term is computed.\012If we compute the
 definite integral over [0, 0.25], say, of the successive terms o
f the generalized series expansion of g, we find that the success
ive values are as follows."}}{COM_R 256 0{TEXT 1 0 ""}}{INP_R 257
 0 "> "{TEXT 0 13 "Digits := 20:"}}{INP_R 258 0 "> "{TEXT 0 41 "s
eq( int(op(i,s), x=0..0.25), i = 1..6 ):"}}{INP_R 259 0 "> "{TEXT
 0 15 "evalf( [ \" ] );"}}{OUT_R 260 0 259{DAG [2,7e3j5x158776060
5431491i2x0019e3i5x0047386157552546p8e3j4x146185587516i2x0018e3i3
x46204200i2x0016e3j3x00014875i2x0014e3i2x0005i2x0012}}{SEP_R 261 
0}{INP_R 262 0 "> "{TEXT 0 0 ""}}{COM_R 263 0{TEXT 1 165 "\012Cle
arly, the series representation is rapidly converging on this int
erval.\012Summing up these values yields the following result for
 the integral\012of g over [0, 0.25]."}}{COM_R 264 0{TEXT 1 0 ""}
}{INP_R 265 0 "> "{TEXT 0 24 "r1 := convert( \", `+` );"}}{OUT_R 
266 0 265{DAG :3n3\`r1`e3j5x1541791537054105i2x0019}}{SEP_R 267 0
}{INP_R 268 0 "> "{TEXT 0 13 "Digits := 10:"}}{INP_R 269 0 "> "
{TEXT 0 0 ""}}{COM_R 270 0{TEXT 1 146 "\012For the remaining inte
rval [0.25, 1], ordinary numerical integration methods encounter 
no difficulties because there are no nearby singularities."}}
{COM_R 271 0{TEXT 1 0 ""}}{INP_R 272 0 "> "{TEXT 0 31 "r2 := eval
f(Int(g, x=0.25..1));"}}{OUT_R 273 0 272{DAG :3n3\`r2`e3j4x005473
062371i2x0010}}{INP_R 274 0 "> "{TEXT 0 49 "# Sum these two value
s to get the integral r1inf."}}{INP_R 275 0 "> "{TEXT 0 6 "r1inf;
"}}{OUT_R 276 0 275{DAG (3n3\`Int`,3*7n3\`x`i2x0002(3n3\`exp`,2+5
*3p5i2x0001j2x0001*3p5p7/3p10j2x0002p12+5p12p12(3pA,2pE/3p12p19p1
0=3p5~3j2x0000p12}}{INP_R 277 0 "> "{TEXT 0 19 "r1inf  :=  r1 + r
2;"}}{OUT_R 278 0 277{DAG :3n4\`r1inf`e3j4x005474604163i2x0010}}
{INP_R 279 0 "> "{TEXT 0 0 ""}}{COM_R 280 0{TEXT 1 0 ""}}{COM_R 
281 0{TEXT 1 74 "Finally, we have obtained the answer for the ori
ginal integration problem."}}{COM_R 282 0{TEXT 1 0 ""}}{INP_R 283
 0 "> "{TEXT 0 38 "Int(G, v=0..infinity)  =  r01 + r1inf;"}}
{OUT_R 284 0 283{DAG =3(3n3\`Int`,3*5(3n3\`exp`,2+5n3\`v`j2x0001*
3pBj2x0002/3i2x0001p11pD+5pDpD(3p7,2pB/3pDp11p14=3pB~3j2x0000n5\`
infinity`e3j4x001305516899i2x0009}}{INP_R 285 0 "> "{TEXT 0 0 ""}
}{SEP_R 286 0}{SEP_R 287 0}{COM_R 288 0{TEXT 1 0 ""}}{COM_R 289 0
{TEXT 9 18 "Concluding Remarks"}}{COM_R 290 0{TEXT 1 0 ""}}{COM_R
 291 0{TEXT 1 272 "The user can set  infolevel[`evalf/int`] := 4;
  in a MAPLE session to see user-level information about a numeri
cal integration computation.  One sees that the techniques of sym
bolic analysis discussed in this article are employed automatical
ly by the evalf/int procedures."}}{COM_R 292 0{TEXT 1 0 ""}}
{COM_R 293 0{TEXT 1 108 "For example, with such an infolevel sett
ing you might wish to try the following examples in a MAPLE sessi
on."}}{COM_R 294 0{TEXT 1 0 ""}}{COM_R 295 0{TEXT 8 72 "Digits :=
 10;\015Int( sin(x)*ln(x)*exp(-x^3),  x = 0..infinity );\015evalf
(\");"}}{COM_R 296 0{TEXT 1 0 ""}}{COM_R 297 0{TEXT 4 61 "Digits 
:= 20;\015Int( (x - sin(x)) / x^3,  x = 0..1 );\015evalf(\");"}}
{COM_R 298 0{TEXT 1 0 ""}}{COM_R 299 0{TEXT 5 59 "Digits := 20;\0
15Int( ln(1 - cos(2*x)),  x = 0..1 );\015evalf(\");"}}{COM_R 300 
0{TEXT 1 0 ""}}{COM_R 301 0{TEXT 7 82 "Digits := 10;\015Int( exp(
v - v^2/2) / (1 + 1/2*exp(v)),  v = 0..infinity);\015evalf(\");"}
}{COM_R 302 0{TEXT 1 0 ""}}{SEP_R 303 0}{SEP_R 304 0}{COM_R 305 0
{TEXT 1 0 ""}}{COM_R 306 0{TEXT 10 10 "REFERENCES"}}{COM_R 307 0
{TEXT 1 127 "\012[Geddes79]  K.O. Geddes.\012Remark on Algorithm 
424:  Clenshaw-Curtis quadrature.\012ACM Trans. Math. Software, 5
 (2), 1979, p. 240."}}{COM_R 308 0{TEXT 1 128 "\012[Geddes92]  K.
O. Geddes, S.R. Czapor, and G. Labahn.\012Algorithms for Computer
 Algebra.\012Kluwer Academic Publishers, Boston, 1992."}}{COM_R 
309 0{TEXT 1 152 "\015[Geddes&Fee92]  K.O. Geddes and G.J. Fee.\0
12Hybrid symbolic-numeric integration in MAPLE.\012Proceedings of
 ISSAC '92, ACM Press, New York, 1992, pp. 36-41."}}{COM_R 310 0
{TEXT 1 263 "\012[Geddes&Gonnet89]  K.O. Geddes and G.H. Gonnet.\
012A new algorithm for computing symbolic limits using hierarchic
al series.\012Symbolic and Algebraic Computation, P. Gianni (ed.)
,\012Lecture Notes in Computer Science, No. 358, \012Springer-Ver
lag, Berlin, 1989, pp. 490-495."}}{COM_R 311 0{TEXT 1 233 "\012[G
eddes&Scott89]  K.O. Geddes and T.C. Scott.\012Recipes for classe
s of definite integrals involving exponentials and logarithms.\01
2Computers and Mathematics, E. Kaltofen and S.M. Watt (ed.),\012S
pringer-Verlag, New York, 1989, pp. 192-201."}}{COM_R 312 0{TEXT 
1 113 "\012[Gentleman72]  W.M. Gentleman.\012Algorithm 424:  Clen
shaw-Curtis Quadrature.\012Comm. ACM, 15 (5), 1972, pp. 353-355."
}}{COM_R 313 0{TEXT 1 281 "\012[GGMS90]  K.O. Geddes, M.L. Glasse
r, R.A. Moore, and T.C. Scott.\012Evaluation of classes of defini
te integrals involving elementary functions via differentiation o
f special functions.\012Applicable Algebra in Engineering, Commun
ication and Computing, 1 (2), November 1990, pp. 149-165."}}
{COM_R 314 0{TEXT 1 199 "\012[Scott91]  Tony Scott.\012Recipes fo
r solving definite integrals involving exponentials and logarithm
s (Part II).\012The MAPLE Technical Newsletter, No. 5, Waterloo M
aple Software, Winter 1991, pp. 16-23."}}{COM_R 315 0{TEXT 1 153 
"\012[Takahasi74]  Hidetosi Takahasi and Masatake Mori.\012Double
 exponential formulas for numerical integration.\012Publ. RIMS, K
yoto Univ., 9, 1974, pp. 721-741."}}{COM_R 316 0{TEXT 1 0 ""}}
{INP_R 317 0 "> "{TEXT 0 0 ""}}}{END}
