{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 12}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-new century schoolbook-bold-r-normal--17-*" "n
ew century schoolbook" "Times-Bold" 8 17 64 "Times-Bold" 17}
{SCP_R 1 0 124{INP_R 2 0 "> "{TEXT 0 0 ""}}{COM_R 3 0{TEXT 3 39 "
Computations on the 3 n + 1 conjecture\012"}}{COM_R 4 0{TEXT 1 
123 "Worksheet created by Michael Monagan,\015Text taken from Col
latz.tex, Gaston H. Gonnet, Informatik E.T.H. Zurich, Switzerland
\012"}}{COM_R 5 0{TEXT 1 435 "The 3n+1 sequence has probably cons
umed more CPU time than any other number theoretic conjecture.  T
he reason being that its statement is so simple, that most amateu
rs will feel compelled to write programs to test it.  This sequen
ce, attributed to Lothar Collatz, has bee given various names, in
cluding Ulam's conjecture, Syracuse problem,  Kakutani's problem 
and Hasse's algorithm. The conjecture is based on the iteration d
efined by:"}}{COM_R 6 0{TEXT 1 64 "\012          n[i+1] = if n[i]
 is even then n[i]/2 else 3*n[i]+1 .\012"}}{COM_R 7 0{TEXT 1 52 "
For example, if n[1]=7 the sequence goes as follows\012"}}{INP_R 
8 0 "> "{TEXT 0 10 "n[1] := 7;"}}{OUT_R 9 0 8{DAG :3b3n3\`n`,2j2x
0001j2x0007}}{INP_R 10 0 "> "{TEXT 0 21 "for i from 1 to 20 do"}}
{INP_R 11 0 "> "{TEXT 0 77 "    if irem(n[i],2)=0 then n[i+1] := 
iquo(n[i],2) else n[i+1] := 3*n[i]+1 fi;"}}{INP_R 12 0 "> "{TEXT 
0 3 "od;"}}{INP_R 13 0 "> "{TEXT 0 21 "seq( n[i], i=1..20 );"}}
{OUT_R 14 0 13{DAG ,15j2x0007j2x0022j2x0011j2x0034j2x0017j2x0052j
2x0026j2x0013j2x0040j2x0020j2x0010j2x0005j2x0016j2x0008j2x0004j2x
0002j2x0001p1Dp1Fp21}}{COM_R 15 0{TEXT 1 1325 "In this case it is
 obvious that the sequence entered a cycle and will repeat the va
lues 4,2,1 forever.  The 3n+1 conjecture states that for any star
ting positive integer, the sequence eventually reaches 1 and repe
ats as above.\012\012Jeffrey Lagarias published an excellent arti
cle summarizing most of the work done on this problem.  His artic
le appeared in\012the American Mathematical Monthly, Volume 92, N
umber 1, January 1985, pages 3-23.  Any reader who is interested 
in doing work on this problem is urged to read Lagarias' article.
\012\012The purpose of this note is to show how to compute iterat
ions of this series efficiently using Maple.  The programs that w
e will show, can compute thousands of iterations over terms which
 are thousands of digits long in reasonably short times.\012\012W
e provide two main functions for working with these sequences: ``
DistTo1'' computes the number of iterations that will take its ar
gument to reach the value 1 for the first time and ``Iterate'' it
erates its first argument the number of times specified in its se
cond argument.  Both functions use a recursive modular computatio
n of the terms which requires some additional explanation.\012\01
2Let sigma(n) denote the number of iterations required to reduce 
n to 1, or what we call the distance to 1.\012The following relat
ions are known and/or easy to derive:"}}{INP_R 16 0 "> "{TEXT 0 
31 "sigma( n*2^k ) = sigma (n) + k;"}}{OUT_R 17 0 16{DAG =3(3n4\`
sigma`,2*5n3\`n`j2x0001^3j2x0002n3\`k`p9+5(3p2,2p7p9pEp9}}{INP_R 
18 0 "> "{TEXT 0 47 "sigma ( n*2^k - 1 ) = sigma( n*3^k - 1 ) + 2
*k;"}}{OUT_R 19 0 18{DAG =3(3n4\`sigma`,2+5*5n3\`n`j2x0001^3j2x00
02n3\`k`pApAi2x0001pA+5(3p2,2+5*5p8pA^3j2x0003pFpApAp13pApApFpD}}
{INP_R 20 0 "> "{TEXT 0 48 "sigma ( n*4^k + 1 ) = sigma ( n*3^k +
 1 ) + 3*k;"}}{OUT_R 21 0 20{DAG =3(3n4\`sigma`,2+5*5n3\`n`j2x000
1^3j2x0004n3\`k`pApApApA+5(3p2,2+5*5p8pA^3j2x0003pFpApApApApApFp1
E}}{COM_R 22 0{TEXT 1 142 "It is easy to see that for any value o
f n, the first k iterations which divide by 2 depend exclusively 
on the value of n mod 2^k, for example."}}{INP_R 23 0 "> "{TEXT 0
 36 "sigma( 8*n+3 ) = sigma( 9*n+4 ) + 5;"}}{OUT_R 24 0 23{DAG =3
(3n4\`sigma`,2+5n3\`n`j2x0008j2x0003j2x0001+5(3p2,2+5p7j2x0009j2x
0004pDpDj2x0005pD}}{INP_R 25 0 "> "{TEXT 0 36 "sigma( 8*n+5 ) = s
igma( 3*n+2 ) + 4;"}}{OUT_R 26 0 25{DAG =3(3n4\`sigma`,2+5n3\`n`j
2x0008j2x0005j2x0001+5(3p2,2+5p7j2x0003j2x0002pDpDj2x0004pD}}
{COM_R 27 0{TEXT 1 838 "It should also be observed that the facto
r that multiplies n in the resulting term is always a power of 3.
  Furthermore, this power of 3 corresponds exactly to the number 
of 3n+1 iterations necessary while doing the k divide by two iter
ations.\012\012The above suggests that we could run the iteration
 in symbolic terms, say for an arbitrary value of k by computing 
the coefficients for the resulting iterations.  This strategy has
 two immediate advantages.  First, for very large numbers, we wil
l need to do the computation with long numbers only once for ever
y k division by two steps; secondly, we could easily tabulate all
 the possible values for small values of k, and hence save in the
 computation of the coefficients themselves.  In mathematical ter
ms, what we will compute are the functions a_k and b_k defined by
 the following equation"}}{INP_R 28 0 "> "{TEXT 0 59 "sigma ( 2^k
*n[1] + n[0] ) = sigma ( 3^(b[k]( n[0] ))*n[1] +"}}{INP_R 29 0 ">
 "{TEXT 0 34 "a[k]( n[0] ) ) + k + b[k]( n[0] );"}}{OUT_R 30 0 29
{DAG =3(3n4\`sigma`,2+5^3j2x0002n3\`k`j2x0007b3n3\`n`,2j2x0000j2x
0001+7(3p2,2+5^3j2x0003(3b3n3\`b`,2pA,2pEpC(3b3n3\`a`p22p24p14p14
pAp14p1Ep14}}{COM_R 31 0{TEXT 1 120 "By analyzing two steps of su
ch an iteration we can derive the function a[2*k] and b[2*k] in t
erms of a[k] and b[k].  Let"}}{INP_R 32 0 "> "{TEXT 0 20 "n = n[1
]*2^k + n[0];"}}{OUT_R 33 0 32{DAG =3n3\`n`+5^3j2x0002n3\`k`j2x00
07b3p1,2j2x0000j2x0001}}{INP_R 34 0 "> "{TEXT 0 37 "q = n[1]*3^(b
[k](n[0])) + a[k](n[0]);"}}{OUT_R 35 0 34{DAG =3n3\`q`+5^3j2x0003
(3b3n3\`b`,2n3\`k`,2b3n3\`n`,2j2x0000j2x0007(3b3n3\`a`pBpEj2x0001
}}{COM_R 36 0{TEXT 1 4 "then"}}{INP_R 37 0 "> "{TEXT 0 73 "a[2*k]
(n) = floor( q/2^k ) * 3^(b[k](' q mod 2^k ')) + a[k]('q mod 2^k'
);"}}{OUT_R 38 0 37{DAG =3(3b3n3\`a`,2+3n3\`k`j2x0002,2n3\`n`+5*5
(3n4\`floor`,2*5n3\`q`j2x0001^3p9p7i2x0001p18^3j2x0003(3b3n3\`b`,
2p7,2(3n3\`mod`,3p16p1Ap18p18(3b3p3p27p29p18}}{INP_R 39 0 "> "
{TEXT 0 43 "b[2*k](n) = b[k](n[0]) + b[k]('q mod 2^k');"}}{OUT_R 
40 0 39{DAG =3(3b3n3\`b`,2+3n3\`k`j2x0002,2n3\`n`+5(3b3p3,2p7,2b3
pC,2j2x0000j2x0001(3p10,2(3n3\`mod`,3n3\`q`^3p9p7p1A}}{COM_R 41 0
{TEXT 1 432 "\012As it turns out, this gives us a very efficient 
method for computing several iterations of the recurrence at once
.  The main program to compute the sigma(n) function will compute
 k as an appropriate power of two, as large as possible, but guar
anteeing that the series will not reach 1 in less than k steps.  
This is achieved simply by insuring that 2^k < n.  The function d
efinition, argument checking and initialization look like:"}}
{INP_R 42 0 "> "{TEXT 0 56 "DistTo1 := proc(n:posint) local its, 
t, qt, u, rt, bits;"}}{INP_R 43 0 "> "{TEXT 0 13 "    its := 0;"}
}{INP_R 44 0 "> "{TEXT 0 11 "    t := n;"}}{INP_R 45 0 "> "{TEXT 
0 6 "    do"}}{COM_R 46 0{TEXT 1 86 "If the argument is small eno
ugh (or becomes small enough) compute the result directly."}}
{INP_R 47 0 "> "{TEXT 0 72 "        if t < 10 then RETURN( op(t,[
0,1,7,2,5,8,16,3,19,6]) + its ) fi;"}}{COM_R 48 0{TEXT 1 186 "Now
 compute 2^bits < t by comparing the lengths of their decimal rep
resentations (the iteration is stopped before exceeding t so that
 we save one (the largest) power of two computation)."}}{INP_R 49
 0 "> "{TEXT 0 18 "        bits := 3;"}}{INP_R 50 0 "> "{TEXT 0 
68 "        while 2*length(pow2(bits)) < length(t) do bits := 2*b
its od;"}}{COM_R 51 0{TEXT 1 86 "The function iquo returns the qu
otient and stores the remainder in its third argument."}}{INP_R 
52 0 "> "{TEXT 0 38 "        qt := iquo(t,pow2(bits),'rt');"}}
{INP_R 53 0 "> "{TEXT 0 33 "        u := CollatzMod(rt,bits);"}}
{COM_R 54 0{TEXT 1 115 "The values a[bits] and b[bits] are in the
 list u, now add the number of iterations and compute the next va
lue of t."}}{INP_R 55 0 "> "{TEXT 0 29 "        its := its+u[2]+b
its;"}}{INP_R 56 0 "> "{TEXT 0 28 "        t := qt*3^u[2]+u[1];"}
}{INP_R 57 0 "> "{TEXT 0 7 "    od;"}}{INP_R 58 0 "> "{TEXT 0 4 "
end:"}}{COM_R 59 0{TEXT 1 236 "\012The function which computes a[
bits] and b[bits] is written recursively.  The bottom of the recu
rsion is entered as fixed constants at the end of the definition.
  The body of this function just follows the above mathematical d
efinition."}}{INP_R 60 0 "> "{TEXT 0 23 "CollatzMod := proc(r,b)"
}}{INP_R 61 0 "> "{TEXT 0 30 "local b2, q1, q2, u1, u2, res;"}}
{INP_R 62 0 "> "{TEXT 0 20 "    b2 := iquo(b,2);"}}{COM_R 63 0
{TEXT 1 86 "The function irem returns the remainder and stores th
e quotient in its third argument."}}{INP_R 64 0 "> "{TEXT 0 47 " 
   u1 := CollatzMod(irem(r,pow2(b2),'q1'),b2);"}}{INP_R 65 0 "> "
{TEXT 0 62 "    u2 := CollatzMod(irem(q1*3^u1[2]+u1[1],pow2(b2),'
q2'),b2);"}}{INP_R 66 0 "> "{TEXT 0 43 "    res := [q2*3^u2[2]+u2
[1], u1[2]+u2[2]];"}}{COM_R 67 0{TEXT 1 206 "If b is less or equa
l to 12, then we will remember any computed value for the future.
  This will effectively create a dynamic table (will only grow as
 needed) with at most 4175=2^12+2^6+2^3+2^2+2^1 entries."}}{INP_R
 68 0 "> "{TEXT 0 47 "    if b <= 12 then CollatzMod(args) := res
 fi;"}}{INP_R 69 0 "> "{TEXT 0 7 "    res"}}{INP_R 70 0 "> "{TEXT
 0 4 "end:"}}{COM_R 71 0{TEXT 1 163 "Now we will define all the p
ossible cases for 3 or less bits, this will terminate the recursi
on of the above function.\012(Notice that b is always of the form
 3 2^k)."}}{INP_R 72 0 "> "{TEXT 0 52 "CollatzMod(0,1) := [0,0]: 
 CollatzMod(1,1) := [2,1]:"}}{INP_R 73 0 "> "{TEXT 0 52 "CollatzM
od(0,2) := [0,0]:  CollatzMod(1,2) := [1,1]:"}}{INP_R 74 0 "> "
{TEXT 0 52 "CollatzMod(2,2) := [2,1]:  CollatzMod(3,2) := [8,2]:"
}}{INP_R 75 0 "> "{TEXT 0 52 "CollatzMod(0,3) := [0,0]:  CollatzM
od(1,3) := [2,2]:"}}{INP_R 76 0 "> "{TEXT 0 52 "CollatzMod(2,3) :
= [1,1]:  CollatzMod(3,3) := [4,2]:"}}{INP_R 77 0 "> "{TEXT 0 52 
"CollatzMod(4,3) := [2,1]:  CollatzMod(5,3) := [2,1]:"}}{INP_R 78
 0 "> "{TEXT 0 53 "CollatzMod(6,3) := [8,2]:  CollatzMod(7,3) := 
[26,3]:"}}{COM_R 79 0{TEXT 1 219 "\012The above functions will us
e some powers of two again and again.  Since these powers of two 
are very few (just the ones of the form 2^(3 2^b) it is worthwhil
e computing them efficiently and remembering the past values."}}
{INP_R 80 0 "> "{TEXT 0 32 "pow2 := proc(b) option remember;"}}
{INP_R 81 0 "> "{TEXT 0 44 "if b <= 24 then 2^b else pow2(b/2)^2 
fi end:"}}{COM_R 82 0{TEXT 1 72 "Now compute some values (and try
 to verify some of the above identities)"}}{INP_R 83 0 "> "{TEXT 
0 17 "DistTo1( 2^200 );"}}{OUT_R 84 0 83{DAG j2x0200}}{INP_R 85 0
 "> "{TEXT 0 46 "DistTo1( 2^100-1 ) = DistTo1( 3^100-1 ) + 200;"}
}{OUT_R 86 0 85{DAG =3j2x1465p1}}{INP_R 87 0 "> "{TEXT 0 52 "Dist
To1( 25*4^100+1 ) = DistTo1( 25*3^100+1 ) + 300;"}}{OUT_R 88 0 87
{DAG =3j2x1562p1}}{COM_R 89 0{TEXT 1 268 "The function Iterate wi
ll start with a value x perform n Collatz iterations and return t
he resulting term.  It is written using the same ideas of modular
 computation as above, plus a provision for terminating quickly o
nce that the iteration reaches its cycle at 4,2,1."}}{INP_R 90 0 
"> "{TEXT 0 37 "Iterate := proc( x:posint, n:posint )"}}{INP_R 91
 0 "> "{TEXT 0 30 "local bits, qt, rn, rt, rx, u;"}}{INP_R 92 0 "
> "{TEXT 0 22 "    rn := n;  rx := x;"}}{INP_R 93 0 "> "{TEXT 0 
19 "    while rn > 0 do"}}{INP_R 94 0 "> "{TEXT 0 58 "        if 
rx=1 then RETURN( op( modp(rn,3)+1, [1,4,2] ) )"}}{INP_R 95 0 "> 
"{TEXT 0 60 "        elif rx=2 then RETURN( op( modp(rn,3)+1, [2,
1,4] ) )"}}{INP_R 96 0 "> "{TEXT 0 60 "        elif rx=4 then RET
URN( op( modp(rn,3)+1, [4,2,1] ) )"}}{INP_R 97 0 "> "{TEXT 0 24 "
        elif rn < 6 then"}}{INP_R 98 0 "> "{TEXT 0 69 "          
   if irem(rx,2,'qt')=1 then rx := 3*rx+1 else rx := qt fi;"}}
{INP_R 99 0 "> "{TEXT 0 23 "             rn := rn-1"}}{INP_R 100 
0 "> "{TEXT 0 23 "        else bits := 3;"}}{INP_R 101 0 "> "
{TEXT 0 67 "             while 2*length(pow2(bits)) < length(t) a
nd 4*bits < rn"}}{INP_R 102 0 "> "{TEXT 0 39 "                 do
 bits := 2*bits od; "}}{INP_R 103 0 "> "{TEXT 0 44 "             
qt := iquo(rx,pow2(bits),'rt');"}}{INP_R 104 0 "> "{TEXT 0 38 "  
           u := CollatzMod(rt,bits);"}}{INP_R 105 0 "> "{TEXT 0 
32 "             rn := rn-u[2]-bits;"}}{INP_R 106 0 "> "{TEXT 0 
34 "             rx := qt*3^u[2]+u[1];"}}{INP_R 107 0 "> "{TEXT 0
 15 "             fi"}}{INP_R 108 0 "> "{TEXT 0 11 "        od;"}
}{INP_R 109 0 "> "{TEXT 0 6 "    rx"}}{INP_R 110 0 "> "{TEXT 0 4 
"end:"}}{COM_R 111 0{TEXT 1 46 "Now we can try some examples of t
his function\012"}}{INP_R 112 0 "> "{TEXT 0 34 "Iterate(123456789
01234567890,100);"}}{OUT_R 113 0 112{DAG j5x2790345133793393}}
{INP_R 114 0 "> "{TEXT 0 26 "Iterate( 2^100-1, 2^100 );"}}{OUT_R 
115 0 114{DAG j2x0001}}{COM_R 116 0{TEXT 1 54 "The next expressio
n should return 1 for any value of x"}}{INP_R 117 0 "> "{TEXT 0 
40 "x := 7052477465274658974657456924727562;"}}{OUT_R 118 0 117
{DAG :3n3\`x`jAx007052477465274658974657456924727562}}{INP_R 119 
0 "> "{TEXT 0 25 "Iterate( x, DistTo1(x) );"}}{OUT_R 120 0 119
{DAG j2x0001}}{COM_R 121 0{TEXT 1 122 "Finally, for some timings,
 this was run on a DEC 5000 workstation (notice that 3^50000-1 is
 an integer 23857 digits long)."}}{INP_R 122 0 "> "{TEXT 0 47 "st
 := time():  DistTo1( 3^5000-1 );  time()-st;"}}{OUT_R 123 0 122
{DAG j3x00057378}}{OUT_R 124 0 122{DAG e3j2x9833i2x0003}}{INP_R 
125 0 "> "{TEXT 0 48 "st := time():  DistTo1( 3^50000-1 );  time(
)-st;"}}}{END}
