{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 3 0}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 12}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 14}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-times-medium-r-normal--17-*" "times" "Times-Ro
man" 4 17 64 "Times-Roman" 17}{SCP_R 1 0 33{COM_R 2 0{TEXT 1 0 ""
}}{COM_R 3 0{TEXT 3 115 "\015Daniel Schwalbe\015Math Dept\015St. 
Cloud State University\015St. Cloud, MN 56301\015e-mail  schwalbe
@condor.stcloud.msus.edu\015"}}{COM_R 4 0{TEXT 1 581 "\015HELIUM 
BALLOON ATTACHED TO A LONG ROPE.\012\012A long flexible rope  is 
coiled neatly on the ground and  a helium balloon is attached to 
one end. \015Our goal is to model the motion of the balloon assum
ing there is no air resistance.\012\015We use the following varia
bles:\015\012x = height of the balloon above the ground.\012v = v
elocity of the balloon.\012\012We use the following constants:\01
2\012g = gravitational constant\012rho = linear density of rope\0
12\012The forces on the balloon are then given by the following e
xpression:\012\012Fgravity = rho * x * g\012Fground = if v < 0 th
en  rho *v^2 else 0\012Fballoon = <constant>\012"}}{INP_R 5 0 "> 
"{TEXT 0 35 "with(share):  readshare(ODE,plots):"}}{INP_R 6 0 "> 
"{TEXT 0 15 "# read `ODE.m`;"}}{INP_R 7 0 "> "{TEXT 0 22 "Fgravit
y:= -rho*g*x; \015"}}{OUT_R 8 0 7{DAG :3n5\`Fgravity`+3*7n3\`rho`
j2x0001n3\`g`p9n3\`x`p9i2x0001}}{INP_R 9 0 "> "{TEXT 0 35 "Fgroun
d:=  Heaviside(-v)*rho*v^2;\012\012"}}{OUT_R 10 0 9{DAG :3n4\`Fgr
ound`*7(3n5\`Heaviside`,2+3n3\`v`i2x0001j2x0001n3\`rho`p10pCj2x00
02}}{COM_R 11 0{TEXT 1 100 "\012We can then write down Newton's s
econd law of motion for this system. (d/dt)(m*v) = sum of Forces\
012\012"}}{INP_R 12 0 "> "{TEXT 0 74 "Newtball:= diff(rho*x(t)*di
ff(x(t),t),t) = Fgravity + Fground + Fballoon;\012"}}{OUT_R 13 0 
12{DAG :3n5\`Newtball`=3+5*5n3\`rho`j2x0001(3n4\`diff`,3(3n3\`x`,
2n3\`t`p15j2x0002pA*7p8pAp11pA(3pD,3pCp15pApA+7*7p8pAn3\`g`pAp12p
Ai2x0001*7(3n5\`Heaviside`,2+3n3\`v`p30pAp8pAp3Ap18pAn5\`Fballoon
`pA}}{COM_R 14 0{TEXT 1 202 "\012In order to use phaseplot and ru
ngekuttahf to draw a phase portrait and numerically solve the dif
ferential equation we need to rewrite the equation as two procedu
res which give (dx)/(dt) and (dv)/(dt)\012"}}{INP_R 15 0 "> "
{TEXT 0 41 "Newtacc:=solve(Newtball,diff(x(t),t,t));\012"}}{OUT_R
 16 0 15{DAG :3n4\`Newtacc`+3*7+9*5n3\`rho`j2x0001(3n4\`diff`,3(3
n3\`x`,2n3\`t`p15j2x0002pA*7p8pAn3\`g`pAp12pApA*7(3n5\`Heaviside`
,2+3n3\`v`i2x0001pAp8pAp2Cp18p2En5\`Fballoon`p2EpAp8p2Ep11p2Ep2E}
}{COM_R 17 0{TEXT 1 48 "\012ropedv then gives us a procedure for 
(dv)/(dt)."}}{INP_R 18 0 "> "{TEXT 0 61 "ropedv:= unapply(subs(di
ff(x(t),t)=v,x(t)=x,Newtacc),t,v,x);\012"}}{OUT_R 19 0 18{DAG :3n
4\`ropedv`@7,4n3\`t`n3\`v`n3\`x`,1,3n5\`operator`n4\`arrow`pC+3*7
+9*5n3\`rho`j2x0001a2x0002j2x0002p1C*7p1Ap1Cn3\`g`p1Ca2x0003p1Cp1
C*7(3n5\`Heaviside`,2+3p1Ei2x0001p1Cp1Ap1Cp1Ep20p36n5\`Fballoon`p
36p1Cp1Ap36p29p36p36pC}}{COM_R 20 0{TEXT 1 38 "\012ropedx is the 
procedure for (dx)/(dt)"}}{INP_R 21 0 "> "{TEXT 0 23 "ropedx:= (t
,v,x) -> v;\012"}}{OUT_R 22 0 21{DAG :3n4\`ropedx`@7,4n3\`t`n3\`v
`n3\`x`,1,3n5\`operator`n4\`arrow`pCa2x0002pC}}{COM_R 23 0{TEXT 1
 26 "\012Values for the constants."}}{INP_R 24 0 "> "{TEXT 0 38 "
Newtcon:=rho=3, Fballoon=9800, g=980;\012"}}{OUT_R 25 0 24{DAG :3
n4\`Newtcon`,4=3n3\`rho`j2x0003=3n5\`Fballoon`j2x9800=3n3\`g`j2x0
980}}{COM_R 26 0{TEXT 1 68 "\012We then substitute these constant
s into our procedure for (dv)/(dt)"}}{INP_R 27 0 "> "{TEXT 0 38 "
ropedv:= subs(Newtcon,eval(ropedv));\012 "}}{OUT_R 28 0 27{DAG :3
n4\`ropedv`@7,4n3\`t`n3\`v`n3\`x`,1,3n5\`operator`n4\`arrow`pC+3*
5+9*3a2x0002j2x0002j2x0003a2x0003j2x2940*5(3n5\`Heaviside`,2+3p1A
i2x0001j2x0001p1Ap1Ci2x0003i2x9800p2Fp2Fp20p2D/3p2Dp1EpC}}{COM_R 
29 0{TEXT 1 88 "\012The phaseplot procedure is used to produce a 
phase space for the motion of the balloon."}}{INP_R 30 0 "> "
{TEXT 0 67 "ropephase:=phaseplot([ropedv,ropedx],-59..59,0.1..5,g
rid=[7,7]):\";\012"}}{COM_R 31 0{TEXT 1 98 "\015We  numerically s
olve the differential equation with the initial condition x(0)=0.
5 and v(0) = 0."}}{INP_R 32 0 "> "{TEXT 0 152 "ropepts:=rungekutt
ahf([ropedv,ropedx],[0,0,0.5],.01,200,10):\012ropeptsplot:=plot(\
{makelist(ropepts,2,3)\},velocity =-50..50,position = 0..5,color=
cyan):\";\012"}}{COM_R 33 0{TEXT 1 78 "It is also interesting to 
look at the path of the balloon in the phase space.\015"}}{INP_R 
34 0 "> "{TEXT 0 40 "plots[display](\{ropephase,ropeptsplot\});"}
}}{END}
