{VERSION 1 0 "X11/Motif" "1.0"}{GLOBALS 1 1}{FONT 0 "-adobe-helve
tica-bold-r-normal--14-*" "helvetica" "Helvetica-Bold" 8 14 0 "He
lvetica-Bold" 14}{FONT 1 "-adobe-times-medium-r-normal--14-*" "ti
mes" "Times-Roman" 4 14 64 "Times-Roman" 14}{FONT 2 "-adobe-couri
er-medium-r-normal--14-*" "courier" "Courier" 4 14 192 "Courier" 
12}{FONT 3 "-adobe-times-bold-i-normal--20-*" "times" "Times-Bold
Italic" 8 20 96 "Times-BoldItalic" 20}{FONT 4 "-adobe-times-bold-
r-normal--17-*" "times" "Times-Bold" 8 17 64 "Times-Bold" 17}
{FONT 5 "-adobe-times-bold-r-normal--17-*" "times" "Times-Bold" 8
 17 64 "Times-Bold" 17}{FONT 6 "-adobe-times-bold-r-normal--17-*"
 "times" "Times-Bold" 8 17 64 "Times-Bold" 17}{SCP_R 1 0 49{COM_R
 2 0{TEXT 3 57 "\015Using Phase Portraits to Understand Populatio
n Dynamics\015"}}{COM_R 3 0{TEXT 1 141 "Daniel Schwalbe, Departme
nt of Mathematics and Statistics, St. Cloud State University, St.
 Cloud, MN 56301, \015schwalbe@condor.stcloud.msus.edu"}}{COM_R 4
 0{TEXT 1 1022 "\015In this worksheet we explore how Maple V's nu
merical and graphical capabilities complement the well-known symb
olic capabilities of Maple.  One of the strenghts of Maple is the
 ability of extending its functionality by adding routines writte
n in Maple's extensive programming language.  The Maple share lib
rary contains many user-written extensions to Maple.\015   The Ma
ple share library contains a package of routines called ODE which
 contains several standard tools for analyzing systems of first-o
rder ordinary differential equations.  The ODE package contains a
 help file and is also documented in the Maple V Flight Manual [1
].  We provide here an example of using this package to analyze t
he standard population model for two competing species.  A good i
ntroductory reference fo this and similar models is given by Brau
n [2].  The reader can find reference to some of the original pap
ers in the field of population biology in Braun's book or in many
 of the olther excellent differential equations texts on the mark
et.\015"}}{COM_R 5 0{TEXT 6 33 "An example Using Phase Portraits\
015"}}{COM_R 6 0{TEXT 1 78 "The standard model for two population
s x and y which compete for resources is\015"}}{OUT_R 7 0 0{DAG =
3n3\`x'`+7*5n3\`a`j2x0001n3\`x`p7p7*7n3\`b`p7p9p7n3\`y`p7i2x0001*
5n3\`c`p7p9j2x0002p16}}{OUT_R 8 0 0{DAG =3n3\`y'`+7*5n3\`d`j2x000
1n3\`y`p7p7*7n3\`e`p7n3\`x`p7p9p7i2x0001*5n3\`f`p7p9j2x0002p16}}
{COM_R 9 0{TEXT 1 472 "where a, b, c, d, e, and f, are positive c
onstants.  a and d are the natural growth rates of the population
s x and y respectively.  The coefficients of the x y terms, b and
 e, measure the degree of internal competition among each species
.\015   Analyzing the system with six parameters is impractical w
ithout some ecological assumptions.  We note then that the ecolog
ical system will support a/c members of population x if y = 0.  I
n this case we have the first order system\015"}}{OUT_R 10 0 0
{DAG =3n3\`x'`+5*5n3\`a`j2x0001n3\`x`p7p7*5n3\`c`p7p9j2x0002i2x00
01}}{COM_R 11 0{TEXT 1 0 ""}}{COM_R 12 0{TEXT 1 161 "To see graph
ically why there is a limiting population we can use the ODE pack
age to draw a direction field for this situation.  We assume a = 
0.04 and c = 0.02.\015"}}{INP_R 13 0 "> "{TEXT 0 73 "with(share):
 readshare(ODE,plots): # load the code from the share library"}}
{OUT_R 14 0 13{TEXT 2 71 "See ?share and ?share,contents for info
rmation about the share library\012"}}{INP_R 15 0 "> "{TEXT 0 15 
"# read `ODE.m`;"}}{INP_R 16 0 "> "{TEXT 0 31 "eq := (t,x) -> 0.0
4*x-0.02*x^2;"}}{OUT_R 17 0 16{DAG :3n3\`eq`@8,3n3\`t`n3\`x`,1,3n
5\`operator`n4\`arrow`p9+5a2x0002e3j2x0004i2x0002*3p14j2x0002e3p1
9p19p9p9}}{INP_R 18 0 "> "{TEXT 0 30 "inits := seq([0,i/4],i=1..1
2):"}}{INP_R 19 0 "> "{TEXT 0 44 "directionfield( eq, 0..100, 0..
3, \{inits\} );"}}{COM_R 20 0{TEXT 1 1005 "\015In the direction f
ield shown, the horizontal axis represents time and the vertical 
axis the population of x.  One can clearly see that the populatio
n approaches a/c or 2.  Similarly, if x = 0, the limiting value f
or the population y is d/f.  We next make the assumption that the
 environment can support an equal number of either population, so
 that a/c = d/f.  We further assume that the two species occupy d
ifferent niches, which means that the internal competition among 
the species is more severe than the competition between the two s
pecies, that is, c > b and f > e.  We assume a = 0.04, b = 0.015,
 c = 0.02, d = 0.03, e = 0.01, and f = 0.015.  We then use the OD
E package to draw a phase portrait for the resulting system.\015 
  Part of the learning process is choosing the parameters to get 
a ``nice'' picture; in this case the step size used by the Runge/
Kutta method must be adjusted to get reasonably long orbits.  Typ
ing ?phaseplot provides a help file containing a list of paramete
rs to change.\015"}}{INP_R 21 0 "> "{TEXT 0 44 "eq1 := (t,x,y) ->
 0.04*x-0.015*x*y-0.02*x^2;"}}{OUT_R 22 0 21{DAG :3n3\`eq1`@8,4n3
\`t`n3\`x`n3\`y`,1,3n5\`operator`n4\`arrow`pB+7a2x0002e3j2x0004i2
x0002*5p16j2x0001a2x0003p1Fe3i2x0015i2x0003*3p16j2x0002e3p1Bp1BpB
pB}}{INP_R 23 0 "> "{TEXT 0 48 "eq2 := (t,x,y) -> 0.03*y - 0.01*x
*y - 0.015*y^2;"}}{OUT_R 24 0 23{DAG :3n3\`eq2`@8,4n3\`t`n3\`x`n3
\`y`,1,3n5\`operator`n4\`arrow`pB+7a2x0003e3j2x0003i2x0002*5a2x00
02j2x0001p16p20e3i2x0001p1B*3p16j2x0002e3i2x0015i2x0003pBpB}}
{INP_R 25 0 "> "{TEXT 0 47 "inits := seq( seq([i/2,j/2], i=1..5),
 j=1..5 ):"}}{INP_R 26 0 "> "{TEXT 0 50 "phaseplot([eq1,eq2],0..3
,0..3,\{inits\},stepsize=2);"}}{COM_R 27 0{TEXT 1 200 "\015\015In
 the above plot, there appears to be an equilibrium point that th
e two populations are approaching. This equilibrium point can be 
found by solving teh system of equations x'(t) = 0 and y'(t) = 0.
\015"}}{INP_R 28 0 "> "{TEXT 0 37 "eqns := \{eq1(t,x,y)=0, eq2(t,
x,y)=0\};"}}{OUT_R 29 0 28{DAG :3n4\`eqns`%2,3=3+7n3\`x`e3j2x0004
i2x0002*5p8j2x0001n3\`y`p11e3i2x0015i2x0003*3p8j2x0002e3pDpDj2x00
00=3+7p13e3j2x0003pDpFe3i2x0001pD*3p13p1Dp16p22}}{INP_R 30 0 "> "
{TEXT 0 28 "equil1 := solve(eqns,\{x,y\});"}}{OUT_R 31 0 30{DAG :
3n4\`equil1`,5%2,3=3n3\`x`j2x0000=3n3\`y`pA%2,3=3p8e3j2x0002pApC%
2,3=3pDp14p7%2,3=3pDe3j4x001333333333i2x0009=3p8e3j4x001000000000
p28}}{COM_R 32 0{TEXT 1 354 "\015The points (0,0), (0,2), and (2,
0) are the equilibrium points arising when one of the populations
 is 0.  The equilibrium point (1,4/3) appears to be a stable equi
librium point.  We can verify this by showing that the eigenvalue
s of the system linearized at this point are both negative.  We n
eed to construct the Jacobian matrix of partial derivatives.\015"
}}{INP_R 33 0 "> "{TEXT 0 52 "linalg[jacobian]( [eq1(t,x,y), eq2(
t,x,y)], [x,y] );"}}{OUT_R 34 0 33{DAG (3n4\`MATRIX`,2[2,3[2,3+7e
3j2x0004i2x0002j2x0001n3\`y`e3i2x0015i2x0003n3\`x`e3i2x0004pD+3p1
8p13[2,3+3p11e3i2x0001pD+7e3j2x0003pDpFp18p25p11e3i2x0030p16}}
{INP_R 35 0 "> "{TEXT 0 21 "subs(\{x=1,y=4/3\}, \");"}}{OUT_R 36 
0 35{DAG (3n4\`MATRIX`,2[2,3[2,3e3i4x002000000000i2x0011e3i2x0015
i2x0003[2,3e3i4x001333333333pEe3i4x001999999999pE}}{INP_R 37 0 ">
 "{TEXT 0 21 "linalg[eigenvals](\");"}}{OUT_R 38 0 37{DAG ,3e3i4x
003414213562i2x0011e3i4x000585786437p6}}{COM_R 39 0{TEXT 1 471 "\
015An interesting aspect of these equations is the way in which s
mall changes to the environment affect the outcome.  If the envir
onment is changed in such a way as to support more members of eac
h species, while the competition for other aspects of the environ
ment remains the same, the outcome is radically different.  We de
crease the values of c and f to reflect the fact that the interna
l competition is less fierce which retaining the values of the ot
her coefficients.\015"}}{INP_R 40 0 "> "{TEXT 0 44 "eq3 := (t,x,y
) -> 0.04*x-0.015*x*y-0.01*x^2;"}}{OUT_R 41 0 40{DAG :3n3\`eq3`@8
,4n3\`t`n3\`x`n3\`y`,1,3n5\`operator`n4\`arrow`pB+7a2x0002e3j2x00
04i2x0002*5p16j2x0001a2x0003p1Fe3i2x0015i2x0003*3p16j2x0002e3i2x0
001p1BpBpB}}{INP_R 42 0 "> "{TEXT 0 50 "eq4 := (t,x,y) -> 0.03*y 
- 0.01*x*y -  0.0075*y^2;"}}{OUT_R 43 0 42{DAG :3n3\`eq4`@8,4n3\`
t`n3\`x`n3\`y`,1,3n5\`operator`n4\`arrow`pB+7a2x0003e3j2x0003i2x0
002*5a2x0002j2x0001p16p20e3i2x0001p1B*3p16j2x0002e3i2x0075i2x0004
pBpB}}{INP_R 44 0 "> "{TEXT 0 56 "phaseplot( [eq3,eq4], 0..4, 0..
4, \{inits\}, stepsize=2 );"}}{COM_R 45 0{TEXT 1 360 "\015In this
 plot we again have an equilibrium point where both populations a
re non-zero, at (2,4/3), but it is unstable.  Maple will verify t
hat one of the eigenvalues of the system linearized at (2,4/3) is
 negative and one is positive.  Two of the other equilibrium poin
ts, (4,0) and (0,4), are now stable.  In this scenario, one of th
e species always dies out.\015"}}{COM_R 46 0{TEXT 5 11 "Conclusio
n\015"}}{COM_R 47 0{TEXT 1 1125 "There are other tools in Maple w
hich also prove useful in analyizing system such as this.  In par
ticular, the ODE package contains a Runge/Kutta solver which will
 return an array of lists for the solution.  Each list represents
 a point on the solution curve, and this array can then be used t
o construct plots of x vs t and y versus t.\015   Although Maple 
is an invaluable aid for drawing the pahase portraits and doing e
igenvalue computations, it is clear that the main use of these to
ols is as motivation to delve deeper into these ecological models
.  Conjectures are often best formed using the traditional paper 
and pencil.  For example, in sketching a rough phase portrait by 
hand, it is immediately clear that the important elements of the 
phase portrait are the curves when x' = 0 and y' = 0.  In the abo
ev examples the curves turn out to be lines, and the behaviour of
 the solutions can be conjectured by the position of these lines.
  Furthere analysis of the ecological meanings of the coefficient
s leads to many interesting conjectures and results which can be 
tested using the large array of tools present in Maple.\015"}}
{COM_R 48 0{TEXT 4 11 "References\015"}}{COM_R 49 0{TEXT 1 291 "[
1] W. Ellis, E. Lodi, E. Johnson, and D. Schwalbe.  Maple V Fligh
t Manual: Tutorials for Calculus, Linear Algebra and Differential
 Equations, Books/Cole Publishing Company, (1991).\015\015[2] M. 
Braun.  Differential Equations and Their Applications, 3rd editio
n, Springer-Verlag New York, (1983)."}}{INP_R 50 0 "> "{TEXT 0 0 
""}}}{END}
